/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import slothLib.web.search.CachedSearchResult;
import slothLib.web.search.ISearch;
import slothLib.web.search.ISearchResult;
import slothLib.web.search.WebSearchException;

public class CachedSearch
implements ISearch {
    String cacheDir;
    ISearch searchEngine;

    public CachedSearch(String cacheDir, ISearch searchEngine) {
        File di;
        if (cacheDir.charAt(cacheDir.length() - 1) != '\\') {
            cacheDir = String.valueOf(cacheDir) + '\\';
        }
        if (!(di = new File(cacheDir)).exists()) {
            di.mkdirs();
        }
        this.cacheDir = cacheDir;
        this.searchEngine = searchEngine;
    }

    public CachedSearch(ISearch searchEngine) {
        this(String.valueOf(System.getProperty("java.io.tmpdir")) + "\\cache\\", searchEngine);
    }

    @Override
    public ISearchResult doSearch(String query, int resultNum) throws WebSearchException {
        String filePath = String.valueOf(this.cacheDir) + this.searchEngine.getClass().getName() + "_" + query.hashCode() + "_" + resultNum + ".dat";
        CachedSearchResult result = this.LoadResult(filePath);
        if (result == null) {
            ISearchResult realResult = this.searchEngine.doSearch(query, resultNum);
            result = new CachedSearchResult(realResult);
            this.saveResult(result, filePath);
        }
        return result;
    }

    private void saveResult(CachedSearchResult searchResult, String filePath) {
        block12: {
            ObjectOutputStream stream = null;
            try {
                try {
                    stream = new ObjectOutputStream(new FileOutputStream(filePath));
                    stream.writeObject(searchResult);
                }
                catch (IOException iOException) {
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private CachedSearchResult LoadResult(String filePath) {
        if (new File(filePath).exists()) {
            ObjectInputStream stream = null;
            try {
                CachedSearchResult result;
                stream = new ObjectInputStream(new FileInputStream(filePath));
                CachedSearchResult cachedSearchResult = result = (CachedSearchResult)stream.readObject();
                return cachedSearchResult;
            }
            catch (IOException e) {
                new File(filePath).delete();
            }
            catch (ClassNotFoundException e) {
                new File(filePath).delete();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

