/*
 * Decompiled with CFR 0.152.
 */
package slothLib.text;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;
import slothLib.text.EncodingConverterResult;
import slothLib.text.IEncodingConverter;

public class AutoDetectConverter
implements IEncodingConverter {
    @Override
    public EncodingConverterResult convertTextFile(String textFilePath) throws SlothLibException {
        try {
            FileInputStream is = new FileInputStream(textFilePath);
            int len = (int)new File(textFilePath).length();
            byte[] buffer = new byte[len];
            PortUtil.readFully(is, buffer, 0, len);
            return this.convertByteArray(buffer);
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
    }

    @Override
    public EncodingConverterResult convertByteArray(byte[] byteArray) throws SlothLibException {
        try {
            return this.convertByteArray(new ByteArrayInputStream(byteArray));
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
    }

    private EncodingConverterResult convertByteArray(InputStream is) throws IOException {
        is.mark(3000);
        String result = null;
        boolean isUTF8 = this.isUTF8Sequence(is, 3000);
        System.out.println(isUTF8);
        is.reset();
        result = isUTF8 ? PortUtil.readFully(is, "UTF-8") : PortUtil.readFully(is, "JISAutoDetect");
        return new EncodingConverterResult(result, "unknown");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUTF8Sequence(InputStream is, int len) throws IOException {
        int counter = 0;
        int sjisCounter = 0;
        int sjisPoint = 0;
        int i = 0;
        while (i < len) {
            int ch = is.read();
            if (ch < 0) {
                return true;
            }
            if (sjisCounter == 0 && ch == 27) {
                ++sjisCounter;
            } else if (sjisCounter == 1 && (ch == 36 || ch == 40)) {
                ++sjisCounter;
            } else if (sjisCounter == 2 && ch == 66) {
                sjisCounter = 0;
                if (++sjisPoint >= 2) {
                    return false;
                }
            }
            if (counter == 0) {
                if ((ch & 0x80) != 0) {
                    if ((ch & 0xE0) == 192) {
                        counter = 1;
                    } else if ((ch & 0xF0) == 224) {
                        counter = 2;
                    } else if ((ch & 0xF8) == 240) {
                        counter = 3;
                    } else if ((ch & 0xFC) == 248) {
                        counter = 4;
                    } else {
                        if ((ch & 0xFE) != 252) return false;
                        counter = 5;
                    }
                }
            } else if ((ch & 0xC0) == 240) {
                --counter;
            }
            ++i;
        }
        return true;
    }
}

