/*
 * Decompiled with CFR 0.152.
 */
package slothLib.portUtil;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import slothLib.portUtil.Redirector;

public class ProcessPipe {
    List<ProcessBuilder> pbs = new ArrayList<ProcessBuilder>();
    List<Process> procs = new ArrayList<Process>();
    private InputStream is = null;
    private InputStream error = null;
    int val = 0;
    String file;

    public void add(ProcessBuilder pb) {
        this.pbs.add(pb);
    }

    public void add(String[] cmd) {
        this.pbs.add(new ProcessBuilder(cmd));
    }

    public void start(String filename) throws IOException {
        Vector<InputStream> errors = new Vector<InputStream>();
        if (filename != null) {
            this.is = new FileInputStream(filename);
        }
        for (ProcessBuilder pb : this.pbs) {
            Process p = pb.start();
            if (this.is != null) {
                Redirector.redirect(this.is, p.getOutputStream());
            }
            this.is = p.getInputStream();
            this.procs.add(p);
            errors.add(p.getErrorStream());
        }
        this.error = new SequenceInputStream(errors.elements());
    }

    public void start() throws IOException {
        this.start(null);
    }

    public int exitValue() {
        try {
            this.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.val;
    }

    public void waitFor() throws InterruptedException {
        for (Process p : this.procs) {
            p.waitFor();
            if (p.exitValue() == 0) continue;
            this.val = p.exitValue();
        }
    }

    public void setResultFileName(String file) {
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return this.is;
    }

    public InputStream getErrorStream() {
        return this.error;
    }

    public void destroy() {
        for (Process p : this.procs) {
            p.destroy();
        }
    }
}

