function SiteswapWriter(siteswap){
	this.initialize.apply(this, [ siteswap ]);
}

SiteswapWriter.prototype = {
	siteswap: null,
	posX: null,
	counter: 0,

	initialize: function(siteswap) {
		this.siteswap = siteswap.getStrings();
		this.counter = -1;
		this.posX = new Array(this.siteswap.length);
	},
	initialize_func: function(jc) {
		var l = 0;
		var i;
		for(i = 0; i < this.siteswap.length; i++) {
			this.posX[i] = l;
			l += this.siteswap[i].length;
		}
		var width = jc.getWidth() / l;
		if (width > Resource.charWidth()){
			width = Resource.charWidth();
		}
		var x = -width * l / 2;
		for(this.counter = 0;
			this.counter < this.siteswap.length; this.counter++) {
			this.posX[this.counter] = this.posX[this.counter] * width + x;
			this.drawString(jc, Graphics.COLOR_BLACK);
		}
		this.counter--;
	},
	drawSiteswap: function(jc) {
		if (this.counter < 0) {
			this.initialize_func(jc);
		}
		var counterBak = this.counter;
		var i;
		for(i = 0; i < this.siteswap.length; i++) {
			this.counter = i;
			this.drawString(jc, Graphics.COLOR_BLACK);
		}
		this.counter = counterBak;

		jc.setEmphasisColor();
		this.counter = (this.counter + 1) % this.siteswap.length;
		this.drawString(jc, Graphics.COLOR_RED);
		jc.setForegroundColor();
	},
	drawString: function(jc, color) {
		jc.drawString(
			this.siteswap[this.counter], this.posX[this.counter],
			Resource.charHeight() + 2, 0, color);
	}

};
