function JugglingBalls(rhand, lhand){
	this.initialize.apply(this, [ rhand, lhand]);
}

JugglingBalls.GRAVITYx10 = 98;

JugglingBalls.square = function(x){
	return x * x;
};

JugglingBalls.squareRoot = function(x){
	if (x <= 0){
		return 0;
	}
		
	var s = 1;
	var t = x;
	while (s < t) {
		s <<= 1;
		t >>= 1;
	}
	do {
		t = s;
		s = (toInt(x / s) + s) >> 1;
	} while (s < t);
	return t;
};

JugglingBalls.prototype = {
	rhand: null,
	lhand: null,
	ball: null,
	tw: 0,
	aw: 0,
	high: null,
	multiplex: null,
	jp: null,
	siteswap: null,
	initialize: function(rhand, lhand){
		Ball.balls = this;
		this.rhand = rhand;
		this.lhand = lhand;
	},
	initialize_func: function(jp) {
		this.jp = jp;
		this.siteswap = this.jp.getSiteSwap();
		if (!this.newBallInstance()){
			return false;
		}
		if (!this.setTW(this.jp)){
			return false;
		}
		this.multiplex = new Array(this.siteswap.size());
		var i;
		for (i = 0; i < this.multiplex.length; i++){
			this.multiplex[i] = 0;
		}
		return true;
	},
	juggle: function(counter) {
		var i;
		for(i = 0; i < this.ball.length; i++){
			this.ball[i].juggle(this.siteswap, counter);
		}
		var ret = this.rhand.juggle(this.siteswap, counter);
		ret |= this.lhand.juggle(this.siteswap, counter);
		return ret;
	},
	getYRange: function(){
		var gy_max = 80;
		var gy_min = -200;
		var tmax = this.siteswap.getMaxValue();
		if (tmax < 3){
			tmax = 3;
		}
		tmax = (tmax + this.siteswap.size() + this.jp.motionSize()) * this.tw;
		var t;
		for(t = 0; t < tmax; t++){
			this.juggle(t);
			var i;
			for(i = 0; i < this.ball.length; i++) {
				gy_max = Math.max(gy_max, this.ball[i].getY());
				gy_min = Math.min(gy_min, this.ball[i].getY());
			}
		}
		this.reset();
		return gy_max - gy_min;
	},
	drawBalls: function() {
		var i;
		for(i = 0; i < this.ball.length; i++){
			jCanvas.drawBall(i, this.ball[i].getX(), this.ball[i].getY());
		}
	},
	reset: function() {
		var i;
		for (i = 0; i < this.ball.length; i++){
			this.ball[i].reset();
		}
		this.rhand.reset();
		this.lhand.reset();
	},
	handPosition: function(b, c, h){
		var pos = new Array(2);

		if (!this.siteswap.isSynchronous() && h == 0) {
			c--;
		}
		if ((c & 1) != 0) {
			pos[0] = this.jp.getCatchPositionX(c - h);
			pos[1] = this.jp.getCatchPositionY(c - h);
		} else {
			pos[0] = this.jp.getThrowPositionX(c + 1 - h);
			pos[1] = this.jp.getThrowPositionY(c + 1 - h);
		}
		if (h == 0) {
			pos[0] = -pos[0];
		}
		return pos;
	},
	getTW: function(){
		return this.tw;
	},
	getAW: function(){
		return this.aw;
	},
	getHigh: function(i){
		return this.high[i];
	},
	newBallInstance: function() {
		this.rhand.init(2, 0, true);
		if (!this.siteswap.isSynchronous()){
			this.lhand.init(2, -1, false);
		}
		else {
			this.lhand.init(2, 0, false);
		}
		this.ball = new Array(this.siteswap.getNumberOfBalls());

		var r = getArray(
			this.siteswap.size() + this.siteswap.getMaxValue(), 0);
		var i;
		for (i = 0; i < this.ball.length; i++){
			var j = 0;
			while (j < r.length && r[j] == this.siteswap.setSize(j)){
				j++;
			}
			if (i == this.ball.length){
				if (j == r.length){
					break;
				}
				else {
					return false;
				}
			}
			var ballStatusC = -j;
			if (this.siteswap.isSynchronous()){
					ballStatusC = -toInt(j / 2) * 2;
			}
			var ballStatusHand = false;
			if (this.siteswap.isSynchronous() == (j % 2 == 1)){
				ballStatusHand = true;
			}
			this.ball[i] = new Ball(false);
			this.ball[i].init(0, ballStatusC, ballStatusHand);

			while (j < r.length) {
				if (r[j] == this.siteswap.setSize(j)){
					return false;
				}
				r[j]++;
				var k = this.siteswap.getValue(
					j, this.siteswap.setSize(j) - r[j]);
				// シンクロパターンでクロスの場合（Siteswapで　x がつく部分）
				if (this.siteswap.isSynchronous() && k < 0) {
					if (j % 2 == 0) {
						j += -k + 1;
					} else {
						j += -k - 1;
					}
				} else {
					j += k;
				}
			}
		}
		this.reset();
		return true;
	},
	setTW: function(jp) {
		var pmax = this.siteswap.getMaxValue();
		if (pmax < 3){
			pmax = 3;
		}
		var dwell = jp.getDwell() * 2;

		var tw1 = 24000 * pmax * jp.getHeight();
		tw1 /= JugglingBalls.square(pmax * 100 - dwell);
		this.high = new Array(pmax + 1);
		this.high[0] = -48;
		this.high[1] = toInt(tw1);
		var i;
		for (i = 2; i <= pmax; i++){
			this.high[i] = toInt(
				tw1 * JugglingBalls.square(100 * i - dwell) / 10000);
		}
		tw1 = tw1 * 100 * JugglingBalls.square(Resource.getRedrawrate()) 
				/ (3 * JugglingBalls.GRAVITYx10
					* JugglingBalls.square(JmPattern.getSpeed()));
		// edit {
		if (tw1 == 0){
			tw1 = 1;
		}
		// }
		this.tw = toInt(JugglingBalls.squareRoot(tw1));
		if (this.tw == 0){
			return false;
		}
		this.aw = this.tw * dwell / 100;
		if (this.aw < 1){
			this.aw = 1;
		}
		if (this.aw > this.tw * 2 - 1){
			this.aw = this.tw * 2 - 1;
		}
		return true;
	},
	getNowNumberOfMultiplex: function(t){
		t %= this.siteswap.size();
		var ret = this.multiplex[t];
		if (++this.multiplex[t] >= this.siteswap.setSize(t)){
			this.multiplex[t] = 0;
		}
		return ret;
	}
};
