package com.jm;

import android.os.Handler;
import android.os.Message;

public class Juggler extends Handler {
    private JugglerCanvas view;
    private int delayTime;
    private int frameRate;

	private static final byte ST_IDLE = 0x0;
	private static final byte ST_PAUSE = 0x1;
	private static final byte ST_PLAYING = 0x2;
	
// edit
//	private Thread			jThread;
	private JugglerCanvas	jCanvas;
	private Body			body;
	private SiteswapWriter	siteswap;
	private JugglingBalls	balls;
	private byte			status;

	private SiteSwap site;
	
	public Juggler(JugglerCanvas view, int frameRate) {
        this.view = view;
        this.frameRate = frameRate;

// edit
//		jCanvas = new JugglerCanvas();
		jCanvas = view;
		body    = new Body();
		balls   = new JugglingBalls(body.getRightHand(), body.getLeftHand());
		jCanvas.setBalls(balls);
	}
	
	public SiteSwap getSiteSwap() {
		return site;
	}

	public void play() {
		this.status = ST_PLAYING;
	}
	
	public void pause() {
		this.status = ST_PAUSE;
	}

    public void stop() {
        delayTime = 0;
		this.status = ST_IDLE;
    }
    
	public boolean isPlaying() {
		return (status == ST_PLAYING);
	}

	public boolean isPause() {
		return (status == ST_PAUSE);
	}

	public boolean isIdle() {
		return (status == ST_IDLE);
	}

	public void start(JmPattern jp) {
		stop();
		if (!balls.initialize(jp)) return;
		// edit {
		//SiteSwap s = jp.getSiteSwap();
		//siteswap = new SiteswapWriter(s);
		//jCanvas.setImageHeight(balls.getYRange());
		//jCanvas.createBalls(s.getNumberOfBalls());
		site = jp.getSiteSwap();
		siteswap = new SiteswapWriter(site);
		// }
	
		this.delayTime = 1000 / frameRate;
        this.sendMessageDelayed(obtainMessage(0), delayTime);

        play();
    }
    
    @Override
    public void handleMessage(Message msg) {
        view.invalidate();
        if (delayTime == 0) return; // stop
        sendMessageDelayed(obtainMessage(0), delayTime);
    }

	protected void drawJuggler(long counter) {
		// update
// edit
//		boolean renew = balls.juggle(counter);
		balls.juggle(counter);
		body.move();

		// clear Image
		jCanvas.clear();

		// draw body
		if(JmPattern.ifShowBody()) {
			body.drawBody(jCanvas);
		}
		// write Siteswap
// edit {
//		if(JmPattern.ifShowSiteSwap() && renew) {
		if(JmPattern.ifShowSiteSwap()) {
// }
			siteswap.drawSiteswap(jCanvas);
		}
		// draw ball
		balls.drawBalls(jCanvas);
	}
}
