function Graphics(c_id){
	this.initialize.apply(this, [ c_id ]);
}

Graphics.COLOR_BLACK = "rgba(0, 0, 0, 1.0)";
Graphics.COLOR_RED = "rgba(255, 0, 0, 1.0)";

Graphics.prototype = {
	center: 0,
	canvas: null,
	ctx: null,
	initialize: function(c_id) {
		var canvas_j = $("#" + c_id);
		this.canvas = $(canvas_j).get(0);
		this.ctx = this.canvas.getContext('2d');
		this.ctx.font = "" + Resource.fontSize + "px 'Monotype Corsiva'";
	},
	translate: function(center, i) {
		this.center = center;
	},
	fillRect: function(x, y, width, height) {
		this.ctx.beginPath();
		this.ctx.clearRect(x, y, width, height);
		this.ctx.closePath();
		this.ctx.fill();
	},
	drawString: function(str, x, y, anchor, color) {
		try { // todo IE
			this.ctx.beginPath();
			this.ctx.strokeStyle = color;
			this.ctx.strokeText(str, x + center, y);
			this.ctx.closePath();
			this.ctx.stroke();
		}
		catch (e){
			;
		}
	},
	drawLine: function(x1, y1, x2, y2) {
		this.ctx.beginPath();
		this.ctx.strokeStyle = "rgba(0, 0, 0, 1.0)";
		this.ctx.moveTo(x1 + center, y1);
		this.ctx.lineTo(x2 + center, y2);
		this.ctx.closePath();
		this.ctx.stroke();
	},
	drawCircle: function(x, y, r) {
		this.ctx.beginPath();
		this.ctx.strokeStyle = "rgba(0, 0, 0, 1.0)";
		this.ctx.arc(x + this.center, y, r, 0, (360 * Math.PI / 180), true);
		this.ctx.closePath();
		this.ctx.stroke();
	},
	drawImage: function(i, x, y, size) {
		this.ctx.beginPath();
		var color = JugglerCanvas.color[i % JugglerCanvas.color.length];
		this.ctx.fillStyle = toRGB(color);
		this.ctx.arc(x + this.center, y, size, 0, (360 * Math.PI / 180), true);
		this.ctx.closePath();
		this.ctx.fill();
	},
	getWidth: function(){
		return this.canvas.width;
	},
	getHeight: function(){
		return this.canvas.height;
	}
};
