/*
 * (C) Copyright 2011 Yoshinori Sato
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#include <asm/processor.h>

	.global	lowlevel_init

	.text
	.align	2

lowlevel_init:
	mov.l	#4f,r1
	mov.l	#0x00080000,r2
1:	
	mov.l	[r1+],r3
	tst	r3,r3
	bn	3f
	mov.l	[r1+],r4
	shlr	#16,r3,r5
	and	#0xffff,r3
	bra	r5
	mov.b	r4,[r3,r2]
	bra	1b
	mov.w	r4,[r3,r2]
	bra	1b
	mov.l	r4,[r3,r2]
	bra	1b
2:	sub	#1,r4
	bne	2b
	nop
	bra	1b
	
3:
	/* dataflash read enable */
	mov.l	#0x7fc440,r1
	mov.w	#0x2dff,[r1]
	mov.w	#0xd2ff,2[r1]
	rts

4:
#define BYTE 0
#define	WORD 1
#define LONG 2
#define WAIT 3
#define REGINIT(offset, size, val) .long ((2 + size * 5) << 16)|(offset >> size),val
	/* Clock/PowerManagement write enable */
	REGINIT(0x03FE,WORD,0xa503)
	/* Main OSC enbale */
	REGINIT(0x0032,BYTE,0x00)
	/* Wait for OSC stable */
	REGINIT(0x0000,WAIT,1400)
	/* PLLIN:12MHz PLLOUT:192MHz */
	REGINIT(0x0028,WORD,0x0f00)
	/* PLL enable */
	REGINIT(0x002A,BYTE,0x00)
	/* Wait for PLL stable */
	REGINIT(0x0000,WAIT,120)
	/* FCLK:48MHz, ICLK:96MHz, BCLK:48MHz, PCLKA:96MHz PCLKB:48MHz */
	/* SDCLK and BCLK enable */
	REGINIT(0x0020,LONG,0x21021211)
	/* UCLK:48MHz IEBCLK:24MHz */
	REGINIT(0x0024,WORD,0x0033)
	/* PLL select */
	REGINIT(0x0026,WORD,0x0400)

	.long	0xffffffff
	
	.align 2
