/*
 * Configuation settings for the csun Kane Bebe
 *
 * Copyright (C) 2010 Yoshinori Sato
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __KANEBEBE_H
#define __KANEBEBE_H

#define CONFIG_CPU_H83069	1
#define CONFIG_H8300_RELOCATE	0

/*#define CONFIG_SYS_LDSCRIPT "board/nisshin-tech/kanebebe/u-boot.lds"*/
#define CONFIG_SYS_LDSCRIPT "board/nisshin-tech/kanebebe/u-boot.lds.ram"

#define CONFIG_BAUDRATE		38400
#define CONFIG_BOOTARGS		"earlyprintk=sh-sci.1,38400 console=ttySC1,38400"
#define CONFIG_BOARD_LATE_INIT
#define CONFIG_SYS_GENERIC_BOARD
#define CONFIG_SYS_TEXT_BASE 0x588000
#define CONFIG_SYS_MONITOR_BASE 0x588000
#define CONFIG_BOARD_EARLY_INIT_F
#undef CONFIG_VERSION_VARIABLE
#undef	CONFIG_SHOW_BOOT_PROGRESS

/* MEMORY */
#define KANEBEBE_DRAM_BASE	0x400000

#define CONFIG_SYS_LONGHELP		/* undef to save memory	*/
#define CONFIG_SYS_PROMPT	"=> "	/* Monitor Command Prompt */
#define CONFIG_SYS_CBSIZE	256	/* Buffer size for input from the Console */
#define CONFIG_SYS_PBSIZE	256	/* Buffer size for Console output */
#define CONFIG_SYS_MAXARGS	16	/* max args accepted for monitor commands */
/* Buffer size for Boot Arguments passed to kernel */
#define CONFIG_SYS_BARGSIZE	512
/* List of legal baudrate settings for this board */
#define CONFIG_SYS_BAUDRATE_TABLE	{ 38400 }
#define CONFIG_DOS_PARTITION

/* SCI */
#define CONFIG_SCI		1
#define CONFIG_SCIF_CONSOLE	1
#define CONFIG_CONS_SCIF1	1

/* TIMER */
#define CONFIG_TIMER_BASE	0xffff80	/* CH0-1 */

#define CONFIG_SYS_MEMTEST_START	KANEBEBE_DRAM_BASE
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_MEMTEST_START + (3 * 1024 * 1024))

#define CONFIG_SYS_DRAM_BASE	        KANEBEBE_DRAM_BASE
#define CONFIG_SYS_DRAM_SIZE		(4 * 1024 * 1024)

#define CONFIG_SYS_SRAM_BASE		0xffc720
#define CONGIG_SYS_SRAM_SIZE		(14 * 1024)

#define CONFIG_SYS_LOAD_ADDR		0x400000
#define CONFIG_STANDALONE_LOAD_ADDR	0x400000
#define CONFIG_SYS_MALLOC_LEN		256 * 1024

#if 0
#define CONFIG_ENV_IS_IN_DATAFLASH	1
#define CONFIG_ENV_ADDR			0x001000
#endif
#define CONFIG_ENV_SIZE			4096
#define CONFIG_ENV_IS_NOWHERE	1
	
#define CONFIG_SYS_RX_ETH_BUFFER	1

#define CONFIG_SYS_NO_FLASH		1
/*#define CONFIG_HAS_DATAFLASH		1*/

/* Board Clock */
#define CONFIG_SYS_CLK_FREQ		25000000
#define CONFIG_SH_SCIF_CLK_FREQ		CONFIG_SYS_CLK_FREQ

/* GPIO */
#define CONFIG_H8300_GPIO \
	{0x00,0x00,0x00,0x00,0xff,0x0f,0x87,0xff,0x00,0xff,0xef}
#define CONFIG_H8300_INIT_DDR \
	{0xff,0xff,0x00,0x00,0x01,0x00,0x00,0x0e,0x00,0xff,0x00}

#ifdef CONFIG_NET
#define CONFIG_DRIVER_NE2000		1
#define CONFIG_DRIVER_NE2000_BASE	0x200000
#endif

#ifdef CONFIG_CMD_USB
#define CONFIG_USB_SL811HS		1
#define CONFIG_USB_SL811HS_ADDRESS	0x800000
#define CONFIG_USB_SL811HS_DATA		0x800002
#define CONFIG_USB_STORAGE		1
#endif

#if 0
#define CONFIG_USB_GADGET
#define CONFIG_USB_GADGET_N9604
#define CONFIG_USBN9604_BASE		0x800004
#define CONFIG_USBN9604_OFFSET		2
#define CONFIG_USB_GADGET_SERIAL
#define CONFIG_USB_TTY_CDC
#endif

#ifdef CONFIG_CMD_MMC_SPI
#define CONFIG_MMC			1
#define CONFIG_GENERIC_MMC		1
#define CONFIG_MMC_SPI			1
#define CONFIG_SOFT_SPI			1
#define SPI_SCL(ck) \
 	do {						\
		asm volatile("bld #0,%w0\n\t"		\
			     "bst #5,@0xffffda:8"	\
			     ::"r"(ck));		\
	} while (0)
#define SPI_SDA(dout) \
	do {						\
		asm volatile("bld #7,%w0\n\t"		\
			     "bst #6,@0xffffda:8"	\
			     ::"r"(dout));		\
	} while (0)

#define SPI_READ \
	({ unsigned char din;						\
	asm volatile("sub.b %w0,%w0\n\t"				\
		     "bld #7,@0xffffda:8\n\t"				\
		     "bst #0,%w0"					\
		     :"=r"(din));					\
	(din);})
#define SPI_DELAY
#endif

#ifdef CONFIG_CMD_LED
#define CONFIG_GPIO_LED
#define CONFIG_STATUS_LED
#define CONFIG_BOARD_SPECIFIC_LED
#define CONFIG_STATUS_LED
#define STATUS_LED_STATE		STATUS_LED_OFF
#define STATUS_LED_BIT			0x0907
#define STATUS_LED_PERIOD		(CONFIG_SYS_HZ / 5000)
#define STATUS_LED_STATE1		STATUS_LED_OFF
#define STATUS_LED_BIT1			0x0906
#define STATUS_LED_PERIOD1		(CONFIG_SYS_HZ / 5000)
#define CONFIG_GPIO_LED_INVERTED_TABLE	{0x0907,0x0906}
#endif

#endif
