/*
 * National 9604 USB device controller driver
 *
 * Copyright 2003 Technical Solutions Inc.
 *
 * ported from:
 * 
 * Toshiba TC86C001 ("Goku-S") USB Device Controller driver
 *
 * Copyright (C) 2000-2002 Lineo
 *      by Stuart Lynne, Tom Rushworth, and Bruce Balden
 * Copyright (C) 2002 Toshiba Corporation
 * Copyright (C) 2003 MontaVista Software (source@mvista.com)
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#define MAX_FIFO_SIZE   64
#define MAX_EP0_SIZE    8

struct n9604_ep {
	struct usb_ep                           ep;
	struct n9604_udc			*dev;
	unsigned long				irqs;
	int					acct_req_lengths[4];
	int					acct_req_dir[4];//direction
	unsigned long				queue_reqs;//how many times has n9604_queue been called
	unsigned long				queue_active;//how many current requests
	unsigned long				packets;//counter of raw packets
	unsigned				num:4,
						numActual:4,
						fifoNum:2,
						is_in:1,
						stage:2,//for ep0, 0 = unused, 1 = got setup, 2 = done transfer/ready to send/receive ZLP
						toggle:1,
						nuking:1;//are we killing on off this endpoint//only used for ep0 to help with stages
	/* analogous to a host-side qh */
	struct list_head			queue;
	const struct usb_endpoint_descriptor	*desc;

	u8					control;
	u8					fifo;
	u8					status;
	u8					command;
};

struct n9604_request {
	struct usb_request		req;
	struct list_head		queue;
	int				complete;//this is added for tx requests
						//if set the entire request has been written to the fifo, just waiting for confirmation
						//from the interrupt that it has been sent

	unsigned			mapped:1;
};

struct n9604_udc {
	struct usb_gadget		gadget;
	struct n9604_ep			ep[7];
	struct usb_gadget_driver	*driver;
	int				configured;

	u8				address;

	/* statistics... */
	unsigned long			irqs;
};


/*-------------------------------------------------------------------------*/

#define xprintf(dev,fmt,args...) \
	printf("%s %s: " fmt , driver_name , \
			"S2410 gadget" , ## args)

#define ERROR(dev,fmt,args...) \
	xprintf(dev , fmt , ## args)
#define WARN(dev,fmt,args...) \
	xprintf(dev , fmt , ## args)
#define INFO(dev,fmt,args...) \
	xprintf(dev , fmt , ## args)

