//******************************************************************************
//
// MIDITrail / MTNoteDesignMod
//
// m[gfUCModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTNoteDesign.h"
//******************************************************************************
// m[gfUCModNX
//******************************************************************************
class MTNoteDesignMod : public MTNoteDesign
{
public:

	//RXgN^^fXgN^
	MTNoteDesignMod(void);
	virtual ~MTNoteDesignMod(void);

	//
	virtual int Initialize(const TCHAR* pSceneName, SMSeqData* pSeqData);

	//g\Ԏ擾
	unsigned long GetRippleDecayDuration();
	unsigned long GetRippleReleaseDuration();

	//g`擾
	D3DBLEND GetRippleSrcBlend();
	D3DBLEND GetRippleDestBlend();
	unsigned long GetRippleOverwriteTimes();
	float GetRippleSpacing();

	//gTCY擾
	float GetRippleHeight(float rate);
	float GetRippleWidth(float rate);
	float GetRippleAlpha(float rate);
	float GetDecayCoefficient(
				float rate,					//TCY䗦
				float saturation = 20.0f	//Oax
			);

	//m[g{bNX_W擾
	void GetActiveNoteBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0,	//ȗFsb`xhx
				float rate = 0.0f						//ȗFTCY䗦
			);

	//m[g{bNXJ[擾
	D3DXCOLOR GetActiveNoteBoxColor(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				float rate
			);

protected:

	virtual void _Clear();
	virtual int _LoadConfFile(const TCHAR* pSceneName);

private:

	//fBPC
	int m_RippleDecayDuration;
	//[X
	int m_RippleReleaseDuration;

	//`挳ibv摜juhw 
	D3DBLEND m_RippleSrcBlend;
	//`iwi摜juhw
	D3DBLEND m_RippleDestBlend;

	//㏑
	int m_RippleOverwriteTimes;
	//`Ԋu
	float m_RippleSpacing;
};


