//******************************************************************************
//
// MIDITrail / MTGridRingLive
//
// Cuj^pObhO`NX
//
// Copyright (C) 2019-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DXPrimitive.h"
#include "MTNoteDesignRing.h"


//******************************************************************************
// Cuj^pObhO`NX
//******************************************************************************
class MTGridRingLive
{
public:
	
	//RXgN^^fXgN^
	MTGridRingLive(void);
	virtual ~MTGridRingLive(void);
	
	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName);
	
	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//
	void Release();
	
	//\ݒ
	void SetEnable(bool isEnable);
	
private:
	
	DXPrimitive m_Primitive;
	MTNoteDesignRing m_NoteDesign;
	bool m_isVisible;
	bool m_isEnable;
	
	//_obt@\
	struct MTGRIDBOXLIVE_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};
	
	//_obt@FVFtH[}bg
	unsigned long _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }
	
	int _CreateVertexOfGrid(
			MTGRIDBOXLIVE_VERTEX* pVertex,
			unsigned long* pIbIndex
		);
	
	void _MakeMaterial(D3DMATERIAL9* pMaterial);

};


