/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ eLXgXN[ ]
 */

#pragma once

#include "bdlist.h"

/*
 * LN^\
 */
typedef struct _SCREEN_CHR
{
    /* LN^(0x0100͔pA0x0100ȏ͑Sp */
    wchar_t chr;

    /* Sp̍EEtO(TRUE:EAFALSE:)p͏FALSE */
    BOOL right;

    /* tHAOEhJ[(eLXgF) */
    COLORREF fore;

    /* obNOEhJ[(wiF) */
    COLORREF back;
} SCREEN_CHR;

/*
 * \LN^\
 */
typedef struct _SCREEN_REAL_CHR
{
    /* ݂̃LN^ */
    SCREEN_CHR current;

    /* `悵LN^ */
    SCREEN_CHR draw;

    /* `W(p) */
    RECT rect_ank;

    /* `W(Sp) */
    RECT rect_kanji;
} SCREEN_REAL_CHR;

/*
 * \C\
 */
typedef struct _SCREEN_REAL_LINE
{
    /* \CPʂőoXg\ */
    BDLIST_ENTRY bdlist;

    /* ̃C̕ */
    UINT chrs;

    /* \LN^\̂̔z */
    SCREEN_REAL_CHR *buf;
} SCREEN_REAL_LINE;

/*
 * \XN[\
 */
typedef struct _SCREEN_REAL_SCREEN
{
    /* C̕ */
    BOOL dir_up;

    /* EBhE̕(LN^) */
    UINT width_chr;

    /* EBhE̍(LN^) */
    UINT height_chr;

    /* C̐ */
    UINT lines;

    /* J[\ʒuxW */
    UINT x;

    /* J[\ʒuyW */
    UINT y;

    /* J[\ʒũtHAOEhJ[ */
    COLORREF fore;

    /* J[\ʒũobNOEhJ[ */
    COLORREF back;

    /* ŏ̃C */
    SCREEN_REAL_LINE *head;
} SCREEN_REAL_SCREEN;

/*
 * zC\
 */
typedef struct _SCREEN_VIRT_LINE
{
    /* zCPʂőoXg\ */
    BDLIST_ENTRY bdlist;

    /* ̃C̕ */
    UINT chrs;

    /* LN^\̂̔z */
    SCREEN_CHR *buf;
} SCREEN_VIRT_LINE;

/*
 * zXN[\
 */
typedef struct _SCREEN_VIRT_SCREEN
{
    /* C̐ */
    UINT lines;

    /* J[\ʒuxW */
    UINT x;

    /* XN[ʒu */
    UINT pos;

    /* ŏ̃C */
    SCREEN_VIRT_LINE *head;
} SCREEN_VIRT_SCREEN;

/*
 * XN[IuWFNg
 */
typedef struct _SCREEN_OBJECT
{
    /* XN[PʂőoXg\ */
    BDLIST_ENTRY bdlist;

    /*
     * ĂяoZbg̈
     */

    /* EBhE̖ */
    LPWSTR name;

    /* eEBhE */
    HWND parent;

    /* eEBhENCAgxW */
    int x;

    /* eEBhENCAgyW */
    int y;

    /* EBhE̕ */
    int width;

    /* EBhE̍ */
    int height;

    /* XN[o[̗L(\˂) */
    BOOL vscroll;

    /* ftHg̃tHAOEhJ[ */
    COLORREF fore_def;

    /* ft4Hg̃obNOEhJ[ */
    COLORREF back_def;

    /*
     * XN[Ǘ̈
     */

    /* \XN[ */
    SCREEN_REAL_SCREEN real;

    /* zXN[ */
    SCREEN_VIRT_SCREEN virt;

    /* `撆̃tHAOEhJ[ */
    COLORREF fore_draw;

    /* `撆̃obNOEhJ[ */
    COLORREF back_draw;

#ifdef _DEBUG
    /* `悵LN^ */
    UINT chrs_draw;
#endif /* _DEBUG */

    /* XVvtO */
    BOOL update;

    /* jtO */
    BOOL destroy;

    /* EBhEnh */
    HWND hwnd;
} SCREEN_OBJECT;

/*
 * O[o֐
 */

/*  */
BOOL screen_init(void);

/* 쐬 */
BOOL screen_create(SCREEN_OBJECT *screen);

/* TCY */
void screen_resize(SCREEN_OBJECT *screen);

/* ACh */
void screen_idle(void);

/* \XN[̈ʒuw */
void screen_locate(SCREEN_OBJECT *screen, UINT x, UINT y);

/* \XN[̕] */
void screen_reverse(SCREEN_OBJECT *screen, BOOL reverse);

/* \XN[͈̔͂NA */
void screen_clear(SCREEN_OBJECT *screen, UINT width, UINT height);

/* \XN[֏o */
void screen_print(SCREEN_OBJECT *screen, const wchar_t *buf);

/* zXN[֏o */
void screen_add(SCREEN_OBJECT *screen, const wchar_t *buf);
