/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ j^GA ]
 */

#include "header.h"
#include "screen.h"
#include "monitor.h"

/*
 * 萔
 */

/* EBhELvV */
#define MONITOR_WINDOW_NAME             L"j^"

/*
 * staticϐ
 */

/* XN[IuWFNg */
static SCREEN_OBJECT g_monitor_screen;

/*
 * j^GA
 * 
 */
BOOL monitor_init(HWND parent, int x, int y, int width, int height)
{
    /* XN[IuWFNg */
    memset(&g_monitor_screen, 0, sizeof(g_monitor_screen));

    /* p[^Zbg */
    g_monitor_screen.name = MONITOR_WINDOW_NAME;
    g_monitor_screen.parent = parent;
    g_monitor_screen.x = x;
    g_monitor_screen.y = y;
    g_monitor_screen.width = width;
    g_monitor_screen.height = height;
    g_monitor_screen.fore_def = GetSysColor(COLOR_WINDOWTEXT);
    g_monitor_screen.back_def = GetSysColor(COLOR_WINDOW);
    g_monitor_screen.vscroll = FALSE;

    /* XN[쐬 */
    return screen_create(&g_monitor_screen);
}

/*
 * j^GA
 * TCY
 */
void monitor_resize(int x, int y, int width, int height)
{
    /* p[^Zbg */
    g_monitor_screen.x = x;
    g_monitor_screen.y = y;
    g_monitor_screen.width = width;
    g_monitor_screen.height = height;

    /* XN[TCY */
    screen_resize(&g_monitor_screen);
}

/*
 * j^GA
 * ʒuw
 */
void monitor_locate(UINT x, UINT y)
{
    screen_locate(&g_monitor_screen, x, y);
}

/*
 * j^GA
 * ]
 */
void monitor_reverse(BOOL reverse)
{
    screen_reverse(&g_monitor_screen, reverse);
}

/*
 * j^GA
 * NA
 */
void monitor_clear(UINT width, UINT height)
{
    screen_clear(&g_monitor_screen, width, height);
}

/*
 * j^GA
 * o(char)
 */
void monitor_printf(const char *format, ...)
{
    char multibyte[0x400];
    wchar_t wide[0x400];
    va_list ap;
    int result;

    assert(NULL != format);

    /* tH[}bg */
    va_start(ap, format);
    vsprintf_s(multibyte, _countof(multibyte), format, ap);
    multibyte[_countof(multibyte) - 1] = '\0';
    va_end(ap);

    /* Ch֕ϊ */
    result = MultiByteToWideChar(
        CP_ACP,
        MB_PRECOMPOSED,
        multibyte,
        -1,
        wide,
        _countof(wide));
    if (0 == result)
    {
        return;
    }
    wide[_countof(wide) - 1] = L'\0';

    /* \XN[֏o */
    screen_print(&g_monitor_screen, wide);
}

/*
 * j^GA
 * ACh
 */
void monitor_idle(void)
{
    SYSTEMTIME st;

    /* [J^C擾 */
    GetLocalTime(&st);

    /* ݎ\ */
    monitor_locate(0, 0);
    monitor_reverse(TRUE);
    monitor_printf("ݎ %02d:%02d:%02d\n", st.wHour, st.wMinute, st.wSecond);
    monitor_reverse(FALSE);
}
