/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ R\[ ]
 */

#include "header.h"
#include "screen.h"
#include "cons.h"

/*
 * 萔
 */

/* EBhELvV */
#define CONS_WINDOW_NAME                L"R\["

/*
 * staticϐ
 */

/* XN[IuWFNg */
static SCREEN_OBJECT g_cons_screen;

/*
 * R\[
 * 
 */
BOOL cons_init(HWND parent, int x, int y, int width, int height)
{
    /* XN[IuWFNg */
    memset(&g_cons_screen, 0, sizeof(g_cons_screen));

    /* p[^Zbg */
    g_cons_screen.name = CONS_WINDOW_NAME;
    g_cons_screen.parent = parent;
    g_cons_screen.x = x;
    g_cons_screen.y = y;
    g_cons_screen.width = width;
    g_cons_screen.height = height;
    g_cons_screen.fore_def = GetSysColor(COLOR_WINDOW);
    g_cons_screen.back_def = GetSysColor(COLOR_WINDOWTEXT);
    g_cons_screen.vscroll = TRUE;

    /* XN[쐬 */
    return screen_create(&g_cons_screen);
}

/*
 * R\[
 * TCY
 */
void cons_resize(int x, int y, int width, int height)
{
    /* p[^Zbg */
    g_cons_screen.x = x;
    g_cons_screen.y = y;
    g_cons_screen.width = width;
    g_cons_screen.height = height;

    /* XN[TCY */
    screen_resize(&g_cons_screen);
}

/*
 * R\[
 * ACh
 */
void cons_idle(void)
{
}

/*
 * R\[
 * o
 */
void cons_printf(const char *format, ...)
{
    char multibyte[0x400];
    wchar_t wide[0x400];
    va_list ap;
    int result;

    assert(NULL != format);

    /* tH[}bg */
    va_start(ap, format);
    vsprintf_s(multibyte, _countof(multibyte), format, ap);
    multibyte[_countof(multibyte) - 1] = '\0';
    va_end(ap);

    /* Ch֕ϊ */
    result = MultiByteToWideChar(
        CP_ACP,
        MB_PRECOMPOSED,
        multibyte,
        -1,
        wide,
        _countof(wide));
    if (0 == result)
    {
        return;
    }
    wide[_countof(wide) - 1] = L'\0';

    /* \XN[֒ǉ */
    screen_add(&g_cons_screen, wide);
}
