/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ ʐM|[g ]
 */

#include "header.h"
#include "logwin.h"
#include "comm.h"

/*
 * 萔
 */

/* sȒʐM|[g */
#define INVALID_COMM_PORTS              0xffffffff

/* {[[g */
#define COMM_PORT_BAUDRATE              115200

/* Mobt@TCY */
#define COMM_INQUEUE_BYTES              0x1000

/* Mobt@TCY */
#define COMM_OUTQUEUE_BYTES             0x1000

/*
 * staticϐ
 */

/* ŏ̒ʐM|[g */
static COMM_PORT *g_comm_port_head;

/* oꂽʐM|[g */
static UINT g_comm_port_num;

/*
 * ʐM|[g
 * |[g̏
 */
static void comm_port_init(COMM_PORT *port)
{
    assert(NULL != port);

    /* [NA */
    memset(port, 0, sizeof(COMM_PORT));

    /* oXg */
    bdlist_init((BDLIST_ENTRY*)port);

    /* t@Cnh */
    port->file_handle = INVALID_HANDLE_VALUE;
}

/*
 * ʐM|[g
 * |[g̃N[Y
 */
static void comm_port_close(COMM_PORT *port)
{
    assert(NULL != port);

    /* I[vĂ */
    if (INVALID_HANDLE_VALUE != port->file_handle)
    {
        /* N[Y */
        CloseHandle(port->file_handle);
        port->file_handle = INVALID_HANDLE_VALUE;
    }
}

/*
 * ʐM|[g
 * |[g̔j
 */
static void comm_port_destroy(COMM_PORT *port)
{
    assert(NULL != port);

    /* |[g̃N[Y */
    comm_port_close(port);

    /* |[gl[ */
    if (NULL != port->port_name)
    {
        free(port->port_name);
        port->port_name = NULL;
    }

    /* |[gt@C */
    if (NULL != port->port_file)
    {
        free(port->port_file);
        port->port_file = NULL;
    }

    /* thl[ */
    if (NULL != port->friendly_name)
    {
        free(port->friendly_name);
        port->friendly_name = NULL;
    }
}

/*
 * ʐM|[g
 * thl[̎擾
 */
static BOOL comm_port_get_friendly(COMM_PORT *port, HDEVINFO hDevInfo, PSP_DEVINFO_DATA data)
{
    BOOL result;
    DWORD required;

    assert(NULL != hDevInfo);
    assert(NULL != data);
    assert(NULL != port);

    /* thl[擾ɕKvȃobt@TCY𓾂 */
    required = 0;
    SetupDiGetDeviceRegistryProperty(
        hDevInfo,
        data,
        SPDRP_FRIENDLYNAME,
        NULL,
        NULL,
        0,
        &required);
    if (0 == required)
    {
        return FALSE;
    }

    /* obt@m(ۂrequired̓oCgPʂȂ̂ŁAł2{mۂĂ) */
    port->friendly_name = (wchar_t*)malloc(required * sizeof(wchar_t));
    assert(NULL != port->friendly_name);
    if (NULL == port->friendly_name)
    {
        return FALSE;
    }

    /* thl[擾 */
    result = SetupDiGetDeviceRegistryProperty(
        hDevInfo,
        data,
        SPDRP_FRIENDLYNAME,
        NULL,
        (PBYTE)port->friendly_name,
        required * sizeof(wchar_t),
        NULL);
    if (FALSE == result)
    {
        /* obt@ */
        free(port->friendly_name);
        port->friendly_name = NULL;
        return FALSE;
    }

    /* port->friendly_name͗Lȃobt@ */
    return TRUE;
}

/*
 * ʐM|[g
 * WXg̎擾
 */
static BOOL comm_port_get_registry(COMM_PORT *port, HDEVINFO hDevInfo, PSP_DEVINFO_DATA data)
{
    BOOL result;
    HKEY key;
    LONG error;
    DWORD type;
    DWORD size;

    assert(NULL != port);
    assert(NULL != hDevInfo);
    assert(NULL != data);

    /* ߂lFALSEŏ */
    result = FALSE;

    /* WXgL[𓾂 */
    key = SetupDiOpenDevRegKey(
        hDevInfo,
        data,
        DICS_FLAG_GLOBAL,
        0,
        DIREG_DEV,
        KEY_QUERY_VALUE);
    if (INVALID_HANDLE_VALUE == key)
    {
        return result;
    }

    /* WXg̓ǂݏoɕKvȃTCY擾 */
    error = RegQueryValueEx(
        key,
        L"PortName",
        NULL,
        &type,
        NULL,
        &size
    );

    /* TCY擾ł */
    if ((ERROR_SUCCESS == error) && (REG_SZ == type))
    {
        /* obt@m(ۂsize̓oCgPʂȂ̂ŁAł2{mۂĂ) */
        port->port_name = (wchar_t*)malloc(size * sizeof(wchar_t));
        if (NULL != port->port_name)
        {
            /* vTCY2{mۂĂ邱Ƃ */
            size *= sizeof(wchar_t);

            /* WXgǂݏo */
            error = RegQueryValueEx(
                key,
                L"PortName",
                NULL,
                NULL,
                (LPBYTE)port->port_name,
                &size);

            /* WXg擾ł */
            if (ERROR_SUCCESS == error)
            {
                /* ߂lTRUE */
                result = TRUE;
            }
            else
            {
                /* obt@ */
                free(port->port_name);
                port->port_name = NULL;
            }
        }
    }

    /* WXgL[ */
    RegCloseKey(key);

    return result;
}

/*
 * ʐM|[g
 * |[gt@C̎擾
 */
static BOOL comm_port_get_file(COMM_PORT *port)
{
    size_t len;

    assert(NULL != port);
    assert(NULL != port->port_name);
    assert(NULL == port->port_file);

    /* 擾 */
    len = wcslen(port->port_name);

    /* \\.\̂4ǉ */
    len += 4;

    /* I[̂1ǉ */
    len++;

    /* obt@m */
    port->port_file = (wchar_t*)malloc(len * sizeof(wchar_t));
    if (NULL == port->port_file)
    {
        return FALSE;
    }

    /* \\.\Zbg */
    wcscpy_s(port->port_file, len, L"\\\\.\\");

    /* |[g𑱂 */
    wcscat_s(port->port_file, len, port->port_name);

    return TRUE;
}

/*
 * ʐM|[g
 * |[g̒ǉ(mf[^)
 */
static void comm_port_add_data(COMM_PORT *data)
{
    COMM_PORT *port;

    /* q[vm */
    port = (COMM_PORT*)malloc(sizeof(COMM_PORT));
    assert(NULL != port);

    /* |[g */
    comm_port_init(port);

    /* X^bNf[^q[vf[^Ɉڍs(std::move) */
    port->friendly_name = data->friendly_name;
    data->friendly_name = NULL;
    port->port_file = data->port_file;
    data->port_file = NULL;
    port->port_name = data->port_name;
    data->port_name = NULL;

    /* |[gԍZbg */
    port->port_number = wcstoul(&port->port_name[3], NULL, 10);

    /* ŏ̃|[g */
    if (NULL == g_comm_port_head)
    {
        /* ŏ̃|[g */
        g_comm_port_head = port;
    }
    else
    {
        /* Xg̖ɒǉ */
        bdlist_insert_tail((BDLIST_ENTRY*)g_comm_port_head, (BDLIST_ENTRY*)port);
    }
}

/*
 * ʐM|[g
 * |[g̒ǉ
 */
static BOOL comm_port_add(HDEVINFO hDevInfo, PSP_DEVINFO_DATA data)
{
    COMM_PORT port;
    BOOL result;

    assert(NULL != hDevInfo);
    assert(NULL != data);

    /* |[g */
    comm_port_init(&port);

    /* thl[̎擾 */
    result = comm_port_get_friendly(&port, hDevInfo, data);
    if (FALSE == result)
    {
        return FALSE;
    }

    /* |[gl[̎擾 */
    result = comm_port_get_registry(&port, hDevInfo, data);
    if (FALSE == result)
    {
        /* thl[ */
        comm_port_destroy(&port);
        return FALSE;
    }

    /* |[gl[̐擪"COM"`FbN */
    if (0 == _wcsnicmp(port.port_name, L"COM", 3))
    {
        /* |[gǉ */
        result = comm_port_get_file(&port);
        if (FALSE == result)
        {
            /* thl[A|[gl[ */
            comm_port_destroy(&port);
        }
        else
        {
            /* thl[A|[gl[A|[gt@Cǉ */
            comm_port_add_data(&port);
        }
    }
    else
    {
        /* thl[A|[gl[ */
        comm_port_destroy(&port);
    }

    /* |[gl[̐擪"COM"łȂꍇp */
    return TRUE;
}


/*
 * ʐM|[g
 * ׂĂ̒ʐM|[g̗
 */
static void comm_allport_enum(HDEVINFO hDevInfo)
{
    SP_DEVINFO_DATA data;
    DWORD index;
    BOOL result;

    assert(NULL != hDevInfo);

    /* CfbNX */
    index = 0;

    /* ʂTRUEɏ */
    result = TRUE;

    /* ʂTRUEł胋[v */
    while (FALSE != result)
    {
        /* data𖈉[NAA\̃TCYZbg */
        memset(&data, 0, sizeof(data));
        data.cbSize = sizeof(data);

        /* foCXCX^X擾 */
        result = SetupDiEnumDeviceInfo(hDevInfo, index, &data);
        if (FALSE != result)
        {
            /* foCXCX^X擾ł̂ŁAfoCXǉ */
            result = comm_port_add(hDevInfo, &data);
            if (FALSE != result)
            {
                /* foCXǉł̂ŁACfbNXi߂ */
                index++;
            }
        }
    }
}

/*
 * ʐM|[g
 * ׂĂ̒ʐM|[g̔j
 */
static void comm_allport_destroy(void)
{
    COMM_PORT *port;

    /* ʐM|[g݂胋[v */
    while (NULL != g_comm_port_head)
    {
        /* IuWFNgޔ */
        port = g_comm_port_head;

        /* oXgO */
        g_comm_port_head = (COMM_PORT*)bdlist_remove((BDLIST_ENTRY*)port);

        /* ʐM|[gj */
        comm_port_destroy(port);

        /* q[v */
        free(port);
    }
}

/*
 * ʐM|[g
 * ׂĂ̒ʐM|[g̃I[v`FbN
 */
static BOOL comm_allport_isopen(void)
{
    COMM_PORT *port;

    /*  */
    port = g_comm_port_head;

    /* |[gLł */
    while (NULL != port)
    {
        /* |[gI[vĂTRUEԂ */
        if (INVALID_HANDLE_VALUE != port->file_handle)
        {
            /* I[vĂ */
            return TRUE;
        }

        /*  */
        port = (COMM_PORT*)port->bdlist.bdlist_next;
    }

    /* ׂăI[vĂȂ */
    return FALSE;
}

/*
 * ʐM|[g
 * ׂĂ̒ʐM|[ǧ擾
 */
static UINT comm_allport_getnum(void)
{
    COMM_PORT *port;
    UINT num;

    /*  */
    num = 0;

    /*  */
    port = g_comm_port_head;

    /* |[gLł */
    while (NULL != port)
    {
        /* +1 */
        num++;

        /*  */
        port = (COMM_PORT*)port->bdlist.bdlist_next;
    }

    /* Ԃ */
    return num;
}

/*
 * ʐM|[g
 * |[gCfbNX|[g擾
 */
static COMM_PORT* comm_allport_getport(UINT index)
{
    COMM_PORT *port;
    UINT loop;

    /*  */
    port = g_comm_port_head;

    /* [v */
    for (loop = 0; loop < index; loop++)
    {
        assert(NULL != port);
        port = (COMM_PORT*)port->bdlist.bdlist_next;
    }

    return port;
}

/*
 * ʐM|[g
 * 
 */
void comm_init(void)
{
    /* ʐM|[gȂ */
    g_comm_port_head = NULL;

    /* |[gslɏ */
    g_comm_port_num = INVALID_COMM_PORTS;
}

/*
 * ʐM|[g
 * I
 */
void comm_deinit(void)
{
    /* ׂĂ̒ʐM|[g̔j */
    comm_allport_destroy();
}

/*
 * ʐM|[g
 * 
 */
void comm_enum(void)
{
    BOOL result;
    GUID guid;
    DWORD required;
    HDEVINFO hDevInfo;
    UINT num;
    COMM_PORT *port;
    UINT loop;

    /* |[gI[vĂΉȂ */
    result = comm_allport_isopen();
    if (FALSE != result)
    {
        return;
    }

    /* ׂĂ̒ʐM|[g̔j */
    comm_allport_destroy();

    /* PORTSNXɌѕtꂽGUID̎̂擾(GUIĎ͏1) */
    result = SetupDiClassGuidsFromName(L"PORTS", &guid, 1, &required);
    if (FALSE == result)
    {
        return;
    }
    if (1 != required)
    {
        return;
    }

    /* foCXZbg擾 */
    hDevInfo = SetupDiGetClassDevs(&guid, NULL, NULL, DIGCF_PRESENT);
    if (NULL == hDevInfo)
    {
        return;
    }

    /* Tu֐ɔC */
    comm_allport_enum(hDevInfo);

    /* foCXZbg̎gpI */
    SetupDiDestroyDeviceInfoList(hDevInfo);

    /* ύXȂꍇ͉Ȃ */
    num = comm_allport_getnum();
    if (g_comm_port_num == num)
    {
        return;
    }

    /* |[gXV */
    g_comm_port_num = num;

    /* |[gȂꍇ */
    if (0 == num)
    {
        logwin_printf("COM|[g܂");
        return;
    }
    else
    {
        logwin_printf("COM|[g%u|[g܂", num);

        /* |[g[v */
        for (loop = 0; loop < num; loop++)
        {
            port = comm_allport_getport(loop);
            assert(NULL != port);

            /* thl[Oo */
            logwin_printfw(port->friendly_name);
        }
    }
}

/*
 * ʐM|[g
 * |[g擾
 */
UINT comm_get_portnum(void)
{
    /* lł0Ԃ */
    if (INVALID_COMM_PORTS == g_comm_port_num)
    {
        return 0;
    }

    /* ȊO̓O[oϐԂ */
    return g_comm_port_num;
}

/*
 * ʐM|[g
 * I[v
 */
BOOL comm_open(UINT index)
{
    COMM_PORT *port;
    DCB dcb;
    COMMTIMEOUTS cto;
    BOOL result;

    /* ʐM|[g擾 */
    port = comm_allport_getport(index);
    if (NULL == port)
    {
        /* |[gIuWFNgȂ */
        return FALSE;
    }

    /* ɃI[vĂTRUEԂ */
    if (INVALID_HANDLE_VALUE != port->file_handle)
    {
        /* ɃI[vĂ */
        return TRUE;
    }

    /* I[v݂ */
    port->file_handle = CreateFile(
        port->port_file,
        GENERIC_READ | GENERIC_WRITE,
        0,
        NULL,
        OPEN_EXISTING,
        0,
        NULL);
    if (INVALID_HANDLE_VALUE == port->file_handle)
    {
        return FALSE;
    }

    /* DCB擾 */
    memset(&dcb, 0, sizeof(dcb));
    dcb.DCBlength = sizeof(dcb);
    result = GetCommState(port->file_handle, &dcb);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* DCBݒ */
    dcb.BaudRate = COMM_PORT_BAUDRATE;
    dcb.fBinary = TRUE;
    dcb.fParity = FALSE;
    dcb.fOutxCtsFlow = FALSE;
    dcb.fOutxDsrFlow = FALSE;
    dcb.fDtrControl = DTR_CONTROL_ENABLE;
    dcb.fDsrSensitivity = FALSE;
    dcb.fTXContinueOnXoff = TRUE;
    dcb.fOutX = FALSE;
    dcb.fInX = FALSE;
    dcb.fErrorChar = FALSE;
    dcb.fNull = FALSE;
    dcb.fRtsControl = RTS_CONTROL_ENABLE;
    dcb.fAbortOnError = FALSE;
    dcb.ByteSize = 8;
    dcb.Parity = NOPARITY;
    dcb.StopBits = ONESTOPBIT;
    result = SetCommState(port->file_handle, &dcb);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* ^CAEg̐ݒ */
    memset(&cto, 0, sizeof(cto));
    cto.ReadIntervalTimeout = MAXDWORD;
    cto.ReadTotalTimeoutConstant = 0;
    cto.ReadTotalTimeoutMultiplier = 0;
    cto.WriteTotalTimeoutConstant = 0;
    cto.WriteTotalTimeoutMultiplier = 0;
    result = SetCommTimeouts(port->file_handle, &cto);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* o̓obt@TCY̐ݒ */
    result = SetupComm(port->file_handle, COMM_INQUEUE_BYTES, COMM_OUTQUEUE_BYTES);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* Cxg}XN̐ݒ */
    result = SetCommMask(port->file_handle, 0);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* u[NԂ̉ */
    result = ClearCommBreak(port->file_handle);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* Mobt@̃NA */
    result = PurgeComm(port->file_handle, PURGE_RXCLEAR | PURGE_TXCLEAR);
    assert(FALSE != result);
    if (FALSE == result)
    {
        comm_port_close(port);
        return FALSE;
    }

    /* I[v */
    return TRUE;
}

/*
 * ʐM|[g
 * N[Y
 */
void comm_close(UINT index)
{
    COMM_PORT *port;

    /* ʐM|[g擾 */
    port = comm_allport_getport(index);
    if (NULL == port)
    {
        /* |[gIuWFNgȂ */
        return;
    }

    /* N[Y */
    comm_port_close(port);
}

/*
 * ʐM|[g
 * MoCg̎擾
 */
UINT comm_get_bytes(UINT index)
{
    COMM_PORT *port;
    DWORD errors;
    COMSTAT stat;
    BOOL result;

    /* ʐM|[g擾 */
    port = comm_allport_getport(index);
    if (NULL == port)
    {
        /* |[gIuWFNgȂ */
        return 0;
    }

    /* I[vĂ邩 */
    if (INVALID_HANDLE_VALUE == port->file_handle)
    {
        /* I[vĂȂ */
        return 0;
    }

    /* G[NAA擾 */
    result = ClearCommError(port->file_handle, &errors, &stat);
    if (FALSE == result)
    {
        /* |[gł */
        comm_port_close(port);
        return 0;
    }

    /* MoCgԂ */
    return (UINT)stat.cbInQue;
}

/*
 * ʐM|[g
 * M
 */
UINT comm_recv(UINT index, BYTE *buf, UINT buflen)
{
    COMM_PORT *port;
    UINT inque;
    DWORD bytes;
    BOOL result;

    assert(NULL != buf);

    /* MoCg𓾂 */
    inque = comm_get_bytes(index);
    if (0 == inque)
    {
        /* Mobt@Ƀf[^Ȃ */
        return 0;
    }

    /* inquebuflen̂Aɑ */
    if (buflen < inque)
    {
        inque = buflen;
    }

    /* |[g𓾂 */
    port = comm_allport_getport(index);
    assert(NULL != port);

    /* M */
    result = ReadFile(
        port->file_handle,
        buf,
        (DWORD)inque,
        &bytes,
        NULL);
    if (result == FALSE)
    {
        /* |[gł */
        comm_port_close(port);
        return 0;
    }

    /* MoCgԂ */
    return (UINT)bytes;
}

/*
 * ʐM|[g
 * M
 */
UINT comm_send(UINT index, const BYTE *buf, UINT buflen)
{
    COMM_PORT *port;
    DWORD written;
    BOOL result;

    /* ʐM|[g擾 */
    port = comm_allport_getport(index);
    if (NULL == port)
    {
        /* |[gIuWFNgȂ */
        return 0;
    }

    /* I[vĂ邩 */
    if (INVALID_HANDLE_VALUE == port->file_handle)
    {
        /* I[vĂȂ */
        return 0;
    }

    /* M */
    result = WriteFile(
        port->file_handle,
        buf,
        (DWORD)buflen,
        &written,
        NULL);
    if (result == FALSE)
    {
        /* |[gł */
        comm_port_close(port);
        return 0;
    }

    /* MoCgԂ */
    return (UINT)written;
}
