/*
 * ParsEvent.h
 *
 * Copyright 2001-2010 Texas Instruments, Inc. - http://www.ti.com/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/****************************************************************************/
/*                                                                          */
/*    MODULE:   ParsEvent.h                                                 */
/*    PURPOSE:                                                              */
/*                                                                          */
/****************************************************************************/
#ifndef _WIRELESS_TOOLS_H_
#define _WIRELESS_TOOLS_H_

/* defines */
/***********/

/* types */
/*********/

/* Structure used for parsing event streams, such as Wireless Events
 * and scan results */
typedef struct stream_descr {
	char *	end;		/* End of the stream */
	char *	current;	/* Current event in stream of events */
	char *	value;		/* Current value in event */
} stream_descr;

/*
 * Scan state and meta-information, used to decode events...
 */
typedef struct iwscan_state {
	/* State */
	int			ap_num;		/* Access Point number 1->N */
	int			val_index;	/* Value in table 0->(N-1) */
} iwscan_state;

/* functions */
/*************/
int
ParsEvent_GetEvent(struct stream_descr* pEventStream, struct iw_event* pEvent);

#endif  /* _WIRELESS_TOOLS_H_ */

