/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.utils;

import twitter4j.DirectMessage;
import twitter4j.RateLimitStatus;
import twitter4j.User;

import java.util.Date;

@SuppressWarnings("serial")
public class DirectMessageImpl implements DirectMessage {

    private User mSender;
    private String mMessage;
    private Date mCreated;
    private long mId;

    public DirectMessageImpl(long id, User sender, String message, Date created) {
        mId = id;
        mSender = sender;
        mMessage = message;
        mCreated = created;
    }

    public Date getCreatedAt() {
        return mCreated;
    }

    public long getId() {
        return mId;
    }

    public User getRecipient() {
        return null;
    }

    public int getRecipientId() {
        // Not implemented
        return -1;
    }

    public String getRecipientScreenName() {
        return null;
    }

    public User getSender() {
        return mSender;
    }

    public int getSenderId() {
        // Not implemented
        return -1;
    }

    public String getSenderScreenName() {
        return mSender.getScreenName();
    }

    public String getText() {
        return mMessage;
    }

    public RateLimitStatus getRateLimitStatus() {
        return null;
    }
}
