/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_EVENT_PROVIDER_URI;
import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_FRIEND_PROVIDER_URI;
import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_PLUGIN_PROVIDER_URI;
import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_SOURCE_PROVIDER_URI;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import com.sonyericsson.eventstream.twitterplugin.utility.EventStreamHelper;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;

@RunWith(PowerMockRunner.class)
@PrepareForTest( {
        ContentResolver.class, Cursor.class, Log.class, Uri.class
})
public class TestEventStreamHelper {

    private static final int ITEM_COUNT_IS_ONE = 1;

    private static final int ITEM_COUNT_IS_ZERO = 0;

    /**
     * Test that we return correct value when everything works OK.
     *
     * @throws Exception
     */
    @Test
    public void testIsPluginRegisteredCorrectValues() throws Exception {
        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);

        PowerMock.suppress(Uri.class.getMethods());

        Cursor cursor = PowerMock.createMock(Cursor.class);

        EasyMock.expect(
                contentResolver.query(EasyMock.eq(EVENTSTREAM_PLUGIN_PROVIDER_URI), EasyMock
                        .aryEq((String[])null), EasyMock.eq((String)null), EasyMock
                        .aryEq((String[])null), EasyMock.eq((String)null))).andReturn(cursor)
                .once();

        EasyMock.expect(cursor.getCount()).andReturn(ITEM_COUNT_IS_ONE).once();
        cursor.close();
        EasyMock.expectLastCall();
        PowerMock.replayAll();
        boolean result = EventStreamHelper.isPluginRegistered(contentResolver);
        PowerMock.verifyAll();
        assertTrue("Expected true when everything is ok", result);
    }

    /**
     * Test that we return false when cursor.getCount() return 0
     *
     * @throws Exception
     */
    @Test
    public void testIsPluginRegisteredGetCountCursorReturnsZero() throws Exception {
        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);

        PowerMock.suppress(Uri.class.getMethods());

        Cursor cursor = PowerMock.createMock(Cursor.class);

        EasyMock.expect(
                contentResolver.query(EasyMock.eq(EVENTSTREAM_PLUGIN_PROVIDER_URI), EasyMock
                        .aryEq((String[])null), EasyMock.eq((String)null), EasyMock
                        .aryEq((String[])null), EasyMock.eq((String)null))).andReturn(cursor)
                .once();

        EasyMock.expect(cursor.getCount()).andReturn(ITEM_COUNT_IS_ZERO).once();
        cursor.close();
        EasyMock.expectLastCall();
        PowerMock.replayAll();
        boolean result = EventStreamHelper.isPluginRegistered(contentResolver);
        PowerMock.verifyAll();
        assertFalse("Expected false when cursor.getCount() returns zero", result);
    }

    /**
     * Test normal behaviour of clearAll()
     *
     * @throws Exception
     */
    @Test
    public void testClearAllCorrectValues() throws Exception {
        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);

        PowerMock.suppress(Uri.class.getConstructors());

        try {
            EasyMock.expect(
                    contentResolver.delete(EasyMock.eq(EVENTSTREAM_PLUGIN_PROVIDER_URI), EasyMock
                            .eq((String)null), EasyMock.eq((String[])null))).andReturn(1)
                    .once();

            EasyMock.expect(
                    contentResolver.delete(EasyMock.eq(EVENTSTREAM_SOURCE_PROVIDER_URI), EasyMock
                            .eq((String)null), EasyMock.eq((String[])null))).andReturn(1)
                    .once();

            EasyMock.expect(
                    contentResolver.delete(EasyMock.eq(EVENTSTREAM_FRIEND_PROVIDER_URI), EasyMock
                            .eq((String)null), EasyMock.eq((String[])null))).andReturn(1)
                    .once();

            EasyMock.expect(
                    contentResolver.delete(EasyMock.eq(EVENTSTREAM_EVENT_PROVIDER_URI), EasyMock
                            .eq((String)null), EasyMock.eq((String[])null))).andReturn(1)
                    .once();
        } catch(Exception e) {
            fail("Exception must not be thrown here");
        }
        PowerMock.replayAll();
        EventStreamHelper.clearAll(contentResolver);
        PowerMock.verifyAll();
    }

    /**
     * Test normal behaviour of clearData()
     *
     * @throws Exception
     */
    @Test
    public void testClearDataCorrectValues() throws Exception {
        ContentResolver contentResolver = PowerMock.createMock(ContentResolver.class);

        PowerMock.suppress(Uri.class.getConstructors());

        try {
            EasyMock.expect(
                    contentResolver.delete(EasyMock.eq(EVENTSTREAM_EVENT_PROVIDER_URI), EasyMock
                            .eq((String)null), EasyMock.eq((String[])null))).andReturn(1)
                    .once();
            EasyMock.expect(
                    contentResolver.delete(EasyMock.eq(EVENTSTREAM_FRIEND_PROVIDER_URI), EasyMock
                            .eq((String)null), EasyMock.eq((String[])null))).andReturn(1)
                    .once();

        } catch(Exception e) {
            fail("Exception must not be thrown here");
        }
        PowerMock.replayAll();
        EventStreamHelper.clearData(contentResolver);
        PowerMock.verifyAll();
    }
}
