/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;

import com.sonyericsson.eventstream.twitterplugin.PluginConstants;
import com.sonyericsson.eventstream.twitterplugin.PluginConstants.InternalIntentExtraParams;
import com.sonyericsson.eventstream.twitterplugin.utility.NetworkHelper;
import com.sonyericsson.eventstream.twitterplugin.view.ConfigurationActivity;

import junit.framework.Assert;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;



@RunWith(PowerMockRunner.class)
@PrepareForTest({ConfigurationActivity.class, Context.class, Intent.class,
    NetworkHelper.class, ComponentName.class})
public class TestConfigurationActivityLogin {

    /**
     * Test to set notification
     * @throws Exception
     */
    @Test
    public void testValidLoginContent() throws Exception {
        String password = "password";
        String username = "username";

        PowerMock.suppress(Activity.class.getConstructors());
        ConfigurationActivity activity = PowerMock.createPartialMock(ConfigurationActivity.class,
                "startActivity", "getIntent", "finish", "validateUserName", "validatePassword");

        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        Intent intent = PowerMock.createMock(Intent.class);
        ComponentName comp = PowerMock.createMock(ComponentName.class);
        PowerMock.mockStatic(NetworkHelper.class);

        EasyMock.expect(Whitebox.invokeMethod(activity, "validateUserName")).andReturn(username).once();
        EasyMock.expect(Whitebox.invokeMethod(activity, "validatePassword")).andReturn(password).once();

        EasyMock.expect(NetworkHelper.isNetworkAvailable(context)).andReturn(true).once();

        try {
            PowerMock.expectNew(Intent.class, PluginConstants.TWITTER_AUTHENTICATE).andReturn(intent).once();
        } catch (Exception e) {
            Assert.fail("Could not create intent class: " + e.getMessage());
        }

        EasyMock.expect(intent.putExtra(InternalIntentExtraParams.USERNAME, username)).andReturn(intent).once();
        EasyMock.expect(intent.putExtra(InternalIntentExtraParams.PASSWORD, password)).andReturn(intent).once();
        EasyMock.expect(context.startService(intent)).andReturn(comp).once();

        PowerMock.replayAll();
        Whitebox.invokeMethod(activity, "callLogin", context);
        PowerMock.verifyAll();
    }
}
