/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.         *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 *
 * @author Maria Ekström (maria.ekstrom@sonyericsson.com)
 */

package com.sonyericsson.simpleui.utils;

import com.sonyericsson.simpleui.activity.SimpleUiInternal.Config;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;

public class DBUtilities {

    public static Cursor querySplineEventCursor(Activity activity, String eventId) {
        if (eventId == null) {
            return eventSourceViewQuery(activity);
        } else {
            return eventSourceViewQuery(activity, eventId);
//            activity.managedQuery(EventStreamContentProvider.Uris.EVENTS_CONTENT_URI,
//                null,
//                EventStreamContentProvider.ID_COLUMN + " = ?",
//                new String[] {eventId},
//                null);
        }
    }

    // TODO: This should be optimized.
    public static Cursor eventSourceViewQuery(Activity activity) {
        String sql = "select " + "event._id AS _id, " + "event.source_id, " + "event."
                + EventStreamContentProvider.EventColumns.PLUGIN_ID + ", "+ "event."
                + EventStreamContentProvider.EventColumns.MESSAGE + ", " + "event."
                + EventStreamContentProvider.EventColumns.IMAGE_URI + ", " + "event."
                + EventStreamContentProvider.EventColumns.PUBLISHED_TIME + ", " + "event."
                + EventStreamContentProvider.EventColumns.STATUS_ICON_URI + ", " + "event."
                + EventStreamContentProvider.EventColumns.TITLE + ", " + "event."
                + EventStreamContentProvider.EventColumns.PERSONAL + ", " + "event."
                + EventStreamContentProvider.EventColumns.OUTGOING + ", " + "event."
                + EventStreamContentProvider.EventColumns.DISPLAY_NAME + ", " + "event."
                + EventStreamContentProvider.EventColumns.FRIEND_KEY + ", " + "event."
                + EventStreamContentProvider.EventColumns.EVENT_KEY + ", " + "source."
                + EventStreamContentProvider.SourceColumns.NAME + ", " + "source."
                + EventStreamContentProvider.SourceColumns.ICON_URI + ", " + "source."
                + EventStreamContentProvider.SourceColumns.CURRENT_STATUS
                + " FROM event JOIN source ON " + "event."
                + EventStreamContentProvider.EventColumns.SOURCE_ID + " = " + "source._id"
                + " WHERE source." + EventStreamContentProvider.SourceColumns.ENABLED + " !=0 "
                + " AND " + EventStreamContentProvider.EventColumns.OUTGOING + " = 0 "
                + " AND " + EventStreamContentProvider.EventColumns.HANDLED_TYPE + " = 0 "
                + " ORDER BY " + EventStreamContentProvider.EventColumns.PUBLISHED_TIME + " DESC"
                + ";";

        return activity
                .managedQuery(EventStreamContentProvider.RawQuery.URI, null, sql, null, null);
    }

    public static Cursor eventSourceViewQuery(Activity activity, String eventId) {
        String sql = "select " + "event._id AS _id, " + "event.source_id, " + "event."
                + EventStreamContentProvider.EventColumns.PLUGIN_ID + ", "+ "event."
                + EventStreamContentProvider.EventColumns.MESSAGE + ", " + "event."
                + EventStreamContentProvider.EventColumns.IMAGE_URI + ", " + "event."
                + EventStreamContentProvider.EventColumns.PUBLISHED_TIME + ", " + "event."
                + EventStreamContentProvider.EventColumns.STATUS_ICON_URI + ", " + "event."
                + EventStreamContentProvider.EventColumns.TITLE + ", " + "event."
                + EventStreamContentProvider.EventColumns.PERSONAL + ", " + "event."
                + EventStreamContentProvider.EventColumns.OUTGOING + ", " + "event."
                + EventStreamContentProvider.EventColumns.DISPLAY_NAME + ", " + "event."
                + EventStreamContentProvider.EventColumns.FRIEND_KEY + ", " + "event."
                + EventStreamContentProvider.EventColumns.EVENT_KEY + ", " + "source."
                + EventStreamContentProvider.SourceColumns.NAME + ", " + "source."
                + EventStreamContentProvider.SourceColumns.ICON_URI + ", " + "source."
                + EventStreamContentProvider.SourceColumns.CURRENT_STATUS
                + " FROM event JOIN source ON " + "event."
                + EventStreamContentProvider.EventColumns.SOURCE_ID + " = " + "source._id"
                + " WHERE source." + EventStreamContentProvider.SourceColumns.ENABLED + " !=0 "
                + " AND " + EventStreamContentProvider.EventColumns.OUTGOING + " = 0 "
                + " AND " + EventStreamContentProvider.EventColumns.HANDLED_TYPE + " = 0 "
                + " AND event." + EventStreamContentProvider.ID_COLUMN + " =  " +eventId
                + " ORDER BY " + EventStreamContentProvider.EventColumns.PUBLISHED_TIME + " DESC"
                + ";";

        return activity
                .managedQuery(EventStreamContentProvider.RawQuery.URI, null, sql, null, null);
    }

    public static Uri getContactUri(Context context, String rawContactUri) {
        Uri contactUri = null;

        if (rawContactUri != null && rawContactUri.startsWith(ContactsContract.RawContacts.CONTENT_URI.toString())) {
            Cursor cursor = null;

            try {
                cursor = context.getContentResolver().query(Uri.parse(rawContactUri),
                        new String[]{ContactsContract.RawContacts.CONTACT_ID},
                        null, null, null);
                if (cursor != null && cursor.moveToNext()) {
                    int columnIndex = cursor.getColumnIndex(ContactsContract.RawContacts.CONTACT_ID);
                    long contactId = cursor.getLong(columnIndex);

                    contactUri = Uri.withAppendedPath(ContactsContract.Contacts.CONTENT_URI, String.valueOf(contactId));
                }
            } catch (SQLException exception) {
                Log.e(Config.LOG_TAG, "Can't query for contact id using raw contact");
            } finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        return contactUri;
    }
}

