/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.simpleui.activity;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.sonyericsson.simpleui.R;
import com.sonyericsson.simpleui.activity.SimpleUiInternal.Config;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;
import com.sonyericsson.simpleui.utils.ImageManager;
import com.sonyericsson.simpleui.utils.ImageUtilities;

public class SimpleUiEventsAdapter extends CursorAdapter {

    private final LayoutInflater mInflater;

    private final int mMainMessageTextIndex;

    private final int mTitleTextIndex;

    private final Bitmap mDefaultSourceIconBitmap;

    private final ImageManager mImageManager;

    static class TileViewHolder {
        TextView message;
        TextView friendName;
        ImageView backgroundImage;
        ImageView sourceIcon;
        ImageView eventIcon;
    }

    public SimpleUiEventsAdapter(SimpleUiEventsActivity activity, Cursor cursor) {
        super(activity, cursor);

        mInflater = LayoutInflater.from(activity);

        mMainMessageTextIndex = cursor
                .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.MESSAGE);
        mTitleTextIndex = cursor
                .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.TITLE);

        mImageManager = ImageManager.getInstance(activity);

        mDefaultSourceIconBitmap = BitmapFactory.decodeResource(
                activity.getResources(), R.drawable.generic_service);
        if (mDefaultSourceIconBitmap == null) {
            if (Config.DEBUG) {
                Log.i(Config.LOG_TAG, "Failed to decode default source icon image!");
            }
        }
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        final View eventView = mInflater.inflate(R.layout.event, null);

        TileViewHolder holder = new TileViewHolder();

        holder.message = (TextView)eventView.findViewById(R.id.event_message);
        holder.friendName = (TextView)eventView.findViewById(R.id.friend_name);
        holder.backgroundImage = (ImageView)eventView.findViewById(R.id.background_image);
        holder.sourceIcon = (ImageView)eventView.findViewById(R.id.source_icon);
        holder.eventIcon = (ImageView)eventView.findViewById(R.id.event_icon);
        eventView.setTag(holder);

        return eventView;
    }

    @Override
    public void bindView(View view, Context context, Cursor cursor) {

        long startTime = System.currentTimeMillis();
        TileViewHolder holder = (TileViewHolder)view.getTag();

        String mainMessageText = cursor.getString(mMainMessageTextIndex);
        holder.message.setText(mainMessageText);

        String titleText = cursor.getString(mTitleTextIndex);
        if (titleText != null && !titleText.equals("")) {
            holder.friendName.setText(titleText);
        } else {
            holder.friendName.setText(cursor.getString(cursor
                .getColumnIndex(EventStreamContentProvider.EventColumns.DISPLAY_NAME)));
        }

        mImageManager.getEventImage(holder.backgroundImage, cursor);

        String iconUriString = cursor.getString(cursor.getColumnIndex(
                EventStreamContentProvider.SourceColumns.ICON_URI));
        Bitmap sourceIconBitmap = ImageUtilities.decodeImageFromUri(
                context, Uri.parse(iconUriString));
        if (sourceIconBitmap == null) {
            sourceIconBitmap = mDefaultSourceIconBitmap;
        }
        holder.sourceIcon.setImageBitmap(sourceIconBitmap);

        String eventIconUriString = cursor.getString(cursor.getColumnIndex(
                EventStreamContentProvider.EventColumns.STATUS_ICON_URI));
        if (eventIconUriString != null) {
            Bitmap eventIconBitmap = ImageUtilities.decodeImageFromUri(
                    context, Uri.parse(eventIconUriString));
            if (eventIconBitmap != null) {
                holder.eventIcon.setImageBitmap(eventIconBitmap);
            }
        } else {
            holder.eventIcon.setImageBitmap(null);
        }

        long diffTime = System.currentTimeMillis() - startTime;
        if (Config.DEBUG) {
            Log.i(Config.LOG_TAG, "time for bindView = " + diffTime);
        }
    }
}
