/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file FaceBookLocaleListener.java
 *
 * @author
 */
package com.sonyericsson.eventstream.facebookplugin;

import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.Config;
import static com.sonyericsson.eventstream.facebookplugin.Constants.LOCALE_CHANGED_INTENT;
import static com.sonyericsson.eventstream.facebookplugin.Constants.PLUGIN_KEY_PARAMETER;
import static com.sonyericsson.eventstream.facebookplugin.Constants.PLUGIN_KEY;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class FaceBookLocaleListener extends BroadcastReceiver{
    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();

        if (Intent.ACTION_LOCALE_CHANGED.equals(action)) {
            if (Config.DEBUG) {
                Log.d("Facebook plugin", "Service received LOCALE_CHANGED");
            }
            Intent serviceIntent = new Intent(Constants.LOCALE_CHANGED_INTENT);
            serviceIntent.putExtra(PLUGIN_KEY_PARAMETER, PLUGIN_KEY);
            context.startService(serviceIntent);
        }
    }
}