/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.facebookplugin;

/**
 * @author Erik Hellman <erik.hellman@sonyericsson.com>
 */
public interface Constants {

    // Key used to authenticate intents sent from EventStream
    static final String PLUGIN_KEY_PARAMETER = "plugin_key";
    static final String PLUGIN_KEY = "PLUGIN_KEY_com.sonyericsson.eventstream.facebookplugin-673924817981782773912";

    // Server request constants
    static final String GRAPH_API_BASE_URL = "https://graph.facebook.com";
    static final String NEWS_FEED_PATH = "/me/home";
    static final String STATUSES_PATH = "/me/statuses";
    static final String FRIENDS_FEED_PATH = "/me/friends";
    static final String MY_FEED_PATH = "/me/feed";
    static final String MYSELF_PATH = "/me";
    static final String RESTFUL_API_BASE_URL = "https://api.facebook.com";
    static final String RESTFUL_SERVER = "api.facebook.com";
    static final String RESTFUL_PATH = "/restserver.php";
    static final String AUTH_LOGIN_METHOD = "facebook.auth.login";
    static final String GRAPH_API_SERVER = "graph.facebook.com";
    static final String EXCHANGE_SESSIONS_PATH = "/oauth/exchange_sessions";

    // HTTP request parameters names
    static final String API_KEY_PARAM = "api_key";
    static final String EMAIL_PARAM = "email";
    static final String PASSWORD_PARAM = "password";
    static final String SCOPE_PARAM = "scope";
    static final String METHOD_PARAM = "method";
    static final String SIG_PARAM = "sig";
    static final String TYPE_PARAM = "type";
    static final String CLIENT_ID_PARAM = "client_id";
    static final String CLIENT_SECRET_PARAM = "client_secret";
    static final String SESSIONS_PARAM = "sessions";
    static final String DATA_PARAMTER = "data";
    static final String SESSION_KEY_PARAM = "session_key";
    static final String TIME_PARAM = "t";
    static final String UID_PARAM = "uid";
    static final String URL_PARAM = "url";

    static final String CLIENT_CRED_VALUE = "client_cred";

    static final String SESSION_KEY_TAG = "session_key";
    static final String ACCESS_TOKEN_TAG = "access_token";
    static final String SESSION_SECRET_TAG = "secret";

    static final String SECRET_TAG = "secret";
    static final String UID_TAG = "uid";

    // Application identifiers used for authentication with Facebook
    static final String APPLICATION_ID = "55772661571";

    static final String LOG_TAG = "FacebookPlugin";

    // Shared preference constants
    static final String CONFIG_STORE = "facebook-plugin.conf";
    static final String ACCESS_TOKEN_PREFS_KEY = "facebook.access_token";
    static final String NEWS_FEED_SINCE_PREFS_KEY = "facebook.newsfeed.since";
    static final String LIMIT_PREFS_KEY = "facebook.newsfeed.limit";
    static final String LAST_COMMUNICATION_WITH_SERVER_KEY = "facebook.communication.lasttime";
    static final String OWN_ID_PREFS_KEY = "facebook.own.id";
    static final String SESSION_KEY = "facebook.communication.session_key";
    static final String SESSION_SECRET = "facebook.communication.session_secret";
    static final String HAS_ACCEPTED_DISCLAIMER = "facebook.accepted_disclaimer";
    static final String DISPLAY_NAME_KEY = "facebook.display.name";

    static final int LIMIT_FIRST_TIME = 150;
    static final int LIMIT_DEFAULT = 500;

    static final int CONN_PER_ROUTE = 10;
    static final long CONNECTION_TIMEOUT = 60000;
    static final int MAX_CONNECTIONS = 5;
    static final int RETRY_COUNT = 3;
    static final int STATUS_TEXT_MAX_LENGTH = 420;

    // Intent constants
    static final String SEND_STATUS_UPDATE_INTENT = "com.sonyericsson.facebook.SEND_STATUS_UPDATE";
    static final String REGISTER_PLUGIN_INTENT = "com.sonyericsson.facebook.REGISTER_PLUGIN";
    static final String REFRESH_REQUEST_INTENT = "com.sonyericsson.facebook.REFRESH_REQUEST";
    static final String AUTHENTICATE_INTENT = "com.sonyericsson.facebook.AUTHENTICATE";
    static final String LOGOUT_INTENT = "com.sonyericsson.facebook.LOGOUT";
    static final String LAUNCH_BROWSER_INTENT = "com.sonyericsson.facebook.VIEW_TILE";
    static final String LOCALE_CHANGED_INTENT = "com.sonyericsson.facebook.LOCALE_CHANGED";

    static final String USERNAME_EXTRA = "username";
    static final String PASSWORD_EXTRA = "password";
    static final String FRIEND_ID_EXTRA = "friend_id";
    static final String SERVICE_ID_EXTRA = "service_id";

    // For LAUNCH_BROWSER_INTENT
    static final String EVENT_KEY_EXTRA = "event_key";
    static final String FRIEND_KEY_EXTRA = "friend_key";

    static final String REFRESH_STATUSES_VALUES = "refreshStatuses";
    static final String REGISTER_PLUGIN_VALUES = "regsiterPlugin";
    static final String OFFICIAL_FACEBOOK_APP_PACKAGE = "com.facebook.katana";
    static final String FACEBOOK_REGISTER_URL = "http://m.facebook.com/r.php";
}
