/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.AccountSettings;
import twitter4j.AccountSettingsJSONImpl;
import twitter4j.AccountTotals;
import twitter4j.AccountTotalsJSONImpl;
import twitter4j.Category;
import twitter4j.CategoryJSONImpl;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Friendship;
import twitter4j.FriendshipJSONImpl;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.IDsJSONImpl;
import twitter4j.Location;
import twitter4j.LocationJSONImpl;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.PlaceJSONImpl;
import twitter4j.ProfileImage;
import twitter4j.ProfileImageImpl;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.QueryResultJSONImpl;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RateLimitStatusListener;
import twitter4j.RelatedResults;
import twitter4j.RelatedResultsJSONImpl;
import twitter4j.Relationship;
import twitter4j.RelationshipJSONImpl;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.SavedSearch;
import twitter4j.SavedSearchJSONImpl;
import twitter4j.SimilarPlaces;
import twitter4j.SimilarPlacesImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.TrendsJSONImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterOAuthSupportBaseImpl;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.api.AccountMethods;
import twitter4j.api.BlockMethods;
import twitter4j.api.DirectMessageMethods;
import twitter4j.api.FavoriteMethods;
import twitter4j.api.FriendsFollowersMethods;
import twitter4j.api.FriendshipMethods;
import twitter4j.api.GeoMethods;
import twitter4j.api.HelpMethods;
import twitter4j.api.LegalResources;
import twitter4j.api.ListMembersMethods;
import twitter4j.api.ListMethods;
import twitter4j.api.ListSubscribersMethods;
import twitter4j.api.LocalTrendsMethods;
import twitter4j.api.NewTwitterMethods;
import twitter4j.api.NotificationMethods;
import twitter4j.api.SavedSearchesMethods;
import twitter4j.api.SearchMethods;
import twitter4j.api.SpamReportingMethods;
import twitter4j.api.StatusMethods;
import twitter4j.api.TimelineMethods;
import twitter4j.api.TrendsMethods;
import twitter4j.api.UserMethods;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.RequestToken;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseEvent;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.util.StringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
extends TwitterOAuthSupportBaseImpl
implements Serializable,
SearchMethods,
TrendsMethods,
TimelineMethods,
StatusMethods,
UserMethods,
ListMethods,
ListMembersMethods,
ListSubscribersMethods,
DirectMessageMethods,
FriendshipMethods,
FriendsFollowersMethods,
AccountMethods,
FavoriteMethods,
NotificationMethods,
BlockMethods,
SpamReportingMethods,
SavedSearchesMethods,
LocalTrendsMethods,
GeoMethods,
LegalResources,
NewTwitterMethods,
HelpMethods {
    private static final long serialVersionUID = -1486360080128882436L;
    private final HttpParameter INCLUDE_ENTITIES;
    private final HttpParameter INCLUDE_RTS;

    Twitter(Configuration conf) {
        this(conf, AuthorizationFactory.getInstance(conf, true));
    }

    public Twitter() {
        super(ConfigurationContext.getInstance());
        this.INCLUDE_ENTITIES = new HttpParameter("include_entities", ConfigurationContext.getInstance().isIncludeEntitiesEnabled());
        this.INCLUDE_RTS = new HttpParameter("include_rts", this.conf.isIncludeRTsEnabled());
    }

    public Twitter(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.INCLUDE_ENTITIES = new HttpParameter("include_entities", ConfigurationContext.getInstance().isIncludeEntitiesEnabled());
        this.INCLUDE_RTS = new HttpParameter("include_rts", this.conf.isIncludeRTsEnabled());
    }

    Twitter(Configuration conf, String screenName, String password) {
        super(conf, screenName, password);
        this.INCLUDE_ENTITIES = new HttpParameter("include_entities", conf.isIncludeEntitiesEnabled());
        this.INCLUDE_RTS = new HttpParameter("include_rts", conf.isIncludeRTsEnabled());
    }

    Twitter(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.INCLUDE_ENTITIES = new HttpParameter("include_entities", conf.isIncludeEntitiesEnabled());
        this.INCLUDE_RTS = new HttpParameter("include_rts", conf.isIncludeRTsEnabled());
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (null != params1 && null != params2) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (null != params1) {
            return params1;
        }
        return params2;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter params2) {
        if (null != params1 && null != params2) {
            HttpParameter[] params = new HttpParameter[params1.length + 1];
            System.arraycopy(params1, 0, params, 0, params1.length);
            params[params.length - 1] = params2;
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (null != params1) {
            return params1;
        }
        return new HttpParameter[]{params2};
    }

    public String getScreenName() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (null == this.screenName) {
            if (this.auth instanceof BasicAuthorization) {
                this.screenName = ((BasicAuthorization)this.auth).getUserId();
                if (-1 != this.screenName.indexOf("@")) {
                    this.screenName = null;
                }
            }
            if (null == this.screenName) {
                this.verifyCredentials();
            }
        }
        return this.screenName;
    }

    public int getId() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (0 == this.id) {
            this.verifyCredentials();
        }
        return this.id;
    }

    @Override
    public QueryResult search(Query query) throws TwitterException {
        try {
            return new QueryResultJSONImpl(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("search.json").toString(), query.asHttpParameterArray(), null));
        }
        catch (TwitterException te) {
            if (404 == te.getStatusCode()) {
                return new QueryResultJSONImpl(query);
            }
            throw te;
        }
    }

    @Override
    public Trends getTrends() throws TwitterException {
        return new TrendsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends.json").toString()));
    }

    @Override
    public Trends getCurrentTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/current.json").toString())).get(0);
    }

    @Override
    public Trends getCurrentTrends(boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/current.json").append(excludeHashTags ? "?exclude=hashtags" : "").toString())).get(0);
    }

    @Override
    public List<Trends> getDailyTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/daily.json").toString()));
    }

    @Override
    public List<Trends> getDailyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/daily.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString()));
    }

    private String toDateStr(Date date) {
        if (null == date) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    @Override
    public List<Trends> getWeeklyTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/weekly.json").toString()));
    }

    @Override
    public List<Trends> getWeeklyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/weekly.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString()));
    }

    @Override
    public ResponseList<Status> getPublicTimeline() throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/public_timeline.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&include_rts=").append(this.conf.isIncludeRTsEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getHomeTimeline() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/home_timeline.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/home_timeline.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public ResponseList<Status> getFriendsTimeline() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends_timeline.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&include_rts=").append(this.conf.isIncludeRTsEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getFriendsTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{this.INCLUDE_RTS}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getUserTimeline(int userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName) throws TwitterException {
        return this.getUserTimeline(screenName, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(int userId) throws TwitterException {
        return this.getUserTimeline(userId, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline() throws TwitterException {
        return this.getUserTimeline(new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getMentions() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/mentions.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&include_rts=").append(this.conf.isIncludeRTsEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getMentions(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/mentions.json").toString(), this.mergeParameters(new HttpParameter[]{this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedByMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_me.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedByMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_me.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedToMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_me.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedToMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_me.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets_of_me.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets_of_me.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedToUser(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_ENTITIES}), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedToUser(int userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_ENTITIES}), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedByUser(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_ENTITIES}), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedByUser(int userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_ENTITIES}), this.auth));
    }

    @Override
    public ResponseList<User> getRetweetedBy(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/").append(statusId).append("/retweeted_by.json?count=100&include_entities").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<User> getRetweetedBy(long statusId, Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/").append(statusId).append("/retweeted_by.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public IDs getRetweetedByIDs(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/").append(statusId).append("/retweeted_by/ids.json?count=100&include_entities").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public IDs getRetweetedByIDs(long statusId, Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/").append(statusId).append("/retweeted_by/ids.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return new StatusJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/show/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public Status updateStatus(String status, GeoLocation location) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude()), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public Status updateStatus(String status, long inReplyToStatusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("in_reply_to_status_id", inReplyToStatusId), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public Status updateStatus(String status, long inReplyToStatusId, GeoLocation location) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude()), new HttpParameter("in_reply_to_status_id", inReplyToStatusId), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public Status updateStatus(StatusUpdate latestStatus) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), this.mergeParameters(latestStatus.asHttpParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/destroy/").append(statusId).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweet/").append(statusId).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets/").append(statusId).append(".json?count=100&include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/show.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User showUser(int userId) throws TwitterException {
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/show.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public ResponseList<User> lookupUsers(String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/lookup.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", Twitter.toCommaSeparatedString(screenNames)), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public ResponseList<User> lookupUsers(int[] ids) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/lookup.json").toString(), new HttpParameter[]{new HttpParameter("user_id", Twitter.toCommaSeparatedString(ids)), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/search.json").toString(), new HttpParameter[]{new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public ResponseList<Category> getSuggestedUserCategories() throws TwitterException {
        return CategoryJSONImpl.createCategoriesList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions.json").toString(), this.auth));
    }

    @Override
    public ResponseList<User> getUserSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions/").append(categorySlug).append(".json").toString(), this.auth);
        try {
            return UserJSONImpl.createUserList(res.asJSONObject().getJSONArray("users"), res);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public ResponseList<User> getMemberSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions/").append(categorySlug).append("/members.json").toString(), this.auth);
        return UserJSONImpl.createUserList(res.asJSONArray(), res);
    }

    @Override
    public ProfileImage getProfileImage(String screenName, ProfileImage.ImageSize size) throws TwitterException {
        return new ProfileImageImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/profile_image/").append(screenName).append(".json?size=").append(size.getName()).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses() throws TwitterException {
        return this.getFriendsStatuses(-1L);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(String screenName) throws TwitterException {
        return this.getFriendsStatuses(screenName, -1L);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(int userId) throws TwitterException {
        return this.getFriendsStatuses(userId, -1L);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(String screenName, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(int userId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).append("&cursor=").append(cursor).toString(), null, this.auth));
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses() throws TwitterException {
        return this.getFollowersStatuses(-1L);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(String screenName) throws TwitterException {
        return this.getFollowersStatuses(screenName, -1L);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(int userId) throws TwitterException {
        return this.getFollowersStatuses(userId, -1L);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(String screenName, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(int userId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList createUserList(String listName, boolean isPublicList, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(new HttpParameter("name", listName));
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (description != null) {
            httpParams.add(new HttpParameter("description", description));
        }
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/lists.json").toString(), httpParams.toArray(new HttpParameter[httpParams.size()]), this.auth));
    }

    @Override
    public UserList updateUserList(int listId, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        if (newListName != null) {
            httpParams.add(new HttpParameter("name", newListName));
        }
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (newDescription != null) {
            httpParams.add(new HttpParameter("description", newDescription));
        }
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/lists/").append(listId).append(".json").toString(), httpParams.toArray(new HttpParameter[httpParams.size()]), this.auth));
    }

    @Override
    public PagableResponseList<UserList> getUserLists(String listOwnerScreenName, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserListJSONImpl.createPagableUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList showUserList(String listOwnerScreenName, int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public UserList destroyUserList(int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.delete(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/lists/").append(listId).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(String listOwnerScreenName, int id, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/").append(id).append("/statuses.json").toString(), this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "per_page"), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserListJSONImpl.createPagableUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listMemberScreenName).append("/lists/memberships.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String listOwnerScreenName, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserListJSONImpl.createPagableUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/subscriptions.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public ResponseList<UserList> getAllUserLists(String screenName) throws TwitterException {
        return UserListJSONImpl.createUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/all.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public ResponseList<UserList> getAllUserLists(int userId) throws TwitterException {
        return UserListJSONImpl.createUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/all.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String listOwnerScreenName, int listId, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/members.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList addUserListMember(int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/").append(listId).append("/members.json?id=").append(userId).toString(), this.auth));
    }

    @Override
    public UserList addUserListMembers(int listId, int[] userIds) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/").append(listId).append("/members/create_all.json?user_id=").append(Twitter.toCommaSeparatedString(userIds)).toString(), this.auth));
    }

    @Override
    public UserList addUserListMembers(int listId, String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/").append(listId).append("/members/create_all.json?screen_name=").append(Twitter.toCommaSeparatedString(screenNames)).toString(), this.auth));
    }

    @Override
    public UserList deleteUserListMember(int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.delete(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/").append(listId).append("/members.json?id=").append(userId).toString(), this.auth));
    }

    @Override
    public User checkUserListMembership(String listOwnerScreenName, int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/members/").append(userId).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String listOwnerScreenName, int listId, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList subscribeUserList(String listOwnerScreenName, int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json").toString(), this.auth));
    }

    @Override
    public UserList unsubscribeUserList(String listOwnerScreenName, int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.delete(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json?id=").append(this.verifyCredentials().getId()).toString(), this.auth));
    }

    @Override
    public User checkUserListSubscription(String listOwnerScreenName, int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers/").append(userId).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/sent.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/sent.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public DirectMessage sendDirectMessage(String screenName, String text) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/new.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("text", text), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public DirectMessage sendDirectMessage(int userId, String text) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/new.json").toString(), new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("text", text), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public DirectMessage destroyDirectMessage(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/destroy/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public DirectMessage showDirectMessage(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/show/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public User createFriendship(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User createFriendship(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User createFriendship(String screenName, boolean follow) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).append("&follow=").append(follow).toString(), this.auth));
    }

    @Override
    public User createFriendship(int userId, boolean follow) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).append("&follow=").append(follow).toString(), this.auth));
    }

    @Override
    public User destroyFriendship(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User destroyFriendship(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public boolean existsFriendship(String userA, String userB) throws TwitterException {
        return -1 != this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/exists.json").toString(), HttpParameter.getParameterArray("user_a", userA, "user_b", userB), this.auth).asString().indexOf("true");
    }

    @Override
    public Relationship showFriendship(String sourceScreenName, String targetScreenName) throws TwitterException {
        return new RelationshipJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/show.json").toString(), HttpParameter.getParameterArray("source_screen_name", sourceScreenName, "target_screen_name", targetScreenName), this.auth));
    }

    @Override
    public Relationship showFriendship(int sourceId, int targetId) throws TwitterException {
        return new RelationshipJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/show.json").toString(), HttpParameter.getParameterArray("source_id", sourceId, "target_id", targetId), this.auth));
    }

    @Override
    public IDs getIncomingFriendships(long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/incoming.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getOutgoingFriendships(long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/outgoing.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return FriendshipJSONImpl.createFriendshipList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/lookup.json?screen_name=").append(StringUtil.join(screenNames)).toString(), this.auth));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(int[] ids) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return FriendshipJSONImpl.createFriendshipList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/lookup.json?user_id=").append(StringUtil.join(ids)).toString(), this.auth));
    }

    @Override
    public Relationship updateFriendship(String screenName, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new RelationshipJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/update.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", enableDeviceNotification)}, this.auth));
    }

    @Override
    public Relationship updateFriendship(int userId, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new RelationshipJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/update.json").toString(), new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", enableDeviceNotification)}, this.auth));
    }

    @Override
    public IDs getFriendsIDs() throws TwitterException {
        return this.getFriendsIDs(-1L);
    }

    @Override
    public IDs getFriendsIDs(long cursor) throws TwitterException {
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFriendsIDs(int userId) throws TwitterException {
        return this.getFriendsIDs(userId, -1L);
    }

    @Override
    public IDs getFriendsIDs(int userId, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?user_id=").append(userId).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFriendsIDs(String screenName) throws TwitterException {
        return this.getFriendsIDs(screenName, -1L);
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFollowersIDs() throws TwitterException {
        return this.getFollowersIDs(-1L);
    }

    @Override
    public IDs getFollowersIDs(long cursor) throws TwitterException {
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFollowersIDs(int userId) throws TwitterException {
        return this.getFollowersIDs(userId, -1L);
    }

    @Override
    public IDs getFollowersIDs(int userId, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?user_id=").append(userId).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFollowersIDs(String screenName) throws TwitterException {
        return this.getFollowersIDs(screenName, -1L);
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        UserJSONImpl user = new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/verify_credentials.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
        this.screenName = user.getScreenName();
        this.id = user.getId();
        return user;
    }

    @Override
    public RateLimitStatus getRateLimitStatus() throws TwitterException {
        return new RateLimitStatusJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/rate_limit_status.json").toString(), this.auth));
    }

    @Override
    public User updateProfile(String name, String email, String url, String location, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.updateProfile(name, url, location, description);
    }

    @Override
    public User updateProfile(String name, String url, String location, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(4);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        profile.add(this.INCLUDE_ENTITIES);
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile.json").toString(), profile.toArray(new HttpParameter[profile.size()]), this.auth));
    }

    @Override
    public AccountTotals getAccountTotals() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new AccountTotalsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/totals.json").toString(), this.auth));
    }

    @Override
    public AccountSettings getAccountSettings() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new AccountSettingsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/settings.json").toString(), this.auth));
    }

    @Override
    public User updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> colors = new ArrayList<HttpParameter>(6);
        this.addParameterToList(colors, "profile_background_color", profileBackgroundColor);
        this.addParameterToList(colors, "profile_text_color", profileTextColor);
        this.addParameterToList(colors, "profile_link_color", profileLinkColor);
        this.addParameterToList(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addParameterToList(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        colors.add(this.INCLUDE_ENTITIES);
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_colors.json").toString(), colors.toArray(new HttpParameter[colors.size()]), this.auth));
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (null != color) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_image.json").toString(), new HttpParameter[]{new HttpParameter("image", image), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public User updateProfileBackgroundImage(File image, boolean tile) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.checkFileValidity(image);
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_background_image.json").toString(), new HttpParameter[]{new HttpParameter("image", image), new HttpParameter("tile", tile), this.INCLUDE_ENTITIES}, this.auth));
    }

    private void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(new StringBuffer().append(image).append(" is not found.").toString()));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(new StringBuffer().append(image).append(" is not a file.").toString()));
        }
    }

    @Override
    public ResponseList<Status> getFavorites() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getFavorites(int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites.json").toString(), new HttpParameter[]{new HttpParameter("page", page), this.INCLUDE_ENTITIES}, this.auth));
    }

    @Override
    public ResponseList<Status> getFavorites(String id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getFavorites(String id, int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/").append(id).append(".json").toString(), this.mergeParameters(HttpParameter.getParameterArray("page", page), this.INCLUDE_ENTITIES), this.auth));
    }

    @Override
    public Status createFavorite(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/create/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public Status destroyFavorite(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/destroy/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public User enableNotification(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/follow.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User enableNotification(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/follow.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&userId=").append(userId).toString(), this.auth));
    }

    @Override
    public User disableNotification(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/leave.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User disableNotification(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/leave.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User createBlock(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User destroyBlock(String screen_name) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screen_name).toString(), this.auth));
    }

    @Override
    public User destroyBlock(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public boolean existsBlock(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return -1 == this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/exists.json?screen_name=").append(screenName).toString(), this.auth).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    @Override
    public boolean existsBlock(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return -1 == this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/exists.json?user_id=").append(userId).toString(), this.auth).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    @Override
    public ResponseList<User> getBlockingUsers() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString(), this.auth));
    }

    @Override
    public ResponseList<User> getBlockingUsers(int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&page=").append(page).toString(), this.auth));
    }

    @Override
    public IDs getBlockingUsersIDs() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking/ids.json").toString(), this.auth));
    }

    @Override
    public User reportSpam(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("report_spam.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User reportSpam(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("report_spam.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public List<SavedSearch> getSavedSearches() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return SavedSearchJSONImpl.createSavedSearchList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches.json").toString(), this.auth));
    }

    @Override
    public SavedSearch showSavedSearch(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/show/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public SavedSearch createSavedSearch(String query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/create.json").toString(), new HttpParameter[]{new HttpParameter("query", query)}, this.auth));
    }

    @Override
    public SavedSearch destroySavedSearch(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/destroy/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<Location> getAvailableTrends() throws TwitterException {
        return LocationJSONImpl.createLocationList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/available.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Location> getAvailableTrends(GeoLocation location) throws TwitterException {
        return LocationJSONImpl.createLocationList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/available.json").toString(), new HttpParameter[]{new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude())}, this.auth));
    }

    @Override
    public Trends getLocationTrends(int woeid) throws TwitterException {
        return new TrendsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/").append(woeid).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<Place> searchPlaces(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/search.json").toString(), query.asHttpParameterArray(), this.auth));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public SimilarPlaces getSimilarPlaces(GeoLocation location, String name, String containedWithin, String streetAddress) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        params.add(new HttpParameter("name", name));
        if (null != containedWithin) {
            params.add(new HttpParameter("contained_within", containedWithin));
        }
        if (null != streetAddress) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return SimilarPlacesImpl.createSimilarPlaces(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/similar_places.json").toString(), params.toArray(new HttpParameter[params.size()]), this.auth));
    }

    @Override
    public ResponseList<Place> getNearbyPlaces(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/nearby_places.json").toString(), query.asHttpParameterArray(), this.auth));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/reverse_geocode.json").toString(), query.asHttpParameterArray(), this.auth));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public Place getGeoDetails(String id) throws TwitterException {
        return new PlaceJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/id/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public Place createPlace(String name, String containedWithin, String token, GeoLocation location, String streetAddress) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("contained_within", containedWithin));
        params.add(new HttpParameter("token", token));
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        if (null != streetAddress) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return new PlaceJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/place.json").toString(), params.toArray(new HttpParameter[params.size()]), this.auth));
    }

    @Override
    public String getTermsOfService() throws TwitterException {
        try {
            return this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("legal/tos.json").toString(), this.auth).asJSONObject().getString("tos");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public String getPrivacyPolicy() throws TwitterException {
        try {
            return this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("legal/privacy.json").toString(), this.auth).asJSONObject().getString("privacy");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public RelatedResults getRelatedResults(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new RelatedResultsJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("related_results/show/").append(Long.toString(statusId)).append(".json").toString(), this.auth));
    }

    @Override
    public boolean test() throws TwitterException {
        return -1 != this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("help/test.json").toString()).asString().indexOf("ok");
    }

    private static String toCommaSeparatedString(String[] strArray) {
        StringBuffer buf = new StringBuffer(strArray.length * 8);
        for (String value : strArray) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(value);
        }
        return buf.toString();
    }

    private static String toCommaSeparatedString(int[] strArray) {
        StringBuffer buf = new StringBuffer(strArray.length * 8);
        for (int value : strArray) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(value);
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("Twitter{auth='").append(this.auth).append('\'').append('}').toString();
    }

    @Override
    public /* synthetic */ void setOAuthConsumer(String x0, String x1) {
        super.setOAuthConsumer(x0, x1);
    }

    @Override
    public /* synthetic */ boolean isOAuthEnabled() {
        return super.isOAuthEnabled();
    }

    @Override
    public /* synthetic */ void setOAuthAccessToken(String x0, String x1) {
        super.setOAuthAccessToken(x0, x1);
    }

    @Override
    public /* synthetic */ AccessToken getOAuthAccessToken(String x0, String x1, String x2) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1, x2);
    }

    @Override
    public /* synthetic */ AccessToken getOAuthAccessToken(String x0, String x1) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1);
    }

    @Override
    public /* synthetic */ void setOAuthAccessToken(AccessToken x0) {
        super.setOAuthAccessToken(x0);
    }

    @Override
    public /* synthetic */ AccessToken getOAuthAccessToken(RequestToken x0, String x1) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1);
    }

    @Override
    public /* synthetic */ AccessToken getOAuthAccessToken(RequestToken x0) throws TwitterException {
        return super.getOAuthAccessToken(x0);
    }

    @Override
    public /* synthetic */ AccessToken getOAuthAccessToken(String x0) throws TwitterException {
        return super.getOAuthAccessToken(x0);
    }

    @Override
    public /* synthetic */ AccessToken getOAuthAccessToken() throws TwitterException {
        return super.getOAuthAccessToken();
    }

    @Override
    public /* synthetic */ RequestToken getOAuthRequestToken(String x0) throws TwitterException {
        return super.getOAuthRequestToken(x0);
    }

    @Override
    public /* synthetic */ RequestToken getOAuthRequestToken() throws TwitterException {
        return super.getOAuthRequestToken();
    }

    @Override
    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    @Override
    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    @Override
    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    @Override
    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }

    @Override
    public /* synthetic */ void shutdown() {
        super.shutdown();
    }

    @Override
    public /* synthetic */ Configuration getConfiguration() {
        return super.getConfiguration();
    }
}

