/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.sonyericsson.eventstream.twitterplugin.utility.NetworkHelper;

import junit.framework.Assert;

import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;



@RunWith(PowerMockRunner.class)
@PrepareForTest({NetworkHelper.class, Context.class, ConnectivityManager.class, NetworkInfo.class})
public class TestNetworkHelper {

    /**
     * Test set up
     */
    @Before
    public void setUp() {

    }

    /**
     * Will test that the result is true if the network is connected
     * @throws Exception
     */
    @Test
    public void testNetworkEnabled() throws Exception {

        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        ConnectivityManager cm = PowerMock.createMock(ConnectivityManager.class);
        NetworkInfo nwInfo = PowerMock.createMock(NetworkInfo.class);

        EasyMock.expect(context.getSystemService(Context.CONNECTIVITY_SERVICE)).andReturn(cm).once();
        EasyMock.expect(cm.getActiveNetworkInfo()).andReturn(nwInfo).once();
        EasyMock.expect(nwInfo.getState()).andReturn(NetworkInfo.State.CONNECTED).once();

        PowerMock.replayAll();
        boolean result = NetworkHelper.isNetworkAvailable(context);
        Assert.assertEquals("Network should be enabled", true, result);
        PowerMock.verifyAll();
    }

    /**
     * Will test that the result is false if the network is not connected
     * @throws Exception
     */
    @Test
    public void testNetworkDisabled() throws Exception {
        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        ConnectivityManager cm = PowerMock.createMock(ConnectivityManager.class);
        NetworkInfo nwInfo = PowerMock.createMock(NetworkInfo.class);

        EasyMock.expect(context.getSystemService(Context.CONNECTIVITY_SERVICE)).andReturn(cm).once();
        EasyMock.expect(cm.getActiveNetworkInfo()).andReturn(nwInfo).once();
        EasyMock.expect(nwInfo.getState()).andReturn(NetworkInfo.State.DISCONNECTED).once();

        PowerMock.replayAll();
        boolean result = NetworkHelper.isNetworkAvailable(context);
        Assert.assertEquals("Network should not be enabled", false, result);
        PowerMock.verifyAll();
    }

}
