/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.testplugin;

import android.app.Service;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.os.IBinder;
import android.util.Config;
import android.util.Log;

import com.sonyericsson.eventstream.provider.EventStreamProvider;


/**
 * Service for handling background stuff issued by the
 * TestPlugin Activity.
 *
 * @author 23007672
 */
public class TestPluginService extends Service {

    // TestPlugin Service Action
    public static final String TESTPLUGINSERVICE_ACTION_REGISTER_PLUGIN = "com.sonyericsson.eventstream.testplugin.REGISTER_PLUGIN";

    @Override
    public IBinder onBind(Intent intent) {
        // Auto-generated method stub (do nothing)
        return null;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        int result = super.onStartCommand(intent, flags, startId);

        if(intent == null) {
            if(Config.DEBUG) {
                Log.d(TestPlugin.LOG_TAG, "TestPluginService is started with null intent.");
            }
            return -1;
        }

        if (TESTPLUGINSERVICE_ACTION_REGISTER_PLUGIN.equals(intent.getAction())) {
            registerTestPlugin();
        }
        return result;
    }

    public void registerTestPlugin() {
        Cursor cursor = null;
        try {
            // Check if we already have instance in plug-in table.
            cursor = getContentResolver().query(
                    EventStreamProvider.URIs.PLUGINS,
                    null, null, null, null);

            // Prepare plug-in data.
            ContentValues regVal = new ContentValues();

            regVal.put(EventStreamProvider.Plugin.COLUMN_FRIENDLY_NAME,
                    getResources().getString(R.string.str_plugin_name));

            regVal.put(EventStreamProvider.Plugin.COLUMN_ICON,
                    "android.resource://com.sonyericsson.eventstream.testplugin/"
                    + Integer.toString(R.drawable.icon));

            if (cursor != null && cursor.getCount() > 0) {
                // Already row in table. Lets update the plug-in data.
                getContentResolver().update(
                        EventStreamProvider.URIs.PLUGINS,
                        regVal, null, null);

                if(Config.DEBUG) {
                    Log.d(TestPlugin.LOG_TAG, "Updated data of test plug-in in Event Stream.");
                }
            } else {
                // Register ourself for the first time.
                getContentResolver().insert(
                        EventStreamProvider.URIs.PLUGINS,
                        regVal);

                Log.d(TestPlugin.LOG_TAG, "Inserted test plug-in into Event Stream.");
            }
        } catch (Exception e) {
            if(Config.DEBUG) {
                Log.d(TestPlugin.LOG_TAG, "Event Stream provider error: " + e.getMessage());
            }
       } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}
