/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.testplugin;

import com.sonyericsson.eventstream.provider.EventStreamProvider;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Config;
import android.util.Log;

/**
 * Broadcast receiver for test plug-in.
 * We must(?) listen for some intents
 * in order to fulfill the Event Stream&#x99; plug-in API.
 * @author 23007672
 */
public class EventStreamListener extends BroadcastReceiver{

    public static final String EVENTSTREAM_REGISTER_ACTION =
            "com.sonyericsson.eventstream.PLUGIN_REGISTRATION_REQUEST";

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if(Config.DEBUG) {
            Log.d(TestPlugin.LOG_TAG, "Got broadcast " + action);
        }
        if(action != null) {
            if(EVENTSTREAM_REGISTER_ACTION.equals(action)) {
                if(Config.DEBUG) {
                    Log.d(TestPlugin.LOG_TAG, "Recieved plug-in registration request from Event Stream.");
                }
                context.startService(new Intent(
                        TestPluginService.TESTPLUGINSERVICE_ACTION_REGISTER_PLUGIN));
            } else if (EventStreamProvider.REFRESH_REQUEST_INTENT.equals(action)) {
                Intent legacyWrapperRefreshRequest = new Intent(EventStreamProvider.LEGACY_REFRESH_EVENTS_INTENT);
                context.startService(legacyWrapperRefreshRequest);
            } else if (Intent.ACTION_PACKAGE_ADDED.equals(action)) {
                Intent legacyWrapperScanPluginIntent = new Intent(EventStreamProvider.LEGACY_SCAN_PLUGINS_INTENT);
                context.startService(legacyWrapperScanPluginIntent);
            } else if (EventStreamProvider.VIEW_EVENT_INTENT.equals(action)) {
                intent.setClassName("com.sonyericsson.eventstream.testplugin", "com.sonyericsson.eventstream.testplugin.ViewEventActivity");
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intent);
            }
        }
    }
}
