/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.calllogplugin;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.provider.CallLog;
import android.provider.CallLog.Calls;
import android.util.Log;

import com.sonyericsson.eventstream.calllogplugin.PluginConstants.Config;

import java.util.LinkedList;
import java.util.List;

public class CallLogAdapter {

    static Cursor getCalls(Context context, long lastIndex) {
        Cursor cursor = null;

        try {
            cursor = context.getContentResolver().query(
                    CallLog.Calls.CONTENT_URI, null,
                    Calls._ID + " > " + lastIndex + " AND " +
                    Calls.TYPE + " IN (" +
                    Calls.MISSED_TYPE + "," +
                    Calls.INCOMING_TYPE + "," +
                    Calls.OUTGOING_TYPE + ")",
                    null,null);
        } catch (SQLException e) {
            Log.w(Config.LOG_TAG, "Failed to query CallLog");
            throw new RuntimeException(e);
        }

        return cursor;
    }

    static List<Integer> getCallIds(Context context) {
        Cursor cursor = null;
        LinkedList<Integer> callIds = new LinkedList<Integer>();

        try {
            cursor = context.getContentResolver().query(
                    Calls.CONTENT_URI,
                    new String[] {Calls._ID},
                    null, null, null);
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    callIds.add(cursor.getInt(cursor.getColumnIndex(Calls._ID)));
                }
            }
        } catch (SQLException e) {
            Log.w(Config.LOG_TAG, "Failed to query CallLog");
            throw new RuntimeException(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }

        return callIds;
    }
}
