/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.StatusListener;
import twitter4j.StreamListener;
import twitter4j.TwitterStream;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.OAuthAuthorization;

public final class TwitterStreamFactory
implements Serializable {
    private static final long serialVersionUID = 8146074704915782233L;
    private final StreamListener listener;
    private final Configuration conf;

    public TwitterStreamFactory() {
        this(ConfigurationContext.getInstance());
    }

    public TwitterStreamFactory(Configuration conf) {
        this.conf = conf;
        this.listener = null;
    }

    public TwitterStreamFactory(StatusListener listener) {
        this.conf = ConfigurationContext.getInstance();
        this.listener = listener;
    }

    public TwitterStreamFactory(UserStreamListener listener) {
        this.conf = ConfigurationContext.getInstance();
        this.listener = listener;
    }

    public TwitterStreamFactory(String configTreePath) {
        this(configTreePath, (StatusListener)null);
    }

    public TwitterStreamFactory(String configTreePath, StatusListener listener) {
        this(ConfigurationContext.getInstance(configTreePath), listener);
    }

    public TwitterStreamFactory(String configTreePath, UserStreamListener listener) {
        this(ConfigurationContext.getInstance(configTreePath), listener);
    }

    public TwitterStreamFactory(Configuration conf, StatusListener listener) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
        this.listener = listener;
    }

    public TwitterStreamFactory(Configuration conf, UserStreamListener listener) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
        this.listener = listener;
    }

    public TwitterStream getInstance() {
        return this.getInstance(this.conf);
    }

    public TwitterStream getInstance(String screenName, String password) {
        return this.getInstance(this.conf, new BasicAuthorization(screenName, password));
    }

    public TwitterStream getInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret, accessToken);
        return this.getInstance(this.conf, oauth);
    }

    public TwitterStream getOAuthAuthorizedInstance(String consumerKey, String consumerSecret) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        return this.getInstance(this.conf, oauth);
    }

    public TwitterStream getOAuthAuthorizedInstance(AccessToken accessToken) {
        return this.getInstance(accessToken);
    }

    public TwitterStream getInstance(Authorization auth) {
        return this.getInstance(this.conf, auth);
    }

    private TwitterStream getInstance(Configuration conf, Authorization auth) {
        return new TwitterStream(conf, auth, this.listener);
    }

    private TwitterStream getInstance(Configuration conf) {
        return new TwitterStream(conf, AuthorizationFactory.getInstance(conf, true), this.listener);
    }
}

