/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.ClassSpecification;
import proguard.KeepClassSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.gui.MemberSpecificationsPanel;

final class ClassSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private final JTextArea commentsTextArea = new JTextArea(4, 20);
    private final JRadioButton keepClassesAndMembersRadioButton = new JRadioButton(ClassSpecificationDialog.msg("keep"));
    private final JRadioButton keepClassMembersRadioButton = new JRadioButton(ClassSpecificationDialog.msg("keepClassMembers"));
    private final JRadioButton keepClassesWithMembersRadioButton = new JRadioButton(ClassSpecificationDialog.msg("keepClassesWithMembers"));
    private final JCheckBox allowShrinkingCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowShrinking"));
    private final JCheckBox allowOptimizationCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowOptimization"));
    private final JCheckBox allowObfuscationCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowObfuscation"));
    private final JRadioButton[] publicRadioButtons;
    private final JRadioButton[] finalRadioButtons;
    private final JRadioButton[] abstractRadioButtons;
    private final JRadioButton[] enumRadioButtons;
    private final JRadioButton[] annotationRadioButtons;
    private final JRadioButton[] interfaceRadioButtons;
    private final JTextField annotationTypeTextField = new JTextField(20);
    private final JTextField classNameTextField = new JTextField(20);
    private final JTextField extendsAnnotationTypeTextField = new JTextField(20);
    private final JTextField extendsClassNameTextField = new JTextField(20);
    private final MemberSpecificationsPanel memberSpecificationsPanel;
    private int returnValue;

    public ClassSpecificationDialog(JFrame jFrame, boolean bl) {
        super(jFrame, ClassSpecificationDialog.msg("specifyClasses"), true);
        this.setResizable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 10;
        gridBagConstraints7.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridwidth = 0;
        gridBagConstraints8.anchor = 10;
        gridBagConstraints8.insets = gridBagConstraints7.insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.anchor = 16;
        gridBagConstraints9.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.anchor = 14;
        gridBagConstraints10.insets = gridBagConstraints9.insets;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridwidth = 0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.anchor = 14;
        gridBagConstraints11.insets = gridBagConstraints9.insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Border border = BorderFactory.createEtchedBorder(0);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("comments")));
        JScrollPane jScrollPane = new JScrollPane(this.commentsTextArea);
        jScrollPane.setBorder(this.classNameTextField.getBorder());
        jPanel.add((Component)ClassSpecificationDialog.tip(jScrollPane, "commentsTip"), gridBagConstraints4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.keepClassesAndMembersRadioButton);
        buttonGroup.add(this.keepClassMembersRadioButton);
        buttonGroup.add(this.keepClassesWithMembersRadioButton);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("keepTitle")));
        jPanel2.add((Component)ClassSpecificationDialog.tip(this.keepClassesAndMembersRadioButton, "keepTip"), gridBagConstraints4);
        jPanel2.add((Component)ClassSpecificationDialog.tip(this.keepClassMembersRadioButton, "keepClassMembersTip"), gridBagConstraints4);
        jPanel2.add((Component)ClassSpecificationDialog.tip(this.keepClassesWithMembersRadioButton, "keepClassesWithMembersTip"), gridBagConstraints4);
        final JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("allowTitle")));
        jPanel3.add((Component)ClassSpecificationDialog.tip(this.allowShrinkingCheckBox, "allowShrinkingTip"), gridBagConstraints4);
        jPanel3.add((Component)ClassSpecificationDialog.tip(this.allowOptimizationCheckBox, "allowOptimizationTip"), gridBagConstraints4);
        jPanel3.add((Component)ClassSpecificationDialog.tip(this.allowObfuscationCheckBox, "allowObfuscationTip"), gridBagConstraints4);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("access")));
        jPanel4.add(Box.createGlue(), gridBagConstraints7);
        jPanel4.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("required")), "requiredTip"), gridBagConstraints7);
        jPanel4.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("not")), "notTip"), gridBagConstraints7);
        jPanel4.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("dontCare")), "dontCareTip"), gridBagConstraints7);
        jPanel4.add(Box.createGlue(), gridBagConstraints4);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", jPanel4);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", jPanel4);
        this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", jPanel4);
        this.enumRadioButtons = this.addRadioButtonTriplet("Enum", jPanel4);
        this.annotationRadioButtons = this.addRadioButtonTriplet("Annotation", jPanel4);
        this.interfaceRadioButtons = this.addRadioButtonTriplet("Interface", jPanel4);
        final JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("annotation")));
        jPanel5.add((Component)ClassSpecificationDialog.tip(this.annotationTypeTextField, "classNameTip"), gridBagConstraints4);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("class")));
        jPanel6.add((Component)ClassSpecificationDialog.tip(this.classNameTextField, "classNameTip"), gridBagConstraints4);
        final JPanel jPanel7 = new JPanel(gridBagLayout);
        jPanel7.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("extendsImplementsAnnotation")));
        jPanel7.add((Component)ClassSpecificationDialog.tip(this.extendsAnnotationTypeTextField, "classNameTip"), gridBagConstraints4);
        JPanel jPanel8 = new JPanel(gridBagLayout);
        jPanel8.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("extendsImplementsClass")));
        jPanel8.add((Component)ClassSpecificationDialog.tip(this.extendsClassNameTextField, "classNameTip"), gridBagConstraints4);
        this.memberSpecificationsPanel = new MemberSpecificationsPanel(this, bl);
        this.memberSpecificationsPanel.setBorder(BorderFactory.createTitledBorder(border, ClassSpecificationDialog.msg("classMembers")));
        final JButton jButton = new JButton(ClassSpecificationDialog.msg("basic"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !jPanel3.isVisible();
                jPanel3.setVisible(bl);
                jPanel5.setVisible(bl);
                jPanel7.setVisible(bl);
                jButton.setText(ClassSpecificationDialog.msg(bl ? "basic" : "advanced"));
                ClassSpecificationDialog.this.pack();
            }
        });
        jButton.doClick();
        JButton jButton2 = new JButton(ClassSpecificationDialog.msg("ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecificationDialog.this.returnValue = 0;
                ClassSpecificationDialog.this.hide();
            }
        });
        JButton jButton3 = new JButton(ClassSpecificationDialog.msg("cancel"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecificationDialog.this.hide();
            }
        });
        JPanel jPanel9 = new JPanel(gridBagLayout);
        jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel, "commentsTip"), gridBagConstraints5);
        if (bl) {
            jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel2, "keepTitleTip"), gridBagConstraints5);
            jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel3, "allowTitleTip"), gridBagConstraints5);
        }
        jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel4, "accessTip"), gridBagConstraints5);
        jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel5, "annotationTip"), gridBagConstraints5);
        jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel6, "classTip"), gridBagConstraints5);
        jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel7, "extendsImplementsAnnotationTip"), gridBagConstraints5);
        jPanel9.add((Component)ClassSpecificationDialog.tip(jPanel8, "extendsImplementsClassTip"), gridBagConstraints5);
        jPanel9.add((Component)ClassSpecificationDialog.tip(this.memberSpecificationsPanel, "classMembersTip"), gridBagConstraints6);
        jPanel9.add((Component)ClassSpecificationDialog.tip(jButton, "advancedTip"), gridBagConstraints9);
        jPanel9.add((Component)jButton2, gridBagConstraints10);
        jPanel9.add((Component)jButton3, gridBagConstraints11);
        this.getContentPane().add(new JScrollPane(jPanel9));
    }

    private JRadioButton[] addRadioButtonTriplet(String string, JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.0;
        JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        JRadioButton jRadioButton3 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        jPanel.add((Component)jRadioButton, gridBagConstraints2);
        jPanel.add((Component)jRadioButton2, gridBagConstraints2);
        jPanel.add((Component)jRadioButton3, gridBagConstraints2);
        jPanel.add(Box.createGlue(), gridBagConstraints3);
        return new JRadioButton[]{jRadioButton, jRadioButton2, jRadioButton3};
    }

    public void setKeepSpecification(KeepClassSpecification keepClassSpecification) {
        boolean bl = keepClassSpecification.markClasses;
        boolean bl2 = keepClassSpecification.markConditionally;
        boolean bl3 = keepClassSpecification.allowShrinking;
        boolean bl4 = keepClassSpecification.allowOptimization;
        boolean bl5 = keepClassSpecification.allowObfuscation;
        JRadioButton jRadioButton = bl2 ? this.keepClassesWithMembersRadioButton : (bl ? this.keepClassesAndMembersRadioButton : this.keepClassMembersRadioButton);
        jRadioButton.setSelected(true);
        this.allowShrinkingCheckBox.setSelected(bl3);
        this.allowOptimizationCheckBox.setSelected(bl4);
        this.allowObfuscationCheckBox.setSelected(bl5);
        this.setClassSpecification(keepClassSpecification);
    }

    public void setClassSpecification(ClassSpecification classSpecification) {
        String string = classSpecification.comments;
        String string2 = classSpecification.annotationType;
        String string3 = classSpecification.className;
        String string4 = classSpecification.extendsAnnotationType;
        String string5 = classSpecification.extendsClassName;
        List list = classSpecification.fieldSpecifications;
        List list2 = classSpecification.methodSpecifications;
        this.commentsTextArea.setText(string == null ? "" : string);
        this.setClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 16384, this.enumRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 8192, this.annotationRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.annotationTypeTextField.setText(string2 == null ? "" : ClassUtil.externalType(string2));
        this.classNameTextField.setText(string3 == null ? "*" : ClassUtil.externalClassName(string3));
        this.extendsAnnotationTypeTextField.setText(string4 == null ? "" : ClassUtil.externalType(string4));
        this.extendsClassNameTextField.setText(string5 == null ? "" : ClassUtil.externalClassName(string5));
        this.memberSpecificationsPanel.setMemberSpecifications(list, list2);
    }

    public KeepClassSpecification getKeepSpecification() {
        boolean bl = !this.keepClassMembersRadioButton.isSelected();
        boolean bl2 = this.keepClassesWithMembersRadioButton.isSelected();
        boolean bl3 = this.allowShrinkingCheckBox.isSelected();
        boolean bl4 = this.allowOptimizationCheckBox.isSelected();
        boolean bl5 = this.allowObfuscationCheckBox.isSelected();
        return new KeepClassSpecification(bl, bl2, bl3, bl4, bl5, this.getClassSpecification());
    }

    public ClassSpecification getClassSpecification() {
        String string = this.commentsTextArea.getText();
        String string2 = this.annotationTypeTextField.getText();
        String string3 = this.classNameTextField.getText();
        String string4 = this.extendsAnnotationTypeTextField.getText();
        String string5 = this.extendsClassNameTextField.getText();
        ClassSpecification classSpecification = new ClassSpecification(string.equals("") ? null : string, 0, 0, string2.equals("") ? null : ClassUtil.internalType(string2), string3.equals("") || string3.equals("*") ? null : ClassUtil.internalClassName(string3), string4.equals("") ? null : ClassUtil.internalType(string4), string5.equals("") ? null : ClassUtil.internalClassName(string5));
        this.getClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 16384, this.enumRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 8192, this.annotationRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        classSpecification.fieldSpecifications = this.memberSpecificationsPanel.getMemberSpecifications(true);
        classSpecification.methodSpecifications = this.memberSpecificationsPanel.getMemberSpecifications(false);
        return classSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private void setClassSpecificationRadioButtons(ClassSpecification classSpecification, int n, JRadioButton[] jRadioButtonArray) {
        int n2 = (classSpecification.requiredSetAccessFlags & n) != 0 ? 0 : ((classSpecification.requiredUnsetAccessFlags & n) != 0 ? 1 : 2);
        jRadioButtonArray[n2].setSelected(true);
    }

    private void getClassSpecificationRadioButtons(ClassSpecification classSpecification, int n, JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray[0].isSelected()) {
            classSpecification.requiredSetAccessFlags |= n;
        } else if (jRadioButtonArray[1].isSelected()) {
            classSpecification.requiredUnsetAccessFlags |= n;
        }
    }

    private static JComponent tip(JComponent jComponent, String string) {
        jComponent.setToolTipText(ClassSpecificationDialog.msg(string));
        return jComponent;
    }

    private static String msg(String string) {
        return GUIResources.getMessage(string);
    }
}

