/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.utility;

import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_EVENT_PROVIDER_URI;
import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_FRIEND_PROVIDER_URI;
import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_PLUGIN_PROVIDER_URI;
import static com.sonyericsson.eventstream.twitterplugin.PluginConstants.EVENTSTREAM_SOURCE_PROVIDER_URI;

import android.content.ContentResolver;
import android.database.Cursor;
public class EventStreamHelper {

    /**
     * Test to see if we are registered in EventStream or not.
     *
     * @return true if registered, false otherwise or contentResolver object is
     *         null
     */
    public static boolean isPluginRegistered(ContentResolver contentResolver) {
        if (contentResolver == null) {
            return false;
        }

        Cursor cursor = null;
        boolean registered = false;
        try {
            cursor = contentResolver.query(EVENTSTREAM_PLUGIN_PROVIDER_URI, null, null, null, null);
            if (cursor != null && cursor.getCount() == 1) {
                registered = true;
            }
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return registered;
    }

    /**
     * Clear everything in EventStream.
     */
    public static void clearAll(ContentResolver contentResolver) {
        if (contentResolver == null) {
            return;
        }

        contentResolver.delete(EVENTSTREAM_PLUGIN_PROVIDER_URI, null, null);
        contentResolver.delete(EVENTSTREAM_SOURCE_PROVIDER_URI, null, null);
        contentResolver.delete(EVENTSTREAM_FRIEND_PROVIDER_URI, null, null);
        contentResolver.delete(EVENTSTREAM_EVENT_PROVIDER_URI, null, null);
    }

    /**
     * Clear data only in EventStream, but keep registration.
     */
    public static void clearData(ContentResolver contentResolver) {
        if (contentResolver == null) {
            return;
        }

        contentResolver.delete(EVENTSTREAM_EVENT_PROVIDER_URI, null, null);
        contentResolver.delete(EVENTSTREAM_FRIEND_PROVIDER_URI, null, null);
    }
}
