/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.simpleui.activity;

import com.sonyericsson.simpleui.R;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;

import android.app.ListActivity;
import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.view.View;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;

public final class SimpleUiSettingsActivity extends ListActivity {

    // TODO: add again if we want to support Automatic sync in the Simple UI
//    private static final String CONFIG_STORE = "config_store";
//
//    private static final String AUTOMATIC_REFRESH_CONFIG = "simpleui.refresh.automatic";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.settings_view);

        Cursor pluginCursor = getContentResolver().query(EventStreamContentProvider.Uris.SOURCE_URI,
                null,
                null,
                null,
                null);
        ListAdapter adapter = new SimpleCursorAdapter(this,
                android.R.layout.simple_list_item_multiple_choice,
                pluginCursor,
                new String[]{EventStreamContentProvider.SourceColumns.NAME},
                new int[] {android.R.id.text1});

        ((SimpleCursorAdapter)adapter).setViewBinder(new SettingsViewBinder());

        setListAdapter(adapter);

        // TODO: add again if we want to support Automatic sync in the Simple UI
//        SharedPreferences preferences = getSharedPreferences(CONFIG_STORE, Context.MODE_PRIVATE);
//        ToggleButton refreshToggle = ((ToggleButton)findViewById(R.id.simpleui_refresh_toggle));
//        refreshToggle.setOnCheckedChangeListener(this);
//        refreshToggle.setChecked(preferences.getBoolean(AUTOMATIC_REFRESH_CONFIG, false));
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        CheckedTextView checkedTextView = (CheckedTextView)v.findViewById(android.R.id.text1);
        boolean checked = checkedTextView.isChecked();
        if (checked) {
            boolean updated = setSourceEnabled(position, false);
            if (updated) {
                checkedTextView.setChecked(false);
            }
        } else {
            boolean updated = setSourceEnabled(position, true);
            if (updated) {
                checkedTextView.setChecked(true);
            }
        }
    }

    // TODO: add again if we want to support Automatic sync in the Simple UI
//    /**
//     * Store the refresh setting.
//     * @param buttonView
//     * @param isChecked
//     */
//    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//        SharedPreferences preferences = getSharedPreferences(CONFIG_STORE, Context.MODE_PRIVATE);
//        preferences.edit().putBoolean(AUTOMATIC_REFRESH_CONFIG, isChecked).commit();
//    }

    private boolean setSourceEnabled(int position, boolean enabled) {
        Cursor c = ((SimpleCursorAdapter)getListAdapter()).getCursor();
        c.moveToPosition(position);
        int serviceId = c.getInt(c.getColumnIndex(EventStreamContentProvider.ID_COLUMN));
        ContentValues sourceValues = new ContentValues();
        sourceValues.put(EventStreamContentProvider.ID_COLUMN, serviceId);
        if (enabled) {
            sourceValues.put(EventStreamContentProvider.SourceColumns.ENABLED, 1);
        } else {
            sourceValues.put(EventStreamContentProvider.SourceColumns.ENABLED, 0);
        }
        int updated = getContentResolver().update(EventStreamContentProvider.Uris.SOURCE_URI, sourceValues,
                EventStreamContentProvider.ID_COLUMN + " = ? ", new String[]{String.valueOf(serviceId)});
        return (updated == 1);
    }

    private class SettingsViewBinder implements SimpleCursorAdapter.ViewBinder {

        public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
            int enabled = cursor.getInt(cursor.getColumnIndexOrThrow(
                            EventStreamContentProvider.SourceColumns.ENABLED));
            ((CheckedTextView)view).setChecked(enabled == 1);
            return false;
        }
    }
}