/* drivers/media/video/msm/seix006_cam_devdrv_table.c
 *
 * Copyright (C) 2010 Sony Ericsson Mobile Communications AB.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */

#include <linux/types.h>
#include "seix006_cam_devdrv_table.h"

/****************************************************************
vf_resolution_800x480 :: View Finder resolution 800x480
****************************************************************/
const struct reg_entry seix006_vf_resolution_800x480[] = {
	{0x0022, 0x2003, REG_BITS_16},
	{0x0028, 0xE001, REG_BITS_16},
	{0x0026, 0x2003, REG_BITS_16},
};

int32_t sizeof_seix006_vf_resolution_800x480 =
    sizeof(seix006_vf_resolution_800x480);

/****************************************************************
vf_resolution_640x480 :: View Finder resolution 640x480 
****************************************************************/
const struct reg_entry seix006_vf_resolution_640x480[] = {
	{0x0022, 0x8002, REG_BITS_16},
	{0x0028, 0xE001, REG_BITS_16},
	{0x0026, 0x8002, REG_BITS_16},
};

int32_t sizeof_seix006_vf_resolution_640x480 =
    sizeof(seix006_vf_resolution_640x480);

/****************************************************************
vf_resolution_320x240 :: View Finder resolution 320x240 
****************************************************************/
const struct reg_entry seix006_vf_resolution_320x240[] = {
	{0x0022, 0x4001, REG_BITS_16},
	{0x0028, 0xF000, REG_BITS_16},
	{0x0026, 0x4001, REG_BITS_16},
};

int32_t sizeof_seix006_vf_resolution_320x240 =
    sizeof(seix006_vf_resolution_320x240);

/****************************************************************
Mode_Monitor :: Mode change Monitor mode 
****************************************************************/
const struct reg_entry seix006_mode_monitor[] = {
	{0x0011, 0x00, REG_BITS_8},
};

int32_t sizeof_seix006_mode_monitor = sizeof(seix006_mode_monitor);

/****************************************************************
Mode_HalfRelease :: Mode Half Release mode 
****************************************************************/
const struct reg_entry seix006_mode_half_release[] = {
	{0x6D77, 0x02, REG_BITS_8},
	{0x0011, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_mode_half_release = sizeof(seix006_mode_half_release);

/****************************************************************
Mode_HalfRelease :: Mode Half Release Auto Scene Start 
****************************************************************/
const struct reg_entry seix006_hr_auto_start[] = {
	{0x6A01, 0x77, REG_BITS_8},
	{0x6A02, 0x6D, REG_BITS_8},
	{0x6A03, 0x02, REG_BITS_8},
	{0x6A04, 0x11, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x01, REG_BITS_8},
	{0x6A07, 0x03, REG_BITS_8},
	{0x6A08, 0x01, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x00, REG_BITS_8},
	{0x6A0B, 0x00, REG_BITS_8},
	{0x6A31, 0x14, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0x69, REG_BITS_8},
	{0x6A34, 0x0E, REG_BITS_8},
	{0x6A35, 0x00, REG_BITS_8},
	{0x6A36, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_hr_auto_start = sizeof(seix006_hr_auto_start);

/****************************************************************
Mode_HalfRelease :: Mode Half Release auto scene reset
****************************************************************/
const struct reg_entry seix006_hr_auto_reset[] = {
	{0x6A01, 0x03, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x01, REG_BITS_8},
	{0x6A04, 0x00, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A31, 0x14, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0x5E, REG_BITS_8},
	{0x6A34, 0x0A, REG_BITS_8},
	{0x6A35, 0x00, REG_BITS_8},
	{0x6A36, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_hr_auto_reset = sizeof(seix006_hr_auto_reset);

/****************************************************************
Mode_Movie :: Mode Movie mode 
****************************************************************/
const struct reg_entry seix006_mode_movie[]={
    {0x0011, 0x03, REG_BITS_8}, // Set MOVIE Mode
};
int32_t sizeof_seix006_mode_movie = sizeof(seix006_mode_movie);

/****************************************************************
Mode_HalfRelease :: Mode Half Release mode in Scene Twilight
****************************************************************/
const struct reg_entry seix006_hr_twilight[] = {
	{0x6A01, 0x77, REG_BITS_8},
	{0x6A02, 0x6D, REG_BITS_8},
	{0x6A03, 0x02, REG_BITS_8},
	{0x6A04, 0x11, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x01, REG_BITS_8},
	{0x6A07, 0x4E, REG_BITS_8},
	{0x6A08, 0x48, REG_BITS_8},
	{0x6A09, 0x09, REG_BITS_8},
	{0x6A0A, 0x00, REG_BITS_8},
	{0x6A0B, 0x00, REG_BITS_8},
	{0x6A31, 0x1E, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xFD, REG_BITS_8},
	{0x6A34, 0x03, REG_BITS_8},
	{0x6A35, 0x20, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0xF6, REG_BITS_8},
	{0x6A38, 0x0B, REG_BITS_8},
	{0x6A39, 0x00, REG_BITS_8},
	{0x6A3A, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_hr_twilight = sizeof(seix006_hr_twilight);

/****************************************************************
Mode_HalfRelease :: Mode Half Release mode reset
****************************************************************/
const struct reg_entry seix006_hr_reset[] = {
	{0x6A01, 0x4E, REG_BITS_8},
	{0x6A02, 0x48, REG_BITS_8},
	{0x6A03, 0x08, REG_BITS_8},
	{0x6A04, 0x00, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A31, 0x1E, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xAB, REG_BITS_8},
	{0x6A34, 0x0F, REG_BITS_8},
	{0x6A35, 0x20, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0xFD, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x00, REG_BITS_8},
	{0x6A3A, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_hr_reset = sizeof(seix006_hr_reset);

/****************************************************************
Mode_HalfRelease :: Mode Half Release with LED
****************************************************************/
const struct reg_entry seix006_hr_LED[] = {
	{0x6A01, 0x77, REG_BITS_8},
	{0x6A02, 0x6D, REG_BITS_8},
	{0x6A03, 0x02, REG_BITS_8},
	{0x6A04, 0x3E, REG_BITS_8},
	{0x6A05, 0x46, REG_BITS_8},
	{0x6A06, 0x50, REG_BITS_8},
	{0x6A07, 0x3F, REG_BITS_8},
	{0x6A08, 0x46, REG_BITS_8},
	{0x6A09, 0x4E, REG_BITS_8},
	{0x6A0A, 0x40, REG_BITS_8},
	{0x6A0B, 0x46, REG_BITS_8},
	{0x6A0C, 0x4C, REG_BITS_8},
	{0x6A0D, 0x41, REG_BITS_8},
	{0x6A0E, 0x46, REG_BITS_8},
	{0x6A0F, 0x4A, REG_BITS_8},
	{0x6A10, 0x42, REG_BITS_8},
	{0x6A11, 0x46, REG_BITS_8},
	{0x6A12, 0x49, REG_BITS_8},
	{0x6A13, 0x43, REG_BITS_8},
	{0x6A14, 0x46, REG_BITS_8},
	{0x6A15, 0x48, REG_BITS_8},
	{0x6A16, 0x44, REG_BITS_8},
	{0x6A17, 0x46, REG_BITS_8},
	{0x6A18, 0x46, REG_BITS_8},
	{0x6A19, 0x45, REG_BITS_8},
	{0x6A1A, 0x46, REG_BITS_8},
	{0x6A1B, 0x45, REG_BITS_8},
	{0x6A1C, 0x48, REG_BITS_8},
	{0x6A1D, 0x46, REG_BITS_8},
	{0x6A1E, 0x44, REG_BITS_8},
	{0x6A1F, 0x4C, REG_BITS_8},
	{0x6A20, 0x46, REG_BITS_8},
	{0x6A21, 0x22, REG_BITS_8},
	{0x6A22, 0x97, REG_BITS_8},
	{0x6A23, 0x46, REG_BITS_8},
	{0x6A24, 0x42, REG_BITS_8},
	{0x6A25, 0x9C, REG_BITS_8},
	{0x6A26, 0x46, REG_BITS_8},
	{0x6A27, 0x21, REG_BITS_8},
	{0x6A28, 0x11, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x01, REG_BITS_8},
	{0x6A2B, 0x03, REG_BITS_8},
	{0x6A2C, 0x01, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x8D, REG_BITS_8},
	{0x6A32, 0x46, REG_BITS_8},
	{0x6A33, 0x4F, REG_BITS_8},
	{0x6A34, 0x4D, REG_BITS_8},
	{0x6A35, 0x8F, REG_BITS_8},
	{0x6A36, 0x46, REG_BITS_8},
	{0x6A37, 0x4B, REG_BITS_8},
	{0x6A38, 0x49, REG_BITS_8},
	{0x6A39, 0x91, REG_BITS_8},
	{0x6A3A, 0x46, REG_BITS_8},
	{0x6A3B, 0x47, REG_BITS_8},
	{0x6A3C, 0x46, REG_BITS_8},
	{0x6A3D, 0x93, REG_BITS_8},
	{0x6A3E, 0x46, REG_BITS_8},
	{0x6A3F, 0x45, REG_BITS_8},
	{0x6A40, 0x43, REG_BITS_8},
	{0x6A41, 0x46, REG_BITS_8},
	{0x6A42, 0x46, REG_BITS_8},
	{0x6A43, 0x45, REG_BITS_8},
	{0x6A44, 0x45, REG_BITS_8},
	{0x6A45, 0x95, REG_BITS_8},
	{0x6A46, 0x46, REG_BITS_8},
	{0x6A47, 0x42, REG_BITS_8},
	{0x6A48, 0x42, REG_BITS_8},
	{0x6A49, 0x14, REG_BITS_8},
	{0x6A4A, 0x40, REG_BITS_8},
	{0x6A4B, 0x69, REG_BITS_8},
	{0x6A4C, 0x0E, REG_BITS_8},
	{0x6A4D, 0x00, REG_BITS_8},
	{0x6A4E, 0x00, REG_BITS_8},
	{0x6A4F, 0x00, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x00, REG_BITS_8},
	{0x6A52, 0x00, REG_BITS_8},
	{0x6A53, 0x00, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x00, REG_BITS_8},
	{0x6A56, 0x00, REG_BITS_8},
	{0x6A57, 0x00, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x00, REG_BITS_8},
	{0x6A5A, 0x00, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x00, REG_BITS_8},
	{0x6A5E, 0x00, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_hr_LED = sizeof(seix006_hr_LED);

/****************************************************************
Mode_HalfRelease :: Mode Half Release LED Reset
****************************************************************/
const struct reg_entry seix006_hr_LED_reset[] = {
	{0x6A01, 0x3E, REG_BITS_8},
	{0x6A02, 0x46, REG_BITS_8},
	{0x6A03, 0x4E, REG_BITS_8},
	{0x6A04, 0x3F, REG_BITS_8},
	{0x6A05, 0x46, REG_BITS_8},
	{0x6A06, 0x4A, REG_BITS_8},
	{0x6A07, 0x40, REG_BITS_8},
	{0x6A08, 0x46, REG_BITS_8},
	{0x6A09, 0x45, REG_BITS_8},
	{0x6A0A, 0x41, REG_BITS_8},
	{0x6A0B, 0x46, REG_BITS_8},
	{0x6A0C, 0x40, REG_BITS_8},
	{0x6A0D, 0x42, REG_BITS_8},
	{0x6A0E, 0x46, REG_BITS_8},
	{0x6A0F, 0x3D, REG_BITS_8},
	{0x6A10, 0x43, REG_BITS_8},
	{0x6A11, 0x46, REG_BITS_8},
	{0x6A12, 0x3A, REG_BITS_8},
	{0x6A13, 0x44, REG_BITS_8},
	{0x6A14, 0x46, REG_BITS_8},
	{0x6A15, 0x38, REG_BITS_8},
	{0x6A16, 0x45, REG_BITS_8},
	{0x6A17, 0x46, REG_BITS_8},
	{0x6A18, 0x36, REG_BITS_8},
	{0x6A19, 0x48, REG_BITS_8},
	{0x6A1A, 0x46, REG_BITS_8},
	{0x6A1B, 0x39, REG_BITS_8},
	{0x6A1C, 0x4C, REG_BITS_8},
	{0x6A1D, 0x46, REG_BITS_8},
	{0x6A1E, 0x1F, REG_BITS_8},
	{0x6A1F, 0x97, REG_BITS_8},
	{0x6A20, 0x46, REG_BITS_8},
	{0x6A21, 0x32, REG_BITS_8},
	{0x6A22, 0x9C, REG_BITS_8},
	{0x6A23, 0x46, REG_BITS_8},
	{0x6A24, 0x1E, REG_BITS_8},
	{0x6A25, 0x03, REG_BITS_8},
	{0x6A26, 0x01, REG_BITS_8},
	{0x6A27, 0x01, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x8D, REG_BITS_8},
	{0x6A32, 0x46, REG_BITS_8},
	{0x6A33, 0x4C, REG_BITS_8},
	{0x6A34, 0x47, REG_BITS_8},
	{0x6A35, 0x8F, REG_BITS_8},
	{0x6A36, 0x46, REG_BITS_8},
	{0x6A37, 0x43, REG_BITS_8},
	{0x6A38, 0x3F, REG_BITS_8},
	{0x6A39, 0x91, REG_BITS_8},
	{0x6A3A, 0x46, REG_BITS_8},
	{0x6A3B, 0x3B, REG_BITS_8},
	{0x6A3C, 0x39, REG_BITS_8},
	{0x6A3D, 0x93, REG_BITS_8},
	{0x6A3E, 0x46, REG_BITS_8},
	{0x6A3F, 0x37, REG_BITS_8},
	{0x6A40, 0x35, REG_BITS_8},
	{0x6A41, 0x46, REG_BITS_8},
	{0x6A42, 0x46, REG_BITS_8},
	{0x6A43, 0x3B, REG_BITS_8},
	{0x6A44, 0x3A, REG_BITS_8},
	{0x6A45, 0x95, REG_BITS_8},
	{0x6A46, 0x46, REG_BITS_8},
	{0x6A47, 0x34, REG_BITS_8},
	{0x6A48, 0x33, REG_BITS_8},
	{0x6A49, 0x14, REG_BITS_8},
	{0x6A4A, 0x40, REG_BITS_8},
	{0x6A4B, 0x5E, REG_BITS_8},
	{0x6A4C, 0x0A, REG_BITS_8},
	{0x6A4D, 0x00, REG_BITS_8},
	{0x6A4E, 0x00, REG_BITS_8},
	{0x6A4F, 0x00, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x00, REG_BITS_8},
	{0x6A52, 0x00, REG_BITS_8},
	{0x6A53, 0x00, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x00, REG_BITS_8},
	{0x6A56, 0x00, REG_BITS_8},
	{0x6A57, 0x00, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x00, REG_BITS_8},
	{0x6A5A, 0x00, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x00, REG_BITS_8},
	{0x6A5E, 0x00, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_hr_LED_reset = sizeof(seix006_hr_LED_reset);

/****************************************************************
Mode_Capture :: Prepare mode capture
****************************************************************/
const struct reg_entry seix006_prepare_mode_capture[] = {
	{0x0039, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_prepare_mode_capture =
    sizeof(seix006_prepare_mode_capture);

/****************************************************************
Mode_Capture :: Mode change Capture mode 
****************************************************************/
const struct reg_entry seix006_mode_capture[] = {
	{0x001D, 0x1B, REG_BITS_8},
	{0x6A01, 0x11, REG_BITS_8},
	{0x6A02, 0x00, REG_BITS_8},
	{0x6A03, 0x02, REG_BITS_8},
	{0x6A04, 0x10, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x02, REG_BITS_8},
	{0x6A07, 0x39, REG_BITS_8},
	{0x6A08, 0x00, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x00, REG_BITS_8},
	{0x6A0B, 0x00, REG_BITS_8},
	{0x6A31, 0x00, REG_BITS_8},
	{0x6A32, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_mode_capture = sizeof(seix006_mode_capture);

/****************************************************************
Mode_Capture :: Mode change YUV Capture mode
****************************************************************/
const struct reg_entry seix006_mode_capture_YUV[] = {
	{0x001D, 0x00, REG_BITS_8},
	{0x0011, 0x02, REG_BITS_8},
};

int32_t sizeof_seix006_mode_capture_YUV = sizeof(seix006_mode_capture_YUV);

/****************************************************************
Mode_Capture :: Mode change RGB Capture mode
****************************************************************/
const struct reg_entry seix006_mode_capture_RGB[] = {
	{0x001D, 0x04, REG_BITS_8},
	{0x0011, 0x02, REG_BITS_8},
};

int32_t sizeof_seix006_mode_capture_RGB = sizeof(seix006_mode_capture_RGB);
/****************************************************************
Test Pattern :: Set test pattern on 
****************************************************************/
const struct reg_entry seix006_test_pattern_on[] = {
	{0x3200, 0x04, REG_BITS_8},
	{0x3202, 0x01, REG_BITS_8},
	{0x2800, 0x01000204, REG_BITS_32},
};

int32_t sizeof_seix006_test_pattern_on = sizeof(seix006_test_pattern_on);

/****************************************************************
Test Pattern :: Set test pattern off 
****************************************************************/
const struct reg_entry seix006_test_pattern_off[] = {
	{0x3200, 0x00, REG_BITS_8},
	{0x3202, 0x00, REG_BITS_8},
};

int32_t sizeof_seix006_test_pattern_off = sizeof(seix006_test_pattern_off);

/****************************************************************
Snapshot_resolution_640x480 :: Snapshot resolution VGA 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_640x480[]={
	{0x0024, 0x8002, REG_BITS_16}, // Set VGA snapshot (640x480)
	{0x002A, 0xE001, REG_BITS_16}, // Set VGA snapshot (640x480)
};
int32_t sizeof_seix006_snapshot_resolution_640x480 = sizeof(seix006_snapshot_resolution_640x480);

/****************************************************************
Snapshot_resolution_640x480 :: Snapshot resolution VGA
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_800x480[]={
	{0x0024, 0x2003, REG_BITS_16}, // Set VGA snapshot (800x480)
	{0x002A, 0xE001, REG_BITS_16}, // Set VGA snapshot (800x480)
};
int32_t sizeof_seix006_snapshot_resolution_800x480 = sizeof(seix006_snapshot_resolution_800x480);

/****************************************************************
Snapshot_resolution_1280x960 :: Snapshot resolution 1MP 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1280x960[]={
	{0x0024, 0x0005, REG_BITS_16}, // Set VGA snapshot (1280x960)
	{0x002A, 0xC003, REG_BITS_16}, // Set VGA snapshot (1280x960)
};
int32_t sizeof_seix006_snapshot_resolution_1280x960 = sizeof(seix006_snapshot_resolution_1280x960);

/****************************************************************
Snapshot_resolution_1632x1224 :: Snapshot resolution 2MP 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1632x1224[]={
	{0x0024, 0x6006, REG_BITS_16}, // Set VGA snapshot (1632x1224)
	{0x002A, 0xC804, REG_BITS_16}, // Set VGA snapshot (1632x1224)
};
int32_t sizeof_seix006_snapshot_resolution_1632x1224 = sizeof(seix006_snapshot_resolution_1632x1224);


/****************************************************************
Snapshot_resolution_176x144 :: Snapshot resolution QCIF 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_176x144[]={
	{0x0024, 0xB000, REG_BITS_16}, // Set QCIF snapshot (176x144)
	{0x002A, 0x9000, REG_BITS_16}, // Set QCIF snapshot (176x144)
};
int32_t sizeof_seix006_snapshot_resolution_176x144 = sizeof(seix006_snapshot_resolution_176x144);

/****************************************************************
Snapshot_resolution_320x240 :: Snapshot resolution QVGA 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_320x240[]={
	{0x0024, 0x4001, REG_BITS_16}, // Set QVGA snapshot (320x240)
	{0x002A, 0xF000, REG_BITS_16}, // Set QVGA snapshot (320x240)
};
int32_t sizeof_seix006_snapshot_resolution_320x240 = sizeof(seix006_snapshot_resolution_320x240);

/****************************************************************
Snapshot_resolution_352x288:: Snapshot resolution CIF 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_352x288[]={
	{0x0024, 0x6001, REG_BITS_16}, // Set CIF snapshot (352x288)
	{0x002A, 0x2001, REG_BITS_16}, // Set CIF snapshot (352x288)
};
int32_t sizeof_seix006_snapshot_resolution_352x288 = sizeof(seix006_snapshot_resolution_352x288);

/****************************************************************
Snapshot_resolution_800x600 :: Snapshot resolution 1MP SVGA 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_800x600[]={
	{0x0024, 0x2003, REG_BITS_16}, // Set 1MP SVGA snapshot (800x600)
	{0x002A, 0x5802, REG_BITS_16}, // Set 1MP SVGA snapshot (800x600)
};
int32_t sizeof_seix006_snapshot_resolution_800x600 = sizeof(seix006_snapshot_resolution_800x600);

/****************************************************************
Snapshot_resolution_1024x768 :: Snapshot resolution 1MP XGA
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1024x768[]={
	{0x0024, 0x0004, REG_BITS_16}, // Set 1MP XGA snapshot (1024x768)
	{0x002A, 0x0003, REG_BITS_16}, // Set 1MP XGA snapshot (1024x768)
};
int32_t sizeof_seix006_snapshot_resolution_1024x768 = sizeof(seix006_snapshot_resolution_1024x768);

/****************************************************************
Snapshot_resolution_1280x720 :: Snapshot resolution HD720 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1280x720[]={
	{0x0024, 0x0005, REG_BITS_16}, // Set HD720 snapshot (1280x720)
	{0x002A, 0xD002, REG_BITS_16}, // Set HD720 snapshot (1280x720)
};
int32_t sizeof_seix006_snapshot_resolution_1280x720 = sizeof(seix006_snapshot_resolution_1280x720);


/****************************************************************
Snapshot_resolution_1280x768 :: Snapshot resolution WXGA 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1280x768[]={
	{0x0024, 0x0005, REG_BITS_16}, // Set WXGA snapshot (1280x768)
	{0x002A, 0x0003, REG_BITS_16}, // Set WXGA snapshot (1280x768)
};
int32_t sizeof_seix006_snapshot_resolution_1280x768 = sizeof(seix006_snapshot_resolution_1280x768);

/****************************************************************
Snapshot_resolution_1600x1200:: Snapshot resolution 2MP 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1600x1200[]={
	{0x0024, 0x4006, REG_BITS_16}, // Set 2MP snapshot (1600x1200)
	{0x002A, 0xB004, REG_BITS_16}, // Set 2MP snapshot (1600x1200)
};
int32_t sizeof_seix006_snapshot_resolution_1600x1200 = sizeof(seix006_snapshot_resolution_1600x1200);

/****************************************************************
Snapshot_resolution_1920x1080 :: Snapshot resolution HD1080 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_1920x1080[]={
	{0x0024, 0x8007, REG_BITS_16}, // Set HD1080 snapshot (1920x1080)
	{0x002A, 0x3804, REG_BITS_16}, // Set HD1080 snapshot (1920x1080)
};
int32_t sizeof_seix006_snapshot_resolution_1920x1080 = sizeof(seix006_snapshot_resolution_1920x1080);

/****************************************************************
Snapshot_resolution_2048x1536 :: Snapshot resolution 3MP 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_2048x1536[]={
	{0x0024, 0x0008, REG_BITS_16}, // Set 3MP snapshot (2048x1536)
	{0x002A, 0x0006, REG_BITS_16}, // Set 3MP snapshot (2048x1536)
};
int32_t sizeof_seix006_snapshot_resolution_2048x1536 = sizeof(seix006_snapshot_resolution_2048x1536);

/****************************************************************
Snapshot_resolution_2592x1944 :: Snapshot resolution 5MP 
****************************************************************/
const struct reg_entry seix006_snapshot_resolution_2592x1944[]={
	{0x0024, 0x200A, REG_BITS_16}, // Set 5MP snapshot (2592x1944)
	{0x002A, 0x9807, REG_BITS_16}, // Set 5MP snapshot (2592x1944)
};
int32_t sizeof_seix006_snapshot_resolution_2592x1944 = sizeof(seix006_snapshot_resolution_2592x1944);


//// Thumbnail dimensions are taken from QualcommHardware.cpp
/****************************************************************
 Set thumbnail dimensions. QCIF 
****************************************************************/
const struct reg_entry seix006_thumbnail_size_QCIF []={
    {0x021A ,0xB000, REG_BITS_16}, // YUV interleaved thumbnail size 176
    {0x021C ,0x9000, REG_BITS_16}  // YUV interleaved thumbnail size 144
};
int32_t sizeof_seix006_thumbnail_size_QCIF = sizeof(seix006_thumbnail_size_QCIF);

/****************************************************************
    Set thumbnail dimensions. WVGA.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_WVGA[]={
	{0x021A ,0x2003, REG_BITS_16}, // YUV interleaved thumbnail size 800
	{0x021C ,0xE001, REG_BITS_16}  // YUV interleaved thumbnail size 480
};
int32_t sizeof_seix006_thumbnail_size_WVGA = sizeof(seix006_thumbnail_size_WVGA);

/****************************************************************
    Set thumbnail dimensions. VGA.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_VGA[]={
    {0x021A ,0x8002, REG_BITS_16}, // YUV interleaved thumbnail size 640
    {0x021C ,0xE001, REG_BITS_16}  // YUV interleaved thumbnail size 480
};
int32_t sizeof_seix006_thumbnail_size_VGA = sizeof(seix006_thumbnail_size_VGA);

/****************************************************************
    Set thumbnail dimensions. QVGA.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_QVGA[]={
    {0x021A ,0x4001, REG_BITS_16}, // YUV interleaved thumbnail size 320
    {0x021C ,0xF000, REG_BITS_16} // YUV interleaved thumbnail size 240
};
int32_t sizeof_seix006_thumbnail_size_QVGA = sizeof(seix006_thumbnail_size_QVGA);

/****************************************************************
    Set thumbnail dimensions. WQVGA.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_WQVGA[]={
    {0x021A ,0x9001, REG_BITS_16}, // YUV interleaved thumbnail size 400
    {0x021C ,0xF000, REG_BITS_16} // YUV interleaved thumbnail size 240
};
int32_t sizeof_seix006_thumbnail_size_WQVGA = sizeof(seix006_thumbnail_size_WQVGA);

/****************************************************************
    Set thumbnail dimensions. 512x384.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_512x384[]={
    {0x021A ,0x0002, REG_BITS_16}, // YUV interleaved thumbnail size 512
    {0x021C ,0x8001, REG_BITS_16} // YUV interleaved thumbnail size 384
};
int32_t sizeof_seix006_thumbnail_size_512x384 = sizeof(seix006_thumbnail_size_512x384);

/****************************************************************
    Set thumbnail dimensions. 480x288.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_480x288[]={
    {0x021A ,0xE001, REG_BITS_16}, // YUV interleaved thumbnail size 480
    {0x021C ,0x2001, REG_BITS_16} // YUV interleaved thumbnail size 288
};
int32_t sizeof_seix006_thumbnail_size_480x288 = sizeof(seix006_thumbnail_size_480x288);
/****************************************************************
    Set thumbnail dimensions. 432x288.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_432x288[]={
    {0x021A ,0xB001, REG_BITS_16}, // YUV interleaved thumbnail size 432
    {0x021C ,0x2001, REG_BITS_16} // YUV interleaved thumbnail size 288
};
int32_t sizeof_seix006_thumbnail_size_432x288 = sizeof(seix006_thumbnail_size_432x288);
/****************************************************************
    Set thumbnail dimensions. 512x288.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_512x288[]={
    {0x021A ,0x0002, REG_BITS_16}, // YUV interleaved thumbnail size 512
    {0x021C ,0x2001, REG_BITS_16} // YUV interleaved thumbnail size 288
};
int32_t sizeof_seix006_thumbnail_size_512x288 = sizeof(seix006_thumbnail_size_512x288);
/****************************************************************
    Set thumbnail dimensions. 352x288.
****************************************************************/
const struct reg_entry seix006_thumbnail_size_352x288[]={
    {0x021A ,0x6001, REG_BITS_16}, // YUV interleaved thumbnail size 352
    {0x021C ,0x2001, REG_BITS_16} // YUV interleaved thumbnail size 288
};
int32_t sizeof_seix006_thumbnail_size_352x288 = sizeof(seix006_thumbnail_size_352x288);


/****************************************************************
frame rate fixed 30 fps
****************************************************************/
const struct reg_entry seix006_framerate_30[] = {
	// FPSTYPE_MONI
	{0x0383, 0x02, REG_BITS_8},
	// FPSTYPE_CAP
	{0x0384, 0x02, REG_BITS_8},
	// FPSTYPE_MOVIE
	{0x0385, 0x02, REG_BITS_8},
};

int32_t sizeof_seix006_framerate_30 = sizeof(seix006_framerate_30);

/****************************************************************
frame rate fixed 15 fps
****************************************************************/
const struct reg_entry seix006_framerate_15[] = {
	// FPSTYPE_MONI
	{0x0383, 0x03, REG_BITS_8},
	// FPSTYPE_CAP
	{0x0384, 0x03, REG_BITS_8},
	// FPSTYPE_MOVIE
	{0x0385, 0x03, REG_BITS_8},
};

int32_t sizeof_seix006_framerate_15 = sizeof(seix006_framerate_15);

/****************************************************************
frame rate variable
****************************************************************/
const struct reg_entry seix006_framerate_variable[] = {
	{0x0103, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_framerate_variable = sizeof(seix006_framerate_variable);

/****************************************************************
frame rate fixed
****************************************************************/
const struct reg_entry seix006_framerate_fixed[] = {
	{0x0103, 0x0, REG_BITS_8},
};

int32_t sizeof_seix006_framerate_fixed = sizeof(seix006_framerate_fixed);

/****************************************************************
scene normal
****************************************************************/
const struct reg_entry seix006_GEN_scene_normal[] = {
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x00, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x20, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0xD3, REG_BITS_8},
	{0x6A0E, 0x01, REG_BITS_8},
	{0x6A0F, 0x04, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC6, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x40, REG_BITS_8},
	{0x6A3C, 0x05, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0xFD, REG_BITS_8},
	{0x6A40, 0x03, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x5F, REG_BITS_8},
	{0x6A44, 0x02, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xCB, REG_BITS_8},
	{0x6A48, 0x02, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x00, REG_BITS_8},
	{0x6A4C, 0x21, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_normal =
    sizeof(seix006_GEN_scene_normal);


/****************************************************************
scene macro
****************************************************************/
const struct reg_entry seix006_GEN_scene_macro[] = {
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x00, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x20, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0xD3, REG_BITS_8},
	{0x6A0E, 0x01, REG_BITS_8},
	{0x6A0F, 0x00, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC6, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x40, REG_BITS_8},
	{0x6A3C, 0x05, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0xFD, REG_BITS_8},
	{0x6A40, 0x03, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x5F, REG_BITS_8},
	{0x6A44, 0x02, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xCB, REG_BITS_8},
	{0x6A48, 0x02, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x00, REG_BITS_8},
	{0x6A4C, 0x21, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_macro =
    sizeof(seix006_GEN_scene_macro);



/****************************************************************
scene sports
****************************************************************/
const struct reg_entry seix006_GEN_scene_sports[] = {
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x04, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x20, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0xD7, REG_BITS_8},
	{0x6A0E, 0x01, REG_BITS_8},
	{0x6A0F, 0x04, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0x91, REG_BITS_8},
	{0x6A34, 0x19, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x5E, REG_BITS_8},
	{0x6A38, 0x0A, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x3F, REG_BITS_8},
	{0x6A3C, 0x0C, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0x00, REG_BITS_8},
	{0x6A40, 0x00, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x00, REG_BITS_8},
	{0x6A44, 0x00, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0x00, REG_BITS_8},
	{0x6A48, 0x00, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x00, REG_BITS_8},
	{0x6A4C, 0x21, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_sports =
    sizeof(seix006_GEN_scene_sports);



/****************************************************************
scene twilight landscape
****************************************************************/
const struct reg_entry seix006_GEN_scene_twilight[] = {
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x05, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x20, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0xD8, REG_BITS_8},
	{0x6A0E, 0x01, REG_BITS_8},
	{0x6A0F, 0x04, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC7, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x00, REG_BITS_8},
	{0x6A3C, 0x00, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0x00, REG_BITS_8},
	{0x6A40, 0x00, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0xAB, REG_BITS_8},
	{0x6A44, 0x0F, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xFD, REG_BITS_8},
	{0x6A48, 0x03, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x5C, REG_BITS_8},
	{0x6A4C, 0x17, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_twilight =
    sizeof(seix006_GEN_scene_twilight);

/****************************************************************
scene beach_and_snow
****************************************************************/
const struct reg_entry seix006_GEN_scene_beach_and_snow[] = {
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x03, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x20, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x02, REG_BITS_8},
	{0x6A0D, 0x00, REG_BITS_8},
	{0x6A0E, 0x00, REG_BITS_8},
	{0x6A0F, 0x00, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC6, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x40, REG_BITS_8},
	{0x6A3C, 0x05, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0xFD, REG_BITS_8},
	{0x6A40, 0x03, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x5F, REG_BITS_8},
	{0x6A44, 0x02, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xCB, REG_BITS_8},
	{0x6A48, 0x02, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x9D, REG_BITS_8},
	{0x6A4C, 0x2E, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_beach_and_snow =
    sizeof(seix006_GEN_scene_beach_and_snow);

/****************************************************************
scene landscape
****************************************************************/
const struct reg_entry seix006_GEN_scene_landscape[] = {	
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x01, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x20, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x02, REG_BITS_8},
	{0x6A0D, 0x00, REG_BITS_8},
	{0x6A0E, 0x00, REG_BITS_8},
	{0x6A0F, 0x00, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC6, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x40, REG_BITS_8},
	{0x6A3C, 0x05, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0xFD, REG_BITS_8},
	{0x6A40, 0x03, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x5F, REG_BITS_8},
	{0x6A44, 0x02, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xCB, REG_BITS_8},
	{0x6A48, 0x02, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x00, REG_BITS_8},
	{0x6A4C, 0x21, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_landscape =
    sizeof(seix006_GEN_scene_landscape);

/****************************************************************
scene portrait
****************************************************************/
const struct reg_entry seix006_GEN_scene_portrait[] = {	
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x02, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x0D, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0x00, REG_BITS_8},
	{0x6A0E, 0x00, REG_BITS_8},
	{0x6A0F, 0x00, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC6, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x40, REG_BITS_8},
	{0x6A3C, 0x05, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0xFD, REG_BITS_8},
	{0x6A40, 0x03, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x5F, REG_BITS_8},
	{0x6A44, 0x02, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xCB, REG_BITS_8},
	{0x6A48, 0x02, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x00, REG_BITS_8},
	{0x6A4C, 0x21, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x20, REG_BITS_8},
	{0x6A5C, 0x03, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_portrait =
    sizeof(seix006_GEN_scene_portrait);

/****************************************************************
scene twilight_portrait
****************************************************************/
const struct reg_entry seix006_GEN_scene_twilight_portrait[] = {	
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x07, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x0D, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0x00, REG_BITS_8},
	{0x6A0E, 0x00, REG_BITS_8},
	{0x6A0F, 0x00, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0xC7, REG_BITS_8},
	{0x6A34, 0x29, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x00, REG_BITS_8},
	{0x6A3C, 0x00, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0x00, REG_BITS_8},
	{0x6A40, 0x00, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0xAB, REG_BITS_8},
	{0x6A44, 0x0F, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xFD, REG_BITS_8},
	{0x6A48, 0x03, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x5C, REG_BITS_8},
	{0x6A4C, 0x17, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x24, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x0B, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x0A, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x20, REG_BITS_8},
	{0x6A5C, 0x03, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_twilight_portrait =
    sizeof(seix006_GEN_scene_twilight_portrait);
    
/****************************************************************
scene document
****************************************************************/
const struct reg_entry seix006_GEN_scene_document[] = {		
	{0x6A01, 0x00, REG_BITS_8},
	{0x6A02, 0x01, REG_BITS_8},
	{0x6A03, 0x06, REG_BITS_8},
	{0x6A04, 0x62, REG_BITS_8},
	{0x6A05, 0x00, REG_BITS_8},
	{0x6A06, 0x30, REG_BITS_8},
	{0x6A07, 0x5D, REG_BITS_8},
	{0x6A08, 0x4E, REG_BITS_8},
	{0x6A09, 0x00, REG_BITS_8},
	{0x6A0A, 0x0B, REG_BITS_8},
	{0x6A0B, 0x4E, REG_BITS_8},
	{0x6A0C, 0x01, REG_BITS_8},
	{0x6A0D, 0x00, REG_BITS_8},
	{0x6A0E, 0x00, REG_BITS_8},
	{0x6A0F, 0x00, REG_BITS_8},
	{0x6A10, 0x00, REG_BITS_8},
	{0x6A11, 0x00, REG_BITS_8},
	{0x6A12, 0x00, REG_BITS_8},
	{0x6A13, 0x00, REG_BITS_8},
	{0x6A14, 0x00, REG_BITS_8},
	{0x6A15, 0x00, REG_BITS_8},
	{0x6A16, 0x00, REG_BITS_8},
	{0x6A17, 0x00, REG_BITS_8},
	{0x6A18, 0x00, REG_BITS_8},
	{0x6A19, 0x00, REG_BITS_8},
	{0x6A1A, 0x00, REG_BITS_8},
	{0x6A1B, 0x00, REG_BITS_8},
	{0x6A1C, 0x00, REG_BITS_8},
	{0x6A1D, 0x00, REG_BITS_8},
	{0x6A1E, 0x00, REG_BITS_8},
	{0x6A1F, 0x00, REG_BITS_8},
	{0x6A20, 0x00, REG_BITS_8},
	{0x6A21, 0x00, REG_BITS_8},
	{0x6A22, 0x00, REG_BITS_8},
	{0x6A23, 0x00, REG_BITS_8},
	{0x6A24, 0x00, REG_BITS_8},
	{0x6A25, 0x00, REG_BITS_8},
	{0x6A26, 0x00, REG_BITS_8},
	{0x6A27, 0x00, REG_BITS_8},
	{0x6A28, 0x00, REG_BITS_8},
	{0x6A29, 0x00, REG_BITS_8},
	{0x6A2A, 0x00, REG_BITS_8},
	{0x6A2B, 0x00, REG_BITS_8},
	{0x6A2C, 0x00, REG_BITS_8},
	{0x6A2D, 0x00, REG_BITS_8},
	{0x6A2E, 0x00, REG_BITS_8},
	{0x6A2F, 0x00, REG_BITS_8},
	{0x6A30, 0x00, REG_BITS_8},
	{0x6A31, 0x16, REG_BITS_8},
	{0x6A32, 0x40, REG_BITS_8},
	{0x6A33, 0x97, REG_BITS_8},
	{0x6A34, 0x25, REG_BITS_8},
	{0x6A35, 0x18, REG_BITS_8},
	{0x6A36, 0x40, REG_BITS_8},
	{0x6A37, 0x97, REG_BITS_8},
	{0x6A38, 0x03, REG_BITS_8},
	{0x6A39, 0x1A, REG_BITS_8},
	{0x6A3A, 0x40, REG_BITS_8},
	{0x6A3B, 0x2D, REG_BITS_8},
	{0x6A3C, 0x04, REG_BITS_8},
	{0x6A3D, 0x1C, REG_BITS_8},
	{0x6A3E, 0x40, REG_BITS_8},
	{0x6A3F, 0xFD, REG_BITS_8},
	{0x6A40, 0x03, REG_BITS_8},
	{0x6A41, 0x1E, REG_BITS_8},
	{0x6A42, 0x40, REG_BITS_8},
	{0x6A43, 0x00, REG_BITS_8},
	{0x6A44, 0x04, REG_BITS_8},
	{0x6A45, 0x20, REG_BITS_8},
	{0x6A46, 0x40, REG_BITS_8},
	{0x6A47, 0xC8, REG_BITS_8},
	{0x6A48, 0x06, REG_BITS_8},
	{0x6A49, 0xAE, REG_BITS_8},
	{0x6A4A, 0x52, REG_BITS_8},
	{0x6A4B, 0x00, REG_BITS_8},
	{0x6A4C, 0x21, REG_BITS_8},
	{0x6A4D, 0x88, REG_BITS_8},
	{0x6A4E, 0x58, REG_BITS_8},
	{0x6A4F, 0x25, REG_BITS_8},
	{0x6A50, 0x00, REG_BITS_8},
	{0x6A51, 0x8A, REG_BITS_8},
	{0x6A52, 0x58, REG_BITS_8},
	{0x6A53, 0x10, REG_BITS_8},
	{0x6A54, 0x00, REG_BITS_8},
	{0x6A55, 0x8C, REG_BITS_8},
	{0x6A56, 0x58, REG_BITS_8},
	{0x6A57, 0x10, REG_BITS_8},
	{0x6A58, 0x00, REG_BITS_8},
	{0x6A59, 0x5E, REG_BITS_8},
	{0x6A5A, 0x4E, REG_BITS_8},
	{0x6A5B, 0x00, REG_BITS_8},
	{0x6A5C, 0x00, REG_BITS_8},
	{0x6A5D, 0x80, REG_BITS_8},
	{0x6A5E, 0x4E, REG_BITS_8},
	{0x6A5F, 0x00, REG_BITS_8},
	{0x6A60, 0x00, REG_BITS_8},
	{0x6A61, 0x00, REG_BITS_8},
	{0x6A62, 0x00, REG_BITS_8},
	{0x6A63, 0x00, REG_BITS_8},
	{0x6A64, 0x00, REG_BITS_8},
	{0x6A65, 0x00, REG_BITS_8},
	{0x6A66, 0x00, REG_BITS_8},
	{0x6A67, 0x00, REG_BITS_8},
	{0x6A68, 0x00, REG_BITS_8},
	{0x6A69, 0x00, REG_BITS_8},
	{0x6A6A, 0x00, REG_BITS_8},
	{0x6A6B, 0x00, REG_BITS_8},
	{0x6A6C, 0x00, REG_BITS_8},
	{0x6A6D, 0x00, REG_BITS_8},
	{0x6A6E, 0x00, REG_BITS_8},
	{0x6A6F, 0x00, REG_BITS_8},
	{0x6A70, 0x00, REG_BITS_8},
	{0x6A00, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_scene_document =
    sizeof(seix006_GEN_scene_document);
                
const struct reg_entry seix006_INTCLR[] = {
	{0x00FC, 0x1F, REG_BITS_8},
};

int32_t sizeof_seix006_INTCLR = sizeof(seix006_INTCLR);

const struct reg_entry seix006_MONI_REFRESH_F[] = {
	{0x0012, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_MONI_REFRESH_F = sizeof(seix006_MONI_REFRESH_F);

const struct reg_entry seix006_GEN_period_1_ES1[] = {
	{0x0009, 0x15, REG_BITS_8},
	{0x0007, 0x00, REG_BITS_8},
	{0x000B, 0x00, REG_BITS_8},
	{0x000F, 0xE6, REG_BITS_8},
	{0x001C, 0x00, REG_BITS_8},
	{0x001E, 0x00, REG_BITS_8},
	{0x001F, 0x00, REG_BITS_8},
	{0x0021, 0x00, REG_BITS_8},
	{0x0022, 0x8002, REG_BITS_16}, /* 640 */
	{0x0024, 0x200A, REG_BITS_16},
	{0x0026, 0x8002, REG_BITS_16},
	{0x0028, 0xE001, REG_BITS_16},
	{0x002A, 0x9807, REG_BITS_16},
	{0x002C, 0xE001, REG_BITS_16},
	{0x0038, 0x0C, REG_BITS_8},
	{0x003A, 0x0002, REG_BITS_16},
	{0x00FA, 0x1F, REG_BITS_8},
	{0x021E, 0x6911, REG_BITS_16},
	{0x0220, 0x0911, REG_BITS_16},
	{0x02A4, 0x0000, REG_BITS_16},
	{0x02B9, 0x50, REG_BITS_8},
	{0x02C4, 0x1000, REG_BITS_16},
	{0x02C7, 0x00, REG_BITS_8},
	{0x02CD, 0xAA, REG_BITS_8},
	{0x02E2, 0x00, REG_BITS_8},
	{0x034A, 0x01, REG_BITS_8},
	{0x034B, 0x01, REG_BITS_8},
	{0x034C, 0x01, REG_BITS_8},
	{0x034D, 0x01, REG_BITS_8},
	{0x0351, 0x40, REG_BITS_8},
	{0x0352, 0xB80B, REG_BITS_16},
	{0x0354, 0xB80B, REG_BITS_16},
	{0x0354, 0xB80B, REG_BITS_16},
	{0x0356, 0xB80B, REG_BITS_16},
	{0x0358, 0x0000, REG_BITS_16},
	{0x035A, 0x0000, REG_BITS_16},
	{0x035C, 0x0000, REG_BITS_16},
	{0x035E, 0x01, REG_BITS_8},
	{0x0360, 0x01, REG_BITS_8},
	{0x0361, 0x00, REG_BITS_8},
	{0x0362, 0x06, REG_BITS_8},
	{0x0364, 0x2700, REG_BITS_16},
	{0x0366, 0x0000, REG_BITS_16},
	{0x0380, 0x01, REG_BITS_8},
	{0x0382, 0x01, REG_BITS_8},
	{0x0383, 0x02, REG_BITS_8},
	{0x0385, 0x02, REG_BITS_8},
	{0x4C86, 0x01, REG_BITS_8},
	{0xB000, 0xADAD1855, REG_BITS_32},
	{0xB004, 0x552C2801, REG_BITS_32},
	{0xB008, 0x6DF10AFC, REG_BITS_32},
	{0xB00C, 0x55A80D01, REG_BITS_32},
	{0xB010, 0x6FF150F9, REG_BITS_32},
	{0xB014, 0x55581501, REG_BITS_32},
	{0xB018, 0x6EF17CFD, REG_BITS_32},
	{0xB01C, 0x5528CD00, REG_BITS_32},
	{0xB020, 0x73F1AEF9, REG_BITS_32},
	{0xB024, 0x558C4400, REG_BITS_32},
	{0xB028, 0x7BF10CFE, REG_BITS_32},
	{0xB02C, 0x55482601, REG_BITS_32},
	{0xB030, 0x6DF13BFD, REG_BITS_32},
	{0xB034, 0x552CD800, REG_BITS_32},
	{0xB038, 0x72F154FC, REG_BITS_32},
	{0xB03C, 0x552C1401, REG_BITS_32},
	{0xB040, 0x6EF172FE, REG_BITS_32},
	{0xB044, 0x92F656FE, REG_BITS_32},
	{0xB048, 0x92F6F6FB, REG_BITS_32},
	{0xB04C, 0x00F066F8, REG_BITS_32},
	{0xB050, 0x90F6C4FE, REG_BITS_32},
	{0xB054, 0x09480A49, REG_BITS_32},
	{0xB058, 0x00890988, REG_BITS_32},
	{0xB05C, 0x884201D1, REG_BITS_32},
	{0xB060, 0x91F6B0FA, REG_BITS_32},
	{0xB064, 0x07480223, REG_BITS_32},
	{0xB068, 0x80781840, REG_BITS_32},
	{0xB06C, 0x022803D1, REG_BITS_32},
	{0xB070, 0x0120A873, REG_BITS_32},
	{0xB074, 0x91F6ABFA, REG_BITS_32},
	{0xB078, 0x91F6A8FA, REG_BITS_32},
	{0xB07C, 0x883E1800, REG_BITS_32},
	{0xB080, 0xA43E1800, REG_BITS_32},
	{0xB084, 0x0C2A1800, REG_BITS_32},
	{0xB088, 0x02B484F6, REG_BITS_32},
	{0xB08C, 0x11FA0448, REG_BITS_32},
	{0xB090, 0x0449407A, REG_BITS_32},
	{0xB094, 0x487102BC, REG_BITS_32},
	{0xB098, 0x01200870, REG_BITS_32},
	{0xB09C, 0x8CF646FE, REG_BITS_32},
	{0xB0A0, 0xBC311800, REG_BITS_32},
	{0xB0A4, 0xA4391800, REG_BITS_32},
	{0xB0A8, 0xC00F8AF6, REG_BITS_32},
	{0xB0AC, 0xE3FF8CF6, REG_BITS_32},
	{0xB0B0, 0xF1FB8CF6, REG_BITS_32},
	{0xB0B4, 0x43FE8CF6, REG_BITS_32},
	{0xB0B8, 0xCFFD8BF6, REG_BITS_32},
	{0xB0BC, 0x2BFC84F6, REG_BITS_32},
	{0xB0C0, 0xEEF90449, REG_BITS_32},
	{0xB0C4, 0x09780029, REG_BITS_32},
	{0xB0C8, 0x01D192F6, REG_BITS_32},
	{0xB0CC, 0xEDFC92F6, REG_BITS_32},
	{0xB0D0, 0xBDFAC046, REG_BITS_32},
	{0xB0D4, 0x24291800, REG_BITS_32},
	{0xB0D8, 0x14D10D48, REG_BITS_32},
	{0xB0DC, 0x00688030, REG_BITS_32},
	{0xB0E0, 0x4068400C, REG_BITS_32},
	{0xB0E4, 0x10D3A327, REG_BITS_32},
	{0xB0E8, 0x3F010626, REG_BITS_32},
	{0xB0EC, 0x6322211C, REG_BITS_32},
	{0xB0F0, 0x069880F6, REG_BITS_32},
	{0xB0F4, 0x27F90CCD, REG_BITS_32},
	{0xB0F8, 0x80F658F8, REG_BITS_32},
	{0xB0FC, 0x034BC018, REG_BITS_32},
	{0xB100, 0x8DF6E3FB, REG_BITS_32},
	{0xB104, 0x8DF6ABFB, REG_BITS_32},
	{0xB108, 0x8DF6A4FB, REG_BITS_32},
	{0xB10C, 0xCAF5FFFF, REG_BITS_32},
	{0xB110, 0x201B1800, REG_BITS_32},
	{0xB114, 0x00F042F8, REG_BITS_32},
	{0xB118, 0x91F6A3F9, REG_BITS_32},
	{0xB11C, 0x80B51948, REG_BITS_32},
	{0xB120, 0xC11D7931, REG_BITS_32},
	{0xB124, 0xCA791849, REG_BITS_32},
	{0xB128, 0x022A16D1, REG_BITS_32},
	{0xB12C, 0x174A1278, REG_BITS_32},
	{0xB130, 0x002A12D1, REG_BITS_32},
	{0xB134, 0x164A1278, REG_BITS_32},
	{0xB138, 0x012A0ED1, REG_BITS_32},
	{0xB13C, 0xC81DFF30, REG_BITS_32},
	{0xB140, 0x2A301449, REG_BITS_32},
	{0xB144, 0x82720978, REG_BITS_32},
	{0xB148, 0x0131C172, REG_BITS_32},
	{0xB14C, 0x91F646FB, REG_BITS_32},
	{0xB150, 0x91F672FB, REG_BITS_32},
	{0xB154, 0x90F65CFC, REG_BITS_32},
	{0xB158, 0x80BD6030, REG_BITS_32},
	{0xB15C, 0x00890E4F, REG_BITS_32},
	{0xB160, 0x002809D1, REG_BITS_32},
	{0xB164, 0x92F6AEFE, REG_BITS_32},
	{0xB168, 0x012192F6, REG_BITS_32},
	{0xB16C, 0xC3FD0720, REG_BITS_32},
	{0xB170, 0xB87192F6, REG_BITS_32},
	{0xB174, 0xB3FCEFE7, REG_BITS_32},
	{0xB178, 0x90F644FE, REG_BITS_32},
	{0xB17C, 0x0920B871, REG_BITS_32},
	{0xB180, 0xEAE70000, REG_BITS_32},
	{0xB184, 0x9C281800, REG_BITS_32},
	{0xB188, 0x08381800, REG_BITS_32},
	{0xB18C, 0x20421800, REG_BITS_32},
	{0xB190, 0xB43E1800, REG_BITS_32},
	{0xB194, 0xA83E1800, REG_BITS_32},
	{0xB198, 0x78391800, REG_BITS_32},
	{0xB19C, 0xF8B50027, REG_BITS_32},
	{0xB1A0, 0x0F4C0022, REG_BITS_32},
	{0xB1A4, 0x10480092, REG_BITS_32},
	{0xB1A8, 0x0268381C, REG_BITS_32},
	{0xB1AC, 0x0D4B0F49, REG_BITS_32},
	{0xB1B0, 0x90F62AFF, REG_BITS_32},
	{0xB1B4, 0x0E49E579, REG_BITS_32},
	{0xB1B8, 0x00208E7D, REG_BITS_32},
	{0xB1BC, 0x8875E071, REG_BITS_32},
	{0xB1C0, 0x0D480122, REG_BITS_32},
	{0xB1C4, 0x00920268, REG_BITS_32},
	{0xB1C8, 0x381C0C49, REG_BITS_32},
	{0xB1CC, 0x094B90F6, REG_BITS_32},
	{0xB1D0, 0x1BFF0749, REG_BITS_32},
	{0xB1D4, 0x8E75E571, REG_BITS_32},
	{0xB1D8, 0x01370A2F, REG_BITS_32},
	{0xB1DC, 0xE1DBF8BD, REG_BITS_32},
	{0xB1E0, 0xDC281800, REG_BITS_32},
	{0xB1E4, 0xB8411800, REG_BITS_32},
	{0xB1E8, 0x24421800, REG_BITS_32},
	{0xB1EC, 0xE83E1800, REG_BITS_32},
	{0xB1F0, 0x9C281800, REG_BITS_32},
	{0xB1F4, 0xC4411800, REG_BITS_32},
	{0xB1F8, 0x28421800, REG_BITS_32},
	{0xB1FC, 0x50401800, REG_BITS_32},
	/* white balance auto */
	{0x0102, 0x20, REG_BITS_8},
	{0x0107, 0x10, REG_BITS_8},
	{0x010C, 0x20, REG_BITS_8},
	{0x0111, 0x10, REG_BITS_8},
	{0x0116, 0x20, REG_BITS_8},
	{0x011B, 0x20, REG_BITS_8},
	{0x0120, 0x20, REG_BITS_8},
	{0x0125, 0x20, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_period_1_ES1 = sizeof(seix006_GEN_period_1_ES1);

const struct reg_entry seix006_GEN_period_1_ES2[] = {
	{0x000B, 0x00, REG_BITS_8},
	{0x0022, 0x8002, REG_BITS_16}, /* 640 */
	{0x0028, 0xE001, REG_BITS_16},
	{0x0205, 0x46, REG_BITS_8}, /* Quality 70 */
	{0x0206, 0x4B, REG_BITS_8}, /* Quality 75 */
	{0x0207, 0x50, REG_BITS_8}, /* Quality 80 */
	{0x0038, 0x0C, REG_BITS_8},
	{0x02CD, 0xA8, REG_BITS_8}, /* Different power setting for Zeus */
	{0x0026, 0x8002, REG_BITS_16}, /* 640 */
	{0x002C, 0xE001, REG_BITS_16},
	{0x00FA, 0x1F, REG_BITS_8},
	{0x02B9, 0x10, REG_BITS_8},
	{0x02C4, 0x1000, REG_BITS_16},
	{0x0364, 0x2700, REG_BITS_16},
	{0x0386, 0x01, REG_BITS_8},
	{0x442A, 0x7B0B, REG_BITS_16},
	{0x442C, 0x4618, REG_BITS_16},
	{0x442E, 0x7B0B, REG_BITS_16},
	{0x4430, 0x4618, REG_BITS_16},
	{0x444A, 0x1879, REG_BITS_16},
	{0x444C, 0x007D, REG_BITS_16},
	{0x4685, 0x65, REG_BITS_8},
	{0x4686, 0x65, REG_BITS_8},
	{0x4687, 0x65, REG_BITS_8},
	{0x4688, 0x63, REG_BITS_8},
	{0x469D, 0x0F, REG_BITS_8},
	{0x46B3, 0x3C, REG_BITS_8},
	{0x46B4, 0x35, REG_BITS_8},
	{0x46B5, 0x30, REG_BITS_8},
	{0x46EC, 0x1A, REG_BITS_8},
	{0x46ED, 0x13, REG_BITS_8},
	{0x4704, 0x47, REG_BITS_8},
	{0x4705, 0x43, REG_BITS_8},
	{0x4706, 0x41, REG_BITS_8},
	{0x472A, 0x4B, REG_BITS_8},
	{0x472B, 0x47, REG_BITS_8},
	{0x473C, 0x19, REG_BITS_8},
	{0x473D, 0x14, REG_BITS_8},
	{0x473E, 0x16, REG_BITS_8},
	{0x473F, 0x14, REG_BITS_8},
	{0x0009, 0x15, REG_BITS_8},
	/* white balance auto */
	{0x0102, 0x20, REG_BITS_8},
	{0x0107, 0x10, REG_BITS_8},
	{0x010C, 0x20, REG_BITS_8},
	{0x0111, 0x10, REG_BITS_8},
	{0x0116, 0x20, REG_BITS_8},
	{0x011B, 0x20, REG_BITS_8},
	{0x0120, 0x20, REG_BITS_8},
	{0x0125, 0x20, REG_BITS_8},
};

int32_t sizeof_seix006_GEN_period_1_ES2 = sizeof(seix006_GEN_period_1_ES2);

const struct reg_entry seix006_vendor_1_period_2_ES1[] = {
	{0x4A00, 0x1001, REG_BITS_16},
	{0x4A02, 0x0000, REG_BITS_16},
	{0x4A04, 0x8611, REG_BITS_16},
	{0x4A06, 0x960E, REG_BITS_16},
	{0x4A08, 0x4A01, REG_BITS_16},
	{0x4A0A, 0x5C02, REG_BITS_16},
	{0x4A0C, 0x00, REG_BITS_8},
	{0x4A0D, 0x00, REG_BITS_8},
	{0x4A0E, 0x05, REG_BITS_8},
	{0x4A10, 0x6F0A, REG_BITS_16},
	{0x4A12, 0x981C, REG_BITS_16},
	{0x4A14, 0x00, REG_BITS_8},
	{0x4A15, 0x00, REG_BITS_8},
	{0x4A16, 0x0000, REG_BITS_16},
	{0x4A18, 0x0000, REG_BITS_16},
	{0x4A1A, 0x0004, REG_BITS_16},
	{0x4A1C, 0x0004, REG_BITS_16},
	{0x4A1E, 0x0004, REG_BITS_16},
	{0x4A20, 0x0004, REG_BITS_16},
	{0x4A22, 0x0000, REG_BITS_16},
	{0x4A24, 0x1E00, REG_BITS_16},
	{0x4A26, 0x0000, REG_BITS_16},
	{0x4A28, 0xF2FF, REG_BITS_16},
	{0x4A2A, 0x0000, REG_BITS_16},
	{0x4A2C, 0x0000, REG_BITS_16},
	{0x400E, 0x0024, REG_BITS_16},
	{0x4012, 0xFFFF, REG_BITS_16},
	{0x4014, 0x5B0E, REG_BITS_16},
	{0x4016, 0xBD28, REG_BITS_16},
	{0x4018, 0x9703, REG_BITS_16},
	{0x401A, 0x4005, REG_BITS_16},
	{0x401C, 0xFD03, REG_BITS_16},
	{0x401E, 0x5F02, REG_BITS_16},
	{0x4020, 0xCB02, REG_BITS_16},
	{0x4036, 0x1005, REG_BITS_16},
	{0x4039, 0x22, REG_BITS_8},
	{0x403A, 0x0A00, REG_BITS_16},
	{0x4042, 0x16, REG_BITS_8},
	{0x4043, 0x16, REG_BITS_8},
	{0x404D, 0xA0, REG_BITS_8},
	{0x404E, 0x02, REG_BITS_8},
	{0x4080, 0x64, REG_BITS_8},
	{0x4081, 0x20, REG_BITS_8},
	{0x4082, 0x35, REG_BITS_8},
	{0x4083, 0x26, REG_BITS_8},
	{0x4084, 0x05, REG_BITS_8},
	{0x4085, 0x04, REG_BITS_8},
	{0x4093, 0x03, REG_BITS_8},
	{0x4098, 0x01, REG_BITS_8},
	{0x4099, 0x10, REG_BITS_8},
	{0x409A, 0x02, REG_BITS_8},
	{0x409B, 0x64, REG_BITS_8},
	{0x409C, 0x20, REG_BITS_8},
	{0x409D, 0x0D, REG_BITS_8},
	{0x409E, 0x0B, REG_BITS_8},
	{0x42BD, 0x04, REG_BITS_8},
	{0x42BE, 0x05, REG_BITS_8},
	{0x42BF, 0x06, REG_BITS_8},
	{0x42C0, 0x07, REG_BITS_8},
	{0x42C1, 0x08, REG_BITS_8},
	{0x42C2, 0x07, REG_BITS_8},
	{0x42C3, 0x06, REG_BITS_8},
	{0x42C4, 0x05, REG_BITS_8},
	{0x42C5, 0x04, REG_BITS_8},
	{0x42C6, 0x09, REG_BITS_8},
	{0x42C7, 0x0D, REG_BITS_8},
	{0x42C8, 0x0E, REG_BITS_8},
	{0x42C9, 0x10, REG_BITS_8},
	{0x42CA, 0x11, REG_BITS_8},
	{0x42CB, 0x10, REG_BITS_8},
	{0x42CC, 0x0E, REG_BITS_8},
	{0x42CD, 0x0D, REG_BITS_8},
	{0x42CE, 0x09, REG_BITS_8},
	{0x42CF, 0x0C, REG_BITS_8},
	{0x42D0, 0x13, REG_BITS_8},
	{0x42D1, 0x1F, REG_BITS_8},
	{0x42D2, 0x27, REG_BITS_8},
	{0x42D3, 0x33, REG_BITS_8},
	{0x42D4, 0x27, REG_BITS_8},
	{0x42D5, 0x1F, REG_BITS_8},
	{0x42D6, 0x13, REG_BITS_8},
	{0x42D7, 0x0C, REG_BITS_8},
	{0x42D8, 0x0D, REG_BITS_8},
	{0x42D9, 0x1F, REG_BITS_8},
	{0x42DA, 0x47, REG_BITS_8},
	{0x42DB, 0x4E, REG_BITS_8},
	{0x42DC, 0x56, REG_BITS_8},
	{0x42DD, 0x4E, REG_BITS_8},
	{0x42DE, 0x47, REG_BITS_8},
	{0x42DF, 0x1F, REG_BITS_8},
	{0x42E0, 0x0D, REG_BITS_8},
	{0x42E1, 0x0E, REG_BITS_8},
	{0x42E2, 0x2A, REG_BITS_8},
	{0x42E3, 0x4D, REG_BITS_8},
	{0x42E4, 0x5A, REG_BITS_8},
	{0x42E5, 0x64, REG_BITS_8},
	{0x42E6, 0x5A, REG_BITS_8},
	{0x42E7, 0x4D, REG_BITS_8},
	{0x42E8, 0x2A, REG_BITS_8},
	{0x42E9, 0x0E, REG_BITS_8},
	{0x42EA, 0x0D, REG_BITS_8},
	{0x42EB, 0x1F, REG_BITS_8},
	{0x42EC, 0x3B, REG_BITS_8},
	{0x42ED, 0x43, REG_BITS_8},
	{0x42EE, 0x4B, REG_BITS_8},
	{0x42EF, 0x43, REG_BITS_8},
	{0x42F0, 0x3B, REG_BITS_8},
	{0x42F1, 0x1F, REG_BITS_8},
	{0x42F2, 0x0D, REG_BITS_8},
	{0x42F3, 0x0B, REG_BITS_8},
	{0x42F4, 0x11, REG_BITS_8},
	{0x42F5, 0x14, REG_BITS_8},
	{0x42F6, 0x18, REG_BITS_8},
	{0x42F7, 0x1C, REG_BITS_8},
	{0x42F8, 0x18, REG_BITS_8},
	{0x42F9, 0x14, REG_BITS_8},
	{0x42FA, 0x11, REG_BITS_8},
	{0x42FB, 0x0B, REG_BITS_8},
	{0x0104, 0x4D, REG_BITS_8},
	{0x01BD, 0x01, REG_BITS_8},
	{0x01BE, 0x02, REG_BITS_8},
	{0x01BF, 0x03, REG_BITS_8},
	{0x01C0, 0x08, REG_BITS_8},
	{0x02E3, 0x00, REG_BITS_8},
	{0x02E4, 0xC0, REG_BITS_8},
	{0x4400, 0x00, REG_BITS_8},
	{0x4402, 0x01, REG_BITS_8},
	{0x4403, 0x01, REG_BITS_8},
	{0x4404, 0x00, REG_BITS_8},
	{0x4405, 0x01, REG_BITS_8},
	{0x4406, 0x0A, REG_BITS_8},
	{0x4408, 0x0001, REG_BITS_16},
	{0x440A, 0x0010, REG_BITS_16},
	{0x440C, 0x20, REG_BITS_8},
	{0x440D, 0x20, REG_BITS_8},
	{0x440E, 0x20, REG_BITS_8},
	{0x440F, 0x20, REG_BITS_8},
	{0x4410, 0x04, REG_BITS_8},
	{0x4411, 0x04, REG_BITS_8},
	{0x4412, 0x04, REG_BITS_8},
	{0x4413, 0x04, REG_BITS_8},
	{0x4414, 0x20, REG_BITS_8},
	{0x4415, 0x20, REG_BITS_8},
	{0x4416, 0x20, REG_BITS_8},
	{0x4417, 0x20, REG_BITS_8},
	{0x4418, 0x04, REG_BITS_8},
	{0x4419, 0x04, REG_BITS_8},
	{0x441A, 0x04, REG_BITS_8},
	{0x441B, 0x04, REG_BITS_8},
	{0x441C, 0x01, REG_BITS_8},
	{0x441D, 0x01, REG_BITS_8},
	{0x441E, 0x01, REG_BITS_8},
	{0x441F, 0x01, REG_BITS_8},
	{0x4420, 0x00, REG_BITS_8},
	{0x4421, 0x04, REG_BITS_8},
	{0x4422, 0x10, REG_BITS_8},
	{0x4423, 0x01, REG_BITS_8},
	{0x4424, 0x02, REG_BITS_8},
	{0x4425, 0x02, REG_BITS_8},
	{0x4426, 0xFFFF, REG_BITS_16},
	{0x4428, 0xFFFF, REG_BITS_16},
	{0x442A, 0x2D0D, REG_BITS_16},
	{0x442C, 0xF613, REG_BITS_16},
	{0x442E, 0xBC0B, REG_BITS_16},
	{0x4430, 0x7517, REG_BITS_16},
	{0x4432, 0x0010, REG_BITS_16},
	{0x4434, 0x0010, REG_BITS_16},
	{0x4436, 0x810B, REG_BITS_16},
	{0x4438, 0x3218, REG_BITS_16},
	{0x443A, 0x5A0A, REG_BITS_16},
	{0x443C, 0x021D, REG_BITS_16},
	{0x443E, 0xCD0A, REG_BITS_16},
	{0x4440, 0xD61A, REG_BITS_16},
	{0x4442, 0x800C, REG_BITS_16},
	{0x4444, 0x0013, REG_BITS_16},
	{0x4446, 0xEF10, REG_BITS_16},
	{0x4448, 0x320F, REG_BITS_16},
	{0x444A, 0x007D, REG_BITS_16},
	{0x444C, 0xE880, REG_BITS_16},
	{0x444E, 0x0A, REG_BITS_8},
	{0x444F, 0x00, REG_BITS_8},
	{0x4450, 0x0000, REG_BITS_16},
	{0x4452, 0x1E, REG_BITS_8},
	{0x4453, 0x7B, REG_BITS_8},
	{0x4454, 0x0000, REG_BITS_16},
	{0x4456, 0x0000, REG_BITS_16},
	{0x4458, 0x0000, REG_BITS_16},
	{0x445A, 0x0000, REG_BITS_16},
	{0x445C, 0x0000, REG_BITS_16},
	{0x445E, 0x0000, REG_BITS_16},
	{0x4460, 0x0003, REG_BITS_16},
	{0x4462, 0x1000, REG_BITS_16},
	{0x4464, 0xC203, REG_BITS_16},
	{0x4466, 0xC203, REG_BITS_16},
	{0x4468, 0xC203, REG_BITS_16},
	{0x446A, 0x14, REG_BITS_8},
	{0x446B, 0x05, REG_BITS_8},
	{0x446C, 0x00, REG_BITS_8},
	{0x446D, 0x20, REG_BITS_8},
	{0x446E, 0x0000, REG_BITS_16},
	{0x4470, 0x05, REG_BITS_8},
	{0x4471, 0x40, REG_BITS_8},
	{0x4600, 0xAA, REG_BITS_8},
	{0x4601, 0xAA, REG_BITS_8},
	{0x4602, 0xAA, REG_BITS_8},
	{0x4603, 0xAA, REG_BITS_8},
	{0x4604, 0xAA, REG_BITS_8},
	{0x4605, 0xAA, REG_BITS_8},
	{0x4606, 0xAA, REG_BITS_8},
	{0x4607, 0xAA, REG_BITS_8},
	{0x4608, 0xAA, REG_BITS_8},
	{0x4609, 0xAA, REG_BITS_8},
	{0x460A, 0x96, REG_BITS_8},
	{0x460B, 0x78, REG_BITS_8},
	{0x460C, 0x6C, REG_BITS_8},
	{0x460D, 0x5F, REG_BITS_8},
	{0x460E, 0x55, REG_BITS_8},
	{0x460F, 0x45, REG_BITS_8},
	{0x4610, 0x3D, REG_BITS_8},
	{0x4611, 0x39, REG_BITS_8},
	{0x4612, 0x37, REG_BITS_8},
	{0x4613, 0x36, REG_BITS_8},
	{0x4614, 0x35, REG_BITS_8},
	{0x4615, 0x34, REG_BITS_8},
	{0x4616, 0x33, REG_BITS_8},
	{0x4617, 0x32, REG_BITS_8},
	{0x4618, 0x31, REG_BITS_8},
	{0x4619, 0x30, REG_BITS_8},
	{0x461A, 0x2F, REG_BITS_8},
	{0x461B, 0x2E, REG_BITS_8},
	{0x461C, 0x2D, REG_BITS_8},
	{0x461D, 0x2C, REG_BITS_8},
	{0x461E, 0x2B, REG_BITS_8},
	{0x461F, 0x29, REG_BITS_8},
	{0x4620, 0x25, REG_BITS_8},
	{0x4621, 0x24, REG_BITS_8},
	{0x4622, 0x23, REG_BITS_8},
	{0x4623, 0x22, REG_BITS_8},
	{0x4624, 0x21, REG_BITS_8},
	{0x4625, 0x20, REG_BITS_8},
	{0x4626, 0xAF, REG_BITS_8},
	{0x4627, 0xAF, REG_BITS_8},
	{0x4628, 0xAF, REG_BITS_8},
	{0x4629, 0xAF, REG_BITS_8},
	{0x462A, 0xAF, REG_BITS_8},
	{0x462B, 0xAF, REG_BITS_8},
	{0x462C, 0xAF, REG_BITS_8},
	{0x462D, 0xAF, REG_BITS_8},
	{0x462E, 0xAF, REG_BITS_8},
	{0x462F, 0xAA, REG_BITS_8},
	{0x4630, 0xB2, REG_BITS_8},
	{0x4631, 0xB4, REG_BITS_8},
	{0x4632, 0xB6, REG_BITS_8},
	{0x4633, 0xB4, REG_BITS_8},
	{0x4634, 0x9B, REG_BITS_8},
	{0x4635, 0x82, REG_BITS_8},
	{0x4636, 0x78, REG_BITS_8},
	{0x4637, 0x72, REG_BITS_8},
	{0x4638, 0x6C, REG_BITS_8},
	{0x4639, 0x67, REG_BITS_8},
	{0x463A, 0x63, REG_BITS_8},
	{0x463B, 0x5E, REG_BITS_8},
	{0x463C, 0x58, REG_BITS_8},
	{0x463D, 0x53, REG_BITS_8},
	{0x463E, 0x4E, REG_BITS_8},
	{0x463F, 0x4A, REG_BITS_8},
	{0x4640, 0x45, REG_BITS_8},
	{0x4641, 0x40, REG_BITS_8},
	{0x4642, 0x3D, REG_BITS_8},
	{0x4643, 0x3A, REG_BITS_8},
	{0x4644, 0x38, REG_BITS_8},
	{0x4645, 0x36, REG_BITS_8},
	{0x4646, 0x3B, REG_BITS_8},
	{0x4647, 0x3A, REG_BITS_8},
	{0x4648, 0x39, REG_BITS_8},
	{0x4649, 0x38, REG_BITS_8},
	{0x464A, 0x37, REG_BITS_8},
	{0x464B, 0x36, REG_BITS_8},
	{0x464C, 0x1F, REG_BITS_8},
	{0x464D, 0x09, REG_BITS_8},
	{0x464E, 0x19, REG_BITS_8},
	{0x464F, 0x10, REG_BITS_8},
	{0x4650, 0x91, REG_BITS_8},
	{0x4651, 0x91, REG_BITS_8},
	{0x4652, 0x91, REG_BITS_8},
	{0x4653, 0x91, REG_BITS_8},
	{0x4654, 0x91, REG_BITS_8},
	{0x4655, 0x91, REG_BITS_8},
	{0x4656, 0x91, REG_BITS_8},
	{0x4657, 0x91, REG_BITS_8},
	{0x4658, 0x91, REG_BITS_8},
	{0x4659, 0x91, REG_BITS_8},
	{0x465A, 0x91, REG_BITS_8},
	{0x465B, 0x91, REG_BITS_8},
	{0x465C, 0x91, REG_BITS_8},
	{0x465D, 0x78, REG_BITS_8},
	{0x465E, 0x68, REG_BITS_8},
	{0x465F, 0x51, REG_BITS_8},
	{0x4660, 0x41, REG_BITS_8},
	{0x4661, 0x3C, REG_BITS_8},
	{0x4662, 0x3A, REG_BITS_8},
	{0x4663, 0x39, REG_BITS_8},
	{0x4664, 0x38, REG_BITS_8},
	{0x4665, 0x37, REG_BITS_8},
	{0x4666, 0x36, REG_BITS_8},
	{0x4667, 0x35, REG_BITS_8},
	{0x4668, 0x34, REG_BITS_8},
	{0x4669, 0x33, REG_BITS_8},
	{0x466A, 0x32, REG_BITS_8},
	{0x466B, 0x31, REG_BITS_8},
	{0x466C, 0x30, REG_BITS_8},
	{0x466D, 0x2F, REG_BITS_8},
	{0x466E, 0x2E, REG_BITS_8},
	{0x466F, 0x2C, REG_BITS_8},
	{0x4670, 0x2B, REG_BITS_8},
	{0x4671, 0x2A, REG_BITS_8},
	{0x4672, 0x29, REG_BITS_8},
	{0x4673, 0x28, REG_BITS_8},
	{0x4674, 0x27, REG_BITS_8},
	{0x4675, 0x26, REG_BITS_8},
	{0x4676, 0xFF, REG_BITS_8},
	{0x4677, 0xFF, REG_BITS_8},
	{0x4678, 0xFF, REG_BITS_8},
	{0x4679, 0xFF, REG_BITS_8},
	{0x467A, 0xFF, REG_BITS_8},
	{0x467B, 0xFF, REG_BITS_8},
	{0x467C, 0xFF, REG_BITS_8},
	{0x467D, 0xFF, REG_BITS_8},
	{0x467E, 0xFF, REG_BITS_8},
	{0x467F, 0xFF, REG_BITS_8},
	{0x4680, 0xD9, REG_BITS_8},
	{0x4681, 0xB7, REG_BITS_8},
	{0x4682, 0x96, REG_BITS_8},
	{0x4683, 0x83, REG_BITS_8},
	{0x4684, 0x76, REG_BITS_8},
	{0x4685, 0x6A, REG_BITS_8},
	{0x4686, 0x68, REG_BITS_8},
	{0x4687, 0x66, REG_BITS_8},
	{0x4688, 0x63, REG_BITS_8},
	{0x4689, 0x5F, REG_BITS_8},
	{0x468A, 0x5B, REG_BITS_8},
	{0x468B, 0x56, REG_BITS_8},
	{0x468C, 0x51, REG_BITS_8},
	{0x468D, 0x4C, REG_BITS_8},
	{0x468E, 0x47, REG_BITS_8},
	{0x468F, 0x43, REG_BITS_8},
	{0x4690, 0x3F, REG_BITS_8},
	{0x4691, 0x3B, REG_BITS_8},
	{0x4692, 0x39, REG_BITS_8},
	{0x4693, 0x37, REG_BITS_8},
	{0x4694, 0x35, REG_BITS_8},
	{0x4695, 0x34, REG_BITS_8},
	{0x4696, 0x33, REG_BITS_8},
	{0x4697, 0x32, REG_BITS_8},
	{0x4698, 0x31, REG_BITS_8},
	{0x4699, 0x30, REG_BITS_8},
	{0x469A, 0x2F, REG_BITS_8},
	{0x469B, 0x2E, REG_BITS_8},
	{0x469C, 0x1E, REG_BITS_8},
	{0x469D, 0x0F, REG_BITS_8},
	{0x469E, 0x18, REG_BITS_8},
	{0x469F, 0x10, REG_BITS_8},
	{0x46A0, 0xFF, REG_BITS_8},
	{0x46A1, 0xFF, REG_BITS_8},
	{0x46A2, 0xFF, REG_BITS_8},
	{0x46A3, 0xFF, REG_BITS_8},
	{0x46A4, 0xFF, REG_BITS_8},
	{0x46A5, 0xFF, REG_BITS_8},
	{0x46A6, 0xFF, REG_BITS_8},
	{0x46A7, 0xFF, REG_BITS_8},
	{0x46A8, 0xFF, REG_BITS_8},
	{0x46A9, 0xFD, REG_BITS_8},
	{0x46AA, 0xCB, REG_BITS_8},
	{0x46AB, 0xA9, REG_BITS_8},
	{0x46AC, 0x90, REG_BITS_8},
	{0x46AD, 0x7D, REG_BITS_8},
	{0x46AE, 0x70, REG_BITS_8},
	{0x46AF, 0x65, REG_BITS_8},
	{0x46B0, 0x5C, REG_BITS_8},
	{0x46B1, 0x55, REG_BITS_8},
	{0x46B2, 0x4F, REG_BITS_8},
	{0x46B3, 0x32, REG_BITS_8},
	{0x46B4, 0x30, REG_BITS_8},
	{0x46B5, 0x2F, REG_BITS_8},
	{0x46B6, 0x2D, REG_BITS_8},
	{0x46B7, 0x2B, REG_BITS_8},
	{0x46B8, 0x29, REG_BITS_8},
	{0x46B9, 0x27, REG_BITS_8},
	{0x46BA, 0x25, REG_BITS_8},
	{0x46BB, 0x23, REG_BITS_8},
	{0x46BC, 0x21, REG_BITS_8},
	{0x46BD, 0x1F, REG_BITS_8},
	{0x46BE, 0x1D, REG_BITS_8},
	{0x46BF, 0x1B, REG_BITS_8},
	{0x46C0, 0x1A, REG_BITS_8},
	{0x46C1, 0x2A, REG_BITS_8},
	{0x46C2, 0x29, REG_BITS_8},
	{0x46C3, 0x28, REG_BITS_8},
	{0x46C4, 0x27, REG_BITS_8},
	{0x46C5, 0x26, REG_BITS_8},
	{0x46C6, 0xFF, REG_BITS_8},
	{0x46C7, 0xFF, REG_BITS_8},
	{0x46C8, 0xFF, REG_BITS_8},
	{0x46C9, 0xFF, REG_BITS_8},
	{0x46CA, 0xFF, REG_BITS_8},
	{0x46CB, 0xFF, REG_BITS_8},
	{0x46CC, 0xFF, REG_BITS_8},
	{0x46CD, 0xFF, REG_BITS_8},
	{0x46CE, 0xFF, REG_BITS_8},
	{0x46CF, 0xFF, REG_BITS_8},
	{0x46D0, 0xD3, REG_BITS_8},
	{0x46D1, 0xB1, REG_BITS_8},
	{0x46D2, 0x98, REG_BITS_8},
	{0x46D3, 0x85, REG_BITS_8},
	{0x46D4, 0x78, REG_BITS_8},
	{0x46D5, 0x6D, REG_BITS_8},
	{0x46D6, 0x64, REG_BITS_8},
	{0x46D7, 0x5D, REG_BITS_8},
	{0x46D8, 0x57, REG_BITS_8},
	{0x46D9, 0x63, REG_BITS_8},
	{0x46DA, 0x5E, REG_BITS_8},
	{0x46DB, 0x5A, REG_BITS_8},
	{0x46DC, 0x56, REG_BITS_8},
	{0x46DD, 0x52, REG_BITS_8},
	{0x46DE, 0x50, REG_BITS_8},
	{0x46DF, 0x4E, REG_BITS_8},
	{0x46E0, 0x4C, REG_BITS_8},
	{0x46E1, 0x4A, REG_BITS_8},
	{0x46E2, 0x48, REG_BITS_8},
	{0x46E3, 0x46, REG_BITS_8},
	{0x46E4, 0x44, REG_BITS_8},
	{0x46E5, 0x43, REG_BITS_8},
	{0x46E6, 0x42, REG_BITS_8},
	{0x46E7, 0x32, REG_BITS_8},
	{0x46E8, 0x31, REG_BITS_8},
	{0x46E9, 0x30, REG_BITS_8},
	{0x46EA, 0x2F, REG_BITS_8},
	{0x46EB, 0x2E, REG_BITS_8},
	{0x46EC, 0x1D, REG_BITS_8},
	{0x46ED, 0x14, REG_BITS_8},
	{0x46EE, 0x19, REG_BITS_8},
	{0x46EF, 0x10, REG_BITS_8},
	{0x46F0, 0xFF, REG_BITS_8},
	{0x46F1, 0xFF, REG_BITS_8},
	{0x46F2, 0xFF, REG_BITS_8},
	{0x46F3, 0xFF, REG_BITS_8},
	{0x46F4, 0xFF, REG_BITS_8},
	{0x46F5, 0xFF, REG_BITS_8},
	{0x46F6, 0xFF, REG_BITS_8},
	{0x46F7, 0xFF, REG_BITS_8},
	{0x46F8, 0xFF, REG_BITS_8},
	{0x46F9, 0xFF, REG_BITS_8},
	{0x46FA, 0xCD, REG_BITS_8},
	{0x46FB, 0xAB, REG_BITS_8},
	{0x46FC, 0x92, REG_BITS_8},
	{0x46FD, 0x7F, REG_BITS_8},
	{0x46FE, 0x72, REG_BITS_8},
	{0x46FF, 0x67, REG_BITS_8},
	{0x4700, 0x5E, REG_BITS_8},
	{0x4701, 0x57, REG_BITS_8},
	{0x4702, 0x51, REG_BITS_8},
	{0x4703, 0x4E, REG_BITS_8},
	{0x4704, 0x49, REG_BITS_8},
	{0x4705, 0x45, REG_BITS_8},
	{0x4706, 0x40, REG_BITS_8},
	{0x4707, 0x3E, REG_BITS_8},
	{0x4708, 0x3B, REG_BITS_8},
	{0x4709, 0x38, REG_BITS_8},
	{0x470A, 0x37, REG_BITS_8},
	{0x470B, 0x35, REG_BITS_8},
	{0x470C, 0x33, REG_BITS_8},
	{0x470D, 0x32, REG_BITS_8},
	{0x470E, 0x30, REG_BITS_8},
	{0x470F, 0x2E, REG_BITS_8},
	{0x4710, 0x2D, REG_BITS_8},
	{0x4711, 0x2C, REG_BITS_8},
	{0x4712, 0x2B, REG_BITS_8},
	{0x4713, 0x2A, REG_BITS_8},
	{0x4714, 0x29, REG_BITS_8},
	{0x4715, 0x28, REG_BITS_8},
	{0x4716, 0xFF, REG_BITS_8},
	{0x4717, 0xFF, REG_BITS_8},
	{0x4718, 0xFF, REG_BITS_8},
	{0x4719, 0xFF, REG_BITS_8},
	{0x471A, 0xFF, REG_BITS_8},
	{0x471B, 0xFF, REG_BITS_8},
	{0x471C, 0xFF, REG_BITS_8},
	{0x471D, 0xFF, REG_BITS_8},
	{0x471E, 0xFF, REG_BITS_8},
	{0x471F, 0xFF, REG_BITS_8},
	{0x4720, 0xD3, REG_BITS_8},
	{0x4721, 0xB1, REG_BITS_8},
	{0x4722, 0x98, REG_BITS_8},
	{0x4723, 0x85, REG_BITS_8},
	{0x4724, 0x78, REG_BITS_8},
	{0x4725, 0x6D, REG_BITS_8},
	{0x4726, 0x64, REG_BITS_8},
	{0x4727, 0x5D, REG_BITS_8},
	{0x4728, 0x57, REG_BITS_8},
	{0x4729, 0x52, REG_BITS_8},
	{0x472A, 0x4D, REG_BITS_8},
	{0x472B, 0x49, REG_BITS_8},
	{0x472C, 0x44, REG_BITS_8},
	{0x472D, 0x42, REG_BITS_8},
	{0x472E, 0x3F, REG_BITS_8},
	{0x472F, 0x3C, REG_BITS_8},
	{0x4730, 0x3B, REG_BITS_8},
	{0x4731, 0x39, REG_BITS_8},
	{0x4732, 0x37, REG_BITS_8},
	{0x4733, 0x36, REG_BITS_8},
	{0x4734, 0x34, REG_BITS_8},
	{0x4735, 0x34, REG_BITS_8},
	{0x4736, 0x33, REG_BITS_8},
	{0x4737, 0x32, REG_BITS_8},
	{0x4738, 0x31, REG_BITS_8},
	{0x4739, 0x30, REG_BITS_8},
	{0x473A, 0x2F, REG_BITS_8},
	{0x473B, 0x2E, REG_BITS_8},
	{0x473C, 0x1C, REG_BITS_8},
	{0x473D, 0x17, REG_BITS_8},
	{0x473E, 0x19, REG_BITS_8},
	{0x473F, 0x17, REG_BITS_8},
	{0x5000, 0xB0FF, REG_BITS_16},
	{0x5002, 0xFAFF, REG_BITS_16},
	{0x5004, 0xD4FF, REG_BITS_16},
	{0x5006, 0xEEFF, REG_BITS_16},
	{0x5008, 0xFEFF, REG_BITS_16},
	{0x500A, 0xD8FF, REG_BITS_16},
	{0x500C, 0xB8FF, REG_BITS_16},
	{0x500E, 0xFDFF, REG_BITS_16},
	{0x5010, 0xD4FF, REG_BITS_16},
	{0x5012, 0xEEFF, REG_BITS_16},
	{0x5014, 0x0000, REG_BITS_16},
	{0x5016, 0xC8FF, REG_BITS_16},
	{0x5018, 0xCEFF, REG_BITS_16},
	{0x501A, 0xF8FF, REG_BITS_16},
	{0x501C, 0xBFFF, REG_BITS_16},
	{0x501E, 0xFEFF, REG_BITS_16},
	{0x5020, 0xF9FF, REG_BITS_16},
	{0x5022, 0xB6FF, REG_BITS_16},
	{0x5024, 0xCCFF, REG_BITS_16},
	{0x5026, 0xF6FF, REG_BITS_16},
	{0x5028, 0xC7FF, REG_BITS_16},
	{0x502A, 0x0000, REG_BITS_16},
	{0x502C, 0xF6FF, REG_BITS_16},
	{0x502E, 0x72FF, REG_BITS_16},
	{0x5030, 0xCCFF, REG_BITS_16},
	{0x5032, 0xF6FF, REG_BITS_16},
	{0x5034, 0xC7FF, REG_BITS_16},
	{0x5036, 0x0000, REG_BITS_16},
	{0x5038, 0xF6FF, REG_BITS_16},
	{0x503A, 0x72FF, REG_BITS_16},
	{0x503C, 0xACFF, REG_BITS_16},
	{0x503E, 0xEEFF, REG_BITS_16},
	{0x5040, 0xBAFF, REG_BITS_16},
	{0x5042, 0x0000, REG_BITS_16},
	{0x5044, 0xFBFF, REG_BITS_16},
	{0x5046, 0xB7FF, REG_BITS_16},
	{0x5048, 0xACFF, REG_BITS_16},
	{0x504A, 0xEEFF, REG_BITS_16},
	{0x504C, 0xBAFF, REG_BITS_16},
	{0x504E, 0x0000, REG_BITS_16},
	{0x5050, 0xFBFF, REG_BITS_16},
	{0x5052, 0xB7FF, REG_BITS_16},
	{0x5054, 0x33, REG_BITS_8},
	{0x5055, 0x1C, REG_BITS_8},
	{0x5056, 0x3F, REG_BITS_8},
	{0x5057, 0x17, REG_BITS_8},
	{0x5058, 0x5D, REG_BITS_8},
	{0x5059, 0x12, REG_BITS_8},
	{0x505A, 0x6C, REG_BITS_8},
	{0x505B, 0x0E, REG_BITS_8},
	{0x505C, 0x95, REG_BITS_8},
	{0x505D, 0x0C, REG_BITS_8},
	{0x505E, 0x41, REG_BITS_8},
	{0x505F, 0x12, REG_BITS_8},
	{0x5060, 0x4D, REG_BITS_8},
	{0x5061, 0x10, REG_BITS_8},
	{0x5092, 0xF6FF, REG_BITS_16},
	{0x5094, 0xE9FF, REG_BITS_16},
	{0x5096, 0xF6FF, REG_BITS_16},
	{0x5098, 0xEAFF, REG_BITS_16},
	{0x509A, 0xF6FF, REG_BITS_16},
	{0x509C, 0xEAFF, REG_BITS_16},
	{0x509E, 0xF6FF, REG_BITS_16},
	{0x50A0, 0xE9FF, REG_BITS_16},
	{0x50A2, 0x40, REG_BITS_8},
	{0x50A3, 0x48, REG_BITS_8},
	{0x50A4, 0x40, REG_BITS_8},
	{0x50A5, 0x56, REG_BITS_8},
	{0x50A6, 0x40, REG_BITS_8},
	{0x50A7, 0x56, REG_BITS_8},
	{0x50A8, 0x40, REG_BITS_8},
	{0x50A9, 0x48, REG_BITS_8},
	{0x50AA, 0xF6FF, REG_BITS_16},
	{0x50AC, 0xE9FF, REG_BITS_16},
	{0x50AE, 0xF6FF, REG_BITS_16},
	{0x50B0, 0xEAFF, REG_BITS_16},
	{0x50B2, 0xF6FF, REG_BITS_16},
	{0x50B4, 0xEAFF, REG_BITS_16},
	{0x50B6, 0xF6FF, REG_BITS_16},
	{0x50B8, 0xE9FF, REG_BITS_16},
	{0x50BA, 0x40, REG_BITS_8},
	{0x50BB, 0x48, REG_BITS_8},
	{0x50BC, 0x40, REG_BITS_8},
	{0x50BD, 0x56, REG_BITS_8},
	{0x50BE, 0x40, REG_BITS_8},
	{0x50BF, 0x56, REG_BITS_8},
	{0x50C0, 0x40, REG_BITS_8},
	{0x50C1, 0x48, REG_BITS_8},
	{0x50C2, 0x12, REG_BITS_8},
	{0x50C3, 0x10, REG_BITS_8},
	{0x5200, 0x0000, REG_BITS_16},
	{0x5202, 0x0400, REG_BITS_16},
	{0x5204, 0x0800, REG_BITS_16},
	{0x5206, 0x0E00, REG_BITS_16},
	{0x5208, 0x1600, REG_BITS_16},
	{0x520A, 0x1E00, REG_BITS_16},
	{0x520C, 0x2600, REG_BITS_16},
	{0x520E, 0x2E00, REG_BITS_16},
	{0x5210, 0x3600, REG_BITS_16},
	{0x5212, 0x3D00, REG_BITS_16},
	{0x5214, 0x4300, REG_BITS_16},
	{0x5216, 0x4900, REG_BITS_16},
	{0x5218, 0x4E00, REG_BITS_16},
	{0x521A, 0x5400, REG_BITS_16},
	{0x521C, 0x5900, REG_BITS_16},
	{0x521E, 0x5E00, REG_BITS_16},
	{0x5220, 0x6300, REG_BITS_16},
	{0x5222, 0x6600, REG_BITS_16},
	{0x5224, 0x4300, REG_BITS_16},
	{0x5226, 0x8700, REG_BITS_16},
	{0x5228, 0xAF00, REG_BITS_16},
	{0x522A, 0xC800, REG_BITS_16},
	{0x522C, 0xDC00, REG_BITS_16},
	{0x522E, 0xEB00, REG_BITS_16},
	{0x5230, 0xF600, REG_BITS_16},
	{0x5232, 0x0001, REG_BITS_16},
	{0x5234, 0x0201, REG_BITS_16},
	{0x5236, 0x0000, REG_BITS_16},
	{0x5238, 0x0400, REG_BITS_16},
	{0x523A, 0x0800, REG_BITS_16},
	{0x523C, 0x0E00, REG_BITS_16},
	{0x523E, 0x1600, REG_BITS_16},
	{0x5240, 0x1E00, REG_BITS_16},
	{0x5242, 0x2600, REG_BITS_16},
	{0x5244, 0x2E00, REG_BITS_16},
	{0x5246, 0x3600, REG_BITS_16},
	{0x5248, 0x3D00, REG_BITS_16},
	{0x524A, 0x4300, REG_BITS_16},
	{0x524C, 0x4900, REG_BITS_16},
	{0x524E, 0x4E00, REG_BITS_16},
	{0x5250, 0x5400, REG_BITS_16},
	{0x5252, 0x5900, REG_BITS_16},
	{0x5254, 0x5E00, REG_BITS_16},
	{0x5256, 0x6300, REG_BITS_16},
	{0x5258, 0x6600, REG_BITS_16},
	{0x525A, 0x4300, REG_BITS_16},
	{0x525C, 0x8700, REG_BITS_16},
	{0x525E, 0xAF00, REG_BITS_16},
	{0x5260, 0xC800, REG_BITS_16},
	{0x5262, 0xDC00, REG_BITS_16},
	{0x5264, 0xEB00, REG_BITS_16},
	{0x5266, 0xF600, REG_BITS_16},
	{0x5268, 0x0001, REG_BITS_16},
	{0x526A, 0x0201, REG_BITS_16},
	{0x526C, 0x0000, REG_BITS_16},
	{0x526E, 0x0400, REG_BITS_16},
	{0x5270, 0x0800, REG_BITS_16},
	{0x5272, 0x0E00, REG_BITS_16},
	{0x5274, 0x1600, REG_BITS_16},
	{0x5276, 0x1E00, REG_BITS_16},
	{0x5278, 0x2600, REG_BITS_16},
	{0x527A, 0x2E00, REG_BITS_16},
	{0x527C, 0x3600, REG_BITS_16},
	{0x527E, 0x3D00, REG_BITS_16},
	{0x5280, 0x4300, REG_BITS_16},
	{0x5282, 0x4900, REG_BITS_16},
	{0x5284, 0x4E00, REG_BITS_16},
	{0x5286, 0x5400, REG_BITS_16},
	{0x5288, 0x5900, REG_BITS_16},
	{0x528A, 0x5E00, REG_BITS_16},
	{0x528C, 0x6300, REG_BITS_16},
	{0x528E, 0x6600, REG_BITS_16},
	{0x5290, 0x4300, REG_BITS_16},
	{0x5292, 0x8700, REG_BITS_16},
	{0x5294, 0xAF00, REG_BITS_16},
	{0x5296, 0xC800, REG_BITS_16},
	{0x5298, 0xDC00, REG_BITS_16},
	{0x529A, 0xEB00, REG_BITS_16},
	{0x529C, 0xF600, REG_BITS_16},
	{0x529E, 0x0001, REG_BITS_16},
	{0x52A0, 0x0201, REG_BITS_16},
	{0x52A2, 0x1002, REG_BITS_16},
	{0x52A4, 0x0540, REG_BITS_16},
	{0x52A6, 0x1002, REG_BITS_16},
	{0x52A8, 0x0540, REG_BITS_16},
	{0x52AA, 0x1002, REG_BITS_16},
	{0x52AC, 0x0540, REG_BITS_16},
	{0x52AE, 0x0021, REG_BITS_16},
	{0x4E40, 0x4A15, REG_BITS_16},
	{0x4E42, 0xEC13, REG_BITS_16},
	{0x4E44, 0x4E11, REG_BITS_16},
	{0x4E46, 0x0410, REG_BITS_16},
	{0x4E48, 0xF811, REG_BITS_16},
	{0x4E4A, 0xCC10, REG_BITS_16},
	{0x4E4C, 0x9065, REG_BITS_16},
	{0x4E4E, 0xD859, REG_BITS_16},
	{0x4E50, 0x0000, REG_BITS_16},
	{0x4E52, 0x0000, REG_BITS_16},
	{0x4E54, 0x0000, REG_BITS_16},
	{0x4E56, 0x0000, REG_BITS_16},
	{0x4E58, 0x0000, REG_BITS_16},
	{0x4E5A, 0x0000, REG_BITS_16},
	{0x4E5D, 0x00, REG_BITS_8},
	{0x4E5E, 0x0000, REG_BITS_16},
	{0x4E60, 0x1E5A20E0, REG_BITS_32},
	{0x4E64, 0xED0EF1F6, REG_BITS_32},
	{0x4E68, 0x13F10313, REG_BITS_32},
	{0x4E6C, 0x863A863A, REG_BITS_32},
	{0x4E70, 0x1E5A20E0, REG_BITS_32},
	{0x4E74, 0xED0EF1F6, REG_BITS_32},
	{0x4E78, 0x13F10313, REG_BITS_32},
	{0x4E7C, 0x863A863A, REG_BITS_32},
	{0x4E80, 0x0000, REG_BITS_16},
	{0x4E84, 0x00000000, REG_BITS_32},
	{0x4E88, 0x00000000, REG_BITS_32},
	{0x4E8C, 0x00000000, REG_BITS_32},
	{0x4E90, 0x00000000, REG_BITS_32},
	{0x4E94, 0x00000000, REG_BITS_32},
	{0x4E98, 0x00000000, REG_BITS_32},
	{0x4E9C, 0x00000000, REG_BITS_32},
	{0x4EA0, 0x00000000, REG_BITS_32},
	{0x4F52, 0x01, REG_BITS_8},
	{0x4F53, 0x08, REG_BITS_8},
	{0x4F54, 0x11, REG_BITS_8},
	{0x4F55, 0x12, REG_BITS_8},
	{0x4F56, 0x1A, REG_BITS_8},
	{0x4F57, 0x1F, REG_BITS_8},
	{0x4F58, 0x04, REG_BITS_8},
	{0x4F59, 0x02, REG_BITS_8},
	{0x4F5A, 0x23, REG_BITS_8},
	{0x4F5B, 0x3C, REG_BITS_8},
	{0x4F5C, 0x0F, REG_BITS_8},
	{0x4F5D, 0x11, REG_BITS_8},
	{0x4F5E, 0x05, REG_BITS_8},
	{0x4F5F, 0x0A, REG_BITS_8},
	{0x4F60, 0x14, REG_BITS_8},
	{0x4F61, 0x02, REG_BITS_8},
	{0x4F62, 0x3C, REG_BITS_8},
	{0x4F63, 0x46, REG_BITS_8},
	{0x4F64, 0x14, REG_BITS_8},
	{0x4F65, 0x11, REG_BITS_8},
	{0x4F66, 0x1E, REG_BITS_8},
	{0x4F67, 0x46, REG_BITS_8},
	{0x4F68, 0x14, REG_BITS_8},
	{0x4F69, 0x01, REG_BITS_8},
	{0x4F6A, 0x14, REG_BITS_8},
	{0x4F6C, 0x0074, REG_BITS_16},
	{0x4F6E, 0x0070, REG_BITS_16},
	{0x4F70, 0x00, REG_BITS_8},
	{0x4F71, 0x00, REG_BITS_8},
	{0x4F72, 0x00, REG_BITS_8},
	{0x4F73, 0x00, REG_BITS_8},
	{0x4F74, 0x00, REG_BITS_8},
	{0x4F75, 0x00, REG_BITS_8},
	{0x4F76, 0x00, REG_BITS_8},
	{0x4F77, 0x00, REG_BITS_8},
	{0x4F78, 0x00, REG_BITS_8},
	{0x4F79, 0x00, REG_BITS_8},
	{0x4F7A, 0x00, REG_BITS_8},
	{0x4F7B, 0x00, REG_BITS_8},
	{0x4F7C, 0x00, REG_BITS_8},
	{0x4F7D, 0x00, REG_BITS_8},
	{0x4F7E, 0x00, REG_BITS_8},
	{0x4F7F, 0x00, REG_BITS_8},
	{0x4F80, 0x00, REG_BITS_8},
	{0x4F81, 0x00, REG_BITS_8},
	{0x4F82, 0x00, REG_BITS_8},
	{0x4F83, 0x00, REG_BITS_8},
	{0x4F84, 0x00, REG_BITS_8},
	{0x4F85, 0x00, REG_BITS_8},
	{0x4F86, 0x00, REG_BITS_8},
	{0x4F87, 0x00, REG_BITS_8},
	{0x4F88, 0x00, REG_BITS_8},
	{0x4F89, 0x00, REG_BITS_8},
	{0x4F8A, 0x00, REG_BITS_8},
	{0x4F8B, 0x00, REG_BITS_8},
	{0x4F8C, 0x00, REG_BITS_8},
	{0x4F8D, 0x00, REG_BITS_8},
	{0x4F8E, 0x00, REG_BITS_8},
	{0x4F8F, 0x00, REG_BITS_8},
	{0x4F90, 0x00, REG_BITS_8},
	{0x4FAC, 0x00, REG_BITS_8},
	{0x4FAD, 0x00, REG_BITS_8},
	{0x4FAE, 0x00, REG_BITS_8},
	{0x4FAF, 0x00, REG_BITS_8},
	{0x4FB0, 0x00, REG_BITS_8},
	{0x4FB1, 0x03, REG_BITS_8},
	{0x4FB2, 0x02, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x01, REG_BITS_8},
	{0x9003, 0x0e, REG_BITS_8},
	{0x9004, 0x04, REG_BITS_8},
	{0x9005, 0x38, REG_BITS_8},
	{0x9006, 0x00, REG_BITS_8},
	{0x9007, 0x20, REG_BITS_8},
	{0x9008, 0x01, REG_BITS_8},
	{0x9009, 0x80, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x00, REG_BITS_8},
	{0x900C, 0x0e, REG_BITS_8},
	{0x900D, 0x00, REG_BITS_8},
	{0x900E, 0x48, REG_BITS_8},
	{0x900F, 0x20, REG_BITS_8},
	{0x9010, 0xe0, REG_BITS_8},
	{0x9011, 0x40, REG_BITS_8},
	{0x9012, 0x00, REG_BITS_8},
	{0x9013, 0x04, REG_BITS_8},
	{0x9014, 0x01, REG_BITS_8},
	{0x9015, 0x10, REG_BITS_8},
	{0x9016, 0x04, REG_BITS_8},
	{0x9017, 0x38, REG_BITS_8},
	{0x9018, 0x10, REG_BITS_8},
	{0x9019, 0xe0, REG_BITS_8},
	{0x901A, 0x00, REG_BITS_8},
	{0x901B, 0x80, REG_BITS_8},
	{0x901C, 0x04, REG_BITS_8},
	{0x901D, 0x00, REG_BITS_8},
	{0x901E, 0x12, REG_BITS_8},
	{0x901F, 0x00, REG_BITS_8},
	{0x9020, 0x38, REG_BITS_8},
	{0x9021, 0x00, REG_BITS_8},
	{0x9022, 0x20, REG_BITS_8},
	{0x9023, 0x81, REG_BITS_8},
	{0x9024, 0x80, REG_BITS_8},
	{0x9025, 0x03, REG_BITS_8},
	{0x9026, 0x01, REG_BITS_8},
	{0x9027, 0x10, REG_BITS_8},
	{0x9028, 0x04, REG_BITS_8},
	{0x9029, 0x40, REG_BITS_8},
	{0x902A, 0x00, REG_BITS_8},
	{0x902B, 0xe0, REG_BITS_8},
	{0x902C, 0x00, REG_BITS_8},
	{0x902D, 0x80, REG_BITS_8},
	{0x902E, 0x03, REG_BITS_8},
	{0x902F, 0x02, REG_BITS_8},
	{0x9030, 0x0e, REG_BITS_8},
	{0x9031, 0x00, REG_BITS_8},
	{0x9032, 0x40, REG_BITS_8},
	{0x9033, 0x10, REG_BITS_8},
	{0x9034, 0xe0, REG_BITS_8},
	{0x9035, 0x00, REG_BITS_8},
	{0x9036, 0x80, REG_BITS_8},
	{0x9037, 0x03, REG_BITS_8},
	{0x9038, 0x00, REG_BITS_8},
	{0x9039, 0x14, REG_BITS_8},
	{0x903A, 0x04, REG_BITS_8},
	{0x903B, 0x40, REG_BITS_8},
	{0x903C, 0x10, REG_BITS_8},
	{0x903D, 0x00, REG_BITS_8},
	{0x903E, 0x81, REG_BITS_8},
	{0x903F, 0x80, REG_BITS_8},
	{0x9040, 0x02, REG_BITS_8},
	{0x9041, 0x02, REG_BITS_8},
	{0x9042, 0x0a, REG_BITS_8},
	{0x9043, 0x08, REG_BITS_8},
	{0x9044, 0x30, REG_BITS_8},
	{0x9045, 0x20, REG_BITS_8},
	{0x9046, 0x80, REG_BITS_8},
	{0x9047, 0x40, REG_BITS_8},
	{0x9048, 0x00, REG_BITS_8},
	{0x9049, 0x02, REG_BITS_8},
	{0x904A, 0x02, REG_BITS_8},
	{0x904B, 0x08, REG_BITS_8},
	{0x904C, 0x04, REG_BITS_8},
	{0x904D, 0x30, REG_BITS_8},
	{0x904E, 0x20, REG_BITS_8},
	{0x904F, 0xc0, REG_BITS_8},
	{0x9050, 0x80, REG_BITS_8},
	{0x9051, 0x00, REG_BITS_8},
	{0x9052, 0x03, REG_BITS_8},
	{0x9053, 0x01, REG_BITS_8},
	{0x9054, 0x08, REG_BITS_8},
	{0x9055, 0x04, REG_BITS_8},
	{0x9056, 0x20, REG_BITS_8},
	{0x9057, 0x00, REG_BITS_8},
	{0x9058, 0x60, REG_BITS_8},
	{0x9059, 0x80, REG_BITS_8},
	{0x905A, 0x00, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x01, REG_BITS_8},
	{0x905D, 0x02, REG_BITS_8},
	{0x905E, 0x04, REG_BITS_8},
	{0x905F, 0x10, REG_BITS_8},
	{0x9060, 0x00, REG_BITS_8},
	{0x9061, 0x60, REG_BITS_8},
	{0x9062, 0x00, REG_BITS_8},
	{0x9063, 0x80, REG_BITS_8},
	{0x9064, 0x02, REG_BITS_8},
	{0x9065, 0x00, REG_BITS_8},
	{0x9066, 0x0a, REG_BITS_8},
	{0x9067, 0x08, REG_BITS_8},
	{0x9068, 0x18, REG_BITS_8},
	{0x9069, 0x20, REG_BITS_8},
	{0x906A, 0x60, REG_BITS_8},
	{0x906B, 0x80, REG_BITS_8},
	{0x906C, 0x00, REG_BITS_8},
	{0x906D, 0x01, REG_BITS_8},
	{0x906E, 0x02, REG_BITS_8},
	{0x906F, 0x00, REG_BITS_8},
	{0x9070, 0x08, REG_BITS_8},
	{0x9071, 0x00, REG_BITS_8},
	{0x9072, 0x10, REG_BITS_8},
	{0x9073, 0x20, REG_BITS_8},
	{0x9074, 0xc0, REG_BITS_8},
	{0x9075, 0xff, REG_BITS_8},
	{0x9076, 0x00, REG_BITS_8},
	{0x9077, 0x01, REG_BITS_8},
	{0x9078, 0x08, REG_BITS_8},
	{0x9079, 0x04, REG_BITS_8},
	{0x907A, 0x20, REG_BITS_8},
	{0x907B, 0x30, REG_BITS_8},
	{0x907C, 0x40, REG_BITS_8},
	{0x907D, 0xc0, REG_BITS_8},
	{0x907E, 0x00, REG_BITS_8},
	{0x907F, 0x01, REG_BITS_8},
	{0x9080, 0x02, REG_BITS_8},
	{0x9081, 0x02, REG_BITS_8},
	{0x9082, 0x04, REG_BITS_8},
	{0x9083, 0xf8, REG_BITS_8},
	{0x9084, 0x1f, REG_BITS_8},
	{0x9085, 0xe0, REG_BITS_8},
	{0x9086, 0x7f, REG_BITS_8},
	{0x9087, 0x80, REG_BITS_8},
	{0x9088, 0xff, REG_BITS_8},
	{0x9089, 0x00, REG_BITS_8},
	{0x908A, 0x02, REG_BITS_8},
	{0x908B, 0x04, REG_BITS_8},
	{0x908C, 0x10, REG_BITS_8},
	{0x908D, 0x10, REG_BITS_8},
	{0x908E, 0x40, REG_BITS_8},
	{0x908F, 0xc0, REG_BITS_8},
	{0x9090, 0x7f, REG_BITS_8},
	{0x9091, 0x01, REG_BITS_8},
	{0x9092, 0xff, REG_BITS_8},
	{0x9093, 0x05, REG_BITS_8},
	{0x9094, 0x08, REG_BITS_8},
	{0x9095, 0x08, REG_BITS_8},
	{0x9096, 0x30, REG_BITS_8},
	{0x9097, 0x00, REG_BITS_8},
	{0x9098, 0x80, REG_BITS_8},
	{0x9099, 0x00, REG_BITS_8},
	{0x909A, 0xff, REG_BITS_8},
	{0x909B, 0x02, REG_BITS_8},
	{0x909C, 0x00, REG_BITS_8},
	{0x909D, 0xfc, REG_BITS_8},
	{0x909E, 0x0f, REG_BITS_8},
	{0x909F, 0x30, REG_BITS_8},
	{0x90A0, 0x20, REG_BITS_8},
	{0x90A1, 0xc0, REG_BITS_8},
	{0x90A2, 0x80, REG_BITS_8},
	{0x90A3, 0x00, REG_BITS_8},
	{0x90A4, 0x00, REG_BITS_8},
	{0x90A5, 0x04, REG_BITS_8},
	{0x90A6, 0x00, REG_BITS_8},
	{0x90A7, 0x10, REG_BITS_8},
	{0x90A8, 0x00, REG_BITS_8},
	{0x90A9, 0x20, REG_BITS_8},
	{0x90AA, 0xc0, REG_BITS_8},
	{0x90AB, 0x00, REG_BITS_8},
	{0x90AC, 0x00, REG_BITS_8},
	{0x90AD, 0x01, REG_BITS_8},
	{0x90AE, 0x00, REG_BITS_8},
	{0x90AF, 0x0c, REG_BITS_8},
	{0x90B0, 0x00, REG_BITS_8},
	{0x90B1, 0x30, REG_BITS_8},
	{0x90B2, 0x20, REG_BITS_8},
	{0x90B3, 0x00, REG_BITS_8},
	{0x90B4, 0x00, REG_BITS_8},
	{0x90B5, 0x01, REG_BITS_8},
	{0x90B6, 0x00, REG_BITS_8},
	{0x90B7, 0x04, REG_BITS_8},
	{0x90B8, 0x00, REG_BITS_8},
	{0x90B9, 0x10, REG_BITS_8},
	{0x90BA, 0x00, REG_BITS_8},
	{0x90BB, 0x40, REG_BITS_8},
	{0x90BC, 0x40, REG_BITS_8},
	{0x90BD, 0x00, REG_BITS_8},
	{0x90BE, 0x01, REG_BITS_8},
	{0x90BF, 0x02, REG_BITS_8},
	{0x90C0, 0x04, REG_BITS_8},
	{0x90C1, 0x10, REG_BITS_8},
	{0x90C2, 0x08, REG_BITS_8},
	{0x90C3, 0x20, REG_BITS_8},
	{0x90C4, 0x20, REG_BITS_8},
	{0x90C5, 0x00, REG_BITS_8},
	{0x90C6, 0x81, REG_BITS_8},
	{0x90C7, 0x01, REG_BITS_8},
	{0x90C8, 0x02, REG_BITS_8},
	{0x90C9, 0x04, REG_BITS_8},
	{0x90CA, 0x08, REG_BITS_8},
	{0x90CB, 0x10, REG_BITS_8},
	{0x90CC, 0x00, REG_BITS_8},
	{0x90CD, 0x20, REG_BITS_8},
	{0x90CE, 0x00, REG_BITS_8},
	{0x90CF, 0x80, REG_BITS_8},
	{0x90D0, 0x00, REG_BITS_8},
	{0x90D1, 0x02, REG_BITS_8},
	{0x90D2, 0x02, REG_BITS_8},
	{0x90D3, 0x04, REG_BITS_8},
	{0x90D4, 0x08, REG_BITS_8},
	{0x90D5, 0x30, REG_BITS_8},
	{0x90D6, 0x40, REG_BITS_8},
	{0x90D7, 0xc0, REG_BITS_8},
	{0x90D8, 0x00, REG_BITS_8},
	{0x90D9, 0x01, REG_BITS_8},
	{0x90DA, 0x03, REG_BITS_8},
	{0x90DB, 0x06, REG_BITS_8},
	{0x90DC, 0x04, REG_BITS_8},
	{0x90DD, 0x08, REG_BITS_8},
	{0x90DE, 0x10, REG_BITS_8},
	{0x90DF, 0x20, REG_BITS_8},
	{0x90E0, 0x00, REG_BITS_8},
	{0x90E1, 0x80, REG_BITS_8},
	{0x90E2, 0x00, REG_BITS_8},
	{0x90E3, 0x00, REG_BITS_8},
	{0x90E4, 0x02, REG_BITS_8},
	{0x90E5, 0x08, REG_BITS_8},
	{0x90E6, 0x08, REG_BITS_8},
	{0x90E7, 0x10, REG_BITS_8},
	{0x90E8, 0x20, REG_BITS_8},
	{0x90E9, 0xc0, REG_BITS_8},
	{0x90EA, 0x00, REG_BITS_8},
	{0x90EB, 0x01, REG_BITS_8},
	{0x90EC, 0x03, REG_BITS_8},
	{0x90ED, 0x04, REG_BITS_8},
	{0x90EE, 0x0c, REG_BITS_8},
	{0x90EF, 0x18, REG_BITS_8},
	{0x90F0, 0x10, REG_BITS_8},
	{0x90F1, 0x20, REG_BITS_8},
	{0x90F2, 0x40, REG_BITS_8},
	{0x90F3, 0x80, REG_BITS_8},
	{0x90F4, 0x00, REG_BITS_8},
	{0x90F5, 0x01, REG_BITS_8},
	{0x90F6, 0xf6, REG_BITS_8},
	{0x90F7, 0x07, REG_BITS_8},
	{0x90F8, 0xd8, REG_BITS_8},
	{0x90F9, 0x1f, REG_BITS_8},
	{0x90FA, 0x80, REG_BITS_8},
	{0x90FB, 0x3f, REG_BITS_8},
	{0x90FC, 0x80, REG_BITS_8},
	{0x90FD, 0xfa, REG_BITS_8},
	{0x90FE, 0x00, REG_BITS_8},
	{0x90FF, 0xf0, REG_BITS_8},
	{0x9100, 0xfb, REG_BITS_8},
	{0x9101, 0xcf, REG_BITS_8},
	{0x9102, 0xff, REG_BITS_8},
	{0x9103, 0x1f, REG_BITS_8},
	{0x9104, 0x3f, REG_BITS_8},
	{0x9105, 0x00, REG_BITS_8},
	{0x9106, 0xfd, REG_BITS_8},
	{0x9107, 0x00, REG_BITS_8},
	{0x9108, 0xf4, REG_BITS_8},
	{0x9109, 0x07, REG_BITS_8},
	{0x910A, 0xd8, REG_BITS_8},
	{0x910B, 0x1f, REG_BITS_8},
	{0x910C, 0x60, REG_BITS_8},
	{0x910D, 0x7f, REG_BITS_8},
	{0x910E, 0x00, REG_BITS_8},
	{0x910F, 0xfe, REG_BITS_8},
	{0x9110, 0x00, REG_BITS_8},
	{0x9111, 0xea, REG_BITS_8},
	{0x9112, 0x03, REG_BITS_8},
	{0x9113, 0xc0, REG_BITS_8},
	{0x9114, 0xef, REG_BITS_8},
	{0x9115, 0x3f, REG_BITS_8},
	{0x9116, 0xff, REG_BITS_8},
	{0x9117, 0x7f, REG_BITS_8},
	{0x9118, 0xfc, REG_BITS_8},
	{0x9119, 0x00, REG_BITS_8},
	{0x911A, 0xf4, REG_BITS_8},
	{0x911B, 0x03, REG_BITS_8},
	{0x911C, 0xd0, REG_BITS_8},
	{0x911D, 0x1f, REG_BITS_8},
	{0x911E, 0x20, REG_BITS_8},
	{0x911F, 0x7f, REG_BITS_8},
	{0x9120, 0x80, REG_BITS_8},
	{0x9121, 0xfc, REG_BITS_8},
	{0x9122, 0x01, REG_BITS_8},
	{0x9123, 0xec, REG_BITS_8},
	{0x9124, 0xff, REG_BITS_8},
	{0x9125, 0xcf, REG_BITS_8},
	{0x9126, 0xff, REG_BITS_8},
	{0x9127, 0xbf, REG_BITS_8},
	{0x9128, 0x3e, REG_BITS_8},
	{0x9129, 0x00, REG_BITS_8},
	{0x912A, 0xfb, REG_BITS_8},
	{0x912B, 0xff, REG_BITS_8},
	{0x912C, 0xf1, REG_BITS_8},
	{0x912D, 0x03, REG_BITS_8},
	{0x912E, 0xe0, REG_BITS_8},
	{0x912F, 0x0f, REG_BITS_8},
	{0x9130, 0x80, REG_BITS_8},
	{0x9131, 0xbf, REG_BITS_8},
	{0x9132, 0x80, REG_BITS_8},
	{0x9133, 0xfe, REG_BITS_8},
	{0x9134, 0x02, REG_BITS_8},
	{0x9135, 0xfa, REG_BITS_8},
	{0x9136, 0x03, REG_BITS_8},
	{0x9137, 0xe0, REG_BITS_8},
	{0x9138, 0xef, REG_BITS_8},
	{0x9139, 0x5f, REG_BITS_8},
	{0x913A, 0xbf, REG_BITS_8},
	{0x913B, 0x7f, REG_BITS_8},
	{0x913C, 0xfd, REG_BITS_8},
	{0x913D, 0xfe, REG_BITS_8},
	{0x913E, 0xf7, REG_BITS_8},
	{0x913F, 0xfb, REG_BITS_8},
	{0x9140, 0xdf, REG_BITS_8},
	{0x9141, 0xef, REG_BITS_8},
	{0x9142, 0x5f, REG_BITS_8},
	{0x9143, 0xbf, REG_BITS_8},
	{0x9144, 0x7f, REG_BITS_8},
	{0x9145, 0xfd, REG_BITS_8},
	{0x9146, 0x02, REG_BITS_8},
	{0x9147, 0xf8, REG_BITS_8},
	{0x9148, 0x0b, REG_BITS_8},
	{0x9149, 0xe0, REG_BITS_8},
	{0x914A, 0x0f, REG_BITS_8},
	{0x914B, 0x80, REG_BITS_8},
	{0x914C, 0xff, REG_BITS_8},
	{0x914D, 0xff, REG_BITS_8},
	{0x914E, 0xfd, REG_BITS_8},
	{0x914F, 0xfe, REG_BITS_8},
	{0x9150, 0xf5, REG_BITS_8},
	{0x9151, 0xf7, REG_BITS_8},
	{0x9152, 0xdf, REG_BITS_8},
	{0x9153, 0xef, REG_BITS_8},
	{0x9154, 0x7f, REG_BITS_8},
	{0x9155, 0xbf, REG_BITS_8},
	{0x9156, 0xff, REG_BITS_8},
	{0x9157, 0xff, REG_BITS_8},
	{0x9158, 0xfe, REG_BITS_8},
	{0x9159, 0xff, REG_BITS_8},
	{0x915A, 0x0f, REG_BITS_8},
	{0x915B, 0xe0, REG_BITS_8},
	{0x915C, 0x3f, REG_BITS_8},
	{0x915D, 0x80, REG_BITS_8},
	{0x915E, 0x3f, REG_BITS_8},
	{0x915F, 0x00, REG_BITS_8},
	{0x9160, 0xfe, REG_BITS_8},
	{0x9161, 0x00, REG_BITS_8},
	{0x9162, 0xfc, REG_BITS_8},
	{0x9163, 0xff, REG_BITS_8},
	{0x9164, 0xef, REG_BITS_8},
	{0x9165, 0xef, REG_BITS_8},
	{0x9166, 0xdf, REG_BITS_8},
	{0x9167, 0xff, REG_BITS_8},
	{0x9168, 0xff, REG_BITS_8},
	{0x9169, 0xfe, REG_BITS_8},
	{0x916A, 0xff, REG_BITS_8},
	{0x916B, 0x01, REG_BITS_8},
	{0x916C, 0xfc, REG_BITS_8},
	{0x916D, 0x07, REG_BITS_8},
	{0x916E, 0x50, REG_BITS_8},
	{0x916F, 0x20, REG_BITS_8},
	{0x9170, 0x40, REG_BITS_8},
	{0x9171, 0x81, REG_BITS_8},
	{0x9172, 0x00, REG_BITS_8},
	{0x9173, 0x01, REG_BITS_8},
	{0x9174, 0x00, REG_BITS_8},
	{0x9175, 0x04, REG_BITS_8},
	{0x9176, 0x00, REG_BITS_8},
	{0x9177, 0x10, REG_BITS_8},
	{0x9178, 0x20, REG_BITS_8},
	{0x9179, 0x40, REG_BITS_8},
	{0x917A, 0x00, REG_BITS_8},
	{0x917B, 0x00, REG_BITS_8},
	{0x917C, 0x00, REG_BITS_8},
	{0x917D, 0x00, REG_BITS_8},
	{0x917E, 0x04, REG_BITS_8},
	{0x917F, 0xf0, REG_BITS_8},
	{0x9180, 0x1f, REG_BITS_8},
	{0x9181, 0xc0, REG_BITS_8},
	{0x9182, 0xff, REG_BITS_8},
	{0x9183, 0x01, REG_BITS_8},
	{0x9184, 0x01, REG_BITS_8},
	{0x9185, 0x07, REG_BITS_8},
	{0x9186, 0x04, REG_BITS_8},
	{0x9187, 0x10, REG_BITS_8},
	{0x9188, 0x18, REG_BITS_8},
	{0x9189, 0x20, REG_BITS_8},
	{0x918A, 0x80, REG_BITS_8},
	{0x918B, 0x40, REG_BITS_8},
	{0x918C, 0x00, REG_BITS_8},
	{0x918D, 0x02, REG_BITS_8},
	{0x918E, 0x00, REG_BITS_8},
	{0x918F, 0x0a, REG_BITS_8},
	{0x9190, 0x00, REG_BITS_8},
	{0x9191, 0x20, REG_BITS_8},
	{0x9192, 0x20, REG_BITS_8},
	{0x9193, 0x00, REG_BITS_8},
	{0x9194, 0x81, REG_BITS_8},
	{0x9195, 0x00, REG_BITS_8},
	{0x9196, 0x04, REG_BITS_8},
	{0x9197, 0x06, REG_BITS_8},
	{0x9198, 0x0c, REG_BITS_8},
	{0x9199, 0x18, REG_BITS_8},
	{0x919A, 0x30, REG_BITS_8},
	{0x919B, 0x60, REG_BITS_8},
	{0x919C, 0x80, REG_BITS_8},
	{0x919D, 0xc0, REG_BITS_8},
	{0x919E, 0x80, REG_BITS_8},
	{0x919F, 0x01, REG_BITS_8},
	{0x91A0, 0x01, REG_BITS_8},
	{0x91A1, 0x0c, REG_BITS_8},
	{0x91A2, 0x04, REG_BITS_8},
	{0x91A3, 0x38, REG_BITS_8},
	{0x91A4, 0x20, REG_BITS_8},
	{0x91A5, 0xe0, REG_BITS_8},
	{0x91A6, 0x80, REG_BITS_8},
	{0x91A7, 0x00, REG_BITS_8},
	{0x91A8, 0x03, REG_BITS_8},
	{0x91A9, 0x02, REG_BITS_8},
	{0x91AA, 0x0c, REG_BITS_8},
	{0x91AB, 0x18, REG_BITS_8},
	{0x91AC, 0x30, REG_BITS_8},
	{0x91AD, 0x60, REG_BITS_8},
	{0x91AE, 0xc0, REG_BITS_8},
	{0x91AF, 0x00, REG_BITS_8},
	{0x91B0, 0x81, REG_BITS_8},
	{0x91B1, 0x02, REG_BITS_8},
	{0x91B2, 0x02, REG_BITS_8},
	{0x91B3, 0x0e, REG_BITS_8},
	{0x91B4, 0x0c, REG_BITS_8},
	{0x91B5, 0x30, REG_BITS_8},
	{0x91B6, 0x30, REG_BITS_8},
	{0x91B7, 0xe0, REG_BITS_8},
	{0x91B8, 0x80, REG_BITS_8},
	{0x91B9, 0x00, REG_BITS_8},
	{0x91BA, 0x05, REG_BITS_8},
	{0x91BB, 0x02, REG_BITS_8},
	{0x91BC, 0x14, REG_BITS_8},
	{0x91BD, 0x08, REG_BITS_8},
	{0x91BE, 0x50, REG_BITS_8},
	{0x91BF, 0x30, REG_BITS_8},
	{0x91C0, 0x20, REG_BITS_8},
	{0x91C1, 0xc1, REG_BITS_8},
	{0x91C2, 0x80, REG_BITS_8},
	{0x91C3, 0x04, REG_BITS_8},
	{0x91C4, 0x05, REG_BITS_8},
	{0x91C5, 0x0c, REG_BITS_8},
	{0x91C6, 0x0c, REG_BITS_8},
	{0x91C7, 0x38, REG_BITS_8},
	{0x91C8, 0x30, REG_BITS_8},
	{0x91C9, 0x40, REG_BITS_8},
	{0x91CA, 0x81, REG_BITS_8},
	{0x91CB, 0x00, REG_BITS_8},
	{0x91CC, 0x04, REG_BITS_8},
	{0x91CD, 0x02, REG_BITS_8},
	{0x91CE, 0x10, REG_BITS_8},
	{0x91CF, 0x0c, REG_BITS_8},
	{0x91D0, 0x38, REG_BITS_8},
	{0x91D1, 0x30, REG_BITS_8},
	{0x91D2, 0xe0, REG_BITS_8},
	{0x91D3, 0xc0, REG_BITS_8},
	{0x91D4, 0x80, REG_BITS_8},
	{0x91D5, 0x04, REG_BITS_8},
	{0x91D6, 0x03, REG_BITS_8},
	{0x91D7, 0x12, REG_BITS_8},
	{0x91D8, 0x14, REG_BITS_8},
	{0x91D9, 0x30, REG_BITS_8},
	{0x91DA, 0x30, REG_BITS_8},
	{0x91DB, 0xe0, REG_BITS_8},
	{0x91DC, 0xc0, REG_BITS_8},
	{0x91DD, 0x00, REG_BITS_8},
	{0x91DE, 0x05, REG_BITS_8},
	{0x91DF, 0x02, REG_BITS_8},
	{0x91E0, 0x10, REG_BITS_8},
	{0x91E1, 0x08, REG_BITS_8},
	{0x91E2, 0x40, REG_BITS_8},
	{0x91E3, 0x30, REG_BITS_8},
	{0x91E4, 0xe0, REG_BITS_8},
	{0x91E5, 0xc0, REG_BITS_8},
	{0x91E6, 0x80, REG_BITS_8},
	{0x91E7, 0x03, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0xf9, REG_BITS_8},
	{0xA003, 0x59, REG_BITS_8},
	{0xA004, 0xd3, REG_BITS_8},
	{0xA005, 0x7c, REG_BITS_8},
	{0xA006, 0xd2, REG_BITS_8},
	{0xA007, 0x24, REG_BITS_8},
	{0xA008, 0x1e, REG_BITS_8},
	{0xA009, 0x2d, REG_BITS_8},
	{0xA00A, 0x49, REG_BITS_8},
	{0xA00B, 0x27, REG_BITS_8},
	{0xA00C, 0x48, REG_BITS_8},
	{0xA00D, 0xcf, REG_BITS_8},
	{0xA00E, 0xb9, REG_BITS_8},
	{0xA00F, 0xd1, REG_BITS_8},
	{0xA010, 0x74, REG_BITS_8},
	{0xA011, 0x7a, REG_BITS_8},
	{0xA012, 0x44, REG_BITS_8},
	{0xA013, 0x1e, REG_BITS_8},
	{0xA014, 0x27, REG_BITS_8},
	{0xA015, 0xd5, REG_BITS_8},
	{0xA016, 0xe7, REG_BITS_8},
	{0xA017, 0x4c, REG_BITS_8},
	{0xA018, 0xfb, REG_BITS_8},
	{0xA019, 0x81, REG_BITS_8},
	{0xA01A, 0x53, REG_BITS_8},
	{0xA01B, 0x7e, REG_BITS_8},
	{0xA01C, 0xd6, REG_BITS_8},
	{0xA01D, 0x94, REG_BITS_8},
	{0xA01E, 0x1e, REG_BITS_8},
	{0xA01F, 0x2c, REG_BITS_8},
	{0xA020, 0x4d, REG_BITS_8},
	{0xA021, 0xe7, REG_BITS_8},
	{0xA022, 0x47, REG_BITS_8},
	{0xA023, 0xc0, REG_BITS_8},
	{0xA024, 0x19, REG_BITS_8},
	{0xA025, 0xd1, REG_BITS_8},
	{0xA026, 0x6e, REG_BITS_8},
	{0xA027, 0x2c, REG_BITS_8},
	{0xA028, 0xf4, REG_BITS_8},
	{0xA029, 0x1b, REG_BITS_8},
	{0xA02A, 0x0e, REG_BITS_8},
	{0xA02B, 0x4d, REG_BITS_8},
	{0xA02C, 0x87, REG_BITS_8},
	{0xA02D, 0x46, REG_BITS_8},
	{0xA02E, 0xe9, REG_BITS_8},
	{0xA02F, 0xa1, REG_BITS_8},
	{0xA030, 0x92, REG_BITS_8},
	{0xA031, 0x7d, REG_BITS_8},
	{0xA032, 0xd2, REG_BITS_8},
	{0xA033, 0x34, REG_BITS_8},
	{0xA034, 0x1d, REG_BITS_8},
	{0xA035, 0x1a, REG_BITS_8},
	{0xA036, 0x01, REG_BITS_8},
	{0xA037, 0xe7, REG_BITS_8},
	{0xA038, 0x42, REG_BITS_8},
	{0xA039, 0xa2, REG_BITS_8},
	{0xA03A, 0x71, REG_BITS_8},
	{0xA03B, 0xcf, REG_BITS_8},
	{0xA03C, 0x62, REG_BITS_8},
	{0xA03D, 0x9c, REG_BITS_8},
	{0xA03E, 0xf3, REG_BITS_8},
	{0xA03F, 0x97, REG_BITS_8},
	{0xA040, 0xdd, REG_BITS_8},
	{0xA041, 0x20, REG_BITS_8},
	{0xA042, 0xc6, REG_BITS_8},
	{0xA043, 0x38, REG_BITS_8},
	{0xA044, 0x9c, REG_BITS_8},
	{0xA045, 0x31, REG_BITS_8},
	{0xA046, 0x0f, REG_BITS_8},
	{0xA047, 0x6f, REG_BITS_8},
	{0xA048, 0x24, REG_BITS_8},
	{0xA049, 0x04, REG_BITS_8},
	{0xA04A, 0x1d, REG_BITS_8},
	{0xA04B, 0x18, REG_BITS_8},
	{0xA04C, 0xcd, REG_BITS_8},
	{0xA04D, 0xa6, REG_BITS_8},
	{0xA04E, 0x3f, REG_BITS_8},
	{0xA04F, 0x9c, REG_BITS_8},
	{0xA050, 0xe1, REG_BITS_8},
	{0xA051, 0x0e, REG_BITS_8},
	{0xA052, 0x5c, REG_BITS_8},
	{0xA053, 0x42, REG_BITS_8},
	{0xA054, 0x43, REG_BITS_8},
	{0xA055, 0x95, REG_BITS_8},
	{0xA056, 0xbb, REG_BITS_8},
	{0xA057, 0x14, REG_BITS_8},
	{0xA058, 0x45, REG_BITS_8},
	{0xA059, 0x2c, REG_BITS_8},
	{0xA05A, 0x4e, REG_BITS_8},
	{0xA05B, 0x71, REG_BITS_8},
	{0xA05C, 0x0b, REG_BITS_8},
	{0xA05D, 0x5a, REG_BITS_8},
	{0xA05E, 0x28, REG_BITS_8},
	{0xA05F, 0x43, REG_BITS_8},
	{0xA060, 0x99, REG_BITS_8},
	{0xA061, 0xe8, REG_BITS_8},
	{0xA062, 0xac, REG_BITS_8},
	{0xA063, 0x66, REG_BITS_8},
	{0xA064, 0x3e, REG_BITS_8},
	{0xA065, 0x95, REG_BITS_8},
	{0xA066, 0x91, REG_BITS_8},
	{0xA067, 0x8e, REG_BITS_8},
	{0xA068, 0x5e, REG_BITS_8},
	{0xA069, 0x54, REG_BITS_8},
	{0xA06A, 0x83, REG_BITS_8},
	{0xA06B, 0x94, REG_BITS_8},
	{0xA06C, 0xb2, REG_BITS_8},
	{0xA06D, 0xa0, REG_BITS_8},
	{0xA06E, 0xe4, REG_BITS_8},
	{0xA06F, 0x26, REG_BITS_8},
	{0xA070, 0x18, REG_BITS_8},
	{0xA071, 0x11, REG_BITS_8},
	{0xA072, 0x49, REG_BITS_8},
	{0xA073, 0x48, REG_BITS_8},
	{0xA074, 0x5c, REG_BITS_8},
	{0xA075, 0xd2, REG_BITS_8},
	{0xA076, 0x93, REG_BITS_8},
	{0xA077, 0xaa, REG_BITS_8},
	{0xA078, 0xbc, REG_BITS_8},
	{0xA079, 0x45, REG_BITS_8},
	{0xA07A, 0x33, REG_BITS_8},
	{0xA07B, 0x8c, REG_BITS_8},
	{0xA07C, 0x29, REG_BITS_8},
	{0xA07D, 0x4e, REG_BITS_8},
	{0xA07E, 0x61, REG_BITS_8},
	{0xA07F, 0x72, REG_BITS_8},
	{0xA080, 0x63, REG_BITS_8},
	{0xA081, 0x16, REG_BITS_8},
	{0xA082, 0xc6, REG_BITS_8},
	{0xA083, 0xc8, REG_BITS_8},
	{0xA084, 0x84, REG_BITS_8},
	{0xA085, 0x28, REG_BITS_8},
	{0xA086, 0x10, REG_BITS_8},
	{0xA087, 0xa9, REG_BITS_8},
	{0xA088, 0x08, REG_BITS_8},
	{0xA089, 0x40, REG_BITS_8},
	{0xA08A, 0x02, REG_BITS_8},
	{0xA08B, 0x92, REG_BITS_8},
	{0xA08C, 0x90, REG_BITS_8},
	{0xA08D, 0x86, REG_BITS_8},
	{0xA08E, 0x94, REG_BITS_8},
	{0xA08F, 0x64, REG_BITS_8},
	{0xA090, 0x26, REG_BITS_8},
	{0xA091, 0x59, REG_BITS_8},
	{0xA092, 0xd1, REG_BITS_8},
	{0xA093, 0x4b, REG_BITS_8},
	{0xA094, 0x5e, REG_BITS_8},
	{0xA095, 0x54, REG_BITS_8},
	{0xA096, 0x33, REG_BITS_8},
	{0xA097, 0x98, REG_BITS_8},
	{0xA098, 0xda, REG_BITS_8},
	{0xA099, 0x90, REG_BITS_8},
	{0xA09A, 0x05, REG_BITS_8},
	{0xA09B, 0x31, REG_BITS_8},
	{0xA09C, 0x30, REG_BITS_8},
	{0xA09D, 0x01, REG_BITS_8},
	{0xA09E, 0x8a, REG_BITS_8},
	{0xA09F, 0x43, REG_BITS_8},
	{0xA0A0, 0x22, REG_BITS_8},
	{0xA0A1, 0xf2, REG_BITS_8},
	{0xA0A2, 0x0f, REG_BITS_8},
	{0xA0A3, 0x7f, REG_BITS_8},
	{0xA0A4, 0x20, REG_BITS_8},
	{0xA0A5, 0x24, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x23, REG_BITS_8},
	{0xA0A8, 0x81, REG_BITS_8},
	{0xA0A9, 0xc9, REG_BITS_8},
	{0xA0AA, 0x55, REG_BITS_8},
	{0xA0AB, 0xe8, REG_BITS_8},
	{0xA0AC, 0x72, REG_BITS_8},
	{0xA0AD, 0x97, REG_BITS_8},
	{0xA0AE, 0xd1, REG_BITS_8},
	{0xA0AF, 0x34, REG_BITS_8},
	{0xA0B0, 0x86, REG_BITS_8},
	{0xA0B1, 0x38, REG_BITS_8},
	{0xA0B2, 0x71, REG_BITS_8},
	{0xA0B3, 0xe1, REG_BITS_8},
	{0xA0B4, 0x8c, REG_BITS_8},
	{0xA0B5, 0x50, REG_BITS_8},
	{0xA0B6, 0xae, REG_BITS_8},
	{0xA0B7, 0x22, REG_BITS_8},
	{0xA0B8, 0x12, REG_BITS_8},
	{0xA0B9, 0x95, REG_BITS_8},
	{0xA0BA, 0x48, REG_BITS_8},
	{0xA0BB, 0xa4, REG_BITS_8},
	{0xA0BC, 0x22, REG_BITS_8},
	{0xA0BD, 0x1c, REG_BITS_8},
	{0xA0BE, 0x11, REG_BITS_8},
	{0xA0BF, 0xc9, REG_BITS_8},
	{0xA0C0, 0x4d, REG_BITS_8},
	{0xA0C1, 0x92, REG_BITS_8},
	{0xA0C2, 0x82, REG_BITS_8},
	{0xA0C3, 0x96, REG_BITS_8},
	{0xA0C4, 0xc5, REG_BITS_8},
	{0xA0C5, 0x10, REG_BITS_8},
	{0xA0C6, 0x86, REG_BITS_8},
	{0xA0C7, 0x36, REG_BITS_8},
	{0xA0C8, 0xa2, REG_BITS_8},
	{0xA0C9, 0x19, REG_BITS_8},
	{0xA0CA, 0x4f, REG_BITS_8},
	{0xA0CB, 0x63, REG_BITS_8},
	{0xA0CC, 0x84, REG_BITS_8},
	{0xA0CD, 0x23, REG_BITS_8},
	{0xA0CE, 0x16, REG_BITS_8},
	{0xA0CF, 0xc3, REG_BITS_8},
	{0xA0D0, 0x1c, REG_BITS_8},
	{0xA0D1, 0x85, REG_BITS_8},
	{0xA0D2, 0x2b, REG_BITS_8},
	{0xA0D3, 0x38, REG_BITS_8},
	{0xA0D4, 0x49, REG_BITS_8},
	{0xA0D5, 0x8a, REG_BITS_8},
	{0xA0D6, 0x50, REG_BITS_8},
	{0xA0D7, 0xac, REG_BITS_8},
	{0xA0D8, 0xb2, REG_BITS_8},
	{0xA0D9, 0x95, REG_BITS_8},
	{0xA0DA, 0xbd, REG_BITS_8},
	{0xA0DB, 0x1c, REG_BITS_8},
	{0xA0DC, 0x26, REG_BITS_8},
	{0xA0DD, 0x37, REG_BITS_8},
	{0xA0DE, 0x9d, REG_BITS_8},
	{0xA0DF, 0xd1, REG_BITS_8},
	{0xA0E0, 0x0e, REG_BITS_8},
	{0xA0E1, 0x6f, REG_BITS_8},
	{0xA0E2, 0x14, REG_BITS_8},
	{0xA0E3, 0x94, REG_BITS_8},
	{0xA0E4, 0x1a, REG_BITS_8},
	{0xA0E5, 0xf7, REG_BITS_8},
	{0xA0E6, 0x30, REG_BITS_8},
	{0xA0E7, 0x66, REG_BITS_8},
	{0xA0E8, 0x38, REG_BITS_8},
	{0xA0E9, 0x77, REG_BITS_8},
	{0xA0EA, 0x29, REG_BITS_8},
	{0xA0EB, 0x0d, REG_BITS_8},
	{0xA0EC, 0x5b, REG_BITS_8},
	{0xA0ED, 0x26, REG_BITS_8},
	{0xA0EE, 0x43, REG_BITS_8},
	{0xA0EF, 0x17, REG_BITS_8},
	{0xA0F0, 0xd0, REG_BITS_8},
	{0xA0F1, 0x24, REG_BITS_8},
	{0xA0F2, 0x26, REG_BITS_8},
	{0xA0F3, 0x38, REG_BITS_8},
	{0xA0F4, 0xa9, REG_BITS_8},
	{0xA0F5, 0x69, REG_BITS_8},
	{0xA0F6, 0x0f, REG_BITS_8},
	{0xA0F7, 0x6f, REG_BITS_8},
	{0xA0F8, 0x10, REG_BITS_8},
	{0xA0F9, 0x74, REG_BITS_8},
	{0xA0FA, 0x1e, REG_BITS_8},
	{0xA0FB, 0x20, REG_BITS_8},
	{0xA0FC, 0x39, REG_BITS_8},
	{0xA0FD, 0xe7, REG_BITS_8},
	{0xA0FE, 0x43, REG_BITS_8},
	{0xA0FF, 0xb6, REG_BITS_8},
	{0xA100, 0xf9, REG_BITS_8},
	{0xA101, 0xcf, REG_BITS_8},
	{0xA102, 0x68, REG_BITS_8},
	{0xA103, 0xcc, REG_BITS_8},
	{0xA104, 0x03, REG_BITS_8},
	{0xA105, 0x1a, REG_BITS_8},
	{0xA106, 0xf1, REG_BITS_8},
	{0xA107, 0x90, REG_BITS_8},
	{0xA108, 0x26, REG_BITS_8},
	{0xA109, 0x3d, REG_BITS_8},
	{0xA10A, 0xb8, REG_BITS_8},
	{0xA10B, 0x39, REG_BITS_8},
	{0xA10C, 0xd0, REG_BITS_8},
	{0xA10D, 0x73, REG_BITS_8},
	{0xA10E, 0x46, REG_BITS_8},
	{0xA10F, 0x14, REG_BITS_8},
	{0xA110, 0x9e, REG_BITS_8},
	{0xA111, 0x1c, REG_BITS_8},
	{0xA112, 0xdd, REG_BITS_8},
	{0xA113, 0xc7, REG_BITS_8},
	{0xA114, 0x4a, REG_BITS_8},
	{0xA115, 0xde, REG_BITS_8},
	{0xA116, 0xb9, REG_BITS_8},
	{0xA117, 0x51, REG_BITS_8},
	{0xA118, 0x70, REG_BITS_8},
	{0xA119, 0x24, REG_BITS_8},
	{0xA11A, 0xf4, REG_BITS_8},
	{0xA11B, 0x9a, REG_BITS_8},
	{0xA11C, 0xfd, REG_BITS_8},
	{0xA11D, 0xb8, REG_BITS_8},
	{0xA11E, 0x86, REG_BITS_8},
	{0xA11F, 0x3f, REG_BITS_8},
	{0xA120, 0xb2, REG_BITS_8},
	{0xA121, 0x09, REG_BITS_8},
	{0xA122, 0xd0, REG_BITS_8},
	{0xA123, 0x70, REG_BITS_8},
	{0xA124, 0x34, REG_BITS_8},
	{0xA125, 0x84, REG_BITS_8},
	{0xA126, 0x9d, REG_BITS_8},
	{0xA127, 0x19, REG_BITS_8},
	{0xA128, 0xa5, REG_BITS_8},
	{0xA129, 0xa7, REG_BITS_8},
	{0xA12A, 0x48, REG_BITS_8},
	{0xA12B, 0xd4, REG_BITS_8},
	{0xA12C, 0xf9, REG_BITS_8},
	{0xA12D, 0x8f, REG_BITS_8},
	{0xA12E, 0x74, REG_BITS_8},
	{0xA12F, 0xf4, REG_BITS_8},
	{0xA130, 0x53, REG_BITS_8},
	{0xA131, 0x1c, REG_BITS_8},
	{0xA132, 0xf6, REG_BITS_8},
	{0xA133, 0xe0, REG_BITS_8},
	{0xA134, 0x26, REG_BITS_8},
	{0xA135, 0x3b, REG_BITS_8},
	{0xA136, 0xb9, REG_BITS_8},
	{0xA137, 0xb9, REG_BITS_8},
	{0xA138, 0x8e, REG_BITS_8},
	{0xA139, 0x6e, REG_BITS_8},
	{0xA13A, 0xb6, REG_BITS_8},
	{0xA13B, 0x93, REG_BITS_8},
	{0xA13C, 0x9c, REG_BITS_8},
	{0xA13D, 0xf5, REG_BITS_8},
	{0xA13E, 0x68, REG_BITS_8},
	{0xA13F, 0xa7, REG_BITS_8},
	{0xA140, 0x3f, REG_BITS_8},
	{0xA141, 0xde, REG_BITS_8},
	{0xA142, 0x19, REG_BITS_8},
	{0xA143, 0x10, REG_BITS_8},
	{0xA144, 0x75, REG_BITS_8},
	{0xA145, 0xfa, REG_BITS_8},
	{0xA146, 0x83, REG_BITS_8},
	{0xA147, 0x9c, REG_BITS_8},
	{0xA148, 0xf7, REG_BITS_8},
	{0xA149, 0xdc, REG_BITS_8},
	{0xA14A, 0x66, REG_BITS_8},
	{0xA14B, 0x3b, REG_BITS_8},
	{0xA14C, 0xa9, REG_BITS_8},
	{0xA14D, 0x31, REG_BITS_8},
	{0xA14E, 0x8e, REG_BITS_8},
	{0xA14F, 0x69, REG_BITS_8},
	{0xA150, 0x84, REG_BITS_8},
	{0xA151, 0xa3, REG_BITS_8},
	{0xA152, 0x1a, REG_BITS_8},
	{0xA153, 0xe3, REG_BITS_8},
	{0xA154, 0xec, REG_BITS_8},
	{0xA155, 0x46, REG_BITS_8},
	{0xA156, 0x3b, REG_BITS_8},
	{0xA157, 0xce, REG_BITS_8},
	{0xA158, 0x81, REG_BITS_8},
	{0xA159, 0x0f, REG_BITS_8},
	{0xA15A, 0x76, REG_BITS_8},
	{0xA15B, 0xfc, REG_BITS_8},
	{0xA15C, 0x23, REG_BITS_8},
	{0xA15D, 0x9b, REG_BITS_8},
	{0xA15E, 0xea, REG_BITS_8},
	{0xA15F, 0x8c, REG_BITS_8},
	{0xA160, 0x66, REG_BITS_8},
	{0xA161, 0x38, REG_BITS_8},
	{0xA162, 0x8c, REG_BITS_8},
	{0xA163, 0x29, REG_BITS_8},
	{0xA164, 0xcd, REG_BITS_8},
	{0xA165, 0x5e, REG_BITS_8},
	{0xA166, 0x20, REG_BITS_8},
	{0xA167, 0x23, REG_BITS_8},
	{0xA168, 0x97, REG_BITS_8},
	{0xA169, 0xc1, REG_BITS_8},
	{0xA16A, 0xf4, REG_BITS_8},
	{0xA16B, 0x85, REG_BITS_8},
	{0xA16C, 0x31, REG_BITS_8},
	{0xA16D, 0x8e, REG_BITS_8},
	{0xA16E, 0x11, REG_BITS_8},
	{0xA16F, 0xcd, REG_BITS_8},
	{0xA170, 0x69, REG_BITS_8},
	{0xA171, 0x84, REG_BITS_8},
	{0xA172, 0x73, REG_BITS_8},
	{0xA173, 0x9b, REG_BITS_8},
	{0xA174, 0xea, REG_BITS_8},
	{0xA175, 0x50, REG_BITS_8},
	{0xA176, 0x66, REG_BITS_8},
	{0xA177, 0x36, REG_BITS_8},
	{0xA178, 0x84, REG_BITS_8},
	{0xA179, 0xf9, REG_BITS_8},
	{0xA17A, 0x4c, REG_BITS_8},
	{0xA17B, 0x58, REG_BITS_8},
	{0xA17C, 0xe8, REG_BITS_8},
	{0xA17D, 0xa2, REG_BITS_8},
	{0xA17E, 0x14, REG_BITS_8},
	{0xA17F, 0xac, REG_BITS_8},
	{0xA180, 0xfc, REG_BITS_8},
	{0xA181, 0x24, REG_BITS_8},
	{0xA182, 0x29, REG_BITS_8},
	{0xA183, 0x49, REG_BITS_8},
	{0xA184, 0x99, REG_BITS_8},
	{0xA185, 0xca, REG_BITS_8},
	{0xA186, 0x57, REG_BITS_8},
	{0xA187, 0xd8, REG_BITS_8},
	{0xA188, 0x32, REG_BITS_8},
	{0xA189, 0x18, REG_BITS_8},
	{0xA18A, 0xcc, REG_BITS_8},
	{0xA18B, 0x48, REG_BITS_8},
	{0xA18C, 0xa6, REG_BITS_8},
	{0xA18D, 0x35, REG_BITS_8},
	{0xA18E, 0x7b, REG_BITS_8},
	{0xA18F, 0xa1, REG_BITS_8},
	{0xA190, 0xcc, REG_BITS_8},
	{0xA191, 0x59, REG_BITS_8},
	{0xA192, 0xf4, REG_BITS_8},
	{0xA193, 0xf2, REG_BITS_8},
	{0xA194, 0x93, REG_BITS_8},
	{0xA195, 0xa5, REG_BITS_8},
	{0xA196, 0x8c, REG_BITS_8},
	{0xA197, 0x64, REG_BITS_8},
	{0xA198, 0x25, REG_BITS_8},
	{0xA199, 0x16, REG_BITS_8},
	{0xA19A, 0xd9, REG_BITS_8},
	{0xA19B, 0x08, REG_BITS_8},
	{0xA19C, 0x48, REG_BITS_8},
	{0xA19D, 0x48, REG_BITS_8},
	{0xA19E, 0x92, REG_BITS_8},
	{0xA19F, 0x13, REG_BITS_8},
	{0xA1A0, 0xa0, REG_BITS_8},
	{0xA1A1, 0x88, REG_BITS_8},
	{0xA1A2, 0x45, REG_BITS_8},
	{0xA1A3, 0x2e, REG_BITS_8},
	{0xA1A4, 0x77, REG_BITS_8},
	{0xA1A5, 0x71, REG_BITS_8},
	{0xA1A6, 0x0c, REG_BITS_8},
	{0xA1A7, 0x5b, REG_BITS_8},
	{0xA1A8, 0x02, REG_BITS_8},
	{0xA1A9, 0x63, REG_BITS_8},
	{0xA1AA, 0x15, REG_BITS_8},
	{0xA1AB, 0xb2, REG_BITS_8},
	{0xA1AC, 0xa8, REG_BITS_8},
	{0xA1AD, 0x44, REG_BITS_8},
	{0xA1AE, 0x26, REG_BITS_8},
	{0xA1AF, 0x0d, REG_BITS_8},
	{0xA1B0, 0x89, REG_BITS_8},
	{0xA1B1, 0x08, REG_BITS_8},
	{0xA1B2, 0x40, REG_BITS_8},
	{0xA1B3, 0x02, REG_BITS_8},
	{0xA1B4, 0xa2, REG_BITS_8},
	{0xA1B5, 0x90, REG_BITS_8},
	{0xA1B6, 0x84, REG_BITS_8},
	{0xA1B7, 0x8c, REG_BITS_8},
	{0xA1B8, 0xa4, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x4e, REG_BITS_8},
	{0xA1BB, 0xc1, REG_BITS_8},
	{0xA1BC, 0x8a, REG_BITS_8},
	{0xA1BD, 0x59, REG_BITS_8},
	{0xA1BE, 0xee, REG_BITS_8},
	{0xA1BF, 0xd2, REG_BITS_8},
	{0xA1C0, 0x16, REG_BITS_8},
	{0xA1C1, 0xbf, REG_BITS_8},
	{0xA1C2, 0x54, REG_BITS_8},
	{0xA1C3, 0x25, REG_BITS_8},
	{0xA1C4, 0x2c, REG_BITS_8},
	{0xA1C5, 0x28, REG_BITS_8},
	{0xA1C6, 0x71, REG_BITS_8},
	{0xA1C7, 0xc9, REG_BITS_8},
	{0xA1C8, 0x42, REG_BITS_8},
	{0xA1C9, 0x1a, REG_BITS_8},
	{0xA1CA, 0xf2, REG_BITS_8},
	{0xA1CB, 0x0f, REG_BITS_8},
	{0xA1CC, 0x7f, REG_BITS_8},
	{0xA1CD, 0x20, REG_BITS_8},
	{0xA1CE, 0xc4, REG_BITS_8},
	{0xA1CF, 0x20, REG_BITS_8},
	{0xA1D0, 0x21, REG_BITS_8},
	{0xA1D1, 0x09, REG_BITS_8},
	{0xA1D2, 0xc9, REG_BITS_8},
	{0xA1D3, 0x52, REG_BITS_8},
	{0xA1D4, 0xa4, REG_BITS_8},
	{0xA1D5, 0x22, REG_BITS_8},
	{0xA1D6, 0x16, REG_BITS_8},
	{0xA1D7, 0xb8, REG_BITS_8},
	{0xA1D8, 0xe4, REG_BITS_8},
	{0xA1D9, 0xe5, REG_BITS_8},
	{0xA1DA, 0x30, REG_BITS_8},
	{0xA1DB, 0x63, REG_BITS_8},
	{0xA1DC, 0x69, REG_BITS_8},
	{0xA1DD, 0x4b, REG_BITS_8},
	{0xA1DE, 0x4e, REG_BITS_8},
	{0xA1DF, 0x7e, REG_BITS_8},
	{0xA1E0, 0xc2, REG_BITS_8},
	{0xA1E1, 0x91, REG_BITS_8},
	{0xA1E2, 0x8f, REG_BITS_8},
	{0xA1E3, 0x38, REG_BITS_8},
	{0xA1E4, 0x04, REG_BITS_8},
	{0xA1E5, 0x22, REG_BITS_8},
	{0xA1E6, 0x16, REG_BITS_8},
	{0xA1E7, 0xc9, REG_BITS_8},
	{0xA1E8, 0x88, REG_BITS_8},
	{0xA1E9, 0x4b, REG_BITS_8},
	{0xA1EA, 0x66, REG_BITS_8},
	{0xA1EB, 0x62, REG_BITS_8},
	{0xA1EC, 0x95, REG_BITS_8},
	{0xA1ED, 0xb1, REG_BITS_8},
	{0xA1EE, 0xa8, REG_BITS_8},
	{0xA1EF, 0xe5, REG_BITS_8},
	{0xA1F0, 0x2f, REG_BITS_8},
	{0xA1F1, 0x8a, REG_BITS_8},
	{0xA1F2, 0xe1, REG_BITS_8},
	{0xA1F3, 0x8c, REG_BITS_8},
	{0xA1F4, 0x5e, REG_BITS_8},
	{0xA1F5, 0x10, REG_BITS_8},
	{0xA1F6, 0x63, REG_BITS_8},
	{0xA1F7, 0x15, REG_BITS_8},
	{0xA1F8, 0xaf, REG_BITS_8},
	{0xA1F9, 0xf4, REG_BITS_8},
	{0xA1FA, 0x64, REG_BITS_8},
	{0xA1FB, 0x28, REG_BITS_8},
	{0xA1FC, 0x2f, REG_BITS_8},
	{0xA1FD, 0xa9, REG_BITS_8},
	{0xA1FE, 0x89, REG_BITS_8},
	{0xA1FF, 0x4d, REG_BITS_8},
	{0xA200, 0x7c, REG_BITS_8},
	{0xA201, 0xb2, REG_BITS_8},
	{0xA202, 0x94, REG_BITS_8},
	{0xA203, 0xab, REG_BITS_8},
	{0xA204, 0xb0, REG_BITS_8},
	{0xA205, 0x45, REG_BITS_8},
	{0xA206, 0x30, REG_BITS_8},
	{0xA207, 0x7b, REG_BITS_8},
	{0xA208, 0xb9, REG_BITS_8},
	{0xA209, 0x4c, REG_BITS_8},
	{0xA20A, 0x68, REG_BITS_8},
	{0xA20B, 0x6e, REG_BITS_8},
	{0xA20C, 0x13, REG_BITS_8},
	{0xA20D, 0x19, REG_BITS_8},
	{0xA20E, 0xd2, REG_BITS_8},
	{0xA20F, 0xe0, REG_BITS_8},
	{0xA210, 0x05, REG_BITS_8},
	{0xA211, 0x31, REG_BITS_8},
	{0xA212, 0x64, REG_BITS_8},
	{0xA213, 0x99, REG_BITS_8},
	{0xA214, 0x8b, REG_BITS_8},
	{0xA215, 0x56, REG_BITS_8},
	{0xA216, 0xd0, REG_BITS_8},
	{0xA217, 0x12, REG_BITS_8},
	{0xA218, 0x16, REG_BITS_8},
	{0xA219, 0xb9, REG_BITS_8},
	{0xA21A, 0xbc, REG_BITS_8},
	{0xA21B, 0xe5, REG_BITS_8},
	{0xA21C, 0x30, REG_BITS_8},
	{0xA21D, 0x85, REG_BITS_8},
	{0xA21E, 0x39, REG_BITS_8},
	{0xA21F, 0xcd, REG_BITS_8},
	{0xA220, 0x64, REG_BITS_8},
	{0xA221, 0x72, REG_BITS_8},
	{0xA222, 0x23, REG_BITS_8},
	{0xA223, 0x1c, REG_BITS_8},
	{0xA224, 0xf2, REG_BITS_8},
	{0xA225, 0xb8, REG_BITS_8},
	{0xA226, 0x86, REG_BITS_8},
	{0xA227, 0x39, REG_BITS_8},
	{0xA228, 0x9d, REG_BITS_8},
	{0xA229, 0x99, REG_BITS_8},
	{0xA22A, 0x8d, REG_BITS_8},
	{0xA22B, 0x62, REG_BITS_8},
	{0xA22C, 0x44, REG_BITS_8},
	{0xA22D, 0x73, REG_BITS_8},
	{0xA22E, 0x18, REG_BITS_8},
	{0xA22F, 0xd0, REG_BITS_8},
	{0xA230, 0x20, REG_BITS_8},
	{0xA231, 0x86, REG_BITS_8},
	{0xA232, 0x34, REG_BITS_8},
	{0xA233, 0x95, REG_BITS_8},
	{0xA234, 0xb9, REG_BITS_8},
	{0xA235, 0xcd, REG_BITS_8},
	{0xA236, 0x69, REG_BITS_8},
	{0xA237, 0x9c, REG_BITS_8},
	{0xA238, 0x33, REG_BITS_8},
	{0xA239, 0x9b, REG_BITS_8},
	{0xA23A, 0xee, REG_BITS_8},
	{0xA23B, 0x40, REG_BITS_8},
	{0xA23C, 0xc7, REG_BITS_8},
	{0xA23D, 0x3e, REG_BITS_8},
	{0xA23E, 0xbb, REG_BITS_8},
	{0xA23F, 0xe9, REG_BITS_8},
	{0xA240, 0xce, REG_BITS_8},
	{0xA241, 0x69, REG_BITS_8},
	{0xA242, 0x80, REG_BITS_8},
	{0xA243, 0x53, REG_BITS_8},
	{0xA244, 0x99, REG_BITS_8},
	{0xA245, 0xd7, REG_BITS_8},
	{0xA246, 0x4c, REG_BITS_8},
	{0xA247, 0xe6, REG_BITS_8},
	{0xA248, 0x35, REG_BITS_8},
	{0xA249, 0x93, REG_BITS_8},
	{0xA24A, 0x91, REG_BITS_8},
	{0xA24B, 0x8d, REG_BITS_8},
	{0xA24C, 0x67, REG_BITS_8},
	{0xA24D, 0x84, REG_BITS_8},
	{0xA24E, 0xf3, REG_BITS_8},
	{0xA24F, 0x9a, REG_BITS_8},
	{0xA250, 0xeb, REG_BITS_8},
	{0xA251, 0xf0, REG_BITS_8},
	{0xA252, 0x86, REG_BITS_8},
	{0xA253, 0x3c, REG_BITS_8},
	{0xA254, 0xf0, REG_BITS_8},
	{0xA255, 0xb9, REG_BITS_8},
	{0xA256, 0x8f, REG_BITS_8},
	{0xA257, 0x7d, REG_BITS_8},
	{0xA258, 0xd4, REG_BITS_8},
	{0xA259, 0x23, REG_BITS_8},
	{0xA25A, 0x1e, REG_BITS_8},
	{0xA25B, 0xf2, REG_BITS_8},
	{0xA25C, 0xc4, REG_BITS_8},
	{0xA25D, 0x47, REG_BITS_8},
	{0xA25E, 0x40, REG_BITS_8},
	{0xA25F, 0x0a, REG_BITS_8},
	{0xA260, 0xb2, REG_BITS_8},
	{0xA261, 0x8f, REG_BITS_8},
	{0xA262, 0x7c, REG_BITS_8},
	{0xA263, 0xd0, REG_BITS_8},
	{0xA264, 0x73, REG_BITS_8},
	{0xA265, 0x1d, REG_BITS_8},
	{0xA266, 0xe6, REG_BITS_8},
	{0xA267, 0x3c, REG_BITS_8},
	{0xA268, 0x47, REG_BITS_8},
	{0xA269, 0x3c, REG_BITS_8},
	{0xA26A, 0xf8, REG_BITS_8},
	{0xA26B, 0x49, REG_BITS_8},
	{0xA26C, 0x10, REG_BITS_8},
	{0xA26D, 0x76, REG_BITS_8},
	{0xA26E, 0x98, REG_BITS_8},
	{0xA26F, 0x13, REG_BITS_8},
	{0xA270, 0x9b, REG_BITS_8},
	{0xA271, 0xcb, REG_BITS_8},
	{0xA272, 0x14, REG_BITS_8},
	{0xA273, 0x06, REG_BITS_8},
	{0xA274, 0x32, REG_BITS_8},
	{0xA275, 0xa8, REG_BITS_8},
	{0xA276, 0x49, REG_BITS_8},
	{0xA277, 0x8e, REG_BITS_8},
	{0xA278, 0x78, REG_BITS_8},
	{0xA279, 0x6c, REG_BITS_8},
	{0xA27A, 0x33, REG_BITS_8},
	{0xA27B, 0x1a, REG_BITS_8},
	{0xA27C, 0xbc, REG_BITS_8},
	{0xA27D, 0x64, REG_BITS_8},
	{0xA27E, 0xc5, REG_BITS_8},
	{0xA27F, 0x28, REG_BITS_8},
	{0xA280, 0x50, REG_BITS_8},
	{0xA281, 0x61, REG_BITS_8},
	{0xA282, 0x8b, REG_BITS_8},
	{0xA283, 0x66, REG_BITS_8},
	{0xA284, 0x6e, REG_BITS_8},
	{0xA285, 0x93, REG_BITS_8},
	{0xA286, 0x99, REG_BITS_8},
	{0xA287, 0xbf, REG_BITS_8},
	{0xA288, 0x34, REG_BITS_8},
	{0xA289, 0x45, REG_BITS_8},
	{0xA28A, 0x25, REG_BITS_8},
	{0xA28B, 0x18, REG_BITS_8},
	{0xA28C, 0x11, REG_BITS_8},
	{0xA28D, 0xc9, REG_BITS_8},
	{0xA28E, 0x4f, REG_BITS_8},
	{0xA28F, 0xe8, REG_BITS_8},
	{0xA290, 0x62, REG_BITS_8},
	{0xA291, 0x19, REG_BITS_8},
	{0xA292, 0xc5, REG_BITS_8},
	{0xA293, 0xac, REG_BITS_8},
	{0xA294, 0xa5, REG_BITS_8},
	{0xA295, 0x26, REG_BITS_8},
	{0xA296, 0x11, REG_BITS_8},
	{0xA297, 0x01, REG_BITS_8},
	{0xA298, 0x48, REG_BITS_8},
	{0xA299, 0x42, REG_BITS_8},
	{0xA29A, 0x4c, REG_BITS_8},
	{0xA29B, 0xd2, REG_BITS_8},
	{0xA29C, 0x95, REG_BITS_8},
	{0xA29D, 0xc1, REG_BITS_8},
	{0xA29E, 0x28, REG_BITS_8},
	{0xA29F, 0x26, REG_BITS_8},
	{0xA2A0, 0x2d, REG_BITS_8},
	{0xA2A1, 0x33, REG_BITS_8},
	{0xA2A2, 0x79, REG_BITS_8},
	{0xA2A3, 0xc8, REG_BITS_8},
	{0xA2A4, 0x3f, REG_BITS_8},
	{0xA2A5, 0x10, REG_BITS_8},
	{0xA2A6, 0x42, REG_BITS_8},
	{0xA2A7, 0x12, REG_BITS_8},
	{0xA2A8, 0xad, REG_BITS_8},
	{0xA2A9, 0xf8, REG_BITS_8},
	{0xA2AA, 0x25, REG_BITS_8},
	{0xA2AB, 0x33, REG_BITS_8},
	{0xA2AC, 0x7c, REG_BITS_8},
	{0xA2AD, 0x39, REG_BITS_8},
	{0xA2AE, 0xca, REG_BITS_8},
	{0xA2AF, 0x48, REG_BITS_8},
	{0xA2B0, 0x20, REG_BITS_8},
	{0xA2B1, 0xb2, REG_BITS_8},
	{0xA2B2, 0x11, REG_BITS_8},
	{0xA2B3, 0x9c, REG_BITS_8},
	{0xA2B4, 0xac, REG_BITS_8},
	{0xA2B5, 0x85, REG_BITS_8},
	{0xA2B6, 0x31, REG_BITS_8},
	{0xA2B7, 0xb4, REG_BITS_8},
	{0xA2B8, 0xd9, REG_BITS_8},
	{0xA2B9, 0x4c, REG_BITS_8},
	{0xA2BA, 0x5a, REG_BITS_8},
	{0xA2BB, 0x92, REG_BITS_8},
	{0xA2BC, 0x82, REG_BITS_8},
	{0xA2BD, 0x93, REG_BITS_8},
	{0xA2BE, 0xa1, REG_BITS_8},
	{0xA2BF, 0x7c, REG_BITS_8},
	{0xA2C0, 0xe5, REG_BITS_8},
	{0xA2C1, 0x31, REG_BITS_8},
	{0xA2C2, 0xab, REG_BITS_8},
	{0xA2C3, 0x99, REG_BITS_8},
	{0xA2C4, 0x8e, REG_BITS_8},
	{0xA2C5, 0x6f, REG_BITS_8},
	{0xA2C6, 0x32, REG_BITS_8},
	{0xA2C7, 0x03, REG_BITS_8},
	{0xA2C8, 0x18, REG_BITS_8},
	{0xA2C9, 0xb8, REG_BITS_8},
	{0xA2CA, 0xe8, REG_BITS_8},
	{0xA2CB, 0x85, REG_BITS_8},
	{0xA2CC, 0x32, REG_BITS_8},
	{0xA2CD, 0xb8, REG_BITS_8},
	{0xA2CE, 0x79, REG_BITS_8},
	{0xA2CF, 0x8e, REG_BITS_8},
	{0xA2D0, 0x7e, REG_BITS_8},
	{0xA2D1, 0xc2, REG_BITS_8},
	{0xA2D2, 0x63, REG_BITS_8},
	{0xA2D3, 0x1c, REG_BITS_8},
	{0xA2D4, 0xd9, REG_BITS_8},
	{0xA2D5, 0xb8, REG_BITS_8},
	{0xA2D6, 0x46, REG_BITS_8},
	{0xA2D7, 0x36, REG_BITS_8},
	{0xA2D8, 0xc9, REG_BITS_8},
	{0xA2D9, 0xe1, REG_BITS_8},
	{0xA2DA, 0xce, REG_BITS_8},
	{0xA2DB, 0x7b, REG_BITS_8},
	{0xA2DC, 0x0a, REG_BITS_8},
	{0xA2DD, 0xd4, REG_BITS_8},
	{0xA2DE, 0x1e, REG_BITS_8},
	{0xA2DF, 0xe8, REG_BITS_8},
	{0xA2E0, 0x04, REG_BITS_8},
	{0xA2E1, 0x07, REG_BITS_8},
	{0xA2E2, 0x38, REG_BITS_8},
	{0xA2E3, 0xc3, REG_BITS_8},
	{0xA2E4, 0xa1, REG_BITS_8},
	{0xA2E5, 0x0e, REG_BITS_8},
	{0xA2E6, 0x79, REG_BITS_8},
	{0xA2E7, 0xe6, REG_BITS_8},
	{0xA2E8, 0x03, REG_BITS_8},
	{0xA2E9, 0x00, REG_BITS_8},
	{0xA2EA, 0x00, REG_BITS_8},
	{0xA2EB, 0x00, REG_BITS_8},
	{0xA2EC, 0x00, REG_BITS_8},
	{0xA2ED, 0x00, REG_BITS_8},
	{0x0060, 0x00, REG_BITS_8},
	{0x0061, 0x80, REG_BITS_8},
	{0x0062, 0x20, REG_BITS_8},
	{0x0068, 0x5F, REG_BITS_8},
	{0x0100, 0x00, REG_BITS_8},
	{0x0105, 0x40, REG_BITS_8},
	{0x01AE, 0x00, REG_BITS_8},
	{0x01B1, 0x80, REG_BITS_8},
	{0x01F8, 0x95, REG_BITS_8},
	{0x02D7, 0x10, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_period_2_ES1 =
    sizeof(seix006_vendor_1_period_2_ES1);

const struct reg_entry seix006_vendor_1_period_2_ES2[] = {
	{0x0105, 0x80, REG_BITS_8},
	{0x0387, 0x01, REG_BITS_8},
	{0x4A24, 0x1200, REG_BITS_16},
	{0x4A28, 0x0000, REG_BITS_16},
	{0x4A2C, 0xF5FF, REG_BITS_16},
	{0x4014, 0x5E0A, REG_BITS_16},
	{0x402E, 0x0A, REG_BITS_8},
	{0x4036, 0x1005, REG_BITS_16},
	{0x404D, 0xA0, REG_BITS_8},
	{0x4085, 0x04, REG_BITS_8},
	{0x409D, 0x33, REG_BITS_8},
	{0x409E, 0x2D, REG_BITS_8},
	{0x409F, 0x64, REG_BITS_8},
	{0x40A0, 0x5E, REG_BITS_8},
	{0x42C0, 0x07, REG_BITS_8},
	{0x42C1, 0x08, REG_BITS_8},
	{0x42C2, 0x07, REG_BITS_8},
	{0x42C6, 0x09, REG_BITS_8},
	{0x42C7, 0x0D, REG_BITS_8},
	{0x42C8, 0x0E, REG_BITS_8},
	{0x42C9, 0x10, REG_BITS_8},
	{0x42CA, 0x11, REG_BITS_8},
	{0x42CB, 0x10, REG_BITS_8},
	{0x42CC, 0x0E, REG_BITS_8},
	{0x42CD, 0x0D, REG_BITS_8},
	{0x42CE, 0x09, REG_BITS_8},
	{0x42CF, 0x0C, REG_BITS_8},
	{0x42D0, 0x13, REG_BITS_8},
	{0x42D1, 0x1F, REG_BITS_8},
	{0x42D2, 0x27, REG_BITS_8},
	{0x42D3, 0x33, REG_BITS_8},
	{0x42D4, 0x27, REG_BITS_8},
	{0x42D5, 0x1F, REG_BITS_8},
	{0x42D6, 0x13, REG_BITS_8},
	{0x42D7, 0x0C, REG_BITS_8},
	{0x42D8, 0x0D, REG_BITS_8},
	{0x42D9, 0x1F, REG_BITS_8},
	{0x42DA, 0x47, REG_BITS_8},
	{0x42DB, 0x4E, REG_BITS_8},
	{0x42DC, 0x56, REG_BITS_8},
	{0x42DD, 0x4E, REG_BITS_8},
	{0x42DE, 0x47, REG_BITS_8},
	{0x42DF, 0x1F, REG_BITS_8},
	{0x42E0, 0x0D, REG_BITS_8},
	{0x42E1, 0x0E, REG_BITS_8},
	{0x42E2, 0x2A, REG_BITS_8},
	{0x42E3, 0x4D, REG_BITS_8},
	{0x42E4, 0x5A, REG_BITS_8},
	{0x42E6, 0x5A, REG_BITS_8},
	{0x42E7, 0x4D, REG_BITS_8},
	{0x42E8, 0x2A, REG_BITS_8},
	{0x42E9, 0x0E, REG_BITS_8},
	{0x42EA, 0x0D, REG_BITS_8},
	{0x42EB, 0x1F, REG_BITS_8},
	{0x42EC, 0x3B, REG_BITS_8},
	{0x42ED, 0x43, REG_BITS_8},
	{0x42EE, 0x4B, REG_BITS_8},
	{0x42EF, 0x43, REG_BITS_8},
	{0x42F0, 0x3B, REG_BITS_8},
	{0x42F1, 0x1F, REG_BITS_8},
	{0x42F2, 0x0D, REG_BITS_8},
	{0x42F3, 0x0B, REG_BITS_8},
	{0x42F4, 0x11, REG_BITS_8},
	{0x42F5, 0x14, REG_BITS_8},
	{0x42F6, 0x18, REG_BITS_8},
	{0x42F8, 0x18, REG_BITS_8},
	{0x42F9, 0x14, REG_BITS_8},
	{0x42FA, 0x11, REG_BITS_8},
	{0x42FB, 0x0B, REG_BITS_8},
	{0x0104, 0x41, REG_BITS_8},
	{0x01BD, 0x01, REG_BITS_8},
	{0x01BE, 0x02, REG_BITS_8},
	{0x01BF, 0x03, REG_BITS_8},
	{0x01C0, 0x08, REG_BITS_8},
	{0x440A, 0x0010, REG_BITS_16},
	{0x5000, 0xA6FF, REG_BITS_16},
	{0x5002, 0xF3FF, REG_BITS_16},
	{0x5004, 0xDCFF, REG_BITS_16},
	{0x5006, 0xE8FF, REG_BITS_16},
	{0x5008, 0xFFFF, REG_BITS_16},
	{0x500A, 0xCEFF, REG_BITS_16},
	{0x500C, 0x9DFF, REG_BITS_16},
	{0x500E, 0xFAFF, REG_BITS_16},
	{0x5010, 0xDCFF, REG_BITS_16},
	{0x5012, 0xEEFF, REG_BITS_16},
	{0x5014, 0x0000, REG_BITS_16},
	{0x5016, 0xC0FF, REG_BITS_16},
	{0x5018, 0xB3FF, REG_BITS_16},
	{0x501A, 0xFAFF, REG_BITS_16},
	{0x501C, 0xD2FF, REG_BITS_16},
	{0x501E, 0xF6FF, REG_BITS_16},
	{0x5020, 0xF8FF, REG_BITS_16},
	{0x5022, 0xC8FF, REG_BITS_16},
	{0x5024, 0xA9FF, REG_BITS_16},
	{0x5026, 0x0000, REG_BITS_16},
	{0x5028, 0xD3FF, REG_BITS_16},
	{0x502A, 0x0100, REG_BITS_16},
	{0x502C, 0xF4FF, REG_BITS_16},
	{0x502E, 0x73FF, REG_BITS_16},
	{0x5030, 0xA9FF, REG_BITS_16},
	{0x5032, 0x0000, REG_BITS_16},
	{0x5034, 0xD3FF, REG_BITS_16},
	{0x5036, 0x0100, REG_BITS_16},
	{0x5038, 0xF4FF, REG_BITS_16},
	{0x503A, 0x73FF, REG_BITS_16},
	{0x503C, 0x83FF, REG_BITS_16},
	{0x503E, 0xEEFF, REG_BITS_16},
	{0x5040, 0xD6FF, REG_BITS_16},
	{0x5042, 0x0000, REG_BITS_16},
	{0x5044, 0x0000, REG_BITS_16},
	{0x5046, 0xB8FF, REG_BITS_16},
	{0x5048, 0x83FF, REG_BITS_16},
	{0x504A, 0xEEFF, REG_BITS_16},
	{0x504C, 0xD6FF, REG_BITS_16},
	{0x504E, 0x0000, REG_BITS_16},
	{0x5050, 0x0000, REG_BITS_16},
	{0x5052, 0xB8FF, REG_BITS_16},
	{0x5055, 0x1C, REG_BITS_8},
	{0x5056, 0x3F, REG_BITS_8},
	{0x5057, 0x17, REG_BITS_8},
	{0x5058, 0x5D, REG_BITS_8},
	{0x505A, 0x6C, REG_BITS_8},
	{0x505B, 0x0E, REG_BITS_8},
	{0x505C, 0x95, REG_BITS_8},
	{0x505E, 0x41, REG_BITS_8},
	{0x505F, 0x12, REG_BITS_8},
	{0x5060, 0x4D, REG_BITS_8},
	{0x5061, 0x10, REG_BITS_8},
	{0x50A2, 0x48, REG_BITS_8},
	{0x50A3, 0x51, REG_BITS_8},
	{0x50A4, 0x48, REG_BITS_8},
	{0x50A5, 0x61, REG_BITS_8},
	{0x50A6, 0x48, REG_BITS_8},
	{0x50A7, 0x61, REG_BITS_8},
	{0x50A8, 0x48, REG_BITS_8},
	{0x50A9, 0x51, REG_BITS_8},
	{0x50AA, 0xF5FF, REG_BITS_16},
	{0x50AC, 0xECFF, REG_BITS_16},
	{0x50AE, 0xF5FF, REG_BITS_16},
	{0x50B0, 0xE1FF, REG_BITS_16},
	{0x50B2, 0xFAFF, REG_BITS_16},
	{0x50B4, 0xE1FF, REG_BITS_16},
	{0x50B6, 0xFAFF, REG_BITS_16},
	{0x50B8, 0xECFF, REG_BITS_16},
	{0x50BA, 0x48, REG_BITS_8},
	{0x50BB, 0x6E, REG_BITS_8},
	{0x50BC, 0x48, REG_BITS_8},
	{0x50BD, 0x73, REG_BITS_8},
	{0x50BE, 0x7C, REG_BITS_8},
	{0x50BF, 0x73, REG_BITS_8},
	{0x50C0, 0x7C, REG_BITS_8},
	{0x50C1, 0x6E, REG_BITS_8},
	{0x50C2, 0x12, REG_BITS_8},
	{0x5238, 0x0400, REG_BITS_16},
	{0x523A, 0x0800, REG_BITS_16},
	{0x523C, 0x0E00, REG_BITS_16},
	{0x523E, 0x1600, REG_BITS_16},
	{0x5240, 0x1E00, REG_BITS_16},
	{0x5242, 0x2600, REG_BITS_16},
	{0x5244, 0x2E00, REG_BITS_16},
	{0x5246, 0x3600, REG_BITS_16},
	{0x5248, 0x3D00, REG_BITS_16},
	{0x524A, 0x4300, REG_BITS_16},
	{0x524C, 0x4900, REG_BITS_16},
	{0x524E, 0x4E00, REG_BITS_16},
	{0x5250, 0x5400, REG_BITS_16},
	{0x5252, 0x5900, REG_BITS_16},
	{0x5254, 0x5E00, REG_BITS_16},
	{0x5256, 0x6300, REG_BITS_16},
	{0x5258, 0x6600, REG_BITS_16},
	{0x525A, 0x4300, REG_BITS_16},
	{0x525C, 0x8700, REG_BITS_16},
	{0x525E, 0xAF00, REG_BITS_16},
	{0x5260, 0xC800, REG_BITS_16},
	{0x5262, 0xDC00, REG_BITS_16},
	{0x5264, 0xEB00, REG_BITS_16},
	{0x5266, 0xF600, REG_BITS_16},
	{0x5268, 0x0001, REG_BITS_16},
	{0x526A, 0x0201, REG_BITS_16},
	{0x52A2, 0x1002, REG_BITS_16},
	{0x52A6, 0x1002, REG_BITS_16},
	{0x52AA, 0x1002, REG_BITS_16},
	{0x0105, 0x40, REG_BITS_8},
	{0x4E48, 0x2C1A, REG_BITS_16},
	{0x4E4C, 0x9065, REG_BITS_16},
	{0x4E4E, 0xD859, REG_BITS_16},
	{0x4E58, 0xDC1E, REG_BITS_16},
	{0x4E60, 0x0A0CC40C, REG_BITS_32},
	{0x4E64, 0xDDE01ADB, REG_BITS_32},
	{0x4E68, 0x2320C528, REG_BITS_32},
	{0x4E6C, 0x33003300, REG_BITS_32},
	{0x4E70, 0x0A0CC40C, REG_BITS_32},
	{0x4E74, 0xDDE01ADB, REG_BITS_32},
	{0x4E78, 0x2320C528, REG_BITS_32},
	{0x4E7C, 0x33003300, REG_BITS_32},
	{0x4F52, 0x00, REG_BITS_8},
	{0x4F54, 0x19, REG_BITS_8},
	{0x4F55, 0x19, REG_BITS_8},
	{0x4F56, 0x1D, REG_BITS_8},
	{0x4F59, 0x01, REG_BITS_8},
	{0x4F5A, 0x14, REG_BITS_8},
	{0x4F5B, 0x28, REG_BITS_8},
	{0x4F5C, 0x32, REG_BITS_8},
	{0x4F5D, 0x1C, REG_BITS_8},
	{0x4F60, 0x0A, REG_BITS_8},
	{0x4F6A, 0x00, REG_BITS_8},
	{0x4F6C, 0xDF63, REG_BITS_16},
	{0x4F6E, 0xDE63, REG_BITS_16},
	{0x0068, 0x5F, REG_BITS_8},
	{0x0105, 0x40, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_period_2_ES2 =
    sizeof(seix006_vendor_1_period_2_ES2);

const struct reg_entry seix006_vendor_0_period_2_ES1[] = {
	{0x4A00, 0x1001, REG_BITS_16},
	{0x4A02, 0x0000, REG_BITS_16},
	{0x4A04, 0x7010, REG_BITS_16},
	{0x4A06, 0x290F, REG_BITS_16},
	{0x4A08, 0x5001, REG_BITS_16},
	{0x4A0A, 0x6B02, REG_BITS_16},
	{0x4A0C, 0x00, REG_BITS_8},
	{0x4A0D, 0x00, REG_BITS_8},
	{0x4A0E, 0x05, REG_BITS_8},
	{0x4A10, 0xD70A, REG_BITS_16},
	{0x4A12, 0x8B17, REG_BITS_16},
	{0x4A14, 0x00, REG_BITS_8},
	{0x4A15, 0x00, REG_BITS_8},
	{0x4A16, 0x0000, REG_BITS_16},
	{0x4A18, 0x0000, REG_BITS_16},
	{0x4A1A, 0x0004, REG_BITS_16},
	{0x4A1C, 0x0004, REG_BITS_16},
	{0x4A1E, 0x0004, REG_BITS_16},
	{0x4A20, 0x0004, REG_BITS_16},
	{0x4A22, 0x0000, REG_BITS_16},
	{0x4A24, 0x1200, REG_BITS_16},
	{0x4A26, 0x0000, REG_BITS_16},
	{0x4A28, 0xF2FF, REG_BITS_16},
	{0x4A2A, 0x0000, REG_BITS_16},
	{0x4A2C, 0x0000, REG_BITS_16},
	{0x400E, 0x0024, REG_BITS_16},
	{0x4012, 0xFFFF, REG_BITS_16},
	{0x4014, 0x5B0E, REG_BITS_16},
	{0x4016, 0xBD28, REG_BITS_16},
	{0x4018, 0x9703, REG_BITS_16},
	{0x401A, 0x4005, REG_BITS_16},
	{0x401C, 0xFD03, REG_BITS_16},
	{0x401E, 0x5F02, REG_BITS_16},
	{0x4020, 0xCB02, REG_BITS_16},
	{0x4036, 0x1005, REG_BITS_16},
	{0x4039, 0x22, REG_BITS_8},
	{0x403A, 0x0A00, REG_BITS_16},
	{0x4042, 0x16, REG_BITS_8},
	{0x4043, 0x16, REG_BITS_8},
	{0x404D, 0xA0, REG_BITS_8},
	{0x404E, 0x02, REG_BITS_8},
	{0x4080, 0x64, REG_BITS_8},
	{0x4081, 0x20, REG_BITS_8},
	{0x4082, 0x35, REG_BITS_8},
	{0x4083, 0x26, REG_BITS_8},
	{0x4084, 0x05, REG_BITS_8},
	{0x4085, 0x04, REG_BITS_8},
	{0x4093, 0x03, REG_BITS_8},
	{0x4098, 0x01, REG_BITS_8},
	{0x4099, 0x10, REG_BITS_8},
	{0x409A, 0x02, REG_BITS_8},
	{0x409B, 0x64, REG_BITS_8},
	{0x409C, 0x20, REG_BITS_8},
	{0x409D, 0x0D, REG_BITS_8},
	{0x409E, 0x0B, REG_BITS_8},
	{0x42BD, 0x04, REG_BITS_8},
	{0x42BE, 0x05, REG_BITS_8},
	{0x42BF, 0x06, REG_BITS_8},
	{0x42C0, 0x07, REG_BITS_8},
	{0x42C1, 0x08, REG_BITS_8},
	{0x42C2, 0x07, REG_BITS_8},
	{0x42C3, 0x06, REG_BITS_8},
	{0x42C4, 0x05, REG_BITS_8},
	{0x42C5, 0x04, REG_BITS_8},
	{0x42C6, 0x09, REG_BITS_8},
	{0x42C7, 0x0D, REG_BITS_8},
	{0x42C8, 0x0E, REG_BITS_8},
	{0x42C9, 0x10, REG_BITS_8},
	{0x42CA, 0x11, REG_BITS_8},
	{0x42CB, 0x10, REG_BITS_8},
	{0x42CC, 0x0E, REG_BITS_8},
	{0x42CD, 0x0D, REG_BITS_8},
	{0x42CE, 0x09, REG_BITS_8},
	{0x42CF, 0x0C, REG_BITS_8},
	{0x42D0, 0x13, REG_BITS_8},
	{0x42D1, 0x1F, REG_BITS_8},
	{0x42D2, 0x27, REG_BITS_8},
	{0x42D3, 0x33, REG_BITS_8},
	{0x42D4, 0x27, REG_BITS_8},
	{0x42D5, 0x1F, REG_BITS_8},
	{0x42D6, 0x13, REG_BITS_8},
	{0x42D7, 0x0C, REG_BITS_8},
	{0x42D8, 0x0D, REG_BITS_8},
	{0x42D9, 0x1F, REG_BITS_8},
	{0x42DA, 0x47, REG_BITS_8},
	{0x42DB, 0x4E, REG_BITS_8},
	{0x42DC, 0x56, REG_BITS_8},
	{0x42DD, 0x4E, REG_BITS_8},
	{0x42DE, 0x47, REG_BITS_8},
	{0x42DF, 0x1F, REG_BITS_8},
	{0x42E0, 0x0D, REG_BITS_8},
	{0x42E1, 0x0E, REG_BITS_8},
	{0x42E2, 0x2A, REG_BITS_8},
	{0x42E3, 0x4D, REG_BITS_8},
	{0x42E4, 0x5A, REG_BITS_8},
	{0x42E5, 0x64, REG_BITS_8},
	{0x42E6, 0x5A, REG_BITS_8},
	{0x42E7, 0x4D, REG_BITS_8},
	{0x42E8, 0x2A, REG_BITS_8},
	{0x42E9, 0x0E, REG_BITS_8},
	{0x42EA, 0x0D, REG_BITS_8},
	{0x42EB, 0x1F, REG_BITS_8},
	{0x42EC, 0x3B, REG_BITS_8},
	{0x42ED, 0x43, REG_BITS_8},
	{0x42EE, 0x4B, REG_BITS_8},
	{0x42EF, 0x43, REG_BITS_8},
	{0x42F0, 0x3B, REG_BITS_8},
	{0x42F1, 0x1F, REG_BITS_8},
	{0x42F2, 0x0D, REG_BITS_8},
	{0x42F3, 0x0B, REG_BITS_8},
	{0x42F4, 0x11, REG_BITS_8},
	{0x42F5, 0x14, REG_BITS_8},
	{0x42F6, 0x18, REG_BITS_8},
	{0x42F7, 0x1C, REG_BITS_8},
	{0x42F8, 0x18, REG_BITS_8},
	{0x42F9, 0x14, REG_BITS_8},
	{0x42FA, 0x11, REG_BITS_8},
	{0x42FB, 0x0B, REG_BITS_8},
	{0x0104, 0x4D, REG_BITS_8},
	{0x01BD, 0x01, REG_BITS_8},
	{0x01BE, 0x02, REG_BITS_8},
	{0x01BF, 0x03, REG_BITS_8},
	{0x01C0, 0x08, REG_BITS_8},
	{0x02E3, 0x00, REG_BITS_8},
	{0x02E4, 0xC0, REG_BITS_8},
	{0x4400, 0x00, REG_BITS_8},
	{0x4402, 0x01, REG_BITS_8},
	{0x4403, 0x01, REG_BITS_8},
	{0x4404, 0x00, REG_BITS_8},
	{0x4405, 0x01, REG_BITS_8},
	{0x4406, 0x0A, REG_BITS_8},
	{0x4408, 0x0001, REG_BITS_16},
	{0x440A, 0x0010, REG_BITS_16},
	{0x440C, 0x20, REG_BITS_8},
	{0x440D, 0x20, REG_BITS_8},
	{0x440E, 0x20, REG_BITS_8},
	{0x440F, 0x20, REG_BITS_8},
	{0x4410, 0x04, REG_BITS_8},
	{0x4411, 0x04, REG_BITS_8},
	{0x4412, 0x04, REG_BITS_8},
	{0x4413, 0x04, REG_BITS_8},
	{0x4414, 0x20, REG_BITS_8},
	{0x4415, 0x20, REG_BITS_8},
	{0x4416, 0x20, REG_BITS_8},
	{0x4417, 0x20, REG_BITS_8},
	{0x4418, 0x04, REG_BITS_8},
	{0x4419, 0x04, REG_BITS_8},
	{0x441A, 0x04, REG_BITS_8},
	{0x441B, 0x04, REG_BITS_8},
	{0x441C, 0x01, REG_BITS_8},
	{0x441D, 0x01, REG_BITS_8},
	{0x441E, 0x01, REG_BITS_8},
	{0x441F, 0x01, REG_BITS_8},
	{0x4420, 0x00, REG_BITS_8},
	{0x4421, 0x04, REG_BITS_8},
	{0x4422, 0x10, REG_BITS_8},
	{0x4423, 0x01, REG_BITS_8},
	{0x4424, 0x02, REG_BITS_8},
	{0x4425, 0x02, REG_BITS_8},
	{0x4426, 0xFFFF, REG_BITS_16},
	{0x4428, 0xFFFF, REG_BITS_16},
	{0x442A, 0x2D0D, REG_BITS_16},
	{0x442C, 0xF613, REG_BITS_16},
	{0x442E, 0xBC0B, REG_BITS_16},
	{0x4430, 0x7517, REG_BITS_16},
	{0x4432, 0x0010, REG_BITS_16},
	{0x4434, 0x0010, REG_BITS_16},
	{0x4436, 0x810B, REG_BITS_16},
	{0x4438, 0x3218, REG_BITS_16},
	{0x443A, 0x5A0A, REG_BITS_16},
	{0x443C, 0x021D, REG_BITS_16},
	{0x443E, 0xCD0A, REG_BITS_16},
	{0x4440, 0xD61A, REG_BITS_16},
	{0x4442, 0x800C, REG_BITS_16},
	{0x4444, 0x0013, REG_BITS_16},
	{0x4446, 0xEF10, REG_BITS_16},
	{0x4448, 0x320F, REG_BITS_16},
	{0x444A, 0x007D, REG_BITS_16},
	{0x444C, 0xE880, REG_BITS_16},
	{0x444E, 0x0A, REG_BITS_8},
	{0x444F, 0x00, REG_BITS_8},
	{0x4450, 0x0000, REG_BITS_16},
	{0x4452, 0x1E, REG_BITS_8},
	{0x4453, 0x7B, REG_BITS_8},
	{0x4454, 0x0000, REG_BITS_16},
	{0x4456, 0x0000, REG_BITS_16},
	{0x4458, 0x0000, REG_BITS_16},
	{0x445A, 0x0000, REG_BITS_16},
	{0x445C, 0x0000, REG_BITS_16},
	{0x445E, 0x0000, REG_BITS_16},
	{0x4460, 0x0003, REG_BITS_16},
	{0x4462, 0x1000, REG_BITS_16},
	{0x4464, 0xC203, REG_BITS_16},
	{0x4466, 0xC203, REG_BITS_16},
	{0x4468, 0xC203, REG_BITS_16},
	{0x446A, 0x14, REG_BITS_8},
	{0x446B, 0x05, REG_BITS_8},
	{0x446C, 0x00, REG_BITS_8},
	{0x446D, 0x20, REG_BITS_8},
	{0x446E, 0x0000, REG_BITS_16},
	{0x4470, 0x05, REG_BITS_8},
	{0x4471, 0x40, REG_BITS_8},
	{0x4600, 0xAA, REG_BITS_8},
	{0x4601, 0xAA, REG_BITS_8},
	{0x4602, 0xAA, REG_BITS_8},
	{0x4603, 0xAA, REG_BITS_8},
	{0x4604, 0xAA, REG_BITS_8},
	{0x4605, 0xAA, REG_BITS_8},
	{0x4606, 0xAA, REG_BITS_8},
	{0x4607, 0xAA, REG_BITS_8},
	{0x4608, 0xAA, REG_BITS_8},
	{0x4609, 0xAA, REG_BITS_8},
	{0x460A, 0x96, REG_BITS_8},
	{0x460B, 0x78, REG_BITS_8},
	{0x460C, 0x6C, REG_BITS_8},
	{0x460D, 0x5F, REG_BITS_8},
	{0x460E, 0x55, REG_BITS_8},
	{0x460F, 0x45, REG_BITS_8},
	{0x4610, 0x3D, REG_BITS_8},
	{0x4611, 0x39, REG_BITS_8},
	{0x4612, 0x37, REG_BITS_8},
	{0x4613, 0x36, REG_BITS_8},
	{0x4614, 0x35, REG_BITS_8},
	{0x4615, 0x34, REG_BITS_8},
	{0x4616, 0x33, REG_BITS_8},
	{0x4617, 0x32, REG_BITS_8},
	{0x4618, 0x31, REG_BITS_8},
	{0x4619, 0x30, REG_BITS_8},
	{0x461A, 0x2F, REG_BITS_8},
	{0x461B, 0x2E, REG_BITS_8},
	{0x461C, 0x2D, REG_BITS_8},
	{0x461D, 0x2C, REG_BITS_8},
	{0x461E, 0x2B, REG_BITS_8},
	{0x461F, 0x29, REG_BITS_8},
	{0x4620, 0x25, REG_BITS_8},
	{0x4621, 0x24, REG_BITS_8},
	{0x4622, 0x23, REG_BITS_8},
	{0x4623, 0x22, REG_BITS_8},
	{0x4624, 0x21, REG_BITS_8},
	{0x4625, 0x20, REG_BITS_8},
	{0x4626, 0xAF, REG_BITS_8},
	{0x4627, 0xAF, REG_BITS_8},
	{0x4628, 0xAF, REG_BITS_8},
	{0x4629, 0xAF, REG_BITS_8},
	{0x462A, 0xAF, REG_BITS_8},
	{0x462B, 0xAF, REG_BITS_8},
	{0x462C, 0xAF, REG_BITS_8},
	{0x462D, 0xAF, REG_BITS_8},
	{0x462E, 0xAF, REG_BITS_8},
	{0x462F, 0xAA, REG_BITS_8},
	{0x4630, 0xB2, REG_BITS_8},
	{0x4631, 0xB4, REG_BITS_8},
	{0x4632, 0xB6, REG_BITS_8},
	{0x4633, 0xB4, REG_BITS_8},
	{0x4634, 0x9B, REG_BITS_8},
	{0x4635, 0x82, REG_BITS_8},
	{0x4636, 0x78, REG_BITS_8},
	{0x4637, 0x72, REG_BITS_8},
	{0x4638, 0x6C, REG_BITS_8},
	{0x4639, 0x67, REG_BITS_8},
	{0x463A, 0x63, REG_BITS_8},
	{0x463B, 0x5E, REG_BITS_8},
	{0x463C, 0x58, REG_BITS_8},
	{0x463D, 0x53, REG_BITS_8},
	{0x463E, 0x4E, REG_BITS_8},
	{0x463F, 0x4A, REG_BITS_8},
	{0x4640, 0x45, REG_BITS_8},
	{0x4641, 0x40, REG_BITS_8},
	{0x4642, 0x3D, REG_BITS_8},
	{0x4643, 0x3A, REG_BITS_8},
	{0x4644, 0x38, REG_BITS_8},
	{0x4645, 0x36, REG_BITS_8},
	{0x4646, 0x3B, REG_BITS_8},
	{0x4647, 0x3A, REG_BITS_8},
	{0x4648, 0x39, REG_BITS_8},
	{0x4649, 0x38, REG_BITS_8},
	{0x464A, 0x37, REG_BITS_8},
	{0x464B, 0x36, REG_BITS_8},
	{0x464C, 0x1F, REG_BITS_8},
	{0x464D, 0x09, REG_BITS_8},
	{0x464E, 0x19, REG_BITS_8},
	{0x464F, 0x10, REG_BITS_8},
	{0x4650, 0x91, REG_BITS_8},
	{0x4651, 0x91, REG_BITS_8},
	{0x4652, 0x91, REG_BITS_8},
	{0x4653, 0x91, REG_BITS_8},
	{0x4654, 0x91, REG_BITS_8},
	{0x4655, 0x91, REG_BITS_8},
	{0x4656, 0x91, REG_BITS_8},
	{0x4657, 0x91, REG_BITS_8},
	{0x4658, 0x91, REG_BITS_8},
	{0x4659, 0x91, REG_BITS_8},
	{0x465A, 0x91, REG_BITS_8},
	{0x465B, 0x91, REG_BITS_8},
	{0x465C, 0x91, REG_BITS_8},
	{0x465D, 0x78, REG_BITS_8},
	{0x465E, 0x68, REG_BITS_8},
	{0x465F, 0x51, REG_BITS_8},
	{0x4660, 0x41, REG_BITS_8},
	{0x4661, 0x3C, REG_BITS_8},
	{0x4662, 0x3A, REG_BITS_8},
	{0x4663, 0x39, REG_BITS_8},
	{0x4664, 0x38, REG_BITS_8},
	{0x4665, 0x37, REG_BITS_8},
	{0x4666, 0x36, REG_BITS_8},
	{0x4667, 0x35, REG_BITS_8},
	{0x4668, 0x34, REG_BITS_8},
	{0x4669, 0x33, REG_BITS_8},
	{0x466A, 0x32, REG_BITS_8},
	{0x466B, 0x31, REG_BITS_8},
	{0x466C, 0x30, REG_BITS_8},
	{0x466D, 0x2F, REG_BITS_8},
	{0x466E, 0x2E, REG_BITS_8},
	{0x466F, 0x2C, REG_BITS_8},
	{0x4670, 0x2B, REG_BITS_8},
	{0x4671, 0x2A, REG_BITS_8},
	{0x4672, 0x29, REG_BITS_8},
	{0x4673, 0x28, REG_BITS_8},
	{0x4674, 0x27, REG_BITS_8},
	{0x4675, 0x26, REG_BITS_8},
	{0x4676, 0xFF, REG_BITS_8},
	{0x4677, 0xFF, REG_BITS_8},
	{0x4678, 0xFF, REG_BITS_8},
	{0x4679, 0xFF, REG_BITS_8},
	{0x467A, 0xFF, REG_BITS_8},
	{0x467B, 0xFF, REG_BITS_8},
	{0x467C, 0xFF, REG_BITS_8},
	{0x467D, 0xFF, REG_BITS_8},
	{0x467E, 0xFF, REG_BITS_8},
	{0x467F, 0xFF, REG_BITS_8},
	{0x4680, 0xD9, REG_BITS_8},
	{0x4681, 0xB7, REG_BITS_8},
	{0x4682, 0x96, REG_BITS_8},
	{0x4683, 0x83, REG_BITS_8},
	{0x4684, 0x76, REG_BITS_8},
	{0x4685, 0x6A, REG_BITS_8},
	{0x4686, 0x68, REG_BITS_8},
	{0x4687, 0x66, REG_BITS_8},
	{0x4688, 0x63, REG_BITS_8},
	{0x4689, 0x5F, REG_BITS_8},
	{0x468A, 0x5B, REG_BITS_8},
	{0x468B, 0x56, REG_BITS_8},
	{0x468C, 0x51, REG_BITS_8},
	{0x468D, 0x4C, REG_BITS_8},
	{0x468E, 0x47, REG_BITS_8},
	{0x468F, 0x43, REG_BITS_8},
	{0x4690, 0x3F, REG_BITS_8},
	{0x4691, 0x3B, REG_BITS_8},
	{0x4692, 0x39, REG_BITS_8},
	{0x4693, 0x37, REG_BITS_8},
	{0x4694, 0x35, REG_BITS_8},
	{0x4695, 0x34, REG_BITS_8},
	{0x4696, 0x33, REG_BITS_8},
	{0x4697, 0x32, REG_BITS_8},
	{0x4698, 0x31, REG_BITS_8},
	{0x4699, 0x30, REG_BITS_8},
	{0x469A, 0x2F, REG_BITS_8},
	{0x469B, 0x2E, REG_BITS_8},
	{0x469C, 0x1E, REG_BITS_8},
	{0x469D, 0x0F, REG_BITS_8},
	{0x469E, 0x18, REG_BITS_8},
	{0x469F, 0x10, REG_BITS_8},
	{0x46A0, 0xFF, REG_BITS_8},
	{0x46A1, 0xFF, REG_BITS_8},
	{0x46A2, 0xFF, REG_BITS_8},
	{0x46A3, 0xFF, REG_BITS_8},
	{0x46A4, 0xFF, REG_BITS_8},
	{0x46A5, 0xFF, REG_BITS_8},
	{0x46A6, 0xFF, REG_BITS_8},
	{0x46A7, 0xFF, REG_BITS_8},
	{0x46A8, 0xFF, REG_BITS_8},
	{0x46A9, 0xFD, REG_BITS_8},
	{0x46AA, 0xCB, REG_BITS_8},
	{0x46AB, 0xA9, REG_BITS_8},
	{0x46AC, 0x90, REG_BITS_8},
	{0x46AD, 0x7D, REG_BITS_8},
	{0x46AE, 0x70, REG_BITS_8},
	{0x46AF, 0x65, REG_BITS_8},
	{0x46B0, 0x5C, REG_BITS_8},
	{0x46B1, 0x55, REG_BITS_8},
	{0x46B2, 0x4F, REG_BITS_8},
	{0x46B3, 0x32, REG_BITS_8},
	{0x46B4, 0x30, REG_BITS_8},
	{0x46B5, 0x2F, REG_BITS_8},
	{0x46B6, 0x2D, REG_BITS_8},
	{0x46B7, 0x2B, REG_BITS_8},
	{0x46B8, 0x29, REG_BITS_8},
	{0x46B9, 0x27, REG_BITS_8},
	{0x46BA, 0x25, REG_BITS_8},
	{0x46BB, 0x23, REG_BITS_8},
	{0x46BC, 0x21, REG_BITS_8},
	{0x46BD, 0x1F, REG_BITS_8},
	{0x46BE, 0x1D, REG_BITS_8},
	{0x46BF, 0x1B, REG_BITS_8},
	{0x46C0, 0x1A, REG_BITS_8},
	{0x46C1, 0x2A, REG_BITS_8},
	{0x46C2, 0x29, REG_BITS_8},
	{0x46C3, 0x28, REG_BITS_8},
	{0x46C4, 0x27, REG_BITS_8},
	{0x46C5, 0x26, REG_BITS_8},
	{0x46C6, 0xFF, REG_BITS_8},
	{0x46C7, 0xFF, REG_BITS_8},
	{0x46C8, 0xFF, REG_BITS_8},
	{0x46C9, 0xFF, REG_BITS_8},
	{0x46CA, 0xFF, REG_BITS_8},
	{0x46CB, 0xFF, REG_BITS_8},
	{0x46CC, 0xFF, REG_BITS_8},
	{0x46CD, 0xFF, REG_BITS_8},
	{0x46CE, 0xFF, REG_BITS_8},
	{0x46CF, 0xFF, REG_BITS_8},
	{0x46D0, 0xD3, REG_BITS_8},
	{0x46D1, 0xB1, REG_BITS_8},
	{0x46D2, 0x98, REG_BITS_8},
	{0x46D3, 0x85, REG_BITS_8},
	{0x46D4, 0x78, REG_BITS_8},
	{0x46D5, 0x6D, REG_BITS_8},
	{0x46D6, 0x64, REG_BITS_8},
	{0x46D7, 0x5D, REG_BITS_8},
	{0x46D8, 0x57, REG_BITS_8},
	{0x46D9, 0x63, REG_BITS_8},
	{0x46DA, 0x5E, REG_BITS_8},
	{0x46DB, 0x5A, REG_BITS_8},
	{0x46DC, 0x56, REG_BITS_8},
	{0x46DD, 0x52, REG_BITS_8},
	{0x46DE, 0x50, REG_BITS_8},
	{0x46DF, 0x4E, REG_BITS_8},
	{0x46E0, 0x4C, REG_BITS_8},
	{0x46E1, 0x4A, REG_BITS_8},
	{0x46E2, 0x48, REG_BITS_8},
	{0x46E3, 0x46, REG_BITS_8},
	{0x46E4, 0x44, REG_BITS_8},
	{0x46E5, 0x43, REG_BITS_8},
	{0x46E6, 0x42, REG_BITS_8},
	{0x46E7, 0x32, REG_BITS_8},
	{0x46E8, 0x31, REG_BITS_8},
	{0x46E9, 0x30, REG_BITS_8},
	{0x46EA, 0x2F, REG_BITS_8},
	{0x46EB, 0x2E, REG_BITS_8},
	{0x46EC, 0x1D, REG_BITS_8},
	{0x46ED, 0x14, REG_BITS_8},
	{0x46EE, 0x19, REG_BITS_8},
	{0x46EF, 0x10, REG_BITS_8},
	{0x46F0, 0xFF, REG_BITS_8},
	{0x46F1, 0xFF, REG_BITS_8},
	{0x46F2, 0xFF, REG_BITS_8},
	{0x46F3, 0xFF, REG_BITS_8},
	{0x46F4, 0xFF, REG_BITS_8},
	{0x46F5, 0xFF, REG_BITS_8},
	{0x46F6, 0xFF, REG_BITS_8},
	{0x46F7, 0xFF, REG_BITS_8},
	{0x46F8, 0xFF, REG_BITS_8},
	{0x46F9, 0xFF, REG_BITS_8},
	{0x46FA, 0xCD, REG_BITS_8},
	{0x46FB, 0xAB, REG_BITS_8},
	{0x46FC, 0x92, REG_BITS_8},
	{0x46FD, 0x7F, REG_BITS_8},
	{0x46FE, 0x72, REG_BITS_8},
	{0x46FF, 0x67, REG_BITS_8},
	{0x4700, 0x5E, REG_BITS_8},
	{0x4701, 0x57, REG_BITS_8},
	{0x4702, 0x51, REG_BITS_8},
	{0x4703, 0x4E, REG_BITS_8},
	{0x4704, 0x49, REG_BITS_8},
	{0x4705, 0x45, REG_BITS_8},
	{0x4706, 0x40, REG_BITS_8},
	{0x4707, 0x3E, REG_BITS_8},
	{0x4708, 0x3B, REG_BITS_8},
	{0x4709, 0x38, REG_BITS_8},
	{0x470A, 0x37, REG_BITS_8},
	{0x470B, 0x35, REG_BITS_8},
	{0x470C, 0x33, REG_BITS_8},
	{0x470D, 0x32, REG_BITS_8},
	{0x470E, 0x30, REG_BITS_8},
	{0x470F, 0x2E, REG_BITS_8},
	{0x4710, 0x2D, REG_BITS_8},
	{0x4711, 0x2C, REG_BITS_8},
	{0x4712, 0x2B, REG_BITS_8},
	{0x4713, 0x2A, REG_BITS_8},
	{0x4714, 0x29, REG_BITS_8},
	{0x4715, 0x28, REG_BITS_8},
	{0x4716, 0xFF, REG_BITS_8},
	{0x4717, 0xFF, REG_BITS_8},
	{0x4718, 0xFF, REG_BITS_8},
	{0x4719, 0xFF, REG_BITS_8},
	{0x471A, 0xFF, REG_BITS_8},
	{0x471B, 0xFF, REG_BITS_8},
	{0x471C, 0xFF, REG_BITS_8},
	{0x471D, 0xFF, REG_BITS_8},
	{0x471E, 0xFF, REG_BITS_8},
	{0x471F, 0xFF, REG_BITS_8},
	{0x4720, 0xD3, REG_BITS_8},
	{0x4721, 0xB1, REG_BITS_8},
	{0x4722, 0x98, REG_BITS_8},
	{0x4723, 0x85, REG_BITS_8},
	{0x4724, 0x78, REG_BITS_8},
	{0x4725, 0x6D, REG_BITS_8},
	{0x4726, 0x64, REG_BITS_8},
	{0x4727, 0x5D, REG_BITS_8},
	{0x4728, 0x57, REG_BITS_8},
	{0x4729, 0x52, REG_BITS_8},
	{0x472A, 0x4D, REG_BITS_8},
	{0x472B, 0x49, REG_BITS_8},
	{0x472C, 0x44, REG_BITS_8},
	{0x472D, 0x42, REG_BITS_8},
	{0x472E, 0x3F, REG_BITS_8},
	{0x472F, 0x3C, REG_BITS_8},
	{0x4730, 0x3B, REG_BITS_8},
	{0x4731, 0x39, REG_BITS_8},
	{0x4732, 0x37, REG_BITS_8},
	{0x4733, 0x36, REG_BITS_8},
	{0x4734, 0x34, REG_BITS_8},
	{0x4735, 0x34, REG_BITS_8},
	{0x4736, 0x33, REG_BITS_8},
	{0x4737, 0x32, REG_BITS_8},
	{0x4738, 0x31, REG_BITS_8},
	{0x4739, 0x30, REG_BITS_8},
	{0x473A, 0x2F, REG_BITS_8},
	{0x473B, 0x2E, REG_BITS_8},
	{0x473C, 0x1C, REG_BITS_8},
	{0x473D, 0x17, REG_BITS_8},
	{0x473E, 0x19, REG_BITS_8},
	{0x473F, 0x17, REG_BITS_8},
	{0x5000, 0xB0FF, REG_BITS_16},
	{0x5002, 0xFAFF, REG_BITS_16},
	{0x5004, 0xD4FF, REG_BITS_16},
	{0x5006, 0xEEFF, REG_BITS_16},
	{0x5008, 0xFEFF, REG_BITS_16},
	{0x500A, 0xD8FF, REG_BITS_16},
	{0x500C, 0xB8FF, REG_BITS_16},
	{0x500E, 0xFDFF, REG_BITS_16},
	{0x5010, 0xD4FF, REG_BITS_16},
	{0x5012, 0xEEFF, REG_BITS_16},
	{0x5014, 0x0000, REG_BITS_16},
	{0x5016, 0xC8FF, REG_BITS_16},
	{0x5018, 0xCEFF, REG_BITS_16},
	{0x501A, 0xF8FF, REG_BITS_16},
	{0x501C, 0xBFFF, REG_BITS_16},
	{0x501E, 0xFEFF, REG_BITS_16},
	{0x5020, 0xF9FF, REG_BITS_16},
	{0x5022, 0xB6FF, REG_BITS_16},
	{0x5024, 0xCCFF, REG_BITS_16},
	{0x5026, 0xF6FF, REG_BITS_16},
	{0x5028, 0xC7FF, REG_BITS_16},
	{0x502A, 0x0000, REG_BITS_16},
	{0x502C, 0xF6FF, REG_BITS_16},
	{0x502E, 0x72FF, REG_BITS_16},
	{0x5030, 0xCCFF, REG_BITS_16},
	{0x5032, 0xF6FF, REG_BITS_16},
	{0x5034, 0xC7FF, REG_BITS_16},
	{0x5036, 0x0000, REG_BITS_16},
	{0x5038, 0xF6FF, REG_BITS_16},
	{0x503A, 0x72FF, REG_BITS_16},
	{0x503C, 0xACFF, REG_BITS_16},
	{0x503E, 0xEEFF, REG_BITS_16},
	{0x5040, 0xBAFF, REG_BITS_16},
	{0x5042, 0x0000, REG_BITS_16},
	{0x5044, 0xFBFF, REG_BITS_16},
	{0x5046, 0xB7FF, REG_BITS_16},
	{0x5048, 0xACFF, REG_BITS_16},
	{0x504A, 0xEEFF, REG_BITS_16},
	{0x504C, 0xBAFF, REG_BITS_16},
	{0x504E, 0x0000, REG_BITS_16},
	{0x5050, 0xFBFF, REG_BITS_16},
	{0x5052, 0xB7FF, REG_BITS_16},
	{0x5054, 0x33, REG_BITS_8},
	{0x5055, 0x1C, REG_BITS_8},
	{0x5056, 0x3F, REG_BITS_8},
	{0x5057, 0x17, REG_BITS_8},
	{0x5058, 0x5D, REG_BITS_8},
	{0x5059, 0x12, REG_BITS_8},
	{0x505A, 0x6C, REG_BITS_8},
	{0x505B, 0x0E, REG_BITS_8},
	{0x505C, 0x95, REG_BITS_8},
	{0x505D, 0x0C, REG_BITS_8},
	{0x505E, 0x41, REG_BITS_8},
	{0x505F, 0x12, REG_BITS_8},
	{0x5060, 0x4D, REG_BITS_8},
	{0x5061, 0x10, REG_BITS_8},
	{0x5092, 0xF6FF, REG_BITS_16},
	{0x5094, 0xE9FF, REG_BITS_16},
	{0x5096, 0xF6FF, REG_BITS_16},
	{0x5098, 0xEAFF, REG_BITS_16},
	{0x509A, 0xF6FF, REG_BITS_16},
	{0x509C, 0xEAFF, REG_BITS_16},
	{0x509E, 0xF6FF, REG_BITS_16},
	{0x50A0, 0xE9FF, REG_BITS_16},
	{0x50A2, 0x40, REG_BITS_8},
	{0x50A3, 0x48, REG_BITS_8},
	{0x50A4, 0x40, REG_BITS_8},
	{0x50A5, 0x56, REG_BITS_8},
	{0x50A6, 0x40, REG_BITS_8},
	{0x50A7, 0x56, REG_BITS_8},
	{0x50A8, 0x40, REG_BITS_8},
	{0x50A9, 0x48, REG_BITS_8},
	{0x50AA, 0xF6FF, REG_BITS_16},
	{0x50AC, 0xE9FF, REG_BITS_16},
	{0x50AE, 0xF6FF, REG_BITS_16},
	{0x50B0, 0xEAFF, REG_BITS_16},
	{0x50B2, 0xF6FF, REG_BITS_16},
	{0x50B4, 0xEAFF, REG_BITS_16},
	{0x50B6, 0xF6FF, REG_BITS_16},
	{0x50B8, 0xE9FF, REG_BITS_16},
	{0x50BA, 0x40, REG_BITS_8},
	{0x50BB, 0x48, REG_BITS_8},
	{0x50BC, 0x40, REG_BITS_8},
	{0x50BD, 0x56, REG_BITS_8},
	{0x50BE, 0x40, REG_BITS_8},
	{0x50BF, 0x56, REG_BITS_8},
	{0x50C0, 0x40, REG_BITS_8},
	{0x50C1, 0x48, REG_BITS_8},
	{0x50C2, 0x12, REG_BITS_8},
	{0x50C3, 0x10, REG_BITS_8},
	{0x5200, 0x0000, REG_BITS_16},
	{0x5202, 0x0400, REG_BITS_16},
	{0x5204, 0x0800, REG_BITS_16},
	{0x5206, 0x0E00, REG_BITS_16},
	{0x5208, 0x1600, REG_BITS_16},
	{0x520A, 0x1E00, REG_BITS_16},
	{0x520C, 0x2600, REG_BITS_16},
	{0x520E, 0x2E00, REG_BITS_16},
	{0x5210, 0x3600, REG_BITS_16},
	{0x5212, 0x3D00, REG_BITS_16},
	{0x5214, 0x4300, REG_BITS_16},
	{0x5216, 0x4900, REG_BITS_16},
	{0x5218, 0x4E00, REG_BITS_16},
	{0x521A, 0x5400, REG_BITS_16},
	{0x521C, 0x5900, REG_BITS_16},
	{0x521E, 0x5E00, REG_BITS_16},
	{0x5220, 0x6300, REG_BITS_16},
	{0x5222, 0x6600, REG_BITS_16},
	{0x5224, 0x4300, REG_BITS_16},
	{0x5226, 0x8700, REG_BITS_16},
	{0x5228, 0xAF00, REG_BITS_16},
	{0x522A, 0xC800, REG_BITS_16},
	{0x522C, 0xDC00, REG_BITS_16},
	{0x522E, 0xEB00, REG_BITS_16},
	{0x5230, 0xF600, REG_BITS_16},
	{0x5232, 0x0001, REG_BITS_16},
	{0x5234, 0x0201, REG_BITS_16},
	{0x5236, 0x0000, REG_BITS_16},
	{0x5238, 0x0400, REG_BITS_16},
	{0x523A, 0x0800, REG_BITS_16},
	{0x523C, 0x0E00, REG_BITS_16},
	{0x523E, 0x1600, REG_BITS_16},
	{0x5240, 0x1E00, REG_BITS_16},
	{0x5242, 0x2600, REG_BITS_16},
	{0x5244, 0x2E00, REG_BITS_16},
	{0x5246, 0x3600, REG_BITS_16},
	{0x5248, 0x3D00, REG_BITS_16},
	{0x524A, 0x4300, REG_BITS_16},
	{0x524C, 0x4900, REG_BITS_16},
	{0x524E, 0x4E00, REG_BITS_16},
	{0x5250, 0x5400, REG_BITS_16},
	{0x5252, 0x5900, REG_BITS_16},
	{0x5254, 0x5E00, REG_BITS_16},
	{0x5256, 0x6300, REG_BITS_16},
	{0x5258, 0x6600, REG_BITS_16},
	{0x525A, 0x4300, REG_BITS_16},
	{0x525C, 0x8700, REG_BITS_16},
	{0x525E, 0xAF00, REG_BITS_16},
	{0x5260, 0xC800, REG_BITS_16},
	{0x5262, 0xDC00, REG_BITS_16},
	{0x5264, 0xEB00, REG_BITS_16},
	{0x5266, 0xF600, REG_BITS_16},
	{0x5268, 0x0001, REG_BITS_16},
	{0x526A, 0x0201, REG_BITS_16},
	{0x526C, 0x0000, REG_BITS_16},
	{0x526E, 0x0400, REG_BITS_16},
	{0x5270, 0x0800, REG_BITS_16},
	{0x5272, 0x0E00, REG_BITS_16},
	{0x5274, 0x1600, REG_BITS_16},
	{0x5276, 0x1E00, REG_BITS_16},
	{0x5278, 0x2600, REG_BITS_16},
	{0x527A, 0x2E00, REG_BITS_16},
	{0x527C, 0x3600, REG_BITS_16},
	{0x527E, 0x3D00, REG_BITS_16},
	{0x5280, 0x4300, REG_BITS_16},
	{0x5282, 0x4900, REG_BITS_16},
	{0x5284, 0x4E00, REG_BITS_16},
	{0x5286, 0x5400, REG_BITS_16},
	{0x5288, 0x5900, REG_BITS_16},
	{0x528A, 0x5E00, REG_BITS_16},
	{0x528C, 0x6300, REG_BITS_16},
	{0x528E, 0x6600, REG_BITS_16},
	{0x5290, 0x4300, REG_BITS_16},
	{0x5292, 0x8700, REG_BITS_16},
	{0x5294, 0xAF00, REG_BITS_16},
	{0x5296, 0xC800, REG_BITS_16},
	{0x5298, 0xDC00, REG_BITS_16},
	{0x529A, 0xEB00, REG_BITS_16},
	{0x529C, 0xF600, REG_BITS_16},
	{0x529E, 0x0001, REG_BITS_16},
	{0x52A0, 0x0201, REG_BITS_16},
	{0x52A2, 0x1002, REG_BITS_16},
	{0x52A4, 0x0540, REG_BITS_16},
	{0x52A6, 0x1002, REG_BITS_16},
	{0x52A8, 0x0540, REG_BITS_16},
	{0x52AA, 0x1002, REG_BITS_16},
	{0x52AC, 0x0540, REG_BITS_16},
	{0x52AE, 0x0021, REG_BITS_16},
	{0x4E40, 0x4A15, REG_BITS_16},
	{0x4E42, 0xEC13, REG_BITS_16},
	{0x4E44, 0x4E11, REG_BITS_16},
	{0x4E46, 0x0410, REG_BITS_16},
	{0x4E48, 0xF811, REG_BITS_16},
	{0x4E4A, 0xCC10, REG_BITS_16},
	{0x4E4C, 0x9065, REG_BITS_16},
	{0x4E4E, 0xD859, REG_BITS_16},
	{0x4E50, 0x0000, REG_BITS_16},
	{0x4E52, 0x0000, REG_BITS_16},
	{0x4E54, 0x0000, REG_BITS_16},
	{0x4E56, 0x0000, REG_BITS_16},
	{0x4E58, 0x0000, REG_BITS_16},
	{0x4E5A, 0x0000, REG_BITS_16},
	{0x4E5D, 0x00, REG_BITS_8},
	{0x4E5E, 0x0000, REG_BITS_16},
	{0x4E60, 0x1E5A20E0, REG_BITS_32},
	{0x4E64, 0xED0EF1F6, REG_BITS_32},
	{0x4E68, 0x13F10313, REG_BITS_32},
	{0x4E6C, 0x863A863A, REG_BITS_32},
	{0x4E70, 0x1E5A20E0, REG_BITS_32},
	{0x4E74, 0xED0EF1F6, REG_BITS_32},
	{0x4E78, 0x13F10313, REG_BITS_32},
	{0x4E7C, 0x863A863A, REG_BITS_32},
	{0x4E80, 0x0000, REG_BITS_16},
	{0x4E84, 0x00000000, REG_BITS_32},
	{0x4E88, 0x00000000, REG_BITS_32},
	{0x4E8C, 0x00000000, REG_BITS_32},
	{0x4E90, 0x00000000, REG_BITS_32},
	{0x4E94, 0x00000000, REG_BITS_32},
	{0x4E98, 0x00000000, REG_BITS_32},
	{0x4E9C, 0x00000000, REG_BITS_32},
	{0x4EA0, 0x00000000, REG_BITS_32},
	{0x4F52, 0x01, REG_BITS_8},
	{0x4F53, 0x08, REG_BITS_8},
	{0x4F54, 0x11, REG_BITS_8},
	{0x4F55, 0x12, REG_BITS_8},
	{0x4F56, 0x1A, REG_BITS_8},
	{0x4F57, 0x1F, REG_BITS_8},
	{0x4F58, 0x04, REG_BITS_8},
	{0x4F59, 0x02, REG_BITS_8},
	{0x4F5A, 0x23, REG_BITS_8},
	{0x4F5B, 0x3C, REG_BITS_8},
	{0x4F5C, 0x0F, REG_BITS_8},
	{0x4F5D, 0x11, REG_BITS_8},
	{0x4F5E, 0x05, REG_BITS_8},
	{0x4F5F, 0x0A, REG_BITS_8},
	{0x4F60, 0x14, REG_BITS_8},
	{0x4F61, 0x02, REG_BITS_8},
	{0x4F62, 0x3C, REG_BITS_8},
	{0x4F63, 0x46, REG_BITS_8},
	{0x4F64, 0x14, REG_BITS_8},
	{0x4F65, 0x11, REG_BITS_8},
	{0x4F66, 0x1E, REG_BITS_8},
	{0x4F67, 0x46, REG_BITS_8},
	{0x4F68, 0x14, REG_BITS_8},
	{0x4F69, 0x01, REG_BITS_8},
	{0x4F6A, 0x14, REG_BITS_8},
	{0x4F6C, 0x0074, REG_BITS_16},
	{0x4F6E, 0x0070, REG_BITS_16},
	{0x4F70, 0x00, REG_BITS_8},
	{0x4F71, 0x00, REG_BITS_8},
	{0x4F72, 0x00, REG_BITS_8},
	{0x4F73, 0x00, REG_BITS_8},
	{0x4F74, 0x00, REG_BITS_8},
	{0x4F75, 0x00, REG_BITS_8},
	{0x4F76, 0x00, REG_BITS_8},
	{0x4F77, 0x00, REG_BITS_8},
	{0x4F78, 0x00, REG_BITS_8},
	{0x4F79, 0x00, REG_BITS_8},
	{0x4F7A, 0x00, REG_BITS_8},
	{0x4F7B, 0x00, REG_BITS_8},
	{0x4F7C, 0x00, REG_BITS_8},
	{0x4F7D, 0x00, REG_BITS_8},
	{0x4F7E, 0x00, REG_BITS_8},
	{0x4F7F, 0x00, REG_BITS_8},
	{0x4F80, 0x00, REG_BITS_8},
	{0x4F81, 0x00, REG_BITS_8},
	{0x4F82, 0x00, REG_BITS_8},
	{0x4F83, 0x00, REG_BITS_8},
	{0x4F84, 0x00, REG_BITS_8},
	{0x4F85, 0x00, REG_BITS_8},
	{0x4F86, 0x00, REG_BITS_8},
	{0x4F87, 0x00, REG_BITS_8},
	{0x4F88, 0x00, REG_BITS_8},
	{0x4F89, 0x00, REG_BITS_8},
	{0x4F8A, 0x00, REG_BITS_8},
	{0x4F8B, 0x00, REG_BITS_8},
	{0x4F8C, 0x00, REG_BITS_8},
	{0x4F8D, 0x00, REG_BITS_8},
	{0x4F8E, 0x00, REG_BITS_8},
	{0x4F8F, 0x00, REG_BITS_8},
	{0x4F90, 0x00, REG_BITS_8},
	{0x4FAC, 0x00, REG_BITS_8},
	{0x4FAD, 0x00, REG_BITS_8},
	{0x4FAE, 0x00, REG_BITS_8},
	{0x4FAF, 0x00, REG_BITS_8},
	{0x4FB0, 0x00, REG_BITS_8},
	{0x4FB1, 0x03, REG_BITS_8},
	{0x4FB2, 0x02, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x01, REG_BITS_8},
	{0x9003, 0x14, REG_BITS_8},
	{0x9004, 0x04, REG_BITS_8},
	{0x9005, 0x50, REG_BITS_8},
	{0x9006, 0x00, REG_BITS_8},
	{0x9007, 0x20, REG_BITS_8},
	{0x9008, 0x41, REG_BITS_8},
	{0x9009, 0x80, REG_BITS_8},
	{0x900A, 0x03, REG_BITS_8},
	{0x900B, 0xff, REG_BITS_8},
	{0x900C, 0x13, REG_BITS_8},
	{0x900D, 0x00, REG_BITS_8},
	{0x900E, 0x48, REG_BITS_8},
	{0x900F, 0x10, REG_BITS_8},
	{0x9010, 0x20, REG_BITS_8},
	{0x9011, 0xc1, REG_BITS_8},
	{0x9012, 0x7f, REG_BITS_8},
	{0x9013, 0x05, REG_BITS_8},
	{0x9014, 0xff, REG_BITS_8},
	{0x9015, 0x15, REG_BITS_8},
	{0x9016, 0x04, REG_BITS_8},
	{0x9017, 0x50, REG_BITS_8},
	{0x9018, 0x10, REG_BITS_8},
	{0x9019, 0x40, REG_BITS_8},
	{0x901A, 0x01, REG_BITS_8},
	{0x901B, 0x80, REG_BITS_8},
	{0x901C, 0x04, REG_BITS_8},
	{0x901D, 0x01, REG_BITS_8},
	{0x901E, 0x0e, REG_BITS_8},
	{0x901F, 0xfc, REG_BITS_8},
	{0x9020, 0x4f, REG_BITS_8},
	{0x9021, 0x00, REG_BITS_8},
	{0x9022, 0x20, REG_BITS_8},
	{0x9023, 0x41, REG_BITS_8},
	{0x9024, 0x80, REG_BITS_8},
	{0x9025, 0x04, REG_BITS_8},
	{0x9026, 0xff, REG_BITS_8},
	{0x9027, 0x15, REG_BITS_8},
	{0x9028, 0xfc, REG_BITS_8},
	{0x9029, 0x57, REG_BITS_8},
	{0x902A, 0x10, REG_BITS_8},
	{0x902B, 0xe0, REG_BITS_8},
	{0x902C, 0x40, REG_BITS_8},
	{0x902D, 0x80, REG_BITS_8},
	{0x902E, 0x03, REG_BITS_8},
	{0x902F, 0x01, REG_BITS_8},
	{0x9030, 0x10, REG_BITS_8},
	{0x9031, 0x00, REG_BITS_8},
	{0x9032, 0x38, REG_BITS_8},
	{0x9033, 0xf0, REG_BITS_8},
	{0x9034, 0xff, REG_BITS_8},
	{0x9035, 0x40, REG_BITS_8},
	{0x9036, 0x00, REG_BITS_8},
	{0x9037, 0x04, REG_BITS_8},
	{0x9038, 0x03, REG_BITS_8},
	{0x9039, 0x10, REG_BITS_8},
	{0x903A, 0x00, REG_BITS_8},
	{0x903B, 0x48, REG_BITS_8},
	{0x903C, 0x00, REG_BITS_8},
	{0x903D, 0x20, REG_BITS_8},
	{0x903E, 0x81, REG_BITS_8},
	{0x903F, 0x00, REG_BITS_8},
	{0x9040, 0x04, REG_BITS_8},
	{0x9041, 0x02, REG_BITS_8},
	{0x9042, 0x10, REG_BITS_8},
	{0x9043, 0x08, REG_BITS_8},
	{0x9044, 0x30, REG_BITS_8},
	{0x9045, 0x10, REG_BITS_8},
	{0x9046, 0xc0, REG_BITS_8},
	{0x9047, 0x00, REG_BITS_8},
	{0x9048, 0x80, REG_BITS_8},
	{0x9049, 0x02, REG_BITS_8},
	{0x904A, 0x00, REG_BITS_8},
	{0x904B, 0x0a, REG_BITS_8},
	{0x904C, 0x00, REG_BITS_8},
	{0x904D, 0x30, REG_BITS_8},
	{0x904E, 0x20, REG_BITS_8},
	{0x904F, 0x00, REG_BITS_8},
	{0x9050, 0x81, REG_BITS_8},
	{0x9051, 0x00, REG_BITS_8},
	{0x9052, 0x04, REG_BITS_8},
	{0x9053, 0x01, REG_BITS_8},
	{0x9054, 0x0c, REG_BITS_8},
	{0x9055, 0x04, REG_BITS_8},
	{0x9056, 0x30, REG_BITS_8},
	{0x9057, 0x10, REG_BITS_8},
	{0x9058, 0x80, REG_BITS_8},
	{0x9059, 0x40, REG_BITS_8},
	{0x905A, 0x80, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x01, REG_BITS_8},
	{0x905D, 0x02, REG_BITS_8},
	{0x905E, 0xf8, REG_BITS_8},
	{0x905F, 0x17, REG_BITS_8},
	{0x9060, 0x00, REG_BITS_8},
	{0x9061, 0xc0, REG_BITS_8},
	{0x9062, 0x40, REG_BITS_8},
	{0x9063, 0x00, REG_BITS_8},
	{0x9064, 0x03, REG_BITS_8},
	{0x9065, 0x01, REG_BITS_8},
	{0x9066, 0x0c, REG_BITS_8},
	{0x9067, 0x04, REG_BITS_8},
	{0x9068, 0x30, REG_BITS_8},
	{0x9069, 0x10, REG_BITS_8},
	{0x906A, 0xc0, REG_BITS_8},
	{0x906B, 0xc0, REG_BITS_8},
	{0x906C, 0x00, REG_BITS_8},
	{0x906D, 0x02, REG_BITS_8},
	{0x906E, 0x01, REG_BITS_8},
	{0x906F, 0x02, REG_BITS_8},
	{0x9070, 0x04, REG_BITS_8},
	{0x9071, 0x00, REG_BITS_8},
	{0x9072, 0x10, REG_BITS_8},
	{0x9073, 0x20, REG_BITS_8},
	{0x9074, 0x40, REG_BITS_8},
	{0x9075, 0x80, REG_BITS_8},
	{0x9076, 0x01, REG_BITS_8},
	{0x9077, 0xff, REG_BITS_8},
	{0x9078, 0x0b, REG_BITS_8},
	{0x9079, 0xfc, REG_BITS_8},
	{0x907A, 0x2f, REG_BITS_8},
	{0x907B, 0x20, REG_BITS_8},
	{0x907C, 0x80, REG_BITS_8},
	{0x907D, 0x80, REG_BITS_8},
	{0x907E, 0x00, REG_BITS_8},
	{0x907F, 0x02, REG_BITS_8},
	{0x9080, 0x01, REG_BITS_8},
	{0x9081, 0x04, REG_BITS_8},
	{0x9082, 0x08, REG_BITS_8},
	{0x9083, 0x00, REG_BITS_8},
	{0x9084, 0x20, REG_BITS_8},
	{0x9085, 0x00, REG_BITS_8},
	{0x9086, 0x40, REG_BITS_8},
	{0x9087, 0x80, REG_BITS_8},
	{0x9088, 0x00, REG_BITS_8},
	{0x9089, 0x01, REG_BITS_8},
	{0x908A, 0x08, REG_BITS_8},
	{0x908B, 0x04, REG_BITS_8},
	{0x908C, 0x18, REG_BITS_8},
	{0x908D, 0x10, REG_BITS_8},
	{0x908E, 0x60, REG_BITS_8},
	{0x908F, 0x80, REG_BITS_8},
	{0x9090, 0x00, REG_BITS_8},
	{0x9091, 0x02, REG_BITS_8},
	{0x9092, 0x02, REG_BITS_8},
	{0x9093, 0x08, REG_BITS_8},
	{0x9094, 0x08, REG_BITS_8},
	{0x9095, 0x18, REG_BITS_8},
	{0x9096, 0x30, REG_BITS_8},
	{0x9097, 0x40, REG_BITS_8},
	{0x9098, 0x40, REG_BITS_8},
	{0x9099, 0x00, REG_BITS_8},
	{0x909A, 0x00, REG_BITS_8},
	{0x909B, 0x02, REG_BITS_8},
	{0x909C, 0x04, REG_BITS_8},
	{0x909D, 0x04, REG_BITS_8},
	{0x909E, 0x10, REG_BITS_8},
	{0x909F, 0x00, REG_BITS_8},
	{0x90A0, 0x80, REG_BITS_8},
	{0x90A1, 0x00, REG_BITS_8},
	{0x90A2, 0x00, REG_BITS_8},
	{0x90A3, 0x02, REG_BITS_8},
	{0x90A4, 0x02, REG_BITS_8},
	{0x90A5, 0x0a, REG_BITS_8},
	{0x90A6, 0x08, REG_BITS_8},
	{0x90A7, 0x28, REG_BITS_8},
	{0x90A8, 0x30, REG_BITS_8},
	{0x90A9, 0x80, REG_BITS_8},
	{0x90AA, 0xc0, REG_BITS_8},
	{0x90AB, 0x00, REG_BITS_8},
	{0x90AC, 0x02, REG_BITS_8},
	{0x90AD, 0x04, REG_BITS_8},
	{0x90AE, 0x04, REG_BITS_8},
	{0x90AF, 0x08, REG_BITS_8},
	{0x90B0, 0x18, REG_BITS_8},
	{0x90B1, 0x30, REG_BITS_8},
	{0x90B2, 0x80, REG_BITS_8},
	{0x90B3, 0xc0, REG_BITS_8},
	{0x90B4, 0x80, REG_BITS_8},
	{0x90B5, 0x02, REG_BITS_8},
	{0x90B6, 0x03, REG_BITS_8},
	{0x90B7, 0x0a, REG_BITS_8},
	{0x90B8, 0x04, REG_BITS_8},
	{0x90B9, 0x28, REG_BITS_8},
	{0x90BA, 0x10, REG_BITS_8},
	{0x90BB, 0xa0, REG_BITS_8},
	{0x90BC, 0xc0, REG_BITS_8},
	{0x90BD, 0x00, REG_BITS_8},
	{0x90BE, 0x02, REG_BITS_8},
	{0x90BF, 0x04, REG_BITS_8},
	{0x90C0, 0x0a, REG_BITS_8},
	{0x90C1, 0x0c, REG_BITS_8},
	{0x90C2, 0x30, REG_BITS_8},
	{0x90C3, 0x40, REG_BITS_8},
	{0x90C4, 0xc0, REG_BITS_8},
	{0x90C5, 0x80, REG_BITS_8},
	{0x90C6, 0x80, REG_BITS_8},
	{0x90C7, 0x02, REG_BITS_8},
	{0x90C8, 0x02, REG_BITS_8},
	{0x90C9, 0x10, REG_BITS_8},
	{0x90CA, 0x08, REG_BITS_8},
	{0x90CB, 0x40, REG_BITS_8},
	{0x90CC, 0x20, REG_BITS_8},
	{0x90CD, 0xa0, REG_BITS_8},
	{0x90CE, 0x80, REG_BITS_8},
	{0x90CF, 0x80, REG_BITS_8},
	{0x90D0, 0x02, REG_BITS_8},
	{0x90D1, 0x03, REG_BITS_8},
	{0x90D2, 0x0a, REG_BITS_8},
	{0x90D3, 0x0c, REG_BITS_8},
	{0x90D4, 0x40, REG_BITS_8},
	{0x90D5, 0x20, REG_BITS_8},
	{0x90D6, 0xe0, REG_BITS_8},
	{0x90D7, 0xc0, REG_BITS_8},
	{0x90D8, 0x80, REG_BITS_8},
	{0x90D9, 0x03, REG_BITS_8},
	{0x90DA, 0x01, REG_BITS_8},
	{0x90DB, 0x0c, REG_BITS_8},
	{0x90DC, 0x08, REG_BITS_8},
	{0x90DD, 0x38, REG_BITS_8},
	{0x90DE, 0x20, REG_BITS_8},
	{0x90DF, 0xe0, REG_BITS_8},
	{0x90E0, 0x80, REG_BITS_8},
	{0x90E1, 0x80, REG_BITS_8},
	{0x90E2, 0x02, REG_BITS_8},
	{0x90E3, 0x02, REG_BITS_8},
	{0x90E4, 0x0a, REG_BITS_8},
	{0x90E5, 0x0c, REG_BITS_8},
	{0x90E6, 0x28, REG_BITS_8},
	{0x90E7, 0x30, REG_BITS_8},
	{0x90E8, 0x00, REG_BITS_8},
	{0x90E9, 0x81, REG_BITS_8},
	{0x90EA, 0x80, REG_BITS_8},
	{0x90EB, 0x03, REG_BITS_8},
	{0x90EC, 0x03, REG_BITS_8},
	{0x90ED, 0x0e, REG_BITS_8},
	{0x90EE, 0x04, REG_BITS_8},
	{0x90EF, 0x30, REG_BITS_8},
	{0x90F0, 0x20, REG_BITS_8},
	{0x90F1, 0xe0, REG_BITS_8},
	{0x90F2, 0x80, REG_BITS_8},
	{0x90F3, 0x80, REG_BITS_8},
	{0x90F4, 0x03, REG_BITS_8},
	{0x90F5, 0x05, REG_BITS_8},
	{0x90F6, 0xf2, REG_BITS_8},
	{0x90F7, 0x17, REG_BITS_8},
	{0x90F8, 0xc8, REG_BITS_8},
	{0x90F9, 0x3f, REG_BITS_8},
	{0x90FA, 0xa0, REG_BITS_8},
	{0x90FB, 0xbe, REG_BITS_8},
	{0x90FC, 0x00, REG_BITS_8},
	{0x90FD, 0xfc, REG_BITS_8},
	{0x90FE, 0x03, REG_BITS_8},
	{0x90FF, 0xe6, REG_BITS_8},
	{0x9100, 0x0f, REG_BITS_8},
	{0x9101, 0xa0, REG_BITS_8},
	{0x9102, 0x0f, REG_BITS_8},
	{0x9103, 0x20, REG_BITS_8},
	{0x9104, 0x3f, REG_BITS_8},
	{0x9105, 0x00, REG_BITS_8},
	{0x9106, 0xfd, REG_BITS_8},
	{0x9107, 0x00, REG_BITS_8},
	{0x9108, 0xf4, REG_BITS_8},
	{0x9109, 0x17, REG_BITS_8},
	{0x910A, 0xc8, REG_BITS_8},
	{0x910B, 0x5f, REG_BITS_8},
	{0x910C, 0x20, REG_BITS_8},
	{0x910D, 0xff, REG_BITS_8},
	{0x910E, 0x80, REG_BITS_8},
	{0x910F, 0xfa, REG_BITS_8},
	{0x9110, 0x02, REG_BITS_8},
	{0x9111, 0xf0, REG_BITS_8},
	{0x9112, 0x0f, REG_BITS_8},
	{0x9113, 0x98, REG_BITS_8},
	{0x9114, 0x3f, REG_BITS_8},
	{0x9115, 0x80, REG_BITS_8},
	{0x9116, 0x3e, REG_BITS_8},
	{0x9117, 0x80, REG_BITS_8},
	{0x9118, 0xfc, REG_BITS_8},
	{0x9119, 0x00, REG_BITS_8},
	{0x911A, 0xf4, REG_BITS_8},
	{0x911B, 0x03, REG_BITS_8},
	{0x911C, 0xd0, REG_BITS_8},
	{0x911D, 0x3f, REG_BITS_8},
	{0x911E, 0xa0, REG_BITS_8},
	{0x911F, 0xfe, REG_BITS_8},
	{0x9120, 0x80, REG_BITS_8},
	{0x9121, 0xfa, REG_BITS_8},
	{0x9122, 0x04, REG_BITS_8},
	{0x9123, 0xf0, REG_BITS_8},
	{0x9124, 0x0b, REG_BITS_8},
	{0x9125, 0xd0, REG_BITS_8},
	{0x9126, 0x3f, REG_BITS_8},
	{0x9127, 0x00, REG_BITS_8},
	{0x9128, 0x3f, REG_BITS_8},
	{0x9129, 0x80, REG_BITS_8},
	{0x912A, 0xfd, REG_BITS_8},
	{0x912B, 0x02, REG_BITS_8},
	{0x912C, 0xf2, REG_BITS_8},
	{0x912D, 0x07, REG_BITS_8},
	{0x912E, 0xc0, REG_BITS_8},
	{0x912F, 0x1f, REG_BITS_8},
	{0x9130, 0x00, REG_BITS_8},
	{0x9131, 0x3f, REG_BITS_8},
	{0x9132, 0x81, REG_BITS_8},
	{0x9133, 0xfd, REG_BITS_8},
	{0x9134, 0x04, REG_BITS_8},
	{0x9135, 0xf6, REG_BITS_8},
	{0x9136, 0x13, REG_BITS_8},
	{0x9137, 0xd0, REG_BITS_8},
	{0x9138, 0x3f, REG_BITS_8},
	{0x9139, 0x20, REG_BITS_8},
	{0x913A, 0x7f, REG_BITS_8},
	{0x913B, 0x80, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0x00, REG_BITS_8},
	{0x913E, 0xf0, REG_BITS_8},
	{0x913F, 0x03, REG_BITS_8},
	{0x9140, 0xd0, REG_BITS_8},
	{0x9141, 0x1f, REG_BITS_8},
	{0x9142, 0x60, REG_BITS_8},
	{0x9143, 0x7f, REG_BITS_8},
	{0x9144, 0x80, REG_BITS_8},
	{0x9145, 0xfd, REG_BITS_8},
	{0x9146, 0x04, REG_BITS_8},
	{0x9147, 0xf4, REG_BITS_8},
	{0x9148, 0x13, REG_BITS_8},
	{0x9149, 0xd0, REG_BITS_8},
	{0x914A, 0x4f, REG_BITS_8},
	{0x914B, 0x40, REG_BITS_8},
	{0x914C, 0xbf, REG_BITS_8},
	{0x914D, 0x00, REG_BITS_8},
	{0x914E, 0xfc, REG_BITS_8},
	{0x914F, 0xff, REG_BITS_8},
	{0x9150, 0xf3, REG_BITS_8},
	{0x9151, 0x03, REG_BITS_8},
	{0x9152, 0xd0, REG_BITS_8},
	{0x9153, 0x0f, REG_BITS_8},
	{0x9154, 0x60, REG_BITS_8},
	{0x9155, 0x3f, REG_BITS_8},
	{0x9156, 0x80, REG_BITS_8},
	{0x9157, 0xfe, REG_BITS_8},
	{0x9158, 0x00, REG_BITS_8},
	{0x9159, 0xfa, REG_BITS_8},
	{0x915A, 0x17, REG_BITS_8},
	{0x915B, 0xd0, REG_BITS_8},
	{0x915C, 0x5f, REG_BITS_8},
	{0x915D, 0x40, REG_BITS_8},
	{0x915E, 0xbf, REG_BITS_8},
	{0x915F, 0x80, REG_BITS_8},
	{0x9160, 0xfe, REG_BITS_8},
	{0x9161, 0x00, REG_BITS_8},
	{0x9162, 0xfc, REG_BITS_8},
	{0x9163, 0xff, REG_BITS_8},
	{0x9164, 0xf7, REG_BITS_8},
	{0x9165, 0xff, REG_BITS_8},
	{0x9166, 0xbf, REG_BITS_8},
	{0x9167, 0xff, REG_BITS_8},
	{0x9168, 0x7f, REG_BITS_8},
	{0x9169, 0xfe, REG_BITS_8},
	{0x916A, 0x00, REG_BITS_8},
	{0x916B, 0xfa, REG_BITS_8},
	{0x916C, 0x03, REG_BITS_8},
	{0x916D, 0xe8, REG_BITS_8},
	{0x916E, 0x6f, REG_BITS_8},
	{0x916F, 0xc0, REG_BITS_8},
	{0x9170, 0xbf, REG_BITS_8},
	{0x9171, 0x01, REG_BITS_8},
	{0x9172, 0xff, REG_BITS_8},
	{0x9173, 0x05, REG_BITS_8},
	{0x9174, 0xfc, REG_BITS_8},
	{0x9175, 0x0b, REG_BITS_8},
	{0x9176, 0xf8, REG_BITS_8},
	{0x9177, 0x0f, REG_BITS_8},
	{0x9178, 0x00, REG_BITS_8},
	{0x9179, 0x00, REG_BITS_8},
	{0x917A, 0x80, REG_BITS_8},
	{0x917B, 0x00, REG_BITS_8},
	{0x917C, 0x00, REG_BITS_8},
	{0x917D, 0x02, REG_BITS_8},
	{0x917E, 0x00, REG_BITS_8},
	{0x917F, 0xf8, REG_BITS_8},
	{0x9180, 0x0f, REG_BITS_8},
	{0x9181, 0xe0, REG_BITS_8},
	{0x9182, 0x7f, REG_BITS_8},
	{0x9183, 0x82, REG_BITS_8},
	{0x9184, 0xff, REG_BITS_8},
	{0x9185, 0x09, REG_BITS_8},
	{0x9186, 0xfe, REG_BITS_8},
	{0x9187, 0x17, REG_BITS_8},
	{0x9188, 0x08, REG_BITS_8},
	{0x9189, 0x30, REG_BITS_8},
	{0x918A, 0x60, REG_BITS_8},
	{0x918B, 0x80, REG_BITS_8},
	{0x918C, 0x00, REG_BITS_8},
	{0x918D, 0x01, REG_BITS_8},
	{0x918E, 0x01, REG_BITS_8},
	{0x918F, 0x06, REG_BITS_8},
	{0x9190, 0x08, REG_BITS_8},
	{0x9191, 0x08, REG_BITS_8},
	{0x9192, 0x20, REG_BITS_8},
	{0x9193, 0x60, REG_BITS_8},
	{0x9194, 0x80, REG_BITS_8},
	{0x9195, 0x80, REG_BITS_8},
	{0x9196, 0x01, REG_BITS_8},
	{0x9197, 0x08, REG_BITS_8},
	{0x9198, 0x04, REG_BITS_8},
	{0x9199, 0x20, REG_BITS_8},
	{0x919A, 0x10, REG_BITS_8},
	{0x919B, 0x70, REG_BITS_8},
	{0x919C, 0xa0, REG_BITS_8},
	{0x919D, 0x80, REG_BITS_8},
	{0x919E, 0x01, REG_BITS_8},
	{0x919F, 0x03, REG_BITS_8},
	{0x91A0, 0x05, REG_BITS_8},
	{0x91A1, 0x0c, REG_BITS_8},
	{0x91A2, 0x0c, REG_BITS_8},
	{0x91A3, 0x30, REG_BITS_8},
	{0x91A4, 0x30, REG_BITS_8},
	{0x91A5, 0x20, REG_BITS_8},
	{0x91A6, 0xc1, REG_BITS_8},
	{0x91A7, 0x80, REG_BITS_8},
	{0x91A8, 0x02, REG_BITS_8},
	{0x91A9, 0x03, REG_BITS_8},
	{0x91AA, 0x0a, REG_BITS_8},
	{0x91AB, 0x20, REG_BITS_8},
	{0x91AC, 0x08, REG_BITS_8},
	{0x91AD, 0x80, REG_BITS_8},
	{0x91AE, 0x20, REG_BITS_8},
	{0x91AF, 0x00, REG_BITS_8},
	{0x91B0, 0x82, REG_BITS_8},
	{0x91B1, 0x02, REG_BITS_8},
	{0x91B2, 0x07, REG_BITS_8},
	{0x91B3, 0x0a, REG_BITS_8},
	{0x91B4, 0x10, REG_BITS_8},
	{0x91B5, 0x30, REG_BITS_8},
	{0x91B6, 0x40, REG_BITS_8},
	{0x91B7, 0x80, REG_BITS_8},
	{0x91B8, 0xc0, REG_BITS_8},
	{0x91B9, 0x80, REG_BITS_8},
	{0x91BA, 0x03, REG_BITS_8},
	{0x91BB, 0x03, REG_BITS_8},
	{0x91BC, 0x12, REG_BITS_8},
	{0x91BD, 0x0c, REG_BITS_8},
	{0x91BE, 0x48, REG_BITS_8},
	{0x91BF, 0xa0, REG_BITS_8},
	{0x91C0, 0xc0, REG_BITS_8},
	{0x91C1, 0x80, REG_BITS_8},
	{0x91C2, 0x02, REG_BITS_8},
	{0x91C3, 0x03, REG_BITS_8},
	{0x91C4, 0x08, REG_BITS_8},
	{0x91C5, 0x0c, REG_BITS_8},
	{0x91C6, 0x18, REG_BITS_8},
	{0x91C7, 0x20, REG_BITS_8},
	{0x91C8, 0x40, REG_BITS_8},
	{0x91C9, 0xe0, REG_BITS_8},
	{0x91CA, 0x40, REG_BITS_8},
	{0x91CB, 0x01, REG_BITS_8},
	{0x91CC, 0x05, REG_BITS_8},
	{0x91CD, 0x05, REG_BITS_8},
	{0x91CE, 0x08, REG_BITS_8},
	{0x91CF, 0x14, REG_BITS_8},
	{0x91D0, 0x20, REG_BITS_8},
	{0x91D1, 0x50, REG_BITS_8},
	{0x91D2, 0x80, REG_BITS_8},
	{0x91D3, 0x80, REG_BITS_8},
	{0x91D4, 0x02, REG_BITS_8},
	{0x91D5, 0x03, REG_BITS_8},
	{0x91D6, 0x0a, REG_BITS_8},
	{0x91D7, 0x0c, REG_BITS_8},
	{0x91D8, 0x20, REG_BITS_8},
	{0x91D9, 0x30, REG_BITS_8},
	{0x91DA, 0x60, REG_BITS_8},
	{0x91DB, 0x80, REG_BITS_8},
	{0x91DC, 0x00, REG_BITS_8},
	{0x91DD, 0x81, REG_BITS_8},
	{0x91DE, 0x03, REG_BITS_8},
	{0x91DF, 0x05, REG_BITS_8},
	{0x91E0, 0x14, REG_BITS_8},
	{0x91E1, 0x14, REG_BITS_8},
	{0x91E2, 0x20, REG_BITS_8},
	{0x91E3, 0x50, REG_BITS_8},
	{0x91E4, 0x80, REG_BITS_8},
	{0x91E5, 0x40, REG_BITS_8},
	{0x91E6, 0x01, REG_BITS_8},
	{0x91E7, 0x02, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x13, REG_BITS_8},
	{0xA003, 0x1a, REG_BITS_8},
	{0xA004, 0x54, REG_BITS_8},
	{0xA005, 0x81, REG_BITS_8},
	{0xA006, 0xda, REG_BITS_8},
	{0xA007, 0xa4, REG_BITS_8},
	{0xA008, 0x9e, REG_BITS_8},
	{0xA009, 0x23, REG_BITS_8},
	{0xA00A, 0x3d, REG_BITS_8},
	{0xA00B, 0x67, REG_BITS_8},
	{0xA00C, 0x44, REG_BITS_8},
	{0xA00D, 0xc9, REG_BITS_8},
	{0xA00E, 0xc9, REG_BITS_8},
	{0xA00F, 0x10, REG_BITS_8},
	{0xA010, 0x73, REG_BITS_8},
	{0xA011, 0x3e, REG_BITS_8},
	{0xA012, 0x44, REG_BITS_8},
	{0xA013, 0x9e, REG_BITS_8},
	{0xA014, 0x1f, REG_BITS_8},
	{0xA015, 0xf9, REG_BITS_8},
	{0xA016, 0x27, REG_BITS_8},
	{0xA017, 0x4c, REG_BITS_8},
	{0xA018, 0x07, REG_BITS_8},
	{0xA019, 0x8a, REG_BITS_8},
	{0xA01A, 0x93, REG_BITS_8},
	{0xA01B, 0x82, REG_BITS_8},
	{0xA01C, 0xe6, REG_BITS_8},
	{0xA01D, 0x44, REG_BITS_8},
	{0xA01E, 0x1f, REG_BITS_8},
	{0xA01F, 0x28, REG_BITS_8},
	{0xA020, 0x29, REG_BITS_8},
	{0xA021, 0x47, REG_BITS_8},
	{0xA022, 0x43, REG_BITS_8},
	{0xA023, 0xa9, REG_BITS_8},
	{0xA024, 0x71, REG_BITS_8},
	{0xA025, 0xcf, REG_BITS_8},
	{0xA026, 0x67, REG_BITS_8},
	{0xA027, 0xc8, REG_BITS_8},
	{0xA028, 0x33, REG_BITS_8},
	{0xA029, 0x9a, REG_BITS_8},
	{0xA02A, 0xf4, REG_BITS_8},
	{0xA02B, 0xf8, REG_BITS_8},
	{0xA02C, 0xc6, REG_BITS_8},
	{0xA02D, 0x41, REG_BITS_8},
	{0xA02E, 0xe6, REG_BITS_8},
	{0xA02F, 0x01, REG_BITS_8},
	{0xA030, 0x52, REG_BITS_8},
	{0xA031, 0x7f, REG_BITS_8},
	{0xA032, 0xc0, REG_BITS_8},
	{0xA033, 0x44, REG_BITS_8},
	{0xA034, 0x9d, REG_BITS_8},
	{0xA035, 0x13, REG_BITS_8},
	{0xA036, 0xb9, REG_BITS_8},
	{0xA037, 0x46, REG_BITS_8},
	{0xA038, 0x3e, REG_BITS_8},
	{0xA039, 0x83, REG_BITS_8},
	{0xA03A, 0xe1, REG_BITS_8},
	{0xA03B, 0x8d, REG_BITS_8},
	{0xA03C, 0x5a, REG_BITS_8},
	{0xA03D, 0x34, REG_BITS_8},
	{0xA03E, 0xc3, REG_BITS_8},
	{0xA03F, 0x15, REG_BITS_8},
	{0xA040, 0xc4, REG_BITS_8},
	{0xA041, 0x90, REG_BITS_8},
	{0xA042, 0x25, REG_BITS_8},
	{0xA043, 0x32, REG_BITS_8},
	{0xA044, 0x79, REG_BITS_8},
	{0xA045, 0x61, REG_BITS_8},
	{0xA046, 0x0d, REG_BITS_8},
	{0xA047, 0x68, REG_BITS_8},
	{0xA048, 0xcc, REG_BITS_8},
	{0xA049, 0x23, REG_BITS_8},
	{0xA04A, 0x9c, REG_BITS_8},
	{0xA04B, 0x09, REG_BITS_8},
	{0xA04C, 0x91, REG_BITS_8},
	{0xA04D, 0xa6, REG_BITS_8},
	{0xA04E, 0x3c, REG_BITS_8},
	{0xA04F, 0x83, REG_BITS_8},
	{0xA050, 0xb9, REG_BITS_8},
	{0xA051, 0x8d, REG_BITS_8},
	{0xA052, 0x55, REG_BITS_8},
	{0xA053, 0xf4, REG_BITS_8},
	{0xA054, 0xd2, REG_BITS_8},
	{0xA055, 0x93, REG_BITS_8},
	{0xA056, 0xac, REG_BITS_8},
	{0xA057, 0xc4, REG_BITS_8},
	{0xA058, 0x04, REG_BITS_8},
	{0xA059, 0x29, REG_BITS_8},
	{0xA05A, 0x39, REG_BITS_8},
	{0xA05B, 0x89, REG_BITS_8},
	{0xA05C, 0x4a, REG_BITS_8},
	{0xA05D, 0x53, REG_BITS_8},
	{0xA05E, 0xde, REG_BITS_8},
	{0xA05F, 0x52, REG_BITS_8},
	{0xA060, 0x17, REG_BITS_8},
	{0xA061, 0xd3, REG_BITS_8},
	{0xA062, 0x3c, REG_BITS_8},
	{0xA063, 0x66, REG_BITS_8},
	{0xA064, 0x39, REG_BITS_8},
	{0xA065, 0x83, REG_BITS_8},
	{0xA066, 0xe1, REG_BITS_8},
	{0xA067, 0x8d, REG_BITS_8},
	{0xA068, 0x59, REG_BITS_8},
	{0xA069, 0x1e, REG_BITS_8},
	{0xA06A, 0x93, REG_BITS_8},
	{0xA06B, 0x93, REG_BITS_8},
	{0xA06C, 0xa7, REG_BITS_8},
	{0xA06D, 0x74, REG_BITS_8},
	{0xA06E, 0x24, REG_BITS_8},
	{0xA06F, 0x25, REG_BITS_8},
	{0xA070, 0x0f, REG_BITS_8},
	{0xA071, 0xb9, REG_BITS_8},
	{0xA072, 0x08, REG_BITS_8},
	{0xA073, 0x46, REG_BITS_8},
	{0xA074, 0x46, REG_BITS_8},
	{0xA075, 0x12, REG_BITS_8},
	{0xA076, 0x13, REG_BITS_8},
	{0xA077, 0xa3, REG_BITS_8},
	{0xA078, 0x64, REG_BITS_8},
	{0xA079, 0xa5, REG_BITS_8},
	{0xA07A, 0x2f, REG_BITS_8},
	{0xA07B, 0x71, REG_BITS_8},
	{0xA07C, 0xf9, REG_BITS_8},
	{0xA07D, 0x0c, REG_BITS_8},
	{0xA07E, 0x5d, REG_BITS_8},
	{0xA07F, 0x50, REG_BITS_8},
	{0xA080, 0x83, REG_BITS_8},
	{0xA081, 0x15, REG_BITS_8},
	{0xA082, 0xbe, REG_BITS_8},
	{0xA083, 0xa4, REG_BITS_8},
	{0xA084, 0x44, REG_BITS_8},
	{0xA085, 0x27, REG_BITS_8},
	{0xA086, 0x0b, REG_BITS_8},
	{0xA087, 0x81, REG_BITS_8},
	{0xA088, 0xc8, REG_BITS_8},
	{0xA089, 0x3f, REG_BITS_8},
	{0xA08A, 0x00, REG_BITS_8},
	{0xA08B, 0x82, REG_BITS_8},
	{0xA08C, 0x10, REG_BITS_8},
	{0xA08D, 0x86, REG_BITS_8},
	{0xA08E, 0x88, REG_BITS_8},
	{0xA08F, 0x04, REG_BITS_8},
	{0xA090, 0x26, REG_BITS_8},
	{0xA091, 0x4d, REG_BITS_8},
	{0xA092, 0x59, REG_BITS_8},
	{0xA093, 0x4b, REG_BITS_8},
	{0xA094, 0x59, REG_BITS_8},
	{0xA095, 0x1c, REG_BITS_8},
	{0xA096, 0x33, REG_BITS_8},
	{0xA097, 0x17, REG_BITS_8},
	{0xA098, 0xd1, REG_BITS_8},
	{0xA099, 0x58, REG_BITS_8},
	{0xA09A, 0xe5, REG_BITS_8},
	{0xA09B, 0x2e, REG_BITS_8},
	{0xA09C, 0x28, REG_BITS_8},
	{0xA09D, 0xb9, REG_BITS_8},
	{0xA09E, 0x09, REG_BITS_8},
	{0xA09F, 0x43, REG_BITS_8},
	{0xA0A0, 0x1e, REG_BITS_8},
	{0xA0A1, 0x02, REG_BITS_8},
	{0xA0A2, 0x90, REG_BITS_8},
	{0xA0A3, 0x7f, REG_BITS_8},
	{0xA0A4, 0x24, REG_BITS_8},
	{0xA0A5, 0xa4, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x24, REG_BITS_8},
	{0xA0A8, 0x89, REG_BITS_8},
	{0xA0A9, 0xc9, REG_BITS_8},
	{0xA0AA, 0x53, REG_BITS_8},
	{0xA0AB, 0xd6, REG_BITS_8},
	{0xA0AC, 0x82, REG_BITS_8},
	{0xA0AD, 0x16, REG_BITS_8},
	{0xA0AE, 0xc6, REG_BITS_8},
	{0xA0AF, 0xfc, REG_BITS_8},
	{0xA0B0, 0x25, REG_BITS_8},
	{0xA0B1, 0x36, REG_BITS_8},
	{0xA0B2, 0x62, REG_BITS_8},
	{0xA0B3, 0x39, REG_BITS_8},
	{0xA0B4, 0x0c, REG_BITS_8},
	{0xA0B5, 0x4e, REG_BITS_8},
	{0xA0B6, 0x9a, REG_BITS_8},
	{0xA0B7, 0xe2, REG_BITS_8},
	{0xA0B8, 0x91, REG_BITS_8},
	{0xA0B9, 0x93, REG_BITS_8},
	{0xA0BA, 0x48, REG_BITS_8},
	{0xA0BB, 0xc4, REG_BITS_8},
	{0xA0BC, 0x22, REG_BITS_8},
	{0xA0BD, 0x1c, REG_BITS_8},
	{0xA0BE, 0x21, REG_BITS_8},
	{0xA0BF, 0xc9, REG_BITS_8},
	{0xA0C0, 0x4d, REG_BITS_8},
	{0xA0C1, 0x8e, REG_BITS_8},
	{0xA0C2, 0x02, REG_BITS_8},
	{0xA0C3, 0x96, REG_BITS_8},
	{0xA0C4, 0xc0, REG_BITS_8},
	{0xA0C5, 0xdc, REG_BITS_8},
	{0xA0C6, 0x65, REG_BITS_8},
	{0xA0C7, 0x34, REG_BITS_8},
	{0xA0C8, 0x9f, REG_BITS_8},
	{0xA0C9, 0xe1, REG_BITS_8},
	{0xA0CA, 0x0e, REG_BITS_8},
	{0xA0CB, 0x60, REG_BITS_8},
	{0xA0CC, 0x5c, REG_BITS_8},
	{0xA0CD, 0x73, REG_BITS_8},
	{0xA0CE, 0x95, REG_BITS_8},
	{0xA0CF, 0xbb, REG_BITS_8},
	{0xA0D0, 0x08, REG_BITS_8},
	{0xA0D1, 0x05, REG_BITS_8},
	{0xA0D2, 0x2b, REG_BITS_8},
	{0xA0D3, 0x38, REG_BITS_8},
	{0xA0D4, 0x41, REG_BITS_8},
	{0xA0D5, 0x4a, REG_BITS_8},
	{0xA0D6, 0x50, REG_BITS_8},
	{0xA0D7, 0xac, REG_BITS_8},
	{0xA0D8, 0x82, REG_BITS_8},
	{0xA0D9, 0x15, REG_BITS_8},
	{0xA0DA, 0xbb, REG_BITS_8},
	{0xA0DB, 0x00, REG_BITS_8},
	{0xA0DC, 0xc6, REG_BITS_8},
	{0xA0DD, 0x35, REG_BITS_8},
	{0xA0DE, 0x9c, REG_BITS_8},
	{0xA0DF, 0xa1, REG_BITS_8},
	{0xA0E0, 0xce, REG_BITS_8},
	{0xA0E1, 0x75, REG_BITS_8},
	{0xA0E2, 0x4c, REG_BITS_8},
	{0xA0E3, 0x14, REG_BITS_8},
	{0xA0E4, 0x9b, REG_BITS_8},
	{0xA0E5, 0xf8, REG_BITS_8},
	{0xA0E6, 0x20, REG_BITS_8},
	{0xA0E7, 0x26, REG_BITS_8},
	{0xA0E8, 0x37, REG_BITS_8},
	{0xA0E9, 0x73, REG_BITS_8},
	{0xA0EA, 0xf1, REG_BITS_8},
	{0xA0EB, 0x8c, REG_BITS_8},
	{0xA0EC, 0x5a, REG_BITS_8},
	{0xA0ED, 0x24, REG_BITS_8},
	{0xA0EE, 0x33, REG_BITS_8},
	{0xA0EF, 0x17, REG_BITS_8},
	{0xA0F0, 0xd0, REG_BITS_8},
	{0xA0F1, 0x24, REG_BITS_8},
	{0xA0F2, 0x86, REG_BITS_8},
	{0xA0F3, 0x37, REG_BITS_8},
	{0xA0F4, 0xb3, REG_BITS_8},
	{0xA0F5, 0xc9, REG_BITS_8},
	{0xA0F6, 0x4f, REG_BITS_8},
	{0xA0F7, 0x76, REG_BITS_8},
	{0xA0F8, 0x56, REG_BITS_8},
	{0xA0F9, 0xf4, REG_BITS_8},
	{0xA0FA, 0x21, REG_BITS_8},
	{0xA0FB, 0x3e, REG_BITS_8},
	{0xA0FC, 0x01, REG_BITS_8},
	{0xA0FD, 0x08, REG_BITS_8},
	{0xA0FE, 0x4a, REG_BITS_8},
	{0xA0FF, 0xd6, REG_BITS_8},
	{0xA100, 0xf9, REG_BITS_8},
	{0xA101, 0xd0, REG_BITS_8},
	{0xA102, 0x6d, REG_BITS_8},
	{0xA103, 0x04, REG_BITS_8},
	{0xA104, 0x24, REG_BITS_8},
	{0xA105, 0x1b, REG_BITS_8},
	{0xA106, 0xfc, REG_BITS_8},
	{0xA107, 0xe4, REG_BITS_8},
	{0xA108, 0x06, REG_BITS_8},
	{0xA109, 0x40, REG_BITS_8},
	{0xA10A, 0xd8, REG_BITS_8},
	{0xA10B, 0x19, REG_BITS_8},
	{0xA10C, 0x11, REG_BITS_8},
	{0xA10D, 0x81, REG_BITS_8},
	{0xA10E, 0xba, REG_BITS_8},
	{0xA10F, 0x04, REG_BITS_8},
	{0xA110, 0x22, REG_BITS_8},
	{0xA111, 0x41, REG_BITS_8},
	{0xA112, 0xed, REG_BITS_8},
	{0xA113, 0xe8, REG_BITS_8},
	{0xA114, 0x53, REG_BITS_8},
	{0xA115, 0x21, REG_BITS_8},
	{0xA116, 0xca, REG_BITS_8},
	{0xA117, 0x13, REG_BITS_8},
	{0xA118, 0x80, REG_BITS_8},
	{0xA119, 0xa2, REG_BITS_8},
	{0xA11A, 0x24, REG_BITS_8},
	{0xA11B, 0x1e, REG_BITS_8},
	{0xA11C, 0x1c, REG_BITS_8},
	{0xA11D, 0x79, REG_BITS_8},
	{0xA11E, 0xe7, REG_BITS_8},
	{0xA11F, 0x45, REG_BITS_8},
	{0xA120, 0xe6, REG_BITS_8},
	{0xA121, 0xa1, REG_BITS_8},
	{0xA122, 0x51, REG_BITS_8},
	{0xA123, 0x80, REG_BITS_8},
	{0xA124, 0xb8, REG_BITS_8},
	{0xA125, 0x24, REG_BITS_8},
	{0xA126, 0x22, REG_BITS_8},
	{0xA127, 0x43, REG_BITS_8},
	{0xA128, 0xc5, REG_BITS_8},
	{0xA129, 0xa8, REG_BITS_8},
	{0xA12A, 0x52, REG_BITS_8},
	{0xA12B, 0xfc, REG_BITS_8},
	{0xA12C, 0xf1, REG_BITS_8},
	{0xA12D, 0x90, REG_BITS_8},
	{0xA12E, 0x7b, REG_BITS_8},
	{0xA12F, 0x1c, REG_BITS_8},
	{0xA130, 0x34, REG_BITS_8},
	{0xA131, 0x9d, REG_BITS_8},
	{0xA132, 0xf9, REG_BITS_8},
	{0xA133, 0xf4, REG_BITS_8},
	{0xA134, 0x26, REG_BITS_8},
	{0xA135, 0x3b, REG_BITS_8},
	{0xA136, 0xbc, REG_BITS_8},
	{0xA137, 0x79, REG_BITS_8},
	{0xA138, 0x4e, REG_BITS_8},
	{0xA139, 0x70, REG_BITS_8},
	{0xA13A, 0xa6, REG_BITS_8},
	{0xA13B, 0x23, REG_BITS_8},
	{0xA13C, 0x1d, REG_BITS_8},
	{0xA13D, 0xf8, REG_BITS_8},
	{0xA13E, 0xa4, REG_BITS_8},
	{0xA13F, 0xa7, REG_BITS_8},
	{0xA140, 0x41, REG_BITS_8},
	{0xA141, 0xef, REG_BITS_8},
	{0xA142, 0xa1, REG_BITS_8},
	{0xA143, 0x50, REG_BITS_8},
	{0xA144, 0x7c, REG_BITS_8},
	{0xA145, 0x24, REG_BITS_8},
	{0xA146, 0xb4, REG_BITS_8},
	{0xA147, 0x1d, REG_BITS_8},
	{0xA148, 0xfd, REG_BITS_8},
	{0xA149, 0xdc, REG_BITS_8},
	{0xA14A, 0x06, REG_BITS_8},
	{0xA14B, 0x3a, REG_BITS_8},
	{0xA14C, 0x9a, REG_BITS_8},
	{0xA14D, 0x89, REG_BITS_8},
	{0xA14E, 0x0d, REG_BITS_8},
	{0xA14F, 0x66, REG_BITS_8},
	{0xA150, 0x4c, REG_BITS_8},
	{0xA151, 0xb3, REG_BITS_8},
	{0xA152, 0x19, REG_BITS_8},
	{0xA153, 0xd5, REG_BITS_8},
	{0xA154, 0xc4, REG_BITS_8},
	{0xA155, 0x26, REG_BITS_8},
	{0xA156, 0x39, REG_BITS_8},
	{0xA157, 0xd3, REG_BITS_8},
	{0xA158, 0x91, REG_BITS_8},
	{0xA159, 0x4f, REG_BITS_8},
	{0xA15A, 0x7a, REG_BITS_8},
	{0xA15B, 0x16, REG_BITS_8},
	{0xA15C, 0xa4, REG_BITS_8},
	{0xA15D, 0x1b, REG_BITS_8},
	{0xA15E, 0xec, REG_BITS_8},
	{0xA15F, 0x64, REG_BITS_8},
	{0xA160, 0x26, REG_BITS_8},
	{0xA161, 0x36, REG_BITS_8},
	{0xA162, 0x76, REG_BITS_8},
	{0xA163, 0x41, REG_BITS_8},
	{0xA164, 0xcc, REG_BITS_8},
	{0xA165, 0x58, REG_BITS_8},
	{0xA166, 0xe2, REG_BITS_8},
	{0xA167, 0xa2, REG_BITS_8},
	{0xA168, 0x95, REG_BITS_8},
	{0xA169, 0xb1, REG_BITS_8},
	{0xA16A, 0x80, REG_BITS_8},
	{0xA16B, 0x85, REG_BITS_8},
	{0xA16C, 0x2d, REG_BITS_8},
	{0xA16D, 0x72, REG_BITS_8},
	{0xA16E, 0x01, REG_BITS_8},
	{0xA16F, 0x8c, REG_BITS_8},
	{0xA170, 0x65, REG_BITS_8},
	{0xA171, 0x52, REG_BITS_8},
	{0xA172, 0x53, REG_BITS_8},
	{0xA173, 0x1b, REG_BITS_8},
	{0xA174, 0xe5, REG_BITS_8},
	{0xA175, 0x28, REG_BITS_8},
	{0xA176, 0xa6, REG_BITS_8},
	{0xA177, 0x34, REG_BITS_8},
	{0xA178, 0x71, REG_BITS_8},
	{0xA179, 0x29, REG_BITS_8},
	{0xA17A, 0xcc, REG_BITS_8},
	{0xA17B, 0x53, REG_BITS_8},
	{0xA17C, 0xb4, REG_BITS_8},
	{0xA17D, 0xc2, REG_BITS_8},
	{0xA17E, 0x13, REG_BITS_8},
	{0xA17F, 0xa1, REG_BITS_8},
	{0xA180, 0xc8, REG_BITS_8},
	{0xA181, 0xa4, REG_BITS_8},
	{0xA182, 0x26, REG_BITS_8},
	{0xA183, 0x38, REG_BITS_8},
	{0xA184, 0xf1, REG_BITS_8},
	{0xA185, 0x89, REG_BITS_8},
	{0xA186, 0x52, REG_BITS_8},
	{0xA187, 0xa6, REG_BITS_8},
	{0xA188, 0xe2, REG_BITS_8},
	{0xA189, 0x96, REG_BITS_8},
	{0xA18A, 0xbd, REG_BITS_8},
	{0xA18B, 0x0c, REG_BITS_8},
	{0xA18C, 0x86, REG_BITS_8},
	{0xA18D, 0x32, REG_BITS_8},
	{0xA18E, 0x6f, REG_BITS_8},
	{0xA18F, 0x21, REG_BITS_8},
	{0xA190, 0x0c, REG_BITS_8},
	{0xA191, 0x56, REG_BITS_8},
	{0xA192, 0xd0, REG_BITS_8},
	{0xA193, 0x42, REG_BITS_8},
	{0xA194, 0x13, REG_BITS_8},
	{0xA195, 0x9e, REG_BITS_8},
	{0xA196, 0x74, REG_BITS_8},
	{0xA197, 0xe4, REG_BITS_8},
	{0xA198, 0x23, REG_BITS_8},
	{0xA199, 0x12, REG_BITS_8},
	{0xA19A, 0x91, REG_BITS_8},
	{0xA19B, 0xc8, REG_BITS_8},
	{0xA19C, 0x46, REG_BITS_8},
	{0xA19D, 0x38, REG_BITS_8},
	{0xA19E, 0x02, REG_BITS_8},
	{0xA19F, 0x13, REG_BITS_8},
	{0xA1A0, 0x9a, REG_BITS_8},
	{0xA1A1, 0x48, REG_BITS_8},
	{0xA1A2, 0xa5, REG_BITS_8},
	{0xA1A3, 0x2b, REG_BITS_8},
	{0xA1A4, 0x65, REG_BITS_8},
	{0xA1A5, 0xa9, REG_BITS_8},
	{0xA1A6, 0x4b, REG_BITS_8},
	{0xA1A7, 0x58, REG_BITS_8},
	{0xA1A8, 0xe6, REG_BITS_8},
	{0xA1A9, 0xb2, REG_BITS_8},
	{0xA1AA, 0x94, REG_BITS_8},
	{0xA1AB, 0xab, REG_BITS_8},
	{0xA1AC, 0x90, REG_BITS_8},
	{0xA1AD, 0x44, REG_BITS_8},
	{0xA1AE, 0x25, REG_BITS_8},
	{0xA1AF, 0x0a, REG_BITS_8},
	{0xA1B0, 0x69, REG_BITS_8},
	{0xA1B1, 0x08, REG_BITS_8},
	{0xA1B2, 0x40, REG_BITS_8},
	{0xA1B3, 0x02, REG_BITS_8},
	{0xA1B4, 0x92, REG_BITS_8},
	{0xA1B5, 0x90, REG_BITS_8},
	{0xA1B6, 0x84, REG_BITS_8},
	{0xA1B7, 0x7c, REG_BITS_8},
	{0xA1B8, 0x44, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x44, REG_BITS_8},
	{0xA1BB, 0x71, REG_BITS_8},
	{0xA1BC, 0xca, REG_BITS_8},
	{0xA1BD, 0x55, REG_BITS_8},
	{0xA1BE, 0xca, REG_BITS_8},
	{0xA1BF, 0x02, REG_BITS_8},
	{0xA1C0, 0x96, REG_BITS_8},
	{0xA1C1, 0xb7, REG_BITS_8},
	{0xA1C2, 0x28, REG_BITS_8},
	{0xA1C3, 0x85, REG_BITS_8},
	{0xA1C4, 0x2a, REG_BITS_8},
	{0xA1C5, 0x23, REG_BITS_8},
	{0xA1C6, 0x39, REG_BITS_8},
	{0xA1C7, 0x49, REG_BITS_8},
	{0xA1C8, 0x42, REG_BITS_8},
	{0xA1C9, 0x16, REG_BITS_8},
	{0xA1CA, 0xf2, REG_BITS_8},
	{0xA1CB, 0x0f, REG_BITS_8},
	{0xA1CC, 0x7f, REG_BITS_8},
	{0xA1CD, 0x1c, REG_BITS_8},
	{0xA1CE, 0xe4, REG_BITS_8},
	{0xA1CF, 0x20, REG_BITS_8},
	{0xA1D0, 0x1e, REG_BITS_8},
	{0xA1D1, 0x11, REG_BITS_8},
	{0xA1D2, 0x89, REG_BITS_8},
	{0xA1D3, 0x50, REG_BITS_8},
	{0xA1D4, 0x9a, REG_BITS_8},
	{0xA1D5, 0x42, REG_BITS_8},
	{0xA1D6, 0x95, REG_BITS_8},
	{0xA1D7, 0xb2, REG_BITS_8},
	{0xA1D8, 0xac, REG_BITS_8},
	{0xA1D9, 0x05, REG_BITS_8},
	{0xA1DA, 0x2f, REG_BITS_8},
	{0xA1DB, 0x56, REG_BITS_8},
	{0xA1DC, 0xe9, REG_BITS_8},
	{0xA1DD, 0x0a, REG_BITS_8},
	{0xA1DE, 0x4c, REG_BITS_8},
	{0xA1DF, 0x6a, REG_BITS_8},
	{0xA1E0, 0x82, REG_BITS_8},
	{0xA1E1, 0x91, REG_BITS_8},
	{0xA1E2, 0x8d, REG_BITS_8},
	{0xA1E3, 0x34, REG_BITS_8},
	{0xA1E4, 0xc4, REG_BITS_8},
	{0xA1E5, 0x21, REG_BITS_8},
	{0xA1E6, 0x16, REG_BITS_8},
	{0xA1E7, 0xc1, REG_BITS_8},
	{0xA1E8, 0xc8, REG_BITS_8},
	{0xA1E9, 0x4a, REG_BITS_8},
	{0xA1EA, 0x64, REG_BITS_8},
	{0xA1EB, 0xe2, REG_BITS_8},
	{0xA1EC, 0x14, REG_BITS_8},
	{0xA1ED, 0xae, REG_BITS_8},
	{0xA1EE, 0x7c, REG_BITS_8},
	{0xA1EF, 0x85, REG_BITS_8},
	{0xA1F0, 0x2e, REG_BITS_8},
	{0xA1F1, 0x88, REG_BITS_8},
	{0xA1F2, 0xb1, REG_BITS_8},
	{0xA1F3, 0x8c, REG_BITS_8},
	{0xA1F4, 0x5b, REG_BITS_8},
	{0xA1F5, 0xf0, REG_BITS_8},
	{0xA1F6, 0xa2, REG_BITS_8},
	{0xA1F7, 0x14, REG_BITS_8},
	{0xA1F8, 0xa9, REG_BITS_8},
	{0xA1F9, 0xe0, REG_BITS_8},
	{0xA1FA, 0xa4, REG_BITS_8},
	{0xA1FB, 0x27, REG_BITS_8},
	{0xA1FC, 0x2d, REG_BITS_8},
	{0xA1FD, 0x91, REG_BITS_8},
	{0xA1FE, 0x09, REG_BITS_8},
	{0xA1FF, 0x4d, REG_BITS_8},
	{0xA200, 0x78, REG_BITS_8},
	{0xA201, 0x52, REG_BITS_8},
	{0xA202, 0x94, REG_BITS_8},
	{0xA203, 0xaa, REG_BITS_8},
	{0xA204, 0x98, REG_BITS_8},
	{0xA205, 0x85, REG_BITS_8},
	{0xA206, 0x2f, REG_BITS_8},
	{0xA207, 0x7d, REG_BITS_8},
	{0xA208, 0xb1, REG_BITS_8},
	{0xA209, 0x0c, REG_BITS_8},
	{0xA20A, 0x6f, REG_BITS_8},
	{0xA20B, 0xa0, REG_BITS_8},
	{0xA20C, 0xb3, REG_BITS_8},
	{0xA20D, 0x19, REG_BITS_8},
	{0xA20E, 0xd5, REG_BITS_8},
	{0xA20F, 0xdc, REG_BITS_8},
	{0xA210, 0x65, REG_BITS_8},
	{0xA211, 0x30, REG_BITS_8},
	{0xA212, 0x63, REG_BITS_8},
	{0xA213, 0x71, REG_BITS_8},
	{0xA214, 0x0b, REG_BITS_8},
	{0xA215, 0x56, REG_BITS_8},
	{0xA216, 0xca, REG_BITS_8},
	{0xA217, 0xf2, REG_BITS_8},
	{0xA218, 0x95, REG_BITS_8},
	{0xA219, 0xb7, REG_BITS_8},
	{0xA21A, 0xb4, REG_BITS_8},
	{0xA21B, 0xc5, REG_BITS_8},
	{0xA21C, 0x30, REG_BITS_8},
	{0xA21D, 0x8f, REG_BITS_8},
	{0xA21E, 0x79, REG_BITS_8},
	{0xA21F, 0xcd, REG_BITS_8},
	{0xA220, 0x6b, REG_BITS_8},
	{0xA221, 0xa8, REG_BITS_8},
	{0xA222, 0xf3, REG_BITS_8},
	{0xA223, 0x9f, REG_BITS_8},
	{0xA224, 0x0c, REG_BITS_8},
	{0xA225, 0x8d, REG_BITS_8},
	{0xA226, 0x47, REG_BITS_8},
	{0xA227, 0x3f, REG_BITS_8},
	{0xA228, 0xbd, REG_BITS_8},
	{0xA229, 0x89, REG_BITS_8},
	{0xA22A, 0x8e, REG_BITS_8},
	{0xA22B, 0x67, REG_BITS_8},
	{0xA22C, 0x66, REG_BITS_8},
	{0xA22D, 0x63, REG_BITS_8},
	{0xA22E, 0x19, REG_BITS_8},
	{0xA22F, 0xd8, REG_BITS_8},
	{0xA230, 0x70, REG_BITS_8},
	{0xA231, 0x06, REG_BITS_8},
	{0xA232, 0x37, REG_BITS_8},
	{0xA233, 0xb4, REG_BITS_8},
	{0xA234, 0xa9, REG_BITS_8},
	{0xA235, 0xce, REG_BITS_8},
	{0xA236, 0x75, REG_BITS_8},
	{0xA237, 0xfe, REG_BITS_8},
	{0xA238, 0xf3, REG_BITS_8},
	{0xA239, 0x1e, REG_BITS_8},
	{0xA23A, 0x0c, REG_BITS_8},
	{0xA23B, 0x79, REG_BITS_8},
	{0xA23C, 0x08, REG_BITS_8},
	{0xA23D, 0x47, REG_BITS_8},
	{0xA23E, 0x03, REG_BITS_8},
	{0xA23F, 0xda, REG_BITS_8},
	{0xA240, 0xd0, REG_BITS_8},
	{0xA241, 0x78, REG_BITS_8},
	{0xA242, 0xf6, REG_BITS_8},
	{0xA243, 0x53, REG_BITS_8},
	{0xA244, 0x1c, REG_BITS_8},
	{0xA245, 0xf0, REG_BITS_8},
	{0xA246, 0xf4, REG_BITS_8},
	{0xA247, 0xc6, REG_BITS_8},
	{0xA248, 0x3b, REG_BITS_8},
	{0xA249, 0xc3, REG_BITS_8},
	{0xA24A, 0x31, REG_BITS_8},
	{0xA24B, 0x0f, REG_BITS_8},
	{0xA24C, 0x77, REG_BITS_8},
	{0xA24D, 0x04, REG_BITS_8},
	{0xA24E, 0x74, REG_BITS_8},
	{0xA24F, 0x9f, REG_BITS_8},
	{0xA250, 0x10, REG_BITS_8},
	{0xA251, 0x01, REG_BITS_8},
	{0xA252, 0x48, REG_BITS_8},
	{0xA253, 0x45, REG_BITS_8},
	{0xA254, 0x34, REG_BITS_8},
	{0xA255, 0x4a, REG_BITS_8},
	{0xA256, 0x11, REG_BITS_8},
	{0xA257, 0x85, REG_BITS_8},
	{0xA258, 0xf0, REG_BITS_8},
	{0xA259, 0x23, REG_BITS_8},
	{0xA25A, 0x1f, REG_BITS_8},
	{0xA25B, 0xfc, REG_BITS_8},
	{0xA25C, 0x60, REG_BITS_8},
	{0xA25D, 0xc8, REG_BITS_8},
	{0xA25E, 0x46, REG_BITS_8},
	{0xA25F, 0x3e, REG_BITS_8},
	{0xA260, 0x6a, REG_BITS_8},
	{0xA261, 0x51, REG_BITS_8},
	{0xA262, 0x85, REG_BITS_8},
	{0xA263, 0xd8, REG_BITS_8},
	{0xA264, 0xb3, REG_BITS_8},
	{0xA265, 0x9c, REG_BITS_8},
	{0xA266, 0xe2, REG_BITS_8},
	{0xA267, 0x2c, REG_BITS_8},
	{0xA268, 0xa7, REG_BITS_8},
	{0xA269, 0x3d, REG_BITS_8},
	{0xA26A, 0x1b, REG_BITS_8},
	{0xA26B, 0xa2, REG_BITS_8},
	{0xA26C, 0x11, REG_BITS_8},
	{0xA26D, 0x7d, REG_BITS_8},
	{0xA26E, 0x94, REG_BITS_8},
	{0xA26F, 0x73, REG_BITS_8},
	{0xA270, 0x19, REG_BITS_8},
	{0xA271, 0xbf, REG_BITS_8},
	{0xA272, 0xd4, REG_BITS_8},
	{0xA273, 0xe5, REG_BITS_8},
	{0xA274, 0x2f, REG_BITS_8},
	{0xA275, 0x97, REG_BITS_8},
	{0xA276, 0x49, REG_BITS_8},
	{0xA277, 0x0e, REG_BITS_8},
	{0xA278, 0x7c, REG_BITS_8},
	{0xA279, 0x6c, REG_BITS_8},
	{0xA27A, 0x23, REG_BITS_8},
	{0xA27B, 0x99, REG_BITS_8},
	{0xA27C, 0xaf, REG_BITS_8},
	{0xA27D, 0x14, REG_BITS_8},
	{0xA27E, 0x65, REG_BITS_8},
	{0xA27F, 0x27, REG_BITS_8},
	{0xA280, 0x46, REG_BITS_8},
	{0xA281, 0xf9, REG_BITS_8},
	{0xA282, 0x4a, REG_BITS_8},
	{0xA283, 0x64, REG_BITS_8},
	{0xA284, 0x66, REG_BITS_8},
	{0xA285, 0xd3, REG_BITS_8},
	{0xA286, 0x18, REG_BITS_8},
	{0xA287, 0xb6, REG_BITS_8},
	{0xA288, 0xec, REG_BITS_8},
	{0xA289, 0xc4, REG_BITS_8},
	{0xA28A, 0x23, REG_BITS_8},
	{0xA28B, 0x13, REG_BITS_8},
	{0xA28C, 0xe9, REG_BITS_8},
	{0xA28D, 0x88, REG_BITS_8},
	{0xA28E, 0x4e, REG_BITS_8},
	{0xA28F, 0xda, REG_BITS_8},
	{0xA290, 0xd2, REG_BITS_8},
	{0xA291, 0x18, REG_BITS_8},
	{0xA292, 0xbd, REG_BITS_8},
	{0xA293, 0x6c, REG_BITS_8},
	{0xA294, 0x25, REG_BITS_8},
	{0xA295, 0x25, REG_BITS_8},
	{0xA296, 0x0b, REG_BITS_8},
	{0xA297, 0xf9, REG_BITS_8},
	{0xA298, 0x07, REG_BITS_8},
	{0xA299, 0x42, REG_BITS_8},
	{0xA29A, 0x4e, REG_BITS_8},
	{0xA29B, 0xd2, REG_BITS_8},
	{0xA29C, 0x95, REG_BITS_8},
	{0xA29D, 0xbe, REG_BITS_8},
	{0xA29E, 0xf0, REG_BITS_8},
	{0xA29F, 0xa5, REG_BITS_8},
	{0xA2A0, 0x2b, REG_BITS_8},
	{0xA2A1, 0x2b, REG_BITS_8},
	{0xA2A2, 0x61, REG_BITS_8},
	{0xA2A3, 0x08, REG_BITS_8},
	{0xA2A4, 0x40, REG_BITS_8},
	{0xA2A5, 0x14, REG_BITS_8},
	{0xA2A6, 0x82, REG_BITS_8},
	{0xA2A7, 0x12, REG_BITS_8},
	{0xA2A8, 0xaf, REG_BITS_8},
	{0xA2A9, 0xf8, REG_BITS_8},
	{0xA2AA, 0xe5, REG_BITS_8},
	{0xA2AB, 0x31, REG_BITS_8},
	{0xA2AC, 0x6f, REG_BITS_8},
	{0xA2AD, 0x01, REG_BITS_8},
	{0xA2AE, 0x8a, REG_BITS_8},
	{0xA2AF, 0x48, REG_BITS_8},
	{0xA2B0, 0x2a, REG_BITS_8},
	{0xA2B1, 0x12, REG_BITS_8},
	{0xA2B2, 0x12, REG_BITS_8},
	{0xA2B3, 0x9f, REG_BITS_8},
	{0xA2B4, 0xc4, REG_BITS_8},
	{0xA2B5, 0x25, REG_BITS_8},
	{0xA2B6, 0x32, REG_BITS_8},
	{0xA2B7, 0xb5, REG_BITS_8},
	{0xA2B8, 0x99, REG_BITS_8},
	{0xA2B9, 0x4c, REG_BITS_8},
	{0xA2BA, 0x59, REG_BITS_8},
	{0xA2BB, 0x98, REG_BITS_8},
	{0xA2BC, 0x02, REG_BITS_8},
	{0xA2BD, 0x14, REG_BITS_8},
	{0xA2BE, 0xa6, REG_BITS_8},
	{0xA2BF, 0xa0, REG_BITS_8},
	{0xA2C0, 0x45, REG_BITS_8},
	{0xA2C1, 0x33, REG_BITS_8},
	{0xA2C2, 0xbc, REG_BITS_8},
	{0xA2C3, 0x99, REG_BITS_8},
	{0xA2C4, 0xcf, REG_BITS_8},
	{0xA2C5, 0x72, REG_BITS_8},
	{0xA2C6, 0x3e, REG_BITS_8},
	{0xA2C7, 0x53, REG_BITS_8},
	{0xA2C8, 0x98, REG_BITS_8},
	{0xA2C9, 0xbd, REG_BITS_8},
	{0xA2CA, 0x1c, REG_BITS_8},
	{0xA2CB, 0x46, REG_BITS_8},
	{0xA2CC, 0x34, REG_BITS_8},
	{0xA2CD, 0xd6, REG_BITS_8},
	{0xA2CE, 0x11, REG_BITS_8},
	{0xA2CF, 0x10, REG_BITS_8},
	{0xA2D0, 0x8d, REG_BITS_8},
	{0xA2D1, 0x32, REG_BITS_8},
	{0xA2D2, 0x24, REG_BITS_8},
	{0xA2D3, 0x1f, REG_BITS_8},
	{0xA2D4, 0xe9, REG_BITS_8},
	{0xA2D5, 0x28, REG_BITS_8},
	{0xA2D6, 0x67, REG_BITS_8},
	{0xA2D7, 0x3a, REG_BITS_8},
	{0xA2D8, 0xf8, REG_BITS_8},
	{0xA2D9, 0x59, REG_BITS_8},
	{0xA2DA, 0x11, REG_BITS_8},
	{0xA2DB, 0x92, REG_BITS_8},
	{0xA2DC, 0x94, REG_BITS_8},
	{0xA2DD, 0x34, REG_BITS_8},
	{0xA2DE, 0x23, REG_BITS_8},
	{0xA2DF, 0x0d, REG_BITS_8},
	{0xA2E0, 0xf9, REG_BITS_8},
	{0xA2E1, 0xe7, REG_BITS_8},
	{0xA2E2, 0x3e, REG_BITS_8},
	{0xA2E3, 0x00, REG_BITS_8},
	{0xA2E4, 0x22, REG_BITS_8},
	{0xA2E5, 0xd1, REG_BITS_8},
	{0xA2E6, 0x91, REG_BITS_8},
	{0xA2E7, 0x9a, REG_BITS_8},
	{0xA2E8, 0x04, REG_BITS_8},
	{0xA2E9, 0x00, REG_BITS_8},
	{0xA2EA, 0x00, REG_BITS_8},
	{0xA2EB, 0x00, REG_BITS_8},
	{0xA2EC, 0x00, REG_BITS_8},
	{0xA2ED, 0x00, REG_BITS_8},
	{0x0060, 0x00, REG_BITS_8},
	{0x0061, 0x80, REG_BITS_8},
	{0x0062, 0x20, REG_BITS_8},
	{0x0068, 0x5F, REG_BITS_8},
	{0x0100, 0x00, REG_BITS_8},
	{0x0105, 0x40, REG_BITS_8},
	{0x01AE, 0x00, REG_BITS_8},
	{0x01B1, 0x80, REG_BITS_8},
	{0x01F8, 0x95, REG_BITS_8},
	{0x02D7, 0x10, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_period_2_ES1 =
    sizeof(seix006_vendor_0_period_2_ES1);

const struct reg_entry seix006_vendor_0_period_2_ES2[] = {
	{0x0105, 0x80, REG_BITS_8},
	{0x0387, 0x01, REG_BITS_8},
	{0x4A24, 0x1300, REG_BITS_16},
	{0x4A28, 0x0000, REG_BITS_16},
	{0x4A2C, 0xF8FF, REG_BITS_16},
	{0x4014, 0x5E0A, REG_BITS_16},
	{0x402E, 0x0A, REG_BITS_8},
	{0x4036, 0x1005, REG_BITS_16},
	{0x404D, 0xA0, REG_BITS_8},
	{0x4085, 0x04, REG_BITS_8},
	{0x409D, 0x33, REG_BITS_8},
	{0x409E, 0x2D, REG_BITS_8},
	{0x409F, 0x64, REG_BITS_8},
	{0x40A0, 0x5E, REG_BITS_8},
	{0x42C0, 0x07, REG_BITS_8},
	{0x42C1, 0x08, REG_BITS_8},
	{0x42C2, 0x07, REG_BITS_8},
	{0x42C6, 0x09, REG_BITS_8},
	{0x42C7, 0x0D, REG_BITS_8},
	{0x42C8, 0x0E, REG_BITS_8},
	{0x42C9, 0x10, REG_BITS_8},
	{0x42CA, 0x11, REG_BITS_8},
	{0x42CB, 0x10, REG_BITS_8},
	{0x42CC, 0x0E, REG_BITS_8},
	{0x42CD, 0x0D, REG_BITS_8},
	{0x42CE, 0x09, REG_BITS_8},
	{0x42CF, 0x0C, REG_BITS_8},
	{0x42D0, 0x13, REG_BITS_8},
	{0x42D1, 0x1F, REG_BITS_8},
	{0x42D2, 0x27, REG_BITS_8},
	{0x42D3, 0x33, REG_BITS_8},
	{0x42D4, 0x27, REG_BITS_8},
	{0x42D5, 0x1F, REG_BITS_8},
	{0x42D6, 0x13, REG_BITS_8},
	{0x42D7, 0x0C, REG_BITS_8},
	{0x42D8, 0x0D, REG_BITS_8},
	{0x42D9, 0x1F, REG_BITS_8},
	{0x42DA, 0x47, REG_BITS_8},
	{0x42DB, 0x4E, REG_BITS_8},
	{0x42DC, 0x56, REG_BITS_8},
	{0x42DD, 0x4E, REG_BITS_8},
	{0x42DE, 0x47, REG_BITS_8},
	{0x42DF, 0x1F, REG_BITS_8},
	{0x42E0, 0x0D, REG_BITS_8},
	{0x42E1, 0x0E, REG_BITS_8},
	{0x42E2, 0x2A, REG_BITS_8},
	{0x42E3, 0x4D, REG_BITS_8},
	{0x42E4, 0x5A, REG_BITS_8},
	{0x42E6, 0x5A, REG_BITS_8},
	{0x42E7, 0x4D, REG_BITS_8},
	{0x42E8, 0x2A, REG_BITS_8},
	{0x42E9, 0x0E, REG_BITS_8},
	{0x42EA, 0x0D, REG_BITS_8},
	{0x42EB, 0x1F, REG_BITS_8},
	{0x42EC, 0x3B, REG_BITS_8},
	{0x42ED, 0x43, REG_BITS_8},
	{0x42EE, 0x4B, REG_BITS_8},
	{0x42EF, 0x43, REG_BITS_8},
	{0x42F0, 0x3B, REG_BITS_8},
	{0x42F1, 0x1F, REG_BITS_8},
	{0x42F2, 0x0D, REG_BITS_8},
	{0x42F3, 0x0B, REG_BITS_8},
	{0x42F4, 0x11, REG_BITS_8},
	{0x42F5, 0x14, REG_BITS_8},
	{0x42F6, 0x18, REG_BITS_8},
	{0x42F8, 0x18, REG_BITS_8},
	{0x42F9, 0x14, REG_BITS_8},
	{0x42FA, 0x11, REG_BITS_8},
	{0x42FB, 0x0B, REG_BITS_8},
	{0x0104, 0x41, REG_BITS_8},
	{0x01BD, 0x01, REG_BITS_8},
	{0x01BE, 0x02, REG_BITS_8},
	{0x01BF, 0x03, REG_BITS_8},
	{0x01C0, 0x08, REG_BITS_8},
	{0x440A, 0x0010, REG_BITS_16},
	{0x5000, 0xA6FF, REG_BITS_16},
	{0x5002, 0xF3FF, REG_BITS_16},
	{0x5004, 0xDAFF, REG_BITS_16},
	{0x5006, 0xE6FF, REG_BITS_16},
	{0x5008, 0xFFFF, REG_BITS_16},
	{0x500A, 0xCDFF, REG_BITS_16},
	{0x500C, 0x9AFF, REG_BITS_16},
	{0x500E, 0xFAFF, REG_BITS_16},
	{0x5010, 0xDAFF, REG_BITS_16},
	{0x5012, 0xEDFF, REG_BITS_16},
	{0x5014, 0xFFFF, REG_BITS_16},
	{0x5016, 0xC0FF, REG_BITS_16},
	{0x5018, 0xACFF, REG_BITS_16},
	{0x501A, 0xEEFF, REG_BITS_16},
	{0x501C, 0xD1FF, REG_BITS_16},
	{0x501E, 0xF8FF, REG_BITS_16},
	{0x5020, 0xFDFF, REG_BITS_16},
	{0x5022, 0xB8FF, REG_BITS_16},
	{0x5024, 0xACFF, REG_BITS_16},
	{0x5026, 0x0600, REG_BITS_16},
	{0x5028, 0xD3FF, REG_BITS_16},
	{0x502A, 0x0000, REG_BITS_16},
	{0x502C, 0xF8FF, REG_BITS_16},
	{0x502E, 0x7AFF, REG_BITS_16},
	{0x5030, 0xACFF, REG_BITS_16},
	{0x5032, 0x0600, REG_BITS_16},
	{0x5034, 0xD3FF, REG_BITS_16},
	{0x5036, 0x0000, REG_BITS_16},
	{0x5038, 0xF8FF, REG_BITS_16},
	{0x503A, 0x7AFF, REG_BITS_16},
	{0x503C, 0x93FF, REG_BITS_16},
	{0x503E, 0xEEFF, REG_BITS_16},
	{0x5040, 0xD3FF, REG_BITS_16},
	{0x5042, 0x0000, REG_BITS_16},
	{0x5044, 0xFDFF, REG_BITS_16},
	{0x5046, 0xB3FF, REG_BITS_16},
	{0x5048, 0x93FF, REG_BITS_16},
	{0x504A, 0xEEFF, REG_BITS_16},
	{0x504C, 0xD3FF, REG_BITS_16},
	{0x504E, 0x0000, REG_BITS_16},
	{0x5050, 0xFDFF, REG_BITS_16},
	{0x5052, 0xB3FF, REG_BITS_16},
	{0x5055, 0x1C, REG_BITS_8},
	{0x5056, 0x3F, REG_BITS_8},
	{0x5057, 0x17, REG_BITS_8},
	{0x5058, 0x5D, REG_BITS_8},
	{0x505A, 0x6C, REG_BITS_8},
	{0x505B, 0x0E, REG_BITS_8},
	{0x505C, 0x95, REG_BITS_8},
	{0x505E, 0x41, REG_BITS_8},
	{0x505F, 0x12, REG_BITS_8},
	{0x5060, 0x4D, REG_BITS_8},
	{0x5061, 0x10, REG_BITS_8},
	{0x50A2, 0x48, REG_BITS_8},
	{0x50A3, 0x51, REG_BITS_8},
	{0x50A4, 0x48, REG_BITS_8},
	{0x50A5, 0x61, REG_BITS_8},
	{0x50A6, 0x48, REG_BITS_8},
	{0x50A7, 0x61, REG_BITS_8},
	{0x50A8, 0x48, REG_BITS_8},
	{0x50A9, 0x51, REG_BITS_8},
	{0x50AA, 0xF5FF, REG_BITS_16},
	{0x50AC, 0xECFF, REG_BITS_16},
	{0x50AE, 0xF5FF, REG_BITS_16},
	{0x50B0, 0xE1FF, REG_BITS_16},
	{0x50B2, 0xFAFF, REG_BITS_16},
	{0x50B4, 0xE1FF, REG_BITS_16},
	{0x50B6, 0xFAFF, REG_BITS_16},
	{0x50B8, 0xECFF, REG_BITS_16},
	{0x50BA, 0x48, REG_BITS_8},
	{0x50BB, 0x6E, REG_BITS_8},
	{0x50BC, 0x48, REG_BITS_8},
	{0x50BD, 0x73, REG_BITS_8},
	{0x50BE, 0x7C, REG_BITS_8},
	{0x50BF, 0x73, REG_BITS_8},
	{0x50C0, 0x7C, REG_BITS_8},
	{0x50C1, 0x6E, REG_BITS_8},
	{0x50C2, 0x12, REG_BITS_8},
	{0x5238, 0x0400, REG_BITS_16},
	{0x523A, 0x0800, REG_BITS_16},
	{0x523C, 0x0E00, REG_BITS_16},
	{0x523E, 0x1600, REG_BITS_16},
	{0x5240, 0x1E00, REG_BITS_16},
	{0x5242, 0x2600, REG_BITS_16},
	{0x5244, 0x2E00, REG_BITS_16},
	{0x5246, 0x3600, REG_BITS_16},
	{0x5248, 0x3D00, REG_BITS_16},
	{0x524A, 0x4300, REG_BITS_16},
	{0x524C, 0x4900, REG_BITS_16},
	{0x524E, 0x4E00, REG_BITS_16},
	{0x5250, 0x5400, REG_BITS_16},
	{0x5252, 0x5900, REG_BITS_16},
	{0x5254, 0x5E00, REG_BITS_16},
	{0x5256, 0x6300, REG_BITS_16},
	{0x5258, 0x6600, REG_BITS_16},
	{0x525A, 0x4300, REG_BITS_16},
	{0x525C, 0x8700, REG_BITS_16},
	{0x525E, 0xAF00, REG_BITS_16},
	{0x5260, 0xC800, REG_BITS_16},
	{0x5262, 0xDC00, REG_BITS_16},
	{0x5264, 0xEB00, REG_BITS_16},
	{0x5266, 0xF600, REG_BITS_16},
	{0x5268, 0x0001, REG_BITS_16},
	{0x526A, 0x0201, REG_BITS_16},
	{0x52A2, 0x1002, REG_BITS_16},
	{0x52A6, 0x1002, REG_BITS_16},
	{0x52AA, 0x1002, REG_BITS_16},
	{0x0105, 0x40, REG_BITS_8},
	{0x4E48, 0x2C1A, REG_BITS_16},
	{0x4E4C, 0x9065, REG_BITS_16},
	{0x4E4E, 0xD859, REG_BITS_16},
	{0x4E58, 0xDC1E, REG_BITS_16},
	{0x4E60, 0x0A0CC40C, REG_BITS_32},
	{0x4E64, 0xDDE01ADB, REG_BITS_32},
	{0x4E68, 0x2320C528, REG_BITS_32},
	{0x4E6C, 0x33003300, REG_BITS_32},
	{0x4E70, 0x0A0CC40C, REG_BITS_32},
	{0x4E74, 0xDDE01ADB, REG_BITS_32},
	{0x4E78, 0x2320C528, REG_BITS_32},
	{0x4E7C, 0x33003300, REG_BITS_32},
	{0x4F52, 0x00, REG_BITS_8},
	{0x4F54, 0x19, REG_BITS_8},
	{0x4F55, 0x19, REG_BITS_8},
	{0x4F56, 0x1D, REG_BITS_8},
	{0x4F59, 0x01, REG_BITS_8},
	{0x4F5A, 0x14, REG_BITS_8},
	{0x4F5B, 0x28, REG_BITS_8},
	{0x4F5C, 0x32, REG_BITS_8},
	{0x4F5D, 0x1C, REG_BITS_8},
	{0x4F60, 0x0A, REG_BITS_8},
	{0x4F6A, 0x00, REG_BITS_8},
	{0x4F6C, 0xDF63, REG_BITS_16},
	{0x4F6E, 0xDE63, REG_BITS_16},
	{0x0068, 0x5F, REG_BITS_8},
	{0x0105, 0x40, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_period_2_ES2 =
    sizeof(seix006_vendor_0_period_2_ES2);

const struct reg_entry seix006_vendor_1_period_3_ES1[] = {
	{0x5800, 0x00, REG_BITS_8},
	{0x5801, 0x00, REG_BITS_8},
	{0x5802, 0x00, REG_BITS_8},
	{0x5803, 0x00, REG_BITS_8},
	{0x5805, 0x00, REG_BITS_8},
	{0x5806, 0x00, REG_BITS_8},
	{0x5808, 0x00, REG_BITS_8},
	{0x5809, 0x00, REG_BITS_8},
	{0x580B, 0x00, REG_BITS_8},
	{0x580C, 0x00, REG_BITS_8},
	{0x580E, 0x00, REG_BITS_8},
	{0x580F, 0x00, REG_BITS_8},
	{0x5811, 0x00, REG_BITS_8},
	{0x5812, 0x00, REG_BITS_8},
	{0x5814, 0x00, REG_BITS_8},
	{0x5815, 0x00, REG_BITS_8},
	{0x5816, 0x00, REG_BITS_8},
	{0x5819, 0x00, REG_BITS_8},
	{0x581A, 0x00, REG_BITS_8},
	{0x581B, 0x00, REG_BITS_8},
	{0x581C, 0x00, REG_BITS_8},
	{0x581F, 0x00, REG_BITS_8},
	{0x5820, 0x00, REG_BITS_8},
	{0x5821, 0x00, REG_BITS_8},
	{0x5822, 0x00, REG_BITS_8},
	{0x5825, 0x00, REG_BITS_8},
	{0x5826, 0x00, REG_BITS_8},
	{0x5827, 0x00, REG_BITS_8},
	{0x5828, 0x00, REG_BITS_8},
	{0x5829, 0x00, REG_BITS_8},
	{0x582A, 0x00, REG_BITS_8},
	{0x582B, 0x00, REG_BITS_8},
	{0x582C, 0x00, REG_BITS_8},
	{0x582D, 0x00, REG_BITS_8},
	{0x582E, 0x00, REG_BITS_8},
	{0x582F, 0x00, REG_BITS_8},
	{0x5830, 0x00, REG_BITS_8},
	{0x5831, 0x00, REG_BITS_8},
	{0x5832, 0x00, REG_BITS_8},
	{0x5833, 0x00, REG_BITS_8},
	{0x5834, 0x00, REG_BITS_8},
	{0x5835, 0x00, REG_BITS_8},
	{0x5836, 0x00, REG_BITS_8},
	{0x5837, 0x00, REG_BITS_8},
	{0x5838, 0x00, REG_BITS_8},
	{0x5839, 0x00, REG_BITS_8},
	{0x583A, 0x00, REG_BITS_8},
	{0x583B, 0x00, REG_BITS_8},
	{0x583C, 0x00, REG_BITS_8},
	{0x583D, 0x00, REG_BITS_8},
	{0x583E, 0x00, REG_BITS_8},
	{0x583F, 0x00, REG_BITS_8},
	{0x5840, 0x00, REG_BITS_8},
	{0x5841, 0x07, REG_BITS_8},
	{0x5842, 0x07, REG_BITS_8},
	{0x5843, 0x07, REG_BITS_8},
	{0x5844, 0x07, REG_BITS_8},
	{0x5845, 0x07, REG_BITS_8},
	{0x5846, 0x07, REG_BITS_8},
	{0x5847, 0x07, REG_BITS_8},
	{0x5848, 0x07, REG_BITS_8},
	{0x5849, 0x07, REG_BITS_8},
	{0x584A, 0x07, REG_BITS_8},
	{0x584B, 0x07, REG_BITS_8},
	{0x584C, 0x07, REG_BITS_8},
	{0x584D, 0x07, REG_BITS_8},
	{0x584E, 0x07, REG_BITS_8},
	{0x584F, 0x07, REG_BITS_8},
	{0x5850, 0x01, REG_BITS_8},
	{0x5851, 0x00, REG_BITS_8},
	{0x5852, 0x02, REG_BITS_8},
	{0x5853, 0x03, REG_BITS_8},
	{0x5854, 0x04, REG_BITS_8},
	{0x5855, 0x01, REG_BITS_8},
	{0x5856, 0x01, REG_BITS_8},
	{0x5857, 0x01, REG_BITS_8},
	{0x5858, 0x2A0A, REG_BITS_16},
	{0x585A, 0x9603, REG_BITS_16},
	{0x585C, 0x0000, REG_BITS_16},
	{0x585E, 0x2B0A, REG_BITS_16},
	{0x5860, 0x2E06, REG_BITS_16},
	{0x5862, 0x3102, REG_BITS_16},
	{0x5864, 0x2B0A, REG_BITS_16},
	{0x5866, 0x2E06, REG_BITS_16},
	{0x5868, 0x3102, REG_BITS_16},
	{0x586A, 0x2B0A, REG_BITS_16},
	{0x586C, 0x2E06, REG_BITS_16},
	{0x586E, 0x3102, REG_BITS_16},
	{0x5870, 0x2B0A, REG_BITS_16},
	{0x5872, 0x2E06, REG_BITS_16},
	{0x5874, 0x3102, REG_BITS_16},
	{0x5876, 0xF709, REG_BITS_16},
	{0x5878, 0xA506, REG_BITS_16},
	{0x587A, 0x5203, REG_BITS_16},
	{0x587C, 0xA20A, REG_BITS_16},
	{0x587E, 0x4F07, REG_BITS_16},
	{0x5880, 0xFD03, REG_BITS_16},
	{0x5882, 0x290B, REG_BITS_16},
	{0x5884, 0x0001, REG_BITS_16},
	{0x5886, 0x0000, REG_BITS_16},
	{0x5888, 0x2400, REG_BITS_16},
	{0x588A, 0x0B00, REG_BITS_16},
	{0x588C, 0x0A00, REG_BITS_16},
	{0x588E, 0x3000, REG_BITS_16},
	{0x5890, 0x2800, REG_BITS_16},
	{0x5892, 0x2000, REG_BITS_16},
	{0x5894, 0x0400, REG_BITS_16},
	{0x5896, 0x0200, REG_BITS_16},
	{0x5898, 0x0200, REG_BITS_16},
	{0x589A, 0x0800, REG_BITS_16},
	{0x589C, 0x1200, REG_BITS_16},
	{0x589E, 0x1200, REG_BITS_16},
	{0x58A6, 0x0400, REG_BITS_16},
	{0x58A8, 0x0200, REG_BITS_16},
	{0x58AA, 0x0200, REG_BITS_16},
	{0x58AC, 0x0800, REG_BITS_16},
	{0x58AE, 0x1200, REG_BITS_16},
	{0x58B0, 0x1200, REG_BITS_16},
	{0x58B8, 0x0100, REG_BITS_16},
	{0x58BA, 0x0100, REG_BITS_16},
	{0x58BC, 0x0000, REG_BITS_16},
	{0x58BE, 0x0400, REG_BITS_16},
	{0x58C0, 0x0500, REG_BITS_16},
	{0x58C2, 0x0400, REG_BITS_16},
	{0x58CA, 0x0100, REG_BITS_16},
	{0x58CC, 0x0100, REG_BITS_16},
	{0x58CE, 0x0000, REG_BITS_16},
	{0x58D0, 0x0400, REG_BITS_16},
	{0x58D2, 0x0500, REG_BITS_16},
	{0x58D4, 0x0400, REG_BITS_16},
	{0x58DC, 0x0A00, REG_BITS_16},
	{0x58DE, 0x0400, REG_BITS_16},
	{0x58E0, 0x0400, REG_BITS_16},
	{0x58E2, 0x0E00, REG_BITS_16},
	{0x58E4, 0x0C00, REG_BITS_16},
	{0x58E6, 0x0A00, REG_BITS_16},
	{0x58EE, 0x0A00, REG_BITS_16},
	{0x58F0, 0x0400, REG_BITS_16},
	{0x58F2, 0x0500, REG_BITS_16},
	{0x58F4, 0x0E00, REG_BITS_16},
	{0x58F6, 0x0C00, REG_BITS_16},
	{0x58F8, 0x0D00, REG_BITS_16},
	{0x5900, 0x0000, REG_BITS_16},
	{0x5902, 0x0000, REG_BITS_16},
	{0x5904, 0x0000, REG_BITS_16},
	{0x5906, 0x5E01, REG_BITS_16},
	{0x5908, 0x5E01, REG_BITS_16},
	{0x590A, 0x5E01, REG_BITS_16},
	{0x590C, 0x2602, REG_BITS_16},
	{0x590E, 0x2602, REG_BITS_16},
	{0x5910, 0x2602, REG_BITS_16},
	{0x591E, 0x0300, REG_BITS_16},
	{0x5920, 0x0400, REG_BITS_16},
	{0x5922, 0x0400, REG_BITS_16},
	{0x5924, 0x0000, REG_BITS_16},
	{0x5926, 0x8200, REG_BITS_16},
	{0x5928, 0x0000, REG_BITS_16},
	{0x592A, 0x2003, REG_BITS_16},
	{0x592C, 0x2003, REG_BITS_16},
	{0x592E, 0x2003, REG_BITS_16},
	{0x5930, 0x8403, REG_BITS_16},
	{0x5932, 0x8403, REG_BITS_16},
	{0x5934, 0x8403, REG_BITS_16},
	{0x5942, 0x0300, REG_BITS_16},
	{0x5944, 0x0400, REG_BITS_16},
	{0x5946, 0x0400, REG_BITS_16},
	{0x5948, 0x0000, REG_BITS_16},
	{0x594A, 0x2300, REG_BITS_16},
	{0x594C, 0x0000, REG_BITS_16},
	{0x594E, 0x3200, REG_BITS_16},
	{0x5950, 0x2300, REG_BITS_16},
	{0x5952, 0x3200, REG_BITS_16},
	{0x5954, 0xC800, REG_BITS_16},
	{0x5956, 0x5D00, REG_BITS_16},
	{0x5958, 0xC800, REG_BITS_16},
	{0x5966, 0x0100, REG_BITS_16},
	{0x5968, 0x0000, REG_BITS_16},
	{0x596A, 0x0000, REG_BITS_16},
	{0x596C, 0x40, REG_BITS_8},
	{0x596D, 0x40, REG_BITS_8},
	{0x596E, 0x40, REG_BITS_8},
	{0x596F, 0x40, REG_BITS_8},
	{0x5970, 0x40, REG_BITS_8},
	{0x5971, 0x40, REG_BITS_8},
	{0x5972, 0x40, REG_BITS_8},
	{0x5973, 0x40, REG_BITS_8},
	{0x5974, 0x46, REG_BITS_8},
	{0x5975, 0x18, REG_BITS_8},
	{0x5976, 0x20, REG_BITS_8},
	{0x5977, 0x20, REG_BITS_8},
	{0x5978, 0x5A, REG_BITS_8},
	{0x5979, 0x5A, REG_BITS_8},
	{0x597A, 0x40, REG_BITS_8},
	{0x597B, 0x00, REG_BITS_8},
	{0x597C, 0x55, REG_BITS_8},
	{0x597D, 0x78, REG_BITS_8},
	{0x597E, 0x10, REG_BITS_8},
	{0x597F, 0x10, REG_BITS_8},
	{0x5980, 0x10, REG_BITS_8},
	{0x5981, 0x10, REG_BITS_8},
	{0x5982, 0x10, REG_BITS_8},
	{0x5983, 0x08, REG_BITS_8},
	{0x5984, 0x10, REG_BITS_8},
	{0x5985, 0x10, REG_BITS_8},
	{0x5986, 0x10, REG_BITS_8},
	{0x5987, 0x10, REG_BITS_8},
	{0x5988, 0x10, REG_BITS_8},
	{0x5989, 0x08, REG_BITS_8},
	{0x598A, 0x10, REG_BITS_8},
	{0x598B, 0x10, REG_BITS_8},
	{0x598C, 0x10, REG_BITS_8},
	{0x598D, 0x10, REG_BITS_8},
	{0x598E, 0x08, REG_BITS_8},
	{0x598F, 0x10, REG_BITS_8},
	{0x5990, 0x10, REG_BITS_8},
	{0x5991, 0x10, REG_BITS_8},
	{0x5992, 0x10, REG_BITS_8},
	{0x5993, 0x10, REG_BITS_8},
	{0x5994, 0x10, REG_BITS_8},
	{0x5995, 0x10, REG_BITS_8},
	{0x5996, 0x10, REG_BITS_8},
	{0x5997, 0x0C, REG_BITS_8},
	{0x5998, 0x0C, REG_BITS_8},
	{0x5999, 0x04, REG_BITS_8},
	{0x599A, 0x03, REG_BITS_8},
	{0x599B, 0x08, REG_BITS_8},
	{0x599C, 0x10, REG_BITS_8},
	{0x599D, 0x08, REG_BITS_8},
	{0x599E, 0x10, REG_BITS_8},
	{0x599F, 0x04, REG_BITS_8},
	{0x59A0, 0x03, REG_BITS_8},
	{0x59A1, 0x08, REG_BITS_8},
	{0x59A2, 0x00, REG_BITS_8},
	{0x59A3, 0x00, REG_BITS_8},
	{0x59A4, 0x00, REG_BITS_8},
	{0x59A5, 0x20, REG_BITS_8},
	{0x59A6, 0x20, REG_BITS_8},
	{0x59A7, 0x20, REG_BITS_8},
	{0x59A8, 0x50, REG_BITS_8},
	{0x59A9, 0x50, REG_BITS_8},
	{0x59AA, 0x50, REG_BITS_8},
	{0x59AB, 0x00, REG_BITS_8},
	{0x59AC, 0x90, REG_BITS_8},
	{0x59AD, 0x00, REG_BITS_8},
	{0x59AE, 0x50, REG_BITS_8},
	{0x59AF, 0x50, REG_BITS_8},
	{0x59B0, 0x50, REG_BITS_8},
	{0x59B1, 0x50, REG_BITS_8},
	{0x59B2, 0x50, REG_BITS_8},
	{0x59B3, 0x50, REG_BITS_8},
	{0x59B4, 0x00, REG_BITS_8},
	{0x59B5, 0xFF, REG_BITS_8},
	{0x59B6, 0x00, REG_BITS_8},
	{0x59B7, 0x30, REG_BITS_8},
	{0x59B8, 0xE0, REG_BITS_8},
	{0x59B9, 0x30, REG_BITS_8},
	{0x59BA, 0x20, REG_BITS_8},
	{0x59BB, 0x20, REG_BITS_8},
	{0x59BC, 0x20, REG_BITS_8},
	{0x59BD, 0x80, REG_BITS_8},
	{0x59BE, 0x80, REG_BITS_8},
	{0x59BF, 0x40, REG_BITS_8},
	{0x59C0, 0x40, REG_BITS_8},
	{0x59C1, 0x40, REG_BITS_8},
	{0x59C2, 0x64, REG_BITS_8},
	{0x59C3, 0x64, REG_BITS_8},
	{0x59C4, 0x64, REG_BITS_8},
	{0x59C5, 0x08, REG_BITS_8},
	{0x59C6, 0x08, REG_BITS_8},
	{0x59C7, 0x08, REG_BITS_8},
	{0x59C8, 0x1E, REG_BITS_8},
	{0x59C9, 0x1E, REG_BITS_8},
	{0x59CA, 0x1E, REG_BITS_8},
	{0x59CB, 0x1E, REG_BITS_8},
	{0x59CC, 0x1E, REG_BITS_8},
	{0x59CD, 0x1E, REG_BITS_8},
	{0x59CE, 0x20, REG_BITS_8},
	{0x59CF, 0x20, REG_BITS_8},
	{0x59D0, 0x20, REG_BITS_8},
	{0x59D1, 0x20, REG_BITS_8},
	{0x59D2, 0x20, REG_BITS_8},
	{0x59D3, 0x20, REG_BITS_8},
	{0x59D4, 0x0000, REG_BITS_16},
	{0x59D6, 0x0000, REG_BITS_16},
	{0x59D8, 0x0000, REG_BITS_16},
	{0x59DA, 0xE2FF, REG_BITS_16},
	{0x59DC, 0xE2FF, REG_BITS_16},
	{0x59DE, 0xE2FF, REG_BITS_16},
	{0x59E0, 0xE0FF, REG_BITS_16},
	{0x59E2, 0xE0FF, REG_BITS_16},
	{0x59E4, 0xE0FF, REG_BITS_16},
	{0x59E6, 0xE0FF, REG_BITS_16},
	{0x59E8, 0xE0FF, REG_BITS_16},
	{0x59EA, 0xE0FF, REG_BITS_16},
	{0x59EC, 0xF9, REG_BITS_8},
	{0x59ED, 0xF9, REG_BITS_8},
	{0x59EE, 0xF9, REG_BITS_8},
	{0x59EF, 0xFE, REG_BITS_8},
	{0x59F0, 0xFE, REG_BITS_8},
	{0x59F1, 0xFE, REG_BITS_8},
	{0x59F2, 0xF9, REG_BITS_8},
	{0x59F3, 0xF9, REG_BITS_8},
	{0x59F4, 0xF9, REG_BITS_8},
	{0xC000, 0xF7B5, REG_BITS_16},
	{0xC002, 0x0E4D, REG_BITS_16},
	{0xC004, 0x0E4C, REG_BITS_16},
	{0xC006, 0x0F4A, REG_BITS_16},
	{0xC008, 0x0F4F, REG_BITS_16},
	{0xC00A, 0x104B, REG_BITS_16},
	{0xC00C, 0x0021, REG_BITS_16},
	{0xC00E, 0x002A, REG_BITS_16},
	{0xC010, 0x04D9, REG_BITS_16},
	{0xC012, 0x6E5C, REG_BITS_16},
	{0xC014, 0x6654, REG_BITS_16},
	{0xC016, 0x0131, REG_BITS_16},
	{0xC018, 0x9142, REG_BITS_16},
	{0xC01A, 0xFAD3, REG_BITS_16},
	{0xC01C, 0x0021, REG_BITS_16},
	{0xC01E, 0x002B, REG_BITS_16},
	{0xC020, 0x04D9, REG_BITS_16},
	{0xC022, 0x0022, REG_BITS_16},
	{0xC024, 0x7A54, REG_BITS_16},
	{0xC026, 0x0131, REG_BITS_16},
	{0xC028, 0x9942, REG_BITS_16},
	{0xC02A, 0xFBD3, REG_BITS_16},
	{0xC02C, 0x0849, REG_BITS_16},
	{0xC02E, 0x8860, REG_BITS_16},
	{0xC030, 0x0199, REG_BITS_16},
	{0xC032, 0x0848, REG_BITS_16},
	{0xC034, 0x0860, REG_BITS_16},
	{0xC036, 0x03B0, REG_BITS_16},
	{0xC038, 0x0120, REG_BITS_16},
	{0xC03A, 0xF0BD, REG_BITS_16},
	{0xC03C, 0x2C0D, REG_BITS_16},
	{0xC03E, 0x1800, REG_BITS_16},
	{0xC040, 0x2C0D, REG_BITS_16},
	{0xC042, 0x1800, REG_BITS_16},
	{0xC044, 0x0400, REG_BITS_16},
	{0xC046, 0x0000, REG_BITS_16},
	{0xC048, 0x300D, REG_BITS_16},
	{0xC04A, 0x1800, REG_BITS_16},
	{0xC04C, 0x0C00, REG_BITS_16},
	{0xC04E, 0x0000, REG_BITS_16},
	{0xC050, 0x300D, REG_BITS_16},
	{0xC052, 0x1800, REG_BITS_16},
	{0xC054, 0x2C0D, REG_BITS_16},
	{0xC056, 0x1800, REG_BITS_16},
	{0xC058, 0x80B5, REG_BITS_16},
	{0xC05A, 0x5F78, REG_BITS_16},
	{0xC05C, 0x002F, REG_BITS_16},
	{0xC05E, 0x02D1, REG_BITS_16},
	{0xC060, 0x00F0, REG_BITS_16},
	{0xC062, 0xB8F8, REG_BITS_16},
	{0xC064, 0x80BD, REG_BITS_16},
	{0xC066, 0x00F0, REG_BITS_16},
	{0xC068, 0x01F8, REG_BITS_16},
	{0xC06A, 0xFBE7, REG_BITS_16},
	{0xC06C, 0xFFB5, REG_BITS_16},
	{0xC06E, 0x83B0, REG_BITS_16},
	{0xC070, 0x0C1C, REG_BITS_16},
	{0xC072, 0x1F1C, REG_BITS_16},
	{0xC074, 0x0025, REG_BITS_16},
	{0xC076, 0x0A23, REG_BITS_16},
	{0xC078, 0xF85E, REG_BITS_16},
	{0xC07A, 0xEB43, REG_BITS_16},
	{0xC07C, 0x544E, REG_BITS_16},
	{0xC07E, 0x9842, REG_BITS_16},
	{0xC080, 0x28D1, REG_BITS_16},
	{0xC082, 0xF280, REG_BITS_16},
	{0xC084, 0xA01A, REG_BITS_16},
	{0xC086, 0x02D5, REG_BITS_16},
	{0xC088, 0x4042, REG_BITS_16},
	{0xC08A, 0x0121, REG_BITS_16},
	{0xC08C, 0x00E0, REG_BITS_16},
	{0xC08E, 0x0021, REG_BITS_16},
	{0xC090, 0x3170, REG_BITS_16},
	{0xC092, 0x0004, REG_BITS_16},
	{0xC094, 0x000C, REG_BITS_16},
	{0xC096, 0x7080, REG_BITS_16},
	{0xC098, 0xB080, REG_BITS_16},
	{0xC09A, 0x1BD1, REG_BITS_16},
	{0xC09C, 0xA001, REG_BITS_16},
	{0xC09E, 0x0004, REG_BITS_16},
	{0xC0A0, 0x000C, REG_BITS_16},
	{0xC0A2, 0x00AB, REG_BITS_16},
	{0xC0A4, 0x1880, REG_BITS_16},
	{0xC0A6, 0x00F0, REG_BITS_16},
	{0xC0A8, 0xF4F8, REG_BITS_16},
	{0xC0AA, 0x00AB, REG_BITS_16},
	{0xC0AC, 0x1880, REG_BITS_16},
	{0xC0AE, 0xB068, REG_BITS_16},
	{0xC0B0, 0x6A46, REG_BITS_16},
	{0xC0B2, 0x0221, REG_BITS_16},
	{0xC0B4, 0x0368, REG_BITS_16},
	{0xC0B6, 0x0C20, REG_BITS_16},
	{0xC0B8, 0x7FF6, REG_BITS_16},
	{0xC0BA, 0xAFFB, REG_BITS_16},
	{0xC0BC, 0x0128, REG_BITS_16},
	{0xC0BE, 0x04D0, REG_BITS_16},
	{0xC0C0, 0x0020, REG_BITS_16},
	{0xC0C2, 0xC043, REG_BITS_16},
	{0xC0C4, 0x7881, REG_BITS_16},
	{0xC0C6, 0x0020, REG_BITS_16},
	{0xC0C8, 0x7FE0, REG_BITS_16},
	{0xC0CA, 0x0398, REG_BITS_16},
	{0xC0CC, 0x0480, REG_BITS_16},
	{0xC0CE, 0x0120, REG_BITS_16},
	{0xC0D0, 0x7881, REG_BITS_16},
	{0xC0D2, 0x7AE0, REG_BITS_16},
	{0xC0D4, 0xB878, REG_BITS_16},
	{0xC0D6, 0x3E4E, REG_BITS_16},
	{0xC0D8, 0x0290, REG_BITS_16},
	{0xC0DA, 0xF978, REG_BITS_16},
	{0xC0DC, 0x4000, REG_BITS_16},
	{0xC0DE, 0x401A, REG_BITS_16},
	{0xC0E0, 0x3979, REG_BITS_16},
	{0xC0E2, 0x401A, REG_BITS_16},
	{0xC0E4, 0xB188, REG_BITS_16},
	{0xC0E6, 0x4900, REG_BITS_16},
	{0xC0E8, 0x7FF6, REG_BITS_16},
	{0xC0EA, 0x9CFB, REG_BITS_16},
	{0xC0EC, 0x0404, REG_BITS_16},
	{0xC0EE, 0x240C, REG_BITS_16},
	{0xC0F0, 0x788A, REG_BITS_16},
	{0xC0F2, 0xA042, REG_BITS_16},
	{0xC0F4, 0x02DA, REG_BITS_16},
	{0xC0F6, 0x0121, REG_BITS_16},
	{0xC0F8, 0x041C, REG_BITS_16},
	{0xC0FA, 0x00E0, REG_BITS_16},
	{0xC0FC, 0x0021, REG_BITS_16},
	{0xC0FE, 0x0191, REG_BITS_16},
	{0xC100, 0x0298, REG_BITS_16},
	{0xC102, 0x0026, REG_BITS_16},
	{0xC104, 0x0028, REG_BITS_16},
	{0xC106, 0x0BDD, REG_BITS_16},
	{0xC108, 0x301C, REG_BITS_16},
	{0xC10A, 0x211C, REG_BITS_16},
	{0xC10C, 0x3A1C, REG_BITS_16},
	{0xC10E, 0x00F0, REG_BITS_16},
	{0xC110, 0xA5F8, REG_BITS_16},
	{0xC112, 0x4019, REG_BITS_16},
	{0xC114, 0x0504, REG_BITS_16},
	{0xC116, 0x2D0C, REG_BITS_16},
	{0xC118, 0xB878, REG_BITS_16},
	{0xC11A, 0x0136, REG_BITS_16},
	{0xC11C, 0xB042, REG_BITS_16},
	{0xC11E, 0xF3DC, REG_BITS_16},
	{0xC120, 0x2B4E, REG_BITS_16},
	{0xC122, 0xB088, REG_BITS_16},
	{0xC124, 0x401B, REG_BITS_16},
	{0xC126, 0xB080, REG_BITS_16},
	{0xC128, 0x0A23, REG_BITS_16},
	{0xC12A, 0xF85E, REG_BITS_16},
	{0xC12C, 0x0123, REG_BITS_16},
	{0xC12E, 0xD842, REG_BITS_16},
	{0xC130, 0x13D1, REG_BITS_16},
	{0xC132, 0x0199, REG_BITS_16},
	{0xC134, 0x0029, REG_BITS_16},
	{0xC136, 0x02D1, REG_BITS_16},
	{0xC138, 0x0121, REG_BITS_16},
	{0xC13A, 0x7981, REG_BITS_16},
	{0xC13C, 0x0DE0, REG_BITS_16},
	{0xC13E, 0x7188, REG_BITS_16},
	{0xC140, 0x281C, REG_BITS_16},
	{0xC142, 0x7FF6, REG_BITS_16},
	{0xC144, 0xB9FA, REG_BITS_16},
	{0xC146, 0x7881, REG_BITS_16},
	{0xC148, 0x7188, REG_BITS_16},
	{0xC14A, 0x281C, REG_BITS_16},
	{0xC14C, 0x7FF6, REG_BITS_16},
	{0xC14E, 0xB4FA, REG_BITS_16},
	{0xC150, 0x0029, REG_BITS_16},
	{0xC152, 0x02D0, REG_BITS_16},
	{0xC154, 0x7889, REG_BITS_16},
	{0xC156, 0x0130, REG_BITS_16},
	{0xC158, 0x7881, REG_BITS_16},
	{0xC15A, 0xB878, REG_BITS_16},
	{0xC15C, 0x0025, REG_BITS_16},
	{0xC15E, 0x0028, REG_BITS_16},
	{0xC160, 0x32DD, REG_BITS_16},
	{0xC162, 0x281C, REG_BITS_16},
	{0xC164, 0x211C, REG_BITS_16},
	{0xC166, 0x3A1C, REG_BITS_16},
	{0xC168, 0x00F0, REG_BITS_16},
	{0xC16A, 0x78F8, REG_BITS_16},
	{0xC16C, 0x0199, REG_BITS_16},
	{0xC16E, 0x0029, REG_BITS_16},
	{0xC170, 0x07D1, REG_BITS_16},
	{0xC172, 0xB188, REG_BITS_16},
	{0xC174, 0x0029, REG_BITS_16},
	{0xC176, 0x04DD, REG_BITS_16},
	{0xC178, 0x0130, REG_BITS_16},
	{0xC17A, 0x0004, REG_BITS_16},
	{0xC17C, 0x000C, REG_BITS_16},
	{0xC17E, 0x0139, REG_BITS_16},
	{0xC180, 0xB180, REG_BITS_16},
	{0xC182, 0x3178, REG_BITS_16},
	{0xC184, 0x0029, REG_BITS_16},
	{0xC186, 0x02D1, REG_BITS_16},
	{0xC188, 0xF188, REG_BITS_16},
	{0xC18A, 0x0818, REG_BITS_16},
	{0xC18C, 0x01E0, REG_BITS_16},
	{0xC18E, 0xF188, REG_BITS_16},
	{0xC190, 0x081A, REG_BITS_16},
	{0xC192, 0xF080, REG_BITS_16},
	{0xC194, 0xF088, REG_BITS_16},
	{0xC196, 0x00AB, REG_BITS_16},
	{0xC198, 0x8001, REG_BITS_16},
	{0xC19A, 0x0004, REG_BITS_16},
	{0xC19C, 0x000C, REG_BITS_16},
	{0xC19E, 0x1880, REG_BITS_16},
	{0xC1A0, 0x00F0, REG_BITS_16},
	{0xC1A2, 0x77F8, REG_BITS_16},
	{0xC1A4, 0x00AB, REG_BITS_16},
	{0xC1A6, 0x1880, REG_BITS_16},
	{0xC1A8, 0xB068, REG_BITS_16},
	{0xC1AA, 0x6A46, REG_BITS_16},
	{0xC1AC, 0x0221, REG_BITS_16},
	{0xC1AE, 0x0368, REG_BITS_16},
	{0xC1B0, 0x0C20, REG_BITS_16},
	{0xC1B2, 0x7FF6, REG_BITS_16},
	{0xC1B4, 0x32FB, REG_BITS_16},
	{0xC1B6, 0x0128, REG_BITS_16},
	{0xC1B8, 0x82D1, REG_BITS_16},
	{0xC1BA, 0xF088, REG_BITS_16},
	{0xC1BC, 0x0399, REG_BITS_16},
	{0xC1BE, 0x0880, REG_BITS_16},
	{0xC1C0, 0xB878, REG_BITS_16},
	{0xC1C2, 0x0135, REG_BITS_16},
	{0xC1C4, 0xA842, REG_BITS_16},
	{0xC1C6, 0xCCDC, REG_BITS_16},
	{0xC1C8, 0x0120, REG_BITS_16},
	{0xC1CA, 0x07B0, REG_BITS_16},
	{0xC1CC, 0xF0BD, REG_BITS_16},
	{0xC1CE, 0x0000, REG_BITS_16},
	{0xC1D0, 0x300D, REG_BITS_16},
	{0xC1D2, 0x1800, REG_BITS_16},
	{0xC1D4, 0xF8B5, REG_BITS_16},
	{0xC1D6, 0x1C1C, REG_BITS_16},
	{0xC1D8, 0x151C, REG_BITS_16},
	{0xC1DA, 0x061C, REG_BITS_16},
	{0xC1DC, 0x0F1C, REG_BITS_16},
	{0xC1DE, 0xB801, REG_BITS_16},
	{0xC1E0, 0x0004, REG_BITS_16},
	{0xC1E2, 0x000C, REG_BITS_16},
	{0xC1E4, 0x00AB, REG_BITS_16},
	{0xC1E6, 0x1880, REG_BITS_16},
	{0xC1E8, 0x00F0, REG_BITS_16},
	{0xC1EA, 0x53F8, REG_BITS_16},
	{0xC1EC, 0x00AB, REG_BITS_16},
	{0xC1EE, 0x1880, REG_BITS_16},
	{0xC1F0, 0x0948, REG_BITS_16},
	{0xC1F2, 0x6A46, REG_BITS_16},
	{0xC1F4, 0x8068, REG_BITS_16},
	{0xC1F6, 0x0221, REG_BITS_16},
	{0xC1F8, 0x0368, REG_BITS_16},
	{0xC1FA, 0x0C20, REG_BITS_16},
	{0xC1FC, 0x7FF6, REG_BITS_16},
	{0xC1FE, 0x0DFB, REG_BITS_16},
	{0xC200, 0x0128, REG_BITS_16},
	{0xC202, 0x01D0, REG_BITS_16},
	{0xC204, 0x0020, REG_BITS_16},
	{0xC206, 0x06E0, REG_BITS_16},
	{0xC208, 0x381C, REG_BITS_16},
	{0xC20A, 0x291C, REG_BITS_16},
	{0xC20C, 0x221C, REG_BITS_16},
	{0xC20E, 0x3780, REG_BITS_16},
	{0xC210, 0x00F0, REG_BITS_16},
	{0xC212, 0x04F8, REG_BITS_16},
	{0xC214, 0x0120, REG_BITS_16},
	{0xC216, 0xF8BD, REG_BITS_16},
	{0xC218, 0x300D, REG_BITS_16},
	{0xC21A, 0x1800, REG_BITS_16},
	{0xC21C, 0x80B5, REG_BITS_16},
	{0xC21E, 0x171C, REG_BITS_16},
	{0xC220, 0x3A78, REG_BITS_16},
	{0xC222, 0x002A, REG_BITS_16},
	{0xC224, 0x01D1, REG_BITS_16},
	{0xC226, 0x3889, REG_BITS_16},
	{0xC228, 0xF988, REG_BITS_16},
	{0xC22A, 0x401A, REG_BITS_16},
	{0xC22C, 0x00D5, REG_BITS_16},
	{0xC22E, 0x4042, REG_BITS_16},
	{0xC230, 0xFA89, REG_BITS_16},
	{0xC232, 0x0109, REG_BITS_16},
	{0xC234, 0x5143, REG_BITS_16},
	{0xC236, 0x0007, REG_BITS_16},
	{0xC238, 0x000F, REG_BITS_16},
	{0xC23A, 0x00D0, REG_BITS_16},
	{0xC23C, 0x5118, REG_BITS_16},
	{0xC23E, 0x388A, REG_BITS_16},
	{0xC240, 0x4118, REG_BITS_16},
	{0xC242, 0xB869, REG_BITS_16},
	{0xC244, 0x0918, REG_BITS_16},
	{0xC246, 0x7FF6, REG_BITS_16},
	{0xC248, 0x37FA, REG_BITS_16},
	{0xC24A, 0x034B, REG_BITS_16},
	{0xC24C, 0x9842, REG_BITS_16},
	{0xC24E, 0x00D9, REG_BITS_16},
	{0xC250, 0x181C, REG_BITS_16},
	{0xC252, 0x7881, REG_BITS_16},
	{0xC254, 0x80BD, REG_BITS_16},
	{0xC256, 0x0000, REG_BITS_16},
	{0xC258, 0xFF7F, REG_BITS_16},
	{0xC25A, 0x0000, REG_BITS_16},
	{0xC25C, 0x80B5, REG_BITS_16},
	{0xC25E, 0xD378, REG_BITS_16},
	{0xC260, 0x8342, REG_BITS_16},
	{0xC262, 0x05DD, REG_BITS_16},
	{0xC264, 0x0130, REG_BITS_16},
	{0xC266, 0x4843, REG_BITS_16},
	{0xC268, 0x0A1C, REG_BITS_16},
	{0xC26A, 0x011C, REG_BITS_16},
	{0xC26C, 0x581C, REG_BITS_16},
	{0xC26E, 0x09E0, REG_BITS_16},
	{0xC270, 0x9378, REG_BITS_16},
	{0xC272, 0x1279, REG_BITS_16},
	{0xC274, 0x9F1A, REG_BITS_16},
	{0xC276, 0x8742, REG_BITS_16},
	{0xC278, 0x09DC, REG_BITS_16},
	{0xC27A, 0x181A, REG_BITS_16},
	{0xC27C, 0x4843, REG_BITS_16},
	{0xC27E, 0x0B1C, REG_BITS_16},
	{0xC280, 0x011C, REG_BITS_16},
	{0xC282, 0x501C, REG_BITS_16},
	{0xC284, 0x7FF6, REG_BITS_16},
	{0xC286, 0xCEFA, REG_BITS_16},
	{0xC288, 0x0004, REG_BITS_16},
	{0xC28A, 0x000C, REG_BITS_16},
	{0xC28C, 0x80BD, REG_BITS_16},
	{0xC28E, 0x081C, REG_BITS_16},
	{0xC290, 0xFCE7, REG_BITS_16},
	{0xC292, 0x0102, REG_BITS_16},
	{0xC294, 0x0012, REG_BITS_16},
	{0xC296, 0x0843, REG_BITS_16},
	{0xC298, 0x0004, REG_BITS_16},
	{0xC29A, 0x000C, REG_BITS_16},
	{0xC29C, 0xF746, REG_BITS_16},
	{0xC29E, 0x0000, REG_BITS_16},
	{0xC2A0, 0xE50A, REG_BITS_16},
	{0xC2A2, 0x1800, REG_BITS_16},
	{0x485C, 0xA402, REG_BITS_16},
	{0x485E, 0x4ACB, REG_BITS_16},
	{0x000A, 0x01, REG_BITS_8},
	{0x4808, 0x1900, REG_BITS_16},
	{0x480A, 0xFA00, REG_BITS_16},
	{0x480C, 0xEB03, REG_BITS_16},
	{0x480E, 0x7D00, REG_BITS_16},
	{0x4810, 0x7D00, REG_BITS_16},
	{0x4812, 0xEB03, REG_BITS_16},
	{0x4816, 0x01, REG_BITS_8},
	{0x481C, 0x01, REG_BITS_8},
	{0x481D, 0x01, REG_BITS_8},
	{0x4826, 0x0500, REG_BITS_16},
	{0x482C, 0x1E00, REG_BITS_16},
	{0x4832, 0x2C01, REG_BITS_16},
	{0x4840, 0x00, REG_BITS_8},
	{0x4846, 0x01, REG_BITS_8},
	{0x4847, 0x01, REG_BITS_8},
	{0x4848, 0x02, REG_BITS_8},
	{0x484A, 0x03, REG_BITS_8},
	{0x484B, 0x03, REG_BITS_8},
	{0x484E, 0x08, REG_BITS_8},
	{0x484F, 0x00, REG_BITS_8},
	{0x4854, 0x02, REG_BITS_8},
	{0x4856, 0x14, REG_BITS_8},
	{0x4857, 0x0A, REG_BITS_8},
	{0x4864, 0x0000, REG_BITS_16},
	{0x4866, 0x0000, REG_BITS_16},
	{0x4868, 0x0000, REG_BITS_16},
	{0x4882, 0x0000, REG_BITS_16},
	{0x4884, 0x01, REG_BITS_8},
	{0x4887, 0x02, REG_BITS_8},
	{0x4888, 0x01, REG_BITS_8},
	{0x4889, 0x10, REG_BITS_8},
	{0x488A, 0x00, REG_BITS_8},
	{0x488B, 0x00, REG_BITS_8},
	{0x488C, 0x0100, REG_BITS_16},
	{0x488E, 0x0400, REG_BITS_16},
	{0x489A, 0xD75D, REG_BITS_16},
	{0x489C, 0x7B67, REG_BITS_16},
	{0x489E, 0x9176, REG_BITS_16},
	{0x48A0, 0x2600, REG_BITS_16},
	{0x48A2, 0x0600, REG_BITS_16},
	{0x48A4, 0x1E00, REG_BITS_16},
	{0x48A6, 0xD75D, REG_BITS_16},
	{0x48A8, 0x7B67, REG_BITS_16},
	{0x48AA, 0x9176, REG_BITS_16},
	{0x48AC, 0x0200, REG_BITS_16},
	{0x48AE, 0x0500, REG_BITS_16},
	{0x48B0, 0x0400, REG_BITS_16},
	{0x48B2, 0xD75D, REG_BITS_16},
	{0x48B4, 0x7B67, REG_BITS_16},
	{0x48B6, 0x9176, REG_BITS_16},
	{0x48B8, 0x0500, REG_BITS_16},
	{0x48BA, 0x0900, REG_BITS_16},
	{0x48BC, 0x0B00, REG_BITS_16},
	{0x48BE, 0xD75D, REG_BITS_16},
	{0x48C0, 0x7B67, REG_BITS_16},
	{0x48C2, 0x9176, REG_BITS_16},
	{0x48C4, 0x1400, REG_BITS_16},
	{0x48C6, 0x1400, REG_BITS_16},
	{0x48C8, 0x2600, REG_BITS_16},
	{0x48CA, 0xD75D, REG_BITS_16},
	{0x48CC, 0x7B67, REG_BITS_16},
	{0x48CE, 0x9176, REG_BITS_16},
	{0x48D0, 0x2600, REG_BITS_16},
	{0x48D2, 0x0600, REG_BITS_16},
	{0x48D4, 0x1E00, REG_BITS_16},
	{0x48D6, 0xD75D, REG_BITS_16},
	{0x48D8, 0x7B67, REG_BITS_16},
	{0x48DA, 0x9176, REG_BITS_16},
	{0x48DC, 0x0200, REG_BITS_16},
	{0x48DE, 0x0600, REG_BITS_16},
	{0x48E0, 0x0300, REG_BITS_16},
	{0x48E2, 0xD75D, REG_BITS_16},
	{0x48E4, 0x7B67, REG_BITS_16},
	{0x48E6, 0x9176, REG_BITS_16},
	{0x48E8, 0x0600, REG_BITS_16},
	{0x48EA, 0x0900, REG_BITS_16},
	{0x48EC, 0x0C00, REG_BITS_16},
	{0x48EE, 0xD75D, REG_BITS_16},
	{0x48F0, 0x7B67, REG_BITS_16},
	{0x48F2, 0x9176, REG_BITS_16},
	{0x48F4, 0x1E00, REG_BITS_16},
	{0x48F6, 0x1600, REG_BITS_16},
	{0x48F8, 0x2600, REG_BITS_16},
	{0x490C, 0x0002, REG_BITS_16},
	{0x490E, 0x0002, REG_BITS_16},
	{0x4910, 0x0002, REG_BITS_16},
	{0x4924, 0x1000, REG_BITS_16},
	{0x4926, 0x1000, REG_BITS_16},
	{0x4928, 0x1000, REG_BITS_16},
	{0x493C, 0x0002, REG_BITS_16},
	{0x493E, 0x0002, REG_BITS_16},
	{0x4940, 0x0002, REG_BITS_16},
	{0x4954, 0x1000, REG_BITS_16},
	{0x4956, 0x1000, REG_BITS_16},
	{0x4958, 0x1000, REG_BITS_16},
	{0x495C, 0x01, REG_BITS_8},
	{0x4962, 0x0000, REG_BITS_16},
	{0x4968, 0x00, REG_BITS_8},
	{0x4969, 0x08, REG_BITS_8},
	{0x496C, 0x00, REG_BITS_8},
	{0x496E, 0xF401, REG_BITS_16},
	{0x4970, 0xE803, REG_BITS_16},
	{0x4972, 0x02, REG_BITS_8},
	{0x4C2C, 0xC604, REG_BITS_16},
	{0x4C2E, 0x4101, REG_BITS_16},
	{0x4C30, 0xE600, REG_BITS_16},
	{0x4C32, 0xE600, REG_BITS_16},
	{0x4C34, 0x8A04, REG_BITS_16},
	{0x4C36, 0x0501, REG_BITS_16},
	{0x4C38, 0x5F01, REG_BITS_16},
	{0x4C3A, 0x5F01, REG_BITS_16},
	{0x4C3C, 0xAA02, REG_BITS_16},
	{0x4C3E, 0x5D03, REG_BITS_16},
	{0x4C40, 0xE600, REG_BITS_16},
	{0x4C42, 0xE600, REG_BITS_16},
	{0x4C44, 0x6E02, REG_BITS_16},
	{0x4C46, 0x2103, REG_BITS_16},
	{0x4C48, 0x5F01, REG_BITS_16},
	{0x4C4A, 0x5F01, REG_BITS_16},
	{0x4C4C, 0xC604, REG_BITS_16},
	{0x4C4E, 0x5D03, REG_BITS_16},
	{0x4C50, 0xE600, REG_BITS_16},
	{0x4C52, 0xE600, REG_BITS_16},
	{0x4C54, 0x8A04, REG_BITS_16},
	{0x4C56, 0x2103, REG_BITS_16},
	{0x4C58, 0x5F01, REG_BITS_16},
	{0x4C5A, 0x5F01, REG_BITS_16},
	{0x4C5C, 0xE206, REG_BITS_16},
	{0x4C5E, 0x5D03, REG_BITS_16},
	{0x4C60, 0xE600, REG_BITS_16},
	{0x4C62, 0xE600, REG_BITS_16},
	{0x4C64, 0xA606, REG_BITS_16},
	{0x4C66, 0x2103, REG_BITS_16},
	{0x4C68, 0x5F01, REG_BITS_16},
	{0x4C6A, 0x5F01, REG_BITS_16},
	{0x4C6C, 0xC604, REG_BITS_16},
	{0x4C6E, 0x7905, REG_BITS_16},
	{0x4C70, 0xE600, REG_BITS_16},
	{0x4C72, 0xE600, REG_BITS_16},
	{0x4C74, 0x8A04, REG_BITS_16},
	{0x4C76, 0x3D05, REG_BITS_16},
	{0x4C78, 0x5F01, REG_BITS_16},
	{0x4C7A, 0x5F01, REG_BITS_16},
	{0x4C7C, 0x06, REG_BITS_8},
	{0x4C7D, 0x05, REG_BITS_8},
	{0x4C7E, 0x02, REG_BITS_8},
	{0x4C7F, 0x01, REG_BITS_8},
	{0x4C80, 0x08, REG_BITS_8},
	{0x4C81, 0x07, REG_BITS_8},
	{0x4C82, 0x02, REG_BITS_8},
	{0x4C83, 0x01, REG_BITS_8},
	{0x4C84, 0x04, REG_BITS_8},
	{0x4C85, 0x03, REG_BITS_8},
	{0x5400, 0x0000, REG_BITS_16},
	{0x5402, 0x0A00, REG_BITS_16},
	{0x5404, 0x1400, REG_BITS_16},
	{0x5406, 0x2000, REG_BITS_16},
	{0x5408, 0x2600, REG_BITS_16},
	{0x540A, 0x3400, REG_BITS_16},
	{0x540C, 0x3800, REG_BITS_16},
	{0x540E, 0x4400, REG_BITS_16},
	{0x5410, 0x4A00, REG_BITS_16},
	{0x5412, 0x5400, REG_BITS_16},
	{0x5414, 0x5800, REG_BITS_16},
	{0x5416, 0x6400, REG_BITS_16},
	{0x5418, 0x6600, REG_BITS_16},
	{0x541A, 0x7000, REG_BITS_16},
	{0x541C, 0x7200, REG_BITS_16},
	{0x541E, 0x7C00, REG_BITS_16},
	{0x5420, 0x7E00, REG_BITS_16},
	{0x5422, 0x8600, REG_BITS_16},
	{0x5424, 0x5B00, REG_BITS_16},
	{0x5426, 0xA900, REG_BITS_16},
	{0x5428, 0xCF00, REG_BITS_16},
	{0x542A, 0xE300, REG_BITS_16},
	{0x542C, 0xF100, REG_BITS_16},
	{0x542E, 0xF700, REG_BITS_16},
	{0x5430, 0x0101, REG_BITS_16},
	{0x5432, 0x0301, REG_BITS_16},
	{0x5434, 0x0D01, REG_BITS_16},
	{0x5436, 0x0000, REG_BITS_16},
	{0x5438, 0x0A00, REG_BITS_16},
	{0x543A, 0x1400, REG_BITS_16},
	{0x543C, 0x2000, REG_BITS_16},
	{0x543E, 0x2600, REG_BITS_16},
	{0x5440, 0x3400, REG_BITS_16},
	{0x5442, 0x3800, REG_BITS_16},
	{0x5444, 0x4400, REG_BITS_16},
	{0x5446, 0x4A00, REG_BITS_16},
	{0x5448, 0x5400, REG_BITS_16},
	{0x544A, 0x5800, REG_BITS_16},
	{0x544C, 0x6400, REG_BITS_16},
	{0x544E, 0x6600, REG_BITS_16},
	{0x5450, 0x7000, REG_BITS_16},
	{0x5452, 0x7200, REG_BITS_16},
	{0x5454, 0x7C00, REG_BITS_16},
	{0x5456, 0x7E00, REG_BITS_16},
	{0x5458, 0x8600, REG_BITS_16},
	{0x545A, 0x5B00, REG_BITS_16},
	{0x545C, 0xA900, REG_BITS_16},
	{0x545E, 0xCF00, REG_BITS_16},
	{0x5460, 0xE300, REG_BITS_16},
	{0x5462, 0xF100, REG_BITS_16},
	{0x5464, 0xF700, REG_BITS_16},
	{0x5466, 0x0101, REG_BITS_16},
	{0x5468, 0x0301, REG_BITS_16},
	{0x546A, 0x0D01, REG_BITS_16},
	{0x546C, 0x0000, REG_BITS_16},
	{0x546E, 0x0A00, REG_BITS_16},
	{0x5470, 0x1400, REG_BITS_16},
	{0x5472, 0x2000, REG_BITS_16},
	{0x5474, 0x2600, REG_BITS_16},
	{0x5476, 0x3400, REG_BITS_16},
	{0x5478, 0x3800, REG_BITS_16},
	{0x547A, 0x4400, REG_BITS_16},
	{0x547C, 0x4A00, REG_BITS_16},
	{0x547E, 0x5400, REG_BITS_16},
	{0x5480, 0x5800, REG_BITS_16},
	{0x5482, 0x6400, REG_BITS_16},
	{0x5484, 0x6600, REG_BITS_16},
	{0x5486, 0x7000, REG_BITS_16},
	{0x5488, 0x7200, REG_BITS_16},
	{0x548A, 0x7C00, REG_BITS_16},
	{0x548C, 0x7E00, REG_BITS_16},
	{0x548E, 0x8600, REG_BITS_16},
	{0x5490, 0x5B00, REG_BITS_16},
	{0x5492, 0xA900, REG_BITS_16},
	{0x5494, 0xCF00, REG_BITS_16},
	{0x5496, 0xE300, REG_BITS_16},
	{0x5498, 0xF100, REG_BITS_16},
	{0x549A, 0xF700, REG_BITS_16},
	{0x549C, 0x0101, REG_BITS_16},
	{0x549E, 0x0301, REG_BITS_16},
	{0x54A0, 0x0D01, REG_BITS_16},
	{0x54A2, 0x1004, REG_BITS_16},
	{0x54A4, 0x0540, REG_BITS_16},
	{0x54A6, 0x1004, REG_BITS_16},
	{0x54A8, 0x0540, REG_BITS_16},
	{0x54AA, 0x1004, REG_BITS_16},
	{0x54AC, 0x0540, REG_BITS_16},
	{0x54AE, 0x401D, REG_BITS_16},
	{0x5600, 0x0000, REG_BITS_16},
	{0x5602, 0x0000, REG_BITS_16},
	{0x5604, 0x0100, REG_BITS_16},
	{0x5606, 0x0600, REG_BITS_16},
	{0x5608, 0x0C00, REG_BITS_16},
	{0x560A, 0x1500, REG_BITS_16},
	{0x560C, 0x1D00, REG_BITS_16},
	{0x560E, 0x2700, REG_BITS_16},
	{0x5610, 0x3100, REG_BITS_16},
	{0x5612, 0x3A00, REG_BITS_16},
	{0x5614, 0x4300, REG_BITS_16},
	{0x5616, 0x4B00, REG_BITS_16},
	{0x5618, 0x5300, REG_BITS_16},
	{0x561A, 0x5B00, REG_BITS_16},
	{0x561C, 0x6300, REG_BITS_16},
	{0x561E, 0x6A00, REG_BITS_16},
	{0x5620, 0x7100, REG_BITS_16},
	{0x5622, 0x7B00, REG_BITS_16},
	{0x5624, 0x3E00, REG_BITS_16},
	{0x5626, 0xAC00, REG_BITS_16},
	{0x5628, 0xD400, REG_BITS_16},
	{0x562A, 0xE600, REG_BITS_16},
	{0x562C, 0xF200, REG_BITS_16},
	{0x562E, 0xF800, REG_BITS_16},
	{0x5630, 0xFE00, REG_BITS_16},
	{0x5632, 0x0101, REG_BITS_16},
	{0x5634, 0x0401, REG_BITS_16},
	{0x5636, 0x0000, REG_BITS_16},
	{0x5638, 0x0000, REG_BITS_16},
	{0x563A, 0x0100, REG_BITS_16},
	{0x563C, 0x0600, REG_BITS_16},
	{0x563E, 0x0C00, REG_BITS_16},
	{0x5640, 0x1500, REG_BITS_16},
	{0x5642, 0x1D00, REG_BITS_16},
	{0x5644, 0x2700, REG_BITS_16},
	{0x5646, 0x3100, REG_BITS_16},
	{0x5648, 0x3A00, REG_BITS_16},
	{0x564A, 0x4300, REG_BITS_16},
	{0x564C, 0x4B00, REG_BITS_16},
	{0x564E, 0x5300, REG_BITS_16},
	{0x5650, 0x5B00, REG_BITS_16},
	{0x5652, 0x6300, REG_BITS_16},
	{0x5654, 0x6A00, REG_BITS_16},
	{0x5656, 0x7100, REG_BITS_16},
	{0x5658, 0x7B00, REG_BITS_16},
	{0x565A, 0x3E00, REG_BITS_16},
	{0x565C, 0xAC00, REG_BITS_16},
	{0x565E, 0xD400, REG_BITS_16},
	{0x5660, 0xE600, REG_BITS_16},
	{0x5662, 0xF200, REG_BITS_16},
	{0x5664, 0xF800, REG_BITS_16},
	{0x5666, 0xFE00, REG_BITS_16},
	{0x5668, 0x0101, REG_BITS_16},
	{0x566A, 0x0401, REG_BITS_16},
	{0x566C, 0x0000, REG_BITS_16},
	{0x566E, 0x0000, REG_BITS_16},
	{0x5670, 0x0100, REG_BITS_16},
	{0x5672, 0x0600, REG_BITS_16},
	{0x5674, 0x0C00, REG_BITS_16},
	{0x5676, 0x1500, REG_BITS_16},
	{0x5678, 0x1D00, REG_BITS_16},
	{0x567A, 0x2700, REG_BITS_16},
	{0x567C, 0x3100, REG_BITS_16},
	{0x567E, 0x3A00, REG_BITS_16},
	{0x5680, 0x4300, REG_BITS_16},
	{0x5682, 0x4B00, REG_BITS_16},
	{0x5684, 0x5300, REG_BITS_16},
	{0x5686, 0x5B00, REG_BITS_16},
	{0x5688, 0x6300, REG_BITS_16},
	{0x568A, 0x6A00, REG_BITS_16},
	{0x568C, 0x7100, REG_BITS_16},
	{0x568E, 0x7B00, REG_BITS_16},
	{0x5690, 0x3E00, REG_BITS_16},
	{0x5692, 0xAC00, REG_BITS_16},
	{0x5694, 0xD400, REG_BITS_16},
	{0x5696, 0xE600, REG_BITS_16},
	{0x5698, 0xF200, REG_BITS_16},
	{0x569A, 0xF800, REG_BITS_16},
	{0x569C, 0xFE00, REG_BITS_16},
	{0x569E, 0x0101, REG_BITS_16},
	{0x56A0, 0x0401, REG_BITS_16},
	{0x56A2, 0x0019, REG_BITS_16},
	{0x56A4, 0x0540, REG_BITS_16},
	{0x56A6, 0x0019, REG_BITS_16},
	{0x56A8, 0x0540, REG_BITS_16},
	{0x56AA, 0x0019, REG_BITS_16},
	{0x56AC, 0x0540, REG_BITS_16},
	{0x56AE, 0x0023, REG_BITS_16},
	{0x4E0B, 0x00, REG_BITS_8},
	{0x4E0C, 0xFE01, REG_BITS_16},
	{0x4E0E, 0x2A0A, REG_BITS_16},
	{0x4E10, 0x0001, REG_BITS_16},
	{0x4E16, 0x00, REG_BITS_8},
	{0x4E17, 0x84, REG_BITS_8},
	{0x4F24, 0x3C, REG_BITS_8},
	{0x4F25, 0x01, REG_BITS_8},
	{0x4F2C, 0x0800, REG_BITS_16},
	{0x4F2E, 0x0000, REG_BITS_16},
	{0x4F30, 0x0000, REG_BITS_16},
	{0x4F32, 0x0800, REG_BITS_16},
	{0x4F34, 0x0000, REG_BITS_16},
	{0x4F36, 0x0000, REG_BITS_16},
	{0x4F38, 0x0A, REG_BITS_8},
	{0x4F39, 0x14, REG_BITS_8},
	{0x4F3A, 0x14, REG_BITS_8},
	{0x4F3B, 0x14, REG_BITS_8},
	{0x4F3C, 0x1E, REG_BITS_8},
	{0x4F3D, 0x1E, REG_BITS_8},
	{0x4F3E, 0x0A, REG_BITS_8},
	{0x4F3F, 0x1E, REG_BITS_8},
	{0x4F40, 0x1E, REG_BITS_8},
	{0x4F41, 0x01, REG_BITS_8},
	{0x4F42, 0x03, REG_BITS_8},
	{0x4F43, 0x01, REG_BITS_8},
	{0x4F44, 0x0010, REG_BITS_16},
	{0x4F46, 0x000C, REG_BITS_16},
	{0x4F48, 0x00, REG_BITS_8},
	{0x4F49, 0x00, REG_BITS_8},
	{0x4F4A, 0x00, REG_BITS_8},
	{0x4F4B, 0x10, REG_BITS_8},
	{0x4F4C, 0x01, REG_BITS_8},
	{0x4F4E, 0x0014, REG_BITS_16},
	{0x4F50, 0x0010, REG_BITS_16},
	{0x5062, 0xF6FF, REG_BITS_16},
	{0x5064, 0xE9FF, REG_BITS_16},
	{0x5066, 0xF6FF, REG_BITS_16},
	{0x5068, 0xEAFF, REG_BITS_16},
	{0x506A, 0xF6FF, REG_BITS_16},
	{0x506C, 0xEAFF, REG_BITS_16},
	{0x506E, 0xF6FF, REG_BITS_16},
	{0x5070, 0xE9FF, REG_BITS_16},
	{0x5072, 0x40, REG_BITS_8},
	{0x5073, 0x48, REG_BITS_8},
	{0x5074, 0x40, REG_BITS_8},
	{0x5075, 0x56, REG_BITS_8},
	{0x5076, 0x40, REG_BITS_8},
	{0x5077, 0x56, REG_BITS_8},
	{0x5078, 0x40, REG_BITS_8},
	{0x5079, 0x48, REG_BITS_8},
	{0x507A, 0xF6FF, REG_BITS_16},
	{0x507C, 0xE9FF, REG_BITS_16},
	{0x507E, 0xF6FF, REG_BITS_16},
	{0x5080, 0xEAFF, REG_BITS_16},
	{0x5082, 0xF6FF, REG_BITS_16},
	{0x5084, 0xEAFF, REG_BITS_16},
	{0x5086, 0xF6FF, REG_BITS_16},
	{0x5088, 0xE9FF, REG_BITS_16},
	{0x508A, 0x40, REG_BITS_8},
	{0x508B, 0x48, REG_BITS_8},
	{0x508C, 0x40, REG_BITS_8},
	{0x508D, 0x56, REG_BITS_8},
	{0x508E, 0x40, REG_BITS_8},
	{0x508F, 0x56, REG_BITS_8},
	{0x5090, 0x40, REG_BITS_8},
	{0x5091, 0x48, REG_BITS_8},
	{0x0101, 0x00, REG_BITS_8},
	{0x0108, 0x01, REG_BITS_8},
	{0x0109, 0x4D, REG_BITS_8},
	{0x010D, 0x01, REG_BITS_8},
	{0x010E, 0x4D, REG_BITS_8},
	{0x0112, 0x01, REG_BITS_8},
	{0x0113, 0x4D, REG_BITS_8},
	{0x0117, 0x01, REG_BITS_8},
	{0x0118, 0x4D, REG_BITS_8},
	{0x011C, 0x01, REG_BITS_8},
	{0x011D, 0xCD, REG_BITS_8},
	{0x0121, 0x01, REG_BITS_8},
	{0x0122, 0x4D, REG_BITS_8},
	{0x0126, 0x01, REG_BITS_8},
	{0x0127, 0x03, REG_BITS_8},
	{0x012A, 0x20, REG_BITS_8},
	{0x012B, 0x01, REG_BITS_8},
	{0x012C, 0x03, REG_BITS_8},
	{0x012F, 0x20, REG_BITS_8},
	{0x0130, 0x01, REG_BITS_8},
	{0x0131, 0x03, REG_BITS_8},
	{0x0134, 0x20, REG_BITS_8},
	{0x0135, 0x01, REG_BITS_8},
	{0x0136, 0x03, REG_BITS_8},
	{0x0139, 0x20, REG_BITS_8},
	{0x013A, 0x01, REG_BITS_8},
	{0x013B, 0x03, REG_BITS_8},
	{0x01D3, 0x00, REG_BITS_8},
	{0x01D4, 0x00, REG_BITS_8},
	{0x01D5, 0x00, REG_BITS_8},
	{0x01D6, 0x00, REG_BITS_8},
	{0x01D7, 0x00, REG_BITS_8},
	{0x01D8, 0x00, REG_BITS_8},
	{0x01D9, 0x00, REG_BITS_8},
	{0x01DA, 0x00, REG_BITS_8},
	{0x01DB, 0x00, REG_BITS_8},
	{0x01DC, 0x00, REG_BITS_8},
	{0x01DD, 0x00, REG_BITS_8},
	{0x01DE, 0x00, REG_BITS_8},
	{0x010A, 0x40, REG_BITS_8},
	{0x010F, 0x40, REG_BITS_8},
	{0x0114, 0x80, REG_BITS_8},
	{0x0119, 0x40, REG_BITS_8},
	{0x011E, 0x40, REG_BITS_8},
	{0x0123, 0xD0, REG_BITS_8},
	{0x0128, 0x40, REG_BITS_8},
	{0x012D, 0x40, REG_BITS_8},
	{0x0132, 0x40, REG_BITS_8},
	{0x0137, 0x40, REG_BITS_8},
	{0x013C, 0x40, REG_BITS_8},
	{0x01AF, 0x00, REG_BITS_8},
	{0x01B0, 0x00, REG_BITS_8},
	{0x01B2, 0x65, REG_BITS_8},
	{0x01B3, 0x80, REG_BITS_8},
	{0x01F9, 0x75, REG_BITS_8},
	{0x01FA, 0x55, REG_BITS_8},
	{0x01FB, 0x95, REG_BITS_8},
	{0x01FC, 0x75, REG_BITS_8},
	{0x01FD, 0x55, REG_BITS_8},
	{0x02CA, 0x0000, REG_BITS_16},
	{0x02D8, 0x11, REG_BITS_8},
	{0x02D9, 0x11, REG_BITS_8},
	{0x02DA, 0x01, REG_BITS_8},
	{0x02DB, 0x00, REG_BITS_8},
	{0x02DC, 0x10, REG_BITS_8},
	{0x0013, 0x01, REG_BITS_8},
	{0x0014, 0x00, REG_BITS_8},
	{0x001D, 0x1B, REG_BITS_8},
	{0x0020, 0x00, REG_BITS_8},
	{0x0032, 0x0001, REG_BITS_16},
	{0x0034, 0x0000, REG_BITS_16},
	{0x0036, 0x0000, REG_BITS_16},
	{0x0204, 0x02, REG_BITS_8},
	{0x0205, 0x46, REG_BITS_8},
	{0x0206, 0x50, REG_BITS_8},
	{0x0207, 0x5A, REG_BITS_8},
	{0x0209, 0x88, REG_BITS_8},
	{0x020A, 0x0000, REG_BITS_16},
	{0x020C, 0x0000, REG_BITS_16},
	{0x020E, 0x0000, REG_BITS_16},
	{0x0210, 0x0000, REG_BITS_16},
	{0x0212, 0x0000, REG_BITS_16},
	{0x0214, 0x0000, REG_BITS_16},
	{0x0216, 0x00, REG_BITS_8},
	{0x0217, 0x00, REG_BITS_8},
	{0x0218, 0x00, REG_BITS_8},
	{0x0224, 0x00, REG_BITS_8},
	{0x0226, 0xA006, REG_BITS_16},
	{0x0234, 0x00, REG_BITS_8},
	{0x02A2, 0x0000, REG_BITS_16},
	{0x02A6, 0x0000, REG_BITS_16},
	{0x02A8, 0x0000, REG_BITS_16},
	{0x02B8, 0x10, REG_BITS_8},
	{0x02BA, 0x50, REG_BITS_8},
	{0x02BB, 0x50, REG_BITS_8},
	{0x02BC, 0x50, REG_BITS_8},
	{0x02BD, 0x50, REG_BITS_8},
	{0x02BE, 0x50, REG_BITS_8},
	{0x02BF, 0x10, REG_BITS_8},
	{0x02C0, 0x41, REG_BITS_8},
	{0x02C1, 0x10, REG_BITS_8},
	{0x02C2, 0x10, REG_BITS_8},
	{0x02C3, 0x10, REG_BITS_8},
	{0x02C8, 0x00, REG_BITS_8},
	{0x02CE, 0xA007, REG_BITS_16},
	{0x02D2, 0x00, REG_BITS_8},
	{0x02D3, 0x00, REG_BITS_8},
	{0x02D6, 0x01, REG_BITS_8},
	{0x033F, 0x00, REG_BITS_8},
	{0x0348, 0x00, REG_BITS_8},
	{0x0349, 0x00, REG_BITS_8},
	{0x034F, 0x00, REG_BITS_8},
	{0x0381, 0x00, REG_BITS_8},
	{0x0384, 0x03, REG_BITS_8},
	{0x5A02, 0x04, REG_BITS_8},
	{0x5A03, 0x00, REG_BITS_8},
	{0x5A04, 0x00, REG_BITS_8},
	{0x4200, 0x05, REG_BITS_8},
	{0x4201, 0x08, REG_BITS_8},
	{0x4202, 0x0A, REG_BITS_8},
	{0x4203, 0x0B, REG_BITS_8},
	{0x4204, 0x0D, REG_BITS_8},
	{0x4205, 0x0B, REG_BITS_8},
	{0x4206, 0x0A, REG_BITS_8},
	{0x4207, 0x08, REG_BITS_8},
	{0x4208, 0x05, REG_BITS_8},
	{0x4209, 0x08, REG_BITS_8},
	{0x420A, 0x09, REG_BITS_8},
	{0x420B, 0x0D, REG_BITS_8},
	{0x420C, 0x0E, REG_BITS_8},
	{0x420D, 0x10, REG_BITS_8},
	{0x420E, 0x0E, REG_BITS_8},
	{0x420F, 0x0D, REG_BITS_8},
	{0x4210, 0x09, REG_BITS_8},
	{0x4211, 0x08, REG_BITS_8},
	{0x4212, 0x09, REG_BITS_8},
	{0x4213, 0x0B, REG_BITS_8},
	{0x4214, 0x17, REG_BITS_8},
	{0x4215, 0x27, REG_BITS_8},
	{0x4216, 0x3F, REG_BITS_8},
	{0x4217, 0x27, REG_BITS_8},
	{0x4218, 0x17, REG_BITS_8},
	{0x4219, 0x0B, REG_BITS_8},
	{0x421A, 0x09, REG_BITS_8},
	{0x421B, 0x0A, REG_BITS_8},
	{0x421C, 0x0D, REG_BITS_8},
	{0x421D, 0x23, REG_BITS_8},
	{0x421E, 0x52, REG_BITS_8},
	{0x421F, 0x64, REG_BITS_8},
	{0x4220, 0x52, REG_BITS_8},
	{0x4221, 0x23, REG_BITS_8},
	{0x4222, 0x0D, REG_BITS_8},
	{0x4223, 0x0A, REG_BITS_8},
	{0x4224, 0x0A, REG_BITS_8},
	{0x4225, 0x0D, REG_BITS_8},
	{0x4226, 0x23, REG_BITS_8},
	{0x4227, 0x52, REG_BITS_8},
	{0x4228, 0x64, REG_BITS_8},
	{0x4229, 0x52, REG_BITS_8},
	{0x422A, 0x23, REG_BITS_8},
	{0x422B, 0x0D, REG_BITS_8},
	{0x422C, 0x0A, REG_BITS_8},
	{0x422D, 0x09, REG_BITS_8},
	{0x422E, 0x0B, REG_BITS_8},
	{0x422F, 0x17, REG_BITS_8},
	{0x4230, 0x27, REG_BITS_8},
	{0x4231, 0x32, REG_BITS_8},
	{0x4232, 0x27, REG_BITS_8},
	{0x4233, 0x17, REG_BITS_8},
	{0x4234, 0x0B, REG_BITS_8},
	{0x4235, 0x09, REG_BITS_8},
	{0x4236, 0x05, REG_BITS_8},
	{0x4237, 0x09, REG_BITS_8},
	{0x4238, 0x0D, REG_BITS_8},
	{0x4239, 0x11, REG_BITS_8},
	{0x423A, 0x13, REG_BITS_8},
	{0x423B, 0x11, REG_BITS_8},
	{0x423C, 0x0D, REG_BITS_8},
	{0x423D, 0x09, REG_BITS_8},
	{0x423E, 0x05, REG_BITS_8},
	{0x423F, 0x07, REG_BITS_8},
	{0x4240, 0x0D, REG_BITS_8},
	{0x4241, 0x0E, REG_BITS_8},
	{0x4242, 0x10, REG_BITS_8},
	{0x4243, 0x13, REG_BITS_8},
	{0x4244, 0x10, REG_BITS_8},
	{0x4245, 0x0E, REG_BITS_8},
	{0x4246, 0x0D, REG_BITS_8},
	{0x4247, 0x07, REG_BITS_8},
	{0x4248, 0x0D, REG_BITS_8},
	{0x4249, 0x10, REG_BITS_8},
	{0x424A, 0x16, REG_BITS_8},
	{0x424B, 0x1C, REG_BITS_8},
	{0x424C, 0x1F, REG_BITS_8},
	{0x424D, 0x1C, REG_BITS_8},
	{0x424E, 0x16, REG_BITS_8},
	{0x424F, 0x10, REG_BITS_8},
	{0x4250, 0x0D, REG_BITS_8},
	{0x4251, 0x12, REG_BITS_8},
	{0x4252, 0x19, REG_BITS_8},
	{0x4253, 0x21, REG_BITS_8},
	{0x4254, 0x32, REG_BITS_8},
	{0x4255, 0x47, REG_BITS_8},
	{0x4256, 0x32, REG_BITS_8},
	{0x4257, 0x21, REG_BITS_8},
	{0x4258, 0x19, REG_BITS_8},
	{0x4259, 0x12, REG_BITS_8},
	{0x425A, 0x14, REG_BITS_8},
	{0x425B, 0x1C, REG_BITS_8},
	{0x425C, 0x2B, REG_BITS_8},
	{0x425D, 0x52, REG_BITS_8},
	{0x425E, 0x64, REG_BITS_8},
	{0x425F, 0x52, REG_BITS_8},
	{0x4260, 0x2B, REG_BITS_8},
	{0x4261, 0x1C, REG_BITS_8},
	{0x4262, 0x14, REG_BITS_8},
	{0x4263, 0x14, REG_BITS_8},
	{0x4264, 0x1C, REG_BITS_8},
	{0x4265, 0x2B, REG_BITS_8},
	{0x4266, 0x52, REG_BITS_8},
	{0x4267, 0x64, REG_BITS_8},
	{0x4268, 0x52, REG_BITS_8},
	{0x4269, 0x2B, REG_BITS_8},
	{0x426A, 0x1C, REG_BITS_8},
	{0x426B, 0x14, REG_BITS_8},
	{0x426C, 0x12, REG_BITS_8},
	{0x426D, 0x19, REG_BITS_8},
	{0x426E, 0x21, REG_BITS_8},
	{0x426F, 0x32, REG_BITS_8},
	{0x4270, 0x38, REG_BITS_8},
	{0x4271, 0x32, REG_BITS_8},
	{0x4272, 0x21, REG_BITS_8},
	{0x4273, 0x19, REG_BITS_8},
	{0x4274, 0x12, REG_BITS_8},
	{0x4275, 0x11, REG_BITS_8},
	{0x4276, 0x14, REG_BITS_8},
	{0x4277, 0x18, REG_BITS_8},
	{0x4278, 0x1C, REG_BITS_8},
	{0x4279, 0x1F, REG_BITS_8},
	{0x427A, 0x1C, REG_BITS_8},
	{0x427B, 0x18, REG_BITS_8},
	{0x427C, 0x14, REG_BITS_8},
	{0x427D, 0x11, REG_BITS_8},
	{0x427E, 0x04, REG_BITS_8},
	{0x427F, 0x06, REG_BITS_8},
	{0x4280, 0x07, REG_BITS_8},
	{0x4281, 0x09, REG_BITS_8},
	{0x4282, 0x09, REG_BITS_8},
	{0x4283, 0x09, REG_BITS_8},
	{0x4284, 0x07, REG_BITS_8},
	{0x4285, 0x06, REG_BITS_8},
	{0x4286, 0x04, REG_BITS_8},
	{0x4287, 0x08, REG_BITS_8},
	{0x4288, 0x0B, REG_BITS_8},
	{0x4289, 0x0D, REG_BITS_8},
	{0x428A, 0x0E, REG_BITS_8},
	{0x428B, 0x10, REG_BITS_8},
	{0x428C, 0x0E, REG_BITS_8},
	{0x428D, 0x0D, REG_BITS_8},
	{0x428E, 0x0B, REG_BITS_8},
	{0x428F, 0x08, REG_BITS_8},
	{0x4290, 0x0C, REG_BITS_8},
	{0x4291, 0x10, REG_BITS_8},
	{0x4292, 0x16, REG_BITS_8},
	{0x4293, 0x1B, REG_BITS_8},
	{0x4294, 0x2F, REG_BITS_8},
	{0x4295, 0x1B, REG_BITS_8},
	{0x4296, 0x16, REG_BITS_8},
	{0x4297, 0x10, REG_BITS_8},
	{0x4298, 0x0C, REG_BITS_8},
	{0x4299, 0x0D, REG_BITS_8},
	{0x429A, 0x14, REG_BITS_8},
	{0x429B, 0x26, REG_BITS_8},
	{0x429C, 0x37, REG_BITS_8},
	{0x429D, 0x4E, REG_BITS_8},
	{0x429E, 0x37, REG_BITS_8},
	{0x429F, 0x26, REG_BITS_8},
	{0x42A0, 0x14, REG_BITS_8},
	{0x42A1, 0x0D, REG_BITS_8},
	{0x42A2, 0x0E, REG_BITS_8},
	{0x42A3, 0x18, REG_BITS_8},
	{0x42A4, 0x43, REG_BITS_8},
	{0x42A5, 0x5A, REG_BITS_8},
	{0x42A6, 0x64, REG_BITS_8},
	{0x42A7, 0x5A, REG_BITS_8},
	{0x42A8, 0x43, REG_BITS_8},
	{0x42A9, 0x18, REG_BITS_8},
	{0x42AA, 0x0E, REG_BITS_8},
	{0x42AB, 0x0D, REG_BITS_8},
	{0x42AC, 0x14, REG_BITS_8},
	{0x42AD, 0x26, REG_BITS_8},
	{0x42AE, 0x37, REG_BITS_8},
	{0x42AF, 0x3F, REG_BITS_8},
	{0x42B0, 0x37, REG_BITS_8},
	{0x42B1, 0x26, REG_BITS_8},
	{0x42B2, 0x14, REG_BITS_8},
	{0x42B3, 0x0D, REG_BITS_8},
	{0x42B4, 0x0B, REG_BITS_8},
	{0x42B5, 0x11, REG_BITS_8},
	{0x42B6, 0x14, REG_BITS_8},
	{0x42B7, 0x18, REG_BITS_8},
	{0x42B8, 0x1C, REG_BITS_8},
	{0x42B9, 0x18, REG_BITS_8},
	{0x42BA, 0x14, REG_BITS_8},
	{0x42BB, 0x11, REG_BITS_8},
	{0x42BC, 0x0B, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_period_3_ES1 =
    sizeof(seix006_vendor_1_period_3_ES1);

const struct reg_entry seix006_vendor_1_period_3_ES2[] = {
	{0x5842, 0x07, REG_BITS_8},
	{0x5843, 0x07, REG_BITS_8},
	{0x5844, 0x07, REG_BITS_8},
	{0x5845, 0x07, REG_BITS_8},
	{0x5846, 0x07, REG_BITS_8},
	{0x5847, 0x07, REG_BITS_8},
	{0x5848, 0x07, REG_BITS_8},
	{0x5849, 0x07, REG_BITS_8},
	{0x584A, 0x07, REG_BITS_8},
	{0x584B, 0x07, REG_BITS_8},
	{0x584C, 0x07, REG_BITS_8},
	{0x584D, 0x07, REG_BITS_8},
	{0x584E, 0x07, REG_BITS_8},
	{0x584F, 0x07, REG_BITS_8},
	{0x5850, 0x00, REG_BITS_8},
	{0x5858, 0x2A0A, REG_BITS_16},
	{0x585A, 0x9603, REG_BITS_16},
	{0x585C, 0x0000, REG_BITS_16},
	{0x5882, 0x290B, REG_BITS_16},
	{0x5884, 0x0001, REG_BITS_16},
	{0x5886, 0x0000, REG_BITS_16},
	{0x588E, 0x3000, REG_BITS_16},
	{0x5890, 0x2800, REG_BITS_16},
	{0x5892, 0x2000, REG_BITS_16},
	{0x5894, 0x0400, REG_BITS_16},
	{0x589A, 0x0800, REG_BITS_16},
	{0x589C, 0x1200, REG_BITS_16},
	{0x589E, 0x1200, REG_BITS_16},
	{0x58A6, 0x0400, REG_BITS_16},
	{0x58AC, 0x0800, REG_BITS_16},
	{0x58AE, 0x1200, REG_BITS_16},
	{0x58B0, 0x1200, REG_BITS_16},
	{0x58B8, 0x0100, REG_BITS_16},
	{0x58BA, 0x0100, REG_BITS_16},
	{0x58BC, 0x0000, REG_BITS_16},
	{0x58BE, 0x0400, REG_BITS_16},
	{0x58C0, 0x0500, REG_BITS_16},
	{0x58CA, 0x0100, REG_BITS_16},
	{0x58CC, 0x0100, REG_BITS_16},
	{0x58CE, 0x0000, REG_BITS_16},
	{0x58D0, 0x0400, REG_BITS_16},
	{0x58D4, 0x0400, REG_BITS_16},
	{0x58DC, 0x0A00, REG_BITS_16},
	{0x58E2, 0x0E00, REG_BITS_16},
	{0x58E4, 0x0C00, REG_BITS_16},
	{0x58E6, 0x0A00, REG_BITS_16},
	{0x58EE, 0x0A00, REG_BITS_16},
	{0x58F2, 0x0500, REG_BITS_16},
	{0x58F4, 0x0E00, REG_BITS_16},
	{0x58F6, 0x0C00, REG_BITS_16},
	{0x58F8, 0x0D00, REG_BITS_16},
	{0x5906, 0x5E01, REG_BITS_16},
	{0x5908, 0x5E01, REG_BITS_16},
	{0x590A, 0x5E01, REG_BITS_16},
	{0x590C, 0x2602, REG_BITS_16},
	{0x590E, 0x2602, REG_BITS_16},
	{0x5910, 0x2602, REG_BITS_16},
	{0x591E, 0x0300, REG_BITS_16},
	{0x5920, 0x0400, REG_BITS_16},
	{0x5922, 0x0400, REG_BITS_16},
	{0x5926, 0x8200, REG_BITS_16},
	{0x592A, 0x2003, REG_BITS_16},
	{0x592C, 0x2003, REG_BITS_16},
	{0x592E, 0x2003, REG_BITS_16},
	{0x5930, 0x8403, REG_BITS_16},
	{0x5932, 0x8403, REG_BITS_16},
	{0x5934, 0x8403, REG_BITS_16},
	{0x5942, 0x0300, REG_BITS_16},
	{0x5944, 0x0400, REG_BITS_16},
	{0x5946, 0x0400, REG_BITS_16},
	{0x594A, 0x2300, REG_BITS_16},
	{0x594E, 0x3200, REG_BITS_16},
	{0x5950, 0x2300, REG_BITS_16},
	{0x5952, 0x3200, REG_BITS_16},
	{0x5954, 0xC800, REG_BITS_16},
	{0x5956, 0x5D00, REG_BITS_16},
	{0x5958, 0xC800, REG_BITS_16},
	{0x5968, 0x0000, REG_BITS_16},
	{0x596A, 0x0000, REG_BITS_16},
	{0x596C, 0x32, REG_BITS_8},
	{0x596D, 0x32, REG_BITS_8},
	{0x596F, 0x32, REG_BITS_8},
	{0x5970, 0x40, REG_BITS_8},
	{0x5971, 0x40, REG_BITS_8},
	{0x5972, 0x32, REG_BITS_8},
	{0x5973, 0x40, REG_BITS_8},
	{0x5974, 0x37, REG_BITS_8},
	{0x5975, 0x20, REG_BITS_8},
	{0x5976, 0x40, REG_BITS_8},
	{0x5977, 0x4A, REG_BITS_8},
	{0x5979, 0x5A, REG_BITS_8},
	{0x597A, 0x50, REG_BITS_8},
	{0x597C, 0x5A, REG_BITS_8},
	{0x597D, 0x87, REG_BITS_8},
	{0x597E, 0x10, REG_BITS_8},
	{0x597F, 0x10, REG_BITS_8},
	{0x5980, 0x10, REG_BITS_8},
	{0x5981, 0x10, REG_BITS_8},
	{0x5982, 0x10, REG_BITS_8},
	{0x5985, 0x10, REG_BITS_8},
	{0x5986, 0x10, REG_BITS_8},
	{0x5987, 0x10, REG_BITS_8},
	{0x5988, 0x10, REG_BITS_8},
	{0x5989, 0x08, REG_BITS_8},
	{0x598A, 0x10, REG_BITS_8},
	{0x598B, 0x10, REG_BITS_8},
	{0x598C, 0x10, REG_BITS_8},
	{0x598D, 0x10, REG_BITS_8},
	{0x598F, 0x10, REG_BITS_8},
	{0x5991, 0x10, REG_BITS_8},
	{0x5992, 0x10, REG_BITS_8},
	{0x5993, 0x10, REG_BITS_8},
	{0x5994, 0x10, REG_BITS_8},
	{0x5995, 0x10, REG_BITS_8},
	{0x5997, 0x0C, REG_BITS_8},
	{0x5998, 0x0C, REG_BITS_8},
	{0x5999, 0x04, REG_BITS_8},
	{0x599A, 0x03, REG_BITS_8},
	{0x599B, 0x08, REG_BITS_8},
	{0x599D, 0x08, REG_BITS_8},
	{0x599E, 0x10, REG_BITS_8},
	{0x599F, 0x04, REG_BITS_8},
	{0x59A0, 0x03, REG_BITS_8},
	{0x59A1, 0x08, REG_BITS_8},
	{0x59A5, 0x20, REG_BITS_8},
	{0x59A6, 0x20, REG_BITS_8},
	{0x59A7, 0x20, REG_BITS_8},
	{0x59A8, 0x50, REG_BITS_8},
	{0x59A9, 0x50, REG_BITS_8},
	{0x59AA, 0x50, REG_BITS_8},
	{0x59AC, 0x90, REG_BITS_8},
	{0x59AE, 0x50, REG_BITS_8},
	{0x59B1, 0x50, REG_BITS_8},
	{0x59B2, 0x50, REG_BITS_8},
	{0x59B3, 0x50, REG_BITS_8},
	{0x59B5, 0xFF, REG_BITS_8},
	{0x59B7, 0x30, REG_BITS_8},
	{0x59B8, 0xE0, REG_BITS_8},
	{0x59B9, 0x30, REG_BITS_8},
	{0x59BA, 0x20, REG_BITS_8},
	{0x59BB, 0x20, REG_BITS_8},
	{0x59BC, 0x20, REG_BITS_8},
	{0x59BD, 0x30, REG_BITS_8},
	{0x59BE, 0x60, REG_BITS_8},
	{0x59C5, 0x08, REG_BITS_8},
	{0x59C6, 0x08, REG_BITS_8},
	{0x59C7, 0x08, REG_BITS_8},
	{0x59C8, 0x1E, REG_BITS_8},
	{0x59C9, 0x1E, REG_BITS_8},
	{0x59CA, 0x1E, REG_BITS_8},
	{0x59CB, 0x1E, REG_BITS_8},
	{0x59CC, 0x1E, REG_BITS_8},
	{0x59CD, 0x1E, REG_BITS_8},
	{0x59D4, 0x0000, REG_BITS_16},
	{0x59D6, 0x0000, REG_BITS_16},
	{0x59D8, 0x0000, REG_BITS_16},
	{0x59DA, 0xE2FF, REG_BITS_16},
	{0x59DC, 0xE2FF, REG_BITS_16},
	{0x59DE, 0xE2FF, REG_BITS_16},
	{0x59EC, 0xF9, REG_BITS_8},
	{0x59ED, 0xF9, REG_BITS_8},
	{0x59EE, 0xF9, REG_BITS_8},
	{0x59F2, 0xF9, REG_BITS_8},
	{0x59F3, 0xF9, REG_BITS_8},
	{0x59F4, 0xF9, REG_BITS_8},
	{0xC000, 0xF7B50E4D, REG_BITS_32},
	{0xC004, 0x0E4C0F4A, REG_BITS_32},
	{0xC008, 0x0F4F104B, REG_BITS_32},
	{0xC00C, 0x0021002A, REG_BITS_32},
	{0xC010, 0x04D96E5C, REG_BITS_32},
	{0xC014, 0x66540131, REG_BITS_32},
	{0xC018, 0x9142FAD3, REG_BITS_32},
	{0xC01C, 0x0021002B, REG_BITS_32},
	{0xC020, 0x04D90022, REG_BITS_32},
	{0xC024, 0x7A540131, REG_BITS_32},
	{0xC028, 0x9942FBD3, REG_BITS_32},
	{0xC02C, 0x08498860, REG_BITS_32},
	{0xC030, 0x01990848, REG_BITS_32},
	{0xC034, 0x086003B0, REG_BITS_32},
	{0xC038, 0x0120F0BD, REG_BITS_32},
	{0xC03C, 0x200D1800, REG_BITS_32},
	{0xC040, 0x200D1800, REG_BITS_32},
	{0xC044, 0x04000000, REG_BITS_32},
	{0xC048, 0x240D1800, REG_BITS_32},
	{0xC04C, 0x0C000000, REG_BITS_32},
	{0xC050, 0x240D1800, REG_BITS_32},
	{0xC054, 0x200D1800, REG_BITS_32},
	{0xC058, 0x80B51F78, REG_BITS_32},
	{0xC05C, 0x002F02D1, REG_BITS_32},
	{0xC060, 0x00F0B8F8, REG_BITS_32},
	{0xC064, 0x80BD00F0, REG_BITS_32},
	{0xC068, 0x01F8FBE7, REG_BITS_32},
	{0xC06C, 0xFFB583B0, REG_BITS_32},
	{0xC070, 0x0C1C1F1C, REG_BITS_32},
	{0xC074, 0x00250823, REG_BITS_32},
	{0xC078, 0xF85EEB43, REG_BITS_32},
	{0xC07C, 0x544E9842, REG_BITS_32},
	{0xC080, 0x28D1F280, REG_BITS_32},
	{0xC084, 0xA01A02D5, REG_BITS_32},
	{0xC088, 0x40420121, REG_BITS_32},
	{0xC08C, 0x00E00021, REG_BITS_32},
	{0xC090, 0x31700004, REG_BITS_32},
	{0xC094, 0x000C7080, REG_BITS_32},
	{0xC098, 0xB0801BD1, REG_BITS_32},
	{0xC09C, 0xA0010004, REG_BITS_32},
	{0xC0A0, 0x000C00AB, REG_BITS_32},
	{0xC0A4, 0x188000F0, REG_BITS_32},
	{0xC0A8, 0xEEF800AB, REG_BITS_32},
	{0xC0AC, 0x1880B068, REG_BITS_32},
	{0xC0B0, 0x6A460221, REG_BITS_32},
	{0xC0B4, 0x03680C20, REG_BITS_32},
	{0xC0B8, 0x7FF6AFFB, REG_BITS_32},
	{0xC0BC, 0x012804D0, REG_BITS_32},
	{0xC0C0, 0x0020C043, REG_BITS_32},
	{0xC0C4, 0x38810020, REG_BITS_32},
	{0xC0C8, 0x7FE00398, REG_BITS_32},
	{0xC0CC, 0x04800120, REG_BITS_32},
	{0xC0D0, 0x38817AE0, REG_BITS_32},
	{0xC0D4, 0x78783E4E, REG_BITS_32},
	{0xC0D8, 0x0290B978, REG_BITS_32},
	{0xC0DC, 0x4000401A, REG_BITS_32},
	{0xC0E0, 0xF978401A, REG_BITS_32},
	{0xC0E4, 0xB1884900, REG_BITS_32},
	{0xC0E8, 0x7FF69CFB, REG_BITS_32},
	{0xC0EC, 0x0404240C, REG_BITS_32},
	{0xC0F0, 0x388AA042, REG_BITS_32},
	{0xC0F4, 0x02DA0121, REG_BITS_32},
	{0xC0F8, 0x041C00E0, REG_BITS_32},
	{0xC0FC, 0x00210191, REG_BITS_32},
	{0xC100, 0x02980026, REG_BITS_32},
	{0xC104, 0x00280BDD, REG_BITS_32},
	{0xC108, 0x301C211C, REG_BITS_32},
	{0xC10C, 0x3A1C00F0, REG_BITS_32},
	{0xC110, 0x9FF84019, REG_BITS_32},
	{0xC114, 0x05042D0C, REG_BITS_32},
	{0xC118, 0x78780136, REG_BITS_32},
	{0xC11C, 0xB042F3DC, REG_BITS_32},
	{0xC120, 0x2B4EB088, REG_BITS_32},
	{0xC124, 0x401BB080, REG_BITS_32},
	{0xC128, 0x0823F85E, REG_BITS_32},
	{0xC12C, 0x0123D842, REG_BITS_32},
	{0xC130, 0x13D10199, REG_BITS_32},
	{0xC134, 0x002902D1, REG_BITS_32},
	{0xC138, 0x01213981, REG_BITS_32},
	{0xC13C, 0x0DE07188, REG_BITS_32},
	{0xC140, 0x281C7FF6, REG_BITS_32},
	{0xC144, 0xB9FA3881, REG_BITS_32},
	{0xC148, 0x7188281C, REG_BITS_32},
	{0xC14C, 0x7FF6B4FA, REG_BITS_32},
	{0xC150, 0x002902D0, REG_BITS_32},
	{0xC154, 0x38890130, REG_BITS_32},
	{0xC158, 0x38817878, REG_BITS_32},
	{0xC15C, 0x00250028, REG_BITS_32},
	{0xC160, 0x32DD281C, REG_BITS_32},
	{0xC164, 0x211C3A1C, REG_BITS_32},
	{0xC168, 0x00F072F8, REG_BITS_32},
	{0xC16C, 0x01990029, REG_BITS_32},
	{0xC170, 0x07D1B188, REG_BITS_32},
	{0xC174, 0x002904DD, REG_BITS_32},
	{0xC178, 0x01300004, REG_BITS_32},
	{0xC17C, 0x000C0139, REG_BITS_32},
	{0xC180, 0xB1803178, REG_BITS_32},
	{0xC184, 0x002902D1, REG_BITS_32},
	{0xC188, 0xF1880818, REG_BITS_32},
	{0xC18C, 0x01E0F188, REG_BITS_32},
	{0xC190, 0x081AF080, REG_BITS_32},
	{0xC194, 0xF08800AB, REG_BITS_32},
	{0xC198, 0x80010004, REG_BITS_32},
	{0xC19C, 0x000C1880, REG_BITS_32},
	{0xC1A0, 0x00F071F8, REG_BITS_32},
	{0xC1A4, 0x00AB1880, REG_BITS_32},
	{0xC1A8, 0xB0686A46, REG_BITS_32},
	{0xC1AC, 0x02210368, REG_BITS_32},
	{0xC1B0, 0x0C207FF6, REG_BITS_32},
	{0xC1B4, 0x32FB0128, REG_BITS_32},
	{0xC1B8, 0x82D1F088, REG_BITS_32},
	{0xC1BC, 0x03990880, REG_BITS_32},
	{0xC1C0, 0x78780135, REG_BITS_32},
	{0xC1C4, 0xA842CCDC, REG_BITS_32},
	{0xC1C8, 0x012007B0, REG_BITS_32},
	{0xC1CC, 0xF0BD0000, REG_BITS_32},
	{0xC1D0, 0x240D1800, REG_BITS_32},
	{0xC1D4, 0xF8B51C1C, REG_BITS_32},
	{0xC1D8, 0x151C061C, REG_BITS_32},
	{0xC1DC, 0x0F1CB801, REG_BITS_32},
	{0xC1E0, 0x0004000C, REG_BITS_32},
	{0xC1E4, 0x00AB1880, REG_BITS_32},
	{0xC1E8, 0x00F04DF8, REG_BITS_32},
	{0xC1EC, 0x00AB1880, REG_BITS_32},
	{0xC1F0, 0x09486A46, REG_BITS_32},
	{0xC1F4, 0x80680221, REG_BITS_32},
	{0xC1F8, 0x03680C20, REG_BITS_32},
	{0xC1FC, 0x7FF60DFB, REG_BITS_32},
	{0xC200, 0x012801D0, REG_BITS_32},
	{0xC204, 0x002006E0, REG_BITS_32},
	{0xC208, 0x381C291C, REG_BITS_32},
	{0xC20C, 0x221C3780, REG_BITS_32},
	{0xC210, 0x00F004F8, REG_BITS_32},
	{0xC214, 0x0120F8BD, REG_BITS_32},
	{0xC218, 0x240D1800, REG_BITS_32},
	{0xC21C, 0x80B5171C, REG_BITS_32},
	{0xC220, 0x401A00D5, REG_BITS_32},
	{0xC224, 0x4042BA89, REG_BITS_32},
	{0xC228, 0x01095143, REG_BITS_32},
	{0xC22C, 0x0007000F, REG_BITS_32},
	{0xC230, 0x00D05118, REG_BITS_32},
	{0xC234, 0xF8894118, REG_BITS_32},
	{0xC238, 0x78690918, REG_BITS_32},
	{0xC23C, 0x7FF63CFA, REG_BITS_32},
	{0xC240, 0x024B9842, REG_BITS_32},
	{0xC244, 0x00D9181C, REG_BITS_32},
	{0xC248, 0x388180BD, REG_BITS_32},
	{0xC24C, 0xFF7F0000, REG_BITS_32},
	{0xC250, 0x80B59378, REG_BITS_32},
	{0xC254, 0x834205DD, REG_BITS_32},
	{0xC258, 0x01304843, REG_BITS_32},
	{0xC25C, 0x0A1C011C, REG_BITS_32},
	{0xC260, 0x581C09E0, REG_BITS_32},
	{0xC264, 0x5378D278, REG_BITS_32},
	{0xC268, 0x9F1A8742, REG_BITS_32},
	{0xC26C, 0x09DC181A, REG_BITS_32},
	{0xC270, 0x48430B1C, REG_BITS_32},
	{0xC274, 0x011C501C, REG_BITS_32},
	{0xC278, 0x7FF6D4FA, REG_BITS_32},
	{0xC27C, 0x0004000C, REG_BITS_32},
	{0xC280, 0x80BD081C, REG_BITS_32},
	{0xC284, 0xFCE70102, REG_BITS_32},
	{0xC288, 0x00120843, REG_BITS_32},
	{0xC28C, 0x0004000C, REG_BITS_32},
	{0xC290, 0xF7460000, REG_BITS_32},
	{0xC294, 0xE50A1800, REG_BITS_32},
	{0x485C, 0x9802, REG_BITS_16},
	{0x485E, 0x6556, REG_BITS_16},
	{0x000A, 0x01, REG_BITS_8},
	{0x4808, 0x1900, REG_BITS_16},
	{0x480A, 0xFA00, REG_BITS_16},
	{0x480C, 0xEB03, REG_BITS_16},
	{0x480E, 0xE803, REG_BITS_16},
	{0x4810, 0xE803, REG_BITS_16},
	{0x4812, 0xEB03, REG_BITS_16},
	{0x481C, 0x00, REG_BITS_8},
	{0x4826, 0x0500, REG_BITS_16},
	{0x482C, 0x1E00, REG_BITS_16},
	{0x4832, 0x2C01, REG_BITS_16},
	{0x484F, 0x00, REG_BITS_8},
	{0x4856, 0x14, REG_BITS_8},
	{0x4884, 0x01, REG_BITS_8},
	{0x4889, 0x10, REG_BITS_8},
	{0x488A, 0x00, REG_BITS_8},
	{0x488B, 0x00, REG_BITS_8},
	{0x488C, 0x0100, REG_BITS_16},
	{0x48D0, 0xFF03, REG_BITS_16},
	{0x48D2, 0xFF03, REG_BITS_16},
	{0x48D4, 0xFF03, REG_BITS_16},
	{0x48E8, 0xFF03, REG_BITS_16},
	{0x48EA, 0xFF03, REG_BITS_16},
	{0x48EC, 0xFF03, REG_BITS_16},
	{0x48F4, 0xFF03, REG_BITS_16},
	{0x48F6, 0xFF03, REG_BITS_16},
	{0x48F8, 0xFF03, REG_BITS_16},
	{0x495C, 0x01, REG_BITS_8},
	{0x4968, 0x00, REG_BITS_8},
	{0x4969, 0x08, REG_BITS_8},
	{0x496C, 0x00, REG_BITS_8},
	{0x496E, 0xF401, REG_BITS_16},
	{0x4970, 0xE803, REG_BITS_16},
	{0x6E00, 0x01, REG_BITS_8},
	{0x6E08, 0x1E00, REG_BITS_16},
	{0x6E12, 0x3400, REG_BITS_16},
	{0x6E8E, 0x9600, REG_BITS_16},
	{0x6E90, 0xF401, REG_BITS_16},
	{0x6E92, 0x9600, REG_BITS_16},
	{0x4C2C, 0x2E04, REG_BITS_16},
	{0x4C2E, 0xC502, REG_BITS_16},
	{0x4C30, 0x1702, REG_BITS_16},
	{0x4C32, 0x1702, REG_BITS_16},
	{0x4C34, 0x8A04, REG_BITS_16},
	{0x4C36, 0x0501, REG_BITS_16},
	{0x4C38, 0x5F01, REG_BITS_16},
	{0x4C3A, 0x5F01, REG_BITS_16},
	{0x4C44, 0x6E02, REG_BITS_16},
	{0x4C46, 0x2103, REG_BITS_16},
	{0x4C48, 0x5F01, REG_BITS_16},
	{0x4C4A, 0x5F01, REG_BITS_16},
	{0x4C54, 0x8A04, REG_BITS_16},
	{0x4C56, 0x2103, REG_BITS_16},
	{0x4C58, 0x5F01, REG_BITS_16},
	{0x4C5A, 0x5F01, REG_BITS_16},
	{0x4C64, 0xA606, REG_BITS_16},
	{0x4C66, 0x2103, REG_BITS_16},
	{0x4C68, 0x5F01, REG_BITS_16},
	{0x4C6A, 0x5F01, REG_BITS_16},
	{0x4C74, 0x8A04, REG_BITS_16},
	{0x4C76, 0x3D05, REG_BITS_16},
	{0x4C78, 0x5F01, REG_BITS_16},
	{0x4C7A, 0x5F01, REG_BITS_16},
	{0x4C7D, 0x00, REG_BITS_8},
	{0x4C7E, 0x00, REG_BITS_8},
	{0x4C7F, 0x00, REG_BITS_8},
	{0x4C82, 0x00, REG_BITS_8},
	{0x4C83, 0x00, REG_BITS_8},
	{0x4C84, 0x00, REG_BITS_8},
	{0x4C85, 0x00, REG_BITS_8},
	{0x5438, 0x0100, REG_BITS_16},
	{0x543A, 0x0200, REG_BITS_16},
	{0x543C, 0x0400, REG_BITS_16},
	{0x543E, 0x0600, REG_BITS_16},
	{0x5440, 0x0800, REG_BITS_16},
	{0x5442, 0x0B00, REG_BITS_16},
	{0x5444, 0x0E00, REG_BITS_16},
	{0x5446, 0x1100, REG_BITS_16},
	{0x5448, 0x1400, REG_BITS_16},
	{0x544A, 0x1700, REG_BITS_16},
	{0x544C, 0x1B00, REG_BITS_16},
	{0x544E, 0x1F00, REG_BITS_16},
	{0x5450, 0x2300, REG_BITS_16},
	{0x5452, 0x2700, REG_BITS_16},
	{0x5454, 0x2C00, REG_BITS_16},
	{0x5456, 0x3200, REG_BITS_16},
	{0x5458, 0x3700, REG_BITS_16},
	{0x545A, 0x1600, REG_BITS_16},
	{0x545C, 0x5200, REG_BITS_16},
	{0x545E, 0x8400, REG_BITS_16},
	{0x5460, 0xAA00, REG_BITS_16},
	{0x5462, 0xC800, REG_BITS_16},
	{0x5464, 0xDC00, REG_BITS_16},
	{0x5466, 0xF000, REG_BITS_16},
	{0x5468, 0xFD00, REG_BITS_16},
	{0x54A2, 0x1001, REG_BITS_16},
	{0x54A6, 0x1001, REG_BITS_16},
	{0x54AA, 0x1001, REG_BITS_16},
	{0x54AE, 0x015D, REG_BITS_16},
	{0x5638, 0x0000, REG_BITS_16},
	{0x563A, 0x0100, REG_BITS_16},
	{0x563C, 0x0600, REG_BITS_16},
	{0x563E, 0x0C00, REG_BITS_16},
	{0x5640, 0x1500, REG_BITS_16},
	{0x5642, 0x1D00, REG_BITS_16},
	{0x5644, 0x2700, REG_BITS_16},
	{0x5646, 0x3100, REG_BITS_16},
	{0x5648, 0x3A00, REG_BITS_16},
	{0x564A, 0x4300, REG_BITS_16},
	{0x564C, 0x4B00, REG_BITS_16},
	{0x564E, 0x5300, REG_BITS_16},
	{0x5650, 0x5B00, REG_BITS_16},
	{0x5652, 0x6300, REG_BITS_16},
	{0x5654, 0x6A00, REG_BITS_16},
	{0x5656, 0x7100, REG_BITS_16},
	{0x5658, 0x7B00, REG_BITS_16},
	{0x565A, 0x3E00, REG_BITS_16},
	{0x565C, 0xAC00, REG_BITS_16},
	{0x565E, 0xD400, REG_BITS_16},
	{0x5660, 0xE600, REG_BITS_16},
	{0x5662, 0xF200, REG_BITS_16},
	{0x5664, 0xF800, REG_BITS_16},
	{0x5666, 0xFE00, REG_BITS_16},
	{0x5668, 0x0101, REG_BITS_16},
	{0x566A, 0x0401, REG_BITS_16},
	{0x56AE, 0x0023, REG_BITS_16},
	{0x4E0C, 0xFE01, REG_BITS_16},
	{0x4E0E, 0x2A0A, REG_BITS_16},
	{0x4E10, 0x0001, REG_BITS_16},
	{0x4F24, 0x3C, REG_BITS_8},
	{0x4F25, 0x09, REG_BITS_8},
	{0x4F2E, 0x0000, REG_BITS_16},
	{0x4F30, 0x0000, REG_BITS_16},
	{0x4F34, 0x0000, REG_BITS_16},
	{0x4F36, 0x0000, REG_BITS_16},
	{0x4F38, 0x0A, REG_BITS_8},
	{0x4F39, 0x14, REG_BITS_8},
	{0x4F3A, 0x14, REG_BITS_8},
	{0x4F3B, 0x14, REG_BITS_8},
	{0x4F3C, 0x1E, REG_BITS_8},
	{0x4F3D, 0x1E, REG_BITS_8},
	{0x4F3E, 0x0A, REG_BITS_8},
	{0x4F3F, 0x1E, REG_BITS_8},
	{0x4F40, 0x1E, REG_BITS_8},
	{0x5062, 0xF6FF, REG_BITS_16},
	{0x5064, 0xE9FF, REG_BITS_16},
	{0x5066, 0xF6FF, REG_BITS_16},
	{0x5068, 0xEAFF, REG_BITS_16},
	{0x506A, 0xF6FF, REG_BITS_16},
	{0x506C, 0xEAFF, REG_BITS_16},
	{0x506E, 0xF6FF, REG_BITS_16},
	{0x5070, 0xE9FF, REG_BITS_16},
	{0x5073, 0x48, REG_BITS_8},
	{0x5075, 0x56, REG_BITS_8},
	{0x5077, 0x56, REG_BITS_8},
	{0x5079, 0x48, REG_BITS_8},
	{0x507A, 0xF6FF, REG_BITS_16},
	{0x507C, 0xE9FF, REG_BITS_16},
	{0x507E, 0xF6FF, REG_BITS_16},
	{0x5080, 0xEAFF, REG_BITS_16},
	{0x5082, 0xF6FF, REG_BITS_16},
	{0x5084, 0xEAFF, REG_BITS_16},
	{0x5086, 0xF6FF, REG_BITS_16},
	{0x5088, 0xE9FF, REG_BITS_16},
	{0x508B, 0x48, REG_BITS_8},
	{0x508D, 0x56, REG_BITS_8},
	{0x508F, 0x56, REG_BITS_8},
	{0x5091, 0x48, REG_BITS_8},
	{0x0108, 0x01, REG_BITS_8},
	{0x0109, 0x4D, REG_BITS_8},
	{0x010D, 0x01, REG_BITS_8},
	{0x010E, 0x41, REG_BITS_8},
	{0x0112, 0x01, REG_BITS_8},
	{0x0113, 0x41, REG_BITS_8},
	{0x0117, 0x01, REG_BITS_8},
	{0x0118, 0x01, REG_BITS_8},
	{0x011C, 0x01, REG_BITS_8},
	{0x011D, 0xCD, REG_BITS_8},
	{0x0121, 0x01, REG_BITS_8},
	{0x0122, 0x01, REG_BITS_8},
	{0x0126, 0x01, REG_BITS_8},
	{0x0127, 0xC1, REG_BITS_8},
	{0x012A, 0x20, REG_BITS_8},
	{0x012B, 0x01, REG_BITS_8},
	{0x012C, 0x03, REG_BITS_8},
	{0x012F, 0x20, REG_BITS_8},
	{0x0130, 0x01, REG_BITS_8},
	{0x0131, 0x03, REG_BITS_8},
	{0x0134, 0x20, REG_BITS_8},
	{0x0135, 0x01, REG_BITS_8},
	{0x0136, 0x03, REG_BITS_8},
	{0x0139, 0x20, REG_BITS_8},
	{0x013A, 0x01, REG_BITS_8},
	{0x013B, 0x03, REG_BITS_8},
	{0x01D3, 0x04, REG_BITS_8},
	{0x01D4, 0x04, REG_BITS_8},
	{0x01D5, 0x04, REG_BITS_8},
	{0x01D6, 0x04, REG_BITS_8},
	{0x01D7, 0x04, REG_BITS_8},
	{0x01D8, 0x04, REG_BITS_8},
	{0x01D9, 0x02, REG_BITS_8},
	{0x01DA, 0x04, REG_BITS_8},
	{0x01DB, 0x00, REG_BITS_8},
	{0x01DC, 0x00, REG_BITS_8},
	{0x01DD, 0x00, REG_BITS_8},
	{0x01DE, 0x00, REG_BITS_8},
	{0x010A, 0x40, REG_BITS_8},
	{0x010F, 0x40, REG_BITS_8},
	{0x0114, 0x40, REG_BITS_8},
	{0x0119, 0x40, REG_BITS_8},
	{0x011E, 0x40, REG_BITS_8},
	{0x0123, 0x90, REG_BITS_8},
	{0x0128, 0x40, REG_BITS_8},
	{0x012D, 0x40, REG_BITS_8},
	{0x0132, 0x40, REG_BITS_8},
	{0x0137, 0x40, REG_BITS_8},
	{0x013C, 0x40, REG_BITS_8},
	{0x01B2, 0x59, REG_BITS_8},
	{0x01F9, 0x65, REG_BITS_8},
	{0x01FC, 0x65, REG_BITS_8},
	{0x0014, 0x0A, REG_BITS_8},
	{0x001D, 0x1B, REG_BITS_8},
	{0x02B8, 0x10, REG_BITS_8},
	{0x02BA, 0x50, REG_BITS_8},
	{0x02BB, 0x50, REG_BITS_8},
	{0x02BC, 0x10, REG_BITS_8},
	{0x02BD, 0x50, REG_BITS_8},
	{0x02BE, 0x50, REG_BITS_8},
	{0x02C0, 0x10, REG_BITS_8},
	{0x02C1, 0x10, REG_BITS_8},
	{0x033F, 0x00, REG_BITS_8},
	{0x02C2, 0x10, REG_BITS_8},
	{0x02C3, 0x10, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_period_3_ES2 =
    sizeof(seix006_vendor_1_period_3_ES2);

const struct reg_entry seix006_vendor_0_period_3_ES1[] = {
	{0x5800, 0x00, REG_BITS_8},
	{0x5801, 0x00, REG_BITS_8},
	{0x5802, 0x00, REG_BITS_8},
	{0x5803, 0x00, REG_BITS_8},
	{0x5805, 0x00, REG_BITS_8},
	{0x5806, 0x00, REG_BITS_8},
	{0x5808, 0x00, REG_BITS_8},
	{0x5809, 0x00, REG_BITS_8},
	{0x580B, 0x00, REG_BITS_8},
	{0x580C, 0x00, REG_BITS_8},
	{0x580E, 0x00, REG_BITS_8},
	{0x580F, 0x00, REG_BITS_8},
	{0x5811, 0x00, REG_BITS_8},
	{0x5812, 0x00, REG_BITS_8},
	{0x5814, 0x00, REG_BITS_8},
	{0x5815, 0x00, REG_BITS_8},
	{0x5816, 0x00, REG_BITS_8},
	{0x5819, 0x00, REG_BITS_8},
	{0x581A, 0x00, REG_BITS_8},
	{0x581B, 0x00, REG_BITS_8},
	{0x581C, 0x00, REG_BITS_8},
	{0x581F, 0x00, REG_BITS_8},
	{0x5820, 0x00, REG_BITS_8},
	{0x5821, 0x00, REG_BITS_8},
	{0x5822, 0x00, REG_BITS_8},
	{0x5825, 0x00, REG_BITS_8},
	{0x5826, 0x00, REG_BITS_8},
	{0x5827, 0x00, REG_BITS_8},
	{0x5828, 0x00, REG_BITS_8},
	{0x5829, 0x00, REG_BITS_8},
	{0x582A, 0x00, REG_BITS_8},
	{0x582B, 0x00, REG_BITS_8},
	{0x582C, 0x00, REG_BITS_8},
	{0x582D, 0x00, REG_BITS_8},
	{0x582E, 0x00, REG_BITS_8},
	{0x582F, 0x00, REG_BITS_8},
	{0x5830, 0x00, REG_BITS_8},
	{0x5831, 0x00, REG_BITS_8},
	{0x5832, 0x00, REG_BITS_8},
	{0x5833, 0x00, REG_BITS_8},
	{0x5834, 0x00, REG_BITS_8},
	{0x5835, 0x00, REG_BITS_8},
	{0x5836, 0x00, REG_BITS_8},
	{0x5837, 0x00, REG_BITS_8},
	{0x5838, 0x00, REG_BITS_8},
	{0x5839, 0x00, REG_BITS_8},
	{0x583A, 0x00, REG_BITS_8},
	{0x583B, 0x00, REG_BITS_8},
	{0x583C, 0x00, REG_BITS_8},
	{0x583D, 0x00, REG_BITS_8},
	{0x583E, 0x00, REG_BITS_8},
	{0x583F, 0x00, REG_BITS_8},
	{0x5840, 0x00, REG_BITS_8},
	{0x5841, 0x07, REG_BITS_8},
	{0x5842, 0x07, REG_BITS_8},
	{0x5843, 0x07, REG_BITS_8},
	{0x5844, 0x07, REG_BITS_8},
	{0x5845, 0x07, REG_BITS_8},
	{0x5846, 0x07, REG_BITS_8},
	{0x5847, 0x07, REG_BITS_8},
	{0x5848, 0x07, REG_BITS_8},
	{0x5849, 0x07, REG_BITS_8},
	{0x584A, 0x07, REG_BITS_8},
	{0x584B, 0x07, REG_BITS_8},
	{0x584C, 0x07, REG_BITS_8},
	{0x584D, 0x07, REG_BITS_8},
	{0x584E, 0x07, REG_BITS_8},
	{0x584F, 0x07, REG_BITS_8},
	{0x5850, 0x01, REG_BITS_8},
	{0x5851, 0x00, REG_BITS_8},
	{0x5852, 0x02, REG_BITS_8},
	{0x5853, 0x03, REG_BITS_8},
	{0x5854, 0x04, REG_BITS_8},
	{0x5855, 0x01, REG_BITS_8},
	{0x5856, 0x01, REG_BITS_8},
	{0x5857, 0x01, REG_BITS_8},
	{0x5858, 0x2A0A, REG_BITS_16},
	{0x585A, 0x9603, REG_BITS_16},
	{0x585C, 0x0000, REG_BITS_16},
	{0x585E, 0x2B0A, REG_BITS_16},
	{0x5860, 0x2E06, REG_BITS_16},
	{0x5862, 0x3102, REG_BITS_16},
	{0x5864, 0x2B0A, REG_BITS_16},
	{0x5866, 0x2E06, REG_BITS_16},
	{0x5868, 0x3102, REG_BITS_16},
	{0x586A, 0x2B0A, REG_BITS_16},
	{0x586C, 0x2E06, REG_BITS_16},
	{0x586E, 0x3102, REG_BITS_16},
	{0x5870, 0x2B0A, REG_BITS_16},
	{0x5872, 0x2E06, REG_BITS_16},
	{0x5874, 0x3102, REG_BITS_16},
	{0x5876, 0xF709, REG_BITS_16},
	{0x5878, 0xA506, REG_BITS_16},
	{0x587A, 0x5203, REG_BITS_16},
	{0x587C, 0xA20A, REG_BITS_16},
	{0x587E, 0x4F07, REG_BITS_16},
	{0x5880, 0xFD03, REG_BITS_16},
	{0x5882, 0x290B, REG_BITS_16},
	{0x5884, 0x0001, REG_BITS_16},
	{0x5886, 0x0000, REG_BITS_16},
	{0x5888, 0x2400, REG_BITS_16},
	{0x588A, 0x0B00, REG_BITS_16},
	{0x588C, 0x0A00, REG_BITS_16},
	{0x588E, 0x3000, REG_BITS_16},
	{0x5890, 0x2800, REG_BITS_16},
	{0x5892, 0x2000, REG_BITS_16},
	{0x5894, 0x0400, REG_BITS_16},
	{0x5896, 0x0200, REG_BITS_16},
	{0x5898, 0x0200, REG_BITS_16},
	{0x589A, 0x0800, REG_BITS_16},
	{0x589C, 0x1200, REG_BITS_16},
	{0x589E, 0x1200, REG_BITS_16},
	{0x58A6, 0x0400, REG_BITS_16},
	{0x58A8, 0x0200, REG_BITS_16},
	{0x58AA, 0x0200, REG_BITS_16},
	{0x58AC, 0x0800, REG_BITS_16},
	{0x58AE, 0x1200, REG_BITS_16},
	{0x58B0, 0x1200, REG_BITS_16},
	{0x58B8, 0x0100, REG_BITS_16},
	{0x58BA, 0x0100, REG_BITS_16},
	{0x58BC, 0x0000, REG_BITS_16},
	{0x58BE, 0x0400, REG_BITS_16},
	{0x58C0, 0x0500, REG_BITS_16},
	{0x58C2, 0x0400, REG_BITS_16},
	{0x58CA, 0x0100, REG_BITS_16},
	{0x58CC, 0x0100, REG_BITS_16},
	{0x58CE, 0x0000, REG_BITS_16},
	{0x58D0, 0x0400, REG_BITS_16},
	{0x58D2, 0x0500, REG_BITS_16},
	{0x58D4, 0x0400, REG_BITS_16},
	{0x58DC, 0x0A00, REG_BITS_16},
	{0x58DE, 0x0400, REG_BITS_16},
	{0x58E0, 0x0400, REG_BITS_16},
	{0x58E2, 0x0E00, REG_BITS_16},
	{0x58E4, 0x0C00, REG_BITS_16},
	{0x58E6, 0x0A00, REG_BITS_16},
	{0x58EE, 0x0A00, REG_BITS_16},
	{0x58F0, 0x0400, REG_BITS_16},
	{0x58F2, 0x0500, REG_BITS_16},
	{0x58F4, 0x0E00, REG_BITS_16},
	{0x58F6, 0x0C00, REG_BITS_16},
	{0x58F8, 0x0D00, REG_BITS_16},
	{0x5900, 0x0000, REG_BITS_16},
	{0x5902, 0x0000, REG_BITS_16},
	{0x5904, 0x0000, REG_BITS_16},
	{0x5906, 0x5E01, REG_BITS_16},
	{0x5908, 0x5E01, REG_BITS_16},
	{0x590A, 0x5E01, REG_BITS_16},
	{0x590C, 0x2602, REG_BITS_16},
	{0x590E, 0x2602, REG_BITS_16},
	{0x5910, 0x2602, REG_BITS_16},
	{0x591E, 0x0300, REG_BITS_16},
	{0x5920, 0x0400, REG_BITS_16},
	{0x5922, 0x0400, REG_BITS_16},
	{0x5924, 0x0000, REG_BITS_16},
	{0x5926, 0x8200, REG_BITS_16},
	{0x5928, 0x0000, REG_BITS_16},
	{0x592A, 0x2003, REG_BITS_16},
	{0x592C, 0x2003, REG_BITS_16},
	{0x592E, 0x2003, REG_BITS_16},
	{0x5930, 0x8403, REG_BITS_16},
	{0x5932, 0x8403, REG_BITS_16},
	{0x5934, 0x8403, REG_BITS_16},
	{0x5942, 0x0300, REG_BITS_16},
	{0x5944, 0x0400, REG_BITS_16},
	{0x5946, 0x0400, REG_BITS_16},
	{0x5948, 0x0000, REG_BITS_16},
	{0x594A, 0x2300, REG_BITS_16},
	{0x594C, 0x0000, REG_BITS_16},
	{0x594E, 0x3200, REG_BITS_16},
	{0x5950, 0x2300, REG_BITS_16},
	{0x5952, 0x3200, REG_BITS_16},
	{0x5954, 0xC800, REG_BITS_16},
	{0x5956, 0x5D00, REG_BITS_16},
	{0x5958, 0xC800, REG_BITS_16},
	{0x5966, 0x0100, REG_BITS_16},
	{0x5968, 0x0000, REG_BITS_16},
	{0x596A, 0x0000, REG_BITS_16},
	{0x596C, 0x40, REG_BITS_8},
	{0x596D, 0x40, REG_BITS_8},
	{0x596E, 0x40, REG_BITS_8},
	{0x596F, 0x40, REG_BITS_8},
	{0x5970, 0x40, REG_BITS_8},
	{0x5971, 0x40, REG_BITS_8},
	{0x5972, 0x40, REG_BITS_8},
	{0x5973, 0x40, REG_BITS_8},
	{0x5974, 0x46, REG_BITS_8},
	{0x5975, 0x18, REG_BITS_8},
	{0x5976, 0x20, REG_BITS_8},
	{0x5977, 0x20, REG_BITS_8},
	{0x5978, 0x5A, REG_BITS_8},
	{0x5979, 0x5A, REG_BITS_8},
	{0x597A, 0x40, REG_BITS_8},
	{0x597B, 0x00, REG_BITS_8},
	{0x597C, 0x55, REG_BITS_8},
	{0x597D, 0x78, REG_BITS_8},
	{0x597E, 0x10, REG_BITS_8},
	{0x597F, 0x10, REG_BITS_8},
	{0x5980, 0x10, REG_BITS_8},
	{0x5981, 0x10, REG_BITS_8},
	{0x5982, 0x10, REG_BITS_8},
	{0x5983, 0x08, REG_BITS_8},
	{0x5984, 0x10, REG_BITS_8},
	{0x5985, 0x10, REG_BITS_8},
	{0x5986, 0x10, REG_BITS_8},
	{0x5987, 0x10, REG_BITS_8},
	{0x5988, 0x10, REG_BITS_8},
	{0x5989, 0x08, REG_BITS_8},
	{0x598A, 0x10, REG_BITS_8},
	{0x598B, 0x10, REG_BITS_8},
	{0x598C, 0x10, REG_BITS_8},
	{0x598D, 0x10, REG_BITS_8},
	{0x598E, 0x08, REG_BITS_8},
	{0x598F, 0x10, REG_BITS_8},
	{0x5990, 0x10, REG_BITS_8},
	{0x5991, 0x10, REG_BITS_8},
	{0x5992, 0x10, REG_BITS_8},
	{0x5993, 0x10, REG_BITS_8},
	{0x5994, 0x10, REG_BITS_8},
	{0x5995, 0x10, REG_BITS_8},
	{0x5996, 0x10, REG_BITS_8},
	{0x5997, 0x0C, REG_BITS_8},
	{0x5998, 0x0C, REG_BITS_8},
	{0x5999, 0x04, REG_BITS_8},
	{0x599A, 0x03, REG_BITS_8},
	{0x599B, 0x08, REG_BITS_8},
	{0x599C, 0x10, REG_BITS_8},
	{0x599D, 0x08, REG_BITS_8},
	{0x599E, 0x10, REG_BITS_8},
	{0x599F, 0x04, REG_BITS_8},
	{0x59A0, 0x03, REG_BITS_8},
	{0x59A1, 0x08, REG_BITS_8},
	{0x59A2, 0x00, REG_BITS_8},
	{0x59A3, 0x00, REG_BITS_8},
	{0x59A4, 0x00, REG_BITS_8},
	{0x59A5, 0x20, REG_BITS_8},
	{0x59A6, 0x20, REG_BITS_8},
	{0x59A7, 0x20, REG_BITS_8},
	{0x59A8, 0x50, REG_BITS_8},
	{0x59A9, 0x50, REG_BITS_8},
	{0x59AA, 0x50, REG_BITS_8},
	{0x59AB, 0x00, REG_BITS_8},
	{0x59AC, 0x90, REG_BITS_8},
	{0x59AD, 0x00, REG_BITS_8},
	{0x59AE, 0x50, REG_BITS_8},
	{0x59AF, 0x50, REG_BITS_8},
	{0x59B0, 0x50, REG_BITS_8},
	{0x59B1, 0x50, REG_BITS_8},
	{0x59B2, 0x50, REG_BITS_8},
	{0x59B3, 0x50, REG_BITS_8},
	{0x59B4, 0x00, REG_BITS_8},
	{0x59B5, 0xFF, REG_BITS_8},
	{0x59B6, 0x00, REG_BITS_8},
	{0x59B7, 0x30, REG_BITS_8},
	{0x59B8, 0xE0, REG_BITS_8},
	{0x59B9, 0x30, REG_BITS_8},
	{0x59BA, 0x20, REG_BITS_8},
	{0x59BB, 0x20, REG_BITS_8},
	{0x59BC, 0x20, REG_BITS_8},
	{0x59BD, 0x80, REG_BITS_8},
	{0x59BE, 0x80, REG_BITS_8},
	{0x59BF, 0x40, REG_BITS_8},
	{0x59C0, 0x40, REG_BITS_8},
	{0x59C1, 0x40, REG_BITS_8},
	{0x59C2, 0x64, REG_BITS_8},
	{0x59C3, 0x64, REG_BITS_8},
	{0x59C4, 0x64, REG_BITS_8},
	{0x59C5, 0x08, REG_BITS_8},
	{0x59C6, 0x08, REG_BITS_8},
	{0x59C7, 0x08, REG_BITS_8},
	{0x59C8, 0x1E, REG_BITS_8},
	{0x59C9, 0x1E, REG_BITS_8},
	{0x59CA, 0x1E, REG_BITS_8},
	{0x59CB, 0x1E, REG_BITS_8},
	{0x59CC, 0x1E, REG_BITS_8},
	{0x59CD, 0x1E, REG_BITS_8},
	{0x59CE, 0x20, REG_BITS_8},
	{0x59CF, 0x20, REG_BITS_8},
	{0x59D0, 0x20, REG_BITS_8},
	{0x59D1, 0x20, REG_BITS_8},
	{0x59D2, 0x20, REG_BITS_8},
	{0x59D3, 0x20, REG_BITS_8},
	{0x59D4, 0x0000, REG_BITS_16},
	{0x59D6, 0x0000, REG_BITS_16},
	{0x59D8, 0x0000, REG_BITS_16},
	{0x59DA, 0xE2FF, REG_BITS_16},
	{0x59DC, 0xE2FF, REG_BITS_16},
	{0x59DE, 0xE2FF, REG_BITS_16},
	{0x59E0, 0xE0FF, REG_BITS_16},
	{0x59E2, 0xE0FF, REG_BITS_16},
	{0x59E4, 0xE0FF, REG_BITS_16},
	{0x59E6, 0xE0FF, REG_BITS_16},
	{0x59E8, 0xE0FF, REG_BITS_16},
	{0x59EA, 0xE0FF, REG_BITS_16},
	{0x59EC, 0xF9, REG_BITS_8},
	{0x59ED, 0xF9, REG_BITS_8},
	{0x59EE, 0xF9, REG_BITS_8},
	{0x59EF, 0xFE, REG_BITS_8},
	{0x59F0, 0xFE, REG_BITS_8},
	{0x59F1, 0xFE, REG_BITS_8},
	{0x59F2, 0xF9, REG_BITS_8},
	{0x59F3, 0xF9, REG_BITS_8},
	{0x59F4, 0xF9, REG_BITS_8},
	{0xC000, 0xF7B50E4D, REG_BITS_32},
	{0xC004, 0x0E4C0F4A, REG_BITS_32},
	{0xC008, 0x0F4F104B, REG_BITS_32},
	{0xC00C, 0x0021002A, REG_BITS_32},
	{0xC010, 0x04D96E5C, REG_BITS_32},
	{0xC014, 0x66540131, REG_BITS_32},
	{0xC018, 0x9142FAD3, REG_BITS_32},
	{0xC01C, 0x0021002B, REG_BITS_32},
	{0xC020, 0x04D90022, REG_BITS_32},
	{0xC024, 0x7A540131, REG_BITS_32},
	{0xC028, 0x9942FBD3, REG_BITS_32},
	{0xC02C, 0x08498860, REG_BITS_32},
	{0xC030, 0x01990848, REG_BITS_32},
	{0xC034, 0x086003B0, REG_BITS_32},
	{0xC038, 0x0120F0BD, REG_BITS_32},
	{0xC03C, 0x280D1800, REG_BITS_32},
	{0xC040, 0x280D1800, REG_BITS_32},
	{0xC044, 0x04000000, REG_BITS_32},
	{0xC048, 0x2C0D1800, REG_BITS_32},
	{0xC04C, 0x0C000000, REG_BITS_32},
	{0xC050, 0x2C0D1800, REG_BITS_32},
	{0xC054, 0x280D1800, REG_BITS_32},
	{0xC058, 0x80B55F78, REG_BITS_32},
	{0xC05C, 0x002F02D1, REG_BITS_32},
	{0xC060, 0x00F0B6F8, REG_BITS_32},
	{0xC064, 0x80BD00F0, REG_BITS_32},
	{0xC068, 0x01F8FBE7, REG_BITS_32},
	{0xC06C, 0xFFB583B0, REG_BITS_32},
	{0xC070, 0x0C1C1F1C, REG_BITS_32},
	{0xC074, 0x00250A23, REG_BITS_32},
	{0xC078, 0xF85EEB43, REG_BITS_32},
	{0xC07C, 0x534E9842, REG_BITS_32},
	{0xC080, 0x27D1F280, REG_BITS_32},
	{0xC084, 0xA01A02D5, REG_BITS_32},
	{0xC088, 0x40420121, REG_BITS_32},
	{0xC08C, 0x00E00021, REG_BITS_32},
	{0xC090, 0x31700004, REG_BITS_32},
	{0xC094, 0x000C7080, REG_BITS_32},
	{0xC098, 0xB0801AD1, REG_BITS_32},
	{0xC09C, 0x03208003, REG_BITS_32},
	{0xC0A0, 0x20430004, REG_BITS_32},
	{0xC0A4, 0x000C00F0, REG_BITS_32},
	{0xC0A8, 0xF2F80090, REG_BITS_32},
	{0xC0AC, 0xB0686A46, REG_BITS_32},
	{0xC0B0, 0x03210368, REG_BITS_32},
	{0xC0B4, 0x0C207FF6, REG_BITS_32},
	{0xC0B8, 0xB0FB0128, REG_BITS_32},
	{0xC0BC, 0x04D00020, REG_BITS_32},
	{0xC0C0, 0xC0437881, REG_BITS_32},
	{0xC0C4, 0x00207EE0, REG_BITS_32},
	{0xC0C8, 0x03980480, REG_BITS_32},
	{0xC0CC, 0x01207881, REG_BITS_32},
	{0xC0D0, 0x79E0B878, REG_BITS_32},
	{0xC0D4, 0x3D4E0290, REG_BITS_32},
	{0xC0D8, 0xF9784000, REG_BITS_32},
	{0xC0DC, 0x401A3979, REG_BITS_32},
	{0xC0E0, 0x401AB188, REG_BITS_32},
	{0xC0E4, 0x49007FF6, REG_BITS_32},
	{0xC0E8, 0x9DFB0404, REG_BITS_32},
	{0xC0EC, 0x240C788A, REG_BITS_32},
	{0xC0F0, 0xA04202DA, REG_BITS_32},
	{0xC0F4, 0x0121041C, REG_BITS_32},
	{0xC0F8, 0x00E00021, REG_BITS_32},
	{0xC0FC, 0x01910298, REG_BITS_32},
	{0xC100, 0x00260028, REG_BITS_32},
	{0xC104, 0x0BDD301C, REG_BITS_32},
	{0xC108, 0x211C3A1C, REG_BITS_32},
	{0xC10C, 0x00F0A4F8, REG_BITS_32},
	{0xC110, 0x40190504, REG_BITS_32},
	{0xC114, 0x2D0CB878, REG_BITS_32},
	{0xC118, 0x0136B042, REG_BITS_32},
	{0xC11C, 0xF3DC2B4E, REG_BITS_32},
	{0xC120, 0xB088401B, REG_BITS_32},
	{0xC124, 0xB0800A23, REG_BITS_32},
	{0xC128, 0xF85E0123, REG_BITS_32},
	{0xC12C, 0xD84213D1, REG_BITS_32},
	{0xC130, 0x01990029, REG_BITS_32},
	{0xC134, 0x02D10121, REG_BITS_32},
	{0xC138, 0x79810DE0, REG_BITS_32},
	{0xC13C, 0x7188281C, REG_BITS_32},
	{0xC140, 0x7FF6BAFA, REG_BITS_32},
	{0xC144, 0x78817188, REG_BITS_32},
	{0xC148, 0x281C7FF6, REG_BITS_32},
	{0xC14C, 0xB5FA0029, REG_BITS_32},
	{0xC150, 0x02D07889, REG_BITS_32},
	{0xC154, 0x01307881, REG_BITS_32},
	{0xC158, 0xB8780025, REG_BITS_32},
	{0xC15C, 0x002831DD, REG_BITS_32},
	{0xC160, 0x281C211C, REG_BITS_32},
	{0xC164, 0x3A1C00F0, REG_BITS_32},
	{0xC168, 0x77F80199, REG_BITS_32},
	{0xC16C, 0x002907D1, REG_BITS_32},
	{0xC170, 0xB1880029, REG_BITS_32},
	{0xC174, 0x04DD0130, REG_BITS_32},
	{0xC178, 0x0004000C, REG_BITS_32},
	{0xC17C, 0x0139B180, REG_BITS_32},
	{0xC180, 0x31780029, REG_BITS_32},
	{0xC184, 0x02D1F188, REG_BITS_32},
	{0xC188, 0x081801E0, REG_BITS_32},
	{0xC18C, 0xF188081A, REG_BITS_32},
	{0xC190, 0xF080F088, REG_BITS_32},
	{0xC194, 0x03239B03, REG_BITS_32},
	{0xC198, 0x18430004, REG_BITS_32},
	{0xC19C, 0x000C00F0, REG_BITS_32},
	{0xC1A0, 0x76F80090, REG_BITS_32},
	{0xC1A4, 0xB0686A46, REG_BITS_32},
	{0xC1A8, 0x03210368, REG_BITS_32},
	{0xC1AC, 0x0C207FF6, REG_BITS_32},
	{0xC1B0, 0x34FB0128, REG_BITS_32},
	{0xC1B4, 0x83D1F088, REG_BITS_32},
	{0xC1B8, 0x03990880, REG_BITS_32},
	{0xC1BC, 0xB8780135, REG_BITS_32},
	{0xC1C0, 0xA842CDDC, REG_BITS_32},
	{0xC1C4, 0x012007B0, REG_BITS_32},
	{0xC1C8, 0xF0BD0000, REG_BITS_32},
	{0xC1CC, 0x2C0D1800, REG_BITS_32},
	{0xC1D0, 0xF8B51C1C, REG_BITS_32},
	{0xC1D4, 0x151C061C, REG_BITS_32},
	{0xC1D8, 0x0F1C0320, REG_BITS_32},
	{0xC1DC, 0x80033843, REG_BITS_32},
	{0xC1E0, 0x0004000C, REG_BITS_32},
	{0xC1E4, 0x00F053F8, REG_BITS_32},
	{0xC1E8, 0x00900A48, REG_BITS_32},
	{0xC1EC, 0x6A468068, REG_BITS_32},
	{0xC1F0, 0x03210368, REG_BITS_32},
	{0xC1F4, 0x0C207FF6, REG_BITS_32},
	{0xC1F8, 0x10FB0128, REG_BITS_32},
	{0xC1FC, 0x01D00020, REG_BITS_32},
	{0xC200, 0x06E0381C, REG_BITS_32},
	{0xC204, 0x291C221C, REG_BITS_32},
	{0xC208, 0x378000F0, REG_BITS_32},
	{0xC20C, 0x05F80120, REG_BITS_32},
	{0xC210, 0xF8BD0000, REG_BITS_32},
	{0xC214, 0x2C0D1800, REG_BITS_32},
	{0xC218, 0x80B5171C, REG_BITS_32},
	{0xC21C, 0x3A78002A, REG_BITS_32},
	{0xC220, 0x01D13889, REG_BITS_32},
	{0xC224, 0xF988401A, REG_BITS_32},
	{0xC228, 0x00D54042, REG_BITS_32},
	{0xC22C, 0xFA890109, REG_BITS_32},
	{0xC230, 0x51430007, REG_BITS_32},
	{0xC234, 0x000F00D0, REG_BITS_32},
	{0xC238, 0x5118388A, REG_BITS_32},
	{0xC23C, 0x4118B869, REG_BITS_32},
	{0xC240, 0x09187FF6, REG_BITS_32},
	{0xC244, 0x39FA034B, REG_BITS_32},
	{0xC248, 0x984200D9, REG_BITS_32},
	{0xC24C, 0x181C7881, REG_BITS_32},
	{0xC250, 0x80BD0000, REG_BITS_32},
	{0xC254, 0xFF7F0000, REG_BITS_32},
	{0xC258, 0x80B5D378, REG_BITS_32},
	{0xC25C, 0x834205DD, REG_BITS_32},
	{0xC260, 0x01304843, REG_BITS_32},
	{0xC264, 0x0A1C011C, REG_BITS_32},
	{0xC268, 0x581C09E0, REG_BITS_32},
	{0xC26C, 0x93781279, REG_BITS_32},
	{0xC270, 0x9F1A8742, REG_BITS_32},
	{0xC274, 0x09DC181A, REG_BITS_32},
	{0xC278, 0x48430B1C, REG_BITS_32},
	{0xC27C, 0x011C501C, REG_BITS_32},
	{0xC280, 0x7FF6D0FA, REG_BITS_32},
	{0xC284, 0x0004000C, REG_BITS_32},
	{0xC288, 0x80BD081C, REG_BITS_32},
	{0xC28C, 0xFCE70102, REG_BITS_32},
	{0xC290, 0x00120843, REG_BITS_32},
	{0xC294, 0x0004000C, REG_BITS_32},
	{0xC298, 0xF7460000, REG_BITS_32},
	{0xC29C, 0xE50A1800, REG_BITS_32},
	{0x485C, 0xA002, REG_BITS_16},
	{0x485E, 0xB8EB, REG_BITS_16},
	{0x000A, 0x01, REG_BITS_8},
	{0x4808, 0x1900, REG_BITS_16},
	{0x480A, 0xFA00, REG_BITS_16},
	{0x480C, 0xEB03, REG_BITS_16},
	{0x480E, 0x7D00, REG_BITS_16},
	{0x4810, 0x7D00, REG_BITS_16},
	{0x4812, 0xEB03, REG_BITS_16},
	{0x4816, 0x01, REG_BITS_8},
	{0x481C, 0x01, REG_BITS_8},
	{0x481D, 0x01, REG_BITS_8},
	{0x4822, 0x0200, REG_BITS_16},
	{0x4824, 0x0800, REG_BITS_16},
	{0x4826, 0x0500, REG_BITS_16},
	{0x482C, 0x1E00, REG_BITS_16},
	{0x4832, 0x2C01, REG_BITS_16},
	{0x4838, 0x2000, REG_BITS_16},
	{0x4840, 0x00, REG_BITS_8},
	{0x4844, 0x8000, REG_BITS_16},
	{0x4846, 0x01, REG_BITS_8},
	{0x4847, 0x01, REG_BITS_8},
	{0x4848, 0x02, REG_BITS_8},
	{0x484A, 0x03, REG_BITS_8},
	{0x484B, 0x03, REG_BITS_8},
	{0x484E, 0x08, REG_BITS_8},
	{0x484F, 0x00, REG_BITS_8},
	{0x4854, 0x02, REG_BITS_8},
	{0x4856, 0x14, REG_BITS_8},
	{0x4857, 0x0A, REG_BITS_8},
	{0x4864, 0x0000, REG_BITS_16},
	{0x4866, 0x0000, REG_BITS_16},
	{0x4868, 0x0000, REG_BITS_16},
	{0x486A, 0x0001, REG_BITS_16},
	{0x486C, 0x4000, REG_BITS_16},
	{0x486E, 0x1000, REG_BITS_16},
	{0x4870, 0x4000, REG_BITS_16},
	{0x4872, 0x1000, REG_BITS_16},
	{0x4876, 0x0000, REG_BITS_16},
	{0x4878, 0x0003, REG_BITS_16},
	{0x487A, 0x0000, REG_BITS_16},
	{0x487C, 0x0002, REG_BITS_16},
	{0x487E, 0x0000, REG_BITS_16},
	{0x4880, 0xFF03, REG_BITS_16},
	{0x4882, 0x0000, REG_BITS_16},
	{0x4884, 0x01, REG_BITS_8},
	{0x4887, 0x02, REG_BITS_8},
	{0x4888, 0x01, REG_BITS_8},
	{0x4889, 0x18, REG_BITS_8},
	{0x488A, 0x00, REG_BITS_8},
	{0x488B, 0x00, REG_BITS_8},
	{0x488C, 0x0400, REG_BITS_16},
	{0x488E, 0x0400, REG_BITS_16},
	{0x489A, 0xD75D, REG_BITS_16},
	{0x489C, 0x7B67, REG_BITS_16},
	{0x489E, 0x9176, REG_BITS_16},
	{0x48A0, 0x2600, REG_BITS_16},
	{0x48A2, 0x0600, REG_BITS_16},
	{0x48A4, 0x1E00, REG_BITS_16},
	{0x48A6, 0xD75D, REG_BITS_16},
	{0x48A8, 0x7B67, REG_BITS_16},
	{0x48AA, 0x9176, REG_BITS_16},
	{0x48AC, 0x0200, REG_BITS_16},
	{0x48AE, 0x0500, REG_BITS_16},
	{0x48B0, 0x0400, REG_BITS_16},
	{0x48B2, 0xD75D, REG_BITS_16},
	{0x48B4, 0x7B67, REG_BITS_16},
	{0x48B6, 0x9176, REG_BITS_16},
	{0x48B8, 0x0500, REG_BITS_16},
	{0x48BA, 0x0900, REG_BITS_16},
	{0x48BC, 0x0B00, REG_BITS_16},
	{0x48BE, 0xD75D, REG_BITS_16},
	{0x48C0, 0x7B67, REG_BITS_16},
	{0x48C2, 0x9176, REG_BITS_16},
	{0x48C4, 0x1400, REG_BITS_16},
	{0x48C6, 0x1400, REG_BITS_16},
	{0x48C8, 0x2600, REG_BITS_16},
	{0x48CA, 0xD75D, REG_BITS_16},
	{0x48CC, 0x7B67, REG_BITS_16},
	{0x48CE, 0x9176, REG_BITS_16},
	{0x48D0, 0x2600, REG_BITS_16},
	{0x48D2, 0x0600, REG_BITS_16},
	{0x48D4, 0x1E00, REG_BITS_16},
	{0x48D6, 0xD75D, REG_BITS_16},
	{0x48D8, 0x7B67, REG_BITS_16},
	{0x48DA, 0x9176, REG_BITS_16},
	{0x48DC, 0x0200, REG_BITS_16},
	{0x48DE, 0x0600, REG_BITS_16},
	{0x48E0, 0x0300, REG_BITS_16},
	{0x48E2, 0xD75D, REG_BITS_16},
	{0x48E4, 0x7B67, REG_BITS_16},
	{0x48E6, 0x9176, REG_BITS_16},
	{0x48E8, 0x0600, REG_BITS_16},
	{0x48EA, 0x0900, REG_BITS_16},
	{0x48EC, 0x0C00, REG_BITS_16},
	{0x48EE, 0xD75D, REG_BITS_16},
	{0x48F0, 0x7B67, REG_BITS_16},
	{0x48F2, 0x9176, REG_BITS_16},
	{0x48F4, 0x1E00, REG_BITS_16},
	{0x48F6, 0x1600, REG_BITS_16},
	{0x48F8, 0x2600, REG_BITS_16},
	{0x490C, 0x0002, REG_BITS_16},
	{0x490E, 0x0002, REG_BITS_16},
	{0x4910, 0x0002, REG_BITS_16},
	{0x4924, 0x1000, REG_BITS_16},
	{0x4926, 0x1000, REG_BITS_16},
	{0x4928, 0x1000, REG_BITS_16},
	{0x493C, 0x0002, REG_BITS_16},
	{0x493E, 0x0002, REG_BITS_16},
	{0x4940, 0x0002, REG_BITS_16},
	{0x4954, 0x1000, REG_BITS_16},
	{0x4956, 0x1000, REG_BITS_16},
	{0x4958, 0x1000, REG_BITS_16},
	{0x495C, 0x01, REG_BITS_8},
	{0x495E, 0x0000, REG_BITS_16},
	{0x4960, 0x0000, REG_BITS_16},
	{0x4962, 0x0000, REG_BITS_16},
	{0x4968, 0x00, REG_BITS_8},
	{0x4969, 0x08, REG_BITS_8},
	{0x496C, 0x00, REG_BITS_8},
	{0x496E, 0xF401, REG_BITS_16},
	{0x4970, 0xE803, REG_BITS_16},
	{0x4972, 0x02, REG_BITS_8},
	{0x4C2C, 0xC604, REG_BITS_16},
	{0x4C2E, 0x4101, REG_BITS_16},
	{0x4C30, 0xE600, REG_BITS_16},
	{0x4C32, 0xE600, REG_BITS_16},
	{0x4C34, 0x8A04, REG_BITS_16},
	{0x4C36, 0x0501, REG_BITS_16},
	{0x4C38, 0x5F01, REG_BITS_16},
	{0x4C3A, 0x5F01, REG_BITS_16},
	{0x4C3C, 0xAA02, REG_BITS_16},
	{0x4C3E, 0x5D03, REG_BITS_16},
	{0x4C40, 0xE600, REG_BITS_16},
	{0x4C42, 0xE600, REG_BITS_16},
	{0x4C44, 0x6E02, REG_BITS_16},
	{0x4C46, 0x2103, REG_BITS_16},
	{0x4C48, 0x5F01, REG_BITS_16},
	{0x4C4A, 0x5F01, REG_BITS_16},
	{0x4C4C, 0xC604, REG_BITS_16},
	{0x4C4E, 0x5D03, REG_BITS_16},
	{0x4C50, 0xE600, REG_BITS_16},
	{0x4C52, 0xE600, REG_BITS_16},
	{0x4C54, 0x8A04, REG_BITS_16},
	{0x4C56, 0x2103, REG_BITS_16},
	{0x4C58, 0x5F01, REG_BITS_16},
	{0x4C5A, 0x5F01, REG_BITS_16},
	{0x4C5C, 0xE206, REG_BITS_16},
	{0x4C5E, 0x5D03, REG_BITS_16},
	{0x4C60, 0xE600, REG_BITS_16},
	{0x4C62, 0xE600, REG_BITS_16},
	{0x4C64, 0xA606, REG_BITS_16},
	{0x4C66, 0x2103, REG_BITS_16},
	{0x4C68, 0x5F01, REG_BITS_16},
	{0x4C6A, 0x5F01, REG_BITS_16},
	{0x4C6C, 0xC604, REG_BITS_16},
	{0x4C6E, 0x7905, REG_BITS_16},
	{0x4C70, 0xE600, REG_BITS_16},
	{0x4C72, 0xE600, REG_BITS_16},
	{0x4C74, 0x8A04, REG_BITS_16},
	{0x4C76, 0x3D05, REG_BITS_16},
	{0x4C78, 0x5F01, REG_BITS_16},
	{0x4C7A, 0x5F01, REG_BITS_16},
	{0x4C7C, 0x06, REG_BITS_8},
	{0x4C7D, 0x05, REG_BITS_8},
	{0x4C7E, 0x02, REG_BITS_8},
	{0x4C7F, 0x01, REG_BITS_8},
	{0x4C80, 0x08, REG_BITS_8},
	{0x4C81, 0x07, REG_BITS_8},
	{0x4C82, 0x02, REG_BITS_8},
	{0x4C83, 0x01, REG_BITS_8},
	{0x4C84, 0x04, REG_BITS_8},
	{0x4C85, 0x03, REG_BITS_8},
	{0x5400, 0x0000, REG_BITS_16},
	{0x5402, 0x0A00, REG_BITS_16},
	{0x5404, 0x1400, REG_BITS_16},
	{0x5406, 0x2000, REG_BITS_16},
	{0x5408, 0x2600, REG_BITS_16},
	{0x540A, 0x3400, REG_BITS_16},
	{0x540C, 0x3800, REG_BITS_16},
	{0x540E, 0x4400, REG_BITS_16},
	{0x5410, 0x4A00, REG_BITS_16},
	{0x5412, 0x5400, REG_BITS_16},
	{0x5414, 0x5800, REG_BITS_16},
	{0x5416, 0x6400, REG_BITS_16},
	{0x5418, 0x6600, REG_BITS_16},
	{0x541A, 0x7000, REG_BITS_16},
	{0x541C, 0x7200, REG_BITS_16},
	{0x541E, 0x7C00, REG_BITS_16},
	{0x5420, 0x7E00, REG_BITS_16},
	{0x5422, 0x8600, REG_BITS_16},
	{0x5424, 0x5B00, REG_BITS_16},
	{0x5426, 0xA900, REG_BITS_16},
	{0x5428, 0xCF00, REG_BITS_16},
	{0x542A, 0xE300, REG_BITS_16},
	{0x542C, 0xF100, REG_BITS_16},
	{0x542E, 0xF700, REG_BITS_16},
	{0x5430, 0x0101, REG_BITS_16},
	{0x5432, 0x0301, REG_BITS_16},
	{0x5434, 0x0D01, REG_BITS_16},
	{0x5436, 0x0000, REG_BITS_16},
	{0x5438, 0x0A00, REG_BITS_16},
	{0x543A, 0x1400, REG_BITS_16},
	{0x543C, 0x2000, REG_BITS_16},
	{0x543E, 0x2600, REG_BITS_16},
	{0x5440, 0x3400, REG_BITS_16},
	{0x5442, 0x3800, REG_BITS_16},
	{0x5444, 0x4400, REG_BITS_16},
	{0x5446, 0x4A00, REG_BITS_16},
	{0x5448, 0x5400, REG_BITS_16},
	{0x544A, 0x5800, REG_BITS_16},
	{0x544C, 0x6400, REG_BITS_16},
	{0x544E, 0x6600, REG_BITS_16},
	{0x5450, 0x7000, REG_BITS_16},
	{0x5452, 0x7200, REG_BITS_16},
	{0x5454, 0x7C00, REG_BITS_16},
	{0x5456, 0x7E00, REG_BITS_16},
	{0x5458, 0x8600, REG_BITS_16},
	{0x545A, 0x5B00, REG_BITS_16},
	{0x545C, 0xA900, REG_BITS_16},
	{0x545E, 0xCF00, REG_BITS_16},
	{0x5460, 0xE300, REG_BITS_16},
	{0x5462, 0xF100, REG_BITS_16},
	{0x5464, 0xF700, REG_BITS_16},
	{0x5466, 0x0101, REG_BITS_16},
	{0x5468, 0x0301, REG_BITS_16},
	{0x546A, 0x0D01, REG_BITS_16},
	{0x546C, 0x0000, REG_BITS_16},
	{0x546E, 0x0A00, REG_BITS_16},
	{0x5470, 0x1400, REG_BITS_16},
	{0x5472, 0x2000, REG_BITS_16},
	{0x5474, 0x2600, REG_BITS_16},
	{0x5476, 0x3400, REG_BITS_16},
	{0x5478, 0x3800, REG_BITS_16},
	{0x547A, 0x4400, REG_BITS_16},
	{0x547C, 0x4A00, REG_BITS_16},
	{0x547E, 0x5400, REG_BITS_16},
	{0x5480, 0x5800, REG_BITS_16},
	{0x5482, 0x6400, REG_BITS_16},
	{0x5484, 0x6600, REG_BITS_16},
	{0x5486, 0x7000, REG_BITS_16},
	{0x5488, 0x7200, REG_BITS_16},
	{0x548A, 0x7C00, REG_BITS_16},
	{0x548C, 0x7E00, REG_BITS_16},
	{0x548E, 0x8600, REG_BITS_16},
	{0x5490, 0x5B00, REG_BITS_16},
	{0x5492, 0xA900, REG_BITS_16},
	{0x5494, 0xCF00, REG_BITS_16},
	{0x5496, 0xE300, REG_BITS_16},
	{0x5498, 0xF100, REG_BITS_16},
	{0x549A, 0xF700, REG_BITS_16},
	{0x549C, 0x0101, REG_BITS_16},
	{0x549E, 0x0301, REG_BITS_16},
	{0x54A0, 0x0D01, REG_BITS_16},
	{0x54A2, 0x1004, REG_BITS_16},
	{0x54A4, 0x0540, REG_BITS_16},
	{0x54A6, 0x1004, REG_BITS_16},
	{0x54A8, 0x0540, REG_BITS_16},
	{0x54AA, 0x1004, REG_BITS_16},
	{0x54AC, 0x0540, REG_BITS_16},
	{0x54AE, 0x401D, REG_BITS_16},
	{0x5600, 0x0000, REG_BITS_16},
	{0x5602, 0x0000, REG_BITS_16},
	{0x5604, 0x0100, REG_BITS_16},
	{0x5606, 0x0600, REG_BITS_16},
	{0x5608, 0x0C00, REG_BITS_16},
	{0x560A, 0x1500, REG_BITS_16},
	{0x560C, 0x1D00, REG_BITS_16},
	{0x560E, 0x2700, REG_BITS_16},
	{0x5610, 0x3100, REG_BITS_16},
	{0x5612, 0x3A00, REG_BITS_16},
	{0x5614, 0x4300, REG_BITS_16},
	{0x5616, 0x4B00, REG_BITS_16},
	{0x5618, 0x5300, REG_BITS_16},
	{0x561A, 0x5B00, REG_BITS_16},
	{0x561C, 0x6300, REG_BITS_16},
	{0x561E, 0x6A00, REG_BITS_16},
	{0x5620, 0x7100, REG_BITS_16},
	{0x5622, 0x7B00, REG_BITS_16},
	{0x5624, 0x3E00, REG_BITS_16},
	{0x5626, 0xAC00, REG_BITS_16},
	{0x5628, 0xD400, REG_BITS_16},
	{0x562A, 0xE600, REG_BITS_16},
	{0x562C, 0xF200, REG_BITS_16},
	{0x562E, 0xF800, REG_BITS_16},
	{0x5630, 0xFE00, REG_BITS_16},
	{0x5632, 0x0101, REG_BITS_16},
	{0x5634, 0x0401, REG_BITS_16},
	{0x5636, 0x0000, REG_BITS_16},
	{0x5638, 0x0000, REG_BITS_16},
	{0x563A, 0x0100, REG_BITS_16},
	{0x563C, 0x0600, REG_BITS_16},
	{0x563E, 0x0C00, REG_BITS_16},
	{0x5640, 0x1500, REG_BITS_16},
	{0x5642, 0x1D00, REG_BITS_16},
	{0x5644, 0x2700, REG_BITS_16},
	{0x5646, 0x3100, REG_BITS_16},
	{0x5648, 0x3A00, REG_BITS_16},
	{0x564A, 0x4300, REG_BITS_16},
	{0x564C, 0x4B00, REG_BITS_16},
	{0x564E, 0x5300, REG_BITS_16},
	{0x5650, 0x5B00, REG_BITS_16},
	{0x5652, 0x6300, REG_BITS_16},
	{0x5654, 0x6A00, REG_BITS_16},
	{0x5656, 0x7100, REG_BITS_16},
	{0x5658, 0x7B00, REG_BITS_16},
	{0x565A, 0x3E00, REG_BITS_16},
	{0x565C, 0xAC00, REG_BITS_16},
	{0x565E, 0xD400, REG_BITS_16},
	{0x5660, 0xE600, REG_BITS_16},
	{0x5662, 0xF200, REG_BITS_16},
	{0x5664, 0xF800, REG_BITS_16},
	{0x5666, 0xFE00, REG_BITS_16},
	{0x5668, 0x0101, REG_BITS_16},
	{0x566A, 0x0401, REG_BITS_16},
	{0x566C, 0x0000, REG_BITS_16},
	{0x566E, 0x0000, REG_BITS_16},
	{0x5670, 0x0100, REG_BITS_16},
	{0x5672, 0x0600, REG_BITS_16},
	{0x5674, 0x0C00, REG_BITS_16},
	{0x5676, 0x1500, REG_BITS_16},
	{0x5678, 0x1D00, REG_BITS_16},
	{0x567A, 0x2700, REG_BITS_16},
	{0x567C, 0x3100, REG_BITS_16},
	{0x567E, 0x3A00, REG_BITS_16},
	{0x5680, 0x4300, REG_BITS_16},
	{0x5682, 0x4B00, REG_BITS_16},
	{0x5684, 0x5300, REG_BITS_16},
	{0x5686, 0x5B00, REG_BITS_16},
	{0x5688, 0x6300, REG_BITS_16},
	{0x568A, 0x6A00, REG_BITS_16},
	{0x568C, 0x7100, REG_BITS_16},
	{0x568E, 0x7B00, REG_BITS_16},
	{0x5690, 0x3E00, REG_BITS_16},
	{0x5692, 0xAC00, REG_BITS_16},
	{0x5694, 0xD400, REG_BITS_16},
	{0x5696, 0xE600, REG_BITS_16},
	{0x5698, 0xF200, REG_BITS_16},
	{0x569A, 0xF800, REG_BITS_16},
	{0x569C, 0xFE00, REG_BITS_16},
	{0x569E, 0x0101, REG_BITS_16},
	{0x56A0, 0x0401, REG_BITS_16},
	{0x56A2, 0x0019, REG_BITS_16},
	{0x56A4, 0x0540, REG_BITS_16},
	{0x56A6, 0x0019, REG_BITS_16},
	{0x56A8, 0x0540, REG_BITS_16},
	{0x56AA, 0x0019, REG_BITS_16},
	{0x56AC, 0x0540, REG_BITS_16},
	{0x56AE, 0x0023, REG_BITS_16},
	{0x4E0B, 0x00, REG_BITS_8},
	{0x4E0C, 0xFE01, REG_BITS_16},
	{0x4E0E, 0x2A0A, REG_BITS_16},
	{0x4E10, 0x0001, REG_BITS_16},
	{0x4E16, 0x00, REG_BITS_8},
	{0x4E17, 0x84, REG_BITS_8},
	{0x4F24, 0x3C, REG_BITS_8},
	{0x4F25, 0x01, REG_BITS_8},
	{0x4F2C, 0x0800, REG_BITS_16},
	{0x4F2E, 0x0000, REG_BITS_16},
	{0x4F30, 0x0000, REG_BITS_16},
	{0x4F32, 0x0800, REG_BITS_16},
	{0x4F34, 0x0000, REG_BITS_16},
	{0x4F36, 0x0000, REG_BITS_16},
	{0x4F38, 0x0A, REG_BITS_8},
	{0x4F39, 0x14, REG_BITS_8},
	{0x4F3A, 0x14, REG_BITS_8},
	{0x4F3B, 0x14, REG_BITS_8},
	{0x4F3C, 0x1E, REG_BITS_8},
	{0x4F3D, 0x1E, REG_BITS_8},
	{0x4F3E, 0x0A, REG_BITS_8},
	{0x4F3F, 0x1E, REG_BITS_8},
	{0x4F40, 0x1E, REG_BITS_8},
	{0x4F41, 0x01, REG_BITS_8},
	{0x4F42, 0x03, REG_BITS_8},
	{0x4F43, 0x01, REG_BITS_8},
	{0x4F44, 0x0010, REG_BITS_16},
	{0x4F46, 0x000C, REG_BITS_16},
	{0x4F48, 0x00, REG_BITS_8},
	{0x4F49, 0x00, REG_BITS_8},
	{0x4F4A, 0x00, REG_BITS_8},
	{0x4F4B, 0x10, REG_BITS_8},
	{0x4F4C, 0x01, REG_BITS_8},
	{0x4F4E, 0x0014, REG_BITS_16},
	{0x4F50, 0x0010, REG_BITS_16},
	{0x5062, 0xF6FF, REG_BITS_16},
	{0x5064, 0xE9FF, REG_BITS_16},
	{0x5066, 0xF6FF, REG_BITS_16},
	{0x5068, 0xEAFF, REG_BITS_16},
	{0x506A, 0xF6FF, REG_BITS_16},
	{0x506C, 0xEAFF, REG_BITS_16},
	{0x506E, 0xF6FF, REG_BITS_16},
	{0x5070, 0xE9FF, REG_BITS_16},
	{0x5072, 0x40, REG_BITS_8},
	{0x5073, 0x48, REG_BITS_8},
	{0x5074, 0x40, REG_BITS_8},
	{0x5075, 0x56, REG_BITS_8},
	{0x5076, 0x40, REG_BITS_8},
	{0x5077, 0x56, REG_BITS_8},
	{0x5078, 0x40, REG_BITS_8},
	{0x5079, 0x48, REG_BITS_8},
	{0x507A, 0xF6FF, REG_BITS_16},
	{0x507C, 0xE9FF, REG_BITS_16},
	{0x507E, 0xF6FF, REG_BITS_16},
	{0x5080, 0xEAFF, REG_BITS_16},
	{0x5082, 0xF6FF, REG_BITS_16},
	{0x5084, 0xEAFF, REG_BITS_16},
	{0x5086, 0xF6FF, REG_BITS_16},
	{0x5088, 0xE9FF, REG_BITS_16},
	{0x508A, 0x40, REG_BITS_8},
	{0x508B, 0x48, REG_BITS_8},
	{0x508C, 0x40, REG_BITS_8},
	{0x508D, 0x56, REG_BITS_8},
	{0x508E, 0x40, REG_BITS_8},
	{0x508F, 0x56, REG_BITS_8},
	{0x5090, 0x40, REG_BITS_8},
	{0x5091, 0x48, REG_BITS_8},
	{0x0101, 0x00, REG_BITS_8},
	{0x0108, 0x01, REG_BITS_8},
	{0x0109, 0x4D, REG_BITS_8},
	{0x010D, 0x01, REG_BITS_8},
	{0x010E, 0x4D, REG_BITS_8},
	{0x0112, 0x01, REG_BITS_8},
	{0x0113, 0x4D, REG_BITS_8},
	{0x0117, 0x01, REG_BITS_8},
	{0x0118, 0x4D, REG_BITS_8},
	{0x011C, 0x01, REG_BITS_8},
	{0x011D, 0xCD, REG_BITS_8},
	{0x0121, 0x01, REG_BITS_8},
	{0x0122, 0x4D, REG_BITS_8},
	{0x0126, 0x01, REG_BITS_8},
	{0x0127, 0x03, REG_BITS_8},
	{0x012A, 0x20, REG_BITS_8},
	{0x012B, 0x01, REG_BITS_8},
	{0x012C, 0x03, REG_BITS_8},
	{0x012F, 0x20, REG_BITS_8},
	{0x0130, 0x01, REG_BITS_8},
	{0x0131, 0x03, REG_BITS_8},
	{0x0134, 0x20, REG_BITS_8},
	{0x0135, 0x01, REG_BITS_8},
	{0x0136, 0x03, REG_BITS_8},
	{0x0139, 0x20, REG_BITS_8},
	{0x013A, 0x01, REG_BITS_8},
	{0x013B, 0x03, REG_BITS_8},
	{0x01D3, 0x00, REG_BITS_8},
	{0x01D4, 0x00, REG_BITS_8},
	{0x01D5, 0x00, REG_BITS_8},
	{0x01D6, 0x00, REG_BITS_8},
	{0x01D7, 0x00, REG_BITS_8},
	{0x01D8, 0x00, REG_BITS_8},
	{0x01D9, 0x00, REG_BITS_8},
	{0x01DA, 0x00, REG_BITS_8},
	{0x01DB, 0x00, REG_BITS_8},
	{0x01DC, 0x00, REG_BITS_8},
	{0x01DD, 0x00, REG_BITS_8},
	{0x01DE, 0x00, REG_BITS_8},
	{0x010A, 0x40, REG_BITS_8},
	{0x010F, 0x40, REG_BITS_8},
	{0x0114, 0x80, REG_BITS_8},
	{0x0119, 0x40, REG_BITS_8},
	{0x011E, 0x40, REG_BITS_8},
	{0x0123, 0xD0, REG_BITS_8},
	{0x0128, 0x40, REG_BITS_8},
	{0x012D, 0x40, REG_BITS_8},
	{0x0132, 0x40, REG_BITS_8},
	{0x0137, 0x40, REG_BITS_8},
	{0x013C, 0x40, REG_BITS_8},
	{0x01AF, 0x00, REG_BITS_8},
	{0x01B0, 0x00, REG_BITS_8},
	{0x01B2, 0x65, REG_BITS_8},
	{0x01B3, 0x80, REG_BITS_8},
	{0x01F9, 0x75, REG_BITS_8},
	{0x01FA, 0x55, REG_BITS_8},
	{0x01FB, 0x95, REG_BITS_8},
	{0x01FC, 0x75, REG_BITS_8},
	{0x01FD, 0x55, REG_BITS_8},
	{0x02CA, 0x0000, REG_BITS_16},
	{0x02D8, 0x11, REG_BITS_8},
	{0x02D9, 0x11, REG_BITS_8},
	{0x02DA, 0x01, REG_BITS_8},
	{0x02DB, 0x00, REG_BITS_8},
	{0x02DC, 0x10, REG_BITS_8},
	{0x0013, 0x01, REG_BITS_8},
	{0x0014, 0x00, REG_BITS_8},
	{0x001D, 0x1B, REG_BITS_8},
	{0x0020, 0x00, REG_BITS_8},
	{0x0032, 0x0001, REG_BITS_16},
	{0x0034, 0x0000, REG_BITS_16},
	{0x0036, 0x0000, REG_BITS_16},
	{0x0204, 0x02, REG_BITS_8},
	{0x0205, 0x46, REG_BITS_8},
	{0x0206, 0x50, REG_BITS_8},
	{0x0207, 0x5A, REG_BITS_8},
	{0x0209, 0x88, REG_BITS_8},
	{0x020A, 0x0000, REG_BITS_16},
	{0x020C, 0x0000, REG_BITS_16},
	{0x020E, 0x0000, REG_BITS_16},
	{0x0210, 0x0000, REG_BITS_16},
	{0x0212, 0x0000, REG_BITS_16},
	{0x0214, 0x0000, REG_BITS_16},
	{0x0216, 0x00, REG_BITS_8},
	{0x0217, 0x00, REG_BITS_8},
	{0x0218, 0x00, REG_BITS_8},
	{0x0224, 0x00, REG_BITS_8},
	{0x0226, 0xA006, REG_BITS_16},
	{0x0234, 0x00, REG_BITS_8},
	{0x02A2, 0x0000, REG_BITS_16},
	{0x02A6, 0x0000, REG_BITS_16},
	{0x02A8, 0x0000, REG_BITS_16},
	{0x02B8, 0x10, REG_BITS_8},
	{0x02BA, 0x50, REG_BITS_8},
	{0x02BB, 0x50, REG_BITS_8},
	{0x02BC, 0x50, REG_BITS_8},
	{0x02BD, 0x50, REG_BITS_8},
	{0x02BE, 0x50, REG_BITS_8},
	{0x02BF, 0x10, REG_BITS_8},
	{0x02C0, 0x41, REG_BITS_8},
	{0x02C1, 0x10, REG_BITS_8},
	{0x02C2, 0x10, REG_BITS_8},
	{0x02C3, 0x10, REG_BITS_8},
	{0x02C8, 0x00, REG_BITS_8},
	{0x02CE, 0xA007, REG_BITS_16},
	{0x02D2, 0x00, REG_BITS_8},
	{0x02D3, 0x00, REG_BITS_8},
	{0x02D6, 0x01, REG_BITS_8},
	{0x033F, 0x00, REG_BITS_8},
	{0x0348, 0x00, REG_BITS_8},
	{0x0349, 0x00, REG_BITS_8},
	{0x034F, 0x00, REG_BITS_8},
	{0x0381, 0x00, REG_BITS_8},
	{0x0384, 0x03, REG_BITS_8},
	{0x5A02, 0x04, REG_BITS_8},
	{0x5A03, 0x00, REG_BITS_8},
	{0x5A04, 0x00, REG_BITS_8},
	{0x4200, 0x05, REG_BITS_8},
	{0x4201, 0x08, REG_BITS_8},
	{0x4202, 0x0A, REG_BITS_8},
	{0x4203, 0x0B, REG_BITS_8},
	{0x4204, 0x0D, REG_BITS_8},
	{0x4205, 0x0B, REG_BITS_8},
	{0x4206, 0x0A, REG_BITS_8},
	{0x4207, 0x08, REG_BITS_8},
	{0x4208, 0x05, REG_BITS_8},
	{0x4209, 0x08, REG_BITS_8},
	{0x420A, 0x09, REG_BITS_8},
	{0x420B, 0x0D, REG_BITS_8},
	{0x420C, 0x0E, REG_BITS_8},
	{0x420D, 0x10, REG_BITS_8},
	{0x420E, 0x0E, REG_BITS_8},
	{0x420F, 0x0D, REG_BITS_8},
	{0x4210, 0x09, REG_BITS_8},
	{0x4211, 0x08, REG_BITS_8},
	{0x4212, 0x09, REG_BITS_8},
	{0x4213, 0x0B, REG_BITS_8},
	{0x4214, 0x17, REG_BITS_8},
	{0x4215, 0x27, REG_BITS_8},
	{0x4216, 0x3F, REG_BITS_8},
	{0x4217, 0x27, REG_BITS_8},
	{0x4218, 0x17, REG_BITS_8},
	{0x4219, 0x0B, REG_BITS_8},
	{0x421A, 0x09, REG_BITS_8},
	{0x421B, 0x0A, REG_BITS_8},
	{0x421C, 0x0D, REG_BITS_8},
	{0x421D, 0x23, REG_BITS_8},
	{0x421E, 0x52, REG_BITS_8},
	{0x421F, 0x64, REG_BITS_8},
	{0x4220, 0x52, REG_BITS_8},
	{0x4221, 0x23, REG_BITS_8},
	{0x4222, 0x0D, REG_BITS_8},
	{0x4223, 0x0A, REG_BITS_8},
	{0x4224, 0x0A, REG_BITS_8},
	{0x4225, 0x0D, REG_BITS_8},
	{0x4226, 0x23, REG_BITS_8},
	{0x4227, 0x52, REG_BITS_8},
	{0x4228, 0x64, REG_BITS_8},
	{0x4229, 0x52, REG_BITS_8},
	{0x422A, 0x23, REG_BITS_8},
	{0x422B, 0x0D, REG_BITS_8},
	{0x422C, 0x0A, REG_BITS_8},
	{0x422D, 0x09, REG_BITS_8},
	{0x422E, 0x0B, REG_BITS_8},
	{0x422F, 0x17, REG_BITS_8},
	{0x4230, 0x27, REG_BITS_8},
	{0x4231, 0x32, REG_BITS_8},
	{0x4232, 0x27, REG_BITS_8},
	{0x4233, 0x17, REG_BITS_8},
	{0x4234, 0x0B, REG_BITS_8},
	{0x4235, 0x09, REG_BITS_8},
	{0x4236, 0x05, REG_BITS_8},
	{0x4237, 0x09, REG_BITS_8},
	{0x4238, 0x0D, REG_BITS_8},
	{0x4239, 0x11, REG_BITS_8},
	{0x423A, 0x13, REG_BITS_8},
	{0x423B, 0x11, REG_BITS_8},
	{0x423C, 0x0D, REG_BITS_8},
	{0x423D, 0x09, REG_BITS_8},
	{0x423E, 0x05, REG_BITS_8},
	{0x423F, 0x07, REG_BITS_8},
	{0x4240, 0x0D, REG_BITS_8},
	{0x4241, 0x0E, REG_BITS_8},
	{0x4242, 0x10, REG_BITS_8},
	{0x4243, 0x13, REG_BITS_8},
	{0x4244, 0x10, REG_BITS_8},
	{0x4245, 0x0E, REG_BITS_8},
	{0x4246, 0x0D, REG_BITS_8},
	{0x4247, 0x07, REG_BITS_8},
	{0x4248, 0x0D, REG_BITS_8},
	{0x4249, 0x10, REG_BITS_8},
	{0x424A, 0x16, REG_BITS_8},
	{0x424B, 0x1C, REG_BITS_8},
	{0x424C, 0x1F, REG_BITS_8},
	{0x424D, 0x1C, REG_BITS_8},
	{0x424E, 0x16, REG_BITS_8},
	{0x424F, 0x10, REG_BITS_8},
	{0x4250, 0x0D, REG_BITS_8},
	{0x4251, 0x12, REG_BITS_8},
	{0x4252, 0x19, REG_BITS_8},
	{0x4253, 0x21, REG_BITS_8},
	{0x4254, 0x32, REG_BITS_8},
	{0x4255, 0x47, REG_BITS_8},
	{0x4256, 0x32, REG_BITS_8},
	{0x4257, 0x21, REG_BITS_8},
	{0x4258, 0x19, REG_BITS_8},
	{0x4259, 0x12, REG_BITS_8},
	{0x425A, 0x14, REG_BITS_8},
	{0x425B, 0x1C, REG_BITS_8},
	{0x425C, 0x2B, REG_BITS_8},
	{0x425D, 0x52, REG_BITS_8},
	{0x425E, 0x64, REG_BITS_8},
	{0x425F, 0x52, REG_BITS_8},
	{0x4260, 0x2B, REG_BITS_8},
	{0x4261, 0x1C, REG_BITS_8},
	{0x4262, 0x14, REG_BITS_8},
	{0x4263, 0x14, REG_BITS_8},
	{0x4264, 0x1C, REG_BITS_8},
	{0x4265, 0x2B, REG_BITS_8},
	{0x4266, 0x52, REG_BITS_8},
	{0x4267, 0x64, REG_BITS_8},
	{0x4268, 0x52, REG_BITS_8},
	{0x4269, 0x2B, REG_BITS_8},
	{0x426A, 0x1C, REG_BITS_8},
	{0x426B, 0x14, REG_BITS_8},
	{0x426C, 0x12, REG_BITS_8},
	{0x426D, 0x19, REG_BITS_8},
	{0x426E, 0x21, REG_BITS_8},
	{0x426F, 0x32, REG_BITS_8},
	{0x4270, 0x38, REG_BITS_8},
	{0x4271, 0x32, REG_BITS_8},
	{0x4272, 0x21, REG_BITS_8},
	{0x4273, 0x19, REG_BITS_8},
	{0x4274, 0x12, REG_BITS_8},
	{0x4275, 0x11, REG_BITS_8},
	{0x4276, 0x14, REG_BITS_8},
	{0x4277, 0x18, REG_BITS_8},
	{0x4278, 0x1C, REG_BITS_8},
	{0x4279, 0x1F, REG_BITS_8},
	{0x427A, 0x1C, REG_BITS_8},
	{0x427B, 0x18, REG_BITS_8},
	{0x427C, 0x14, REG_BITS_8},
	{0x427D, 0x11, REG_BITS_8},
	{0x427E, 0x04, REG_BITS_8},
	{0x427F, 0x06, REG_BITS_8},
	{0x4280, 0x07, REG_BITS_8},
	{0x4281, 0x09, REG_BITS_8},
	{0x4282, 0x09, REG_BITS_8},
	{0x4283, 0x09, REG_BITS_8},
	{0x4284, 0x07, REG_BITS_8},
	{0x4285, 0x06, REG_BITS_8},
	{0x4286, 0x04, REG_BITS_8},
	{0x4287, 0x08, REG_BITS_8},
	{0x4288, 0x0B, REG_BITS_8},
	{0x4289, 0x0D, REG_BITS_8},
	{0x428A, 0x0E, REG_BITS_8},
	{0x428B, 0x10, REG_BITS_8},
	{0x428C, 0x0E, REG_BITS_8},
	{0x428D, 0x0D, REG_BITS_8},
	{0x428E, 0x0B, REG_BITS_8},
	{0x428F, 0x08, REG_BITS_8},
	{0x4290, 0x0C, REG_BITS_8},
	{0x4291, 0x10, REG_BITS_8},
	{0x4292, 0x16, REG_BITS_8},
	{0x4293, 0x1B, REG_BITS_8},
	{0x4294, 0x2F, REG_BITS_8},
	{0x4295, 0x1B, REG_BITS_8},
	{0x4296, 0x16, REG_BITS_8},
	{0x4297, 0x10, REG_BITS_8},
	{0x4298, 0x0C, REG_BITS_8},
	{0x4299, 0x0D, REG_BITS_8},
	{0x429A, 0x14, REG_BITS_8},
	{0x429B, 0x26, REG_BITS_8},
	{0x429C, 0x37, REG_BITS_8},
	{0x429D, 0x4E, REG_BITS_8},
	{0x429E, 0x37, REG_BITS_8},
	{0x429F, 0x26, REG_BITS_8},
	{0x42A0, 0x14, REG_BITS_8},
	{0x42A1, 0x0D, REG_BITS_8},
	{0x42A2, 0x0E, REG_BITS_8},
	{0x42A3, 0x18, REG_BITS_8},
	{0x42A4, 0x43, REG_BITS_8},
	{0x42A5, 0x5A, REG_BITS_8},
	{0x42A6, 0x64, REG_BITS_8},
	{0x42A7, 0x5A, REG_BITS_8},
	{0x42A8, 0x43, REG_BITS_8},
	{0x42A9, 0x18, REG_BITS_8},
	{0x42AA, 0x0E, REG_BITS_8},
	{0x42AB, 0x0D, REG_BITS_8},
	{0x42AC, 0x14, REG_BITS_8},
	{0x42AD, 0x26, REG_BITS_8},
	{0x42AE, 0x37, REG_BITS_8},
	{0x42AF, 0x3F, REG_BITS_8},
	{0x42B0, 0x37, REG_BITS_8},
	{0x42B1, 0x26, REG_BITS_8},
	{0x42B2, 0x14, REG_BITS_8},
	{0x42B3, 0x0D, REG_BITS_8},
	{0x42B4, 0x0B, REG_BITS_8},
	{0x42B5, 0x11, REG_BITS_8},
	{0x42B6, 0x14, REG_BITS_8},
	{0x42B7, 0x18, REG_BITS_8},
	{0x42B8, 0x1C, REG_BITS_8},
	{0x42B9, 0x18, REG_BITS_8},
	{0x42BA, 0x14, REG_BITS_8},
	{0x42BB, 0x11, REG_BITS_8},
	{0x42BC, 0x0B, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_period_3_ES1 =
    sizeof(seix006_vendor_0_period_3_ES1);

const struct reg_entry seix006_vendor_0_period_3_ES2[] = {
	{0x5842, 0x07, REG_BITS_8},
	{0x5843, 0x07, REG_BITS_8},
	{0x5844, 0x07, REG_BITS_8},
	{0x5845, 0x07, REG_BITS_8},
	{0x5846, 0x07, REG_BITS_8},
	{0x5847, 0x07, REG_BITS_8},
	{0x5848, 0x07, REG_BITS_8},
	{0x5849, 0x07, REG_BITS_8},
	{0x584A, 0x07, REG_BITS_8},
	{0x584B, 0x07, REG_BITS_8},
	{0x584C, 0x07, REG_BITS_8},
	{0x584D, 0x07, REG_BITS_8},
	{0x584E, 0x07, REG_BITS_8},
	{0x584F, 0x07, REG_BITS_8},
	{0x5850, 0x00, REG_BITS_8},
	{0x5858, 0x2A0A, REG_BITS_16},
	{0x585A, 0x9603, REG_BITS_16},
	{0x585C, 0x0000, REG_BITS_16},
	{0x5882, 0x290B, REG_BITS_16},
	{0x5884, 0x0001, REG_BITS_16},
	{0x5886, 0x0000, REG_BITS_16},
	{0x588E, 0x3000, REG_BITS_16},
	{0x5890, 0x2800, REG_BITS_16},
	{0x5892, 0x2000, REG_BITS_16},
	{0x5894, 0x0400, REG_BITS_16},
	{0x589A, 0x0800, REG_BITS_16},
	{0x589C, 0x1200, REG_BITS_16},
	{0x589E, 0x1200, REG_BITS_16},
	{0x58A6, 0x0400, REG_BITS_16},
	{0x58AC, 0x0800, REG_BITS_16},
	{0x58AE, 0x1200, REG_BITS_16},
	{0x58B0, 0x1200, REG_BITS_16},
	{0x58B8, 0x0100, REG_BITS_16},
	{0x58BA, 0x0100, REG_BITS_16},
	{0x58BC, 0x0000, REG_BITS_16},
	{0x58BE, 0x0400, REG_BITS_16},
	{0x58C0, 0x0500, REG_BITS_16},
	{0x58CA, 0x0100, REG_BITS_16},
	{0x58CC, 0x0100, REG_BITS_16},
	{0x58CE, 0x0000, REG_BITS_16},
	{0x58D0, 0x0400, REG_BITS_16},
	{0x58D4, 0x0400, REG_BITS_16},
	{0x58DC, 0x0A00, REG_BITS_16},
	{0x58E2, 0x0E00, REG_BITS_16},
	{0x58E4, 0x0C00, REG_BITS_16},
	{0x58E6, 0x0A00, REG_BITS_16},
	{0x58EE, 0x0A00, REG_BITS_16},
	{0x58F2, 0x0500, REG_BITS_16},
	{0x58F4, 0x0E00, REG_BITS_16},
	{0x58F6, 0x0C00, REG_BITS_16},
	{0x58F8, 0x0D00, REG_BITS_16},
	{0x5906, 0x5E01, REG_BITS_16},
	{0x5908, 0x5E01, REG_BITS_16},
	{0x590A, 0x5E01, REG_BITS_16},
	{0x590C, 0x2602, REG_BITS_16},
	{0x590E, 0x2602, REG_BITS_16},
	{0x5910, 0x2602, REG_BITS_16},
	{0x591E, 0x0300, REG_BITS_16},
	{0x5920, 0x0400, REG_BITS_16},
	{0x5922, 0x0400, REG_BITS_16},
	{0x5926, 0x8200, REG_BITS_16},
	{0x592A, 0x2003, REG_BITS_16},
	{0x592C, 0x2003, REG_BITS_16},
	{0x592E, 0x2003, REG_BITS_16},
	{0x5930, 0x8403, REG_BITS_16},
	{0x5932, 0x8403, REG_BITS_16},
	{0x5934, 0x8403, REG_BITS_16},
	{0x5942, 0x0300, REG_BITS_16},
	{0x5944, 0x0400, REG_BITS_16},
	{0x5946, 0x0400, REG_BITS_16},
	{0x594A, 0x2300, REG_BITS_16},
	{0x594E, 0x3200, REG_BITS_16},
	{0x5950, 0x2300, REG_BITS_16},
	{0x5952, 0x3200, REG_BITS_16},
	{0x5954, 0xC800, REG_BITS_16},
	{0x5956, 0x5D00, REG_BITS_16},
	{0x5958, 0xC800, REG_BITS_16},
	{0x5968, 0x0000, REG_BITS_16},
	{0x596A, 0x0000, REG_BITS_16},
	{0x596C, 0x32, REG_BITS_8},
	{0x596D, 0x32, REG_BITS_8},
	{0x596F, 0x32, REG_BITS_8},
	{0x5970, 0x40, REG_BITS_8},
	{0x5971, 0x40, REG_BITS_8},
	{0x5972, 0x32, REG_BITS_8},
	{0x5973, 0x40, REG_BITS_8},
	{0x5974, 0x37, REG_BITS_8},
	{0x5975, 0x20, REG_BITS_8},
	{0x5976, 0x40, REG_BITS_8},
	{0x5977, 0x4A, REG_BITS_8},
	{0x5979, 0x5A, REG_BITS_8},
	{0x597A, 0x50, REG_BITS_8},
	{0x597C, 0x5A, REG_BITS_8},
	{0x597D, 0x87, REG_BITS_8},
	{0x597E, 0x10, REG_BITS_8},
	{0x597F, 0x10, REG_BITS_8},
	{0x5980, 0x10, REG_BITS_8},
	{0x5981, 0x10, REG_BITS_8},
	{0x5982, 0x10, REG_BITS_8},
	{0x5985, 0x10, REG_BITS_8},
	{0x5986, 0x10, REG_BITS_8},
	{0x5987, 0x10, REG_BITS_8},
	{0x5988, 0x10, REG_BITS_8},
	{0x5989, 0x08, REG_BITS_8},
	{0x598A, 0x10, REG_BITS_8},
	{0x598B, 0x10, REG_BITS_8},
	{0x598C, 0x10, REG_BITS_8},
	{0x598D, 0x10, REG_BITS_8},
	{0x598F, 0x10, REG_BITS_8},
	{0x5991, 0x10, REG_BITS_8},
	{0x5992, 0x10, REG_BITS_8},
	{0x5993, 0x10, REG_BITS_8},
	{0x5994, 0x10, REG_BITS_8},
	{0x5995, 0x10, REG_BITS_8},
	{0x5997, 0x0C, REG_BITS_8},
	{0x5998, 0x0C, REG_BITS_8},
	{0x5999, 0x04, REG_BITS_8},
	{0x599A, 0x03, REG_BITS_8},
	{0x599B, 0x08, REG_BITS_8},
	{0x599D, 0x08, REG_BITS_8},
	{0x599E, 0x10, REG_BITS_8},
	{0x599F, 0x04, REG_BITS_8},
	{0x59A0, 0x03, REG_BITS_8},
	{0x59A1, 0x08, REG_BITS_8},
	{0x59A5, 0x20, REG_BITS_8},
	{0x59A6, 0x20, REG_BITS_8},
	{0x59A7, 0x20, REG_BITS_8},
	{0x59A8, 0x50, REG_BITS_8},
	{0x59A9, 0x50, REG_BITS_8},
	{0x59AA, 0x50, REG_BITS_8},
	{0x59AC, 0x90, REG_BITS_8},
	{0x59AE, 0x50, REG_BITS_8},
	{0x59B1, 0x50, REG_BITS_8},
	{0x59B2, 0x50, REG_BITS_8},
	{0x59B3, 0x50, REG_BITS_8},
	{0x59B5, 0xFF, REG_BITS_8},
	{0x59B7, 0x30, REG_BITS_8},
	{0x59B8, 0xE0, REG_BITS_8},
	{0x59B9, 0x30, REG_BITS_8},
	{0x59BA, 0x20, REG_BITS_8},
	{0x59BB, 0x20, REG_BITS_8},
	{0x59BC, 0x20, REG_BITS_8},
	{0x59BD, 0x30, REG_BITS_8},
	{0x59BE, 0x60, REG_BITS_8},
	{0x59C5, 0x08, REG_BITS_8},
	{0x59C6, 0x08, REG_BITS_8},
	{0x59C7, 0x08, REG_BITS_8},
	{0x59C8, 0x1E, REG_BITS_8},
	{0x59C9, 0x1E, REG_BITS_8},
	{0x59CA, 0x1E, REG_BITS_8},
	{0x59CB, 0x1E, REG_BITS_8},
	{0x59CC, 0x1E, REG_BITS_8},
	{0x59CD, 0x1E, REG_BITS_8},
	{0x59D4, 0x0000, REG_BITS_16},
	{0x59D6, 0x0000, REG_BITS_16},
	{0x59D8, 0x0000, REG_BITS_16},
	{0x59DA, 0xE2FF, REG_BITS_16},
	{0x59DC, 0xE2FF, REG_BITS_16},
	{0x59DE, 0xE2FF, REG_BITS_16},
	{0x59EC, 0xF9, REG_BITS_8},
	{0x59ED, 0xF9, REG_BITS_8},
	{0x59EE, 0xF9, REG_BITS_8},
	{0x59F2, 0xF9, REG_BITS_8},
	{0x59F3, 0xF9, REG_BITS_8},
	{0x59F4, 0xF9, REG_BITS_8},
	{0xC000, 0xF7B581B0, REG_BITS_32},
	{0xC004, 0x164D174C, REG_BITS_32},
	{0xC008, 0x174F184A, REG_BITS_32},
	{0xC00C, 0x18490023, REG_BITS_32},
	{0xC010, 0x002F04D9, REG_BITS_32},
	{0xC014, 0xEE5CE654, REG_BITS_32},
	{0xC018, 0x0133BB42, REG_BITS_32},
	{0xC01C, 0xFAD30023, REG_BITS_32},
	{0xC020, 0x00270029, REG_BITS_32},
	{0xC024, 0x03D9D754, REG_BITS_32},
	{0xC028, 0x01338B42, REG_BITS_32},
	{0xC02C, 0xFBD31149, REG_BITS_32},
	{0xC030, 0x8860029A, REG_BITS_32},
	{0xC034, 0x10481060, REG_BITS_32},
	{0xC038, 0x10480090, REG_BITS_32},
	{0xC03C, 0x88686A46, REG_BITS_32},
	{0xC040, 0x03210368, REG_BITS_32},
	{0xC044, 0x0C207FF6, REG_BITS_32},
	{0xC048, 0xE8FB0128, REG_BITS_32},
	{0xC04C, 0x05D00020, REG_BITS_32},
	{0xC050, 0x039AC043, REG_BITS_32},
	{0xC054, 0x1081381C, REG_BITS_32},
	{0xC058, 0x00E00120, REG_BITS_32},
	{0xC05C, 0x04B0F0BD, REG_BITS_32},
	{0xC060, 0x440D1800, REG_BITS_32},
	{0xC064, 0x440D1800, REG_BITS_32},
	{0xC068, 0x04000000, REG_BITS_32},
	{0xC06C, 0x480D1800, REG_BITS_32},
	{0xC070, 0x0C000000, REG_BITS_32},
	{0xC074, 0x480D1800, REG_BITS_32},
	{0xC078, 0x440D1800, REG_BITS_32},
	{0xC07C, 0xCC010600, REG_BITS_32},
	{0xC080, 0x80B51F78, REG_BITS_32},
	{0xC084, 0x002F02D1, REG_BITS_32},
	{0xC088, 0x00F0B6F8, REG_BITS_32},
	{0xC08C, 0x80BD00F0, REG_BITS_32},
	{0xC090, 0x01F8FBE7, REG_BITS_32},
	{0xC094, 0xFFB583B0, REG_BITS_32},
	{0xC098, 0x0C1C1F1C, REG_BITS_32},
	{0xC09C, 0x00250823, REG_BITS_32},
	{0xC0A0, 0xF85EEB43, REG_BITS_32},
	{0xC0A4, 0x534E9842, REG_BITS_32},
	{0xC0A8, 0x27D1F280, REG_BITS_32},
	{0xC0AC, 0xA01A02D5, REG_BITS_32},
	{0xC0B0, 0x40420121, REG_BITS_32},
	{0xC0B4, 0x00E00021, REG_BITS_32},
	{0xC0B8, 0x31700004, REG_BITS_32},
	{0xC0BC, 0x000C7080, REG_BITS_32},
	{0xC0C0, 0xB0801AD1, REG_BITS_32},
	{0xC0C4, 0x1920C002, REG_BITS_32},
	{0xC0C8, 0x20430004, REG_BITS_32},
	{0xC0CC, 0x000C00F0, REG_BITS_32},
	{0xC0D0, 0xECF80090, REG_BITS_32},
	{0xC0D4, 0xB0686A46, REG_BITS_32},
	{0xC0D8, 0x03210368, REG_BITS_32},
	{0xC0DC, 0x0C207FF6, REG_BITS_32},
	{0xC0E0, 0x9CFB0128, REG_BITS_32},
	{0xC0E4, 0x04D00020, REG_BITS_32},
	{0xC0E8, 0xC0433881, REG_BITS_32},
	{0xC0EC, 0x00207EE0, REG_BITS_32},
	{0xC0F0, 0x03980480, REG_BITS_32},
	{0xC0F4, 0x01203881, REG_BITS_32},
	{0xC0F8, 0x79E07878, REG_BITS_32},
	{0xC0FC, 0x3D4E0290, REG_BITS_32},
	{0xC100, 0xB9784000, REG_BITS_32},
	{0xC104, 0x401AF978, REG_BITS_32},
	{0xC108, 0x401AB188, REG_BITS_32},
	{0xC10C, 0x49007FF6, REG_BITS_32},
	{0xC110, 0x89FB0404, REG_BITS_32},
	{0xC114, 0x240C388A, REG_BITS_32},
	{0xC118, 0xA04202DA, REG_BITS_32},
	{0xC11C, 0x0121041C, REG_BITS_32},
	{0xC120, 0x00E00021, REG_BITS_32},
	{0xC124, 0x01910298, REG_BITS_32},
	{0xC128, 0x00260028, REG_BITS_32},
	{0xC12C, 0x0BDD301C, REG_BITS_32},
	{0xC130, 0x211C3A1C, REG_BITS_32},
	{0xC134, 0x00F09EF8, REG_BITS_32},
	{0xC138, 0x40190504, REG_BITS_32},
	{0xC13C, 0x2D0C7878, REG_BITS_32},
	{0xC140, 0x0136B042, REG_BITS_32},
	{0xC144, 0xF3DC2B4E, REG_BITS_32},
	{0xC148, 0xB088401B, REG_BITS_32},
	{0xC14C, 0xB0800823, REG_BITS_32},
	{0xC150, 0xF85E0123, REG_BITS_32},
	{0xC154, 0xD84213D1, REG_BITS_32},
	{0xC158, 0x01990029, REG_BITS_32},
	{0xC15C, 0x02D10121, REG_BITS_32},
	{0xC160, 0x39810DE0, REG_BITS_32},
	{0xC164, 0x7188281C, REG_BITS_32},
	{0xC168, 0x7FF6A6FA, REG_BITS_32},
	{0xC16C, 0x38817188, REG_BITS_32},
	{0xC170, 0x281C7FF6, REG_BITS_32},
	{0xC174, 0xA1FA0029, REG_BITS_32},
	{0xC178, 0x02D03889, REG_BITS_32},
	{0xC17C, 0x01303881, REG_BITS_32},
	{0xC180, 0x78780025, REG_BITS_32},
	{0xC184, 0x002831DD, REG_BITS_32},
	{0xC188, 0x281C211C, REG_BITS_32},
	{0xC18C, 0x3A1C00F0, REG_BITS_32},
	{0xC190, 0x71F80199, REG_BITS_32},
	{0xC194, 0x002907D1, REG_BITS_32},
	{0xC198, 0xB1880029, REG_BITS_32},
	{0xC19C, 0x04DD0130, REG_BITS_32},
	{0xC1A0, 0x0004000C, REG_BITS_32},
	{0xC1A4, 0x0139B180, REG_BITS_32},
	{0xC1A8, 0x31780029, REG_BITS_32},
	{0xC1AC, 0x02D1F188, REG_BITS_32},
	{0xC1B0, 0x081801E0, REG_BITS_32},
	{0xC1B4, 0xF188081A, REG_BITS_32},
	{0xC1B8, 0xF080F088, REG_BITS_32},
	{0xC1BC, 0x1923DB02, REG_BITS_32},
	{0xC1C0, 0x18430004, REG_BITS_32},
	{0xC1C4, 0x000C00F0, REG_BITS_32},
	{0xC1C8, 0x70F80090, REG_BITS_32},
	{0xC1CC, 0xB0686A46, REG_BITS_32},
	{0xC1D0, 0x03210368, REG_BITS_32},
	{0xC1D4, 0x0C207FF6, REG_BITS_32},
	{0xC1D8, 0x20FB0128, REG_BITS_32},
	{0xC1DC, 0x83D1F088, REG_BITS_32},
	{0xC1E0, 0x03990880, REG_BITS_32},
	{0xC1E4, 0x78780135, REG_BITS_32},
	{0xC1E8, 0xA842CDDC, REG_BITS_32},
	{0xC1EC, 0x012007B0, REG_BITS_32},
	{0xC1F0, 0xF0BD0000, REG_BITS_32},
	{0xC1F4, 0x480D1800, REG_BITS_32},
	{0xC1F8, 0xF8B51C1C, REG_BITS_32},
	{0xC1FC, 0x151C061C, REG_BITS_32},
	{0xC200, 0x0F1C1920, REG_BITS_32},
	{0xC204, 0xC0023843, REG_BITS_32},
	{0xC208, 0x0004000C, REG_BITS_32},
	{0xC20C, 0x00F04DF8, REG_BITS_32},
	{0xC210, 0x00900A48, REG_BITS_32},
	{0xC214, 0x6A468068, REG_BITS_32},
	{0xC218, 0x03210368, REG_BITS_32},
	{0xC21C, 0x0C207FF6, REG_BITS_32},
	{0xC220, 0xFCFA0128, REG_BITS_32},
	{0xC224, 0x01D00020, REG_BITS_32},
	{0xC228, 0x06E0381C, REG_BITS_32},
	{0xC22C, 0x291C221C, REG_BITS_32},
	{0xC230, 0x378000F0, REG_BITS_32},
	{0xC234, 0x05F80120, REG_BITS_32},
	{0xC238, 0xF8BD0000, REG_BITS_32},
	{0xC23C, 0x480D1800, REG_BITS_32},
	{0xC240, 0x80B5171C, REG_BITS_32},
	{0xC244, 0x401A00D5, REG_BITS_32},
	{0xC248, 0x4042BA89, REG_BITS_32},
	{0xC24C, 0x01095143, REG_BITS_32},
	{0xC250, 0x0007000F, REG_BITS_32},
	{0xC254, 0x00D05118, REG_BITS_32},
	{0xC258, 0xF8894118, REG_BITS_32},
	{0xC25C, 0x78690918, REG_BITS_32},
	{0xC260, 0x7FF62AFA, REG_BITS_32},
	{0xC264, 0x024B9842, REG_BITS_32},
	{0xC268, 0x00D9181C, REG_BITS_32},
	{0xC26C, 0x388180BD, REG_BITS_32},
	{0xC270, 0xFF7F0000, REG_BITS_32},
	{0xC274, 0x80B59378, REG_BITS_32},
	{0xC278, 0x834205DD, REG_BITS_32},
	{0xC27C, 0x01304843, REG_BITS_32},
	{0xC280, 0x0A1C011C, REG_BITS_32},
	{0xC284, 0x581C09E0, REG_BITS_32},
	{0xC288, 0x5378D278, REG_BITS_32},
	{0xC28C, 0x9F1A8742, REG_BITS_32},
	{0xC290, 0x09DC181A, REG_BITS_32},
	{0xC294, 0x48430B1C, REG_BITS_32},
	{0xC298, 0x011C501C, REG_BITS_32},
	{0xC29C, 0x7FF6C2FA, REG_BITS_32},
	{0xC2A0, 0x0004000C, REG_BITS_32},
	{0xC2A4, 0x80BD081C, REG_BITS_32},
	{0xC2A8, 0xFCE70102, REG_BITS_32},
	{0xC2AC, 0x00120843, REG_BITS_32},
	{0xC2B0, 0x0004000C, REG_BITS_32},
	{0xC2B4, 0xF7460000, REG_BITS_32},
	{0xC2B8, 0x0D0B1800, REG_BITS_32},
	{0x485C, 0xBC02, REG_BITS_16},
	{0x485E, 0x8D1F, REG_BITS_16},
	{0x000A, 0x01, REG_BITS_8},
	{0x4808, 0x1900, REG_BITS_16},
	{0x480A, 0xFA00, REG_BITS_16},
	{0x480C, 0xEB03, REG_BITS_16},
	{0x480E, 0xE803, REG_BITS_16},
	{0x4810, 0xE803, REG_BITS_16},
	{0x4812, 0xEB03, REG_BITS_16},
	{0x481C, 0x00, REG_BITS_8},
	{0x4826, 0x0500, REG_BITS_16},
	{0x482C, 0x1E00, REG_BITS_16},
	{0x4832, 0x2C01, REG_BITS_16},
	{0x484F, 0x00, REG_BITS_8},
	{0x4856, 0x14, REG_BITS_8},
	{0x4884, 0x01, REG_BITS_8},
	{0x4889, 0x18, REG_BITS_8},
	{0x488A, 0x00, REG_BITS_8},
	{0x488B, 0x00, REG_BITS_8},
	{0x488C, 0x0400, REG_BITS_16},
	{0x48D0, 0xFF03, REG_BITS_16},
	{0x48D2, 0xFF03, REG_BITS_16},
	{0x48D4, 0xFF03, REG_BITS_16},
	{0x48E8, 0xFF03, REG_BITS_16},
	{0x48EA, 0xFF03, REG_BITS_16},
	{0x48EC, 0xFF03, REG_BITS_16},
	{0x48F4, 0xFF03, REG_BITS_16},
	{0x48F6, 0xFF03, REG_BITS_16},
	{0x48F8, 0xFF03, REG_BITS_16},
	{0x495C, 0x01, REG_BITS_8},
	{0x4968, 0x00, REG_BITS_8},
	{0x4969, 0x08, REG_BITS_8},
	{0x496C, 0x00, REG_BITS_8},
	{0x496E, 0xF401, REG_BITS_16},
	{0x4970, 0xE803, REG_BITS_16},
	{0x6E00, 0x01, REG_BITS_8},
	{0x6E08, 0x1E00, REG_BITS_16},
	{0x6E12, 0x3400, REG_BITS_16},
	{0x6E8E, 0x9600, REG_BITS_16},
	{0x6E90, 0xF401, REG_BITS_16},
	{0x6E92, 0x9600, REG_BITS_16},
	{0x4C2C, 0x2E04, REG_BITS_16},
	{0x4C2E, 0xC502, REG_BITS_16},
	{0x4C30, 0x1702, REG_BITS_16},
	{0x4C32, 0x1702, REG_BITS_16},
	{0x4C34, 0x8A04, REG_BITS_16},
	{0x4C36, 0x0501, REG_BITS_16},
	{0x4C38, 0x5F01, REG_BITS_16},
	{0x4C3A, 0x5F01, REG_BITS_16},
	{0x4C44, 0x6E02, REG_BITS_16},
	{0x4C46, 0x2103, REG_BITS_16},
	{0x4C48, 0x5F01, REG_BITS_16},
	{0x4C4A, 0x5F01, REG_BITS_16},
	{0x4C54, 0x8A04, REG_BITS_16},
	{0x4C56, 0x2103, REG_BITS_16},
	{0x4C58, 0x5F01, REG_BITS_16},
	{0x4C5A, 0x5F01, REG_BITS_16},
	{0x4C64, 0xA606, REG_BITS_16},
	{0x4C66, 0x2103, REG_BITS_16},
	{0x4C68, 0x5F01, REG_BITS_16},
	{0x4C6A, 0x5F01, REG_BITS_16},
	{0x4C74, 0x8A04, REG_BITS_16},
	{0x4C76, 0x3D05, REG_BITS_16},
	{0x4C78, 0x5F01, REG_BITS_16},
	{0x4C7A, 0x5F01, REG_BITS_16},
	{0x4C7D, 0x00, REG_BITS_8},
	{0x4C7E, 0x00, REG_BITS_8},
	{0x4C7F, 0x00, REG_BITS_8},
	{0x4C82, 0x00, REG_BITS_8},
	{0x4C83, 0x00, REG_BITS_8},
	{0x4C84, 0x00, REG_BITS_8},
	{0x4C85, 0x00, REG_BITS_8},
	{0x5438, 0x0100, REG_BITS_16},
	{0x543A, 0x0200, REG_BITS_16},
	{0x543C, 0x0400, REG_BITS_16},
	{0x543E, 0x0600, REG_BITS_16},
	{0x5440, 0x0800, REG_BITS_16},
	{0x5442, 0x0B00, REG_BITS_16},
	{0x5444, 0x0E00, REG_BITS_16},
	{0x5446, 0x1100, REG_BITS_16},
	{0x5448, 0x1400, REG_BITS_16},
	{0x544A, 0x1700, REG_BITS_16},
	{0x544C, 0x1B00, REG_BITS_16},
	{0x544E, 0x1F00, REG_BITS_16},
	{0x5450, 0x2300, REG_BITS_16},
	{0x5452, 0x2700, REG_BITS_16},
	{0x5454, 0x2C00, REG_BITS_16},
	{0x5456, 0x3200, REG_BITS_16},
	{0x5458, 0x3700, REG_BITS_16},
	{0x545A, 0x1600, REG_BITS_16},
	{0x545C, 0x5200, REG_BITS_16},
	{0x545E, 0x8400, REG_BITS_16},
	{0x5460, 0xAA00, REG_BITS_16},
	{0x5462, 0xC800, REG_BITS_16},
	{0x5464, 0xDC00, REG_BITS_16},
	{0x5466, 0xF000, REG_BITS_16},
	{0x5468, 0xFD00, REG_BITS_16},
	{0x54A2, 0x1001, REG_BITS_16},
	{0x54A6, 0x1001, REG_BITS_16},
	{0x54AA, 0x1001, REG_BITS_16},
	{0x54AE, 0x015D, REG_BITS_16},
	{0x5638, 0x0000, REG_BITS_16},
	{0x563A, 0x0100, REG_BITS_16},
	{0x563C, 0x0600, REG_BITS_16},
	{0x563E, 0x0C00, REG_BITS_16},
	{0x5640, 0x1500, REG_BITS_16},
	{0x5642, 0x1D00, REG_BITS_16},
	{0x5644, 0x2700, REG_BITS_16},
	{0x5646, 0x3100, REG_BITS_16},
	{0x5648, 0x3A00, REG_BITS_16},
	{0x564A, 0x4300, REG_BITS_16},
	{0x564C, 0x4B00, REG_BITS_16},
	{0x564E, 0x5300, REG_BITS_16},
	{0x5650, 0x5B00, REG_BITS_16},
	{0x5652, 0x6300, REG_BITS_16},
	{0x5654, 0x6A00, REG_BITS_16},
	{0x5656, 0x7100, REG_BITS_16},
	{0x5658, 0x7B00, REG_BITS_16},
	{0x565A, 0x3E00, REG_BITS_16},
	{0x565C, 0xAC00, REG_BITS_16},
	{0x565E, 0xD400, REG_BITS_16},
	{0x5660, 0xE600, REG_BITS_16},
	{0x5662, 0xF200, REG_BITS_16},
	{0x5664, 0xF800, REG_BITS_16},
	{0x5666, 0xFE00, REG_BITS_16},
	{0x5668, 0x0101, REG_BITS_16},
	{0x566A, 0x0401, REG_BITS_16},
	{0x56AE, 0x0023, REG_BITS_16},
	{0x4E0C, 0xFE01, REG_BITS_16},
	{0x4E0E, 0x2A0A, REG_BITS_16},
	{0x4E10, 0x0001, REG_BITS_16},
	{0x4F24, 0x3C, REG_BITS_8},
	{0x4F25, 0x09, REG_BITS_8},
	{0x4F2E, 0x0000, REG_BITS_16},
	{0x4F30, 0x0000, REG_BITS_16},
	{0x4F34, 0x0000, REG_BITS_16},
	{0x4F36, 0x0000, REG_BITS_16},
	{0x4F38, 0x0A, REG_BITS_8},
	{0x4F39, 0x14, REG_BITS_8},
	{0x4F3A, 0x14, REG_BITS_8},
	{0x4F3B, 0x14, REG_BITS_8},
	{0x4F3C, 0x1E, REG_BITS_8},
	{0x4F3D, 0x1E, REG_BITS_8},
	{0x4F3E, 0x0A, REG_BITS_8},
	{0x4F3F, 0x1E, REG_BITS_8},
	{0x4F40, 0x1E, REG_BITS_8},
	{0x5062, 0xF6FF, REG_BITS_16},
	{0x5064, 0xE9FF, REG_BITS_16},
	{0x5066, 0xF6FF, REG_BITS_16},
	{0x5068, 0xEAFF, REG_BITS_16},
	{0x506A, 0xF6FF, REG_BITS_16},
	{0x506C, 0xEAFF, REG_BITS_16},
	{0x506E, 0xF6FF, REG_BITS_16},
	{0x5070, 0xE9FF, REG_BITS_16},
	{0x5073, 0x48, REG_BITS_8},
	{0x5075, 0x56, REG_BITS_8},
	{0x5077, 0x56, REG_BITS_8},
	{0x5079, 0x48, REG_BITS_8},
	{0x507A, 0xF6FF, REG_BITS_16},
	{0x507C, 0xE9FF, REG_BITS_16},
	{0x507E, 0xF6FF, REG_BITS_16},
	{0x5080, 0xEAFF, REG_BITS_16},
	{0x5082, 0xF6FF, REG_BITS_16},
	{0x5084, 0xEAFF, REG_BITS_16},
	{0x5086, 0xF6FF, REG_BITS_16},
	{0x5088, 0xE9FF, REG_BITS_16},
	{0x508B, 0x48, REG_BITS_8},
	{0x508D, 0x56, REG_BITS_8},
	{0x508F, 0x56, REG_BITS_8},
	{0x5091, 0x48, REG_BITS_8},
	{0x0108, 0x01, REG_BITS_8},
	{0x0109, 0x4D, REG_BITS_8},
	{0x010D, 0x01, REG_BITS_8},
	{0x010E, 0x41, REG_BITS_8},
	{0x0112, 0x01, REG_BITS_8},
	{0x0113, 0x41, REG_BITS_8},
	{0x0117, 0x01, REG_BITS_8},
	{0x0118, 0x01, REG_BITS_8},
	{0x011C, 0x01, REG_BITS_8},
	{0x011D, 0xCD, REG_BITS_8},
	{0x0121, 0x01, REG_BITS_8},
	{0x0122, 0x01, REG_BITS_8},
	{0x0126, 0x01, REG_BITS_8},
	{0x0127, 0xC1, REG_BITS_8},
	{0x012A, 0x20, REG_BITS_8},
	{0x012B, 0x01, REG_BITS_8},
	{0x012C, 0x03, REG_BITS_8},
	{0x012F, 0x20, REG_BITS_8},
	{0x0130, 0x01, REG_BITS_8},
	{0x0131, 0x03, REG_BITS_8},
	{0x0134, 0x20, REG_BITS_8},
	{0x0135, 0x01, REG_BITS_8},
	{0x0136, 0x03, REG_BITS_8},
	{0x0139, 0x20, REG_BITS_8},
	{0x013A, 0x01, REG_BITS_8},
	{0x013B, 0x03, REG_BITS_8},
	{0x01D3, 0x04, REG_BITS_8},
	{0x01D4, 0x04, REG_BITS_8},
	{0x01D5, 0x04, REG_BITS_8},
	{0x01D6, 0x04, REG_BITS_8},
	{0x01D7, 0x04, REG_BITS_8},
	{0x01D8, 0x04, REG_BITS_8},
	{0x01D9, 0x02, REG_BITS_8},
	{0x01DA, 0x04, REG_BITS_8},
	{0x01DB, 0x00, REG_BITS_8},
	{0x01DC, 0x00, REG_BITS_8},
	{0x01DD, 0x00, REG_BITS_8},
	{0x01DE, 0x00, REG_BITS_8},
	{0x010A, 0x40, REG_BITS_8},
	{0x010F, 0x40, REG_BITS_8},
	{0x0114, 0x40, REG_BITS_8},
	{0x0119, 0x40, REG_BITS_8},
	{0x011E, 0x40, REG_BITS_8},
	{0x0123, 0x90, REG_BITS_8},
	{0x0128, 0x40, REG_BITS_8},
	{0x012D, 0x40, REG_BITS_8},
	{0x0132, 0x40, REG_BITS_8},
	{0x0137, 0x40, REG_BITS_8},
	{0x013C, 0x40, REG_BITS_8},
	{0x01B2, 0x59, REG_BITS_8},
	{0x01F9, 0x65, REG_BITS_8},
	{0x01FC, 0x65, REG_BITS_8},
	{0x0014, 0x0A, REG_BITS_8},
	{0x001D, 0x1B, REG_BITS_8},
	{0x02B8, 0x10, REG_BITS_8},
	{0x02BA, 0x50, REG_BITS_8},
	{0x02BB, 0x50, REG_BITS_8},
	{0x02BC, 0x10, REG_BITS_8},
	{0x02BD, 0x50, REG_BITS_8},
	{0x02BE, 0x50, REG_BITS_8},
	{0x02C0, 0x10, REG_BITS_8},
	{0x02C1, 0x10, REG_BITS_8},
	{0x033F, 0x00, REG_BITS_8},
	{0x02C2, 0x10, REG_BITS_8},
	{0x02C3, 0x10, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_period_3_ES2 =
    sizeof(seix006_vendor_0_period_3_ES2);

const struct reg_entry seix006_vendor_0_SHD_1_ES2[] = {
	{0x0068, 0x50, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x01, REG_BITS_8},
	{0x9003, 0x0e, REG_BITS_8},
	{0x9004, 0x04, REG_BITS_8},
	{0x9005, 0x38, REG_BITS_8},
	{0x9006, 0x20, REG_BITS_8},
	{0x9007, 0x40, REG_BITS_8},
	{0x9008, 0x01, REG_BITS_8},
	{0x9009, 0x81, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x02, REG_BITS_8},
	{0x900C, 0x14, REG_BITS_8},
	{0x900D, 0x04, REG_BITS_8},
	{0x900E, 0x50, REG_BITS_8},
	{0x900F, 0x10, REG_BITS_8},
	{0x9010, 0x60, REG_BITS_8},
	{0x9011, 0x01, REG_BITS_8},
	{0x9012, 0x01, REG_BITS_8},
	{0x9013, 0x05, REG_BITS_8},
	{0x9014, 0x04, REG_BITS_8},
	{0x9015, 0x14, REG_BITS_8},
	{0x9016, 0x04, REG_BITS_8},
	{0x9017, 0x38, REG_BITS_8},
	{0x9018, 0x10, REG_BITS_8},
	{0x9019, 0xe0, REG_BITS_8},
	{0x901A, 0x80, REG_BITS_8},
	{0x901B, 0x00, REG_BITS_8},
	{0x901C, 0x05, REG_BITS_8},
	{0x901D, 0x04, REG_BITS_8},
	{0x901E, 0x12, REG_BITS_8},
	{0x901F, 0x08, REG_BITS_8},
	{0x9020, 0x50, REG_BITS_8},
	{0x9021, 0x10, REG_BITS_8},
	{0x9022, 0x40, REG_BITS_8},
	{0x9023, 0x41, REG_BITS_8},
	{0x9024, 0x80, REG_BITS_8},
	{0x9025, 0x05, REG_BITS_8},
	{0x9026, 0x04, REG_BITS_8},
	{0x9027, 0x14, REG_BITS_8},
	{0x9028, 0x10, REG_BITS_8},
	{0x9029, 0x50, REG_BITS_8},
	{0x902A, 0x20, REG_BITS_8},
	{0x902B, 0xe0, REG_BITS_8},
	{0x902C, 0x80, REG_BITS_8},
	{0x902D, 0x80, REG_BITS_8},
	{0x902E, 0x03, REG_BITS_8},
	{0x902F, 0x01, REG_BITS_8},
	{0x9030, 0x12, REG_BITS_8},
	{0x9031, 0x08, REG_BITS_8},
	{0x9032, 0x40, REG_BITS_8},
	{0x9033, 0x30, REG_BITS_8},
	{0x9034, 0xe0, REG_BITS_8},
	{0x9035, 0x80, REG_BITS_8},
	{0x9036, 0x80, REG_BITS_8},
	{0x9037, 0x03, REG_BITS_8},
	{0x9038, 0x04, REG_BITS_8},
	{0x9039, 0x14, REG_BITS_8},
	{0x903A, 0x00, REG_BITS_8},
	{0x903B, 0x48, REG_BITS_8},
	{0x903C, 0x00, REG_BITS_8},
	{0x903D, 0x20, REG_BITS_8},
	{0x903E, 0x81, REG_BITS_8},
	{0x903F, 0x00, REG_BITS_8},
	{0x9040, 0x03, REG_BITS_8},
	{0x9041, 0x02, REG_BITS_8},
	{0x9042, 0x0c, REG_BITS_8},
	{0x9043, 0x08, REG_BITS_8},
	{0x9044, 0x30, REG_BITS_8},
	{0x9045, 0x30, REG_BITS_8},
	{0x9046, 0xa0, REG_BITS_8},
	{0x9047, 0x80, REG_BITS_8},
	{0x9048, 0x80, REG_BITS_8},
	{0x9049, 0x02, REG_BITS_8},
	{0x904A, 0x01, REG_BITS_8},
	{0x904B, 0x0e, REG_BITS_8},
	{0x904C, 0x08, REG_BITS_8},
	{0x904D, 0x40, REG_BITS_8},
	{0x904E, 0x30, REG_BITS_8},
	{0x904F, 0x40, REG_BITS_8},
	{0x9050, 0xc1, REG_BITS_8},
	{0x9051, 0x00, REG_BITS_8},
	{0x9052, 0x05, REG_BITS_8},
	{0x9053, 0x04, REG_BITS_8},
	{0x9054, 0x0a, REG_BITS_8},
	{0x9055, 0x10, REG_BITS_8},
	{0x9056, 0x28, REG_BITS_8},
	{0x9057, 0x00, REG_BITS_8},
	{0x9058, 0x80, REG_BITS_8},
	{0x9059, 0x00, REG_BITS_8},
	{0x905A, 0x81, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x02, REG_BITS_8},
	{0x905D, 0x06, REG_BITS_8},
	{0x905E, 0x08, REG_BITS_8},
	{0x905F, 0x20, REG_BITS_8},
	{0x9060, 0x10, REG_BITS_8},
	{0x9061, 0xa0, REG_BITS_8},
	{0x9062, 0x40, REG_BITS_8},
	{0x9063, 0x00, REG_BITS_8},
	{0x9064, 0x04, REG_BITS_8},
	{0x9065, 0x01, REG_BITS_8},
	{0x9066, 0x10, REG_BITS_8},
	{0x9067, 0x08, REG_BITS_8},
	{0x9068, 0x28, REG_BITS_8},
	{0x9069, 0x20, REG_BITS_8},
	{0x906A, 0xa0, REG_BITS_8},
	{0x906B, 0x40, REG_BITS_8},
	{0x906C, 0x80, REG_BITS_8},
	{0x906D, 0x01, REG_BITS_8},
	{0x906E, 0x02, REG_BITS_8},
	{0x906F, 0x04, REG_BITS_8},
	{0x9070, 0x08, REG_BITS_8},
	{0x9071, 0x08, REG_BITS_8},
	{0x9072, 0x10, REG_BITS_8},
	{0x9073, 0x40, REG_BITS_8},
	{0x9074, 0xc0, REG_BITS_8},
	{0x9075, 0xff, REG_BITS_8},
	{0x9076, 0x02, REG_BITS_8},
	{0x9077, 0x00, REG_BITS_8},
	{0x9078, 0x10, REG_BITS_8},
	{0x9079, 0x00, REG_BITS_8},
	{0x907A, 0x40, REG_BITS_8},
	{0x907B, 0x50, REG_BITS_8},
	{0x907C, 0x80, REG_BITS_8},
	{0x907D, 0x40, REG_BITS_8},
	{0x907E, 0x01, REG_BITS_8},
	{0x907F, 0x02, REG_BITS_8},
	{0x9080, 0x04, REG_BITS_8},
	{0x9081, 0x04, REG_BITS_8},
	{0x9082, 0x08, REG_BITS_8},
	{0x9083, 0x10, REG_BITS_8},
	{0x9084, 0x10, REG_BITS_8},
	{0x9085, 0x00, REG_BITS_8},
	{0x9086, 0x00, REG_BITS_8},
	{0x9087, 0x80, REG_BITS_8},
	{0x9088, 0x00, REG_BITS_8},
	{0x9089, 0x01, REG_BITS_8},
	{0x908A, 0x06, REG_BITS_8},
	{0x908B, 0x04, REG_BITS_8},
	{0x908C, 0x30, REG_BITS_8},
	{0x908D, 0x10, REG_BITS_8},
	{0x908E, 0xc0, REG_BITS_8},
	{0x908F, 0x80, REG_BITS_8},
	{0x9090, 0x00, REG_BITS_8},
	{0x9091, 0x02, REG_BITS_8},
	{0x9092, 0x02, REG_BITS_8},
	{0x9093, 0x08, REG_BITS_8},
	{0x9094, 0x08, REG_BITS_8},
	{0x9095, 0x10, REG_BITS_8},
	{0x9096, 0x30, REG_BITS_8},
	{0x9097, 0x20, REG_BITS_8},
	{0x9098, 0x00, REG_BITS_8},
	{0x9099, 0x81, REG_BITS_8},
	{0x909A, 0x00, REG_BITS_8},
	{0x909B, 0x03, REG_BITS_8},
	{0x909C, 0x02, REG_BITS_8},
	{0x909D, 0x08, REG_BITS_8},
	{0x909E, 0x18, REG_BITS_8},
	{0x909F, 0x30, REG_BITS_8},
	{0x90A0, 0xa0, REG_BITS_8},
	{0x90A1, 0xc0, REG_BITS_8},
	{0x90A2, 0x80, REG_BITS_8},
	{0x90A3, 0x02, REG_BITS_8},
	{0x90A4, 0x04, REG_BITS_8},
	{0x90A5, 0x0a, REG_BITS_8},
	{0x90A6, 0x10, REG_BITS_8},
	{0x90A7, 0x28, REG_BITS_8},
	{0x90A8, 0x10, REG_BITS_8},
	{0x90A9, 0x60, REG_BITS_8},
	{0x90AA, 0xc0, REG_BITS_8},
	{0x90AB, 0x80, REG_BITS_8},
	{0x90AC, 0x01, REG_BITS_8},
	{0x90AD, 0x04, REG_BITS_8},
	{0x90AE, 0x08, REG_BITS_8},
	{0x90AF, 0x0c, REG_BITS_8},
	{0x90B0, 0x10, REG_BITS_8},
	{0x90B1, 0x30, REG_BITS_8},
	{0x90B2, 0x80, REG_BITS_8},
	{0x90B3, 0x00, REG_BITS_8},
	{0x90B4, 0x81, REG_BITS_8},
	{0x90B5, 0x02, REG_BITS_8},
	{0x90B6, 0x04, REG_BITS_8},
	{0x90B7, 0x0a, REG_BITS_8},
	{0x90B8, 0x08, REG_BITS_8},
	{0x90B9, 0x18, REG_BITS_8},
	{0x90BA, 0x20, REG_BITS_8},
	{0x90BB, 0x60, REG_BITS_8},
	{0x90BC, 0x00, REG_BITS_8},
	{0x90BD, 0x01, REG_BITS_8},
	{0x90BE, 0x02, REG_BITS_8},
	{0x90BF, 0x05, REG_BITS_8},
	{0x90C0, 0x0a, REG_BITS_8},
	{0x90C1, 0x18, REG_BITS_8},
	{0x90C2, 0x28, REG_BITS_8},
	{0x90C3, 0x20, REG_BITS_8},
	{0x90C4, 0x80, REG_BITS_8},
	{0x90C5, 0xc0, REG_BITS_8},
	{0x90C6, 0x80, REG_BITS_8},
	{0x90C7, 0x02, REG_BITS_8},
	{0x90C8, 0x03, REG_BITS_8},
	{0x90C9, 0x0c, REG_BITS_8},
	{0x90CA, 0x0c, REG_BITS_8},
	{0x90CB, 0x30, REG_BITS_8},
	{0x90CC, 0x40, REG_BITS_8},
	{0x90CD, 0x80, REG_BITS_8},
	{0x90CE, 0x00, REG_BITS_8},
	{0x90CF, 0x01, REG_BITS_8},
	{0x90D0, 0x02, REG_BITS_8},
	{0x90D1, 0x04, REG_BITS_8},
	{0x90D2, 0x0c, REG_BITS_8},
	{0x90D3, 0x08, REG_BITS_8},
	{0x90D4, 0x30, REG_BITS_8},
	{0x90D5, 0x60, REG_BITS_8},
	{0x90D6, 0xc0, REG_BITS_8},
	{0x90D7, 0x80, REG_BITS_8},
	{0x90D8, 0x81, REG_BITS_8},
	{0x90D9, 0x03, REG_BITS_8},
	{0x90DA, 0x05, REG_BITS_8},
	{0x90DB, 0x0a, REG_BITS_8},
	{0x90DC, 0x18, REG_BITS_8},
	{0x90DD, 0x30, REG_BITS_8},
	{0x90DE, 0x60, REG_BITS_8},
	{0x90DF, 0xc0, REG_BITS_8},
	{0x90E0, 0x00, REG_BITS_8},
	{0x90E1, 0x01, REG_BITS_8},
	{0x90E2, 0x02, REG_BITS_8},
	{0x90E3, 0x04, REG_BITS_8},
	{0x90E4, 0x08, REG_BITS_8},
	{0x90E5, 0x10, REG_BITS_8},
	{0x90E6, 0x30, REG_BITS_8},
	{0x90E7, 0x20, REG_BITS_8},
	{0x90E8, 0xc0, REG_BITS_8},
	{0x90E9, 0x80, REG_BITS_8},
	{0x90EA, 0x01, REG_BITS_8},
	{0x90EB, 0x03, REG_BITS_8},
	{0x90EC, 0x06, REG_BITS_8},
	{0x90ED, 0x0e, REG_BITS_8},
	{0x90EE, 0x14, REG_BITS_8},
	{0x90EF, 0x28, REG_BITS_8},
	{0x90F0, 0x60, REG_BITS_8},
	{0x90F1, 0xc0, REG_BITS_8},
	{0x90F2, 0x80, REG_BITS_8},
	{0x90F3, 0x01, REG_BITS_8},
	{0x90F4, 0x03, REG_BITS_8},
	{0x90F5, 0x02, REG_BITS_8},
	{0x90F6, 0xe8, REG_BITS_8},
	{0x90F7, 0x0b, REG_BITS_8},
	{0x90F8, 0xa0, REG_BITS_8},
	{0x90F9, 0x4f, REG_BITS_8},
	{0x90FA, 0x60, REG_BITS_8},
	{0x90FB, 0x3e, REG_BITS_8},
	{0x90FC, 0x80, REG_BITS_8},
	{0x90FD, 0xfa, REG_BITS_8},
	{0x90FE, 0x00, REG_BITS_8},
	{0x90FF, 0xec, REG_BITS_8},
	{0x9100, 0x07, REG_BITS_8},
	{0x9101, 0xc0, REG_BITS_8},
	{0x9102, 0x0f, REG_BITS_8},
	{0x9103, 0x80, REG_BITS_8},
	{0x9104, 0x7e, REG_BITS_8},
	{0x9105, 0x00, REG_BITS_8},
	{0x9106, 0xfd, REG_BITS_8},
	{0x9107, 0x01, REG_BITS_8},
	{0x9108, 0xf4, REG_BITS_8},
	{0x9109, 0x0b, REG_BITS_8},
	{0x910A, 0xa0, REG_BITS_8},
	{0x910B, 0x2f, REG_BITS_8},
	{0x910C, 0x80, REG_BITS_8},
	{0x910D, 0x3e, REG_BITS_8},
	{0x910E, 0x81, REG_BITS_8},
	{0x910F, 0xf9, REG_BITS_8},
	{0x9110, 0x00, REG_BITS_8},
	{0x9111, 0xea, REG_BITS_8},
	{0x9112, 0x03, REG_BITS_8},
	{0x9113, 0xb0, REG_BITS_8},
	{0x9114, 0x1f, REG_BITS_8},
	{0x9115, 0x00, REG_BITS_8},
	{0x9116, 0x3f, REG_BITS_8},
	{0x9117, 0x00, REG_BITS_8},
	{0x9118, 0xfa, REG_BITS_8},
	{0x9119, 0x01, REG_BITS_8},
	{0x911A, 0xf4, REG_BITS_8},
	{0x911B, 0x07, REG_BITS_8},
	{0x911C, 0xd0, REG_BITS_8},
	{0x911D, 0x2f, REG_BITS_8},
	{0x911E, 0x80, REG_BITS_8},
	{0x911F, 0xbe, REG_BITS_8},
	{0x9120, 0x00, REG_BITS_8},
	{0x9121, 0xfa, REG_BITS_8},
	{0x9122, 0x02, REG_BITS_8},
	{0x9123, 0xec, REG_BITS_8},
	{0x9124, 0x0b, REG_BITS_8},
	{0x9125, 0x98, REG_BITS_8},
	{0x9126, 0x0f, REG_BITS_8},
	{0x9127, 0x00, REG_BITS_8},
	{0x9128, 0x7f, REG_BITS_8},
	{0x9129, 0x80, REG_BITS_8},
	{0x912A, 0xfa, REG_BITS_8},
	{0x912B, 0x01, REG_BITS_8},
	{0x912C, 0xec, REG_BITS_8},
	{0x912D, 0x03, REG_BITS_8},
	{0x912E, 0xa8, REG_BITS_8},
	{0x912F, 0x0f, REG_BITS_8},
	{0x9130, 0xa0, REG_BITS_8},
	{0x9131, 0x3e, REG_BITS_8},
	{0x9132, 0x01, REG_BITS_8},
	{0x9133, 0xfb, REG_BITS_8},
	{0x9134, 0x04, REG_BITS_8},
	{0x9135, 0xec, REG_BITS_8},
	{0x9136, 0x07, REG_BITS_8},
	{0x9137, 0xb8, REG_BITS_8},
	{0x9138, 0x1f, REG_BITS_8},
	{0x9139, 0x40, REG_BITS_8},
	{0x913A, 0x7f, REG_BITS_8},
	{0x913B, 0x80, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0x00, REG_BITS_8},
	{0x913E, 0xf4, REG_BITS_8},
	{0x913F, 0x07, REG_BITS_8},
	{0x9140, 0xc8, REG_BITS_8},
	{0x9141, 0xff, REG_BITS_8},
	{0x9142, 0x3f, REG_BITS_8},
	{0x9143, 0xff, REG_BITS_8},
	{0x9144, 0xff, REG_BITS_8},
	{0x9145, 0xfc, REG_BITS_8},
	{0x9146, 0x02, REG_BITS_8},
	{0x9147, 0xf2, REG_BITS_8},
	{0x9148, 0x0b, REG_BITS_8},
	{0x9149, 0xc8, REG_BITS_8},
	{0x914A, 0x3f, REG_BITS_8},
	{0x914B, 0x40, REG_BITS_8},
	{0x914C, 0x3f, REG_BITS_8},
	{0x914D, 0x80, REG_BITS_8},
	{0x914E, 0xfd, REG_BITS_8},
	{0x914F, 0x00, REG_BITS_8},
	{0x9150, 0xf2, REG_BITS_8},
	{0x9151, 0xfb, REG_BITS_8},
	{0x9152, 0xd7, REG_BITS_8},
	{0x9153, 0xff, REG_BITS_8},
	{0x9154, 0x7f, REG_BITS_8},
	{0x9155, 0x7f, REG_BITS_8},
	{0x9156, 0x80, REG_BITS_8},
	{0x9157, 0xfd, REG_BITS_8},
	{0x9158, 0x01, REG_BITS_8},
	{0x9159, 0xf6, REG_BITS_8},
	{0x915A, 0x17, REG_BITS_8},
	{0x915B, 0xd8, REG_BITS_8},
	{0x915C, 0x5f, REG_BITS_8},
	{0x915D, 0x60, REG_BITS_8},
	{0x915E, 0xbf, REG_BITS_8},
	{0x915F, 0x00, REG_BITS_8},
	{0x9160, 0xfd, REG_BITS_8},
	{0x9161, 0x01, REG_BITS_8},
	{0x9162, 0xf6, REG_BITS_8},
	{0x9163, 0xff, REG_BITS_8},
	{0x9164, 0xe7, REG_BITS_8},
	{0x9165, 0x0f, REG_BITS_8},
	{0x9166, 0x80, REG_BITS_8},
	{0x9167, 0xbf, REG_BITS_8},
	{0x9168, 0x80, REG_BITS_8},
	{0x9169, 0xfd, REG_BITS_8},
	{0x916A, 0x02, REG_BITS_8},
	{0x916B, 0xfc, REG_BITS_8},
	{0x916C, 0x0b, REG_BITS_8},
	{0x916D, 0xf0, REG_BITS_8},
	{0x916E, 0x5f, REG_BITS_8},
	{0x916F, 0xc0, REG_BITS_8},
	{0x9170, 0x7f, REG_BITS_8},
	{0x9171, 0x01, REG_BITS_8},
	{0x9172, 0xff, REG_BITS_8},
	{0x9173, 0x04, REG_BITS_8},
	{0x9174, 0xfe, REG_BITS_8},
	{0x9175, 0x0b, REG_BITS_8},
	{0x9176, 0xf0, REG_BITS_8},
	{0x9177, 0x0f, REG_BITS_8},
	{0x9178, 0xe0, REG_BITS_8},
	{0x9179, 0xff, REG_BITS_8},
	{0x917A, 0x00, REG_BITS_8},
	{0x917B, 0xff, REG_BITS_8},
	{0x917C, 0x01, REG_BITS_8},
	{0x917D, 0xfe, REG_BITS_8},
	{0x917E, 0x0f, REG_BITS_8},
	{0x917F, 0xf8, REG_BITS_8},
	{0x9180, 0x3f, REG_BITS_8},
	{0x9181, 0xe0, REG_BITS_8},
	{0x9182, 0xbf, REG_BITS_8},
	{0x9183, 0x01, REG_BITS_8},
	{0x9184, 0x01, REG_BITS_8},
	{0x9185, 0x06, REG_BITS_8},
	{0x9186, 0x04, REG_BITS_8},
	{0x9187, 0x14, REG_BITS_8},
	{0x9188, 0x08, REG_BITS_8},
	{0x9189, 0x50, REG_BITS_8},
	{0x918A, 0x20, REG_BITS_8},
	{0x918B, 0xc0, REG_BITS_8},
	{0x918C, 0x00, REG_BITS_8},
	{0x918D, 0x01, REG_BITS_8},
	{0x918E, 0x03, REG_BITS_8},
	{0x918F, 0x02, REG_BITS_8},
	{0x9190, 0x10, REG_BITS_8},
	{0x9191, 0x20, REG_BITS_8},
	{0x9192, 0x40, REG_BITS_8},
	{0x9193, 0x40, REG_BITS_8},
	{0x9194, 0x00, REG_BITS_8},
	{0x9195, 0x01, REG_BITS_8},
	{0x9196, 0x01, REG_BITS_8},
	{0x9197, 0x06, REG_BITS_8},
	{0x9198, 0x06, REG_BITS_8},
	{0x9199, 0x18, REG_BITS_8},
	{0x919A, 0x18, REG_BITS_8},
	{0x919B, 0x60, REG_BITS_8},
	{0x919C, 0xa0, REG_BITS_8},
	{0x919D, 0x00, REG_BITS_8},
	{0x919E, 0x81, REG_BITS_8},
	{0x919F, 0x02, REG_BITS_8},
	{0x91A0, 0x04, REG_BITS_8},
	{0x91A1, 0x0a, REG_BITS_8},
	{0x91A2, 0x14, REG_BITS_8},
	{0x91A3, 0x28, REG_BITS_8},
	{0x91A4, 0x50, REG_BITS_8},
	{0x91A5, 0xa0, REG_BITS_8},
	{0x91A6, 0x00, REG_BITS_8},
	{0x91A7, 0x81, REG_BITS_8},
	{0x91A8, 0x03, REG_BITS_8},
	{0x91A9, 0x04, REG_BITS_8},
	{0x91AA, 0x0e, REG_BITS_8},
	{0x91AB, 0x1c, REG_BITS_8},
	{0x91AC, 0x30, REG_BITS_8},
	{0x91AD, 0x70, REG_BITS_8},
	{0x91AE, 0xc0, REG_BITS_8},
	{0x91AF, 0xc0, REG_BITS_8},
	{0x91B0, 0x01, REG_BITS_8},
	{0x91B1, 0x03, REG_BITS_8},
	{0x91B2, 0x05, REG_BITS_8},
	{0x91B3, 0x0e, REG_BITS_8},
	{0x91B4, 0x10, REG_BITS_8},
	{0x91B5, 0x50, REG_BITS_8},
	{0x91B6, 0x50, REG_BITS_8},
	{0x91B7, 0xe0, REG_BITS_8},
	{0x91B8, 0x40, REG_BITS_8},
	{0x91B9, 0x81, REG_BITS_8},
	{0x91BA, 0x02, REG_BITS_8},
	{0x91BB, 0x05, REG_BITS_8},
	{0x91BC, 0x0a, REG_BITS_8},
	{0x91BD, 0x14, REG_BITS_8},
	{0x91BE, 0x28, REG_BITS_8},
	{0x91BF, 0x80, REG_BITS_8},
	{0x91C0, 0xa0, REG_BITS_8},
	{0x91C1, 0x00, REG_BITS_8},
	{0x91C2, 0x82, REG_BITS_8},
	{0x91C3, 0x02, REG_BITS_8},
	{0x91C4, 0x06, REG_BITS_8},
	{0x91C5, 0x0e, REG_BITS_8},
	{0x91C6, 0x14, REG_BITS_8},
	{0x91C7, 0x48, REG_BITS_8},
	{0x91C8, 0x60, REG_BITS_8},
	{0x91C9, 0xa0, REG_BITS_8},
	{0x91CA, 0x41, REG_BITS_8},
	{0x91CB, 0x81, REG_BITS_8},
	{0x91CC, 0x03, REG_BITS_8},
	{0x91CD, 0x05, REG_BITS_8},
	{0x91CE, 0x12, REG_BITS_8},
	{0x91CF, 0x10, REG_BITS_8},
	{0x91D0, 0x20, REG_BITS_8},
	{0x91D1, 0x40, REG_BITS_8},
	{0x91D2, 0x80, REG_BITS_8},
	{0x91D3, 0x00, REG_BITS_8},
	{0x91D4, 0x82, REG_BITS_8},
	{0x91D5, 0x02, REG_BITS_8},
	{0x91D6, 0x08, REG_BITS_8},
	{0x91D7, 0x0a, REG_BITS_8},
	{0x91D8, 0x18, REG_BITS_8},
	{0x91D9, 0x38, REG_BITS_8},
	{0x91DA, 0x50, REG_BITS_8},
	{0x91DB, 0x20, REG_BITS_8},
	{0x91DC, 0x81, REG_BITS_8},
	{0x91DD, 0x81, REG_BITS_8},
	{0x91DE, 0x06, REG_BITS_8},
	{0x91DF, 0x05, REG_BITS_8},
	{0x91E0, 0x0e, REG_BITS_8},
	{0x91E1, 0x14, REG_BITS_8},
	{0x91E2, 0x48, REG_BITS_8},
	{0x91E3, 0x40, REG_BITS_8},
	{0x91E4, 0x80, REG_BITS_8},
	{0x91E5, 0x00, REG_BITS_8},
	{0x91E6, 0x01, REG_BITS_8},
	{0x91E7, 0x02, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x76, REG_BITS_8},
	{0xA003, 0xf1, REG_BITS_8},
	{0xA004, 0x0d, REG_BITS_8},
	{0xA005, 0x62, REG_BITS_8},
	{0xA006, 0xaa, REG_BITS_8},
	{0xA007, 0x63, REG_BITS_8},
	{0xA008, 0x18, REG_BITS_8},
	{0xA009, 0xec, REG_BITS_8},
	{0xA00A, 0xe4, REG_BITS_8},
	{0xA00B, 0xe5, REG_BITS_8},
	{0xA00C, 0x38, REG_BITS_8},
	{0xA00D, 0x74, REG_BITS_8},
	{0xA00E, 0x29, REG_BITS_8},
	{0xA00F, 0x4e, REG_BITS_8},
	{0xA010, 0x5e, REG_BITS_8},
	{0xA011, 0x98, REG_BITS_8},
	{0xA012, 0x83, REG_BITS_8},
	{0xA013, 0x98, REG_BITS_8},
	{0xA014, 0xef, REG_BITS_8},
	{0xA015, 0x50, REG_BITS_8},
	{0xA016, 0x26, REG_BITS_8},
	{0xA017, 0x3d, REG_BITS_8},
	{0xA018, 0x8e, REG_BITS_8},
	{0xA019, 0x01, REG_BITS_8},
	{0xA01A, 0xcf, REG_BITS_8},
	{0xA01B, 0x64, REG_BITS_8},
	{0xA01C, 0xc4, REG_BITS_8},
	{0xA01D, 0x53, REG_BITS_8},
	{0xA01E, 0x19, REG_BITS_8},
	{0xA01F, 0xf2, REG_BITS_8},
	{0xA020, 0x10, REG_BITS_8},
	{0xA021, 0x66, REG_BITS_8},
	{0xA022, 0x3a, REG_BITS_8},
	{0xA023, 0x76, REG_BITS_8},
	{0xA024, 0xe9, REG_BITS_8},
	{0xA025, 0x0d, REG_BITS_8},
	{0xA026, 0x5c, REG_BITS_8},
	{0xA027, 0x70, REG_BITS_8},
	{0xA028, 0x63, REG_BITS_8},
	{0xA029, 0x97, REG_BITS_8},
	{0xA02A, 0xe0, REG_BITS_8},
	{0xA02B, 0x1c, REG_BITS_8},
	{0xA02C, 0x46, REG_BITS_8},
	{0xA02D, 0x3b, REG_BITS_8},
	{0xA02E, 0x9e, REG_BITS_8},
	{0xA02F, 0xa1, REG_BITS_8},
	{0xA030, 0xcf, REG_BITS_8},
	{0xA031, 0x67, REG_BITS_8},
	{0xA032, 0xee, REG_BITS_8},
	{0xA033, 0xd3, REG_BITS_8},
	{0xA034, 0x97, REG_BITS_8},
	{0xA035, 0xe2, REG_BITS_8},
	{0xA036, 0xd0, REG_BITS_8},
	{0xA037, 0xc5, REG_BITS_8},
	{0xA038, 0x36, REG_BITS_8},
	{0xA039, 0x57, REG_BITS_8},
	{0xA03A, 0x89, REG_BITS_8},
	{0xA03B, 0x4c, REG_BITS_8},
	{0xA03C, 0x52, REG_BITS_8},
	{0xA03D, 0xf4, REG_BITS_8},
	{0xA03E, 0x62, REG_BITS_8},
	{0xA03F, 0x94, REG_BITS_8},
	{0xA040, 0xb9, REG_BITS_8},
	{0xA041, 0x2c, REG_BITS_8},
	{0xA042, 0x85, REG_BITS_8},
	{0xA043, 0x2f, REG_BITS_8},
	{0xA044, 0x5b, REG_BITS_8},
	{0xA045, 0xb9, REG_BITS_8},
	{0xA046, 0xcc, REG_BITS_8},
	{0xA047, 0x5e, REG_BITS_8},
	{0xA048, 0x88, REG_BITS_8},
	{0xA049, 0x33, REG_BITS_8},
	{0xA04A, 0x18, REG_BITS_8},
	{0xA04B, 0xe9, REG_BITS_8},
	{0xA04C, 0x88, REG_BITS_8},
	{0xA04D, 0x85, REG_BITS_8},
	{0xA04E, 0x33, REG_BITS_8},
	{0xA04F, 0x53, REG_BITS_8},
	{0xA050, 0x21, REG_BITS_8},
	{0xA051, 0xcc, REG_BITS_8},
	{0xA052, 0x4e, REG_BITS_8},
	{0xA053, 0xc0, REG_BITS_8},
	{0xA054, 0xc2, REG_BITS_8},
	{0xA055, 0x92, REG_BITS_8},
	{0xA056, 0xa3, REG_BITS_8},
	{0xA057, 0x9c, REG_BITS_8},
	{0xA058, 0xe4, REG_BITS_8},
	{0xA059, 0x27, REG_BITS_8},
	{0xA05A, 0x2f, REG_BITS_8},
	{0xA05B, 0x59, REG_BITS_8},
	{0xA05C, 0x4a, REG_BITS_8},
	{0xA05D, 0x50, REG_BITS_8},
	{0xA05E, 0xd2, REG_BITS_8},
	{0xA05F, 0xb2, REG_BITS_8},
	{0xA060, 0x15, REG_BITS_8},
	{0xA061, 0xca, REG_BITS_8},
	{0xA062, 0xa4, REG_BITS_8},
	{0xA063, 0xa5, REG_BITS_8},
	{0xA064, 0x35, REG_BITS_8},
	{0xA065, 0x52, REG_BITS_8},
	{0xA066, 0x09, REG_BITS_8},
	{0xA067, 0x8c, REG_BITS_8},
	{0xA068, 0x50, REG_BITS_8},
	{0xA069, 0xd0, REG_BITS_8},
	{0xA06A, 0x62, REG_BITS_8},
	{0xA06B, 0x92, REG_BITS_8},
	{0xA06C, 0x9e, REG_BITS_8},
	{0xA06D, 0x40, REG_BITS_8},
	{0xA06E, 0x84, REG_BITS_8},
	{0xA06F, 0x23, REG_BITS_8},
	{0xA070, 0x0a, REG_BITS_8},
	{0xA071, 0x99, REG_BITS_8},
	{0xA072, 0xc8, REG_BITS_8},
	{0xA073, 0x44, REG_BITS_8},
	{0xA074, 0x40, REG_BITS_8},
	{0xA075, 0xd2, REG_BITS_8},
	{0xA076, 0x12, REG_BITS_8},
	{0xA077, 0xa3, REG_BITS_8},
	{0xA078, 0x28, REG_BITS_8},
	{0xA079, 0xc5, REG_BITS_8},
	{0xA07A, 0x2e, REG_BITS_8},
	{0xA07B, 0x56, REG_BITS_8},
	{0xA07C, 0x79, REG_BITS_8},
	{0xA07D, 0x8c, REG_BITS_8},
	{0xA07E, 0x51, REG_BITS_8},
	{0xA07F, 0xe4, REG_BITS_8},
	{0xA080, 0xa2, REG_BITS_8},
	{0xA081, 0x93, REG_BITS_8},
	{0xA082, 0xad, REG_BITS_8},
	{0xA083, 0x6c, REG_BITS_8},
	{0xA084, 0x44, REG_BITS_8},
	{0xA085, 0x25, REG_BITS_8},
	{0xA086, 0x03, REG_BITS_8},
	{0xA087, 0x39, REG_BITS_8},
	{0xA088, 0x88, REG_BITS_8},
	{0xA089, 0x3f, REG_BITS_8},
	{0xA08A, 0xfe, REG_BITS_8},
	{0xA08B, 0x71, REG_BITS_8},
	{0xA08C, 0x10, REG_BITS_8},
	{0xA08D, 0x86, REG_BITS_8},
	{0xA08E, 0x88, REG_BITS_8},
	{0xA08F, 0x84, REG_BITS_8},
	{0xA090, 0x26, REG_BITS_8},
	{0xA091, 0x42, REG_BITS_8},
	{0xA092, 0x49, REG_BITS_8},
	{0xA093, 0xcb, REG_BITS_8},
	{0xA094, 0x52, REG_BITS_8},
	{0xA095, 0xfe, REG_BITS_8},
	{0xA096, 0x92, REG_BITS_8},
	{0xA097, 0x94, REG_BITS_8},
	{0xA098, 0xb9, REG_BITS_8},
	{0xA099, 0xf4, REG_BITS_8},
	{0xA09A, 0x84, REG_BITS_8},
	{0xA09B, 0x2b, REG_BITS_8},
	{0xA09C, 0x1e, REG_BITS_8},
	{0xA09D, 0x61, REG_BITS_8},
	{0xA09E, 0x89, REG_BITS_8},
	{0xA09F, 0x41, REG_BITS_8},
	{0xA0A0, 0x12, REG_BITS_8},
	{0xA0A1, 0x12, REG_BITS_8},
	{0xA0A2, 0x10, REG_BITS_8},
	{0xA0A3, 0x80, REG_BITS_8},
	{0xA0A4, 0x28, REG_BITS_8},
	{0xA0A5, 0xa4, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x25, REG_BITS_8},
	{0xA0A8, 0xa9, REG_BITS_8},
	{0xA0A9, 0x49, REG_BITS_8},
	{0xA0AA, 0x51, REG_BITS_8},
	{0xA0AB, 0xd0, REG_BITS_8},
	{0xA0AC, 0xf2, REG_BITS_8},
	{0xA0AD, 0x94, REG_BITS_8},
	{0xA0AE, 0xbf, REG_BITS_8},
	{0xA0AF, 0x5c, REG_BITS_8},
	{0xA0B0, 0xc5, REG_BITS_8},
	{0xA0B1, 0x30, REG_BITS_8},
	{0xA0B2, 0x48, REG_BITS_8},
	{0xA0B3, 0x69, REG_BITS_8},
	{0xA0B4, 0x8b, REG_BITS_8},
	{0xA0B5, 0x4b, REG_BITS_8},
	{0xA0B6, 0x82, REG_BITS_8},
	{0xA0B7, 0x82, REG_BITS_8},
	{0xA0B8, 0x11, REG_BITS_8},
	{0xA0B9, 0x90, REG_BITS_8},
	{0xA0BA, 0x4c, REG_BITS_8},
	{0xA0BB, 0xe4, REG_BITS_8},
	{0xA0BC, 0x22, REG_BITS_8},
	{0xA0BD, 0x1c, REG_BITS_8},
	{0xA0BE, 0x21, REG_BITS_8},
	{0xA0BF, 0x49, REG_BITS_8},
	{0xA0C0, 0x4d, REG_BITS_8},
	{0xA0C1, 0x94, REG_BITS_8},
	{0xA0C2, 0x32, REG_BITS_8},
	{0xA0C3, 0x15, REG_BITS_8},
	{0xA0C4, 0xbc, REG_BITS_8},
	{0xA0C5, 0x80, REG_BITS_8},
	{0xA0C6, 0x25, REG_BITS_8},
	{0xA0C7, 0x32, REG_BITS_8},
	{0xA0C8, 0x6c, REG_BITS_8},
	{0xA0C9, 0x39, REG_BITS_8},
	{0xA0CA, 0x4d, REG_BITS_8},
	{0xA0CB, 0x57, REG_BITS_8},
	{0xA0CC, 0x1c, REG_BITS_8},
	{0xA0CD, 0x53, REG_BITS_8},
	{0xA0CE, 0x94, REG_BITS_8},
	{0xA0CF, 0xb3, REG_BITS_8},
	{0xA0D0, 0xdc, REG_BITS_8},
	{0xA0D1, 0xe4, REG_BITS_8},
	{0xA0D2, 0x29, REG_BITS_8},
	{0xA0D3, 0x34, REG_BITS_8},
	{0xA0D4, 0x41, REG_BITS_8},
	{0xA0D5, 0xca, REG_BITS_8},
	{0xA0D6, 0x4e, REG_BITS_8},
	{0xA0D7, 0xa2, REG_BITS_8},
	{0xA0D8, 0xc2, REG_BITS_8},
	{0xA0D9, 0x94, REG_BITS_8},
	{0xA0DA, 0xb7, REG_BITS_8},
	{0xA0DB, 0xa0, REG_BITS_8},
	{0xA0DC, 0x25, REG_BITS_8},
	{0xA0DD, 0x33, REG_BITS_8},
	{0xA0DE, 0x76, REG_BITS_8},
	{0xA0DF, 0x99, REG_BITS_8},
	{0xA0E0, 0x4d, REG_BITS_8},
	{0xA0E1, 0x62, REG_BITS_8},
	{0xA0E2, 0x96, REG_BITS_8},
	{0xA0E3, 0x13, REG_BITS_8},
	{0xA0E4, 0x98, REG_BITS_8},
	{0xA0E5, 0xde, REG_BITS_8},
	{0xA0E6, 0x8c, REG_BITS_8},
	{0xA0E7, 0xc5, REG_BITS_8},
	{0xA0E8, 0x32, REG_BITS_8},
	{0xA0E9, 0x57, REG_BITS_8},
	{0xA0EA, 0x19, REG_BITS_8},
	{0xA0EB, 0x0c, REG_BITS_8},
	{0xA0EC, 0x55, REG_BITS_8},
	{0xA0ED, 0xfc, REG_BITS_8},
	{0xA0EE, 0x92, REG_BITS_8},
	{0xA0EF, 0x95, REG_BITS_8},
	{0xA0F0, 0xc2, REG_BITS_8},
	{0xA0F1, 0xa8, REG_BITS_8},
	{0xA0F2, 0xc5, REG_BITS_8},
	{0xA0F3, 0x33, REG_BITS_8},
	{0xA0F4, 0x8d, REG_BITS_8},
	{0xA0F5, 0x81, REG_BITS_8},
	{0xA0F6, 0x4e, REG_BITS_8},
	{0xA0F7, 0x65, REG_BITS_8},
	{0xA0F8, 0xbe, REG_BITS_8},
	{0xA0F9, 0x33, REG_BITS_8},
	{0xA0FA, 0x1a, REG_BITS_8},
	{0xA0FB, 0xf6, REG_BITS_8},
	{0xA0FC, 0x94, REG_BITS_8},
	{0xA0FD, 0xa6, REG_BITS_8},
	{0xA0FE, 0x3d, REG_BITS_8},
	{0xA0FF, 0x92, REG_BITS_8},
	{0xA100, 0xc9, REG_BITS_8},
	{0xA101, 0xce, REG_BITS_8},
	{0xA102, 0x60, REG_BITS_8},
	{0xA103, 0x8e, REG_BITS_8},
	{0xA104, 0x13, REG_BITS_8},
	{0xA105, 0x18, REG_BITS_8},
	{0xA106, 0xe1, REG_BITS_8},
	{0xA107, 0x24, REG_BITS_8},
	{0xA108, 0x86, REG_BITS_8},
	{0xA109, 0x39, REG_BITS_8},
	{0xA10A, 0x9a, REG_BITS_8},
	{0xA10B, 0xf9, REG_BITS_8},
	{0xA10C, 0x8e, REG_BITS_8},
	{0xA10D, 0x6c, REG_BITS_8},
	{0xA10E, 0xfe, REG_BITS_8},
	{0xA10F, 0xe3, REG_BITS_8},
	{0xA110, 0x9a, REG_BITS_8},
	{0xA111, 0xff, REG_BITS_8},
	{0xA112, 0x08, REG_BITS_8},
	{0xA113, 0xa6, REG_BITS_8},
	{0xA114, 0x38, REG_BITS_8},
	{0xA115, 0x97, REG_BITS_8},
	{0xA116, 0xf1, REG_BITS_8},
	{0xA117, 0x0e, REG_BITS_8},
	{0xA118, 0x65, REG_BITS_8},
	{0xA119, 0xbe, REG_BITS_8},
	{0xA11A, 0x53, REG_BITS_8},
	{0xA11B, 0x18, REG_BITS_8},
	{0xA11C, 0xe8, REG_BITS_8},
	{0xA11D, 0x14, REG_BITS_8},
	{0xA11E, 0x86, REG_BITS_8},
	{0xA11F, 0x39, REG_BITS_8},
	{0xA120, 0x8c, REG_BITS_8},
	{0xA121, 0x99, REG_BITS_8},
	{0xA122, 0x0e, REG_BITS_8},
	{0xA123, 0x67, REG_BITS_8},
	{0xA124, 0xc4, REG_BITS_8},
	{0xA125, 0x43, REG_BITS_8},
	{0xA126, 0x9a, REG_BITS_8},
	{0xA127, 0xf6, REG_BITS_8},
	{0xA128, 0x44, REG_BITS_8},
	{0xA129, 0x06, REG_BITS_8},
	{0xA12A, 0x3b, REG_BITS_8},
	{0xA12B, 0x62, REG_BITS_8},
	{0xA12C, 0xb9, REG_BITS_8},
	{0xA12D, 0x0b, REG_BITS_8},
	{0xA12E, 0x5d, REG_BITS_8},
	{0xA12F, 0x0e, REG_BITS_8},
	{0xA130, 0x73, REG_BITS_8},
	{0xA131, 0x17, REG_BITS_8},
	{0xA132, 0xc3, REG_BITS_8},
	{0xA133, 0xa4, REG_BITS_8},
	{0xA134, 0x25, REG_BITS_8},
	{0xA135, 0x2f, REG_BITS_8},
	{0xA136, 0x68, REG_BITS_8},
	{0xA137, 0xb9, REG_BITS_8},
	{0xA138, 0x4b, REG_BITS_8},
	{0xA139, 0x5c, REG_BITS_8},
	{0xA13A, 0xfc, REG_BITS_8},
	{0xA13B, 0xe2, REG_BITS_8},
	{0xA13C, 0x97, REG_BITS_8},
	{0xA13D, 0xc6, REG_BITS_8},
	{0xA13E, 0x20, REG_BITS_8},
	{0xA13F, 0x26, REG_BITS_8},
	{0xA140, 0x33, REG_BITS_8},
	{0xA141, 0x81, REG_BITS_8},
	{0xA142, 0x99, REG_BITS_8},
	{0xA143, 0x4c, REG_BITS_8},
	{0xA144, 0x5f, REG_BITS_8},
	{0xA145, 0x26, REG_BITS_8},
	{0xA146, 0x13, REG_BITS_8},
	{0xA147, 0x18, REG_BITS_8},
	{0xA148, 0xcb, REG_BITS_8},
	{0xA149, 0xd0, REG_BITS_8},
	{0xA14A, 0x85, REG_BITS_8},
	{0xA14B, 0x30, REG_BITS_8},
	{0xA14C, 0x67, REG_BITS_8},
	{0xA14D, 0xb9, REG_BITS_8},
	{0xA14E, 0x0b, REG_BITS_8},
	{0xA14F, 0x59, REG_BITS_8},
	{0xA150, 0xe8, REG_BITS_8},
	{0xA151, 0xe2, REG_BITS_8},
	{0xA152, 0x96, REG_BITS_8},
	{0xA153, 0xbd, REG_BITS_8},
	{0xA154, 0xf4, REG_BITS_8},
	{0xA155, 0x85, REG_BITS_8},
	{0xA156, 0x31, REG_BITS_8},
	{0xA157, 0x92, REG_BITS_8},
	{0xA158, 0x19, REG_BITS_8},
	{0xA159, 0x4d, REG_BITS_8},
	{0xA15A, 0x64, REG_BITS_8},
	{0xA15B, 0x46, REG_BITS_8},
	{0xA15C, 0x73, REG_BITS_8},
	{0xA15D, 0x16, REG_BITS_8},
	{0xA15E, 0xbe, REG_BITS_8},
	{0xA15F, 0x84, REG_BITS_8},
	{0xA160, 0x85, REG_BITS_8},
	{0xA161, 0x2e, REG_BITS_8},
	{0xA162, 0x4a, REG_BITS_8},
	{0xA163, 0xc9, REG_BITS_8},
	{0xA164, 0x0a, REG_BITS_8},
	{0xA165, 0x50, REG_BITS_8},
	{0xA166, 0x96, REG_BITS_8},
	{0xA167, 0x02, REG_BITS_8},
	{0xA168, 0x14, REG_BITS_8},
	{0xA169, 0xa4, REG_BITS_8},
	{0xA16A, 0x18, REG_BITS_8},
	{0xA16B, 0xe5, REG_BITS_8},
	{0xA16C, 0x29, REG_BITS_8},
	{0xA16D, 0x54, REG_BITS_8},
	{0xA16E, 0xf9, REG_BITS_8},
	{0xA16F, 0x4a, REG_BITS_8},
	{0xA170, 0x5c, REG_BITS_8},
	{0xA171, 0xfe, REG_BITS_8},
	{0xA172, 0x82, REG_BITS_8},
	{0xA173, 0x17, REG_BITS_8},
	{0xA174, 0xc3, REG_BITS_8},
	{0xA175, 0x38, REG_BITS_8},
	{0xA176, 0x25, REG_BITS_8},
	{0xA177, 0x2c, REG_BITS_8},
	{0xA178, 0x44, REG_BITS_8},
	{0xA179, 0x99, REG_BITS_8},
	{0xA17A, 0x8a, REG_BITS_8},
	{0xA17B, 0x4c, REG_BITS_8},
	{0xA17C, 0x7a, REG_BITS_8},
	{0xA17D, 0x72, REG_BITS_8},
	{0xA17E, 0x92, REG_BITS_8},
	{0xA17F, 0x97, REG_BITS_8},
	{0xA180, 0x94, REG_BITS_8},
	{0xA181, 0x44, REG_BITS_8},
	{0xA182, 0x25, REG_BITS_8},
	{0xA183, 0x2e, REG_BITS_8},
	{0xA184, 0x99, REG_BITS_8},
	{0xA185, 0x49, REG_BITS_8},
	{0xA186, 0x4f, REG_BITS_8},
	{0xA187, 0x8a, REG_BITS_8},
	{0xA188, 0x12, REG_BITS_8},
	{0xA189, 0x95, REG_BITS_8},
	{0xA18A, 0xae, REG_BITS_8},
	{0xA18B, 0x6c, REG_BITS_8},
	{0xA18C, 0x45, REG_BITS_8},
	{0xA18D, 0x2d, REG_BITS_8},
	{0xA18E, 0x3d, REG_BITS_8},
	{0xA18F, 0x79, REG_BITS_8},
	{0xA190, 0x0a, REG_BITS_8},
	{0xA191, 0x4d, REG_BITS_8},
	{0xA192, 0x84, REG_BITS_8},
	{0xA193, 0x02, REG_BITS_8},
	{0xA194, 0x92, REG_BITS_8},
	{0xA195, 0x94, REG_BITS_8},
	{0xA196, 0x34, REG_BITS_8},
	{0xA197, 0x64, REG_BITS_8},
	{0xA198, 0x22, REG_BITS_8},
	{0xA199, 0x0a, REG_BITS_8},
	{0xA19A, 0x61, REG_BITS_8},
	{0xA19B, 0xc8, REG_BITS_8},
	{0xA19C, 0x44, REG_BITS_8},
	{0xA19D, 0x2c, REG_BITS_8},
	{0xA19E, 0xb2, REG_BITS_8},
	{0xA19F, 0x12, REG_BITS_8},
	{0xA1A0, 0x98, REG_BITS_8},
	{0xA1A1, 0x10, REG_BITS_8},
	{0xA1A2, 0x85, REG_BITS_8},
	{0xA1A3, 0x29, REG_BITS_8},
	{0xA1A4, 0x4c, REG_BITS_8},
	{0xA1A5, 0xc1, REG_BITS_8},
	{0xA1A6, 0x4a, REG_BITS_8},
	{0xA1A7, 0x4d, REG_BITS_8},
	{0xA1A8, 0x86, REG_BITS_8},
	{0xA1A9, 0xe2, REG_BITS_8},
	{0xA1AA, 0x12, REG_BITS_8},
	{0xA1AB, 0x9c, REG_BITS_8},
	{0xA1AC, 0x54, REG_BITS_8},
	{0xA1AD, 0x84, REG_BITS_8},
	{0xA1AE, 0x23, REG_BITS_8},
	{0xA1AF, 0x01, REG_BITS_8},
	{0xA1B0, 0x21, REG_BITS_8},
	{0xA1B1, 0xc8, REG_BITS_8},
	{0xA1B2, 0x3f, REG_BITS_8},
	{0xA1B3, 0xfe, REG_BITS_8},
	{0xA1B4, 0x91, REG_BITS_8},
	{0xA1B5, 0x10, REG_BITS_8},
	{0xA1B6, 0x84, REG_BITS_8},
	{0xA1B7, 0x88, REG_BITS_8},
	{0xA1B8, 0x64, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x3d, REG_BITS_8},
	{0xA1BB, 0x19, REG_BITS_8},
	{0xA1BC, 0x8a, REG_BITS_8},
	{0xA1BD, 0x50, REG_BITS_8},
	{0xA1BE, 0x98, REG_BITS_8},
	{0xA1BF, 0x72, REG_BITS_8},
	{0xA1C0, 0x13, REG_BITS_8},
	{0xA1C1, 0xa2, REG_BITS_8},
	{0xA1C2, 0xc0, REG_BITS_8},
	{0xA1C3, 0x44, REG_BITS_8},
	{0xA1C4, 0x27, REG_BITS_8},
	{0xA1C5, 0x17, REG_BITS_8},
	{0xA1C6, 0xe9, REG_BITS_8},
	{0xA1C7, 0xc8, REG_BITS_8},
	{0xA1C8, 0x40, REG_BITS_8},
	{0xA1C9, 0x0a, REG_BITS_8},
	{0xA1CA, 0x02, REG_BITS_8},
	{0xA1CB, 0x10, REG_BITS_8},
	{0xA1CC, 0x80, REG_BITS_8},
	{0xA1CD, 0x2c, REG_BITS_8},
	{0xA1CE, 0x24, REG_BITS_8},
	{0xA1CF, 0x21, REG_BITS_8},
	{0xA1D0, 0x23, REG_BITS_8},
	{0xA1D1, 0x21, REG_BITS_8},
	{0xA1D2, 0x49, REG_BITS_8},
	{0xA1D3, 0x4f, REG_BITS_8},
	{0xA1D4, 0x86, REG_BITS_8},
	{0xA1D5, 0x22, REG_BITS_8},
	{0xA1D6, 0x14, REG_BITS_8},
	{0xA1D7, 0xa6, REG_BITS_8},
	{0xA1D8, 0x10, REG_BITS_8},
	{0xA1D9, 0x45, REG_BITS_8},
	{0xA1DA, 0x2a, REG_BITS_8},
	{0xA1DB, 0x3b, REG_BITS_8},
	{0xA1DC, 0x29, REG_BITS_8},
	{0xA1DD, 0x8a, REG_BITS_8},
	{0xA1DE, 0x49, REG_BITS_8},
	{0xA1DF, 0x58, REG_BITS_8},
	{0xA1E0, 0x32, REG_BITS_8},
	{0xA1E1, 0x91, REG_BITS_8},
	{0xA1E2, 0x8a, REG_BITS_8},
	{0xA1E3, 0x3c, REG_BITS_8},
	{0xA1E4, 0xe4, REG_BITS_8},
	{0xA1E5, 0x21, REG_BITS_8},
	{0xA1E6, 0x19, REG_BITS_8},
	{0xA1E7, 0xc9, REG_BITS_8},
	{0xA1E8, 0x88, REG_BITS_8},
	{0xA1E9, 0x4b, REG_BITS_8},
	{0xA1EA, 0x66, REG_BITS_8},
	{0xA1EB, 0x42, REG_BITS_8},
	{0xA1EC, 0x94, REG_BITS_8},
	{0xA1ED, 0xa7, REG_BITS_8},
	{0xA1EE, 0x30, REG_BITS_8},
	{0xA1EF, 0x65, REG_BITS_8},
	{0xA1F0, 0x2b, REG_BITS_8},
	{0xA1F1, 0x58, REG_BITS_8},
	{0xA1F2, 0x39, REG_BITS_8},
	{0xA1F3, 0x4b, REG_BITS_8},
	{0xA1F4, 0x53, REG_BITS_8},
	{0xA1F5, 0xb2, REG_BITS_8},
	{0xA1F6, 0xb2, REG_BITS_8},
	{0xA1F7, 0x93, REG_BITS_8},
	{0xA1F8, 0xa1, REG_BITS_8},
	{0xA1F9, 0xbc, REG_BITS_8},
	{0xA1FA, 0x84, REG_BITS_8},
	{0xA1FB, 0x26, REG_BITS_8},
	{0xA1FC, 0x2b, REG_BITS_8},
	{0xA1FD, 0x81, REG_BITS_8},
	{0xA1FE, 0xc9, REG_BITS_8},
	{0xA1FF, 0x4c, REG_BITS_8},
	{0xA200, 0x70, REG_BITS_8},
	{0xA201, 0x02, REG_BITS_8},
	{0xA202, 0x14, REG_BITS_8},
	{0xA203, 0xa5, REG_BITS_8},
	{0xA204, 0x4c, REG_BITS_8},
	{0xA205, 0x85, REG_BITS_8},
	{0xA206, 0x2c, REG_BITS_8},
	{0xA207, 0x5d, REG_BITS_8},
	{0xA208, 0x91, REG_BITS_8},
	{0xA209, 0xcb, REG_BITS_8},
	{0xA20A, 0x5d, REG_BITS_8},
	{0xA20B, 0x0a, REG_BITS_8},
	{0xA20C, 0x03, REG_BITS_8},
	{0xA20D, 0x17, REG_BITS_8},
	{0xA20E, 0xbf, REG_BITS_8},
	{0xA20F, 0x5c, REG_BITS_8},
	{0xA210, 0x45, REG_BITS_8},
	{0xA211, 0x2c, REG_BITS_8},
	{0xA212, 0x4a, REG_BITS_8},
	{0xA213, 0xa9, REG_BITS_8},
	{0xA214, 0xca, REG_BITS_8},
	{0xA215, 0x51, REG_BITS_8},
	{0xA216, 0xa6, REG_BITS_8},
	{0xA217, 0xc2, REG_BITS_8},
	{0xA218, 0x14, REG_BITS_8},
	{0xA219, 0xac, REG_BITS_8},
	{0xA21A, 0x60, REG_BITS_8},
	{0xA21B, 0x25, REG_BITS_8},
	{0xA21C, 0x2d, REG_BITS_8},
	{0xA21D, 0x73, REG_BITS_8},
	{0xA21E, 0x51, REG_BITS_8},
	{0xA21F, 0x0c, REG_BITS_8},
	{0xA220, 0x5e, REG_BITS_8},
	{0xA221, 0x22, REG_BITS_8},
	{0xA222, 0x03, REG_BITS_8},
	{0xA223, 0x99, REG_BITS_8},
	{0xA224, 0xcf, REG_BITS_8},
	{0xA225, 0x4c, REG_BITS_8},
	{0xA226, 0x46, REG_BITS_8},
	{0xA227, 0x34, REG_BITS_8},
	{0xA228, 0x81, REG_BITS_8},
	{0xA229, 0x89, REG_BITS_8},
	{0xA22A, 0xcc, REG_BITS_8},
	{0xA22B, 0x5c, REG_BITS_8},
	{0xA22C, 0x08, REG_BITS_8},
	{0xA22D, 0x03, REG_BITS_8},
	{0xA22E, 0x17, REG_BITS_8},
	{0xA22F, 0xc1, REG_BITS_8},
	{0xA230, 0xd4, REG_BITS_8},
	{0xA231, 0x05, REG_BITS_8},
	{0xA232, 0x31, REG_BITS_8},
	{0xA233, 0x82, REG_BITS_8},
	{0xA234, 0xd1, REG_BITS_8},
	{0xA235, 0x8c, REG_BITS_8},
	{0xA236, 0x64, REG_BITS_8},
	{0xA237, 0x5c, REG_BITS_8},
	{0xA238, 0xc3, REG_BITS_8},
	{0xA239, 0x18, REG_BITS_8},
	{0xA23A, 0xd4, REG_BITS_8},
	{0xA23B, 0xc8, REG_BITS_8},
	{0xA23C, 0x45, REG_BITS_8},
	{0xA23D, 0x30, REG_BITS_8},
	{0xA23E, 0x86, REG_BITS_8},
	{0xA23F, 0xa1, REG_BITS_8},
	{0xA240, 0xcc, REG_BITS_8},
	{0xA241, 0x60, REG_BITS_8},
	{0xA242, 0x28, REG_BITS_8},
	{0xA243, 0x73, REG_BITS_8},
	{0xA244, 0x17, REG_BITS_8},
	{0xA245, 0xc4, REG_BITS_8},
	{0xA246, 0xd4, REG_BITS_8},
	{0xA247, 0x05, REG_BITS_8},
	{0xA248, 0x31, REG_BITS_8},
	{0xA249, 0x79, REG_BITS_8},
	{0xA24A, 0x61, REG_BITS_8},
	{0xA24B, 0x0c, REG_BITS_8},
	{0xA24C, 0x61, REG_BITS_8},
	{0xA24D, 0x3a, REG_BITS_8},
	{0xA24E, 0x63, REG_BITS_8},
	{0xA24F, 0x18, REG_BITS_8},
	{0xA250, 0xd0, REG_BITS_8},
	{0xA251, 0xc8, REG_BITS_8},
	{0xA252, 0x45, REG_BITS_8},
	{0xA253, 0x31, REG_BITS_8},
	{0xA254, 0x95, REG_BITS_8},
	{0xA255, 0x41, REG_BITS_8},
	{0xA256, 0x8d, REG_BITS_8},
	{0xA257, 0x69, REG_BITS_8},
	{0xA258, 0x2c, REG_BITS_8},
	{0xA259, 0x13, REG_BITS_8},
	{0xA25A, 0x99, REG_BITS_8},
	{0xA25B, 0xcb, REG_BITS_8},
	{0xA25C, 0xa0, REG_BITS_8},
	{0xA25D, 0x46, REG_BITS_8},
	{0xA25E, 0x36, REG_BITS_8},
	{0xA25F, 0xab, REG_BITS_8},
	{0xA260, 0xa1, REG_BITS_8},
	{0xA261, 0xcd, REG_BITS_8},
	{0xA262, 0x6d, REG_BITS_8},
	{0xA263, 0x40, REG_BITS_8},
	{0xA264, 0xd3, REG_BITS_8},
	{0xA265, 0x18, REG_BITS_8},
	{0xA266, 0xc4, REG_BITS_8},
	{0xA267, 0x38, REG_BITS_8},
	{0xA268, 0x66, REG_BITS_8},
	{0xA269, 0x34, REG_BITS_8},
	{0xA26A, 0xbc, REG_BITS_8},
	{0xA26B, 0xf1, REG_BITS_8},
	{0xA26C, 0x8d, REG_BITS_8},
	{0xA26D, 0x66, REG_BITS_8},
	{0xA26E, 0x1a, REG_BITS_8},
	{0xA26F, 0x83, REG_BITS_8},
	{0xA270, 0x16, REG_BITS_8},
	{0xA271, 0xaa, REG_BITS_8},
	{0xA272, 0x3c, REG_BITS_8},
	{0xA273, 0xc5, REG_BITS_8},
	{0xA274, 0x2a, REG_BITS_8},
	{0xA275, 0x6a, REG_BITS_8},
	{0xA276, 0x91, REG_BITS_8},
	{0xA277, 0x0c, REG_BITS_8},
	{0xA278, 0x68, REG_BITS_8},
	{0xA279, 0xf0, REG_BITS_8},
	{0xA27A, 0x32, REG_BITS_8},
	{0xA27B, 0x96, REG_BITS_8},
	{0xA27C, 0xa1, REG_BITS_8},
	{0xA27D, 0xbc, REG_BITS_8},
	{0xA27E, 0x04, REG_BITS_8},
	{0xA27F, 0x25, REG_BITS_8},
	{0xA280, 0x30, REG_BITS_8},
	{0xA281, 0x31, REG_BITS_8},
	{0xA282, 0x0a, REG_BITS_8},
	{0xA283, 0x5a, REG_BITS_8},
	{0xA284, 0xfc, REG_BITS_8},
	{0xA285, 0x12, REG_BITS_8},
	{0xA286, 0x16, REG_BITS_8},
	{0xA287, 0xa6, REG_BITS_8},
	{0xA288, 0xa8, REG_BITS_8},
	{0xA289, 0x04, REG_BITS_8},
	{0xA28A, 0x22, REG_BITS_8},
	{0xA28B, 0x09, REG_BITS_8},
	{0xA28C, 0x91, REG_BITS_8},
	{0xA28D, 0x88, REG_BITS_8},
	{0xA28E, 0x4b, REG_BITS_8},
	{0xA28F, 0xa2, REG_BITS_8},
	{0xA290, 0x82, REG_BITS_8},
	{0xA291, 0x16, REG_BITS_8},
	{0xA292, 0xaa, REG_BITS_8},
	{0xA293, 0x04, REG_BITS_8},
	{0xA294, 0xa5, REG_BITS_8},
	{0xA295, 0x23, REG_BITS_8},
	{0xA296, 0x04, REG_BITS_8},
	{0xA297, 0xf1, REG_BITS_8},
	{0xA298, 0x87, REG_BITS_8},
	{0xA299, 0x41, REG_BITS_8},
	{0xA29A, 0x46, REG_BITS_8},
	{0xA29B, 0x82, REG_BITS_8},
	{0xA29C, 0x94, REG_BITS_8},
	{0xA29D, 0xad, REG_BITS_8},
	{0xA29E, 0x58, REG_BITS_8},
	{0xA29F, 0x85, REG_BITS_8},
	{0xA2A0, 0x28, REG_BITS_8},
	{0xA2A1, 0x1f, REG_BITS_8},
	{0xA2A2, 0x31, REG_BITS_8},
	{0xA2A3, 0x48, REG_BITS_8},
	{0xA2A4, 0x40, REG_BITS_8},
	{0xA2A5, 0x14, REG_BITS_8},
	{0xA2A6, 0x62, REG_BITS_8},
	{0xA2A7, 0x92, REG_BITS_8},
	{0xA2A8, 0xa5, REG_BITS_8},
	{0xA2A9, 0x78, REG_BITS_8},
	{0xA2AA, 0x25, REG_BITS_8},
	{0xA2AB, 0x2d, REG_BITS_8},
	{0xA2AC, 0x53, REG_BITS_8},
	{0xA2AD, 0x81, REG_BITS_8},
	{0xA2AE, 0xc9, REG_BITS_8},
	{0xA2AF, 0x45, REG_BITS_8},
	{0xA2B0, 0x22, REG_BITS_8},
	{0xA2B1, 0xb2, REG_BITS_8},
	{0xA2B2, 0x91, REG_BITS_8},
	{0xA2B3, 0x9b, REG_BITS_8},
	{0xA2B4, 0x6c, REG_BITS_8},
	{0xA2B5, 0x25, REG_BITS_8},
	{0xA2B6, 0x2e, REG_BITS_8},
	{0xA2B7, 0x84, REG_BITS_8},
	{0xA2B8, 0x71, REG_BITS_8},
	{0xA2B9, 0x8b, REG_BITS_8},
	{0xA2BA, 0x53, REG_BITS_8},
	{0xA2BB, 0x74, REG_BITS_8},
	{0xA2BC, 0x52, REG_BITS_8},
	{0xA2BD, 0x93, REG_BITS_8},
	{0xA2BE, 0x9e, REG_BITS_8},
	{0xA2BF, 0x54, REG_BITS_8},
	{0xA2C0, 0x05, REG_BITS_8},
	{0xA2C1, 0x2f, REG_BITS_8},
	{0xA2C2, 0x8f, REG_BITS_8},
	{0xA2C3, 0x59, REG_BITS_8},
	{0xA2C4, 0x4d, REG_BITS_8},
	{0xA2C5, 0x67, REG_BITS_8},
	{0xA2C6, 0xec, REG_BITS_8},
	{0xA2C7, 0x42, REG_BITS_8},
	{0xA2C8, 0x16, REG_BITS_8},
	{0xA2C9, 0xaf, REG_BITS_8},
	{0xA2CA, 0x98, REG_BITS_8},
	{0xA2CB, 0x85, REG_BITS_8},
	{0xA2CC, 0x2f, REG_BITS_8},
	{0xA2CD, 0xa8, REG_BITS_8},
	{0xA2CE, 0xb1, REG_BITS_8},
	{0xA2CF, 0x0d, REG_BITS_8},
	{0xA2D0, 0x72, REG_BITS_8},
	{0xA2D1, 0x92, REG_BITS_8},
	{0xA2D2, 0x13, REG_BITS_8},
	{0xA2D3, 0x1b, REG_BITS_8},
	{0xA2D4, 0xcf, REG_BITS_8},
	{0xA2D5, 0x64, REG_BITS_8},
	{0xA2D6, 0x26, REG_BITS_8},
	{0xA2D7, 0x34, REG_BITS_8},
	{0xA2D8, 0xb7, REG_BITS_8},
	{0xA2D9, 0x99, REG_BITS_8},
	{0xA2DA, 0x0e, REG_BITS_8},
	{0xA2DB, 0x74, REG_BITS_8},
	{0xA2DC, 0x40, REG_BITS_8},
	{0xA2DD, 0x83, REG_BITS_8},
	{0xA2DE, 0x9b, REG_BITS_8},
	{0xA2DF, 0xda, REG_BITS_8},
	{0xA2E0, 0x94, REG_BITS_8},
	{0xA2E1, 0x26, REG_BITS_8},
	{0xA2E2, 0x34, REG_BITS_8},
	{0xA2E3, 0xa8, REG_BITS_8},
	{0xA2E4, 0xd1, REG_BITS_8},
	{0xA2E5, 0x4d, REG_BITS_8},
	{0xA2E6, 0x70, REG_BITS_8},
	{0xA2E7, 0x56, REG_BITS_8},
	{0xA2E8, 0x03, REG_BITS_8},
	{0xA2E9, 0x13, REG_BITS_8},
	{0xA2EA, 0xbc, REG_BITS_8},
	{0xA2EB, 0x44, REG_BITS_8},
	{0xA2EC, 0x14, REG_BITS_8},
	{0xA2ED, 0xa6, REG_BITS_8},
	{0xA2EE, 0xd2, REG_BITS_8},
	{0xA2EF, 0x41, REG_BITS_8},
	{0xA2F0, 0x0f, REG_BITS_8},
	{0xA2F1, 0x7a, REG_BITS_8},
	{0xA2F2, 0xa4, REG_BITS_8},
	{0xA2F3, 0xd3, REG_BITS_8},
	{0xA2F4, 0x9c, REG_BITS_8},
	{0xA2F5, 0xe9, REG_BITS_8},
	{0xA2F6, 0x98, REG_BITS_8},
	{0xA2F7, 0x87, REG_BITS_8},
	{0xA2F8, 0x3d, REG_BITS_8},
	{0xA2F9, 0xe3, REG_BITS_8},
	{0xA2FA, 0xb9, REG_BITS_8},
	{0xA2FB, 0x0f, REG_BITS_8},
	{0xA2FC, 0x7e, REG_BITS_8},
	{0xA2FD, 0xc0, REG_BITS_8},
	{0xA2FE, 0x73, REG_BITS_8},
	{0xA2FF, 0x9c, REG_BITS_8},
	{0xA300, 0xdf, REG_BITS_8},
	{0xA301, 0x1c, REG_BITS_8},
	{0xA302, 0xc7, REG_BITS_8},
	{0xA303, 0x3b, REG_BITS_8},
	{0xA304, 0xf7, REG_BITS_8},
	{0xA305, 0xb9, REG_BITS_8},
	{0xA306, 0x0f, REG_BITS_8},
	{0xA307, 0x76, REG_BITS_8},
	{0xA308, 0x8c, REG_BITS_8},
	{0xA309, 0x93, REG_BITS_8},
	{0xA30A, 0x99, REG_BITS_8},
	{0xA30B, 0xbe, REG_BITS_8},
	{0xA30C, 0xd0, REG_BITS_8},
	{0xA30D, 0x85, REG_BITS_8},
	{0xA30E, 0x2f, REG_BITS_8},
	{0xA30F, 0x97, REG_BITS_8},
	{0xA310, 0x21, REG_BITS_8},
	{0xA311, 0xce, REG_BITS_8},
	{0xA312, 0x74, REG_BITS_8},
	{0xA313, 0x58, REG_BITS_8},
	{0xA314, 0xf3, REG_BITS_8},
	{0xA315, 0x18, REG_BITS_8},
	{0xA316, 0xb2, REG_BITS_8},
	{0xA317, 0x1c, REG_BITS_8},
	{0xA318, 0xc5, REG_BITS_8},
	{0xA319, 0x27, REG_BITS_8},
	{0xA31A, 0x49, REG_BITS_8},
	{0xA31B, 0x31, REG_BITS_8},
	{0xA31C, 0x8b, REG_BITS_8},
	{0xA31D, 0x64, REG_BITS_8},
	{0xA31E, 0x5a, REG_BITS_8},
	{0xA31F, 0xe3, REG_BITS_8},
	{0xA320, 0x98, REG_BITS_8},
	{0xA321, 0xb7, REG_BITS_8},
	{0xA322, 0xfc, REG_BITS_8},
	{0xA323, 0x84, REG_BITS_8},
	{0xA324, 0x23, REG_BITS_8},
	{0xA325, 0x12, REG_BITS_8},
	{0xA326, 0xf1, REG_BITS_8},
	{0xA327, 0xc8, REG_BITS_8},
	{0xA328, 0x50, REG_BITS_8},
	{0xA329, 0xe8, REG_BITS_8},
	{0xA32A, 0x02, REG_BITS_8},
	{0xA32B, 0x99, REG_BITS_8},
	{0xA32C, 0xbe, REG_BITS_8},
	{0xA32D, 0x84, REG_BITS_8},
	{0xA32E, 0x85, REG_BITS_8},
	{0xA32F, 0x25, REG_BITS_8},
	{0xA330, 0x08, REG_BITS_8},
	{0xA331, 0xf9, REG_BITS_8},
	{0xA332, 0xc7, REG_BITS_8},
	{0xA333, 0x42, REG_BITS_8},
	{0xA334, 0x66, REG_BITS_8},
	{0xA335, 0x82, REG_BITS_8},
	{0xA336, 0x96, REG_BITS_8},
	{0xA337, 0xc0, REG_BITS_8},
	{0xA338, 0xfc, REG_BITS_8},
	{0xA339, 0x45, REG_BITS_8},
	{0xA33A, 0x2c, REG_BITS_8},
	{0xA33B, 0x2e, REG_BITS_8},
	{0xA33C, 0x51, REG_BITS_8},
	{0xA33D, 0x08, REG_BITS_8},
	{0xA33E, 0x40, REG_BITS_8},
	{0xA33F, 0x1a, REG_BITS_8},
	{0xA340, 0x52, REG_BITS_8},
	{0xA341, 0x13, REG_BITS_8},
	{0xA342, 0xb5, REG_BITS_8},
	{0xA343, 0x08, REG_BITS_8},
	{0xA344, 0xa6, REG_BITS_8},
	{0xA345, 0x32, REG_BITS_8},
	{0xA346, 0x76, REG_BITS_8},
	{0xA347, 0x21, REG_BITS_8},
	{0xA348, 0x4a, REG_BITS_8},
	{0xA349, 0x48, REG_BITS_8},
	{0xA34A, 0x2e, REG_BITS_8},
	{0xA34B, 0x42, REG_BITS_8},
	{0xA34C, 0x12, REG_BITS_8},
	{0xA34D, 0xa5, REG_BITS_8},
	{0xA34E, 0xe8, REG_BITS_8},
	{0xA34F, 0xa5, REG_BITS_8},
	{0xA350, 0x32, REG_BITS_8},
	{0xA351, 0xb8, REG_BITS_8},
	{0xA352, 0xc9, REG_BITS_8},
	{0xA353, 0x0c, REG_BITS_8},
	{0xA354, 0x5b, REG_BITS_8},
	{0xA355, 0xa2, REG_BITS_8},
	{0xA356, 0x82, REG_BITS_8},
	{0xA357, 0x94, REG_BITS_8},
	{0xA358, 0xa8, REG_BITS_8},
	{0xA359, 0xbc, REG_BITS_8},
	{0xA35A, 0x85, REG_BITS_8},
	{0xA35B, 0x33, REG_BITS_8},
	{0xA35C, 0xb7, REG_BITS_8},
	{0xA35D, 0x19, REG_BITS_8},
	{0xA35E, 0x0f, REG_BITS_8},
	{0xA35F, 0x74, REG_BITS_8},
	{0xA360, 0x40, REG_BITS_8},
	{0xA361, 0x93, REG_BITS_8},
	{0xA362, 0x18, REG_BITS_8},
	{0xA363, 0xc0, REG_BITS_8},
	{0xA364, 0x20, REG_BITS_8},
	{0xA365, 0x46, REG_BITS_8},
	{0xA366, 0x34, REG_BITS_8},
	{0xA367, 0xd5, REG_BITS_8},
	{0xA368, 0x29, REG_BITS_8},
	{0xA369, 0x0f, REG_BITS_8},
	{0xA36A, 0x82, REG_BITS_8},
	{0xA36B, 0x0c, REG_BITS_8},
	{0xA36C, 0xa4, REG_BITS_8},
	{0xA36D, 0x9e, REG_BITS_8},
	{0xA36E, 0xe9, REG_BITS_8},
	{0xA36F, 0x2c, REG_BITS_8},
	{0xA370, 0x67, REG_BITS_8},
	{0xA371, 0x3a, REG_BITS_8},
	{0xA372, 0xe8, REG_BITS_8},
	{0xA373, 0x39, REG_BITS_8},
	{0xA374, 0x10, REG_BITS_8},
	{0xA375, 0x81, REG_BITS_8},
	{0xA376, 0xba, REG_BITS_8},
	{0xA377, 0x53, REG_BITS_8},
	{0xA378, 0x9f, REG_BITS_8},
	{0xA379, 0xf8, REG_BITS_8},
	{0xA37A, 0x74, REG_BITS_8},
	{0xA37B, 0xe7, REG_BITS_8},
	{0xA37C, 0x3a, REG_BITS_8},
	{0xA37D, 0xde, REG_BITS_8},
	{0xA37E, 0x71, REG_BITS_8},
	{0xA37F, 0xcf, REG_BITS_8},
	{0xA380, 0x7c, REG_BITS_8},
	{0xA381, 0xb6, REG_BITS_8},
	{0xA382, 0x43, REG_BITS_8},
	{0xA383, 0x98, REG_BITS_8},
	{0xA384, 0xc9, REG_BITS_8},
	{0xA385, 0x50, REG_BITS_8},
	{0xA386, 0xa6, REG_BITS_8},
	{0xA387, 0x2f, REG_BITS_8},
	{0xA388, 0x84, REG_BITS_8},
	{0xA389, 0x99, REG_BITS_8},
	{0xA38A, 0x0c, REG_BITS_8},
	{0xA38B, 0x65, REG_BITS_8},
	{0xA38C, 0xfa, REG_BITS_8},
	{0xA38D, 0x82, REG_BITS_8},
	{0xA38E, 0x97, REG_BITS_8},
	{0xA38F, 0xc0, REG_BITS_8},
	{0xA390, 0x38, REG_BITS_8},
	{0xA391, 0x66, REG_BITS_8},
	{0xA392, 0x33, REG_BITS_8},
	{0xA393, 0x98, REG_BITS_8},
	{0xA394, 0x01, REG_BITS_8},
	{0xA395, 0xcd, REG_BITS_8},
	{0xA396, 0x67, REG_BITS_8},
	{0xA397, 0x1a, REG_BITS_8},
	{0xA398, 0x93, REG_BITS_8},
	{0xA399, 0x17, REG_BITS_8},
	{0xA39A, 0xb9, REG_BITS_8},
	{0xA39B, 0xf0, REG_BITS_8},
	{0xA39C, 0x65, REG_BITS_8},
	{0xA39D, 0x31, REG_BITS_8},
	{0xA39E, 0xa2, REG_BITS_8},
	{0xA39F, 0x21, REG_BITS_8},
	{0xA3A0, 0x0d, REG_BITS_8},
	{0xA3A1, 0x61, REG_BITS_8},
	{0xA3A2, 0xf4, REG_BITS_8},
	{0xA3A3, 0xc2, REG_BITS_8},
	{0xA3A4, 0x95, REG_BITS_8},
	{0xA3A5, 0xa6, REG_BITS_8},
	{0xA3A6, 0x20, REG_BITS_8},
	{0xA3A7, 0xe5, REG_BITS_8},
	{0xA3A8, 0x29, REG_BITS_8},
	{0xA3A9, 0x5e, REG_BITS_8},
	{0xA3AA, 0xe1, REG_BITS_8},
	{0xA3AB, 0x0b, REG_BITS_8},
	{0xA3AC, 0x61, REG_BITS_8},
	{0xA3AD, 0xd0, REG_BITS_8},
	{0xA3AE, 0x72, REG_BITS_8},
	{0xA3AF, 0x15, REG_BITS_8},
	{0xA3B0, 0x9f, REG_BITS_8},
	{0xA3B1, 0xbc, REG_BITS_8},
	{0xA3B2, 0x64, REG_BITS_8},
	{0xA3B3, 0x25, REG_BITS_8},
	{0xA3B4, 0x32, REG_BITS_8},
	{0xA3B5, 0x11, REG_BITS_8},
	{0xA3B6, 0x0a, REG_BITS_8},
	{0xA3B7, 0x56, REG_BITS_8},
	{0xA3B8, 0xc8, REG_BITS_8},
	{0xA3B9, 0x02, REG_BITS_8},
	{0xA3BA, 0x15, REG_BITS_8},
	{0xA3BB, 0xa1, REG_BITS_8},
	{0xA3BC, 0xa4, REG_BITS_8},
	{0xA3BD, 0x44, REG_BITS_8},
	{0xA3BE, 0x22, REG_BITS_8},
	{0xA3BF, 0x0d, REG_BITS_8},
	{0xA3C0, 0xa1, REG_BITS_8},
	{0xA3C1, 0x88, REG_BITS_8},
	{0xA3C2, 0x4b, REG_BITS_8},
	{0xA3C3, 0x92, REG_BITS_8},
	{0xA3C4, 0x52, REG_BITS_8},
	{0xA3C5, 0x15, REG_BITS_8},
	{0xA3C6, 0xa4, REG_BITS_8},
	{0xA3C7, 0xf0, REG_BITS_8},
	{0xA3C8, 0xa4, REG_BITS_8},
	{0xA3C9, 0x23, REG_BITS_8},
	{0xA3CA, 0x04, REG_BITS_8},
	{0xA3CB, 0xf9, REG_BITS_8},
	{0xA3CC, 0x87, REG_BITS_8},
	{0xA3CD, 0x42, REG_BITS_8},
	{0xA3CE, 0x4c, REG_BITS_8},
	{0xA3CF, 0x42, REG_BITS_8},
	{0xA3D0, 0x94, REG_BITS_8},
	{0xA3D1, 0xa5, REG_BITS_8},
	{0xA3D2, 0x24, REG_BITS_8},
	{0xA3D3, 0xc5, REG_BITS_8},
	{0xA3D4, 0x27, REG_BITS_8},
	{0xA3D5, 0x20, REG_BITS_8},
	{0xA3D6, 0x39, REG_BITS_8},
	{0xA3D7, 0x08, REG_BITS_8},
	{0xA3D8, 0x40, REG_BITS_8},
	{0xA3D9, 0x1a, REG_BITS_8},
	{0xA3DA, 0x62, REG_BITS_8},
	{0xA3DB, 0x12, REG_BITS_8},
	{0xA3DC, 0xa2, REG_BITS_8},
	{0xA3DD, 0x2c, REG_BITS_8},
	{0xA3DE, 0x05, REG_BITS_8},
	{0xA3DF, 0x2b, REG_BITS_8},
	{0xA3E0, 0x49, REG_BITS_8},
	{0xA3E1, 0x81, REG_BITS_8},
	{0xA3E2, 0x49, REG_BITS_8},
	{0xA3E3, 0x46, REG_BITS_8},
	{0xA3E4, 0x22, REG_BITS_8},
	{0xA3E5, 0xa2, REG_BITS_8},
	{0xA3E6, 0x11, REG_BITS_8},
	{0xA3E7, 0x99, REG_BITS_8},
	{0xA3E8, 0x2c, REG_BITS_8},
	{0xA3E9, 0xc5, REG_BITS_8},
	{0xA3EA, 0x2a, REG_BITS_8},
	{0xA3EB, 0x6e, REG_BITS_8},
	{0xA3EC, 0xe9, REG_BITS_8},
	{0xA3ED, 0x8a, REG_BITS_8},
	{0xA3EE, 0x51, REG_BITS_8},
	{0xA3EF, 0x68, REG_BITS_8},
	{0xA3F0, 0xe2, REG_BITS_8},
	{0xA3F1, 0x12, REG_BITS_8},
	{0xA3F2, 0x9b, REG_BITS_8},
	{0xA3F3, 0x14, REG_BITS_8},
	{0xA3F4, 0x65, REG_BITS_8},
	{0xA3F5, 0x2b, REG_BITS_8},
	{0xA3F6, 0x67, REG_BITS_8},
	{0xA3F7, 0x81, REG_BITS_8},
	{0xA3F8, 0x4c, REG_BITS_8},
	{0xA3F9, 0x61, REG_BITS_8},
	{0xA3FA, 0xca, REG_BITS_8},
	{0xA3FB, 0x22, REG_BITS_8},
	{0xA3FC, 0x15, REG_BITS_8},
	{0xA3FD, 0xa6, REG_BITS_8},
	{0xA3FE, 0x48, REG_BITS_8},
	{0xA3FF, 0x05, REG_BITS_8},
	{0xA400, 0x2c, REG_BITS_8},
	{0xA401, 0x7e, REG_BITS_8},
	{0xA402, 0x31, REG_BITS_8},
	{0xA403, 0xcc, REG_BITS_8},
	{0xA404, 0x6c, REG_BITS_8},
	{0xA405, 0x5a, REG_BITS_8},
	{0xA406, 0x33, REG_BITS_8},
	{0xA407, 0x19, REG_BITS_8},
	{0xA408, 0xc0, REG_BITS_8},
	{0xA409, 0xec, REG_BITS_8},
	{0xA40A, 0xe5, REG_BITS_8},
	{0xA40B, 0x2f, REG_BITS_8},
	{0xA40C, 0x8e, REG_BITS_8},
	{0xA40D, 0x01, REG_BITS_8},
	{0xA40E, 0x0d, REG_BITS_8},
	{0xA40F, 0x67, REG_BITS_8},
	{0xA410, 0x2e, REG_BITS_8},
	{0xA411, 0x53, REG_BITS_8},
	{0xA412, 0x9a, REG_BITS_8},
	{0xA413, 0xcb, REG_BITS_8},
	{0xA414, 0x1c, REG_BITS_8},
	{0xA415, 0x46, REG_BITS_8},
	{0xA416, 0x30, REG_BITS_8},
	{0xA417, 0x85, REG_BITS_8},
	{0xA418, 0x91, REG_BITS_8},
	{0xA419, 0x0c, REG_BITS_8},
	{0xA41A, 0x65, REG_BITS_8},
	{0xA41B, 0x08, REG_BITS_8},
	{0xA41C, 0x03, REG_BITS_8},
	{0xA41D, 0x00, REG_BITS_8},
	{0xA41E, 0x00, REG_BITS_8},
	{0xA41F, 0x00, REG_BITS_8},
	{0xA420, 0x00, REG_BITS_8},
	{0xA421, 0x0a, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_SHD_1_ES2 = sizeof(seix006_vendor_0_SHD_1_ES2);

const struct reg_entry seix006_vendor_0_SHD_2_ES2[] = {
	{0x0068, 0x50, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x02, REG_BITS_8},
	{0x9003, 0x0e, REG_BITS_8},
	{0x9004, 0x08, REG_BITS_8},
	{0x9005, 0x38, REG_BITS_8},
	{0x9006, 0x10, REG_BITS_8},
	{0x9007, 0x20, REG_BITS_8},
	{0x9008, 0x01, REG_BITS_8},
	{0x9009, 0x00, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x01, REG_BITS_8},
	{0x900C, 0x12, REG_BITS_8},
	{0x900D, 0x04, REG_BITS_8},
	{0x900E, 0x48, REG_BITS_8},
	{0x900F, 0x10, REG_BITS_8},
	{0x9010, 0x00, REG_BITS_8},
	{0x9011, 0xc1, REG_BITS_8},
	{0x9012, 0x80, REG_BITS_8},
	{0x9013, 0x04, REG_BITS_8},
	{0x9014, 0x03, REG_BITS_8},
	{0x9015, 0x12, REG_BITS_8},
	{0x9016, 0x08, REG_BITS_8},
	{0x9017, 0x38, REG_BITS_8},
	{0x9018, 0x20, REG_BITS_8},
	{0x9019, 0xe0, REG_BITS_8},
	{0x901A, 0x40, REG_BITS_8},
	{0x901B, 0x80, REG_BITS_8},
	{0x901C, 0x04, REG_BITS_8},
	{0x901D, 0x00, REG_BITS_8},
	{0x901E, 0x10, REG_BITS_8},
	{0x901F, 0x04, REG_BITS_8},
	{0x9020, 0x48, REG_BITS_8},
	{0x9021, 0x10, REG_BITS_8},
	{0x9022, 0x20, REG_BITS_8},
	{0x9023, 0x41, REG_BITS_8},
	{0x9024, 0x00, REG_BITS_8},
	{0x9025, 0x04, REG_BITS_8},
	{0x9026, 0x03, REG_BITS_8},
	{0x9027, 0x12, REG_BITS_8},
	{0x9028, 0x0c, REG_BITS_8},
	{0x9029, 0x48, REG_BITS_8},
	{0x902A, 0x10, REG_BITS_8},
	{0x902B, 0xc0, REG_BITS_8},
	{0x902C, 0x40, REG_BITS_8},
	{0x902D, 0x00, REG_BITS_8},
	{0x902E, 0x03, REG_BITS_8},
	{0x902F, 0x03, REG_BITS_8},
	{0x9030, 0x0c, REG_BITS_8},
	{0x9031, 0x08, REG_BITS_8},
	{0x9032, 0x38, REG_BITS_8},
	{0x9033, 0x10, REG_BITS_8},
	{0x9034, 0xa0, REG_BITS_8},
	{0x9035, 0x80, REG_BITS_8},
	{0x9036, 0x80, REG_BITS_8},
	{0x9037, 0x03, REG_BITS_8},
	{0x9038, 0x02, REG_BITS_8},
	{0x9039, 0x10, REG_BITS_8},
	{0x903A, 0x08, REG_BITS_8},
	{0x903B, 0x40, REG_BITS_8},
	{0x903C, 0x20, REG_BITS_8},
	{0x903D, 0x00, REG_BITS_8},
	{0x903E, 0x01, REG_BITS_8},
	{0x903F, 0x00, REG_BITS_8},
	{0x9040, 0x03, REG_BITS_8},
	{0x9041, 0x00, REG_BITS_8},
	{0x9042, 0x0c, REG_BITS_8},
	{0x9043, 0x04, REG_BITS_8},
	{0x9044, 0x30, REG_BITS_8},
	{0x9045, 0x30, REG_BITS_8},
	{0x9046, 0xa0, REG_BITS_8},
	{0x9047, 0x80, REG_BITS_8},
	{0x9048, 0x00, REG_BITS_8},
	{0x9049, 0x03, REG_BITS_8},
	{0x904A, 0x02, REG_BITS_8},
	{0x904B, 0x0c, REG_BITS_8},
	{0x904C, 0x04, REG_BITS_8},
	{0x904D, 0x30, REG_BITS_8},
	{0x904E, 0x10, REG_BITS_8},
	{0x904F, 0xe0, REG_BITS_8},
	{0x9050, 0x40, REG_BITS_8},
	{0x9051, 0x80, REG_BITS_8},
	{0x9052, 0x03, REG_BITS_8},
	{0x9053, 0x02, REG_BITS_8},
	{0x9054, 0x0a, REG_BITS_8},
	{0x9055, 0x08, REG_BITS_8},
	{0x9056, 0x28, REG_BITS_8},
	{0x9057, 0x20, REG_BITS_8},
	{0x9058, 0x80, REG_BITS_8},
	{0x9059, 0x80, REG_BITS_8},
	{0x905A, 0x00, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x01, REG_BITS_8},
	{0x905D, 0x06, REG_BITS_8},
	{0x905E, 0x0c, REG_BITS_8},
	{0x905F, 0x18, REG_BITS_8},
	{0x9060, 0xe0, REG_BITS_8},
	{0x9061, 0x9f, REG_BITS_8},
	{0x9062, 0x40, REG_BITS_8},
	{0x9063, 0x00, REG_BITS_8},
	{0x9064, 0x03, REG_BITS_8},
	{0x9065, 0x01, REG_BITS_8},
	{0x9066, 0x0c, REG_BITS_8},
	{0x9067, 0x0c, REG_BITS_8},
	{0x9068, 0x30, REG_BITS_8},
	{0x9069, 0x30, REG_BITS_8},
	{0x906A, 0xc0, REG_BITS_8},
	{0x906B, 0x00, REG_BITS_8},
	{0x906C, 0x01, REG_BITS_8},
	{0x906D, 0x01, REG_BITS_8},
	{0x906E, 0x02, REG_BITS_8},
	{0x906F, 0x04, REG_BITS_8},
	{0x9070, 0x04, REG_BITS_8},
	{0x9071, 0x00, REG_BITS_8},
	{0x9072, 0x10, REG_BITS_8},
	{0x9073, 0x20, REG_BITS_8},
	{0x9074, 0x00, REG_BITS_8},
	{0x9075, 0x00, REG_BITS_8},
	{0x9076, 0x02, REG_BITS_8},
	{0x9077, 0x02, REG_BITS_8},
	{0x9078, 0x0c, REG_BITS_8},
	{0x9079, 0x08, REG_BITS_8},
	{0x907A, 0x30, REG_BITS_8},
	{0x907B, 0x30, REG_BITS_8},
	{0x907C, 0x80, REG_BITS_8},
	{0x907D, 0xc0, REG_BITS_8},
	{0x907E, 0x00, REG_BITS_8},
	{0x907F, 0x02, REG_BITS_8},
	{0x9080, 0x03, REG_BITS_8},
	{0x9081, 0x06, REG_BITS_8},
	{0x9082, 0x08, REG_BITS_8},
	{0x9083, 0x08, REG_BITS_8},
	{0x9084, 0x20, REG_BITS_8},
	{0x9085, 0x20, REG_BITS_8},
	{0x9086, 0xc0, REG_BITS_8},
	{0x9087, 0x00, REG_BITS_8},
	{0x9088, 0x01, REG_BITS_8},
	{0x9089, 0x03, REG_BITS_8},
	{0x908A, 0x04, REG_BITS_8},
	{0x908B, 0x08, REG_BITS_8},
	{0x908C, 0x20, REG_BITS_8},
	{0x908D, 0x20, REG_BITS_8},
	{0x908E, 0x80, REG_BITS_8},
	{0x908F, 0x40, REG_BITS_8},
	{0x9090, 0x00, REG_BITS_8},
	{0x9091, 0x02, REG_BITS_8},
	{0x9092, 0x01, REG_BITS_8},
	{0x9093, 0x08, REG_BITS_8},
	{0x9094, 0x10, REG_BITS_8},
	{0x9095, 0x08, REG_BITS_8},
	{0x9096, 0x50, REG_BITS_8},
	{0x9097, 0x20, REG_BITS_8},
	{0x9098, 0xc0, REG_BITS_8},
	{0x9099, 0x80, REG_BITS_8},
	{0x909A, 0x00, REG_BITS_8},
	{0x909B, 0x04, REG_BITS_8},
	{0x909C, 0x02, REG_BITS_8},
	{0x909D, 0x10, REG_BITS_8},
	{0x909E, 0x18, REG_BITS_8},
	{0x909F, 0x20, REG_BITS_8},
	{0x90A0, 0x80, REG_BITS_8},
	{0x90A1, 0x80, REG_BITS_8},
	{0x90A2, 0x00, REG_BITS_8},
	{0x90A3, 0x02, REG_BITS_8},
	{0x90A4, 0x03, REG_BITS_8},
	{0x90A5, 0x08, REG_BITS_8},
	{0x90A6, 0x0c, REG_BITS_8},
	{0x90A7, 0x20, REG_BITS_8},
	{0x90A8, 0x40, REG_BITS_8},
	{0x90A9, 0x80, REG_BITS_8},
	{0x90AA, 0x00, REG_BITS_8},
	{0x90AB, 0x01, REG_BITS_8},
	{0x90AC, 0x02, REG_BITS_8},
	{0x90AD, 0x02, REG_BITS_8},
	{0x90AE, 0x06, REG_BITS_8},
	{0x90AF, 0x0c, REG_BITS_8},
	{0x90B0, 0x18, REG_BITS_8},
	{0x90B1, 0x40, REG_BITS_8},
	{0x90B2, 0x60, REG_BITS_8},
	{0x90B3, 0xc0, REG_BITS_8},
	{0x90B4, 0x00, REG_BITS_8},
	{0x90B5, 0x02, REG_BITS_8},
	{0x90B6, 0x03, REG_BITS_8},
	{0x90B7, 0x08, REG_BITS_8},
	{0x90B8, 0x0c, REG_BITS_8},
	{0x90B9, 0x20, REG_BITS_8},
	{0x90BA, 0x30, REG_BITS_8},
	{0x90BB, 0x80, REG_BITS_8},
	{0x90BC, 0x40, REG_BITS_8},
	{0x90BD, 0x81, REG_BITS_8},
	{0x90BE, 0x02, REG_BITS_8},
	{0x90BF, 0x04, REG_BITS_8},
	{0x90C0, 0x06, REG_BITS_8},
	{0x90C1, 0x18, REG_BITS_8},
	{0x90C2, 0x20, REG_BITS_8},
	{0x90C3, 0x60, REG_BITS_8},
	{0x90C4, 0x80, REG_BITS_8},
	{0x90C5, 0x40, REG_BITS_8},
	{0x90C6, 0x81, REG_BITS_8},
	{0x90C7, 0x02, REG_BITS_8},
	{0x90C8, 0x06, REG_BITS_8},
	{0x90C9, 0x0a, REG_BITS_8},
	{0x90CA, 0x18, REG_BITS_8},
	{0x90CB, 0x28, REG_BITS_8},
	{0x90CC, 0x20, REG_BITS_8},
	{0x90CD, 0x80, REG_BITS_8},
	{0x90CE, 0x80, REG_BITS_8},
	{0x90CF, 0x00, REG_BITS_8},
	{0x90D0, 0x02, REG_BITS_8},
	{0x90D1, 0x03, REG_BITS_8},
	{0x90D2, 0x08, REG_BITS_8},
	{0x90D3, 0x10, REG_BITS_8},
	{0x90D4, 0x20, REG_BITS_8},
	{0x90D5, 0x60, REG_BITS_8},
	{0x90D6, 0xa0, REG_BITS_8},
	{0x90D7, 0x80, REG_BITS_8},
	{0x90D8, 0x80, REG_BITS_8},
	{0x90D9, 0x02, REG_BITS_8},
	{0x90DA, 0x03, REG_BITS_8},
	{0x90DB, 0x06, REG_BITS_8},
	{0x90DC, 0x1c, REG_BITS_8},
	{0x90DD, 0x30, REG_BITS_8},
	{0x90DE, 0x70, REG_BITS_8},
	{0x90DF, 0xc0, REG_BITS_8},
	{0x90E0, 0x80, REG_BITS_8},
	{0x90E1, 0x00, REG_BITS_8},
	{0x90E2, 0x02, REG_BITS_8},
	{0x90E3, 0x02, REG_BITS_8},
	{0x90E4, 0x08, REG_BITS_8},
	{0x90E5, 0x0c, REG_BITS_8},
	{0x90E6, 0x20, REG_BITS_8},
	{0x90E7, 0x40, REG_BITS_8},
	{0x90E8, 0x80, REG_BITS_8},
	{0x90E9, 0x80, REG_BITS_8},
	{0x90EA, 0x81, REG_BITS_8},
	{0x90EB, 0x02, REG_BITS_8},
	{0x90EC, 0x02, REG_BITS_8},
	{0x90ED, 0x0a, REG_BITS_8},
	{0x90EE, 0x0c, REG_BITS_8},
	{0x90EF, 0x18, REG_BITS_8},
	{0x90F0, 0x70, REG_BITS_8},
	{0x90F1, 0xc0, REG_BITS_8},
	{0x90F2, 0xc0, REG_BITS_8},
	{0x90F3, 0x01, REG_BITS_8},
	{0x90F4, 0x03, REG_BITS_8},
	{0x90F5, 0x00, REG_BITS_8},
	{0x90F6, 0xf0, REG_BITS_8},
	{0x90F7, 0x03, REG_BITS_8},
	{0x90F8, 0xc0, REG_BITS_8},
	{0x90F9, 0x1f, REG_BITS_8},
	{0x90FA, 0xc0, REG_BITS_8},
	{0x90FB, 0xfe, REG_BITS_8},
	{0x90FC, 0xff, REG_BITS_8},
	{0x90FD, 0xfc, REG_BITS_8},
	{0x90FE, 0x01, REG_BITS_8},
	{0x90FF, 0xec, REG_BITS_8},
	{0x9100, 0xff, REG_BITS_8},
	{0x9101, 0xbf, REG_BITS_8},
	{0x9102, 0x0f, REG_BITS_8},
	{0x9103, 0x20, REG_BITS_8},
	{0x9104, 0x7f, REG_BITS_8},
	{0x9105, 0x00, REG_BITS_8},
	{0x9106, 0xfb, REG_BITS_8},
	{0x9107, 0x01, REG_BITS_8},
	{0x9108, 0xec, REG_BITS_8},
	{0x9109, 0x03, REG_BITS_8},
	{0x910A, 0xc0, REG_BITS_8},
	{0x910B, 0x0f, REG_BITS_8},
	{0x910C, 0x00, REG_BITS_8},
	{0x910D, 0x7f, REG_BITS_8},
	{0x910E, 0x00, REG_BITS_8},
	{0x910F, 0xfb, REG_BITS_8},
	{0x9110, 0xff, REG_BITS_8},
	{0x9111, 0xf3, REG_BITS_8},
	{0x9112, 0x07, REG_BITS_8},
	{0x9113, 0xb0, REG_BITS_8},
	{0x9114, 0xff, REG_BITS_8},
	{0x9115, 0xff, REG_BITS_8},
	{0x9116, 0x3e, REG_BITS_8},
	{0x9117, 0x80, REG_BITS_8},
	{0x9118, 0xfc, REG_BITS_8},
	{0x9119, 0x01, REG_BITS_8},
	{0x911A, 0xec, REG_BITS_8},
	{0x911B, 0x07, REG_BITS_8},
	{0x911C, 0xb0, REG_BITS_8},
	{0x911D, 0x2f, REG_BITS_8},
	{0x911E, 0x80, REG_BITS_8},
	{0x911F, 0xbe, REG_BITS_8},
	{0x9120, 0x00, REG_BITS_8},
	{0x9121, 0xfa, REG_BITS_8},
	{0x9122, 0x02, REG_BITS_8},
	{0x9123, 0xec, REG_BITS_8},
	{0x9124, 0x03, REG_BITS_8},
	{0x9125, 0xc0, REG_BITS_8},
	{0x9126, 0x0f, REG_BITS_8},
	{0x9127, 0x80, REG_BITS_8},
	{0x9128, 0xfe, REG_BITS_8},
	{0x9129, 0x7f, REG_BITS_8},
	{0x912A, 0xfa, REG_BITS_8},
	{0x912B, 0x01, REG_BITS_8},
	{0x912C, 0xf2, REG_BITS_8},
	{0x912D, 0x03, REG_BITS_8},
	{0x912E, 0xc0, REG_BITS_8},
	{0x912F, 0x0f, REG_BITS_8},
	{0x9130, 0x00, REG_BITS_8},
	{0x9131, 0x7f, REG_BITS_8},
	{0x9132, 0x00, REG_BITS_8},
	{0x9133, 0xfc, REG_BITS_8},
	{0x9134, 0x01, REG_BITS_8},
	{0x9135, 0xf0, REG_BITS_8},
	{0x9136, 0x07, REG_BITS_8},
	{0x9137, 0xa8, REG_BITS_8},
	{0x9138, 0x0f, REG_BITS_8},
	{0x9139, 0xa0, REG_BITS_8},
	{0x913A, 0xfe, REG_BITS_8},
	{0x913B, 0xff, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0xfe, REG_BITS_8},
	{0x913E, 0xf1, REG_BITS_8},
	{0x913F, 0xfb, REG_BITS_8},
	{0x9140, 0xb7, REG_BITS_8},
	{0x9141, 0x1f, REG_BITS_8},
	{0x9142, 0xa0, REG_BITS_8},
	{0x9143, 0x7e, REG_BITS_8},
	{0x9144, 0x80, REG_BITS_8},
	{0x9145, 0xfa, REG_BITS_8},
	{0x9146, 0x02, REG_BITS_8},
	{0x9147, 0xee, REG_BITS_8},
	{0x9148, 0x0b, REG_BITS_8},
	{0x9149, 0xb8, REG_BITS_8},
	{0x914A, 0x2f, REG_BITS_8},
	{0x914B, 0xe0, REG_BITS_8},
	{0x914C, 0x3e, REG_BITS_8},
	{0x914D, 0x80, REG_BITS_8},
	{0x914E, 0xfd, REG_BITS_8},
	{0x914F, 0xff, REG_BITS_8},
	{0x9150, 0xef, REG_BITS_8},
	{0x9151, 0xff, REG_BITS_8},
	{0x9152, 0xcf, REG_BITS_8},
	{0x9153, 0x0f, REG_BITS_8},
	{0x9154, 0xe0, REG_BITS_8},
	{0x9155, 0x3e, REG_BITS_8},
	{0x9156, 0x00, REG_BITS_8},
	{0x9157, 0xfd, REG_BITS_8},
	{0x9158, 0x00, REG_BITS_8},
	{0x9159, 0xf4, REG_BITS_8},
	{0x915A, 0x13, REG_BITS_8},
	{0x915B, 0xe0, REG_BITS_8},
	{0x915C, 0x4f, REG_BITS_8},
	{0x915D, 0x80, REG_BITS_8},
	{0x915E, 0x3f, REG_BITS_8},
	{0x915F, 0x00, REG_BITS_8},
	{0x9160, 0xfd, REG_BITS_8},
	{0x9161, 0x00, REG_BITS_8},
	{0x9162, 0xf8, REG_BITS_8},
	{0x9163, 0xff, REG_BITS_8},
	{0x9164, 0xef, REG_BITS_8},
	{0x9165, 0xff, REG_BITS_8},
	{0x9166, 0x7f, REG_BITS_8},
	{0x9167, 0x3f, REG_BITS_8},
	{0x9168, 0x00, REG_BITS_8},
	{0x9169, 0xfe, REG_BITS_8},
	{0x916A, 0x01, REG_BITS_8},
	{0x916B, 0xf8, REG_BITS_8},
	{0x916C, 0x07, REG_BITS_8},
	{0x916D, 0xe0, REG_BITS_8},
	{0x916E, 0x6f, REG_BITS_8},
	{0x916F, 0x80, REG_BITS_8},
	{0x9170, 0xbf, REG_BITS_8},
	{0x9171, 0x01, REG_BITS_8},
	{0x9172, 0xfe, REG_BITS_8},
	{0x9173, 0x03, REG_BITS_8},
	{0x9174, 0xfe, REG_BITS_8},
	{0x9175, 0x0b, REG_BITS_8},
	{0x9176, 0xf8, REG_BITS_8},
	{0x9177, 0x0f, REG_BITS_8},
	{0x9178, 0xe0, REG_BITS_8},
	{0x9179, 0xff, REG_BITS_8},
	{0x917A, 0x7f, REG_BITS_8},
	{0x917B, 0xff, REG_BITS_8},
	{0x917C, 0x02, REG_BITS_8},
	{0x917D, 0x00, REG_BITS_8},
	{0x917E, 0x08, REG_BITS_8},
	{0x917F, 0xe8, REG_BITS_8},
	{0x9180, 0x2f, REG_BITS_8},
	{0x9181, 0xa0, REG_BITS_8},
	{0x9182, 0x7f, REG_BITS_8},
	{0x9183, 0x01, REG_BITS_8},
	{0x9184, 0xff, REG_BITS_8},
	{0x9185, 0x05, REG_BITS_8},
	{0x9186, 0xfc, REG_BITS_8},
	{0x9187, 0x13, REG_BITS_8},
	{0x9188, 0x10, REG_BITS_8},
	{0x9189, 0x30, REG_BITS_8},
	{0x918A, 0x60, REG_BITS_8},
	{0x918B, 0x80, REG_BITS_8},
	{0x918C, 0x80, REG_BITS_8},
	{0x918D, 0x00, REG_BITS_8},
	{0x918E, 0x02, REG_BITS_8},
	{0x918F, 0x0c, REG_BITS_8},
	{0x9190, 0x00, REG_BITS_8},
	{0x9191, 0x20, REG_BITS_8},
	{0x9192, 0x30, REG_BITS_8},
	{0x9193, 0x20, REG_BITS_8},
	{0x9194, 0xc0, REG_BITS_8},
	{0x9195, 0x80, REG_BITS_8},
	{0x9196, 0x00, REG_BITS_8},
	{0x9197, 0x07, REG_BITS_8},
	{0x9198, 0x04, REG_BITS_8},
	{0x9199, 0x1c, REG_BITS_8},
	{0x919A, 0x10, REG_BITS_8},
	{0x919B, 0x60, REG_BITS_8},
	{0x919C, 0xa0, REG_BITS_8},
	{0x919D, 0xc0, REG_BITS_8},
	{0x919E, 0x80, REG_BITS_8},
	{0x919F, 0x02, REG_BITS_8},
	{0x91A0, 0x05, REG_BITS_8},
	{0x91A1, 0x0c, REG_BITS_8},
	{0x91A2, 0x0c, REG_BITS_8},
	{0x91A3, 0x30, REG_BITS_8},
	{0x91A4, 0x30, REG_BITS_8},
	{0x91A5, 0x60, REG_BITS_8},
	{0x91A6, 0xc0, REG_BITS_8},
	{0x91A7, 0x80, REG_BITS_8},
	{0x91A8, 0x02, REG_BITS_8},
	{0x91A9, 0x03, REG_BITS_8},
	{0x91AA, 0x0a, REG_BITS_8},
	{0x91AB, 0x18, REG_BITS_8},
	{0x91AC, 0x20, REG_BITS_8},
	{0x91AD, 0x60, REG_BITS_8},
	{0x91AE, 0x80, REG_BITS_8},
	{0x91AF, 0xc0, REG_BITS_8},
	{0x91B0, 0x01, REG_BITS_8},
	{0x91B1, 0x02, REG_BITS_8},
	{0x91B2, 0x05, REG_BITS_8},
	{0x91B3, 0x16, REG_BITS_8},
	{0x91B4, 0x14, REG_BITS_8},
	{0x91B5, 0x48, REG_BITS_8},
	{0x91B6, 0x40, REG_BITS_8},
	{0x91B7, 0x00, REG_BITS_8},
	{0x91B8, 0x01, REG_BITS_8},
	{0x91B9, 0x81, REG_BITS_8},
	{0x91BA, 0x04, REG_BITS_8},
	{0x91BB, 0x04, REG_BITS_8},
	{0x91BC, 0x0a, REG_BITS_8},
	{0x91BD, 0x10, REG_BITS_8},
	{0x91BE, 0x28, REG_BITS_8},
	{0x91BF, 0x50, REG_BITS_8},
	{0x91C0, 0x60, REG_BITS_8},
	{0x91C1, 0x40, REG_BITS_8},
	{0x91C2, 0x81, REG_BITS_8},
	{0x91C3, 0x01, REG_BITS_8},
	{0x91C4, 0x05, REG_BITS_8},
	{0x91C5, 0x0e, REG_BITS_8},
	{0x91C6, 0x10, REG_BITS_8},
	{0x91C7, 0x40, REG_BITS_8},
	{0x91C8, 0x40, REG_BITS_8},
	{0x91C9, 0x00, REG_BITS_8},
	{0x91CA, 0x01, REG_BITS_8},
	{0x91CB, 0x81, REG_BITS_8},
	{0x91CC, 0x02, REG_BITS_8},
	{0x91CD, 0x04, REG_BITS_8},
	{0x91CE, 0x0c, REG_BITS_8},
	{0x91CF, 0x14, REG_BITS_8},
	{0x91D0, 0x08, REG_BITS_8},
	{0x91D1, 0x50, REG_BITS_8},
	{0x91D2, 0x20, REG_BITS_8},
	{0x91D3, 0x40, REG_BITS_8},
	{0x91D4, 0x81, REG_BITS_8},
	{0x91D5, 0x01, REG_BITS_8},
	{0x91D6, 0x05, REG_BITS_8},
	{0x91D7, 0x06, REG_BITS_8},
	{0x91D8, 0x14, REG_BITS_8},
	{0x91D9, 0x38, REG_BITS_8},
	{0x91DA, 0x40, REG_BITS_8},
	{0x91DB, 0x00, REG_BITS_8},
	{0x91DC, 0x01, REG_BITS_8},
	{0x91DD, 0x01, REG_BITS_8},
	{0x91DE, 0x04, REG_BITS_8},
	{0x91DF, 0x04, REG_BITS_8},
	{0x91E0, 0x0a, REG_BITS_8},
	{0x91E1, 0x10, REG_BITS_8},
	{0x91E2, 0x30, REG_BITS_8},
	{0x91E3, 0x50, REG_BITS_8},
	{0x91E4, 0x20, REG_BITS_8},
	{0x91E5, 0x40, REG_BITS_8},
	{0x91E6, 0x81, REG_BITS_8},
	{0x91E7, 0x00, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x7c, REG_BITS_8},
	{0xA003, 0xe1, REG_BITS_8},
	{0xA004, 0x4d, REG_BITS_8},
	{0xA005, 0x63, REG_BITS_8},
	{0xA006, 0x9e, REG_BITS_8},
	{0xA007, 0x83, REG_BITS_8},
	{0xA008, 0x18, REG_BITS_8},
	{0xA009, 0xe7, REG_BITS_8},
	{0xA00A, 0xdc, REG_BITS_8},
	{0xA00B, 0x25, REG_BITS_8},
	{0xA00C, 0x37, REG_BITS_8},
	{0xA00D, 0x73, REG_BITS_8},
	{0xA00E, 0xa9, REG_BITS_8},
	{0xA00F, 0x4d, REG_BITS_8},
	{0xA010, 0x5e, REG_BITS_8},
	{0xA011, 0x7a, REG_BITS_8},
	{0xA012, 0xa3, REG_BITS_8},
	{0xA013, 0x18, REG_BITS_8},
	{0xA014, 0xe7, REG_BITS_8},
	{0xA015, 0x54, REG_BITS_8},
	{0xA016, 0xc6, REG_BITS_8},
	{0xA017, 0x3b, REG_BITS_8},
	{0xA018, 0x8c, REG_BITS_8},
	{0xA019, 0xa1, REG_BITS_8},
	{0xA01A, 0x8e, REG_BITS_8},
	{0xA01B, 0x66, REG_BITS_8},
	{0xA01C, 0xbc, REG_BITS_8},
	{0xA01D, 0x93, REG_BITS_8},
	{0xA01E, 0x19, REG_BITS_8},
	{0xA01F, 0xee, REG_BITS_8},
	{0xA020, 0x10, REG_BITS_8},
	{0xA021, 0xa6, REG_BITS_8},
	{0xA022, 0x38, REG_BITS_8},
	{0xA023, 0x74, REG_BITS_8},
	{0xA024, 0x81, REG_BITS_8},
	{0xA025, 0xcd, REG_BITS_8},
	{0xA026, 0x5b, REG_BITS_8},
	{0xA027, 0x52, REG_BITS_8},
	{0xA028, 0x43, REG_BITS_8},
	{0xA029, 0x97, REG_BITS_8},
	{0xA02A, 0xd8, REG_BITS_8},
	{0xA02B, 0x18, REG_BITS_8},
	{0xA02C, 0xa6, REG_BITS_8},
	{0xA02D, 0x38, REG_BITS_8},
	{0xA02E, 0x9e, REG_BITS_8},
	{0xA02F, 0x29, REG_BITS_8},
	{0xA030, 0x0f, REG_BITS_8},
	{0xA031, 0x68, REG_BITS_8},
	{0xA032, 0xd6, REG_BITS_8},
	{0xA033, 0x33, REG_BITS_8},
	{0xA034, 0x18, REG_BITS_8},
	{0xA035, 0xdf, REG_BITS_8},
	{0xA036, 0xe0, REG_BITS_8},
	{0xA037, 0xa5, REG_BITS_8},
	{0xA038, 0x35, REG_BITS_8},
	{0xA039, 0x59, REG_BITS_8},
	{0xA03A, 0x29, REG_BITS_8},
	{0xA03B, 0x8c, REG_BITS_8},
	{0xA03C, 0x52, REG_BITS_8},
	{0xA03D, 0xe0, REG_BITS_8},
	{0xA03E, 0x52, REG_BITS_8},
	{0xA03F, 0x14, REG_BITS_8},
	{0xA040, 0xb4, REG_BITS_8},
	{0xA041, 0x28, REG_BITS_8},
	{0xA042, 0x05, REG_BITS_8},
	{0xA043, 0x2e, REG_BITS_8},
	{0xA044, 0x5a, REG_BITS_8},
	{0xA045, 0x39, REG_BITS_8},
	{0xA046, 0x8c, REG_BITS_8},
	{0xA047, 0x5e, REG_BITS_8},
	{0xA048, 0x66, REG_BITS_8},
	{0xA049, 0x23, REG_BITS_8},
	{0xA04A, 0x18, REG_BITS_8},
	{0xA04B, 0xe1, REG_BITS_8},
	{0xA04C, 0x98, REG_BITS_8},
	{0xA04D, 0xe5, REG_BITS_8},
	{0xA04E, 0x32, REG_BITS_8},
	{0xA04F, 0x56, REG_BITS_8},
	{0xA050, 0xf9, REG_BITS_8},
	{0xA051, 0x8b, REG_BITS_8},
	{0xA052, 0x4f, REG_BITS_8},
	{0xA053, 0xb6, REG_BITS_8},
	{0xA054, 0xd2, REG_BITS_8},
	{0xA055, 0x12, REG_BITS_8},
	{0xA056, 0xa1, REG_BITS_8},
	{0xA057, 0x98, REG_BITS_8},
	{0xA058, 0x44, REG_BITS_8},
	{0xA059, 0x27, REG_BITS_8},
	{0xA05A, 0x2d, REG_BITS_8},
	{0xA05B, 0x19, REG_BITS_8},
	{0xA05C, 0xca, REG_BITS_8},
	{0xA05D, 0x4f, REG_BITS_8},
	{0xA05E, 0xb8, REG_BITS_8},
	{0xA05F, 0x82, REG_BITS_8},
	{0xA060, 0x15, REG_BITS_8},
	{0xA061, 0xc1, REG_BITS_8},
	{0xA062, 0x9c, REG_BITS_8},
	{0xA063, 0x45, REG_BITS_8},
	{0xA064, 0x33, REG_BITS_8},
	{0xA065, 0x57, REG_BITS_8},
	{0xA066, 0xf1, REG_BITS_8},
	{0xA067, 0x8b, REG_BITS_8},
	{0xA068, 0x51, REG_BITS_8},
	{0xA069, 0xca, REG_BITS_8},
	{0xA06A, 0x92, REG_BITS_8},
	{0xA06B, 0x92, REG_BITS_8},
	{0xA06C, 0x9d, REG_BITS_8},
	{0xA06D, 0x44, REG_BITS_8},
	{0xA06E, 0x44, REG_BITS_8},
	{0xA06F, 0x23, REG_BITS_8},
	{0xA070, 0x09, REG_BITS_8},
	{0xA071, 0x81, REG_BITS_8},
	{0xA072, 0x88, REG_BITS_8},
	{0xA073, 0x44, REG_BITS_8},
	{0xA074, 0x36, REG_BITS_8},
	{0xA075, 0x92, REG_BITS_8},
	{0xA076, 0x92, REG_BITS_8},
	{0xA077, 0x9e, REG_BITS_8},
	{0xA078, 0x1c, REG_BITS_8},
	{0xA079, 0x25, REG_BITS_8},
	{0xA07A, 0x2d, REG_BITS_8},
	{0xA07B, 0x55, REG_BITS_8},
	{0xA07C, 0x01, REG_BITS_8},
	{0xA07D, 0x4c, REG_BITS_8},
	{0xA07E, 0x53, REG_BITS_8},
	{0xA07F, 0xe4, REG_BITS_8},
	{0xA080, 0xf2, REG_BITS_8},
	{0xA081, 0x93, REG_BITS_8},
	{0xA082, 0xad, REG_BITS_8},
	{0xA083, 0x7c, REG_BITS_8},
	{0xA084, 0x64, REG_BITS_8},
	{0xA085, 0x25, REG_BITS_8},
	{0xA086, 0x04, REG_BITS_8},
	{0xA087, 0x41, REG_BITS_8},
	{0xA088, 0x48, REG_BITS_8},
	{0xA089, 0x3f, REG_BITS_8},
	{0xA08A, 0xfa, REG_BITS_8},
	{0xA08B, 0x61, REG_BITS_8},
	{0xA08C, 0x90, REG_BITS_8},
	{0xA08D, 0x84, REG_BITS_8},
	{0xA08E, 0x80, REG_BITS_8},
	{0xA08F, 0xc4, REG_BITS_8},
	{0xA090, 0x25, REG_BITS_8},
	{0xA091, 0x41, REG_BITS_8},
	{0xA092, 0xe9, REG_BITS_8},
	{0xA093, 0x0a, REG_BITS_8},
	{0xA094, 0x53, REG_BITS_8},
	{0xA095, 0xe4, REG_BITS_8},
	{0xA096, 0xf2, REG_BITS_8},
	{0xA097, 0x94, REG_BITS_8},
	{0xA098, 0xb9, REG_BITS_8},
	{0xA099, 0x08, REG_BITS_8},
	{0xA09A, 0xa5, REG_BITS_8},
	{0xA09B, 0x2b, REG_BITS_8},
	{0xA09C, 0x22, REG_BITS_8},
	{0xA09D, 0x79, REG_BITS_8},
	{0xA09E, 0x09, REG_BITS_8},
	{0xA09F, 0x42, REG_BITS_8},
	{0xA0A0, 0x18, REG_BITS_8},
	{0xA0A1, 0x22, REG_BITS_8},
	{0xA0A2, 0x10, REG_BITS_8},
	{0xA0A3, 0x81, REG_BITS_8},
	{0xA0A4, 0x28, REG_BITS_8},
	{0xA0A5, 0xa4, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x25, REG_BITS_8},
	{0xA0A8, 0x89, REG_BITS_8},
	{0xA0A9, 0x49, REG_BITS_8},
	{0xA0AA, 0x51, REG_BITS_8},
	{0xA0AB, 0xbe, REG_BITS_8},
	{0xA0AC, 0xf2, REG_BITS_8},
	{0xA0AD, 0x94, REG_BITS_8},
	{0xA0AE, 0xb9, REG_BITS_8},
	{0xA0AF, 0x74, REG_BITS_8},
	{0xA0B0, 0x05, REG_BITS_8},
	{0xA0B1, 0x31, REG_BITS_8},
	{0xA0B2, 0x4e, REG_BITS_8},
	{0xA0B3, 0x71, REG_BITS_8},
	{0xA0B4, 0xcb, REG_BITS_8},
	{0xA0B5, 0x4c, REG_BITS_8},
	{0xA0B6, 0x86, REG_BITS_8},
	{0xA0B7, 0xc2, REG_BITS_8},
	{0xA0B8, 0x11, REG_BITS_8},
	{0xA0B9, 0x92, REG_BITS_8},
	{0xA0BA, 0x54, REG_BITS_8},
	{0xA0BB, 0x44, REG_BITS_8},
	{0xA0BC, 0x23, REG_BITS_8},
	{0xA0BD, 0x1e, REG_BITS_8},
	{0xA0BE, 0x29, REG_BITS_8},
	{0xA0BF, 0xc9, REG_BITS_8},
	{0xA0C0, 0x4d, REG_BITS_8},
	{0xA0C1, 0x8e, REG_BITS_8},
	{0xA0C2, 0x32, REG_BITS_8},
	{0xA0C3, 0x95, REG_BITS_8},
	{0xA0C4, 0xb8, REG_BITS_8},
	{0xA0C5, 0x80, REG_BITS_8},
	{0xA0C6, 0x25, REG_BITS_8},
	{0xA0C7, 0x31, REG_BITS_8},
	{0xA0C8, 0x75, REG_BITS_8},
	{0xA0C9, 0x39, REG_BITS_8},
	{0xA0CA, 0x4d, REG_BITS_8},
	{0xA0CB, 0x59, REG_BITS_8},
	{0xA0CC, 0x1c, REG_BITS_8},
	{0xA0CD, 0xc3, REG_BITS_8},
	{0xA0CE, 0x94, REG_BITS_8},
	{0xA0CF, 0xb4, REG_BITS_8},
	{0xA0D0, 0xf4, REG_BITS_8},
	{0xA0D1, 0x44, REG_BITS_8},
	{0xA0D2, 0x2a, REG_BITS_8},
	{0xA0D3, 0x37, REG_BITS_8},
	{0xA0D4, 0x49, REG_BITS_8},
	{0xA0D5, 0x8a, REG_BITS_8},
	{0xA0D6, 0x4f, REG_BITS_8},
	{0xA0D7, 0xa4, REG_BITS_8},
	{0xA0D8, 0xf2, REG_BITS_8},
	{0xA0D9, 0x94, REG_BITS_8},
	{0xA0DA, 0xb5, REG_BITS_8},
	{0xA0DB, 0xa4, REG_BITS_8},
	{0xA0DC, 0x65, REG_BITS_8},
	{0xA0DD, 0x32, REG_BITS_8},
	{0xA0DE, 0x79, REG_BITS_8},
	{0xA0DF, 0x51, REG_BITS_8},
	{0xA0E0, 0x4d, REG_BITS_8},
	{0xA0E1, 0x65, REG_BITS_8},
	{0xA0E2, 0xa2, REG_BITS_8},
	{0xA0E3, 0xb3, REG_BITS_8},
	{0xA0E4, 0x98, REG_BITS_8},
	{0xA0E5, 0xe0, REG_BITS_8},
	{0xA0E6, 0xb0, REG_BITS_8},
	{0xA0E7, 0x05, REG_BITS_8},
	{0xA0E8, 0x33, REG_BITS_8},
	{0xA0E9, 0x5d, REG_BITS_8},
	{0xA0EA, 0x11, REG_BITS_8},
	{0xA0EB, 0x8c, REG_BITS_8},
	{0xA0EC, 0x56, REG_BITS_8},
	{0xA0ED, 0xf6, REG_BITS_8},
	{0xA0EE, 0xf2, REG_BITS_8},
	{0xA0EF, 0x95, REG_BITS_8},
	{0xA0F0, 0xc1, REG_BITS_8},
	{0xA0F1, 0xbc, REG_BITS_8},
	{0xA0F2, 0x65, REG_BITS_8},
	{0xA0F3, 0x33, REG_BITS_8},
	{0xA0F4, 0x92, REG_BITS_8},
	{0xA0F5, 0x49, REG_BITS_8},
	{0xA0F6, 0xce, REG_BITS_8},
	{0xA0F7, 0x66, REG_BITS_8},
	{0xA0F8, 0xb2, REG_BITS_8},
	{0xA0F9, 0xb3, REG_BITS_8},
	{0xA0FA, 0x9a, REG_BITS_8},
	{0xA0FB, 0xf6, REG_BITS_8},
	{0xA0FC, 0xb4, REG_BITS_8},
	{0xA0FD, 0xc6, REG_BITS_8},
	{0xA0FE, 0x3d, REG_BITS_8},
	{0xA0FF, 0x9c, REG_BITS_8},
	{0xA100, 0xb9, REG_BITS_8},
	{0xA101, 0x8e, REG_BITS_8},
	{0xA102, 0x63, REG_BITS_8},
	{0xA103, 0x88, REG_BITS_8},
	{0xA104, 0xa3, REG_BITS_8},
	{0xA105, 0x98, REG_BITS_8},
	{0xA106, 0xdf, REG_BITS_8},
	{0xA107, 0x38, REG_BITS_8},
	{0xA108, 0xe6, REG_BITS_8},
	{0xA109, 0x38, REG_BITS_8},
	{0xA10A, 0xa0, REG_BITS_8},
	{0xA10B, 0xe1, REG_BITS_8},
	{0xA10C, 0x4e, REG_BITS_8},
	{0xA10D, 0x6e, REG_BITS_8},
	{0xA10E, 0xfc, REG_BITS_8},
	{0xA10F, 0x73, REG_BITS_8},
	{0xA110, 0x1b, REG_BITS_8},
	{0xA111, 0xff, REG_BITS_8},
	{0xA112, 0x34, REG_BITS_8},
	{0xA113, 0x86, REG_BITS_8},
	{0xA114, 0x39, REG_BITS_8},
	{0xA115, 0x9f, REG_BITS_8},
	{0xA116, 0x19, REG_BITS_8},
	{0xA117, 0x0f, REG_BITS_8},
	{0xA118, 0x68, REG_BITS_8},
	{0xA119, 0xbe, REG_BITS_8},
	{0xA11A, 0x33, REG_BITS_8},
	{0xA11B, 0x19, REG_BITS_8},
	{0xA11C, 0xe9, REG_BITS_8},
	{0xA11D, 0x48, REG_BITS_8},
	{0xA11E, 0xe6, REG_BITS_8},
	{0xA11F, 0x39, REG_BITS_8},
	{0xA120, 0x94, REG_BITS_8},
	{0xA121, 0xa9, REG_BITS_8},
	{0xA122, 0x4e, REG_BITS_8},
	{0xA123, 0x69, REG_BITS_8},
	{0xA124, 0xcc, REG_BITS_8},
	{0xA125, 0xe3, REG_BITS_8},
	{0xA126, 0x1a, REG_BITS_8},
	{0xA127, 0xfa, REG_BITS_8},
	{0xA128, 0x74, REG_BITS_8},
	{0xA129, 0xe6, REG_BITS_8},
	{0xA12A, 0x3b, REG_BITS_8},
	{0xA12B, 0x63, REG_BITS_8},
	{0xA12C, 0x01, REG_BITS_8},
	{0xA12D, 0x8c, REG_BITS_8},
	{0xA12E, 0x5d, REG_BITS_8},
	{0xA12F, 0x24, REG_BITS_8},
	{0xA130, 0x53, REG_BITS_8},
	{0xA131, 0x97, REG_BITS_8},
	{0xA132, 0xc6, REG_BITS_8},
	{0xA133, 0xa0, REG_BITS_8},
	{0xA134, 0xe5, REG_BITS_8},
	{0xA135, 0x2f, REG_BITS_8},
	{0xA136, 0x68, REG_BITS_8},
	{0xA137, 0xc9, REG_BITS_8},
	{0xA138, 0x4b, REG_BITS_8},
	{0xA139, 0x5b, REG_BITS_8},
	{0xA13A, 0xfe, REG_BITS_8},
	{0xA13B, 0xf2, REG_BITS_8},
	{0xA13C, 0x17, REG_BITS_8},
	{0xA13D, 0xc9, REG_BITS_8},
	{0xA13E, 0x24, REG_BITS_8},
	{0xA13F, 0x26, REG_BITS_8},
	{0xA140, 0x33, REG_BITS_8},
	{0xA141, 0x7e, REG_BITS_8},
	{0xA142, 0x79, REG_BITS_8},
	{0xA143, 0x4c, REG_BITS_8},
	{0xA144, 0x60, REG_BITS_8},
	{0xA145, 0x3c, REG_BITS_8},
	{0xA146, 0x23, REG_BITS_8},
	{0xA147, 0x18, REG_BITS_8},
	{0xA148, 0xcf, REG_BITS_8},
	{0xA149, 0xc8, REG_BITS_8},
	{0xA14A, 0x25, REG_BITS_8},
	{0xA14B, 0x31, REG_BITS_8},
	{0xA14C, 0x66, REG_BITS_8},
	{0xA14D, 0xd1, REG_BITS_8},
	{0xA14E, 0x4b, REG_BITS_8},
	{0xA14F, 0x59, REG_BITS_8},
	{0xA150, 0xe6, REG_BITS_8},
	{0xA151, 0xa2, REG_BITS_8},
	{0xA152, 0x16, REG_BITS_8},
	{0xA153, 0xbd, REG_BITS_8},
	{0xA154, 0xec, REG_BITS_8},
	{0xA155, 0xa5, REG_BITS_8},
	{0xA156, 0x31, REG_BITS_8},
	{0xA157, 0x92, REG_BITS_8},
	{0xA158, 0x19, REG_BITS_8},
	{0xA159, 0x8d, REG_BITS_8},
	{0xA15A, 0x64, REG_BITS_8},
	{0xA15B, 0x46, REG_BITS_8},
	{0xA15C, 0xe3, REG_BITS_8},
	{0xA15D, 0x96, REG_BITS_8},
	{0xA15E, 0xc2, REG_BITS_8},
	{0xA15F, 0x98, REG_BITS_8},
	{0xA160, 0x65, REG_BITS_8},
	{0xA161, 0x2f, REG_BITS_8},
	{0xA162, 0x4c, REG_BITS_8},
	{0xA163, 0xe1, REG_BITS_8},
	{0xA164, 0x4a, REG_BITS_8},
	{0xA165, 0x50, REG_BITS_8},
	{0xA166, 0x9a, REG_BITS_8},
	{0xA167, 0xf2, REG_BITS_8},
	{0xA168, 0x93, REG_BITS_8},
	{0xA169, 0xa3, REG_BITS_8},
	{0xA16A, 0x10, REG_BITS_8},
	{0xA16B, 0xa5, REG_BITS_8},
	{0xA16C, 0x29, REG_BITS_8},
	{0xA16D, 0x54, REG_BITS_8},
	{0xA16E, 0xf9, REG_BITS_8},
	{0xA16F, 0x4a, REG_BITS_8},
	{0xA170, 0x5c, REG_BITS_8},
	{0xA171, 0xfc, REG_BITS_8},
	{0xA172, 0x82, REG_BITS_8},
	{0xA173, 0x17, REG_BITS_8},
	{0xA174, 0xc3, REG_BITS_8},
	{0xA175, 0x4c, REG_BITS_8},
	{0xA176, 0x25, REG_BITS_8},
	{0xA177, 0x2d, REG_BITS_8},
	{0xA178, 0x47, REG_BITS_8},
	{0xA179, 0xc9, REG_BITS_8},
	{0xA17A, 0x0a, REG_BITS_8},
	{0xA17B, 0x4d, REG_BITS_8},
	{0xA17C, 0x80, REG_BITS_8},
	{0xA17D, 0x82, REG_BITS_8},
	{0xA17E, 0x92, REG_BITS_8},
	{0xA17F, 0x97, REG_BITS_8},
	{0xA180, 0x90, REG_BITS_8},
	{0xA181, 0x24, REG_BITS_8},
	{0xA182, 0x25, REG_BITS_8},
	{0xA183, 0x2b, REG_BITS_8},
	{0xA184, 0x89, REG_BITS_8},
	{0xA185, 0x89, REG_BITS_8},
	{0xA186, 0x4e, REG_BITS_8},
	{0xA187, 0x84, REG_BITS_8},
	{0xA188, 0x22, REG_BITS_8},
	{0xA189, 0x95, REG_BITS_8},
	{0xA18A, 0xad, REG_BITS_8},
	{0xA18B, 0x7c, REG_BITS_8},
	{0xA18C, 0x05, REG_BITS_8},
	{0xA18D, 0x2d, REG_BITS_8},
	{0xA18E, 0x44, REG_BITS_8},
	{0xA18F, 0xb1, REG_BITS_8},
	{0xA190, 0x0a, REG_BITS_8},
	{0xA191, 0x4e, REG_BITS_8},
	{0xA192, 0x8e, REG_BITS_8},
	{0xA193, 0x22, REG_BITS_8},
	{0xA194, 0x92, REG_BITS_8},
	{0xA195, 0x95, REG_BITS_8},
	{0xA196, 0x38, REG_BITS_8},
	{0xA197, 0x64, REG_BITS_8},
	{0xA198, 0x22, REG_BITS_8},
	{0xA199, 0x0a, REG_BITS_8},
	{0xA19A, 0x59, REG_BITS_8},
	{0xA19B, 0x88, REG_BITS_8},
	{0xA19C, 0x44, REG_BITS_8},
	{0xA19D, 0x26, REG_BITS_8},
	{0xA19E, 0x92, REG_BITS_8},
	{0xA19F, 0x12, REG_BITS_8},
	{0xA1A0, 0x96, REG_BITS_8},
	{0xA1A1, 0x04, REG_BITS_8},
	{0xA1A2, 0x25, REG_BITS_8},
	{0xA1A3, 0x29, REG_BITS_8},
	{0xA1A4, 0x4c, REG_BITS_8},
	{0xA1A5, 0xb1, REG_BITS_8},
	{0xA1A6, 0x0a, REG_BITS_8},
	{0xA1A7, 0x4f, REG_BITS_8},
	{0xA1A8, 0x96, REG_BITS_8},
	{0xA1A9, 0x22, REG_BITS_8},
	{0xA1AA, 0x93, REG_BITS_8},
	{0xA1AB, 0x9f, REG_BITS_8},
	{0xA1AC, 0x5c, REG_BITS_8},
	{0xA1AD, 0xe4, REG_BITS_8},
	{0xA1AE, 0x23, REG_BITS_8},
	{0xA1AF, 0x02, REG_BITS_8},
	{0xA1B0, 0x31, REG_BITS_8},
	{0xA1B1, 0x88, REG_BITS_8},
	{0xA1B2, 0x3f, REG_BITS_8},
	{0xA1B3, 0xfe, REG_BITS_8},
	{0xA1B4, 0x71, REG_BITS_8},
	{0xA1B5, 0x10, REG_BITS_8},
	{0xA1B6, 0x83, REG_BITS_8},
	{0xA1B7, 0x7c, REG_BITS_8},
	{0xA1B8, 0x04, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x3a, REG_BITS_8},
	{0xA1BB, 0x01, REG_BITS_8},
	{0xA1BC, 0x8a, REG_BITS_8},
	{0xA1BD, 0x50, REG_BITS_8},
	{0xA1BE, 0x96, REG_BITS_8},
	{0xA1BF, 0x02, REG_BITS_8},
	{0xA1C0, 0x94, REG_BITS_8},
	{0xA1C1, 0xa5, REG_BITS_8},
	{0xA1C2, 0xd8, REG_BITS_8},
	{0xA1C3, 0xe4, REG_BITS_8},
	{0xA1C4, 0x27, REG_BITS_8},
	{0xA1C5, 0x1b, REG_BITS_8},
	{0xA1C6, 0x11, REG_BITS_8},
	{0xA1C7, 0x89, REG_BITS_8},
	{0xA1C8, 0x41, REG_BITS_8},
	{0xA1C9, 0x10, REG_BITS_8},
	{0xA1CA, 0x12, REG_BITS_8},
	{0xA1CB, 0x10, REG_BITS_8},
	{0xA1CC, 0x80, REG_BITS_8},
	{0xA1CD, 0x24, REG_BITS_8},
	{0xA1CE, 0x04, REG_BITS_8},
	{0xA1CF, 0x21, REG_BITS_8},
	{0xA1D0, 0x21, REG_BITS_8},
	{0xA1D1, 0x19, REG_BITS_8},
	{0xA1D2, 0xc9, REG_BITS_8},
	{0xA1D3, 0x4e, REG_BITS_8},
	{0xA1D4, 0x84, REG_BITS_8},
	{0xA1D5, 0x22, REG_BITS_8},
	{0xA1D6, 0x14, REG_BITS_8},
	{0xA1D7, 0xa6, REG_BITS_8},
	{0xA1D8, 0x38, REG_BITS_8},
	{0xA1D9, 0x25, REG_BITS_8},
	{0xA1DA, 0x2b, REG_BITS_8},
	{0xA1DB, 0x41, REG_BITS_8},
	{0xA1DC, 0x59, REG_BITS_8},
	{0xA1DD, 0x8a, REG_BITS_8},
	{0xA1DE, 0x4a, REG_BITS_8},
	{0xA1DF, 0x62, REG_BITS_8},
	{0xA1E0, 0x62, REG_BITS_8},
	{0xA1E1, 0x11, REG_BITS_8},
	{0xA1E2, 0x8d, REG_BITS_8},
	{0xA1E3, 0x44, REG_BITS_8},
	{0xA1E4, 0x44, REG_BITS_8},
	{0xA1E5, 0x22, REG_BITS_8},
	{0xA1E6, 0x18, REG_BITS_8},
	{0xA1E7, 0xd9, REG_BITS_8},
	{0xA1E8, 0x08, REG_BITS_8},
	{0xA1E9, 0x4b, REG_BITS_8},
	{0xA1EA, 0x68, REG_BITS_8},
	{0xA1EB, 0x52, REG_BITS_8},
	{0xA1EC, 0x14, REG_BITS_8},
	{0xA1ED, 0xa8, REG_BITS_8},
	{0xA1EE, 0x3c, REG_BITS_8},
	{0xA1EF, 0xa5, REG_BITS_8},
	{0xA1F0, 0x2b, REG_BITS_8},
	{0xA1F1, 0x65, REG_BITS_8},
	{0xA1F2, 0x89, REG_BITS_8},
	{0xA1F3, 0xcb, REG_BITS_8},
	{0xA1F4, 0x55, REG_BITS_8},
	{0xA1F5, 0xc2, REG_BITS_8},
	{0xA1F6, 0x12, REG_BITS_8},
	{0xA1F7, 0x14, REG_BITS_8},
	{0xA1F8, 0xa5, REG_BITS_8},
	{0xA1F9, 0xcc, REG_BITS_8},
	{0xA1FA, 0x64, REG_BITS_8},
	{0xA1FB, 0x27, REG_BITS_8},
	{0xA1FC, 0x30, REG_BITS_8},
	{0xA1FD, 0xa9, REG_BITS_8},
	{0xA1FE, 0x49, REG_BITS_8},
	{0xA1FF, 0x4d, REG_BITS_8},
	{0xA200, 0x7a, REG_BITS_8},
	{0xA201, 0x12, REG_BITS_8},
	{0xA202, 0x94, REG_BITS_8},
	{0xA203, 0xa6, REG_BITS_8},
	{0xA204, 0x58, REG_BITS_8},
	{0xA205, 0x05, REG_BITS_8},
	{0xA206, 0x2d, REG_BITS_8},
	{0xA207, 0x61, REG_BITS_8},
	{0xA208, 0xb1, REG_BITS_8},
	{0xA209, 0x8b, REG_BITS_8},
	{0xA20A, 0x60, REG_BITS_8},
	{0xA20B, 0x22, REG_BITS_8},
	{0xA20C, 0xb3, REG_BITS_8},
	{0xA20D, 0x97, REG_BITS_8},
	{0xA20E, 0xc4, REG_BITS_8},
	{0xA20F, 0x7c, REG_BITS_8},
	{0xA210, 0x45, REG_BITS_8},
	{0xA211, 0x2d, REG_BITS_8},
	{0xA212, 0x51, REG_BITS_8},
	{0xA213, 0xf1, REG_BITS_8},
	{0xA214, 0x4a, REG_BITS_8},
	{0xA215, 0x53, REG_BITS_8},
	{0xA216, 0xb2, REG_BITS_8},
	{0xA217, 0x02, REG_BITS_8},
	{0xA218, 0x15, REG_BITS_8},
	{0xA219, 0xaf, REG_BITS_8},
	{0xA21A, 0x70, REG_BITS_8},
	{0xA21B, 0xe5, REG_BITS_8},
	{0xA21C, 0x2d, REG_BITS_8},
	{0xA21D, 0x78, REG_BITS_8},
	{0xA21E, 0x79, REG_BITS_8},
	{0xA21F, 0xcc, REG_BITS_8},
	{0xA220, 0x5f, REG_BITS_8},
	{0xA221, 0x2e, REG_BITS_8},
	{0xA222, 0x73, REG_BITS_8},
	{0xA223, 0x99, REG_BITS_8},
	{0xA224, 0xd4, REG_BITS_8},
	{0xA225, 0x6c, REG_BITS_8},
	{0xA226, 0xa6, REG_BITS_8},
	{0xA227, 0x35, REG_BITS_8},
	{0xA228, 0x8b, REG_BITS_8},
	{0xA229, 0xe9, REG_BITS_8},
	{0xA22A, 0x4c, REG_BITS_8},
	{0xA22B, 0x5f, REG_BITS_8},
	{0xA22C, 0x1e, REG_BITS_8},
	{0xA22D, 0x83, REG_BITS_8},
	{0xA22E, 0x17, REG_BITS_8},
	{0xA22F, 0xc5, REG_BITS_8},
	{0xA230, 0xf0, REG_BITS_8},
	{0xA231, 0x05, REG_BITS_8},
	{0xA232, 0x32, REG_BITS_8},
	{0xA233, 0x89, REG_BITS_8},
	{0xA234, 0x09, REG_BITS_8},
	{0xA235, 0x0d, REG_BITS_8},
	{0xA236, 0x67, REG_BITS_8},
	{0xA237, 0x6a, REG_BITS_8},
	{0xA238, 0x73, REG_BITS_8},
	{0xA239, 0x19, REG_BITS_8},
	{0xA23A, 0xd8, REG_BITS_8},
	{0xA23B, 0xec, REG_BITS_8},
	{0xA23C, 0x65, REG_BITS_8},
	{0xA23D, 0x31, REG_BITS_8},
	{0xA23E, 0x8e, REG_BITS_8},
	{0xA23F, 0x09, REG_BITS_8},
	{0xA240, 0x8d, REG_BITS_8},
	{0xA241, 0x63, REG_BITS_8},
	{0xA242, 0x42, REG_BITS_8},
	{0xA243, 0x23, REG_BITS_8},
	{0xA244, 0x98, REG_BITS_8},
	{0xA245, 0xca, REG_BITS_8},
	{0xA246, 0x00, REG_BITS_8},
	{0xA247, 0x66, REG_BITS_8},
	{0xA248, 0x32, REG_BITS_8},
	{0xA249, 0x82, REG_BITS_8},
	{0xA24A, 0xb1, REG_BITS_8},
	{0xA24B, 0xcc, REG_BITS_8},
	{0xA24C, 0x63, REG_BITS_8},
	{0xA24D, 0x4e, REG_BITS_8},
	{0xA24E, 0x13, REG_BITS_8},
	{0xA24F, 0x19, REG_BITS_8},
	{0xA250, 0xd5, REG_BITS_8},
	{0xA251, 0xf8, REG_BITS_8},
	{0xA252, 0xc5, REG_BITS_8},
	{0xA253, 0x32, REG_BITS_8},
	{0xA254, 0x91, REG_BITS_8},
	{0xA255, 0x21, REG_BITS_8},
	{0xA256, 0x0d, REG_BITS_8},
	{0xA257, 0x68, REG_BITS_8},
	{0xA258, 0x20, REG_BITS_8},
	{0xA259, 0xd3, REG_BITS_8},
	{0xA25A, 0x98, REG_BITS_8},
	{0xA25B, 0xc9, REG_BITS_8},
	{0xA25C, 0x90, REG_BITS_8},
	{0xA25D, 0x26, REG_BITS_8},
	{0xA25E, 0x36, REG_BITS_8},
	{0xA25F, 0xa6, REG_BITS_8},
	{0xA260, 0x79, REG_BITS_8},
	{0xA261, 0xcd, REG_BITS_8},
	{0xA262, 0x6b, REG_BITS_8},
	{0xA263, 0x36, REG_BITS_8},
	{0xA264, 0x93, REG_BITS_8},
	{0xA265, 0x18, REG_BITS_8},
	{0xA266, 0xc2, REG_BITS_8},
	{0xA267, 0x2c, REG_BITS_8},
	{0xA268, 0xa6, REG_BITS_8},
	{0xA269, 0x33, REG_BITS_8},
	{0xA26A, 0xb8, REG_BITS_8},
	{0xA26B, 0xe1, REG_BITS_8},
	{0xA26C, 0x4d, REG_BITS_8},
	{0xA26D, 0x65, REG_BITS_8},
	{0xA26E, 0x0e, REG_BITS_8},
	{0xA26F, 0x53, REG_BITS_8},
	{0xA270, 0x16, REG_BITS_8},
	{0xA271, 0xaa, REG_BITS_8},
	{0xA272, 0x38, REG_BITS_8},
	{0xA273, 0xa5, REG_BITS_8},
	{0xA274, 0x2a, REG_BITS_8},
	{0xA275, 0x68, REG_BITS_8},
	{0xA276, 0x69, REG_BITS_8},
	{0xA277, 0x8c, REG_BITS_8},
	{0xA278, 0x66, REG_BITS_8},
	{0xA279, 0xe8, REG_BITS_8},
	{0xA27A, 0x12, REG_BITS_8},
	{0xA27B, 0x16, REG_BITS_8},
	{0xA27C, 0xa2, REG_BITS_8},
	{0xA27D, 0xc4, REG_BITS_8},
	{0xA27E, 0x64, REG_BITS_8},
	{0xA27F, 0x25, REG_BITS_8},
	{0xA280, 0x33, REG_BITS_8},
	{0xA281, 0x31, REG_BITS_8},
	{0xA282, 0x4a, REG_BITS_8},
	{0xA283, 0x59, REG_BITS_8},
	{0xA284, 0xf0, REG_BITS_8},
	{0xA285, 0x02, REG_BITS_8},
	{0xA286, 0x96, REG_BITS_8},
	{0xA287, 0xa6, REG_BITS_8},
	{0xA288, 0xb4, REG_BITS_8},
	{0xA289, 0x44, REG_BITS_8},
	{0xA28A, 0x22, REG_BITS_8},
	{0xA28B, 0x0a, REG_BITS_8},
	{0xA28C, 0x99, REG_BITS_8},
	{0xA28D, 0xc8, REG_BITS_8},
	{0xA28E, 0x4b, REG_BITS_8},
	{0xA28F, 0xa4, REG_BITS_8},
	{0xA290, 0x42, REG_BITS_8},
	{0xA291, 0x16, REG_BITS_8},
	{0xA292, 0xab, REG_BITS_8},
	{0xA293, 0x18, REG_BITS_8},
	{0xA294, 0x25, REG_BITS_8},
	{0xA295, 0x24, REG_BITS_8},
	{0xA296, 0x06, REG_BITS_8},
	{0xA297, 0xe9, REG_BITS_8},
	{0xA298, 0xc7, REG_BITS_8},
	{0xA299, 0x41, REG_BITS_8},
	{0xA29A, 0x48, REG_BITS_8},
	{0xA29B, 0xa2, REG_BITS_8},
	{0xA29C, 0x94, REG_BITS_8},
	{0xA29D, 0xac, REG_BITS_8},
	{0xA29E, 0x60, REG_BITS_8},
	{0xA29F, 0x05, REG_BITS_8},
	{0xA2A0, 0x29, REG_BITS_8},
	{0xA2A1, 0x24, REG_BITS_8},
	{0xA2A2, 0x49, REG_BITS_8},
	{0xA2A3, 0x88, REG_BITS_8},
	{0xA2A4, 0x40, REG_BITS_8},
	{0xA2A5, 0x16, REG_BITS_8},
	{0xA2A6, 0x82, REG_BITS_8},
	{0xA2A7, 0x12, REG_BITS_8},
	{0xA2A8, 0xa6, REG_BITS_8},
	{0xA2A9, 0x6c, REG_BITS_8},
	{0xA2AA, 0x25, REG_BITS_8},
	{0xA2AB, 0x2d, REG_BITS_8},
	{0xA2AC, 0x55, REG_BITS_8},
	{0xA2AD, 0xa9, REG_BITS_8},
	{0xA2AE, 0x09, REG_BITS_8},
	{0xA2AF, 0x47, REG_BITS_8},
	{0xA2B0, 0x28, REG_BITS_8},
	{0xA2B1, 0xd2, REG_BITS_8},
	{0xA2B2, 0x91, REG_BITS_8},
	{0xA2B3, 0x9c, REG_BITS_8},
	{0xA2B4, 0x68, REG_BITS_8},
	{0xA2B5, 0x85, REG_BITS_8},
	{0xA2B6, 0x2d, REG_BITS_8},
	{0xA2B7, 0x83, REG_BITS_8},
	{0xA2B8, 0x79, REG_BITS_8},
	{0xA2B9, 0x8b, REG_BITS_8},
	{0xA2BA, 0x54, REG_BITS_8},
	{0xA2BB, 0x82, REG_BITS_8},
	{0xA2BC, 0xa2, REG_BITS_8},
	{0xA2BD, 0x13, REG_BITS_8},
	{0xA2BE, 0xa1, REG_BITS_8},
	{0xA2BF, 0x58, REG_BITS_8},
	{0xA2C0, 0xa5, REG_BITS_8},
	{0xA2C1, 0x2e, REG_BITS_8},
	{0xA2C2, 0x88, REG_BITS_8},
	{0xA2C3, 0x41, REG_BITS_8},
	{0xA2C4, 0xcd, REG_BITS_8},
	{0xA2C5, 0x66, REG_BITS_8},
	{0xA2C6, 0xf0, REG_BITS_8},
	{0xA2C7, 0x62, REG_BITS_8},
	{0xA2C8, 0x16, REG_BITS_8},
	{0xA2C9, 0xb1, REG_BITS_8},
	{0xA2CA, 0xa0, REG_BITS_8},
	{0xA2CB, 0x85, REG_BITS_8},
	{0xA2CC, 0x2f, REG_BITS_8},
	{0xA2CD, 0xa4, REG_BITS_8},
	{0xA2CE, 0x81, REG_BITS_8},
	{0xA2CF, 0x4d, REG_BITS_8},
	{0xA2D0, 0x70, REG_BITS_8},
	{0xA2D1, 0x88, REG_BITS_8},
	{0xA2D2, 0xf3, REG_BITS_8},
	{0xA2D3, 0x1a, REG_BITS_8},
	{0xA2D4, 0xcf, REG_BITS_8},
	{0xA2D5, 0x6c, REG_BITS_8},
	{0xA2D6, 0x26, REG_BITS_8},
	{0xA2D7, 0x34, REG_BITS_8},
	{0xA2D8, 0xb4, REG_BITS_8},
	{0xA2D9, 0x89, REG_BITS_8},
	{0xA2DA, 0xce, REG_BITS_8},
	{0xA2DB, 0x73, REG_BITS_8},
	{0xA2DC, 0x42, REG_BITS_8},
	{0xA2DD, 0x63, REG_BITS_8},
	{0xA2DE, 0x9b, REG_BITS_8},
	{0xA2DF, 0xda, REG_BITS_8},
	{0xA2E0, 0xa4, REG_BITS_8},
	{0xA2E1, 0xe6, REG_BITS_8},
	{0xA2E2, 0x34, REG_BITS_8},
	{0xA2E3, 0xab, REG_BITS_8},
	{0xA2E4, 0xd9, REG_BITS_8},
	{0xA2E5, 0x4d, REG_BITS_8},
	{0xA2E6, 0x71, REG_BITS_8},
	{0xA2E7, 0x64, REG_BITS_8},
	{0xA2E8, 0x03, REG_BITS_8},
	{0xA2E9, 0x13, REG_BITS_8},
	{0xA2EA, 0xbc, REG_BITS_8},
	{0xA2EB, 0x44, REG_BITS_8},
	{0xA2EC, 0x14, REG_BITS_8},
	{0xA2ED, 0xa6, REG_BITS_8},
	{0xA2EE, 0xc6, REG_BITS_8},
	{0xA2EF, 0xc9, REG_BITS_8},
	{0xA2F0, 0x4e, REG_BITS_8},
	{0xA2F1, 0x75, REG_BITS_8},
	{0xA2F2, 0x80, REG_BITS_8},
	{0xA2F3, 0xc3, REG_BITS_8},
	{0xA2F4, 0x9b, REG_BITS_8},
	{0xA2F5, 0xe1, REG_BITS_8},
	{0xA2F6, 0x60, REG_BITS_8},
	{0xA2F7, 0xe7, REG_BITS_8},
	{0xA2F8, 0x3c, REG_BITS_8},
	{0xA2F9, 0xde, REG_BITS_8},
	{0xA2FA, 0x31, REG_BITS_8},
	{0xA2FB, 0x0f, REG_BITS_8},
	{0xA2FC, 0x79, REG_BITS_8},
	{0xA2FD, 0x96, REG_BITS_8},
	{0xA2FE, 0x43, REG_BITS_8},
	{0xA2FF, 0x1b, REG_BITS_8},
	{0xA300, 0xd7, REG_BITS_8},
	{0xA301, 0xd8, REG_BITS_8},
	{0xA302, 0xa6, REG_BITS_8},
	{0xA303, 0x39, REG_BITS_8},
	{0xA304, 0xee, REG_BITS_8},
	{0xA305, 0x99, REG_BITS_8},
	{0xA306, 0x4f, REG_BITS_8},
	{0xA307, 0x71, REG_BITS_8},
	{0xA308, 0x64, REG_BITS_8},
	{0xA309, 0x83, REG_BITS_8},
	{0xA30A, 0x98, REG_BITS_8},
	{0xA30B, 0xb8, REG_BITS_8},
	{0xA30C, 0xa8, REG_BITS_8},
	{0xA30D, 0x65, REG_BITS_8},
	{0xA30E, 0x2e, REG_BITS_8},
	{0xA30F, 0x8a, REG_BITS_8},
	{0xA310, 0xc1, REG_BITS_8},
	{0xA311, 0x4d, REG_BITS_8},
	{0xA312, 0x72, REG_BITS_8},
	{0xA313, 0x38, REG_BITS_8},
	{0xA314, 0x13, REG_BITS_8},
	{0xA315, 0x18, REG_BITS_8},
	{0xA316, 0xae, REG_BITS_8},
	{0xA317, 0x04, REG_BITS_8},
	{0xA318, 0x25, REG_BITS_8},
	{0xA319, 0x27, REG_BITS_8},
	{0xA31A, 0x44, REG_BITS_8},
	{0xA31B, 0xf1, REG_BITS_8},
	{0xA31C, 0x8a, REG_BITS_8},
	{0xA31D, 0x61, REG_BITS_8},
	{0xA31E, 0x3e, REG_BITS_8},
	{0xA31F, 0x23, REG_BITS_8},
	{0xA320, 0x98, REG_BITS_8},
	{0xA321, 0xb3, REG_BITS_8},
	{0xA322, 0xec, REG_BITS_8},
	{0xA323, 0x24, REG_BITS_8},
	{0xA324, 0x23, REG_BITS_8},
	{0xA325, 0x0f, REG_BITS_8},
	{0xA326, 0xd1, REG_BITS_8},
	{0xA327, 0x48, REG_BITS_8},
	{0xA328, 0x4f, REG_BITS_8},
	{0xA329, 0xd6, REG_BITS_8},
	{0xA32A, 0x42, REG_BITS_8},
	{0xA32B, 0x18, REG_BITS_8},
	{0xA32C, 0xbb, REG_BITS_8},
	{0xA32D, 0x74, REG_BITS_8},
	{0xA32E, 0x85, REG_BITS_8},
	{0xA32F, 0x25, REG_BITS_8},
	{0xA330, 0x08, REG_BITS_8},
	{0xA331, 0xe9, REG_BITS_8},
	{0xA332, 0x07, REG_BITS_8},
	{0xA333, 0x42, REG_BITS_8},
	{0xA334, 0x5a, REG_BITS_8},
	{0xA335, 0xf2, REG_BITS_8},
	{0xA336, 0x95, REG_BITS_8},
	{0xA337, 0xba, REG_BITS_8},
	{0xA338, 0xe4, REG_BITS_8},
	{0xA339, 0x25, REG_BITS_8},
	{0xA33A, 0x2c, REG_BITS_8},
	{0xA33B, 0x31, REG_BITS_8},
	{0xA33C, 0x61, REG_BITS_8},
	{0xA33D, 0x88, REG_BITS_8},
	{0xA33E, 0x40, REG_BITS_8},
	{0xA33F, 0x18, REG_BITS_8},
	{0xA340, 0x02, REG_BITS_8},
	{0xA341, 0x13, REG_BITS_8},
	{0xA342, 0xb0, REG_BITS_8},
	{0xA343, 0xd8, REG_BITS_8},
	{0xA344, 0xc5, REG_BITS_8},
	{0xA345, 0x31, REG_BITS_8},
	{0xA346, 0x73, REG_BITS_8},
	{0xA347, 0x31, REG_BITS_8},
	{0xA348, 0x0a, REG_BITS_8},
	{0xA349, 0x49, REG_BITS_8},
	{0xA34A, 0x32, REG_BITS_8},
	{0xA34B, 0x42, REG_BITS_8},
	{0xA34C, 0x92, REG_BITS_8},
	{0xA34D, 0xa3, REG_BITS_8},
	{0xA34E, 0xc8, REG_BITS_8},
	{0xA34F, 0x65, REG_BITS_8},
	{0xA350, 0x31, REG_BITS_8},
	{0xA351, 0xaa, REG_BITS_8},
	{0xA352, 0x81, REG_BITS_8},
	{0xA353, 0x8c, REG_BITS_8},
	{0xA354, 0x5a, REG_BITS_8},
	{0xA355, 0xa0, REG_BITS_8},
	{0xA356, 0x82, REG_BITS_8},
	{0xA357, 0x94, REG_BITS_8},
	{0xA358, 0xa8, REG_BITS_8},
	{0xA359, 0xac, REG_BITS_8},
	{0xA35A, 0x65, REG_BITS_8},
	{0xA35B, 0x32, REG_BITS_8},
	{0xA35C, 0xac, REG_BITS_8},
	{0xA35D, 0x91, REG_BITS_8},
	{0xA35E, 0x8e, REG_BITS_8},
	{0xA35F, 0x70, REG_BITS_8},
	{0xA360, 0x2e, REG_BITS_8},
	{0xA361, 0x13, REG_BITS_8},
	{0xA362, 0x18, REG_BITS_8},
	{0xA363, 0xbd, REG_BITS_8},
	{0xA364, 0x0c, REG_BITS_8},
	{0xA365, 0x66, REG_BITS_8},
	{0xA366, 0x33, REG_BITS_8},
	{0xA367, 0xca, REG_BITS_8},
	{0xA368, 0xd1, REG_BITS_8},
	{0xA369, 0xce, REG_BITS_8},
	{0xA36A, 0x7b, REG_BITS_8},
	{0xA36B, 0xe0, REG_BITS_8},
	{0xA36C, 0x83, REG_BITS_8},
	{0xA36D, 0x1d, REG_BITS_8},
	{0xA36E, 0xe2, REG_BITS_8},
	{0xA36F, 0xf8, REG_BITS_8},
	{0xA370, 0xe6, REG_BITS_8},
	{0xA371, 0x38, REG_BITS_8},
	{0xA372, 0xdd, REG_BITS_8},
	{0xA373, 0xf1, REG_BITS_8},
	{0xA374, 0x4f, REG_BITS_8},
	{0xA375, 0x7f, REG_BITS_8},
	{0xA376, 0x96, REG_BITS_8},
	{0xA377, 0x33, REG_BITS_8},
	{0xA378, 0x1e, REG_BITS_8},
	{0xA379, 0xf0, REG_BITS_8},
	{0xA37A, 0x44, REG_BITS_8},
	{0xA37B, 0xe7, REG_BITS_8},
	{0xA37C, 0x39, REG_BITS_8},
	{0xA37D, 0xd4, REG_BITS_8},
	{0xA37E, 0x39, REG_BITS_8},
	{0xA37F, 0x4f, REG_BITS_8},
	{0xA380, 0x7c, REG_BITS_8},
	{0xA381, 0xbc, REG_BITS_8},
	{0xA382, 0xb3, REG_BITS_8},
	{0xA383, 0x17, REG_BITS_8},
	{0xA384, 0xc5, REG_BITS_8},
	{0xA385, 0x1c, REG_BITS_8},
	{0xA386, 0x06, REG_BITS_8},
	{0xA387, 0x2f, REG_BITS_8},
	{0xA388, 0x7b, REG_BITS_8},
	{0xA389, 0x51, REG_BITS_8},
	{0xA38A, 0xcc, REG_BITS_8},
	{0xA38B, 0x61, REG_BITS_8},
	{0xA38C, 0xf0, REG_BITS_8},
	{0xA38D, 0x72, REG_BITS_8},
	{0xA38E, 0x17, REG_BITS_8},
	{0xA38F, 0xbe, REG_BITS_8},
	{0xA390, 0x48, REG_BITS_8},
	{0xA391, 0x46, REG_BITS_8},
	{0xA392, 0x34, REG_BITS_8},
	{0xA393, 0x9c, REG_BITS_8},
	{0xA394, 0xa9, REG_BITS_8},
	{0xA395, 0xcc, REG_BITS_8},
	{0xA396, 0x64, REG_BITS_8},
	{0xA397, 0x04, REG_BITS_8},
	{0xA398, 0x23, REG_BITS_8},
	{0xA399, 0x17, REG_BITS_8},
	{0xA39A, 0xb8, REG_BITS_8},
	{0xA39B, 0xd4, REG_BITS_8},
	{0xA39C, 0x45, REG_BITS_8},
	{0xA39D, 0x31, REG_BITS_8},
	{0xA39E, 0xa6, REG_BITS_8},
	{0xA39F, 0x49, REG_BITS_8},
	{0xA3A0, 0xcd, REG_BITS_8},
	{0xA3A1, 0x5f, REG_BITS_8},
	{0xA3A2, 0xea, REG_BITS_8},
	{0xA3A3, 0x72, REG_BITS_8},
	{0xA3A4, 0x95, REG_BITS_8},
	{0xA3A5, 0xa4, REG_BITS_8},
	{0xA3A6, 0x18, REG_BITS_8},
	{0xA3A7, 0x65, REG_BITS_8},
	{0xA3A8, 0x29, REG_BITS_8},
	{0xA3A9, 0x5d, REG_BITS_8},
	{0xA3AA, 0xf1, REG_BITS_8},
	{0xA3AB, 0xcb, REG_BITS_8},
	{0xA3AC, 0x61, REG_BITS_8},
	{0xA3AD, 0xbe, REG_BITS_8},
	{0xA3AE, 0x12, REG_BITS_8},
	{0xA3AF, 0x15, REG_BITS_8},
	{0xA3B0, 0x9e, REG_BITS_8},
	{0xA3B1, 0xb4, REG_BITS_8},
	{0xA3B2, 0x04, REG_BITS_8},
	{0xA3B3, 0x25, REG_BITS_8},
	{0xA3B4, 0x2f, REG_BITS_8},
	{0xA3B5, 0x01, REG_BITS_8},
	{0xA3B6, 0x0a, REG_BITS_8},
	{0xA3B7, 0x57, REG_BITS_8},
	{0xA3B8, 0xd6, REG_BITS_8},
	{0xA3B9, 0xf2, REG_BITS_8},
	{0xA3BA, 0x14, REG_BITS_8},
	{0xA3BB, 0xa0, REG_BITS_8},
	{0xA3BC, 0xa0, REG_BITS_8},
	{0xA3BD, 0x44, REG_BITS_8},
	{0xA3BE, 0x22, REG_BITS_8},
	{0xA3BF, 0x0c, REG_BITS_8},
	{0xA3C0, 0xa9, REG_BITS_8},
	{0xA3C1, 0x48, REG_BITS_8},
	{0xA3C2, 0x4b, REG_BITS_8},
	{0xA3C3, 0x8e, REG_BITS_8},
	{0xA3C4, 0x32, REG_BITS_8},
	{0xA3C5, 0x95, REG_BITS_8},
	{0xA3C6, 0xa3, REG_BITS_8},
	{0xA3C7, 0xec, REG_BITS_8},
	{0xA3C8, 0x84, REG_BITS_8},
	{0xA3C9, 0x23, REG_BITS_8},
	{0xA3CA, 0x04, REG_BITS_8},
	{0xA3CB, 0xf9, REG_BITS_8},
	{0xA3CC, 0xc7, REG_BITS_8},
	{0xA3CD, 0x41, REG_BITS_8},
	{0xA3CE, 0x42, REG_BITS_8},
	{0xA3CF, 0xf2, REG_BITS_8},
	{0xA3D0, 0x93, REG_BITS_8},
	{0xA3D1, 0xa3, REG_BITS_8},
	{0xA3D2, 0x34, REG_BITS_8},
	{0xA3D3, 0x25, REG_BITS_8},
	{0xA3D4, 0x28, REG_BITS_8},
	{0xA3D5, 0x22, REG_BITS_8},
	{0xA3D6, 0x49, REG_BITS_8},
	{0xA3D7, 0x08, REG_BITS_8},
	{0xA3D8, 0x40, REG_BITS_8},
	{0xA3D9, 0x0e, REG_BITS_8},
	{0xA3DA, 0x22, REG_BITS_8},
	{0xA3DB, 0x92, REG_BITS_8},
	{0xA3DC, 0x9f, REG_BITS_8},
	{0xA3DD, 0x1c, REG_BITS_8},
	{0xA3DE, 0x45, REG_BITS_8},
	{0xA3DF, 0x2b, REG_BITS_8},
	{0xA3E0, 0x4c, REG_BITS_8},
	{0xA3E1, 0x89, REG_BITS_8},
	{0xA3E2, 0x09, REG_BITS_8},
	{0xA3E3, 0x46, REG_BITS_8},
	{0xA3E4, 0x22, REG_BITS_8},
	{0xA3E5, 0x72, REG_BITS_8},
	{0xA3E6, 0x11, REG_BITS_8},
	{0xA3E7, 0x96, REG_BITS_8},
	{0xA3E8, 0x20, REG_BITS_8},
	{0xA3E9, 0xa5, REG_BITS_8},
	{0xA3EA, 0x2a, REG_BITS_8},
	{0xA3EB, 0x70, REG_BITS_8},
	{0xA3EC, 0xf9, REG_BITS_8},
	{0xA3ED, 0x8a, REG_BITS_8},
	{0xA3EE, 0x51, REG_BITS_8},
	{0xA3EF, 0x66, REG_BITS_8},
	{0xA3F0, 0x02, REG_BITS_8},
	{0xA3F1, 0x13, REG_BITS_8},
	{0xA3F2, 0x9a, REG_BITS_8},
	{0xA3F3, 0x04, REG_BITS_8},
	{0xA3F4, 0x45, REG_BITS_8},
	{0xA3F5, 0x2b, REG_BITS_8},
	{0xA3F6, 0x67, REG_BITS_8},
	{0xA3F7, 0x59, REG_BITS_8},
	{0xA3F8, 0x0c, REG_BITS_8},
	{0xA3F9, 0x60, REG_BITS_8},
	{0xA3FA, 0xc4, REG_BITS_8},
	{0xA3FB, 0x12, REG_BITS_8},
	{0xA3FC, 0x95, REG_BITS_8},
	{0xA3FD, 0xa6, REG_BITS_8},
	{0xA3FE, 0x40, REG_BITS_8},
	{0xA3FF, 0xa5, REG_BITS_8},
	{0xA400, 0x2b, REG_BITS_8},
	{0xA401, 0x7e, REG_BITS_8},
	{0xA402, 0x39, REG_BITS_8},
	{0xA403, 0xcc, REG_BITS_8},
	{0xA404, 0x67, REG_BITS_8},
	{0xA405, 0x3e, REG_BITS_8},
	{0xA406, 0xc3, REG_BITS_8},
	{0xA407, 0x98, REG_BITS_8},
	{0xA408, 0xbd, REG_BITS_8},
	{0xA409, 0xdc, REG_BITS_8},
	{0xA40A, 0x85, REG_BITS_8},
	{0xA40B, 0x2f, REG_BITS_8},
	{0xA40C, 0x8d, REG_BITS_8},
	{0xA40D, 0x29, REG_BITS_8},
	{0xA40E, 0x0d, REG_BITS_8},
	{0xA40F, 0x69, REG_BITS_8},
	{0xA410, 0x0e, REG_BITS_8},
	{0xA411, 0x73, REG_BITS_8},
	{0xA412, 0x19, REG_BITS_8},
	{0xA413, 0xc9, REG_BITS_8},
	{0xA414, 0x0c, REG_BITS_8},
	{0xA415, 0x06, REG_BITS_8},
	{0xA416, 0x30, REG_BITS_8},
	{0xA417, 0x83, REG_BITS_8},
	{0xA418, 0x91, REG_BITS_8},
	{0xA419, 0x8c, REG_BITS_8},
	{0xA41A, 0x67, REG_BITS_8},
	{0xA41B, 0x1a, REG_BITS_8},
	{0xA41C, 0x03, REG_BITS_8},
	{0xA41D, 0x00, REG_BITS_8},
	{0xA41E, 0x00, REG_BITS_8},
	{0xA41F, 0x00, REG_BITS_8},
	{0xA420, 0x00, REG_BITS_8},
	{0xA421, 0x04, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_SHD_2_ES2 = sizeof(seix006_vendor_0_SHD_2_ES2);

const struct reg_entry seix006_vendor_0_SHD_3_ES2[] = {
	{0x0068, 0x50, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x03, REG_BITS_8},
	{0x9003, 0x0c, REG_BITS_8},
	{0x9004, 0x0c, REG_BITS_8},
	{0x9005, 0x30, REG_BITS_8},
	{0x9006, 0x20, REG_BITS_8},
	{0x9007, 0x00, REG_BITS_8},
	{0x9008, 0x41, REG_BITS_8},
	{0x9009, 0x80, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x02, REG_BITS_8},
	{0x900C, 0x12, REG_BITS_8},
	{0x900D, 0x08, REG_BITS_8},
	{0x900E, 0x50, REG_BITS_8},
	{0x900F, 0x20, REG_BITS_8},
	{0x9010, 0x20, REG_BITS_8},
	{0x9011, 0x01, REG_BITS_8},
	{0x9012, 0x81, REG_BITS_8},
	{0x9013, 0x05, REG_BITS_8},
	{0x9014, 0x04, REG_BITS_8},
	{0x9015, 0x16, REG_BITS_8},
	{0x9016, 0x0c, REG_BITS_8},
	{0x9017, 0x30, REG_BITS_8},
	{0x9018, 0x30, REG_BITS_8},
	{0x9019, 0xc0, REG_BITS_8},
	{0x901A, 0x80, REG_BITS_8},
	{0x901B, 0x00, REG_BITS_8},
	{0x901C, 0x04, REG_BITS_8},
	{0x901D, 0x01, REG_BITS_8},
	{0x901E, 0x12, REG_BITS_8},
	{0x901F, 0x08, REG_BITS_8},
	{0x9020, 0x48, REG_BITS_8},
	{0x9021, 0x20, REG_BITS_8},
	{0x9022, 0x40, REG_BITS_8},
	{0x9023, 0x81, REG_BITS_8},
	{0x9024, 0x80, REG_BITS_8},
	{0x9025, 0x04, REG_BITS_8},
	{0x9026, 0x04, REG_BITS_8},
	{0x9027, 0x16, REG_BITS_8},
	{0x9028, 0x10, REG_BITS_8},
	{0x9029, 0x58, REG_BITS_8},
	{0x902A, 0x30, REG_BITS_8},
	{0x902B, 0x00, REG_BITS_8},
	{0x902C, 0xc1, REG_BITS_8},
	{0x902D, 0x00, REG_BITS_8},
	{0x902E, 0x04, REG_BITS_8},
	{0x902F, 0x00, REG_BITS_8},
	{0x9030, 0x0c, REG_BITS_8},
	{0x9031, 0x04, REG_BITS_8},
	{0x9032, 0x38, REG_BITS_8},
	{0x9033, 0x20, REG_BITS_8},
	{0x9034, 0x20, REG_BITS_8},
	{0x9035, 0xc1, REG_BITS_8},
	{0x9036, 0x00, REG_BITS_8},
	{0x9037, 0x04, REG_BITS_8},
	{0x9038, 0x04, REG_BITS_8},
	{0x9039, 0x12, REG_BITS_8},
	{0x903A, 0x0c, REG_BITS_8},
	{0x903B, 0x48, REG_BITS_8},
	{0x903C, 0x30, REG_BITS_8},
	{0x903D, 0x20, REG_BITS_8},
	{0x903E, 0x01, REG_BITS_8},
	{0x903F, 0x00, REG_BITS_8},
	{0x9040, 0x03, REG_BITS_8},
	{0x9041, 0x00, REG_BITS_8},
	{0x9042, 0x0c, REG_BITS_8},
	{0x9043, 0x10, REG_BITS_8},
	{0x9044, 0x30, REG_BITS_8},
	{0x9045, 0x10, REG_BITS_8},
	{0x9046, 0x80, REG_BITS_8},
	{0x9047, 0x80, REG_BITS_8},
	{0x9048, 0x00, REG_BITS_8},
	{0x9049, 0x02, REG_BITS_8},
	{0x904A, 0x03, REG_BITS_8},
	{0x904B, 0x0c, REG_BITS_8},
	{0x904C, 0x04, REG_BITS_8},
	{0x904D, 0x40, REG_BITS_8},
	{0x904E, 0x30, REG_BITS_8},
	{0x904F, 0x20, REG_BITS_8},
	{0x9050, 0xc1, REG_BITS_8},
	{0x9051, 0x80, REG_BITS_8},
	{0x9052, 0x04, REG_BITS_8},
	{0x9053, 0x02, REG_BITS_8},
	{0x9054, 0x0a, REG_BITS_8},
	{0x9055, 0x08, REG_BITS_8},
	{0x9056, 0x28, REG_BITS_8},
	{0x9057, 0x30, REG_BITS_8},
	{0x9058, 0x80, REG_BITS_8},
	{0x9059, 0xc0, REG_BITS_8},
	{0x905A, 0x00, REG_BITS_8},
	{0x905B, 0x02, REG_BITS_8},
	{0x905C, 0x02, REG_BITS_8},
	{0x905D, 0x04, REG_BITS_8},
	{0x905E, 0x04, REG_BITS_8},
	{0x905F, 0x20, REG_BITS_8},
	{0x9060, 0x30, REG_BITS_8},
	{0x9061, 0xc0, REG_BITS_8},
	{0x9062, 0x80, REG_BITS_8},
	{0x9063, 0x00, REG_BITS_8},
	{0x9064, 0x04, REG_BITS_8},
	{0x9065, 0x02, REG_BITS_8},
	{0x9066, 0x10, REG_BITS_8},
	{0x9067, 0x0c, REG_BITS_8},
	{0x9068, 0x18, REG_BITS_8},
	{0x9069, 0x30, REG_BITS_8},
	{0x906A, 0x60, REG_BITS_8},
	{0x906B, 0x80, REG_BITS_8},
	{0x906C, 0x80, REG_BITS_8},
	{0x906D, 0x00, REG_BITS_8},
	{0x906E, 0x03, REG_BITS_8},
	{0x906F, 0x00, REG_BITS_8},
	{0x9070, 0x08, REG_BITS_8},
	{0x9071, 0x00, REG_BITS_8},
	{0x9072, 0x00, REG_BITS_8},
	{0x9073, 0x40, REG_BITS_8},
	{0x9074, 0x80, REG_BITS_8},
	{0x9075, 0x80, REG_BITS_8},
	{0x9076, 0x01, REG_BITS_8},
	{0x9077, 0x01, REG_BITS_8},
	{0x9078, 0x0e, REG_BITS_8},
	{0x9079, 0x04, REG_BITS_8},
	{0x907A, 0x38, REG_BITS_8},
	{0x907B, 0x30, REG_BITS_8},
	{0x907C, 0x40, REG_BITS_8},
	{0x907D, 0xc0, REG_BITS_8},
	{0x907E, 0x00, REG_BITS_8},
	{0x907F, 0x01, REG_BITS_8},
	{0x9080, 0x03, REG_BITS_8},
	{0x9081, 0x02, REG_BITS_8},
	{0x9082, 0x08, REG_BITS_8},
	{0x9083, 0x00, REG_BITS_8},
	{0x9084, 0x20, REG_BITS_8},
	{0x9085, 0xe0, REG_BITS_8},
	{0x9086, 0x7f, REG_BITS_8},
	{0x9087, 0x00, REG_BITS_8},
	{0x9088, 0x00, REG_BITS_8},
	{0x9089, 0x02, REG_BITS_8},
	{0x908A, 0x06, REG_BITS_8},
	{0x908B, 0x00, REG_BITS_8},
	{0x908C, 0x28, REG_BITS_8},
	{0x908D, 0x00, REG_BITS_8},
	{0x908E, 0xa0, REG_BITS_8},
	{0x908F, 0xc0, REG_BITS_8},
	{0x9090, 0x80, REG_BITS_8},
	{0x9091, 0x00, REG_BITS_8},
	{0x9092, 0x03, REG_BITS_8},
	{0x9093, 0x02, REG_BITS_8},
	{0x9094, 0x10, REG_BITS_8},
	{0x9095, 0x08, REG_BITS_8},
	{0x9096, 0x40, REG_BITS_8},
	{0x9097, 0xe0, REG_BITS_8},
	{0x9098, 0xff, REG_BITS_8},
	{0x9099, 0x00, REG_BITS_8},
	{0x909A, 0x00, REG_BITS_8},
	{0x909B, 0x04, REG_BITS_8},
	{0x909C, 0x02, REG_BITS_8},
	{0x909D, 0x0c, REG_BITS_8},
	{0x909E, 0x18, REG_BITS_8},
	{0x909F, 0x20, REG_BITS_8},
	{0x90A0, 0x80, REG_BITS_8},
	{0x90A1, 0x80, REG_BITS_8},
	{0x90A2, 0x00, REG_BITS_8},
	{0x90A3, 0x02, REG_BITS_8},
	{0x90A4, 0x03, REG_BITS_8},
	{0x90A5, 0x04, REG_BITS_8},
	{0x90A6, 0x0c, REG_BITS_8},
	{0x90A7, 0x10, REG_BITS_8},
	{0x90A8, 0x20, REG_BITS_8},
	{0x90A9, 0x60, REG_BITS_8},
	{0x90AA, 0x40, REG_BITS_8},
	{0x90AB, 0x81, REG_BITS_8},
	{0x90AC, 0x01, REG_BITS_8},
	{0x90AD, 0x04, REG_BITS_8},
	{0x90AE, 0x02, REG_BITS_8},
	{0x90AF, 0x0c, REG_BITS_8},
	{0x90B0, 0x18, REG_BITS_8},
	{0x90B1, 0x20, REG_BITS_8},
	{0x90B2, 0x80, REG_BITS_8},
	{0x90B3, 0x80, REG_BITS_8},
	{0x90B4, 0x80, REG_BITS_8},
	{0x90B5, 0x01, REG_BITS_8},
	{0x90B6, 0x02, REG_BITS_8},
	{0x90B7, 0x06, REG_BITS_8},
	{0x90B8, 0x04, REG_BITS_8},
	{0x90B9, 0x18, REG_BITS_8},
	{0x90BA, 0x10, REG_BITS_8},
	{0x90BB, 0x60, REG_BITS_8},
	{0x90BC, 0xc0, REG_BITS_8},
	{0x90BD, 0x00, REG_BITS_8},
	{0x90BE, 0x02, REG_BITS_8},
	{0x90BF, 0x04, REG_BITS_8},
	{0x90C0, 0x06, REG_BITS_8},
	{0x90C1, 0x10, REG_BITS_8},
	{0x90C2, 0x10, REG_BITS_8},
	{0x90C3, 0x20, REG_BITS_8},
	{0x90C4, 0x80, REG_BITS_8},
	{0x90C5, 0x40, REG_BITS_8},
	{0x90C6, 0x00, REG_BITS_8},
	{0x90C7, 0x03, REG_BITS_8},
	{0x90C8, 0x02, REG_BITS_8},
	{0x90C9, 0x08, REG_BITS_8},
	{0x90CA, 0x08, REG_BITS_8},
	{0x90CB, 0x20, REG_BITS_8},
	{0x90CC, 0x40, REG_BITS_8},
	{0x90CD, 0x60, REG_BITS_8},
	{0x90CE, 0x00, REG_BITS_8},
	{0x90CF, 0x81, REG_BITS_8},
	{0x90D0, 0x01, REG_BITS_8},
	{0x90D1, 0x03, REG_BITS_8},
	{0x90D2, 0x06, REG_BITS_8},
	{0x90D3, 0x0c, REG_BITS_8},
	{0x90D4, 0x20, REG_BITS_8},
	{0x90D5, 0x50, REG_BITS_8},
	{0x90D6, 0xc0, REG_BITS_8},
	{0x90D7, 0x40, REG_BITS_8},
	{0x90D8, 0x81, REG_BITS_8},
	{0x90D9, 0x02, REG_BITS_8},
	{0x90DA, 0x03, REG_BITS_8},
	{0x90DB, 0x08, REG_BITS_8},
	{0x90DC, 0x10, REG_BITS_8},
	{0x90DD, 0x28, REG_BITS_8},
	{0x90DE, 0x40, REG_BITS_8},
	{0x90DF, 0xa0, REG_BITS_8},
	{0x90E0, 0x00, REG_BITS_8},
	{0x90E1, 0x81, REG_BITS_8},
	{0x90E2, 0x01, REG_BITS_8},
	{0x90E3, 0x04, REG_BITS_8},
	{0x90E4, 0x06, REG_BITS_8},
	{0x90E5, 0x0c, REG_BITS_8},
	{0x90E6, 0x18, REG_BITS_8},
	{0x90E7, 0x30, REG_BITS_8},
	{0x90E8, 0x80, REG_BITS_8},
	{0x90E9, 0x40, REG_BITS_8},
	{0x90EA, 0x01, REG_BITS_8},
	{0x90EB, 0x03, REG_BITS_8},
	{0x90EC, 0x05, REG_BITS_8},
	{0x90ED, 0x0a, REG_BITS_8},
	{0x90EE, 0x0c, REG_BITS_8},
	{0x90EF, 0x20, REG_BITS_8},
	{0x90F0, 0x40, REG_BITS_8},
	{0x90F1, 0xa0, REG_BITS_8},
	{0x90F2, 0x00, REG_BITS_8},
	{0x90F3, 0x81, REG_BITS_8},
	{0x90F4, 0x02, REG_BITS_8},
	{0x90F5, 0x01, REG_BITS_8},
	{0x90F6, 0xec, REG_BITS_8},
	{0x90F7, 0x07, REG_BITS_8},
	{0x90F8, 0xb0, REG_BITS_8},
	{0x90F9, 0x1f, REG_BITS_8},
	{0x90FA, 0xa0, REG_BITS_8},
	{0x90FB, 0xbe, REG_BITS_8},
	{0x90FC, 0x00, REG_BITS_8},
	{0x90FD, 0xfb, REG_BITS_8},
	{0x90FE, 0x01, REG_BITS_8},
	{0x90FF, 0xf0, REG_BITS_8},
	{0x9100, 0x0b, REG_BITS_8},
	{0x9101, 0xa8, REG_BITS_8},
	{0x9102, 0x2f, REG_BITS_8},
	{0x9103, 0xe0, REG_BITS_8},
	{0x9104, 0xfe, REG_BITS_8},
	{0x9105, 0xff, REG_BITS_8},
	{0x9106, 0xfa, REG_BITS_8},
	{0x9107, 0xff, REG_BITS_8},
	{0x9108, 0xeb, REG_BITS_8},
	{0x9109, 0x07, REG_BITS_8},
	{0x910A, 0xb0, REG_BITS_8},
	{0x910B, 0x1f, REG_BITS_8},
	{0x910C, 0xc0, REG_BITS_8},
	{0x910D, 0x7e, REG_BITS_8},
	{0x910E, 0x80, REG_BITS_8},
	{0x910F, 0xfa, REG_BITS_8},
	{0x9110, 0x02, REG_BITS_8},
	{0x9111, 0xec, REG_BITS_8},
	{0x9112, 0x07, REG_BITS_8},
	{0x9113, 0xc0, REG_BITS_8},
	{0x9114, 0x2f, REG_BITS_8},
	{0x9115, 0xa0, REG_BITS_8},
	{0x9116, 0xbe, REG_BITS_8},
	{0x9117, 0x80, REG_BITS_8},
	{0x9118, 0xfb, REG_BITS_8},
	{0x9119, 0xff, REG_BITS_8},
	{0x911A, 0xeb, REG_BITS_8},
	{0x911B, 0xff, REG_BITS_8},
	{0x911C, 0xaf, REG_BITS_8},
	{0x911D, 0x3f, REG_BITS_8},
	{0x911E, 0xc0, REG_BITS_8},
	{0x911F, 0xfe, REG_BITS_8},
	{0x9120, 0x00, REG_BITS_8},
	{0x9121, 0xfb, REG_BITS_8},
	{0x9122, 0x01, REG_BITS_8},
	{0x9123, 0xf2, REG_BITS_8},
	{0x9124, 0x03, REG_BITS_8},
	{0x9125, 0xb0, REG_BITS_8},
	{0x9126, 0x0f, REG_BITS_8},
	{0x9127, 0xc0, REG_BITS_8},
	{0x9128, 0x3e, REG_BITS_8},
	{0x9129, 0x80, REG_BITS_8},
	{0x912A, 0xfc, REG_BITS_8},
	{0x912B, 0x00, REG_BITS_8},
	{0x912C, 0xf0, REG_BITS_8},
	{0x912D, 0x03, REG_BITS_8},
	{0x912E, 0xc0, REG_BITS_8},
	{0x912F, 0x0f, REG_BITS_8},
	{0x9130, 0x00, REG_BITS_8},
	{0x9131, 0xbf, REG_BITS_8},
	{0x9132, 0x80, REG_BITS_8},
	{0x9133, 0xfc, REG_BITS_8},
	{0x9134, 0x02, REG_BITS_8},
	{0x9135, 0xf2, REG_BITS_8},
	{0x9136, 0x0b, REG_BITS_8},
	{0x9137, 0xc0, REG_BITS_8},
	{0x9138, 0x0f, REG_BITS_8},
	{0x9139, 0x00, REG_BITS_8},
	{0x913A, 0xff, REG_BITS_8},
	{0x913B, 0xff, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0xff, REG_BITS_8},
	{0x913E, 0xf1, REG_BITS_8},
	{0x913F, 0xff, REG_BITS_8},
	{0x9140, 0xcf, REG_BITS_8},
	{0x9141, 0x1f, REG_BITS_8},
	{0x9142, 0xe0, REG_BITS_8},
	{0x9143, 0x7e, REG_BITS_8},
	{0x9144, 0x80, REG_BITS_8},
	{0x9145, 0xfb, REG_BITS_8},
	{0x9146, 0x04, REG_BITS_8},
	{0x9147, 0xf6, REG_BITS_8},
	{0x9148, 0x13, REG_BITS_8},
	{0x9149, 0xd8, REG_BITS_8},
	{0x914A, 0x1f, REG_BITS_8},
	{0x914B, 0x60, REG_BITS_8},
	{0x914C, 0x7f, REG_BITS_8},
	{0x914D, 0x80, REG_BITS_8},
	{0x914E, 0xfc, REG_BITS_8},
	{0x914F, 0x00, REG_BITS_8},
	{0x9150, 0xf2, REG_BITS_8},
	{0x9151, 0x03, REG_BITS_8},
	{0x9152, 0xd8, REG_BITS_8},
	{0x9153, 0x1f, REG_BITS_8},
	{0x9154, 0xe0, REG_BITS_8},
	{0x9155, 0x7e, REG_BITS_8},
	{0x9156, 0x80, REG_BITS_8},
	{0x9157, 0xfc, REG_BITS_8},
	{0x9158, 0x01, REG_BITS_8},
	{0x9159, 0xf2, REG_BITS_8},
	{0x915A, 0x0b, REG_BITS_8},
	{0x915B, 0xc0, REG_BITS_8},
	{0x915C, 0x2f, REG_BITS_8},
	{0x915D, 0x00, REG_BITS_8},
	{0x915E, 0xbf, REG_BITS_8},
	{0x915F, 0x00, REG_BITS_8},
	{0x9160, 0xfd, REG_BITS_8},
	{0x9161, 0x01, REG_BITS_8},
	{0x9162, 0xfa, REG_BITS_8},
	{0x9163, 0x07, REG_BITS_8},
	{0x9164, 0xe8, REG_BITS_8},
	{0x9165, 0xef, REG_BITS_8},
	{0x9166, 0x7f, REG_BITS_8},
	{0x9167, 0x7f, REG_BITS_8},
	{0x9168, 0x00, REG_BITS_8},
	{0x9169, 0xfe, REG_BITS_8},
	{0x916A, 0x02, REG_BITS_8},
	{0x916B, 0xfa, REG_BITS_8},
	{0x916C, 0x0b, REG_BITS_8},
	{0x916D, 0xe8, REG_BITS_8},
	{0x916E, 0x4f, REG_BITS_8},
	{0x916F, 0x60, REG_BITS_8},
	{0x9170, 0x3f, REG_BITS_8},
	{0x9171, 0x81, REG_BITS_8},
	{0x9172, 0xfd, REG_BITS_8},
	{0x9173, 0x03, REG_BITS_8},
	{0x9174, 0xfc, REG_BITS_8},
	{0x9175, 0x07, REG_BITS_8},
	{0x9176, 0xf0, REG_BITS_8},
	{0x9177, 0x0f, REG_BITS_8},
	{0x9178, 0xe0, REG_BITS_8},
	{0x9179, 0x7f, REG_BITS_8},
	{0x917A, 0x00, REG_BITS_8},
	{0x917B, 0xff, REG_BITS_8},
	{0x917C, 0x01, REG_BITS_8},
	{0x917D, 0xf8, REG_BITS_8},
	{0x917E, 0x0b, REG_BITS_8},
	{0x917F, 0xf0, REG_BITS_8},
	{0x9180, 0x2f, REG_BITS_8},
	{0x9181, 0xc0, REG_BITS_8},
	{0x9182, 0xbf, REG_BITS_8},
	{0x9183, 0x81, REG_BITS_8},
	{0x9184, 0x00, REG_BITS_8},
	{0x9185, 0x06, REG_BITS_8},
	{0x9186, 0x02, REG_BITS_8},
	{0x9187, 0x10, REG_BITS_8},
	{0x9188, 0x00, REG_BITS_8},
	{0x9189, 0x40, REG_BITS_8},
	{0x918A, 0x80, REG_BITS_8},
	{0x918B, 0x80, REG_BITS_8},
	{0x918C, 0x00, REG_BITS_8},
	{0x918D, 0x02, REG_BITS_8},
	{0x918E, 0x02, REG_BITS_8},
	{0x918F, 0x06, REG_BITS_8},
	{0x9190, 0x0c, REG_BITS_8},
	{0x9191, 0x00, REG_BITS_8},
	{0x9192, 0x30, REG_BITS_8},
	{0x9193, 0x20, REG_BITS_8},
	{0x9194, 0xc0, REG_BITS_8},
	{0x9195, 0x80, REG_BITS_8},
	{0x9196, 0x00, REG_BITS_8},
	{0x9197, 0x08, REG_BITS_8},
	{0x9198, 0xfe, REG_BITS_8},
	{0x9199, 0x23, REG_BITS_8},
	{0x919A, 0xf8, REG_BITS_8},
	{0x919B, 0x6f, REG_BITS_8},
	{0x919C, 0xa0, REG_BITS_8},
	{0x919D, 0x80, REG_BITS_8},
	{0x919E, 0x00, REG_BITS_8},
	{0x919F, 0x02, REG_BITS_8},
	{0x91A0, 0x02, REG_BITS_8},
	{0x91A1, 0x0e, REG_BITS_8},
	{0x91A2, 0x10, REG_BITS_8},
	{0x91A3, 0x30, REG_BITS_8},
	{0x91A4, 0x40, REG_BITS_8},
	{0x91A5, 0xa0, REG_BITS_8},
	{0x91A6, 0x00, REG_BITS_8},
	{0x91A7, 0x01, REG_BITS_8},
	{0x91A8, 0x01, REG_BITS_8},
	{0x91A9, 0x04, REG_BITS_8},
	{0x91AA, 0x04, REG_BITS_8},
	{0x91AB, 0x1c, REG_BITS_8},
	{0x91AC, 0x20, REG_BITS_8},
	{0x91AD, 0x70, REG_BITS_8},
	{0x91AE, 0x80, REG_BITS_8},
	{0x91AF, 0x40, REG_BITS_8},
	{0x91B0, 0x81, REG_BITS_8},
	{0x91B1, 0x02, REG_BITS_8},
	{0x91B2, 0x06, REG_BITS_8},
	{0x91B3, 0x0c, REG_BITS_8},
	{0x91B4, 0x10, REG_BITS_8},
	{0x91B5, 0x38, REG_BITS_8},
	{0x91B6, 0x30, REG_BITS_8},
	{0x91B7, 0xe0, REG_BITS_8},
	{0x91B8, 0x00, REG_BITS_8},
	{0x91B9, 0x81, REG_BITS_8},
	{0x91BA, 0x03, REG_BITS_8},
	{0x91BB, 0x02, REG_BITS_8},
	{0x91BC, 0x0a, REG_BITS_8},
	{0x91BD, 0x08, REG_BITS_8},
	{0x91BE, 0x28, REG_BITS_8},
	{0x91BF, 0x60, REG_BITS_8},
	{0x91C0, 0xc0, REG_BITS_8},
	{0x91C1, 0x80, REG_BITS_8},
	{0x91C2, 0x01, REG_BITS_8},
	{0x91C3, 0x03, REG_BITS_8},
	{0x91C4, 0x06, REG_BITS_8},
	{0x91C5, 0x06, REG_BITS_8},
	{0x91C6, 0x18, REG_BITS_8},
	{0x91C7, 0x40, REG_BITS_8},
	{0x91C8, 0x40, REG_BITS_8},
	{0x91C9, 0xe0, REG_BITS_8},
	{0x91CA, 0x40, REG_BITS_8},
	{0x91CB, 0x81, REG_BITS_8},
	{0x91CC, 0x03, REG_BITS_8},
	{0x91CD, 0x03, REG_BITS_8},
	{0x91CE, 0x10, REG_BITS_8},
	{0x91CF, 0x10, REG_BITS_8},
	{0x91D0, 0x30, REG_BITS_8},
	{0x91D1, 0x40, REG_BITS_8},
	{0x91D2, 0xc0, REG_BITS_8},
	{0x91D3, 0x80, REG_BITS_8},
	{0x91D4, 0x01, REG_BITS_8},
	{0x91D5, 0x03, REG_BITS_8},
	{0x91D6, 0x06, REG_BITS_8},
	{0x91D7, 0x0c, REG_BITS_8},
	{0x91D8, 0x18, REG_BITS_8},
	{0x91D9, 0x18, REG_BITS_8},
	{0x91DA, 0x60, REG_BITS_8},
	{0x91DB, 0x00, REG_BITS_8},
	{0x91DC, 0x01, REG_BITS_8},
	{0x91DD, 0x81, REG_BITS_8},
	{0x91DE, 0x03, REG_BITS_8},
	{0x91DF, 0x05, REG_BITS_8},
	{0x91E0, 0x0e, REG_BITS_8},
	{0x91E1, 0x0c, REG_BITS_8},
	{0x91E2, 0x40, REG_BITS_8},
	{0x91E3, 0x40, REG_BITS_8},
	{0x91E4, 0xc0, REG_BITS_8},
	{0x91E5, 0x00, REG_BITS_8},
	{0x91E6, 0x01, REG_BITS_8},
	{0x91E7, 0x03, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x84, REG_BITS_8},
	{0xA003, 0xe1, REG_BITS_8},
	{0xA004, 0x0d, REG_BITS_8},
	{0xA005, 0x64, REG_BITS_8},
	{0xA006, 0x92, REG_BITS_8},
	{0xA007, 0xa3, REG_BITS_8},
	{0xA008, 0x98, REG_BITS_8},
	{0xA009, 0xe3, REG_BITS_8},
	{0xA00A, 0xec, REG_BITS_8},
	{0xA00B, 0x25, REG_BITS_8},
	{0xA00C, 0x37, REG_BITS_8},
	{0xA00D, 0x79, REG_BITS_8},
	{0xA00E, 0xb1, REG_BITS_8},
	{0xA00F, 0xcd, REG_BITS_8},
	{0xA010, 0x5f, REG_BITS_8},
	{0xA011, 0x7e, REG_BITS_8},
	{0xA012, 0x13, REG_BITS_8},
	{0xA013, 0x99, REG_BITS_8},
	{0xA014, 0xe9, REG_BITS_8},
	{0xA015, 0x64, REG_BITS_8},
	{0xA016, 0xe6, REG_BITS_8},
	{0xA017, 0x3b, REG_BITS_8},
	{0xA018, 0x87, REG_BITS_8},
	{0xA019, 0x61, REG_BITS_8},
	{0xA01A, 0x8e, REG_BITS_8},
	{0xA01B, 0x66, REG_BITS_8},
	{0xA01C, 0xa8, REG_BITS_8},
	{0xA01D, 0xb3, REG_BITS_8},
	{0xA01E, 0x99, REG_BITS_8},
	{0xA01F, 0xea, REG_BITS_8},
	{0xA020, 0x18, REG_BITS_8},
	{0xA021, 0x06, REG_BITS_8},
	{0xA022, 0x38, REG_BITS_8},
	{0xA023, 0x77, REG_BITS_8},
	{0xA024, 0x81, REG_BITS_8},
	{0xA025, 0x0d, REG_BITS_8},
	{0xA026, 0x5d, REG_BITS_8},
	{0xA027, 0x5a, REG_BITS_8},
	{0xA028, 0xc3, REG_BITS_8},
	{0xA029, 0x97, REG_BITS_8},
	{0xA02A, 0xdb, REG_BITS_8},
	{0xA02B, 0x3c, REG_BITS_8},
	{0xA02C, 0xa6, REG_BITS_8},
	{0xA02D, 0x39, REG_BITS_8},
	{0xA02E, 0xa7, REG_BITS_8},
	{0xA02F, 0x71, REG_BITS_8},
	{0xA030, 0x8f, REG_BITS_8},
	{0xA031, 0x69, REG_BITS_8},
	{0xA032, 0xdc, REG_BITS_8},
	{0xA033, 0xe3, REG_BITS_8},
	{0xA034, 0x97, REG_BITS_8},
	{0xA035, 0xdb, REG_BITS_8},
	{0xA036, 0xdc, REG_BITS_8},
	{0xA037, 0x65, REG_BITS_8},
	{0xA038, 0x35, REG_BITS_8},
	{0xA039, 0x59, REG_BITS_8},
	{0xA03A, 0x19, REG_BITS_8},
	{0xA03B, 0xcc, REG_BITS_8},
	{0xA03C, 0x52, REG_BITS_8},
	{0xA03D, 0xe4, REG_BITS_8},
	{0xA03E, 0x82, REG_BITS_8},
	{0xA03F, 0x94, REG_BITS_8},
	{0xA040, 0xb7, REG_BITS_8},
	{0xA041, 0x40, REG_BITS_8},
	{0xA042, 0x05, REG_BITS_8},
	{0xA043, 0x2f, REG_BITS_8},
	{0xA044, 0x62, REG_BITS_8},
	{0xA045, 0x81, REG_BITS_8},
	{0xA046, 0x0c, REG_BITS_8},
	{0xA047, 0x61, REG_BITS_8},
	{0xA048, 0x78, REG_BITS_8},
	{0xA049, 0xe3, REG_BITS_8},
	{0xA04A, 0x98, REG_BITS_8},
	{0xA04B, 0xe6, REG_BITS_8},
	{0xA04C, 0x80, REG_BITS_8},
	{0xA04D, 0x05, REG_BITS_8},
	{0xA04E, 0x32, REG_BITS_8},
	{0xA04F, 0x54, REG_BITS_8},
	{0xA050, 0xe1, REG_BITS_8},
	{0xA051, 0x4b, REG_BITS_8},
	{0xA052, 0x4f, REG_BITS_8},
	{0xA053, 0xb4, REG_BITS_8},
	{0xA054, 0xd2, REG_BITS_8},
	{0xA055, 0x12, REG_BITS_8},
	{0xA056, 0xa1, REG_BITS_8},
	{0xA057, 0xa4, REG_BITS_8},
	{0xA058, 0x64, REG_BITS_8},
	{0xA059, 0x27, REG_BITS_8},
	{0xA05A, 0x31, REG_BITS_8},
	{0xA05B, 0x49, REG_BITS_8},
	{0xA05C, 0x0a, REG_BITS_8},
	{0xA05D, 0x51, REG_BITS_8},
	{0xA05E, 0xca, REG_BITS_8},
	{0xA05F, 0x02, REG_BITS_8},
	{0xA060, 0x96, REG_BITS_8},
	{0xA061, 0xc6, REG_BITS_8},
	{0xA062, 0xc4, REG_BITS_8},
	{0xA063, 0xc5, REG_BITS_8},
	{0xA064, 0x34, REG_BITS_8},
	{0xA065, 0x4f, REG_BITS_8},
	{0xA066, 0xa9, REG_BITS_8},
	{0xA067, 0x8b, REG_BITS_8},
	{0xA068, 0x50, REG_BITS_8},
	{0xA069, 0xc0, REG_BITS_8},
	{0xA06A, 0x72, REG_BITS_8},
	{0xA06B, 0x12, REG_BITS_8},
	{0xA06C, 0x9c, REG_BITS_8},
	{0xA06D, 0x40, REG_BITS_8},
	{0xA06E, 0x24, REG_BITS_8},
	{0xA06F, 0x23, REG_BITS_8},
	{0xA070, 0x0a, REG_BITS_8},
	{0xA071, 0x89, REG_BITS_8},
	{0xA072, 0x48, REG_BITS_8},
	{0xA073, 0x45, REG_BITS_8},
	{0xA074, 0x3e, REG_BITS_8},
	{0xA075, 0x02, REG_BITS_8},
	{0xA076, 0x13, REG_BITS_8},
	{0xA077, 0xa2, REG_BITS_8},
	{0xA078, 0x38, REG_BITS_8},
	{0xA079, 0x45, REG_BITS_8},
	{0xA07A, 0x2e, REG_BITS_8},
	{0xA07B, 0x5d, REG_BITS_8},
	{0xA07C, 0x51, REG_BITS_8},
	{0xA07D, 0x0c, REG_BITS_8},
	{0xA07E, 0x51, REG_BITS_8},
	{0xA07F, 0xc6, REG_BITS_8},
	{0xA080, 0x92, REG_BITS_8},
	{0xA081, 0x13, REG_BITS_8},
	{0xA082, 0xa8, REG_BITS_8},
	{0xA083, 0x68, REG_BITS_8},
	{0xA084, 0xa4, REG_BITS_8},
	{0xA085, 0x24, REG_BITS_8},
	{0xA086, 0x03, REG_BITS_8},
	{0xA087, 0x29, REG_BITS_8},
	{0xA088, 0x88, REG_BITS_8},
	{0xA089, 0x3f, REG_BITS_8},
	{0xA08A, 0xfc, REG_BITS_8},
	{0xA08B, 0x71, REG_BITS_8},
	{0xA08C, 0x10, REG_BITS_8},
	{0xA08D, 0x86, REG_BITS_8},
	{0xA08E, 0x90, REG_BITS_8},
	{0xA08F, 0x44, REG_BITS_8},
	{0xA090, 0x26, REG_BITS_8},
	{0xA091, 0x45, REG_BITS_8},
	{0xA092, 0x21, REG_BITS_8},
	{0xA093, 0x4b, REG_BITS_8},
	{0xA094, 0x54, REG_BITS_8},
	{0xA095, 0xf4, REG_BITS_8},
	{0xA096, 0x62, REG_BITS_8},
	{0xA097, 0x94, REG_BITS_8},
	{0xA098, 0xb1, REG_BITS_8},
	{0xA099, 0xf0, REG_BITS_8},
	{0xA09A, 0x44, REG_BITS_8},
	{0xA09B, 0x2a, REG_BITS_8},
	{0xA09C, 0x1d, REG_BITS_8},
	{0xA09D, 0x39, REG_BITS_8},
	{0xA09E, 0x89, REG_BITS_8},
	{0xA09F, 0x41, REG_BITS_8},
	{0xA0A0, 0x0e, REG_BITS_8},
	{0xA0A1, 0x12, REG_BITS_8},
	{0xA0A2, 0x90, REG_BITS_8},
	{0xA0A3, 0x80, REG_BITS_8},
	{0xA0A4, 0x2c, REG_BITS_8},
	{0xA0A5, 0xc4, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x28, REG_BITS_8},
	{0xA0A8, 0xa9, REG_BITS_8},
	{0xA0A9, 0x09, REG_BITS_8},
	{0xA0AA, 0x52, REG_BITS_8},
	{0xA0AB, 0xcc, REG_BITS_8},
	{0xA0AC, 0x32, REG_BITS_8},
	{0xA0AD, 0x15, REG_BITS_8},
	{0xA0AE, 0xbd, REG_BITS_8},
	{0xA0AF, 0x54, REG_BITS_8},
	{0xA0B0, 0xa5, REG_BITS_8},
	{0xA0B1, 0x2e, REG_BITS_8},
	{0xA0B2, 0x48, REG_BITS_8},
	{0xA0B3, 0x09, REG_BITS_8},
	{0xA0B4, 0x8b, REG_BITS_8},
	{0xA0B5, 0x4b, REG_BITS_8},
	{0xA0B6, 0x76, REG_BITS_8},
	{0xA0B7, 0x82, REG_BITS_8},
	{0xA0B8, 0x91, REG_BITS_8},
	{0xA0B9, 0x8e, REG_BITS_8},
	{0xA0BA, 0x4c, REG_BITS_8},
	{0xA0BB, 0xc4, REG_BITS_8},
	{0xA0BC, 0x22, REG_BITS_8},
	{0xA0BD, 0x1e, REG_BITS_8},
	{0xA0BE, 0x29, REG_BITS_8},
	{0xA0BF, 0x09, REG_BITS_8},
	{0xA0C0, 0x4e, REG_BITS_8},
	{0xA0C1, 0x94, REG_BITS_8},
	{0xA0C2, 0x42, REG_BITS_8},
	{0xA0C3, 0x95, REG_BITS_8},
	{0xA0C4, 0xb9, REG_BITS_8},
	{0xA0C5, 0x8c, REG_BITS_8},
	{0xA0C6, 0x45, REG_BITS_8},
	{0xA0C7, 0x31, REG_BITS_8},
	{0xA0C8, 0x6a, REG_BITS_8},
	{0xA0C9, 0x89, REG_BITS_8},
	{0xA0CA, 0x4c, REG_BITS_8},
	{0xA0CB, 0x57, REG_BITS_8},
	{0xA0CC, 0xfc, REG_BITS_8},
	{0xA0CD, 0x62, REG_BITS_8},
	{0xA0CE, 0x94, REG_BITS_8},
	{0xA0CF, 0xaf, REG_BITS_8},
	{0xA0D0, 0xe4, REG_BITS_8},
	{0xA0D1, 0x44, REG_BITS_8},
	{0xA0D2, 0x29, REG_BITS_8},
	{0xA0D3, 0x35, REG_BITS_8},
	{0xA0D4, 0x19, REG_BITS_8},
	{0xA0D5, 0x0a, REG_BITS_8},
	{0xA0D6, 0x4f, REG_BITS_8},
	{0xA0D7, 0xa2, REG_BITS_8},
	{0xA0D8, 0xe2, REG_BITS_8},
	{0xA0D9, 0x94, REG_BITS_8},
	{0xA0DA, 0xb5, REG_BITS_8},
	{0xA0DB, 0xa4, REG_BITS_8},
	{0xA0DC, 0xc5, REG_BITS_8},
	{0xA0DD, 0x31, REG_BITS_8},
	{0xA0DE, 0x7a, REG_BITS_8},
	{0xA0DF, 0x29, REG_BITS_8},
	{0xA0E0, 0x8d, REG_BITS_8},
	{0xA0E1, 0x61, REG_BITS_8},
	{0xA0E2, 0x78, REG_BITS_8},
	{0xA0E3, 0x03, REG_BITS_8},
	{0xA0E4, 0x18, REG_BITS_8},
	{0xA0E5, 0xd8, REG_BITS_8},
	{0xA0E6, 0x90, REG_BITS_8},
	{0xA0E7, 0x85, REG_BITS_8},
	{0xA0E8, 0x31, REG_BITS_8},
	{0xA0E9, 0x58, REG_BITS_8},
	{0xA0EA, 0xc9, REG_BITS_8},
	{0xA0EB, 0x8b, REG_BITS_8},
	{0xA0EC, 0x55, REG_BITS_8},
	{0xA0ED, 0xe8, REG_BITS_8},
	{0xA0EE, 0xb2, REG_BITS_8},
	{0xA0EF, 0x15, REG_BITS_8},
	{0xA0F0, 0xc0, REG_BITS_8},
	{0xA0F1, 0xac, REG_BITS_8},
	{0xA0F2, 0x25, REG_BITS_8},
	{0xA0F3, 0x33, REG_BITS_8},
	{0xA0F4, 0x8f, REG_BITS_8},
	{0xA0F5, 0x19, REG_BITS_8},
	{0xA0F6, 0x8e, REG_BITS_8},
	{0xA0F7, 0x66, REG_BITS_8},
	{0xA0F8, 0xa4, REG_BITS_8},
	{0xA0F9, 0x23, REG_BITS_8},
	{0xA0FA, 0x9a, REG_BITS_8},
	{0xA0FB, 0xed, REG_BITS_8},
	{0xA0FC, 0x94, REG_BITS_8},
	{0xA0FD, 0xe6, REG_BITS_8},
	{0xA0FE, 0x3b, REG_BITS_8},
	{0xA0FF, 0x92, REG_BITS_8},
	{0xA100, 0x41, REG_BITS_8},
	{0xA101, 0x0e, REG_BITS_8},
	{0xA102, 0x61, REG_BITS_8},
	{0xA103, 0x70, REG_BITS_8},
	{0xA104, 0x33, REG_BITS_8},
	{0xA105, 0x98, REG_BITS_8},
	{0xA106, 0xdb, REG_BITS_8},
	{0xA107, 0x28, REG_BITS_8},
	{0xA108, 0x06, REG_BITS_8},
	{0xA109, 0x38, REG_BITS_8},
	{0xA10A, 0x9b, REG_BITS_8},
	{0xA10B, 0xb1, REG_BITS_8},
	{0xA10C, 0xce, REG_BITS_8},
	{0xA10D, 0x6c, REG_BITS_8},
	{0xA10E, 0xe6, REG_BITS_8},
	{0xA10F, 0x23, REG_BITS_8},
	{0xA110, 0x9b, REG_BITS_8},
	{0xA111, 0xf9, REG_BITS_8},
	{0xA112, 0x20, REG_BITS_8},
	{0xA113, 0xe6, REG_BITS_8},
	{0xA114, 0x37, REG_BITS_8},
	{0xA115, 0x97, REG_BITS_8},
	{0xA116, 0x71, REG_BITS_8},
	{0xA117, 0x8e, REG_BITS_8},
	{0xA118, 0x64, REG_BITS_8},
	{0xA119, 0x96, REG_BITS_8},
	{0xA11A, 0x63, REG_BITS_8},
	{0xA11B, 0x18, REG_BITS_8},
	{0xA11C, 0xdf, REG_BITS_8},
	{0xA11D, 0x18, REG_BITS_8},
	{0xA11E, 0x26, REG_BITS_8},
	{0xA11F, 0x38, REG_BITS_8},
	{0xA120, 0x8d, REG_BITS_8},
	{0xA121, 0x31, REG_BITS_8},
	{0xA122, 0x4e, REG_BITS_8},
	{0xA123, 0x67, REG_BITS_8},
	{0xA124, 0xb2, REG_BITS_8},
	{0xA125, 0x43, REG_BITS_8},
	{0xA126, 0x1a, REG_BITS_8},
	{0xA127, 0xf1, REG_BITS_8},
	{0xA128, 0x44, REG_BITS_8},
	{0xA129, 0x26, REG_BITS_8},
	{0xA12A, 0x3a, REG_BITS_8},
	{0xA12B, 0x68, REG_BITS_8},
	{0xA12C, 0x21, REG_BITS_8},
	{0xA12D, 0x4c, REG_BITS_8},
	{0xA12E, 0x5d, REG_BITS_8},
	{0xA12F, 0x20, REG_BITS_8},
	{0xA130, 0x53, REG_BITS_8},
	{0xA131, 0x17, REG_BITS_8},
	{0xA132, 0xc5, REG_BITS_8},
	{0xA133, 0xb0, REG_BITS_8},
	{0xA134, 0xc5, REG_BITS_8},
	{0xA135, 0x2f, REG_BITS_8},
	{0xA136, 0x6c, REG_BITS_8},
	{0xA137, 0xf1, REG_BITS_8},
	{0xA138, 0x4b, REG_BITS_8},
	{0xA139, 0x5d, REG_BITS_8},
	{0xA13A, 0x06, REG_BITS_8},
	{0xA13B, 0x63, REG_BITS_8},
	{0xA13C, 0x18, REG_BITS_8},
	{0xA13D, 0xcb, REG_BITS_8},
	{0xA13E, 0x1c, REG_BITS_8},
	{0xA13F, 0x86, REG_BITS_8},
	{0xA140, 0x33, REG_BITS_8},
	{0xA141, 0x72, REG_BITS_8},
	{0xA142, 0x39, REG_BITS_8},
	{0xA143, 0x4c, REG_BITS_8},
	{0xA144, 0x5f, REG_BITS_8},
	{0xA145, 0x32, REG_BITS_8},
	{0xA146, 0x13, REG_BITS_8},
	{0xA147, 0x98, REG_BITS_8},
	{0xA148, 0xcd, REG_BITS_8},
	{0xA149, 0xc8, REG_BITS_8},
	{0xA14A, 0x05, REG_BITS_8},
	{0xA14B, 0x31, REG_BITS_8},
	{0xA14C, 0x69, REG_BITS_8},
	{0xA14D, 0xd9, REG_BITS_8},
	{0xA14E, 0x0b, REG_BITS_8},
	{0xA14F, 0x5a, REG_BITS_8},
	{0xA150, 0xf0, REG_BITS_8},
	{0xA151, 0x22, REG_BITS_8},
	{0xA152, 0x17, REG_BITS_8},
	{0xA153, 0xc0, REG_BITS_8},
	{0xA154, 0x0c, REG_BITS_8},
	{0xA155, 0x86, REG_BITS_8},
	{0xA156, 0x32, REG_BITS_8},
	{0xA157, 0x96, REG_BITS_8},
	{0xA158, 0x51, REG_BITS_8},
	{0xA159, 0x4d, REG_BITS_8},
	{0xA15A, 0x64, REG_BITS_8},
	{0xA15B, 0x50, REG_BITS_8},
	{0xA15C, 0x73, REG_BITS_8},
	{0xA15D, 0x16, REG_BITS_8},
	{0xA15E, 0xbf, REG_BITS_8},
	{0xA15F, 0x88, REG_BITS_8},
	{0xA160, 0x05, REG_BITS_8},
	{0xA161, 0x2f, REG_BITS_8},
	{0xA162, 0x4a, REG_BITS_8},
	{0xA163, 0xe1, REG_BITS_8},
	{0xA164, 0x4a, REG_BITS_8},
	{0xA165, 0x50, REG_BITS_8},
	{0xA166, 0x9e, REG_BITS_8},
	{0xA167, 0x12, REG_BITS_8},
	{0xA168, 0x14, REG_BITS_8},
	{0xA169, 0xa6, REG_BITS_8},
	{0xA16A, 0x20, REG_BITS_8},
	{0xA16B, 0x85, REG_BITS_8},
	{0xA16C, 0x2a, REG_BITS_8},
	{0xA16D, 0x58, REG_BITS_8},
	{0xA16E, 0x31, REG_BITS_8},
	{0xA16F, 0x8b, REG_BITS_8},
	{0xA170, 0x5d, REG_BITS_8},
	{0xA171, 0x0e, REG_BITS_8},
	{0xA172, 0xf3, REG_BITS_8},
	{0xA173, 0x97, REG_BITS_8},
	{0xA174, 0xc8, REG_BITS_8},
	{0xA175, 0x30, REG_BITS_8},
	{0xA176, 0x45, REG_BITS_8},
	{0xA177, 0x2c, REG_BITS_8},
	{0xA178, 0x44, REG_BITS_8},
	{0xA179, 0xb1, REG_BITS_8},
	{0xA17A, 0x8a, REG_BITS_8},
	{0xA17B, 0x4c, REG_BITS_8},
	{0xA17C, 0x80, REG_BITS_8},
	{0xA17D, 0x72, REG_BITS_8},
	{0xA17E, 0x12, REG_BITS_8},
	{0xA17F, 0x98, REG_BITS_8},
	{0xA180, 0x94, REG_BITS_8},
	{0xA181, 0x84, REG_BITS_8},
	{0xA182, 0x25, REG_BITS_8},
	{0xA183, 0x2d, REG_BITS_8},
	{0xA184, 0xa9, REG_BITS_8},
	{0xA185, 0x49, REG_BITS_8},
	{0xA186, 0x4f, REG_BITS_8},
	{0xA187, 0x90, REG_BITS_8},
	{0xA188, 0x62, REG_BITS_8},
	{0xA189, 0x15, REG_BITS_8},
	{0xA18A, 0xb1, REG_BITS_8},
	{0xA18B, 0x90, REG_BITS_8},
	{0xA18C, 0x05, REG_BITS_8},
	{0xA18D, 0x2e, REG_BITS_8},
	{0xA18E, 0x3c, REG_BITS_8},
	{0xA18F, 0x71, REG_BITS_8},
	{0xA190, 0x0a, REG_BITS_8},
	{0xA191, 0x4d, REG_BITS_8},
	{0xA192, 0x86, REG_BITS_8},
	{0xA193, 0xf2, REG_BITS_8},
	{0xA194, 0x91, REG_BITS_8},
	{0xA195, 0x94, REG_BITS_8},
	{0xA196, 0x34, REG_BITS_8},
	{0xA197, 0x44, REG_BITS_8},
	{0xA198, 0x22, REG_BITS_8},
	{0xA199, 0x0b, REG_BITS_8},
	{0xA19A, 0x69, REG_BITS_8},
	{0xA19B, 0x08, REG_BITS_8},
	{0xA19C, 0x45, REG_BITS_8},
	{0xA19D, 0x2e, REG_BITS_8},
	{0xA19E, 0xc2, REG_BITS_8},
	{0xA19F, 0x92, REG_BITS_8},
	{0xA1A0, 0x98, REG_BITS_8},
	{0xA1A1, 0x14, REG_BITS_8},
	{0xA1A2, 0xc5, REG_BITS_8},
	{0xA1A3, 0x29, REG_BITS_8},
	{0xA1A4, 0x50, REG_BITS_8},
	{0xA1A5, 0xe1, REG_BITS_8},
	{0xA1A6, 0x0a, REG_BITS_8},
	{0xA1A7, 0x4c, REG_BITS_8},
	{0xA1A8, 0x7e, REG_BITS_8},
	{0xA1A9, 0xa2, REG_BITS_8},
	{0xA1AA, 0x92, REG_BITS_8},
	{0xA1AB, 0x9b, REG_BITS_8},
	{0xA1AC, 0x4c, REG_BITS_8},
	{0xA1AD, 0x64, REG_BITS_8},
	{0xA1AE, 0x23, REG_BITS_8},
	{0xA1AF, 0x01, REG_BITS_8},
	{0xA1B0, 0x21, REG_BITS_8},
	{0xA1B1, 0xc8, REG_BITS_8},
	{0xA1B2, 0x3f, REG_BITS_8},
	{0xA1B3, 0xfe, REG_BITS_8},
	{0xA1B4, 0x81, REG_BITS_8},
	{0xA1B5, 0x10, REG_BITS_8},
	{0xA1B6, 0x84, REG_BITS_8},
	{0xA1B7, 0x84, REG_BITS_8},
	{0xA1B8, 0x84, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x3d, REG_BITS_8},
	{0xA1BB, 0x21, REG_BITS_8},
	{0xA1BC, 0x0a, REG_BITS_8},
	{0xA1BD, 0x51, REG_BITS_8},
	{0xA1BE, 0xa0, REG_BITS_8},
	{0xA1BF, 0x22, REG_BITS_8},
	{0xA1C0, 0x13, REG_BITS_8},
	{0xA1C1, 0xa0, REG_BITS_8},
	{0xA1C2, 0xb0, REG_BITS_8},
	{0xA1C3, 0x04, REG_BITS_8},
	{0xA1C4, 0x27, REG_BITS_8},
	{0xA1C5, 0x14, REG_BITS_8},
	{0xA1C6, 0xe1, REG_BITS_8},
	{0xA1C7, 0x88, REG_BITS_8},
	{0xA1C8, 0x40, REG_BITS_8},
	{0xA1C9, 0x0a, REG_BITS_8},
	{0xA1CA, 0x02, REG_BITS_8},
	{0xA1CB, 0x10, REG_BITS_8},
	{0xA1CC, 0x80, REG_BITS_8},
	{0xA1CD, 0x24, REG_BITS_8},
	{0xA1CE, 0x24, REG_BITS_8},
	{0xA1CF, 0x21, REG_BITS_8},
	{0xA1D0, 0x21, REG_BITS_8},
	{0xA1D1, 0x21, REG_BITS_8},
	{0xA1D2, 0x09, REG_BITS_8},
	{0xA1D3, 0x4f, REG_BITS_8},
	{0xA1D4, 0x8a, REG_BITS_8},
	{0xA1D5, 0x32, REG_BITS_8},
	{0xA1D6, 0x94, REG_BITS_8},
	{0xA1D7, 0xa8, REG_BITS_8},
	{0xA1D8, 0x08, REG_BITS_8},
	{0xA1D9, 0xe5, REG_BITS_8},
	{0xA1DA, 0x29, REG_BITS_8},
	{0xA1DB, 0x39, REG_BITS_8},
	{0xA1DC, 0x21, REG_BITS_8},
	{0xA1DD, 0xca, REG_BITS_8},
	{0xA1DE, 0x48, REG_BITS_8},
	{0xA1DF, 0x56, REG_BITS_8},
	{0xA1E0, 0x02, REG_BITS_8},
	{0xA1E1, 0x11, REG_BITS_8},
	{0xA1E2, 0x8b, REG_BITS_8},
	{0xA1E3, 0x34, REG_BITS_8},
	{0xA1E4, 0x24, REG_BITS_8},
	{0xA1E5, 0x22, REG_BITS_8},
	{0xA1E6, 0x16, REG_BITS_8},
	{0xA1E7, 0xd1, REG_BITS_8},
	{0xA1E8, 0x48, REG_BITS_8},
	{0xA1E9, 0x4b, REG_BITS_8},
	{0xA1EA, 0x68, REG_BITS_8},
	{0xA1EB, 0x22, REG_BITS_8},
	{0xA1EC, 0x14, REG_BITS_8},
	{0xA1ED, 0xa8, REG_BITS_8},
	{0xA1EE, 0x30, REG_BITS_8},
	{0xA1EF, 0xe5, REG_BITS_8},
	{0xA1F0, 0x2b, REG_BITS_8},
	{0xA1F1, 0x57, REG_BITS_8},
	{0xA1F2, 0x11, REG_BITS_8},
	{0xA1F3, 0x4b, REG_BITS_8},
	{0xA1F4, 0x53, REG_BITS_8},
	{0xA1F5, 0xae, REG_BITS_8},
	{0xA1F6, 0x92, REG_BITS_8},
	{0xA1F7, 0x93, REG_BITS_8},
	{0xA1F8, 0xa1, REG_BITS_8},
	{0xA1F9, 0xb0, REG_BITS_8},
	{0xA1FA, 0xa4, REG_BITS_8},
	{0xA1FB, 0x26, REG_BITS_8},
	{0xA1FC, 0x29, REG_BITS_8},
	{0xA1FD, 0x91, REG_BITS_8},
	{0xA1FE, 0x09, REG_BITS_8},
	{0xA1FF, 0x4c, REG_BITS_8},
	{0xA200, 0x74, REG_BITS_8},
	{0xA201, 0xd2, REG_BITS_8},
	{0xA202, 0x93, REG_BITS_8},
	{0xA203, 0xa5, REG_BITS_8},
	{0xA204, 0x44, REG_BITS_8},
	{0xA205, 0xa5, REG_BITS_8},
	{0xA206, 0x2c, REG_BITS_8},
	{0xA207, 0x5d, REG_BITS_8},
	{0xA208, 0xa9, REG_BITS_8},
	{0xA209, 0x0b, REG_BITS_8},
	{0xA20A, 0x5d, REG_BITS_8},
	{0xA20B, 0x06, REG_BITS_8},
	{0xA20C, 0xf3, REG_BITS_8},
	{0xA20D, 0x96, REG_BITS_8},
	{0xA20E, 0xbe, REG_BITS_8},
	{0xA20F, 0x50, REG_BITS_8},
	{0xA210, 0x45, REG_BITS_8},
	{0xA211, 0x2c, REG_BITS_8},
	{0xA212, 0x49, REG_BITS_8},
	{0xA213, 0xb1, REG_BITS_8},
	{0xA214, 0x4a, REG_BITS_8},
	{0xA215, 0x51, REG_BITS_8},
	{0xA216, 0xa8, REG_BITS_8},
	{0xA217, 0x82, REG_BITS_8},
	{0xA218, 0x94, REG_BITS_8},
	{0xA219, 0xad, REG_BITS_8},
	{0xA21A, 0x50, REG_BITS_8},
	{0xA21B, 0x85, REG_BITS_8},
	{0xA21C, 0x2d, REG_BITS_8},
	{0xA21D, 0x70, REG_BITS_8},
	{0xA21E, 0x69, REG_BITS_8},
	{0xA21F, 0xcc, REG_BITS_8},
	{0xA220, 0x5d, REG_BITS_8},
	{0xA221, 0x2c, REG_BITS_8},
	{0xA222, 0xb3, REG_BITS_8},
	{0xA223, 0x18, REG_BITS_8},
	{0xA224, 0xcf, REG_BITS_8},
	{0xA225, 0x3c, REG_BITS_8},
	{0xA226, 0x46, REG_BITS_8},
	{0xA227, 0x34, REG_BITS_8},
	{0xA228, 0x80, REG_BITS_8},
	{0xA229, 0x89, REG_BITS_8},
	{0xA22A, 0xcc, REG_BITS_8},
	{0xA22B, 0x5c, REG_BITS_8},
	{0xA22C, 0x0a, REG_BITS_8},
	{0xA22D, 0xd3, REG_BITS_8},
	{0xA22E, 0x16, REG_BITS_8},
	{0xA22F, 0xc1, REG_BITS_8},
	{0xA230, 0xc8, REG_BITS_8},
	{0xA231, 0x25, REG_BITS_8},
	{0xA232, 0x31, REG_BITS_8},
	{0xA233, 0x7f, REG_BITS_8},
	{0xA234, 0xe9, REG_BITS_8},
	{0xA235, 0x0c, REG_BITS_8},
	{0xA236, 0x64, REG_BITS_8},
	{0xA237, 0x64, REG_BITS_8},
	{0xA238, 0xd3, REG_BITS_8},
	{0xA239, 0x18, REG_BITS_8},
	{0xA23A, 0xd7, REG_BITS_8},
	{0xA23B, 0xc4, REG_BITS_8},
	{0xA23C, 0xa5, REG_BITS_8},
	{0xA23D, 0x30, REG_BITS_8},
	{0xA23E, 0x82, REG_BITS_8},
	{0xA23F, 0xa9, REG_BITS_8},
	{0xA240, 0x4c, REG_BITS_8},
	{0xA241, 0x60, REG_BITS_8},
	{0xA242, 0x24, REG_BITS_8},
	{0xA243, 0x53, REG_BITS_8},
	{0xA244, 0x17, REG_BITS_8},
	{0xA245, 0xc4, REG_BITS_8},
	{0xA246, 0xc8, REG_BITS_8},
	{0xA247, 0xc5, REG_BITS_8},
	{0xA248, 0x30, REG_BITS_8},
	{0xA249, 0x75, REG_BITS_8},
	{0xA24A, 0x61, REG_BITS_8},
	{0xA24B, 0x0c, REG_BITS_8},
	{0xA24C, 0x60, REG_BITS_8},
	{0xA24D, 0x3c, REG_BITS_8},
	{0xA24E, 0x33, REG_BITS_8},
	{0xA24F, 0x98, REG_BITS_8},
	{0xA250, 0xd1, REG_BITS_8},
	{0xA251, 0xbc, REG_BITS_8},
	{0xA252, 0xc5, REG_BITS_8},
	{0xA253, 0x31, REG_BITS_8},
	{0xA254, 0x97, REG_BITS_8},
	{0xA255, 0x21, REG_BITS_8},
	{0xA256, 0x4d, REG_BITS_8},
	{0xA257, 0x68, REG_BITS_8},
	{0xA258, 0x28, REG_BITS_8},
	{0xA259, 0x03, REG_BITS_8},
	{0xA25A, 0x19, REG_BITS_8},
	{0xA25B, 0xcc, REG_BITS_8},
	{0xA25C, 0xa8, REG_BITS_8},
	{0xA25D, 0x86, REG_BITS_8},
	{0xA25E, 0x36, REG_BITS_8},
	{0xA25F, 0xa3, REG_BITS_8},
	{0xA260, 0x61, REG_BITS_8},
	{0xA261, 0x8d, REG_BITS_8},
	{0xA262, 0x6b, REG_BITS_8},
	{0xA263, 0x36, REG_BITS_8},
	{0xA264, 0xd3, REG_BITS_8},
	{0xA265, 0x18, REG_BITS_8},
	{0xA266, 0xc5, REG_BITS_8},
	{0xA267, 0x48, REG_BITS_8},
	{0xA268, 0xa6, REG_BITS_8},
	{0xA269, 0x34, REG_BITS_8},
	{0xA26A, 0xc1, REG_BITS_8},
	{0xA26B, 0x09, REG_BITS_8},
	{0xA26C, 0x4e, REG_BITS_8},
	{0xA26D, 0x64, REG_BITS_8},
	{0xA26E, 0x10, REG_BITS_8},
	{0xA26F, 0x73, REG_BITS_8},
	{0xA270, 0x16, REG_BITS_8},
	{0xA271, 0xac, REG_BITS_8},
	{0xA272, 0x5c, REG_BITS_8},
	{0xA273, 0xa5, REG_BITS_8},
	{0xA274, 0x2b, REG_BITS_8},
	{0xA275, 0x71, REG_BITS_8},
	{0xA276, 0xb9, REG_BITS_8},
	{0xA277, 0x0c, REG_BITS_8},
	{0xA278, 0x69, REG_BITS_8},
	{0xA279, 0xe0, REG_BITS_8},
	{0xA27A, 0x02, REG_BITS_8},
	{0xA27B, 0x16, REG_BITS_8},
	{0xA27C, 0xa3, REG_BITS_8},
	{0xA27D, 0xcc, REG_BITS_8},
	{0xA27E, 0xc4, REG_BITS_8},
	{0xA27F, 0x25, REG_BITS_8},
	{0xA280, 0x39, REG_BITS_8},
	{0xA281, 0x79, REG_BITS_8},
	{0xA282, 0xca, REG_BITS_8},
	{0xA283, 0x5b, REG_BITS_8},
	{0xA284, 0x08, REG_BITS_8},
	{0xA285, 0xa3, REG_BITS_8},
	{0xA286, 0x95, REG_BITS_8},
	{0xA287, 0xa5, REG_BITS_8},
	{0xA288, 0xb0, REG_BITS_8},
	{0xA289, 0x64, REG_BITS_8},
	{0xA28A, 0x22, REG_BITS_8},
	{0xA28B, 0x0d, REG_BITS_8},
	{0xA28C, 0xc9, REG_BITS_8},
	{0xA28D, 0xc8, REG_BITS_8},
	{0xA28E, 0x4d, REG_BITS_8},
	{0xA28F, 0xb4, REG_BITS_8},
	{0xA290, 0xe2, REG_BITS_8},
	{0xA291, 0x16, REG_BITS_8},
	{0xA292, 0xa6, REG_BITS_8},
	{0xA293, 0x00, REG_BITS_8},
	{0xA294, 0xc5, REG_BITS_8},
	{0xA295, 0x23, REG_BITS_8},
	{0xA296, 0x04, REG_BITS_8},
	{0xA297, 0xf9, REG_BITS_8},
	{0xA298, 0xc7, REG_BITS_8},
	{0xA299, 0x42, REG_BITS_8},
	{0xA29A, 0x52, REG_BITS_8},
	{0xA29B, 0x12, REG_BITS_8},
	{0xA29C, 0x15, REG_BITS_8},
	{0xA29D, 0xb1, REG_BITS_8},
	{0xA29E, 0x34, REG_BITS_8},
	{0xA29F, 0x25, REG_BITS_8},
	{0xA2A0, 0x28, REG_BITS_8},
	{0xA2A1, 0x20, REG_BITS_8},
	{0xA2A2, 0x31, REG_BITS_8},
	{0xA2A3, 0x08, REG_BITS_8},
	{0xA2A4, 0x40, REG_BITS_8},
	{0xA2A5, 0x18, REG_BITS_8},
	{0xA2A6, 0xc2, REG_BITS_8},
	{0xA2A7, 0x92, REG_BITS_8},
	{0xA2A8, 0xa9, REG_BITS_8},
	{0xA2A9, 0x8c, REG_BITS_8},
	{0xA2AA, 0x65, REG_BITS_8},
	{0xA2AB, 0x2b, REG_BITS_8},
	{0xA2AC, 0x4c, REG_BITS_8},
	{0xA2AD, 0x81, REG_BITS_8},
	{0xA2AE, 0x09, REG_BITS_8},
	{0xA2AF, 0x46, REG_BITS_8},
	{0xA2B0, 0x26, REG_BITS_8},
	{0xA2B1, 0xf2, REG_BITS_8},
	{0xA2B2, 0x91, REG_BITS_8},
	{0xA2B3, 0x9e, REG_BITS_8},
	{0xA2B4, 0x74, REG_BITS_8},
	{0xA2B5, 0xe5, REG_BITS_8},
	{0xA2B6, 0x2d, REG_BITS_8},
	{0xA2B7, 0x73, REG_BITS_8},
	{0xA2B8, 0x21, REG_BITS_8},
	{0xA2B9, 0x0b, REG_BITS_8},
	{0xA2BA, 0x53, REG_BITS_8},
	{0xA2BB, 0x78, REG_BITS_8},
	{0xA2BC, 0x72, REG_BITS_8},
	{0xA2BD, 0x93, REG_BITS_8},
	{0xA2BE, 0xa0, REG_BITS_8},
	{0xA2BF, 0x58, REG_BITS_8},
	{0xA2C0, 0x45, REG_BITS_8},
	{0xA2C1, 0x2e, REG_BITS_8},
	{0xA2C2, 0x85, REG_BITS_8},
	{0xA2C3, 0xb9, REG_BITS_8},
	{0xA2C4, 0x8c, REG_BITS_8},
	{0xA2C5, 0x63, REG_BITS_8},
	{0xA2C6, 0xde, REG_BITS_8},
	{0xA2C7, 0x02, REG_BITS_8},
	{0xA2C8, 0x96, REG_BITS_8},
	{0xA2C9, 0xae, REG_BITS_8},
	{0xA2CA, 0x98, REG_BITS_8},
	{0xA2CB, 0x45, REG_BITS_8},
	{0xA2CC, 0x2f, REG_BITS_8},
	{0xA2CD, 0x9e, REG_BITS_8},
	{0xA2CE, 0x59, REG_BITS_8},
	{0xA2CF, 0xcd, REG_BITS_8},
	{0xA2D0, 0x6c, REG_BITS_8},
	{0xA2D1, 0x6c, REG_BITS_8},
	{0xA2D2, 0x23, REG_BITS_8},
	{0xA2D3, 0x1a, REG_BITS_8},
	{0xA2D4, 0xca, REG_BITS_8},
	{0xA2D5, 0x4c, REG_BITS_8},
	{0xA2D6, 0x66, REG_BITS_8},
	{0xA2D7, 0x33, REG_BITS_8},
	{0xA2D8, 0xae, REG_BITS_8},
	{0xA2D9, 0x39, REG_BITS_8},
	{0xA2DA, 0x0e, REG_BITS_8},
	{0xA2DB, 0x72, REG_BITS_8},
	{0xA2DC, 0x30, REG_BITS_8},
	{0xA2DD, 0x63, REG_BITS_8},
	{0xA2DE, 0x9a, REG_BITS_8},
	{0xA2DF, 0xd2, REG_BITS_8},
	{0xA2E0, 0x64, REG_BITS_8},
	{0xA2E1, 0x26, REG_BITS_8},
	{0xA2E2, 0x33, REG_BITS_8},
	{0xA2E3, 0x9f, REG_BITS_8},
	{0xA2E4, 0x81, REG_BITS_8},
	{0xA2E5, 0xcd, REG_BITS_8},
	{0xA2E6, 0x6d, REG_BITS_8},
	{0xA2E7, 0x50, REG_BITS_8},
	{0xA2E8, 0x03, REG_BITS_8},
	{0xA2E9, 0x13, REG_BITS_8},
	{0xA2EA, 0xbc, REG_BITS_8},
	{0xA2EB, 0x44, REG_BITS_8},
	{0xA2EC, 0x14, REG_BITS_8},
	{0xA2ED, 0xa6, REG_BITS_8},
	{0xA2EE, 0xcd, REG_BITS_8},
	{0xA2EF, 0xb9, REG_BITS_8},
	{0xA2F0, 0x0e, REG_BITS_8},
	{0xA2F1, 0x74, REG_BITS_8},
	{0xA2F2, 0x7c, REG_BITS_8},
	{0xA2F3, 0x83, REG_BITS_8},
	{0xA2F4, 0x1b, REG_BITS_8},
	{0xA2F5, 0xe0, REG_BITS_8},
	{0xA2F6, 0x4c, REG_BITS_8},
	{0xA2F7, 0xa7, REG_BITS_8},
	{0xA2F8, 0x3b, REG_BITS_8},
	{0xA2F9, 0xc8, REG_BITS_8},
	{0xA2FA, 0x21, REG_BITS_8},
	{0xA2FB, 0x8f, REG_BITS_8},
	{0xA2FC, 0x78, REG_BITS_8},
	{0xA2FD, 0x90, REG_BITS_8},
	{0xA2FE, 0x43, REG_BITS_8},
	{0xA2FF, 0x1b, REG_BITS_8},
	{0xA300, 0xd7, REG_BITS_8},
	{0xA301, 0xd8, REG_BITS_8},
	{0xA302, 0x86, REG_BITS_8},
	{0xA303, 0x39, REG_BITS_8},
	{0xA304, 0xeb, REG_BITS_8},
	{0xA305, 0x59, REG_BITS_8},
	{0xA306, 0xcf, REG_BITS_8},
	{0xA307, 0x70, REG_BITS_8},
	{0xA308, 0x68, REG_BITS_8},
	{0xA309, 0x83, REG_BITS_8},
	{0xA30A, 0x98, REG_BITS_8},
	{0xA30B, 0xb9, REG_BITS_8},
	{0xA30C, 0xb8, REG_BITS_8},
	{0xA30D, 0xa5, REG_BITS_8},
	{0xA30E, 0x2e, REG_BITS_8},
	{0xA30F, 0x8c, REG_BITS_8},
	{0xA310, 0xc9, REG_BITS_8},
	{0xA311, 0x8d, REG_BITS_8},
	{0xA312, 0x72, REG_BITS_8},
	{0xA313, 0x34, REG_BITS_8},
	{0xA314, 0x33, REG_BITS_8},
	{0xA315, 0x98, REG_BITS_8},
	{0xA316, 0xae, REG_BITS_8},
	{0xA317, 0x0c, REG_BITS_8},
	{0xA318, 0x45, REG_BITS_8},
	{0xA319, 0x27, REG_BITS_8},
	{0xA31A, 0x46, REG_BITS_8},
	{0xA31B, 0x09, REG_BITS_8},
	{0xA31C, 0x4b, REG_BITS_8},
	{0xA31D, 0x62, REG_BITS_8},
	{0xA31E, 0x46, REG_BITS_8},
	{0xA31F, 0x03, REG_BITS_8},
	{0xA320, 0x98, REG_BITS_8},
	{0xA321, 0xb3, REG_BITS_8},
	{0xA322, 0xf0, REG_BITS_8},
	{0xA323, 0x44, REG_BITS_8},
	{0xA324, 0x23, REG_BITS_8},
	{0xA325, 0x10, REG_BITS_8},
	{0xA326, 0xe9, REG_BITS_8},
	{0xA327, 0x48, REG_BITS_8},
	{0xA328, 0x50, REG_BITS_8},
	{0xA329, 0xdc, REG_BITS_8},
	{0xA32A, 0x92, REG_BITS_8},
	{0xA32B, 0x98, REG_BITS_8},
	{0xA32C, 0xb7, REG_BITS_8},
	{0xA32D, 0x64, REG_BITS_8},
	{0xA32E, 0x25, REG_BITS_8},
	{0xA32F, 0x25, REG_BITS_8},
	{0xA330, 0x07, REG_BITS_8},
	{0xA331, 0xf1, REG_BITS_8},
	{0xA332, 0xc7, REG_BITS_8},
	{0xA333, 0x42, REG_BITS_8},
	{0xA334, 0x60, REG_BITS_8},
	{0xA335, 0x22, REG_BITS_8},
	{0xA336, 0x96, REG_BITS_8},
	{0xA337, 0xbc, REG_BITS_8},
	{0xA338, 0xc0, REG_BITS_8},
	{0xA339, 0x65, REG_BITS_8},
	{0xA33A, 0x2b, REG_BITS_8},
	{0xA33B, 0x2c, REG_BITS_8},
	{0xA33C, 0x51, REG_BITS_8},
	{0xA33D, 0x48, REG_BITS_8},
	{0xA33E, 0x40, REG_BITS_8},
	{0xA33F, 0x1c, REG_BITS_8},
	{0xA340, 0x32, REG_BITS_8},
	{0xA341, 0x13, REG_BITS_8},
	{0xA342, 0xb2, REG_BITS_8},
	{0xA343, 0xe8, REG_BITS_8},
	{0xA344, 0x65, REG_BITS_8},
	{0xA345, 0x30, REG_BITS_8},
	{0xA346, 0x6b, REG_BITS_8},
	{0xA347, 0x11, REG_BITS_8},
	{0xA348, 0x4a, REG_BITS_8},
	{0xA349, 0x48, REG_BITS_8},
	{0xA34A, 0x30, REG_BITS_8},
	{0xA34B, 0x62, REG_BITS_8},
	{0xA34C, 0x92, REG_BITS_8},
	{0xA34D, 0xa4, REG_BITS_8},
	{0xA34E, 0xcc, REG_BITS_8},
	{0xA34F, 0x45, REG_BITS_8},
	{0xA350, 0x31, REG_BITS_8},
	{0xA351, 0xa1, REG_BITS_8},
	{0xA352, 0x59, REG_BITS_8},
	{0xA353, 0x0c, REG_BITS_8},
	{0xA354, 0x5a, REG_BITS_8},
	{0xA355, 0x9e, REG_BITS_8},
	{0xA356, 0x72, REG_BITS_8},
	{0xA357, 0x94, REG_BITS_8},
	{0xA358, 0xa9, REG_BITS_8},
	{0xA359, 0xac, REG_BITS_8},
	{0xA35A, 0xc5, REG_BITS_8},
	{0xA35B, 0x31, REG_BITS_8},
	{0xA35C, 0xa6, REG_BITS_8},
	{0xA35D, 0x71, REG_BITS_8},
	{0xA35E, 0x0e, REG_BITS_8},
	{0xA35F, 0x70, REG_BITS_8},
	{0xA360, 0x2e, REG_BITS_8},
	{0xA361, 0x13, REG_BITS_8},
	{0xA362, 0x18, REG_BITS_8},
	{0xA363, 0xbd, REG_BITS_8},
	{0xA364, 0x08, REG_BITS_8},
	{0xA365, 0x26, REG_BITS_8},
	{0xA366, 0x33, REG_BITS_8},
	{0xA367, 0xc2, REG_BITS_8},
	{0xA368, 0x91, REG_BITS_8},
	{0xA369, 0xce, REG_BITS_8},
	{0xA36A, 0x7b, REG_BITS_8},
	{0xA36B, 0xe2, REG_BITS_8},
	{0xA36C, 0x73, REG_BITS_8},
	{0xA36D, 0x1d, REG_BITS_8},
	{0xA36E, 0xe1, REG_BITS_8},
	{0xA36F, 0xf4, REG_BITS_8},
	{0xA370, 0x66, REG_BITS_8},
	{0xA371, 0x38, REG_BITS_8},
	{0xA372, 0xd8, REG_BITS_8},
	{0xA373, 0x91, REG_BITS_8},
	{0xA374, 0x4f, REG_BITS_8},
	{0xA375, 0x7c, REG_BITS_8},
	{0xA376, 0xa4, REG_BITS_8},
	{0xA377, 0x13, REG_BITS_8},
	{0xA378, 0x1e, REG_BITS_8},
	{0xA379, 0xed, REG_BITS_8},
	{0xA37A, 0x28, REG_BITS_8},
	{0xA37B, 0x07, REG_BITS_8},
	{0xA37C, 0x39, REG_BITS_8},
	{0xA37D, 0xca, REG_BITS_8},
	{0xA37E, 0xd1, REG_BITS_8},
	{0xA37F, 0x4e, REG_BITS_8},
	{0xA380, 0x78, REG_BITS_8},
	{0xA381, 0x96, REG_BITS_8},
	{0xA382, 0xb3, REG_BITS_8},
	{0xA383, 0x98, REG_BITS_8},
	{0xA384, 0xc9, REG_BITS_8},
	{0xA385, 0x38, REG_BITS_8},
	{0xA386, 0x46, REG_BITS_8},
	{0xA387, 0x30, REG_BITS_8},
	{0xA388, 0x8b, REG_BITS_8},
	{0xA389, 0x99, REG_BITS_8},
	{0xA38A, 0x8c, REG_BITS_8},
	{0xA38B, 0x63, REG_BITS_8},
	{0xA38C, 0x04, REG_BITS_8},
	{0xA38D, 0xc3, REG_BITS_8},
	{0xA38E, 0x17, REG_BITS_8},
	{0xA38F, 0xc4, REG_BITS_8},
	{0xA390, 0x64, REG_BITS_8},
	{0xA391, 0x46, REG_BITS_8},
	{0xA392, 0x33, REG_BITS_8},
	{0xA393, 0x88, REG_BITS_8},
	{0xA394, 0xf1, REG_BITS_8},
	{0xA395, 0x4c, REG_BITS_8},
	{0xA396, 0x67, REG_BITS_8},
	{0xA397, 0x10, REG_BITS_8},
	{0xA398, 0xb3, REG_BITS_8},
	{0xA399, 0x17, REG_BITS_8},
	{0xA39A, 0xbb, REG_BITS_8},
	{0xA39B, 0x00, REG_BITS_8},
	{0xA39C, 0x66, REG_BITS_8},
	{0xA39D, 0x32, REG_BITS_8},
	{0xA39E, 0xa6, REG_BITS_8},
	{0xA39F, 0x21, REG_BITS_8},
	{0xA3A0, 0x0d, REG_BITS_8},
	{0xA3A1, 0x61, REG_BITS_8},
	{0xA3A2, 0xf6, REG_BITS_8},
	{0xA3A3, 0xa2, REG_BITS_8},
	{0xA3A4, 0x15, REG_BITS_8},
	{0xA3A5, 0xa6, REG_BITS_8},
	{0xA3A6, 0x20, REG_BITS_8},
	{0xA3A7, 0xe5, REG_BITS_8},
	{0xA3A8, 0x29, REG_BITS_8},
	{0xA3A9, 0x60, REG_BITS_8},
	{0xA3AA, 0x11, REG_BITS_8},
	{0xA3AB, 0x8c, REG_BITS_8},
	{0xA3AC, 0x63, REG_BITS_8},
	{0xA3AD, 0xc8, REG_BITS_8},
	{0xA3AE, 0x72, REG_BITS_8},
	{0xA3AF, 0x95, REG_BITS_8},
	{0xA3B0, 0x9f, REG_BITS_8},
	{0xA3B1, 0xbc, REG_BITS_8},
	{0xA3B2, 0x24, REG_BITS_8},
	{0xA3B3, 0x25, REG_BITS_8},
	{0xA3B4, 0x30, REG_BITS_8},
	{0xA3B5, 0x09, REG_BITS_8},
	{0xA3B6, 0x8a, REG_BITS_8},
	{0xA3B7, 0x57, REG_BITS_8},
	{0xA3B8, 0xe2, REG_BITS_8},
	{0xA3B9, 0x22, REG_BITS_8},
	{0xA3BA, 0x95, REG_BITS_8},
	{0xA3BB, 0xa2, REG_BITS_8},
	{0xA3BC, 0xa4, REG_BITS_8},
	{0xA3BD, 0x64, REG_BITS_8},
	{0xA3BE, 0x22, REG_BITS_8},
	{0xA3BF, 0x0d, REG_BITS_8},
	{0xA3C0, 0xa9, REG_BITS_8},
	{0xA3C1, 0x88, REG_BITS_8},
	{0xA3C2, 0x4b, REG_BITS_8},
	{0xA3C3, 0x96, REG_BITS_8},
	{0xA3C4, 0xa2, REG_BITS_8},
	{0xA3C5, 0x15, REG_BITS_8},
	{0xA3C6, 0xa1, REG_BITS_8},
	{0xA3C7, 0xe0, REG_BITS_8},
	{0xA3C8, 0x84, REG_BITS_8},
	{0xA3C9, 0x23, REG_BITS_8},
	{0xA3CA, 0x05, REG_BITS_8},
	{0xA3CB, 0x01, REG_BITS_8},
	{0xA3CC, 0x88, REG_BITS_8},
	{0xA3CD, 0x41, REG_BITS_8},
	{0xA3CE, 0x42, REG_BITS_8},
	{0xA3CF, 0x12, REG_BITS_8},
	{0xA3D0, 0x14, REG_BITS_8},
	{0xA3D1, 0xa6, REG_BITS_8},
	{0xA3D2, 0x10, REG_BITS_8},
	{0xA3D3, 0x45, REG_BITS_8},
	{0xA3D4, 0x27, REG_BITS_8},
	{0xA3D5, 0x1d, REG_BITS_8},
	{0xA3D6, 0x31, REG_BITS_8},
	{0xA3D7, 0xc8, REG_BITS_8},
	{0xA3D8, 0x3f, REG_BITS_8},
	{0xA3D9, 0x0e, REG_BITS_8},
	{0xA3DA, 0x12, REG_BITS_8},
	{0xA3DB, 0x92, REG_BITS_8},
	{0xA3DC, 0x9f, REG_BITS_8},
	{0xA3DD, 0x28, REG_BITS_8},
	{0xA3DE, 0xe5, REG_BITS_8},
	{0xA3DF, 0x2a, REG_BITS_8},
	{0xA3E0, 0x49, REG_BITS_8},
	{0xA3E1, 0x69, REG_BITS_8},
	{0xA3E2, 0x89, REG_BITS_8},
	{0xA3E3, 0x45, REG_BITS_8},
	{0xA3E4, 0x1c, REG_BITS_8},
	{0xA3E5, 0x72, REG_BITS_8},
	{0xA3E6, 0x11, REG_BITS_8},
	{0xA3E7, 0x97, REG_BITS_8},
	{0xA3E8, 0x1c, REG_BITS_8},
	{0xA3E9, 0x65, REG_BITS_8},
	{0xA3EA, 0x2a, REG_BITS_8},
	{0xA3EB, 0x71, REG_BITS_8},
	{0xA3EC, 0x11, REG_BITS_8},
	{0xA3ED, 0x4b, REG_BITS_8},
	{0xA3EE, 0x51, REG_BITS_8},
	{0xA3EF, 0x62, REG_BITS_8},
	{0xA3F0, 0xb2, REG_BITS_8},
	{0xA3F1, 0x92, REG_BITS_8},
	{0xA3F2, 0x99, REG_BITS_8},
	{0xA3F3, 0x00, REG_BITS_8},
	{0xA3F4, 0xe5, REG_BITS_8},
	{0xA3F5, 0x2a, REG_BITS_8},
	{0xA3F6, 0x67, REG_BITS_8},
	{0xA3F7, 0x81, REG_BITS_8},
	{0xA3F8, 0x8c, REG_BITS_8},
	{0xA3F9, 0x61, REG_BITS_8},
	{0xA3FA, 0xc6, REG_BITS_8},
	{0xA3FB, 0x32, REG_BITS_8},
	{0xA3FC, 0x95, REG_BITS_8},
	{0xA3FD, 0xa5, REG_BITS_8},
	{0xA3FE, 0x30, REG_BITS_8},
	{0xA3FF, 0x45, REG_BITS_8},
	{0xA400, 0x2b, REG_BITS_8},
	{0xA401, 0x77, REG_BITS_8},
	{0xA402, 0x09, REG_BITS_8},
	{0xA403, 0x8c, REG_BITS_8},
	{0xA404, 0x6a, REG_BITS_8},
	{0xA405, 0x54, REG_BITS_8},
	{0xA406, 0x43, REG_BITS_8},
	{0xA407, 0x19, REG_BITS_8},
	{0xA408, 0xc1, REG_BITS_8},
	{0xA409, 0xdc, REG_BITS_8},
	{0xA40A, 0x45, REG_BITS_8},
	{0xA40B, 0x2f, REG_BITS_8},
	{0xA40C, 0x87, REG_BITS_8},
	{0xA40D, 0xd9, REG_BITS_8},
	{0xA40E, 0x0c, REG_BITS_8},
	{0xA40F, 0x67, REG_BITS_8},
	{0xA410, 0x28, REG_BITS_8},
	{0xA411, 0x03, REG_BITS_8},
	{0xA412, 0x1a, REG_BITS_8},
	{0xA413, 0xcc, REG_BITS_8},
	{0xA414, 0x1c, REG_BITS_8},
	{0xA415, 0xc6, REG_BITS_8},
	{0xA416, 0x2f, REG_BITS_8},
	{0xA417, 0x80, REG_BITS_8},
	{0xA418, 0x51, REG_BITS_8},
	{0xA419, 0x4c, REG_BITS_8},
	{0xA41A, 0x64, REG_BITS_8},
	{0xA41B, 0x06, REG_BITS_8},
	{0xA41C, 0x03, REG_BITS_8},
	{0xA41D, 0x00, REG_BITS_8},
	{0xA41E, 0x00, REG_BITS_8},
	{0xA41F, 0x00, REG_BITS_8},
	{0xA420, 0x00, REG_BITS_8},
	{0xA421, 0x0a, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_0_SHD_3_ES2 = sizeof(seix006_vendor_0_SHD_3_ES2);

const struct reg_entry seix006_vendor_1_SHD_1_ES2[] = {
	{0x0068, 0x50, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x01, REG_BITS_8},
	{0x9003, 0x0c, REG_BITS_8},
	{0x9004, 0x04, REG_BITS_8},
	{0x9005, 0x30, REG_BITS_8},
	{0x9006, 0xf0, REG_BITS_8},
	{0x9007, 0xff, REG_BITS_8},
	{0x9008, 0xc0, REG_BITS_8},
	{0x9009, 0x7f, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x01, REG_BITS_8},
	{0x900C, 0x12, REG_BITS_8},
	{0x900D, 0x08, REG_BITS_8},
	{0x900E, 0x50, REG_BITS_8},
	{0x900F, 0x20, REG_BITS_8},
	{0x9010, 0x20, REG_BITS_8},
	{0x9011, 0x81, REG_BITS_8},
	{0x9012, 0x00, REG_BITS_8},
	{0x9013, 0x04, REG_BITS_8},
	{0x9014, 0x02, REG_BITS_8},
	{0x9015, 0x10, REG_BITS_8},
	{0x9016, 0x04, REG_BITS_8},
	{0x9017, 0x30, REG_BITS_8},
	{0x9018, 0x10, REG_BITS_8},
	{0x9019, 0xc0, REG_BITS_8},
	{0x901A, 0xc0, REG_BITS_8},
	{0x901B, 0xff, REG_BITS_8},
	{0x901C, 0x03, REG_BITS_8},
	{0x901D, 0xff, REG_BITS_8},
	{0x901E, 0x11, REG_BITS_8},
	{0x901F, 0x04, REG_BITS_8},
	{0x9020, 0x48, REG_BITS_8},
	{0x9021, 0x20, REG_BITS_8},
	{0x9022, 0x40, REG_BITS_8},
	{0x9023, 0x81, REG_BITS_8},
	{0x9024, 0x80, REG_BITS_8},
	{0x9025, 0x04, REG_BITS_8},
	{0x9026, 0x02, REG_BITS_8},
	{0x9027, 0x10, REG_BITS_8},
	{0x9028, 0x08, REG_BITS_8},
	{0x9029, 0x40, REG_BITS_8},
	{0x902A, 0x00, REG_BITS_8},
	{0x902B, 0xc0, REG_BITS_8},
	{0x902C, 0x00, REG_BITS_8},
	{0x902D, 0x00, REG_BITS_8},
	{0x902E, 0x03, REG_BITS_8},
	{0x902F, 0x01, REG_BITS_8},
	{0x9030, 0x0e, REG_BITS_8},
	{0x9031, 0x00, REG_BITS_8},
	{0x9032, 0x30, REG_BITS_8},
	{0x9033, 0x00, REG_BITS_8},
	{0x9034, 0xe0, REG_BITS_8},
	{0x9035, 0xc0, REG_BITS_8},
	{0x9036, 0x80, REG_BITS_8},
	{0x9037, 0x03, REG_BITS_8},
	{0x9038, 0x02, REG_BITS_8},
	{0x9039, 0x14, REG_BITS_8},
	{0x903A, 0x0c, REG_BITS_8},
	{0x903B, 0x48, REG_BITS_8},
	{0x903C, 0x30, REG_BITS_8},
	{0x903D, 0x20, REG_BITS_8},
	{0x903E, 0x01, REG_BITS_8},
	{0x903F, 0x00, REG_BITS_8},
	{0x9040, 0x03, REG_BITS_8},
	{0x9041, 0x00, REG_BITS_8},
	{0x9042, 0x0c, REG_BITS_8},
	{0x9043, 0x04, REG_BITS_8},
	{0x9044, 0x30, REG_BITS_8},
	{0x9045, 0x10, REG_BITS_8},
	{0x9046, 0xa0, REG_BITS_8},
	{0x9047, 0x00, REG_BITS_8},
	{0x9048, 0x80, REG_BITS_8},
	{0x9049, 0x01, REG_BITS_8},
	{0x904A, 0x00, REG_BITS_8},
	{0x904B, 0x0c, REG_BITS_8},
	{0x904C, 0x04, REG_BITS_8},
	{0x904D, 0x30, REG_BITS_8},
	{0x904E, 0x30, REG_BITS_8},
	{0x904F, 0xe0, REG_BITS_8},
	{0x9050, 0xc0, REG_BITS_8},
	{0x9051, 0x80, REG_BITS_8},
	{0x9052, 0x03, REG_BITS_8},
	{0x9053, 0x04, REG_BITS_8},
	{0x9054, 0x0a, REG_BITS_8},
	{0x9055, 0x10, REG_BITS_8},
	{0x9056, 0x28, REG_BITS_8},
	{0x9057, 0x20, REG_BITS_8},
	{0x9058, 0x60, REG_BITS_8},
	{0x9059, 0xc0, REG_BITS_8},
	{0x905A, 0x00, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x03, REG_BITS_8},
	{0x905D, 0x02, REG_BITS_8},
	{0x905E, 0x00, REG_BITS_8},
	{0x905F, 0x18, REG_BITS_8},
	{0x9060, 0x10, REG_BITS_8},
	{0x9061, 0x60, REG_BITS_8},
	{0x9062, 0x00, REG_BITS_8},
	{0x9063, 0x80, REG_BITS_8},
	{0x9064, 0x02, REG_BITS_8},
	{0x9065, 0x00, REG_BITS_8},
	{0x9066, 0x0a, REG_BITS_8},
	{0x9067, 0x04, REG_BITS_8},
	{0x9068, 0x20, REG_BITS_8},
	{0x9069, 0x10, REG_BITS_8},
	{0x906A, 0x80, REG_BITS_8},
	{0x906B, 0x80, REG_BITS_8},
	{0x906C, 0x80, REG_BITS_8},
	{0x906D, 0x00, REG_BITS_8},
	{0x906E, 0x03, REG_BITS_8},
	{0x906F, 0x00, REG_BITS_8},
	{0x9070, 0x04, REG_BITS_8},
	{0x9071, 0x00, REG_BITS_8},
	{0x9072, 0x00, REG_BITS_8},
	{0x9073, 0x00, REG_BITS_8},
	{0x9074, 0x40, REG_BITS_8},
	{0x9075, 0x80, REG_BITS_8},
	{0x9076, 0x01, REG_BITS_8},
	{0x9077, 0x01, REG_BITS_8},
	{0x9078, 0x0a, REG_BITS_8},
	{0x9079, 0x04, REG_BITS_8},
	{0x907A, 0x28, REG_BITS_8},
	{0x907B, 0x30, REG_BITS_8},
	{0x907C, 0x40, REG_BITS_8},
	{0x907D, 0xc0, REG_BITS_8},
	{0x907E, 0x00, REG_BITS_8},
	{0x907F, 0x01, REG_BITS_8},
	{0x9080, 0x03, REG_BITS_8},
	{0x9081, 0x00, REG_BITS_8},
	{0x9082, 0x08, REG_BITS_8},
	{0x9083, 0xf8, REG_BITS_8},
	{0x9084, 0x3f, REG_BITS_8},
	{0x9085, 0xc0, REG_BITS_8},
	{0x9086, 0xbf, REG_BITS_8},
	{0x9087, 0x00, REG_BITS_8},
	{0x9088, 0x00, REG_BITS_8},
	{0x9089, 0x01, REG_BITS_8},
	{0x908A, 0x02, REG_BITS_8},
	{0x908B, 0x10, REG_BITS_8},
	{0x908C, 0x20, REG_BITS_8},
	{0x908D, 0x40, REG_BITS_8},
	{0x908E, 0x80, REG_BITS_8},
	{0x908F, 0x80, REG_BITS_8},
	{0x9090, 0x80, REG_BITS_8},
	{0x9091, 0x01, REG_BITS_8},
	{0x9092, 0x02, REG_BITS_8},
	{0x9093, 0x06, REG_BITS_8},
	{0x9094, 0x08, REG_BITS_8},
	{0x9095, 0x00, REG_BITS_8},
	{0x9096, 0x20, REG_BITS_8},
	{0x9097, 0xe0, REG_BITS_8},
	{0x9098, 0x3f, REG_BITS_8},
	{0x9099, 0x81, REG_BITS_8},
	{0x909A, 0xff, REG_BITS_8},
	{0x909B, 0x03, REG_BITS_8},
	{0x909C, 0x00, REG_BITS_8},
	{0x909D, 0x04, REG_BITS_8},
	{0x909E, 0x08, REG_BITS_8},
	{0x909F, 0x30, REG_BITS_8},
	{0x90A0, 0x80, REG_BITS_8},
	{0x90A1, 0xc0, REG_BITS_8},
	{0x90A2, 0x00, REG_BITS_8},
	{0x90A3, 0x02, REG_BITS_8},
	{0x90A4, 0x03, REG_BITS_8},
	{0x90A5, 0x04, REG_BITS_8},
	{0x90A6, 0x0c, REG_BITS_8},
	{0x90A7, 0x10, REG_BITS_8},
	{0x90A8, 0x40, REG_BITS_8},
	{0x90A9, 0x40, REG_BITS_8},
	{0x90AA, 0x40, REG_BITS_8},
	{0x90AB, 0x01, REG_BITS_8},
	{0x90AC, 0x00, REG_BITS_8},
	{0x90AD, 0x05, REG_BITS_8},
	{0x90AE, 0x02, REG_BITS_8},
	{0x90AF, 0x04, REG_BITS_8},
	{0x90B0, 0x08, REG_BITS_8},
	{0x90B1, 0x30, REG_BITS_8},
	{0x90B2, 0x40, REG_BITS_8},
	{0x90B3, 0x00, REG_BITS_8},
	{0x90B4, 0x01, REG_BITS_8},
	{0x90B5, 0x03, REG_BITS_8},
	{0x90B6, 0x04, REG_BITS_8},
	{0x90B7, 0x0c, REG_BITS_8},
	{0x90B8, 0x08, REG_BITS_8},
	{0x90B9, 0x28, REG_BITS_8},
	{0x90BA, 0x20, REG_BITS_8},
	{0x90BB, 0xa0, REG_BITS_8},
	{0x90BC, 0x00, REG_BITS_8},
	{0x90BD, 0x01, REG_BITS_8},
	{0x90BE, 0x02, REG_BITS_8},
	{0x90BF, 0x02, REG_BITS_8},
	{0x90C0, 0x0a, REG_BITS_8},
	{0x90C1, 0x10, REG_BITS_8},
	{0x90C2, 0x20, REG_BITS_8},
	{0x90C3, 0x40, REG_BITS_8},
	{0x90C4, 0x60, REG_BITS_8},
	{0x90C5, 0x00, REG_BITS_8},
	{0x90C6, 0x01, REG_BITS_8},
	{0x90C7, 0x02, REG_BITS_8},
	{0x90C8, 0x04, REG_BITS_8},
	{0x90C9, 0x0a, REG_BITS_8},
	{0x90CA, 0x10, REG_BITS_8},
	{0x90CB, 0x28, REG_BITS_8},
	{0x90CC, 0x40, REG_BITS_8},
	{0x90CD, 0x80, REG_BITS_8},
	{0x90CE, 0x00, REG_BITS_8},
	{0x90CF, 0x01, REG_BITS_8},
	{0x90D0, 0x02, REG_BITS_8},
	{0x90D1, 0x03, REG_BITS_8},
	{0x90D2, 0x0e, REG_BITS_8},
	{0x90D3, 0x0c, REG_BITS_8},
	{0x90D4, 0x30, REG_BITS_8},
	{0x90D5, 0x50, REG_BITS_8},
	{0x90D6, 0xe0, REG_BITS_8},
	{0x90D7, 0x40, REG_BITS_8},
	{0x90D8, 0x01, REG_BITS_8},
	{0x90D9, 0x03, REG_BITS_8},
	{0x90DA, 0x04, REG_BITS_8},
	{0x90DB, 0x0a, REG_BITS_8},
	{0x90DC, 0x10, REG_BITS_8},
	{0x90DD, 0x30, REG_BITS_8},
	{0x90DE, 0x40, REG_BITS_8},
	{0x90DF, 0xc0, REG_BITS_8},
	{0x90E0, 0x00, REG_BITS_8},
	{0x90E1, 0x01, REG_BITS_8},
	{0x90E2, 0x02, REG_BITS_8},
	{0x90E3, 0x04, REG_BITS_8},
	{0x90E4, 0x08, REG_BITS_8},
	{0x90E5, 0x0c, REG_BITS_8},
	{0x90E6, 0x38, REG_BITS_8},
	{0x90E7, 0x30, REG_BITS_8},
	{0x90E8, 0xc0, REG_BITS_8},
	{0x90E9, 0x40, REG_BITS_8},
	{0x90EA, 0x81, REG_BITS_8},
	{0x90EB, 0x03, REG_BITS_8},
	{0x90EC, 0x05, REG_BITS_8},
	{0x90ED, 0x0c, REG_BITS_8},
	{0x90EE, 0x10, REG_BITS_8},
	{0x90EF, 0x28, REG_BITS_8},
	{0x90F0, 0x40, REG_BITS_8},
	{0x90F1, 0xc0, REG_BITS_8},
	{0x90F2, 0x00, REG_BITS_8},
	{0x90F3, 0x01, REG_BITS_8},
	{0x90F4, 0x03, REG_BITS_8},
	{0x90F5, 0x02, REG_BITS_8},
	{0x90F6, 0xde, REG_BITS_8},
	{0x90F7, 0x0b, REG_BITS_8},
	{0x90F8, 0x78, REG_BITS_8},
	{0x90F9, 0x3f, REG_BITS_8},
	{0x90FA, 0x80, REG_BITS_8},
	{0x90FB, 0x3e, REG_BITS_8},
	{0x90FC, 0x80, REG_BITS_8},
	{0x90FD, 0xf9, REG_BITS_8},
	{0x90FE, 0x02, REG_BITS_8},
	{0x90FF, 0xe8, REG_BITS_8},
	{0x9100, 0x07, REG_BITS_8},
	{0x9101, 0x98, REG_BITS_8},
	{0x9102, 0x1f, REG_BITS_8},
	{0x9103, 0xe0, REG_BITS_8},
	{0x9104, 0xfe, REG_BITS_8},
	{0x9105, 0xff, REG_BITS_8},
	{0x9106, 0xfa, REG_BITS_8},
	{0x9107, 0xff, REG_BITS_8},
	{0x9108, 0xeb, REG_BITS_8},
	{0x9109, 0x0b, REG_BITS_8},
	{0x910A, 0x78, REG_BITS_8},
	{0x910B, 0x2f, REG_BITS_8},
	{0x910C, 0xe0, REG_BITS_8},
	{0x910D, 0xfd, REG_BITS_8},
	{0x910E, 0x00, REG_BITS_8},
	{0x910F, 0xfa, REG_BITS_8},
	{0x9110, 0x00, REG_BITS_8},
	{0x9111, 0xe6, REG_BITS_8},
	{0x9112, 0x0b, REG_BITS_8},
	{0x9113, 0xa0, REG_BITS_8},
	{0x9114, 0x1f, REG_BITS_8},
	{0x9115, 0x60, REG_BITS_8},
	{0x9116, 0x7e, REG_BITS_8},
	{0x9117, 0x80, REG_BITS_8},
	{0x9118, 0xfb, REG_BITS_8},
	{0x9119, 0xff, REG_BITS_8},
	{0x911A, 0xeb, REG_BITS_8},
	{0x911B, 0xff, REG_BITS_8},
	{0x911C, 0xaf, REG_BITS_8},
	{0x911D, 0x5f, REG_BITS_8},
	{0x911E, 0x60, REG_BITS_8},
	{0x911F, 0x7e, REG_BITS_8},
	{0x9120, 0x81, REG_BITS_8},
	{0x9121, 0xf9, REG_BITS_8},
	{0x9122, 0x02, REG_BITS_8},
	{0x9123, 0xe6, REG_BITS_8},
	{0x9124, 0x03, REG_BITS_8},
	{0x9125, 0x98, REG_BITS_8},
	{0x9126, 0x0f, REG_BITS_8},
	{0x9127, 0x20, REG_BITS_8},
	{0x9128, 0x7e, REG_BITS_8},
	{0x9129, 0x80, REG_BITS_8},
	{0x912A, 0xfb, REG_BITS_8},
	{0x912B, 0x00, REG_BITS_8},
	{0x912C, 0xe8, REG_BITS_8},
	{0x912D, 0x07, REG_BITS_8},
	{0x912E, 0xb0, REG_BITS_8},
	{0x912F, 0x1f, REG_BITS_8},
	{0x9130, 0xc0, REG_BITS_8},
	{0x9131, 0xbe, REG_BITS_8},
	{0x9132, 0x80, REG_BITS_8},
	{0x9133, 0xfb, REG_BITS_8},
	{0x9134, 0x02, REG_BITS_8},
	{0x9135, 0xee, REG_BITS_8},
	{0x9136, 0x0f, REG_BITS_8},
	{0x9137, 0xc0, REG_BITS_8},
	{0x9138, 0x0f, REG_BITS_8},
	{0x9139, 0x80, REG_BITS_8},
	{0x913A, 0xfe, REG_BITS_8},
	{0x913B, 0xff, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0xff, REG_BITS_8},
	{0x913E, 0xe7, REG_BITS_8},
	{0x913F, 0xff, REG_BITS_8},
	{0x9140, 0xaf, REG_BITS_8},
	{0x9141, 0x1f, REG_BITS_8},
	{0x9142, 0xc0, REG_BITS_8},
	{0x9143, 0x7e, REG_BITS_8},
	{0x9144, 0x00, REG_BITS_8},
	{0x9145, 0xfb, REG_BITS_8},
	{0x9146, 0x04, REG_BITS_8},
	{0x9147, 0xf2, REG_BITS_8},
	{0x9148, 0x13, REG_BITS_8},
	{0x9149, 0xc8, REG_BITS_8},
	{0x914A, 0x0f, REG_BITS_8},
	{0x914B, 0xc0, REG_BITS_8},
	{0x914C, 0xfe, REG_BITS_8},
	{0x914D, 0xff, REG_BITS_8},
	{0x914E, 0xfb, REG_BITS_8},
	{0x914F, 0xfe, REG_BITS_8},
	{0x9150, 0xf1, REG_BITS_8},
	{0x9151, 0xfb, REG_BITS_8},
	{0x9152, 0xc7, REG_BITS_8},
	{0x9153, 0xff, REG_BITS_8},
	{0x9154, 0xff, REG_BITS_8},
	{0x9155, 0x3e, REG_BITS_8},
	{0x9156, 0x00, REG_BITS_8},
	{0x9157, 0xfc, REG_BITS_8},
	{0x9158, 0x00, REG_BITS_8},
	{0x9159, 0xf0, REG_BITS_8},
	{0x915A, 0x13, REG_BITS_8},
	{0x915B, 0xc8, REG_BITS_8},
	{0x915C, 0x4f, REG_BITS_8},
	{0x915D, 0x20, REG_BITS_8},
	{0x915E, 0xbf, REG_BITS_8},
	{0x915F, 0x00, REG_BITS_8},
	{0x9160, 0xfd, REG_BITS_8},
	{0x9161, 0x00, REG_BITS_8},
	{0x9162, 0xf8, REG_BITS_8},
	{0x9163, 0x03, REG_BITS_8},
	{0x9164, 0xe0, REG_BITS_8},
	{0x9165, 0x0f, REG_BITS_8},
	{0x9166, 0x40, REG_BITS_8},
	{0x9167, 0x3f, REG_BITS_8},
	{0x9168, 0x00, REG_BITS_8},
	{0x9169, 0xfd, REG_BITS_8},
	{0x916A, 0x00, REG_BITS_8},
	{0x916B, 0xfa, REG_BITS_8},
	{0x916C, 0x03, REG_BITS_8},
	{0x916D, 0xe8, REG_BITS_8},
	{0x916E, 0x5f, REG_BITS_8},
	{0x916F, 0x80, REG_BITS_8},
	{0x9170, 0x7f, REG_BITS_8},
	{0x9171, 0x01, REG_BITS_8},
	{0x9172, 0xfe, REG_BITS_8},
	{0x9173, 0x01, REG_BITS_8},
	{0x9174, 0xfa, REG_BITS_8},
	{0x9175, 0x07, REG_BITS_8},
	{0x9176, 0xf0, REG_BITS_8},
	{0x9177, 0x1f, REG_BITS_8},
	{0x9178, 0x00, REG_BITS_8},
	{0x9179, 0x00, REG_BITS_8},
	{0x917A, 0x00, REG_BITS_8},
	{0x917B, 0xfe, REG_BITS_8},
	{0x917C, 0x00, REG_BITS_8},
	{0x917D, 0xf8, REG_BITS_8},
	{0x917E, 0x03, REG_BITS_8},
	{0x917F, 0x08, REG_BITS_8},
	{0x9180, 0x00, REG_BITS_8},
	{0x9181, 0x20, REG_BITS_8},
	{0x9182, 0x80, REG_BITS_8},
	{0x9183, 0x81, REG_BITS_8},
	{0x9184, 0xff, REG_BITS_8},
	{0x9185, 0x06, REG_BITS_8},
	{0x9186, 0xfe, REG_BITS_8},
	{0x9187, 0x13, REG_BITS_8},
	{0x9188, 0x00, REG_BITS_8},
	{0x9189, 0x10, REG_BITS_8},
	{0x918A, 0x00, REG_BITS_8},
	{0x918B, 0x40, REG_BITS_8},
	{0x918C, 0x00, REG_BITS_8},
	{0x918D, 0x01, REG_BITS_8},
	{0x918E, 0x00, REG_BITS_8},
	{0x918F, 0x04, REG_BITS_8},
	{0x9190, 0x0c, REG_BITS_8},
	{0x9191, 0x20, REG_BITS_8},
	{0x9192, 0x30, REG_BITS_8},
	{0x9193, 0x20, REG_BITS_8},
	{0x9194, 0xc0, REG_BITS_8},
	{0x9195, 0x80, REG_BITS_8},
	{0x9196, 0x00, REG_BITS_8},
	{0x9197, 0x07, REG_BITS_8},
	{0x9198, 0x08, REG_BITS_8},
	{0x9199, 0x1c, REG_BITS_8},
	{0x919A, 0x20, REG_BITS_8},
	{0x919B, 0x60, REG_BITS_8},
	{0x919C, 0x40, REG_BITS_8},
	{0x919D, 0xc0, REG_BITS_8},
	{0x919E, 0x00, REG_BITS_8},
	{0x919F, 0x02, REG_BITS_8},
	{0x91A0, 0x04, REG_BITS_8},
	{0x91A1, 0x0a, REG_BITS_8},
	{0x91A2, 0x08, REG_BITS_8},
	{0x91A3, 0x20, REG_BITS_8},
	{0x91A4, 0x40, REG_BITS_8},
	{0x91A5, 0x00, REG_BITS_8},
	{0x91A6, 0xc1, REG_BITS_8},
	{0x91A7, 0x00, REG_BITS_8},
	{0x91A8, 0x01, REG_BITS_8},
	{0x91A9, 0x03, REG_BITS_8},
	{0x91AA, 0x04, REG_BITS_8},
	{0x91AB, 0x20, REG_BITS_8},
	{0x91AC, 0x30, REG_BITS_8},
	{0x91AD, 0x80, REG_BITS_8},
	{0x91AE, 0xc0, REG_BITS_8},
	{0x91AF, 0x00, REG_BITS_8},
	{0x91B0, 0x82, REG_BITS_8},
	{0x91B1, 0x01, REG_BITS_8},
	{0x91B2, 0x05, REG_BITS_8},
	{0x91B3, 0x04, REG_BITS_8},
	{0x91B4, 0x14, REG_BITS_8},
	{0x91B5, 0x38, REG_BITS_8},
	{0x91B6, 0x50, REG_BITS_8},
	{0x91B7, 0xc0, REG_BITS_8},
	{0x91B8, 0x80, REG_BITS_8},
	{0x91B9, 0x01, REG_BITS_8},
	{0x91BA, 0x03, REG_BITS_8},
	{0x91BB, 0x06, REG_BITS_8},
	{0x91BC, 0x14, REG_BITS_8},
	{0x91BD, 0x18, REG_BITS_8},
	{0x91BE, 0x50, REG_BITS_8},
	{0x91BF, 0x70, REG_BITS_8},
	{0x91C0, 0x80, REG_BITS_8},
	{0x91C1, 0xc0, REG_BITS_8},
	{0x91C2, 0x01, REG_BITS_8},
	{0x91C3, 0x02, REG_BITS_8},
	{0x91C4, 0x08, REG_BITS_8},
	{0x91C5, 0x0c, REG_BITS_8},
	{0x91C6, 0x20, REG_BITS_8},
	{0x91C7, 0x28, REG_BITS_8},
	{0x91C8, 0x50, REG_BITS_8},
	{0x91C9, 0xc0, REG_BITS_8},
	{0x91CA, 0x00, REG_BITS_8},
	{0x91CB, 0x81, REG_BITS_8},
	{0x91CC, 0x03, REG_BITS_8},
	{0x91CD, 0x05, REG_BITS_8},
	{0x91CE, 0x0c, REG_BITS_8},
	{0x91CF, 0x18, REG_BITS_8},
	{0x91D0, 0x30, REG_BITS_8},
	{0x91D1, 0x60, REG_BITS_8},
	{0x91D2, 0xc0, REG_BITS_8},
	{0x91D3, 0xc0, REG_BITS_8},
	{0x91D4, 0x01, REG_BITS_8},
	{0x91D5, 0x02, REG_BITS_8},
	{0x91D6, 0x07, REG_BITS_8},
	{0x91D7, 0x08, REG_BITS_8},
	{0x91D8, 0x20, REG_BITS_8},
	{0x91D9, 0x30, REG_BITS_8},
	{0x91DA, 0x80, REG_BITS_8},
	{0x91DB, 0xa0, REG_BITS_8},
	{0x91DC, 0x40, REG_BITS_8},
	{0x91DD, 0x01, REG_BITS_8},
	{0x91DE, 0x03, REG_BITS_8},
	{0x91DF, 0x04, REG_BITS_8},
	{0x91E0, 0x0e, REG_BITS_8},
	{0x91E1, 0x14, REG_BITS_8},
	{0x91E2, 0x30, REG_BITS_8},
	{0x91E3, 0x60, REG_BITS_8},
	{0x91E4, 0xc0, REG_BITS_8},
	{0x91E5, 0x80, REG_BITS_8},
	{0x91E6, 0x01, REG_BITS_8},
	{0x91E7, 0x03, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x4a, REG_BITS_8},
	{0xA003, 0x81, REG_BITS_8},
	{0xA004, 0xcc, REG_BITS_8},
	{0xA005, 0x59, REG_BITS_8},
	{0xA006, 0x6a, REG_BITS_8},
	{0xA007, 0x43, REG_BITS_8},
	{0xA008, 0x96, REG_BITS_8},
	{0xA009, 0xdb, REG_BITS_8},
	{0xA00A, 0x74, REG_BITS_8},
	{0xA00B, 0x25, REG_BITS_8},
	{0xA00C, 0x36, REG_BITS_8},
	{0xA00D, 0x5c, REG_BITS_8},
	{0xA00E, 0x89, REG_BITS_8},
	{0xA00F, 0x0d, REG_BITS_8},
	{0xA010, 0x57, REG_BITS_8},
	{0xA011, 0x66, REG_BITS_8},
	{0xA012, 0x23, REG_BITS_8},
	{0xA013, 0x96, REG_BITS_8},
	{0xA014, 0xdc, REG_BITS_8},
	{0xA015, 0x8c, REG_BITS_8},
	{0xA016, 0x05, REG_BITS_8},
	{0xA017, 0x37, REG_BITS_8},
	{0xA018, 0x47, REG_BITS_8},
	{0xA019, 0x99, REG_BITS_8},
	{0xA01A, 0x4c, REG_BITS_8},
	{0xA01B, 0x5c, REG_BITS_8},
	{0xA01C, 0x82, REG_BITS_8},
	{0xA01D, 0x93, REG_BITS_8},
	{0xA01E, 0x17, REG_BITS_8},
	{0xA01F, 0xe5, REG_BITS_8},
	{0xA020, 0xc8, REG_BITS_8},
	{0xA021, 0xa5, REG_BITS_8},
	{0xA022, 0x38, REG_BITS_8},
	{0xA023, 0x6d, REG_BITS_8},
	{0xA024, 0xf1, REG_BITS_8},
	{0xA025, 0xcd, REG_BITS_8},
	{0xA026, 0x5a, REG_BITS_8},
	{0xA027, 0x78, REG_BITS_8},
	{0xA028, 0xd3, REG_BITS_8},
	{0xA029, 0x16, REG_BITS_8},
	{0xA02A, 0xe0, REG_BITS_8},
	{0xA02B, 0xc4, REG_BITS_8},
	{0xA02C, 0xa5, REG_BITS_8},
	{0xA02D, 0x38, REG_BITS_8},
	{0xA02E, 0x74, REG_BITS_8},
	{0xA02F, 0x51, REG_BITS_8},
	{0xA030, 0xce, REG_BITS_8},
	{0xA031, 0x5a, REG_BITS_8},
	{0xA032, 0x80, REG_BITS_8},
	{0xA033, 0xc3, REG_BITS_8},
	{0xA034, 0x96, REG_BITS_8},
	{0xA035, 0xdc, REG_BITS_8},
	{0xA036, 0xc0, REG_BITS_8},
	{0xA037, 0x65, REG_BITS_8},
	{0xA038, 0x37, REG_BITS_8},
	{0xA039, 0x5f, REG_BITS_8},
	{0xA03A, 0x01, REG_BITS_8},
	{0xA03B, 0xcd, REG_BITS_8},
	{0xA03C, 0x54, REG_BITS_8},
	{0xA03D, 0x18, REG_BITS_8},
	{0xA03E, 0xd3, REG_BITS_8},
	{0xA03F, 0x94, REG_BITS_8},
	{0xA040, 0xc1, REG_BITS_8},
	{0xA041, 0x44, REG_BITS_8},
	{0xA042, 0x45, REG_BITS_8},
	{0xA043, 0x31, REG_BITS_8},
	{0xA044, 0x5c, REG_BITS_8},
	{0xA045, 0xf9, REG_BITS_8},
	{0xA046, 0x4c, REG_BITS_8},
	{0xA047, 0x5b, REG_BITS_8},
	{0xA048, 0x74, REG_BITS_8},
	{0xA049, 0x43, REG_BITS_8},
	{0xA04A, 0x96, REG_BITS_8},
	{0xA04B, 0xda, REG_BITS_8},
	{0xA04C, 0x9c, REG_BITS_8},
	{0xA04D, 0x85, REG_BITS_8},
	{0xA04E, 0x35, REG_BITS_8},
	{0xA04F, 0x5f, REG_BITS_8},
	{0xA050, 0xe9, REG_BITS_8},
	{0xA051, 0xcc, REG_BITS_8},
	{0xA052, 0x51, REG_BITS_8},
	{0xA053, 0xe8, REG_BITS_8},
	{0xA054, 0x52, REG_BITS_8},
	{0xA055, 0x93, REG_BITS_8},
	{0xA056, 0xaa, REG_BITS_8},
	{0xA057, 0xb4, REG_BITS_8},
	{0xA058, 0x04, REG_BITS_8},
	{0xA059, 0x29, REG_BITS_8},
	{0xA05A, 0x32, REG_BITS_8},
	{0xA05B, 0x99, REG_BITS_8},
	{0xA05C, 0x8a, REG_BITS_8},
	{0xA05D, 0x50, REG_BITS_8},
	{0xA05E, 0xda, REG_BITS_8},
	{0xA05F, 0x92, REG_BITS_8},
	{0xA060, 0x15, REG_BITS_8},
	{0xA061, 0xca, REG_BITS_8},
	{0xA062, 0x78, REG_BITS_8},
	{0xA063, 0x45, REG_BITS_8},
	{0xA064, 0x34, REG_BITS_8},
	{0xA065, 0x61, REG_BITS_8},
	{0xA066, 0xd1, REG_BITS_8},
	{0xA067, 0x4c, REG_BITS_8},
	{0xA068, 0x54, REG_BITS_8},
	{0xA069, 0xfe, REG_BITS_8},
	{0xA06A, 0x12, REG_BITS_8},
	{0xA06B, 0x13, REG_BITS_8},
	{0xA06C, 0xa6, REG_BITS_8},
	{0xA06D, 0x60, REG_BITS_8},
	{0xA06E, 0xc4, REG_BITS_8},
	{0xA06F, 0x24, REG_BITS_8},
	{0xA070, 0x0e, REG_BITS_8},
	{0xA071, 0xc1, REG_BITS_8},
	{0xA072, 0x08, REG_BITS_8},
	{0xA073, 0x45, REG_BITS_8},
	{0xA074, 0x44, REG_BITS_8},
	{0xA075, 0xc2, REG_BITS_8},
	{0xA076, 0x12, REG_BITS_8},
	{0xA077, 0xa2, REG_BITS_8},
	{0xA078, 0x20, REG_BITS_8},
	{0xA079, 0x65, REG_BITS_8},
	{0xA07A, 0x2e, REG_BITS_8},
	{0xA07B, 0x53, REG_BITS_8},
	{0xA07C, 0x59, REG_BITS_8},
	{0xA07D, 0x4c, REG_BITS_8},
	{0xA07E, 0x55, REG_BITS_8},
	{0xA07F, 0x10, REG_BITS_8},
	{0xA080, 0x63, REG_BITS_8},
	{0xA081, 0x94, REG_BITS_8},
	{0xA082, 0xb6, REG_BITS_8},
	{0xA083, 0x90, REG_BITS_8},
	{0xA084, 0xa4, REG_BITS_8},
	{0xA085, 0x26, REG_BITS_8},
	{0xA086, 0x09, REG_BITS_8},
	{0xA087, 0x71, REG_BITS_8},
	{0xA088, 0xc8, REG_BITS_8},
	{0xA089, 0x3f, REG_BITS_8},
	{0xA08A, 0x00, REG_BITS_8},
	{0xA08B, 0x52, REG_BITS_8},
	{0xA08C, 0x10, REG_BITS_8},
	{0xA08D, 0x85, REG_BITS_8},
	{0xA08E, 0x78, REG_BITS_8},
	{0xA08F, 0xe4, REG_BITS_8},
	{0xA090, 0x25, REG_BITS_8},
	{0xA091, 0x3f, REG_BITS_8},
	{0xA092, 0x19, REG_BITS_8},
	{0xA093, 0x8b, REG_BITS_8},
	{0xA094, 0x52, REG_BITS_8},
	{0xA095, 0xf6, REG_BITS_8},
	{0xA096, 0x62, REG_BITS_8},
	{0xA097, 0x95, REG_BITS_8},
	{0xA098, 0xc3, REG_BITS_8},
	{0xA099, 0x20, REG_BITS_8},
	{0xA09A, 0x85, REG_BITS_8},
	{0xA09B, 0x2d, REG_BITS_8},
	{0xA09C, 0x26, REG_BITS_8},
	{0xA09D, 0xa9, REG_BITS_8},
	{0xA09E, 0x89, REG_BITS_8},
	{0xA09F, 0x42, REG_BITS_8},
	{0xA0A0, 0x1a, REG_BITS_8},
	{0xA0A1, 0x02, REG_BITS_8},
	{0xA0A2, 0x90, REG_BITS_8},
	{0xA0A3, 0x7f, REG_BITS_8},
	{0xA0A4, 0x1c, REG_BITS_8},
	{0xA0A5, 0x44, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x20, REG_BITS_8},
	{0xA0A8, 0x71, REG_BITS_8},
	{0xA0A9, 0x49, REG_BITS_8},
	{0xA0AA, 0x50, REG_BITS_8},
	{0xA0AB, 0xc6, REG_BITS_8},
	{0xA0AC, 0xd2, REG_BITS_8},
	{0xA0AD, 0x14, REG_BITS_8},
	{0xA0AE, 0xbe, REG_BITS_8},
	{0xA0AF, 0x90, REG_BITS_8},
	{0xA0B0, 0x85, REG_BITS_8},
	{0xA0B1, 0x33, REG_BITS_8},
	{0xA0B2, 0x54, REG_BITS_8},
	{0xA0B3, 0x01, REG_BITS_8},
	{0xA0B4, 0x8c, REG_BITS_8},
	{0xA0B5, 0x4d, REG_BITS_8},
	{0xA0B6, 0x96, REG_BITS_8},
	{0xA0B7, 0xc2, REG_BITS_8},
	{0xA0B8, 0x11, REG_BITS_8},
	{0xA0B9, 0x92, REG_BITS_8},
	{0xA0BA, 0x4c, REG_BITS_8},
	{0xA0BB, 0xe4, REG_BITS_8},
	{0xA0BC, 0x22, REG_BITS_8},
	{0xA0BD, 0x18, REG_BITS_8},
	{0xA0BE, 0x01, REG_BITS_8},
	{0xA0BF, 0xc9, REG_BITS_8},
	{0xA0C0, 0x4b, REG_BITS_8},
	{0xA0C1, 0x86, REG_BITS_8},
	{0xA0C2, 0xd2, REG_BITS_8},
	{0xA0C3, 0x14, REG_BITS_8},
	{0xA0C4, 0xbb, REG_BITS_8},
	{0xA0C5, 0x68, REG_BITS_8},
	{0xA0C6, 0x05, REG_BITS_8},
	{0xA0C7, 0x32, REG_BITS_8},
	{0xA0C8, 0x6f, REG_BITS_8},
	{0xA0C9, 0x79, REG_BITS_8},
	{0xA0CA, 0x4d, REG_BITS_8},
	{0xA0CB, 0x5a, REG_BITS_8},
	{0xA0CC, 0x3e, REG_BITS_8},
	{0xA0CD, 0x23, REG_BITS_8},
	{0xA0CE, 0x15, REG_BITS_8},
	{0xA0CF, 0xbb, REG_BITS_8},
	{0xA0D0, 0xf8, REG_BITS_8},
	{0xA0D1, 0xa4, REG_BITS_8},
	{0xA0D2, 0x2a, REG_BITS_8},
	{0xA0D3, 0x35, REG_BITS_8},
	{0xA0D4, 0x49, REG_BITS_8},
	{0xA0D5, 0x0a, REG_BITS_8},
	{0xA0D6, 0x4e, REG_BITS_8},
	{0xA0D7, 0xa2, REG_BITS_8},
	{0xA0D8, 0x82, REG_BITS_8},
	{0xA0D9, 0x14, REG_BITS_8},
	{0xA0DA, 0xb6, REG_BITS_8},
	{0xA0DB, 0x80, REG_BITS_8},
	{0xA0DC, 0x25, REG_BITS_8},
	{0xA0DD, 0x33, REG_BITS_8},
	{0xA0DE, 0x66, REG_BITS_8},
	{0xA0DF, 0x51, REG_BITS_8},
	{0xA0E0, 0xcd, REG_BITS_8},
	{0xA0E1, 0x5d, REG_BITS_8},
	{0xA0E2, 0x88, REG_BITS_8},
	{0xA0E3, 0xf3, REG_BITS_8},
	{0xA0E4, 0x97, REG_BITS_8},
	{0xA0E5, 0xe4, REG_BITS_8},
	{0xA0E6, 0xb4, REG_BITS_8},
	{0xA0E7, 0x65, REG_BITS_8},
	{0xA0E8, 0x35, REG_BITS_8},
	{0xA0E9, 0x5f, REG_BITS_8},
	{0xA0EA, 0xa1, REG_BITS_8},
	{0xA0EB, 0x0c, REG_BITS_8},
	{0xA0EC, 0x56, REG_BITS_8},
	{0xA0ED, 0x10, REG_BITS_8},
	{0xA0EE, 0xa3, REG_BITS_8},
	{0xA0EF, 0x95, REG_BITS_8},
	{0xA0F0, 0xc5, REG_BITS_8},
	{0xA0F1, 0x90, REG_BITS_8},
	{0xA0F2, 0xe5, REG_BITS_8},
	{0xA0F3, 0x33, REG_BITS_8},
	{0xA0F4, 0x75, REG_BITS_8},
	{0xA0F5, 0xf1, REG_BITS_8},
	{0xA0F6, 0x4d, REG_BITS_8},
	{0xA0F7, 0x5b, REG_BITS_8},
	{0xA0F8, 0x74, REG_BITS_8},
	{0xA0F9, 0xd3, REG_BITS_8},
	{0xA0FA, 0x17, REG_BITS_8},
	{0xA0FB, 0xe8, REG_BITS_8},
	{0xA0FC, 0x1c, REG_BITS_8},
	{0xA0FD, 0x66, REG_BITS_8},
	{0xA0FE, 0x3b, REG_BITS_8},
	{0xA0FF, 0x82, REG_BITS_8},
	{0xA100, 0xc1, REG_BITS_8},
	{0xA101, 0x0e, REG_BITS_8},
	{0xA102, 0x5f, REG_BITS_8},
	{0xA103, 0x9a, REG_BITS_8},
	{0xA104, 0x93, REG_BITS_8},
	{0xA105, 0x17, REG_BITS_8},
	{0xA106, 0xe4, REG_BITS_8},
	{0xA107, 0xe0, REG_BITS_8},
	{0xA108, 0xa5, REG_BITS_8},
	{0xA109, 0x38, REG_BITS_8},
	{0xA10A, 0x79, REG_BITS_8},
	{0xA10B, 0x39, REG_BITS_8},
	{0xA10C, 0x0e, REG_BITS_8},
	{0xA10D, 0x5f, REG_BITS_8},
	{0xA10E, 0xa0, REG_BITS_8},
	{0xA10F, 0x13, REG_BITS_8},
	{0xA110, 0x17, REG_BITS_8},
	{0xA111, 0xe3, REG_BITS_8},
	{0xA112, 0x44, REG_BITS_8},
	{0xA113, 0xc5, REG_BITS_8},
	{0xA114, 0x32, REG_BITS_8},
	{0xA115, 0x70, REG_BITS_8},
	{0xA116, 0x11, REG_BITS_8},
	{0xA117, 0x0e, REG_BITS_8},
	{0xA118, 0x5c, REG_BITS_8},
	{0xA119, 0x90, REG_BITS_8},
	{0xA11A, 0x93, REG_BITS_8},
	{0xA11B, 0x96, REG_BITS_8},
	{0xA11C, 0xde, REG_BITS_8},
	{0xA11D, 0xa4, REG_BITS_8},
	{0xA11E, 0xa5, REG_BITS_8},
	{0xA11F, 0x37, REG_BITS_8},
	{0xA120, 0x66, REG_BITS_8},
	{0xA121, 0xb1, REG_BITS_8},
	{0xA122, 0x4d, REG_BITS_8},
	{0xA123, 0x5a, REG_BITS_8},
	{0xA124, 0x74, REG_BITS_8},
	{0xA125, 0x73, REG_BITS_8},
	{0xA126, 0x96, REG_BITS_8},
	{0xA127, 0xdc, REG_BITS_8},
	{0xA128, 0x24, REG_BITS_8},
	{0xA129, 0x85, REG_BITS_8},
	{0xA12A, 0x32, REG_BITS_8},
	{0xA12B, 0x3b, REG_BITS_8},
	{0xA12C, 0x39, REG_BITS_8},
	{0xA12D, 0x0a, REG_BITS_8},
	{0xA12E, 0x56, REG_BITS_8},
	{0xA12F, 0xca, REG_BITS_8},
	{0xA130, 0x92, REG_BITS_8},
	{0xA131, 0x95, REG_BITS_8},
	{0xA132, 0xb3, REG_BITS_8},
	{0xA133, 0x50, REG_BITS_8},
	{0xA134, 0x25, REG_BITS_8},
	{0xA135, 0x2c, REG_BITS_8},
	{0xA136, 0x57, REG_BITS_8},
	{0xA137, 0x01, REG_BITS_8},
	{0xA138, 0xcb, REG_BITS_8},
	{0xA139, 0x55, REG_BITS_8},
	{0xA13A, 0xc0, REG_BITS_8},
	{0xA13B, 0xb2, REG_BITS_8},
	{0xA13C, 0x95, REG_BITS_8},
	{0xA13D, 0xb3, REG_BITS_8},
	{0xA13E, 0x64, REG_BITS_8},
	{0xA13F, 0xe5, REG_BITS_8},
	{0xA140, 0x2c, REG_BITS_8},
	{0xA141, 0x3c, REG_BITS_8},
	{0xA142, 0x49, REG_BITS_8},
	{0xA143, 0x0a, REG_BITS_8},
	{0xA144, 0x58, REG_BITS_8},
	{0xA145, 0xde, REG_BITS_8},
	{0xA146, 0x92, REG_BITS_8},
	{0xA147, 0x16, REG_BITS_8},
	{0xA148, 0xbc, REG_BITS_8},
	{0xA149, 0xa0, REG_BITS_8},
	{0xA14A, 0xa5, REG_BITS_8},
	{0xA14B, 0x2e, REG_BITS_8},
	{0xA14C, 0x64, REG_BITS_8},
	{0xA14D, 0x89, REG_BITS_8},
	{0xA14E, 0x4b, REG_BITS_8},
	{0xA14F, 0x59, REG_BITS_8},
	{0xA150, 0xdc, REG_BITS_8},
	{0xA151, 0x72, REG_BITS_8},
	{0xA152, 0x16, REG_BITS_8},
	{0xA153, 0xb8, REG_BITS_8},
	{0xA154, 0xa4, REG_BITS_8},
	{0xA155, 0xa5, REG_BITS_8},
	{0xA156, 0x2e, REG_BITS_8},
	{0xA157, 0x69, REG_BITS_8},
	{0xA158, 0xb9, REG_BITS_8},
	{0xA159, 0x8b, REG_BITS_8},
	{0xA15A, 0x57, REG_BITS_8},
	{0xA15B, 0xda, REG_BITS_8},
	{0xA15C, 0xe2, REG_BITS_8},
	{0xA15D, 0x95, REG_BITS_8},
	{0xA15E, 0xb5, REG_BITS_8},
	{0xA15F, 0x94, REG_BITS_8},
	{0xA160, 0x25, REG_BITS_8},
	{0xA161, 0x2e, REG_BITS_8},
	{0xA162, 0x57, REG_BITS_8},
	{0xA163, 0x09, REG_BITS_8},
	{0xA164, 0x4b, REG_BITS_8},
	{0xA165, 0x53, REG_BITS_8},
	{0xA166, 0xac, REG_BITS_8},
	{0xA167, 0xa2, REG_BITS_8},
	{0xA168, 0x14, REG_BITS_8},
	{0xA169, 0xa8, REG_BITS_8},
	{0xA16A, 0x38, REG_BITS_8},
	{0xA16B, 0x85, REG_BITS_8},
	{0xA16C, 0x2a, REG_BITS_8},
	{0xA16D, 0x57, REG_BITS_8},
	{0xA16E, 0xf9, REG_BITS_8},
	{0xA16F, 0x8a, REG_BITS_8},
	{0xA170, 0x59, REG_BITS_8},
	{0xA171, 0xde, REG_BITS_8},
	{0xA172, 0xb2, REG_BITS_8},
	{0xA173, 0x95, REG_BITS_8},
	{0xA174, 0xb2, REG_BITS_8},
	{0xA175, 0x5c, REG_BITS_8},
	{0xA176, 0xe5, REG_BITS_8},
	{0xA177, 0x2c, REG_BITS_8},
	{0xA178, 0x53, REG_BITS_8},
	{0xA179, 0x09, REG_BITS_8},
	{0xA17A, 0x4b, REG_BITS_8},
	{0xA17B, 0x50, REG_BITS_8},
	{0xA17C, 0x92, REG_BITS_8},
	{0xA17D, 0x22, REG_BITS_8},
	{0xA17E, 0x93, REG_BITS_8},
	{0xA17F, 0x9b, REG_BITS_8},
	{0xA180, 0xb0, REG_BITS_8},
	{0xA181, 0x04, REG_BITS_8},
	{0xA182, 0x26, REG_BITS_8},
	{0xA183, 0x32, REG_BITS_8},
	{0xA184, 0xa9, REG_BITS_8},
	{0xA185, 0x09, REG_BITS_8},
	{0xA186, 0x50, REG_BITS_8},
	{0xA187, 0x8a, REG_BITS_8},
	{0xA188, 0x42, REG_BITS_8},
	{0xA189, 0x15, REG_BITS_8},
	{0xA18A, 0xad, REG_BITS_8},
	{0xA18B, 0x58, REG_BITS_8},
	{0xA18C, 0xc5, REG_BITS_8},
	{0xA18D, 0x2b, REG_BITS_8},
	{0xA18E, 0x50, REG_BITS_8},
	{0xA18F, 0xf1, REG_BITS_8},
	{0xA190, 0x4a, REG_BITS_8},
	{0xA191, 0x51, REG_BITS_8},
	{0xA192, 0xa0, REG_BITS_8},
	{0xA193, 0xb2, REG_BITS_8},
	{0xA194, 0x12, REG_BITS_8},
	{0xA195, 0x99, REG_BITS_8},
	{0xA196, 0x54, REG_BITS_8},
	{0xA197, 0x24, REG_BITS_8},
	{0xA198, 0x23, REG_BITS_8},
	{0xA199, 0x0e, REG_BITS_8},
	{0xA19A, 0x81, REG_BITS_8},
	{0xA19B, 0x48, REG_BITS_8},
	{0xA19C, 0x45, REG_BITS_8},
	{0xA19D, 0x2c, REG_BITS_8},
	{0xA19E, 0xb2, REG_BITS_8},
	{0xA19F, 0x92, REG_BITS_8},
	{0xA1A0, 0x96, REG_BITS_8},
	{0xA1A1, 0x10, REG_BITS_8},
	{0xA1A2, 0x25, REG_BITS_8},
	{0xA1A3, 0x29, REG_BITS_8},
	{0xA1A4, 0x4c, REG_BITS_8},
	{0xA1A5, 0x99, REG_BITS_8},
	{0xA1A6, 0x4a, REG_BITS_8},
	{0xA1A7, 0x51, REG_BITS_8},
	{0xA1A8, 0xa4, REG_BITS_8},
	{0xA1A9, 0xc2, REG_BITS_8},
	{0xA1AA, 0x93, REG_BITS_8},
	{0xA1AB, 0xa2, REG_BITS_8},
	{0xA1AC, 0x7c, REG_BITS_8},
	{0xA1AD, 0x84, REG_BITS_8},
	{0xA1AE, 0x24, REG_BITS_8},
	{0xA1AF, 0x07, REG_BITS_8},
	{0xA1B0, 0x49, REG_BITS_8},
	{0xA1B1, 0x08, REG_BITS_8},
	{0xA1B2, 0x40, REG_BITS_8},
	{0xA1B3, 0x00, REG_BITS_8},
	{0xA1B4, 0x72, REG_BITS_8},
	{0xA1B5, 0x10, REG_BITS_8},
	{0xA1B6, 0x83, REG_BITS_8},
	{0xA1B7, 0x7c, REG_BITS_8},
	{0xA1B8, 0xc4, REG_BITS_8},
	{0xA1B9, 0x23, REG_BITS_8},
	{0xA1BA, 0x39, REG_BITS_8},
	{0xA1BB, 0xf1, REG_BITS_8},
	{0xA1BC, 0xc9, REG_BITS_8},
	{0xA1BD, 0x4f, REG_BITS_8},
	{0xA1BE, 0x92, REG_BITS_8},
	{0xA1BF, 0x72, REG_BITS_8},
	{0xA1C0, 0x94, REG_BITS_8},
	{0xA1C1, 0xa8, REG_BITS_8},
	{0xA1C2, 0xf4, REG_BITS_8},
	{0xA1C3, 0xa4, REG_BITS_8},
	{0xA1C4, 0x28, REG_BITS_8},
	{0xA1C5, 0x20, REG_BITS_8},
	{0xA1C6, 0x21, REG_BITS_8},
	{0xA1C7, 0xc9, REG_BITS_8},
	{0xA1C8, 0x41, REG_BITS_8},
	{0xA1C9, 0x12, REG_BITS_8},
	{0xA1CA, 0xf2, REG_BITS_8},
	{0xA1CB, 0x8f, REG_BITS_8},
	{0xA1CC, 0x7f, REG_BITS_8},
	{0xA1CD, 0x18, REG_BITS_8},
	{0xA1CE, 0xa4, REG_BITS_8},
	{0xA1CF, 0x20, REG_BITS_8},
	{0xA1D0, 0x1d, REG_BITS_8},
	{0xA1D1, 0xe9, REG_BITS_8},
	{0xA1D2, 0xc8, REG_BITS_8},
	{0xA1D3, 0x4d, REG_BITS_8},
	{0xA1D4, 0x7c, REG_BITS_8},
	{0xA1D5, 0xc2, REG_BITS_8},
	{0xA1D6, 0x93, REG_BITS_8},
	{0xA1D7, 0xa4, REG_BITS_8},
	{0xA1D8, 0x54, REG_BITS_8},
	{0xA1D9, 0xc5, REG_BITS_8},
	{0xA1DA, 0x2b, REG_BITS_8},
	{0xA1DB, 0x4a, REG_BITS_8},
	{0xA1DC, 0x89, REG_BITS_8},
	{0xA1DD, 0xca, REG_BITS_8},
	{0xA1DE, 0x4b, REG_BITS_8},
	{0xA1DF, 0x66, REG_BITS_8},
	{0xA1E0, 0x62, REG_BITS_8},
	{0xA1E1, 0x91, REG_BITS_8},
	{0xA1E2, 0x8c, REG_BITS_8},
	{0xA1E3, 0x38, REG_BITS_8},
	{0xA1E4, 0x04, REG_BITS_8},
	{0xA1E5, 0x22, REG_BITS_8},
	{0xA1E6, 0x14, REG_BITS_8},
	{0xA1E7, 0xa9, REG_BITS_8},
	{0xA1E8, 0x88, REG_BITS_8},
	{0xA1E9, 0x4a, REG_BITS_8},
	{0xA1EA, 0x5a, REG_BITS_8},
	{0xA1EB, 0x02, REG_BITS_8},
	{0xA1EC, 0x94, REG_BITS_8},
	{0xA1ED, 0xa4, REG_BITS_8},
	{0xA1EE, 0x1c, REG_BITS_8},
	{0xA1EF, 0xa5, REG_BITS_8},
	{0xA1F0, 0x2a, REG_BITS_8},
	{0xA1F1, 0x61, REG_BITS_8},
	{0xA1F2, 0x51, REG_BITS_8},
	{0xA1F3, 0x0b, REG_BITS_8},
	{0xA1F4, 0x57, REG_BITS_8},
	{0xA1F5, 0xca, REG_BITS_8},
	{0xA1F6, 0x92, REG_BITS_8},
	{0xA1F7, 0x94, REG_BITS_8},
	{0xA1F8, 0xa6, REG_BITS_8},
	{0xA1F9, 0xd8, REG_BITS_8},
	{0xA1FA, 0x44, REG_BITS_8},
	{0xA1FB, 0x27, REG_BITS_8},
	{0xA1FC, 0x2f, REG_BITS_8},
	{0xA1FD, 0x91, REG_BITS_8},
	{0xA1FE, 0x49, REG_BITS_8},
	{0xA1FF, 0x4c, REG_BITS_8},
	{0xA200, 0x6c, REG_BITS_8},
	{0xA201, 0xe2, REG_BITS_8},
	{0xA202, 0x93, REG_BITS_8},
	{0xA203, 0xa3, REG_BITS_8},
	{0xA204, 0x3c, REG_BITS_8},
	{0xA205, 0x85, REG_BITS_8},
	{0xA206, 0x2b, REG_BITS_8},
	{0xA207, 0x50, REG_BITS_8},
	{0xA208, 0x09, REG_BITS_8},
	{0xA209, 0xcb, REG_BITS_8},
	{0xA20A, 0x5a, REG_BITS_8},
	{0xA20B, 0xe8, REG_BITS_8},
	{0xA20C, 0x42, REG_BITS_8},
	{0xA20D, 0x17, REG_BITS_8},
	{0xA20E, 0xbe, REG_BITS_8},
	{0xA20F, 0x94, REG_BITS_8},
	{0xA210, 0x65, REG_BITS_8},
	{0xA211, 0x2d, REG_BITS_8},
	{0xA212, 0x57, REG_BITS_8},
	{0xA213, 0xe9, REG_BITS_8},
	{0xA214, 0x0a, REG_BITS_8},
	{0xA215, 0x54, REG_BITS_8},
	{0xA216, 0xae, REG_BITS_8},
	{0xA217, 0x02, REG_BITS_8},
	{0xA218, 0x15, REG_BITS_8},
	{0xA219, 0xad, REG_BITS_8},
	{0xA21A, 0x58, REG_BITS_8},
	{0xA21B, 0x85, REG_BITS_8},
	{0xA21C, 0x2c, REG_BITS_8},
	{0xA21D, 0x62, REG_BITS_8},
	{0xA21E, 0xb1, REG_BITS_8},
	{0xA21F, 0x8b, REG_BITS_8},
	{0xA220, 0x55, REG_BITS_8},
	{0xA221, 0xd8, REG_BITS_8},
	{0xA222, 0xe2, REG_BITS_8},
	{0xA223, 0x16, REG_BITS_8},
	{0xA224, 0xbd, REG_BITS_8},
	{0xA225, 0xe4, REG_BITS_8},
	{0xA226, 0x85, REG_BITS_8},
	{0xA227, 0x30, REG_BITS_8},
	{0xA228, 0x79, REG_BITS_8},
	{0xA229, 0x11, REG_BITS_8},
	{0xA22A, 0x4c, REG_BITS_8},
	{0xA22B, 0x5d, REG_BITS_8},
	{0xA22C, 0xfa, REG_BITS_8},
	{0xA22D, 0xd2, REG_BITS_8},
	{0xA22E, 0x16, REG_BITS_8},
	{0xA22F, 0xbd, REG_BITS_8},
	{0xA230, 0xa0, REG_BITS_8},
	{0xA231, 0x45, REG_BITS_8},
	{0xA232, 0x2f, REG_BITS_8},
	{0xA233, 0x67, REG_BITS_8},
	{0xA234, 0xe1, REG_BITS_8},
	{0xA235, 0xcb, REG_BITS_8},
	{0xA236, 0x59, REG_BITS_8},
	{0xA237, 0xfc, REG_BITS_8},
	{0xA238, 0xb2, REG_BITS_8},
	{0xA239, 0x95, REG_BITS_8},
	{0xA23A, 0xb8, REG_BITS_8},
	{0xA23B, 0x10, REG_BITS_8},
	{0xA23C, 0xc5, REG_BITS_8},
	{0xA23D, 0x29, REG_BITS_8},
	{0xA23E, 0x63, REG_BITS_8},
	{0xA23F, 0x71, REG_BITS_8},
	{0xA240, 0x4b, REG_BITS_8},
	{0xA241, 0x5a, REG_BITS_8},
	{0xA242, 0xe4, REG_BITS_8},
	{0xA243, 0x52, REG_BITS_8},
	{0xA244, 0x16, REG_BITS_8},
	{0xA245, 0xb6, REG_BITS_8},
	{0xA246, 0x78, REG_BITS_8},
	{0xA247, 0x85, REG_BITS_8},
	{0xA248, 0x2d, REG_BITS_8},
	{0xA249, 0x56, REG_BITS_8},
	{0xA24A, 0x51, REG_BITS_8},
	{0xA24B, 0x0b, REG_BITS_8},
	{0xA24C, 0x56, REG_BITS_8},
	{0xA24D, 0xdc, REG_BITS_8},
	{0xA24E, 0x52, REG_BITS_8},
	{0xA24F, 0x15, REG_BITS_8},
	{0xA250, 0xb4, REG_BITS_8},
	{0xA251, 0xd8, REG_BITS_8},
	{0xA252, 0xe4, REG_BITS_8},
	{0xA253, 0x28, REG_BITS_8},
	{0xA254, 0x77, REG_BITS_8},
	{0xA255, 0xe9, REG_BITS_8},
	{0xA256, 0xcc, REG_BITS_8},
	{0xA257, 0x67, REG_BITS_8},
	{0xA258, 0x30, REG_BITS_8},
	{0xA259, 0x83, REG_BITS_8},
	{0xA25A, 0x99, REG_BITS_8},
	{0xA25B, 0xcc, REG_BITS_8},
	{0xA25C, 0x84, REG_BITS_8},
	{0xA25D, 0x26, REG_BITS_8},
	{0xA25E, 0x34, REG_BITS_8},
	{0xA25F, 0x81, REG_BITS_8},
	{0xA260, 0x49, REG_BITS_8},
	{0xA261, 0xcd, REG_BITS_8},
	{0xA262, 0x6c, REG_BITS_8},
	{0xA263, 0x58, REG_BITS_8},
	{0xA264, 0x43, REG_BITS_8},
	{0xA265, 0x1a, REG_BITS_8},
	{0xA266, 0xd1, REG_BITS_8},
	{0xA267, 0x98, REG_BITS_8},
	{0xA268, 0xa6, REG_BITS_8},
	{0xA269, 0x35, REG_BITS_8},
	{0xA26A, 0xb5, REG_BITS_8},
	{0xA26B, 0xa1, REG_BITS_8},
	{0xA26C, 0xcd, REG_BITS_8},
	{0xA26D, 0x68, REG_BITS_8},
	{0xA26E, 0x46, REG_BITS_8},
	{0xA26F, 0x73, REG_BITS_8},
	{0xA270, 0x98, REG_BITS_8},
	{0xA271, 0xb9, REG_BITS_8},
	{0xA272, 0xac, REG_BITS_8},
	{0xA273, 0x45, REG_BITS_8},
	{0xA274, 0x2e, REG_BITS_8},
	{0xA275, 0x87, REG_BITS_8},
	{0xA276, 0x21, REG_BITS_8},
	{0xA277, 0x0d, REG_BITS_8},
	{0xA278, 0x6b, REG_BITS_8},
	{0xA279, 0x26, REG_BITS_8},
	{0xA27A, 0x33, REG_BITS_8},
	{0xA27B, 0x98, REG_BITS_8},
	{0xA27C, 0xae, REG_BITS_8},
	{0xA27D, 0x0c, REG_BITS_8},
	{0xA27E, 0x05, REG_BITS_8},
	{0xA27F, 0x27, REG_BITS_8},
	{0xA280, 0x41, REG_BITS_8},
	{0xA281, 0xc9, REG_BITS_8},
	{0xA282, 0x0a, REG_BITS_8},
	{0xA283, 0x60, REG_BITS_8},
	{0xA284, 0x36, REG_BITS_8},
	{0xA285, 0x13, REG_BITS_8},
	{0xA286, 0x98, REG_BITS_8},
	{0xA287, 0xb3, REG_BITS_8},
	{0xA288, 0xf0, REG_BITS_8},
	{0xA289, 0x84, REG_BITS_8},
	{0xA28A, 0x23, REG_BITS_8},
	{0xA28B, 0x11, REG_BITS_8},
	{0xA28C, 0xd1, REG_BITS_8},
	{0xA28D, 0xc8, REG_BITS_8},
	{0xA28E, 0x4d, REG_BITS_8},
	{0xA28F, 0xc4, REG_BITS_8},
	{0xA290, 0x62, REG_BITS_8},
	{0xA291, 0x18, REG_BITS_8},
	{0xA292, 0xb8, REG_BITS_8},
	{0xA293, 0x60, REG_BITS_8},
	{0xA294, 0x25, REG_BITS_8},
	{0xA295, 0x25, REG_BITS_8},
	{0xA296, 0x0a, REG_BITS_8},
	{0xA297, 0x01, REG_BITS_8},
	{0xA298, 0xc8, REG_BITS_8},
	{0xA299, 0x41, REG_BITS_8},
	{0xA29A, 0x4c, REG_BITS_8},
	{0xA29B, 0x32, REG_BITS_8},
	{0xA29C, 0x15, REG_BITS_8},
	{0xA29D, 0xba, REG_BITS_8},
	{0xA29E, 0xc0, REG_BITS_8},
	{0xA29F, 0x05, REG_BITS_8},
	{0xA2A0, 0x2b, REG_BITS_8},
	{0xA2A1, 0x2a, REG_BITS_8},
	{0xA2A2, 0x51, REG_BITS_8},
	{0xA2A3, 0xc8, REG_BITS_8},
	{0xA2A4, 0x3f, REG_BITS_8},
	{0xA2A5, 0x0e, REG_BITS_8},
	{0xA2A6, 0x52, REG_BITS_8},
	{0xA2A7, 0x12, REG_BITS_8},
	{0xA2A8, 0xaa, REG_BITS_8},
	{0xA2A9, 0xc4, REG_BITS_8},
	{0xA2AA, 0x65, REG_BITS_8},
	{0xA2AB, 0x30, REG_BITS_8},
	{0xA2AC, 0x69, REG_BITS_8},
	{0xA2AD, 0xe1, REG_BITS_8},
	{0xA2AE, 0x09, REG_BITS_8},
	{0xA2AF, 0x47, REG_BITS_8},
	{0xA2B0, 0x22, REG_BITS_8},
	{0xA2B1, 0xa2, REG_BITS_8},
	{0xA2B2, 0x11, REG_BITS_8},
	{0xA2B3, 0x9c, REG_BITS_8},
	{0xA2B4, 0x94, REG_BITS_8},
	{0xA2B5, 0x05, REG_BITS_8},
	{0xA2B6, 0x30, REG_BITS_8},
	{0xA2B7, 0x98, REG_BITS_8},
	{0xA2B8, 0x31, REG_BITS_8},
	{0xA2B9, 0xcc, REG_BITS_8},
	{0xA2BA, 0x57, REG_BITS_8},
	{0xA2BB, 0x88, REG_BITS_8},
	{0xA2BC, 0xa2, REG_BITS_8},
	{0xA2BD, 0x13, REG_BITS_8},
	{0xA2BE, 0xa1, REG_BITS_8},
	{0xA2BF, 0x6c, REG_BITS_8},
	{0xA2C0, 0xa5, REG_BITS_8},
	{0xA2C1, 0x30, REG_BITS_8},
	{0xA2C2, 0x98, REG_BITS_8},
	{0xA2C3, 0x61, REG_BITS_8},
	{0xA2C4, 0x8d, REG_BITS_8},
	{0xA2C5, 0x6b, REG_BITS_8},
	{0xA2C6, 0x1e, REG_BITS_8},
	{0xA2C7, 0xa3, REG_BITS_8},
	{0xA2C8, 0x17, REG_BITS_8},
	{0xA2C9, 0xb8, REG_BITS_8},
	{0xA2CA, 0xd4, REG_BITS_8},
	{0xA2CB, 0x45, REG_BITS_8},
	{0xA2CC, 0x31, REG_BITS_8},
	{0xA2CD, 0xac, REG_BITS_8},
	{0xA2CE, 0x59, REG_BITS_8},
	{0xA2CF, 0x8d, REG_BITS_8},
	{0xA2D0, 0x6d, REG_BITS_8},
	{0xA2D1, 0x80, REG_BITS_8},
	{0xA2D2, 0xa3, REG_BITS_8},
	{0xA2D3, 0x1b, REG_BITS_8},
	{0xA2D4, 0xd8, REG_BITS_8},
	{0xA2D5, 0xb0, REG_BITS_8},
	{0xA2D6, 0xa6, REG_BITS_8},
	{0xA2D7, 0x35, REG_BITS_8},
	{0xA2D8, 0xb4, REG_BITS_8},
	{0xA2D9, 0xf1, REG_BITS_8},
	{0xA2DA, 0x4d, REG_BITS_8},
	{0xA2DB, 0x6d, REG_BITS_8},
	{0xA2DC, 0xf8, REG_BITS_8},
	{0xA2DD, 0x62, REG_BITS_8},
	{0xA2DE, 0x1a, REG_BITS_8},
	{0xA2DF, 0xd6, REG_BITS_8},
	{0xA2E0, 0x88, REG_BITS_8},
	{0xA2E1, 0x26, REG_BITS_8},
	{0xA2E2, 0x34, REG_BITS_8},
	{0xA2E3, 0xa0, REG_BITS_8},
	{0xA2E4, 0x41, REG_BITS_8},
	{0xA2E5, 0x8d, REG_BITS_8},
	{0xA2E6, 0x69, REG_BITS_8},
	{0xA2E7, 0xfe, REG_BITS_8},
	{0xA2E8, 0x02, REG_BITS_8},
	{0xA2E9, 0x80, REG_BITS_8},
	{0xA2EA, 0x00, REG_BITS_8},
	{0xA2EB, 0x00, REG_BITS_8},
	{0xA2EC, 0x00, REG_BITS_8},
	{0xA2ED, 0x00, REG_BITS_8},
	{0xA2EE, 0x98, REG_BITS_8},
	{0xA2EF, 0x09, REG_BITS_8},
	{0xA2F0, 0x8e, REG_BITS_8},
	{0xA2F1, 0x70, REG_BITS_8},
	{0xA2F2, 0x74, REG_BITS_8},
	{0xA2F3, 0x83, REG_BITS_8},
	{0xA2F4, 0x1b, REG_BITS_8},
	{0xA2F5, 0xdc, REG_BITS_8},
	{0xA2F6, 0xf8, REG_BITS_8},
	{0xA2F7, 0xa6, REG_BITS_8},
	{0xA2F8, 0x37, REG_BITS_8},
	{0xA2F9, 0x96, REG_BITS_8},
	{0xA2FA, 0x81, REG_BITS_8},
	{0xA2FB, 0x0e, REG_BITS_8},
	{0xA2FC, 0x76, REG_BITS_8},
	{0xA2FD, 0xa0, REG_BITS_8},
	{0xA2FE, 0x63, REG_BITS_8},
	{0xA2FF, 0x1c, REG_BITS_8},
	{0xA300, 0xe1, REG_BITS_8},
	{0xA301, 0x10, REG_BITS_8},
	{0xA302, 0x47, REG_BITS_8},
	{0xA303, 0x39, REG_BITS_8},
	{0xA304, 0xd1, REG_BITS_8},
	{0xA305, 0x31, REG_BITS_8},
	{0xA306, 0x0e, REG_BITS_8},
	{0xA307, 0x72, REG_BITS_8},
	{0xA308, 0x8e, REG_BITS_8},
	{0xA309, 0x63, REG_BITS_8},
	{0xA30A, 0x1a, REG_BITS_8},
	{0xA30B, 0xc7, REG_BITS_8},
	{0xA30C, 0x10, REG_BITS_8},
	{0xA30D, 0x26, REG_BITS_8},
	{0xA30E, 0x31, REG_BITS_8},
	{0xA30F, 0x9e, REG_BITS_8},
	{0xA310, 0xe1, REG_BITS_8},
	{0xA311, 0x4d, REG_BITS_8},
	{0xA312, 0x6e, REG_BITS_8},
	{0xA313, 0x6e, REG_BITS_8},
	{0xA314, 0x33, REG_BITS_8},
	{0xA315, 0x9a, REG_BITS_8},
	{0xA316, 0xba, REG_BITS_8},
	{0xA317, 0x54, REG_BITS_8},
	{0xA318, 0xe5, REG_BITS_8},
	{0xA319, 0x28, REG_BITS_8},
	{0xA31A, 0x50, REG_BITS_8},
	{0xA31B, 0x59, REG_BITS_8},
	{0xA31C, 0xcb, REG_BITS_8},
	{0xA31D, 0x64, REG_BITS_8},
	{0xA31E, 0x4a, REG_BITS_8},
	{0xA31F, 0x13, REG_BITS_8},
	{0xA320, 0x9a, REG_BITS_8},
	{0xA321, 0xc0, REG_BITS_8},
	{0xA322, 0x30, REG_BITS_8},
	{0xA323, 0xa5, REG_BITS_8},
	{0xA324, 0x24, REG_BITS_8},
	{0xA325, 0x17, REG_BITS_8},
	{0xA326, 0x01, REG_BITS_8},
	{0xA327, 0x89, REG_BITS_8},
	{0xA328, 0x50, REG_BITS_8},
	{0xA329, 0xe4, REG_BITS_8},
	{0xA32A, 0xe2, REG_BITS_8},
	{0xA32B, 0x18, REG_BITS_8},
	{0xA32C, 0xc7, REG_BITS_8},
	{0xA32D, 0xbc, REG_BITS_8},
	{0xA32E, 0xa5, REG_BITS_8},
	{0xA32F, 0x26, REG_BITS_8},
	{0xA330, 0x0e, REG_BITS_8},
	{0xA331, 0x01, REG_BITS_8},
	{0xA332, 0x48, REG_BITS_8},
	{0xA333, 0x42, REG_BITS_8},
	{0xA334, 0x58, REG_BITS_8},
	{0xA335, 0x12, REG_BITS_8},
	{0xA336, 0x96, REG_BITS_8},
	{0xA337, 0xbe, REG_BITS_8},
	{0xA338, 0x38, REG_BITS_8},
	{0xA339, 0xe6, REG_BITS_8},
	{0xA33A, 0x2d, REG_BITS_8},
	{0xA33B, 0x36, REG_BITS_8},
	{0xA33C, 0x69, REG_BITS_8},
	{0xA33D, 0xc8, REG_BITS_8},
	{0xA33E, 0x3f, REG_BITS_8},
	{0xA33F, 0x12, REG_BITS_8},
	{0xA340, 0xc2, REG_BITS_8},
	{0xA341, 0x92, REG_BITS_8},
	{0xA342, 0xb0, REG_BITS_8},
	{0xA343, 0xf8, REG_BITS_8},
	{0xA344, 0x85, REG_BITS_8},
	{0xA345, 0x34, REG_BITS_8},
	{0xA346, 0x84, REG_BITS_8},
	{0xA347, 0x61, REG_BITS_8},
	{0xA348, 0x0a, REG_BITS_8},
	{0xA349, 0x49, REG_BITS_8},
	{0xA34A, 0x2c, REG_BITS_8},
	{0xA34B, 0xf2, REG_BITS_8},
	{0xA34C, 0x11, REG_BITS_8},
	{0xA34D, 0xa1, REG_BITS_8},
	{0xA34E, 0xd8, REG_BITS_8},
	{0xA34F, 0x65, REG_BITS_8},
	{0xA350, 0x32, REG_BITS_8},
	{0xA351, 0xbc, REG_BITS_8},
	{0xA352, 0x31, REG_BITS_8},
	{0xA353, 0x8d, REG_BITS_8},
	{0xA354, 0x5d, REG_BITS_8},
	{0xA355, 0xa8, REG_BITS_8},
	{0xA356, 0x72, REG_BITS_8},
	{0xA357, 0x94, REG_BITS_8},
	{0xA358, 0xa7, REG_BITS_8},
	{0xA359, 0xb0, REG_BITS_8},
	{0xA35A, 0x45, REG_BITS_8},
	{0xA35B, 0x33, REG_BITS_8},
	{0xA35C, 0xaf, REG_BITS_8},
	{0xA35D, 0x91, REG_BITS_8},
	{0xA35E, 0x8e, REG_BITS_8},
	{0xA35F, 0x74, REG_BITS_8},
	{0xA360, 0x5a, REG_BITS_8},
	{0xA361, 0x33, REG_BITS_8},
	{0xA362, 0x19, REG_BITS_8},
	{0xA363, 0xc3, REG_BITS_8},
	{0xA364, 0x2c, REG_BITS_8},
	{0xA365, 0x06, REG_BITS_8},
	{0xA366, 0x34, REG_BITS_8},
	{0xA367, 0xc3, REG_BITS_8},
	{0xA368, 0x11, REG_BITS_8},
	{0xA369, 0x4e, REG_BITS_8},
	{0xA36A, 0x77, REG_BITS_8},
	{0xA36B, 0xcc, REG_BITS_8},
	{0xA36C, 0xe3, REG_BITS_8},
	{0xA36D, 0x1d, REG_BITS_8},
	{0xA36E, 0xe8, REG_BITS_8},
	{0xA36F, 0x24, REG_BITS_8},
	{0xA370, 0x07, REG_BITS_8},
	{0xA371, 0x39, REG_BITS_8},
	{0xA372, 0xce, REG_BITS_8},
	{0xA373, 0xc1, REG_BITS_8},
	{0xA374, 0x4e, REG_BITS_8},
	{0xA375, 0x73, REG_BITS_8},
	{0xA376, 0x42, REG_BITS_8},
	{0xA377, 0xd3, REG_BITS_8},
	{0xA378, 0x9c, REG_BITS_8},
	{0xA379, 0xe8, REG_BITS_8},
	{0xA37A, 0x0c, REG_BITS_8},
	{0xA37B, 0x07, REG_BITS_8},
	{0xA37C, 0x38, REG_BITS_8},
	{0xA37D, 0xbc, REG_BITS_8},
	{0xA37E, 0x09, REG_BITS_8},
	{0xA37F, 0xce, REG_BITS_8},
	{0xA380, 0x6f, REG_BITS_8},
	{0xA381, 0x32, REG_BITS_8},
	{0xA382, 0x33, REG_BITS_8},
	{0xA383, 0x15, REG_BITS_8},
	{0xA384, 0xb8, REG_BITS_8},
	{0xA385, 0xb4, REG_BITS_8},
	{0xA386, 0x65, REG_BITS_8},
	{0xA387, 0x2c, REG_BITS_8},
	{0xA388, 0x53, REG_BITS_8},
	{0xA389, 0x81, REG_BITS_8},
	{0xA38A, 0x4b, REG_BITS_8},
	{0xA38B, 0x5b, REG_BITS_8},
	{0xA38C, 0xc6, REG_BITS_8},
	{0xA38D, 0x52, REG_BITS_8},
	{0xA38E, 0x96, REG_BITS_8},
	{0xA38F, 0xb2, REG_BITS_8},
	{0xA390, 0xa4, REG_BITS_8},
	{0xA391, 0xe5, REG_BITS_8},
	{0xA392, 0x2c, REG_BITS_8},
	{0xA393, 0x4b, REG_BITS_8},
	{0xA394, 0xc9, REG_BITS_8},
	{0xA395, 0xcb, REG_BITS_8},
	{0xA396, 0x5f, REG_BITS_8},
	{0xA397, 0xf4, REG_BITS_8},
	{0xA398, 0x12, REG_BITS_8},
	{0xA399, 0x17, REG_BITS_8},
	{0xA39A, 0xb8, REG_BITS_8},
	{0xA39B, 0xc4, REG_BITS_8},
	{0xA39C, 0xa5, REG_BITS_8},
	{0xA39D, 0x2e, REG_BITS_8},
	{0xA39E, 0x76, REG_BITS_8},
	{0xA39F, 0x61, REG_BITS_8},
	{0xA3A0, 0x0b, REG_BITS_8},
	{0xA3A1, 0x5d, REG_BITS_8},
	{0xA3A2, 0xf0, REG_BITS_8},
	{0xA3A3, 0x42, REG_BITS_8},
	{0xA3A4, 0x96, REG_BITS_8},
	{0xA3A5, 0xaa, REG_BITS_8},
	{0xA3A6, 0x44, REG_BITS_8},
	{0xA3A7, 0x85, REG_BITS_8},
	{0xA3A8, 0x2a, REG_BITS_8},
	{0xA3A9, 0x5d, REG_BITS_8},
	{0xA3AA, 0x79, REG_BITS_8},
	{0xA3AB, 0x8b, REG_BITS_8},
	{0xA3AC, 0x59, REG_BITS_8},
	{0xA3AD, 0xce, REG_BITS_8},
	{0xA3AE, 0x12, REG_BITS_8},
	{0xA3AF, 0x96, REG_BITS_8},
	{0xA3B0, 0xa5, REG_BITS_8},
	{0xA3B1, 0xdc, REG_BITS_8},
	{0xA3B2, 0xc4, REG_BITS_8},
	{0xA3B3, 0x25, REG_BITS_8},
	{0xA3B4, 0x34, REG_BITS_8},
	{0xA3B5, 0x19, REG_BITS_8},
	{0xA3B6, 0x8a, REG_BITS_8},
	{0xA3B7, 0x56, REG_BITS_8},
	{0xA3B8, 0xba, REG_BITS_8},
	{0xA3B9, 0xd2, REG_BITS_8},
	{0xA3BA, 0x15, REG_BITS_8},
	{0xA3BB, 0xa8, REG_BITS_8},
	{0xA3BC, 0xc8, REG_BITS_8},
	{0xA3BD, 0x04, REG_BITS_8},
	{0xA3BE, 0x23, REG_BITS_8},
	{0xA3BF, 0x0e, REG_BITS_8},
	{0xA3C0, 0xa1, REG_BITS_8},
	{0xA3C1, 0xc8, REG_BITS_8},
	{0xA3C2, 0x4a, REG_BITS_8},
	{0xA3C3, 0x8c, REG_BITS_8},
	{0xA3C4, 0xf2, REG_BITS_8},
	{0xA3C5, 0x94, REG_BITS_8},
	{0xA3C6, 0xa8, REG_BITS_8},
	{0xA3C7, 0x18, REG_BITS_8},
	{0xA3C8, 0x85, REG_BITS_8},
	{0xA3C9, 0x24, REG_BITS_8},
	{0xA3CA, 0x09, REG_BITS_8},
	{0xA3CB, 0x01, REG_BITS_8},
	{0xA3CC, 0x88, REG_BITS_8},
	{0xA3CD, 0x41, REG_BITS_8},
	{0xA3CE, 0x3a, REG_BITS_8},
	{0xA3CF, 0x82, REG_BITS_8},
	{0xA3D0, 0x13, REG_BITS_8},
	{0xA3D1, 0xa0, REG_BITS_8},
	{0xA3D2, 0x4c, REG_BITS_8},
	{0xA3D3, 0xe5, REG_BITS_8},
	{0xA3D4, 0x28, REG_BITS_8},
	{0xA3D5, 0x23, REG_BITS_8},
	{0xA3D6, 0x41, REG_BITS_8},
	{0xA3D7, 0xc8, REG_BITS_8},
	{0xA3D8, 0x3f, REG_BITS_8},
	{0xA3D9, 0x08, REG_BITS_8},
	{0xA3DA, 0xb2, REG_BITS_8},
	{0xA3DB, 0x11, REG_BITS_8},
	{0xA3DC, 0x9b, REG_BITS_8},
	{0xA3DD, 0xf8, REG_BITS_8},
	{0xA3DE, 0x24, REG_BITS_8},
	{0xA3DF, 0x2c, REG_BITS_8},
	{0xA3E0, 0x54, REG_BITS_8},
	{0xA3E1, 0x99, REG_BITS_8},
	{0xA3E2, 0x89, REG_BITS_8},
	{0xA3E3, 0x45, REG_BITS_8},
	{0xA3E4, 0x18, REG_BITS_8},
	{0xA3E5, 0x02, REG_BITS_8},
	{0xA3E6, 0x91, REG_BITS_8},
	{0xA3E7, 0x94, REG_BITS_8},
	{0xA3E8, 0x0c, REG_BITS_8},
	{0xA3E9, 0x65, REG_BITS_8},
	{0xA3EA, 0x29, REG_BITS_8},
	{0xA3EB, 0x6f, REG_BITS_8},
	{0xA3EC, 0x31, REG_BITS_8},
	{0xA3ED, 0x4b, REG_BITS_8},
	{0xA3EE, 0x53, REG_BITS_8},
	{0xA3EF, 0x6a, REG_BITS_8},
	{0xA3F0, 0xc2, REG_BITS_8},
	{0xA3F1, 0x92, REG_BITS_8},
	{0xA3F2, 0x97, REG_BITS_8},
	{0xA3F3, 0xfc, REG_BITS_8},
	{0xA3F4, 0x64, REG_BITS_8},
	{0xA3F5, 0x2a, REG_BITS_8},
	{0xA3F6, 0x56, REG_BITS_8},
	{0xA3F7, 0xd1, REG_BITS_8},
	{0xA3F8, 0x8b, REG_BITS_8},
	{0xA3F9, 0x5f, REG_BITS_8},
	{0xA3FA, 0xd2, REG_BITS_8},
	{0xA3FB, 0x72, REG_BITS_8},
	{0xA3FC, 0x15, REG_BITS_8},
	{0xA3FD, 0xa7, REG_BITS_8},
	{0xA3FE, 0x40, REG_BITS_8},
	{0xA3FF, 0x45, REG_BITS_8},
	{0xA400, 0x2b, REG_BITS_8},
	{0xA401, 0x6b, REG_BITS_8},
	{0xA402, 0x19, REG_BITS_8},
	{0xA403, 0xcb, REG_BITS_8},
	{0xA404, 0x5f, REG_BITS_8},
	{0xA405, 0x0a, REG_BITS_8},
	{0xA406, 0x03, REG_BITS_8},
	{0xA407, 0x18, REG_BITS_8},
	{0xA408, 0xbc, REG_BITS_8},
	{0xA409, 0xb0, REG_BITS_8},
	{0xA40A, 0x25, REG_BITS_8},
	{0xA40B, 0x2d, REG_BITS_8},
	{0xA40C, 0x6f, REG_BITS_8},
	{0xA40D, 0xa1, REG_BITS_8},
	{0xA40E, 0x8b, REG_BITS_8},
	{0xA40F, 0x5a, REG_BITS_8},
	{0xA410, 0xac, REG_BITS_8},
	{0xA411, 0x12, REG_BITS_8},
	{0xA412, 0x97, REG_BITS_8},
	{0xA413, 0xb9, REG_BITS_8},
	{0xA414, 0xac, REG_BITS_8},
	{0xA415, 0x25, REG_BITS_8},
	{0xA416, 0x2c, REG_BITS_8},
	{0xA417, 0x5a, REG_BITS_8},
	{0xA418, 0x11, REG_BITS_8},
	{0xA419, 0x0b, REG_BITS_8},
	{0xA41A, 0x59, REG_BITS_8},
	{0xA41B, 0x8e, REG_BITS_8},
	{0xA41C, 0x02, REG_BITS_8},
	{0xA41D, 0x00, REG_BITS_8},
	{0xA41E, 0x00, REG_BITS_8},
	{0xA41F, 0x00, REG_BITS_8},
	{0xA420, 0x00, REG_BITS_8},
	{0xA421, 0x0a, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_SHD_1_ES2 = sizeof(seix006_vendor_1_SHD_1_ES2);

const struct reg_entry seix006_vendor_1_SHD_2_ES2[] = {
	{0x0068, 0x50, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0x01, REG_BITS_8},
	{0x9003, 0x10, REG_BITS_8},
	{0x9004, 0x04, REG_BITS_8},
	{0x9005, 0x40, REG_BITS_8},
	{0x9006, 0x10, REG_BITS_8},
	{0x9007, 0x00, REG_BITS_8},
	{0x9008, 0x41, REG_BITS_8},
	{0x9009, 0x80, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x00, REG_BITS_8},
	{0x900C, 0x12, REG_BITS_8},
	{0x900D, 0x04, REG_BITS_8},
	{0x900E, 0x50, REG_BITS_8},
	{0x900F, 0x10, REG_BITS_8},
	{0x9010, 0x20, REG_BITS_8},
	{0x9011, 0x81, REG_BITS_8},
	{0x9012, 0x80, REG_BITS_8},
	{0x9013, 0x04, REG_BITS_8},
	{0x9014, 0x02, REG_BITS_8},
	{0x9015, 0x12, REG_BITS_8},
	{0x9016, 0x04, REG_BITS_8},
	{0x9017, 0x40, REG_BITS_8},
	{0x9018, 0x10, REG_BITS_8},
	{0x9019, 0x00, REG_BITS_8},
	{0x901A, 0x41, REG_BITS_8},
	{0x901B, 0x00, REG_BITS_8},
	{0x901C, 0x04, REG_BITS_8},
	{0x901D, 0x01, REG_BITS_8},
	{0x901E, 0x12, REG_BITS_8},
	{0x901F, 0x00, REG_BITS_8},
	{0x9020, 0x48, REG_BITS_8},
	{0x9021, 0x10, REG_BITS_8},
	{0x9022, 0x40, REG_BITS_8},
	{0x9023, 0x41, REG_BITS_8},
	{0x9024, 0x80, REG_BITS_8},
	{0x9025, 0x04, REG_BITS_8},
	{0x9026, 0x02, REG_BITS_8},
	{0x9027, 0x12, REG_BITS_8},
	{0x9028, 0x08, REG_BITS_8},
	{0x9029, 0x48, REG_BITS_8},
	{0x902A, 0x10, REG_BITS_8},
	{0x902B, 0xe0, REG_BITS_8},
	{0x902C, 0x40, REG_BITS_8},
	{0x902D, 0x80, REG_BITS_8},
	{0x902E, 0x03, REG_BITS_8},
	{0x902F, 0x00, REG_BITS_8},
	{0x9030, 0x0a, REG_BITS_8},
	{0x9031, 0x04, REG_BITS_8},
	{0x9032, 0x38, REG_BITS_8},
	{0x9033, 0x30, REG_BITS_8},
	{0x9034, 0xe0, REG_BITS_8},
	{0x9035, 0x80, REG_BITS_8},
	{0x9036, 0x80, REG_BITS_8},
	{0x9037, 0x03, REG_BITS_8},
	{0x9038, 0x01, REG_BITS_8},
	{0x9039, 0x12, REG_BITS_8},
	{0x903A, 0x0c, REG_BITS_8},
	{0x903B, 0x50, REG_BITS_8},
	{0x903C, 0x30, REG_BITS_8},
	{0x903D, 0x40, REG_BITS_8},
	{0x903E, 0xc1, REG_BITS_8},
	{0x903F, 0x00, REG_BITS_8},
	{0x9040, 0x03, REG_BITS_8},
	{0x9041, 0x03, REG_BITS_8},
	{0x9042, 0x0c, REG_BITS_8},
	{0x9043, 0x0c, REG_BITS_8},
	{0x9044, 0x28, REG_BITS_8},
	{0x9045, 0x10, REG_BITS_8},
	{0x9046, 0x60, REG_BITS_8},
	{0x9047, 0x40, REG_BITS_8},
	{0x9048, 0x00, REG_BITS_8},
	{0x9049, 0x02, REG_BITS_8},
	{0x904A, 0x01, REG_BITS_8},
	{0x904B, 0x0c, REG_BITS_8},
	{0x904C, 0x08, REG_BITS_8},
	{0x904D, 0x30, REG_BITS_8},
	{0x904E, 0x20, REG_BITS_8},
	{0x904F, 0xe0, REG_BITS_8},
	{0x9050, 0x80, REG_BITS_8},
	{0x9051, 0x80, REG_BITS_8},
	{0x9052, 0x03, REG_BITS_8},
	{0x9053, 0x03, REG_BITS_8},
	{0x9054, 0x06, REG_BITS_8},
	{0x9055, 0x0c, REG_BITS_8},
	{0x9056, 0x18, REG_BITS_8},
	{0x9057, 0x20, REG_BITS_8},
	{0x9058, 0x60, REG_BITS_8},
	{0x9059, 0xc0, REG_BITS_8},
	{0x905A, 0x00, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x02, REG_BITS_8},
	{0x905D, 0x02, REG_BITS_8},
	{0x905E, 0x08, REG_BITS_8},
	{0x905F, 0x10, REG_BITS_8},
	{0x9060, 0x30, REG_BITS_8},
	{0x9061, 0x80, REG_BITS_8},
	{0x9062, 0x80, REG_BITS_8},
	{0x9063, 0x80, REG_BITS_8},
	{0x9064, 0x02, REG_BITS_8},
	{0x9065, 0x02, REG_BITS_8},
	{0x9066, 0x0a, REG_BITS_8},
	{0x9067, 0x08, REG_BITS_8},
	{0x9068, 0x10, REG_BITS_8},
	{0x9069, 0x20, REG_BITS_8},
	{0x906A, 0x40, REG_BITS_8},
	{0x906B, 0x40, REG_BITS_8},
	{0x906C, 0x80, REG_BITS_8},
	{0x906D, 0x00, REG_BITS_8},
	{0x906E, 0x02, REG_BITS_8},
	{0x906F, 0x00, REG_BITS_8},
	{0x9070, 0x08, REG_BITS_8},
	{0x9071, 0x08, REG_BITS_8},
	{0x9072, 0x20, REG_BITS_8},
	{0x9073, 0x00, REG_BITS_8},
	{0x9074, 0x80, REG_BITS_8},
	{0x9075, 0x00, REG_BITS_8},
	{0x9076, 0x01, REG_BITS_8},
	{0x9077, 0x02, REG_BITS_8},
	{0x9078, 0x0a, REG_BITS_8},
	{0x9079, 0x08, REG_BITS_8},
	{0x907A, 0x28, REG_BITS_8},
	{0x907B, 0x30, REG_BITS_8},
	{0x907C, 0x40, REG_BITS_8},
	{0x907D, 0xc0, REG_BITS_8},
	{0x907E, 0x00, REG_BITS_8},
	{0x907F, 0x01, REG_BITS_8},
	{0x9080, 0x03, REG_BITS_8},
	{0x9081, 0xfe, REG_BITS_8},
	{0x9082, 0x0b, REG_BITS_8},
	{0x9083, 0xf8, REG_BITS_8},
	{0x9084, 0x2f, REG_BITS_8},
	{0x9085, 0x00, REG_BITS_8},
	{0x9086, 0x80, REG_BITS_8},
	{0x9087, 0x00, REG_BITS_8},
	{0x9088, 0x00, REG_BITS_8},
	{0x9089, 0x01, REG_BITS_8},
	{0x908A, 0x02, REG_BITS_8},
	{0x908B, 0x04, REG_BITS_8},
	{0x908C, 0x20, REG_BITS_8},
	{0x908D, 0x10, REG_BITS_8},
	{0x908E, 0x80, REG_BITS_8},
	{0x908F, 0x80, REG_BITS_8},
	{0x9090, 0x80, REG_BITS_8},
	{0x9091, 0x01, REG_BITS_8},
	{0x9092, 0x02, REG_BITS_8},
	{0x9093, 0x06, REG_BITS_8},
	{0x9094, 0x14, REG_BITS_8},
	{0x9095, 0x00, REG_BITS_8},
	{0x9096, 0x10, REG_BITS_8},
	{0x9097, 0xe0, REG_BITS_8},
	{0x9098, 0xbf, REG_BITS_8},
	{0x9099, 0x80, REG_BITS_8},
	{0x909A, 0xff, REG_BITS_8},
	{0x909B, 0x04, REG_BITS_8},
	{0x909C, 0xfe, REG_BITS_8},
	{0x909D, 0x0b, REG_BITS_8},
	{0x909E, 0x00, REG_BITS_8},
	{0x909F, 0x20, REG_BITS_8},
	{0x90A0, 0x40, REG_BITS_8},
	{0x90A1, 0x80, REG_BITS_8},
	{0x90A2, 0x00, REG_BITS_8},
	{0x90A3, 0x01, REG_BITS_8},
	{0x90A4, 0x03, REG_BITS_8},
	{0x90A5, 0x04, REG_BITS_8},
	{0x90A6, 0x0c, REG_BITS_8},
	{0x90A7, 0x10, REG_BITS_8},
	{0x90A8, 0x40, REG_BITS_8},
	{0x90A9, 0x20, REG_BITS_8},
	{0x90AA, 0x40, REG_BITS_8},
	{0x90AB, 0x01, REG_BITS_8},
	{0x90AC, 0x00, REG_BITS_8},
	{0x90AD, 0x05, REG_BITS_8},
	{0x90AE, 0x00, REG_BITS_8},
	{0x90AF, 0x10, REG_BITS_8},
	{0x90B0, 0x08, REG_BITS_8},
	{0x90B1, 0x30, REG_BITS_8},
	{0x90B2, 0x40, REG_BITS_8},
	{0x90B3, 0x00, REG_BITS_8},
	{0x90B4, 0x01, REG_BITS_8},
	{0x90B5, 0x02, REG_BITS_8},
	{0x90B6, 0x04, REG_BITS_8},
	{0x90B7, 0x08, REG_BITS_8},
	{0x90B8, 0x00, REG_BITS_8},
	{0x90B9, 0x18, REG_BITS_8},
	{0x90BA, 0x00, REG_BITS_8},
	{0x90BB, 0x60, REG_BITS_8},
	{0x90BC, 0xc0, REG_BITS_8},
	{0x90BD, 0x00, REG_BITS_8},
	{0x90BE, 0x01, REG_BITS_8},
	{0x90BF, 0x02, REG_BITS_8},
	{0x90C0, 0x06, REG_BITS_8},
	{0x90C1, 0x18, REG_BITS_8},
	{0x90C2, 0x20, REG_BITS_8},
	{0x90C3, 0x50, REG_BITS_8},
	{0x90C4, 0x60, REG_BITS_8},
	{0x90C5, 0x40, REG_BITS_8},
	{0x90C6, 0x81, REG_BITS_8},
	{0x90C7, 0x01, REG_BITS_8},
	{0x90C8, 0x05, REG_BITS_8},
	{0x90C9, 0x06, REG_BITS_8},
	{0x90CA, 0x14, REG_BITS_8},
	{0x90CB, 0x18, REG_BITS_8},
	{0x90CC, 0x20, REG_BITS_8},
	{0x90CD, 0x80, REG_BITS_8},
	{0x90CE, 0x80, REG_BITS_8},
	{0x90CF, 0x00, REG_BITS_8},
	{0x90D0, 0x02, REG_BITS_8},
	{0x90D1, 0x06, REG_BITS_8},
	{0x90D2, 0x0a, REG_BITS_8},
	{0x90D3, 0x08, REG_BITS_8},
	{0x90D4, 0x20, REG_BITS_8},
	{0x90D5, 0x50, REG_BITS_8},
	{0x90D6, 0xa0, REG_BITS_8},
	{0x90D7, 0xc0, REG_BITS_8},
	{0x90D8, 0x80, REG_BITS_8},
	{0x90D9, 0x02, REG_BITS_8},
	{0x90DA, 0x04, REG_BITS_8},
	{0x90DB, 0x0a, REG_BITS_8},
	{0x90DC, 0x08, REG_BITS_8},
	{0x90DD, 0x30, REG_BITS_8},
	{0x90DE, 0x20, REG_BITS_8},
	{0x90DF, 0xc0, REG_BITS_8},
	{0x90E0, 0x80, REG_BITS_8},
	{0x90E1, 0x00, REG_BITS_8},
	{0x90E2, 0x02, REG_BITS_8},
	{0x90E3, 0x02, REG_BITS_8},
	{0x90E4, 0x08, REG_BITS_8},
	{0x90E5, 0x18, REG_BITS_8},
	{0x90E6, 0x28, REG_BITS_8},
	{0x90E7, 0x20, REG_BITS_8},
	{0x90E8, 0x80, REG_BITS_8},
	{0x90E9, 0x40, REG_BITS_8},
	{0x90EA, 0x81, REG_BITS_8},
	{0x90EB, 0x02, REG_BITS_8},
	{0x90EC, 0x03, REG_BITS_8},
	{0x90ED, 0x0a, REG_BITS_8},
	{0x90EE, 0x10, REG_BITS_8},
	{0x90EF, 0x28, REG_BITS_8},
	{0x90F0, 0x20, REG_BITS_8},
	{0x90F1, 0xc0, REG_BITS_8},
	{0x90F2, 0x80, REG_BITS_8},
	{0x90F3, 0x00, REG_BITS_8},
	{0x90F4, 0x03, REG_BITS_8},
	{0x90F5, 0x01, REG_BITS_8},
	{0x90F6, 0xf0, REG_BITS_8},
	{0x90F7, 0x07, REG_BITS_8},
	{0x90F8, 0xc0, REG_BITS_8},
	{0x90F9, 0x1f, REG_BITS_8},
	{0x90FA, 0xc0, REG_BITS_8},
	{0x90FB, 0x3e, REG_BITS_8},
	{0x90FC, 0x00, REG_BITS_8},
	{0x90FD, 0xfd, REG_BITS_8},
	{0x90FE, 0xff, REG_BITS_8},
	{0x90FF, 0xf1, REG_BITS_8},
	{0x9100, 0x03, REG_BITS_8},
	{0x9101, 0xb8, REG_BITS_8},
	{0x9102, 0x0f, REG_BITS_8},
	{0x9103, 0x40, REG_BITS_8},
	{0x9104, 0x3f, REG_BITS_8},
	{0x9105, 0x80, REG_BITS_8},
	{0x9106, 0xfa, REG_BITS_8},
	{0x9107, 0x00, REG_BITS_8},
	{0x9108, 0xea, REG_BITS_8},
	{0x9109, 0x07, REG_BITS_8},
	{0x910A, 0xc0, REG_BITS_8},
	{0x910B, 0x1f, REG_BITS_8},
	{0x910C, 0x00, REG_BITS_8},
	{0x910D, 0x7f, REG_BITS_8},
	{0x910E, 0x00, REG_BITS_8},
	{0x910F, 0xfb, REG_BITS_8},
	{0x9110, 0x00, REG_BITS_8},
	{0x9111, 0xf4, REG_BITS_8},
	{0x9112, 0xff, REG_BITS_8},
	{0x9113, 0xc7, REG_BITS_8},
	{0x9114, 0x0f, REG_BITS_8},
	{0x9115, 0xe0, REG_BITS_8},
	{0x9116, 0x3e, REG_BITS_8},
	{0x9117, 0x00, REG_BITS_8},
	{0x9118, 0xfd, REG_BITS_8},
	{0x9119, 0x00, REG_BITS_8},
	{0x911A, 0xea, REG_BITS_8},
	{0x911B, 0x03, REG_BITS_8},
	{0x911C, 0xa8, REG_BITS_8},
	{0x911D, 0x2f, REG_BITS_8},
	{0x911E, 0x40, REG_BITS_8},
	{0x911F, 0xbf, REG_BITS_8},
	{0x9120, 0x00, REG_BITS_8},
	{0x9121, 0xfd, REG_BITS_8},
	{0x9122, 0x01, REG_BITS_8},
	{0x9123, 0xec, REG_BITS_8},
	{0x9124, 0x03, REG_BITS_8},
	{0x9125, 0xa8, REG_BITS_8},
	{0x9126, 0x0f, REG_BITS_8},
	{0x9127, 0x20, REG_BITS_8},
	{0x9128, 0xff, REG_BITS_8},
	{0x9129, 0xff, REG_BITS_8},
	{0x912A, 0xfc, REG_BITS_8},
	{0x912B, 0x01, REG_BITS_8},
	{0x912C, 0xf4, REG_BITS_8},
	{0x912D, 0x07, REG_BITS_8},
	{0x912E, 0xb0, REG_BITS_8},
	{0x912F, 0x1f, REG_BITS_8},
	{0x9130, 0xc0, REG_BITS_8},
	{0x9131, 0x7e, REG_BITS_8},
	{0x9132, 0x00, REG_BITS_8},
	{0x9133, 0xfb, REG_BITS_8},
	{0x9134, 0x01, REG_BITS_8},
	{0x9135, 0xec, REG_BITS_8},
	{0x9136, 0x03, REG_BITS_8},
	{0x9137, 0xb8, REG_BITS_8},
	{0x9138, 0xff, REG_BITS_8},
	{0x9139, 0x1f, REG_BITS_8},
	{0x913A, 0xbf, REG_BITS_8},
	{0x913B, 0xff, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0x00, REG_BITS_8},
	{0x913E, 0xec, REG_BITS_8},
	{0x913F, 0xff, REG_BITS_8},
	{0x9140, 0xbf, REG_BITS_8},
	{0x9141, 0x0f, REG_BITS_8},
	{0x9142, 0x40, REG_BITS_8},
	{0x9143, 0x3f, REG_BITS_8},
	{0x9144, 0x00, REG_BITS_8},
	{0x9145, 0xfd, REG_BITS_8},
	{0x9146, 0x00, REG_BITS_8},
	{0x9147, 0xe8, REG_BITS_8},
	{0x9148, 0x03, REG_BITS_8},
	{0x9149, 0xa0, REG_BITS_8},
	{0x914A, 0xff, REG_BITS_8},
	{0x914B, 0x3f, REG_BITS_8},
	{0x914C, 0xff, REG_BITS_8},
	{0x914D, 0xff, REG_BITS_8},
	{0x914E, 0xfd, REG_BITS_8},
	{0x914F, 0xfe, REG_BITS_8},
	{0x9150, 0xf3, REG_BITS_8},
	{0x9151, 0xfb, REG_BITS_8},
	{0x9152, 0xc7, REG_BITS_8},
	{0x9153, 0x0f, REG_BITS_8},
	{0x9154, 0x40, REG_BITS_8},
	{0x9155, 0xff, REG_BITS_8},
	{0x9156, 0x7f, REG_BITS_8},
	{0x9157, 0xfe, REG_BITS_8},
	{0x9158, 0xff, REG_BITS_8},
	{0x9159, 0xf9, REG_BITS_8},
	{0x915A, 0x07, REG_BITS_8},
	{0x915B, 0xb8, REG_BITS_8},
	{0x915C, 0x1f, REG_BITS_8},
	{0x915D, 0xe0, REG_BITS_8},
	{0x915E, 0x3e, REG_BITS_8},
	{0x915F, 0x00, REG_BITS_8},
	{0x9160, 0xfd, REG_BITS_8},
	{0x9161, 0x00, REG_BITS_8},
	{0x9162, 0xf6, REG_BITS_8},
	{0x9163, 0xff, REG_BITS_8},
	{0x9164, 0xd7, REG_BITS_8},
	{0x9165, 0xef, REG_BITS_8},
	{0x9166, 0xbf, REG_BITS_8},
	{0x9167, 0xff, REG_BITS_8},
	{0x9168, 0x7f, REG_BITS_8},
	{0x9169, 0xfd, REG_BITS_8},
	{0x916A, 0xff, REG_BITS_8},
	{0x916B, 0xfd, REG_BITS_8},
	{0x916C, 0xff, REG_BITS_8},
	{0x916D, 0xf7, REG_BITS_8},
	{0x916E, 0x4f, REG_BITS_8},
	{0x916F, 0xa0, REG_BITS_8},
	{0x9170, 0x3f, REG_BITS_8},
	{0x9171, 0x81, REG_BITS_8},
	{0x9172, 0xfe, REG_BITS_8},
	{0x9173, 0x03, REG_BITS_8},
	{0x9174, 0xf4, REG_BITS_8},
	{0x9175, 0x03, REG_BITS_8},
	{0x9176, 0xe8, REG_BITS_8},
	{0x9177, 0x0f, REG_BITS_8},
	{0x9178, 0x20, REG_BITS_8},
	{0x9179, 0x80, REG_BITS_8},
	{0x917A, 0x7f, REG_BITS_8},
	{0x917B, 0x00, REG_BITS_8},
	{0x917C, 0x00, REG_BITS_8},
	{0x917D, 0xfe, REG_BITS_8},
	{0x917E, 0x0b, REG_BITS_8},
	{0x917F, 0x00, REG_BITS_8},
	{0x9180, 0x20, REG_BITS_8},
	{0x9181, 0x00, REG_BITS_8},
	{0x9182, 0x40, REG_BITS_8},
	{0x9183, 0x81, REG_BITS_8},
	{0x9184, 0x00, REG_BITS_8},
	{0x9185, 0x05, REG_BITS_8},
	{0x9186, 0x02, REG_BITS_8},
	{0x9187, 0x0c, REG_BITS_8},
	{0x9188, 0x08, REG_BITS_8},
	{0x9189, 0x20, REG_BITS_8},
	{0x918A, 0x00, REG_BITS_8},
	{0x918B, 0x00, REG_BITS_8},
	{0x918C, 0x00, REG_BITS_8},
	{0x918D, 0x01, REG_BITS_8},
	{0x918E, 0x00, REG_BITS_8},
	{0x918F, 0x04, REG_BITS_8},
	{0x9190, 0x04, REG_BITS_8},
	{0x9191, 0x08, REG_BITS_8},
	{0x9192, 0x10, REG_BITS_8},
	{0x9193, 0x00, REG_BITS_8},
	{0x9194, 0x40, REG_BITS_8},
	{0x9195, 0x00, REG_BITS_8},
	{0x9196, 0x00, REG_BITS_8},
	{0x9197, 0x07, REG_BITS_8},
	{0x9198, 0x00, REG_BITS_8},
	{0x9199, 0x1c, REG_BITS_8},
	{0x919A, 0x00, REG_BITS_8},
	{0x919B, 0x40, REG_BITS_8},
	{0x919C, 0xa0, REG_BITS_8},
	{0x919D, 0x00, REG_BITS_8},
	{0x919E, 0x01, REG_BITS_8},
	{0x919F, 0x03, REG_BITS_8},
	{0x91A0, 0x03, REG_BITS_8},
	{0x91A1, 0x0c, REG_BITS_8},
	{0x91A2, 0x04, REG_BITS_8},
	{0x91A3, 0x28, REG_BITS_8},
	{0x91A4, 0x20, REG_BITS_8},
	{0x91A5, 0xc0, REG_BITS_8},
	{0x91A6, 0xc0, REG_BITS_8},
	{0x91A7, 0x00, REG_BITS_8},
	{0x91A8, 0x03, REG_BITS_8},
	{0x91A9, 0x03, REG_BITS_8},
	{0x91AA, 0x0c, REG_BITS_8},
	{0x91AB, 0x18, REG_BITS_8},
	{0x91AC, 0x28, REG_BITS_8},
	{0x91AD, 0x60, REG_BITS_8},
	{0x91AE, 0xa0, REG_BITS_8},
	{0x91AF, 0x80, REG_BITS_8},
	{0x91B0, 0x81, REG_BITS_8},
	{0x91B1, 0x02, REG_BITS_8},
	{0x91B2, 0x03, REG_BITS_8},
	{0x91B3, 0x0c, REG_BITS_8},
	{0x91B4, 0x0c, REG_BITS_8},
	{0x91B5, 0x40, REG_BITS_8},
	{0x91B6, 0x30, REG_BITS_8},
	{0x91B7, 0xe0, REG_BITS_8},
	{0x91B8, 0xc0, REG_BITS_8},
	{0x91B9, 0x80, REG_BITS_8},
	{0x91BA, 0x02, REG_BITS_8},
	{0x91BB, 0x03, REG_BITS_8},
	{0x91BC, 0x14, REG_BITS_8},
	{0x91BD, 0x0c, REG_BITS_8},
	{0x91BE, 0x50, REG_BITS_8},
	{0x91BF, 0x60, REG_BITS_8},
	{0x91C0, 0x60, REG_BITS_8},
	{0x91C1, 0x80, REG_BITS_8},
	{0x91C2, 0x81, REG_BITS_8},
	{0x91C3, 0x01, REG_BITS_8},
	{0x91C4, 0x06, REG_BITS_8},
	{0x91C5, 0x0c, REG_BITS_8},
	{0x91C6, 0x10, REG_BITS_8},
	{0x91C7, 0x30, REG_BITS_8},
	{0x91C8, 0x50, REG_BITS_8},
	{0x91C9, 0x00, REG_BITS_8},
	{0x91CA, 0x41, REG_BITS_8},
	{0x91CB, 0x81, REG_BITS_8},
	{0x91CC, 0x04, REG_BITS_8},
	{0x91CD, 0x04, REG_BITS_8},
	{0x91CE, 0x10, REG_BITS_8},
	{0x91CF, 0x10, REG_BITS_8},
	{0x91D0, 0x40, REG_BITS_8},
	{0x91D1, 0x40, REG_BITS_8},
	{0x91D2, 0x00, REG_BITS_8},
	{0x91D3, 0x81, REG_BITS_8},
	{0x91D4, 0x81, REG_BITS_8},
	{0x91D5, 0x01, REG_BITS_8},
	{0x91D6, 0x06, REG_BITS_8},
	{0x91D7, 0x06, REG_BITS_8},
	{0x91D8, 0x18, REG_BITS_8},
	{0x91D9, 0x30, REG_BITS_8},
	{0x91DA, 0x40, REG_BITS_8},
	{0x91DB, 0xc0, REG_BITS_8},
	{0x91DC, 0x40, REG_BITS_8},
	{0x91DD, 0x01, REG_BITS_8},
	{0x91DE, 0x04, REG_BITS_8},
	{0x91DF, 0x05, REG_BITS_8},
	{0x91E0, 0x12, REG_BITS_8},
	{0x91E1, 0x10, REG_BITS_8},
	{0x91E2, 0x40, REG_BITS_8},
	{0x91E3, 0x40, REG_BITS_8},
	{0x91E4, 0x00, REG_BITS_8},
	{0x91E5, 0x01, REG_BITS_8},
	{0x91E6, 0x01, REG_BITS_8},
	{0x91E7, 0x04, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x41, REG_BITS_8},
	{0xA003, 0x61, REG_BITS_8},
	{0xA004, 0x8c, REG_BITS_8},
	{0xA005, 0x58, REG_BITS_8},
	{0xA006, 0x74, REG_BITS_8},
	{0xA007, 0x73, REG_BITS_8},
	{0xA008, 0x16, REG_BITS_8},
	{0xA009, 0xdf, REG_BITS_8},
	{0xA00A, 0x88, REG_BITS_8},
	{0xA00B, 0x25, REG_BITS_8},
	{0xA00C, 0x37, REG_BITS_8},
	{0xA00D, 0x60, REG_BITS_8},
	{0xA00E, 0xc9, REG_BITS_8},
	{0xA00F, 0x8d, REG_BITS_8},
	{0xA010, 0x58, REG_BITS_8},
	{0xA011, 0x72, REG_BITS_8},
	{0xA012, 0x63, REG_BITS_8},
	{0xA013, 0x96, REG_BITS_8},
	{0xA014, 0xde, REG_BITS_8},
	{0xA015, 0x88, REG_BITS_8},
	{0xA016, 0xc5, REG_BITS_8},
	{0xA017, 0x36, REG_BITS_8},
	{0xA018, 0x41, REG_BITS_8},
	{0xA019, 0x59, REG_BITS_8},
	{0xA01A, 0xcc, REG_BITS_8},
	{0xA01B, 0x5b, REG_BITS_8},
	{0xA01C, 0x90, REG_BITS_8},
	{0xA01D, 0x93, REG_BITS_8},
	{0xA01E, 0x17, REG_BITS_8},
	{0xA01F, 0xe9, REG_BITS_8},
	{0xA020, 0xd8, REG_BITS_8},
	{0xA021, 0x85, REG_BITS_8},
	{0xA022, 0x39, REG_BITS_8},
	{0xA023, 0x73, REG_BITS_8},
	{0xA024, 0x39, REG_BITS_8},
	{0xA025, 0x4e, REG_BITS_8},
	{0xA026, 0x5c, REG_BITS_8},
	{0xA027, 0x88, REG_BITS_8},
	{0xA028, 0x33, REG_BITS_8},
	{0xA029, 0x97, REG_BITS_8},
	{0xA02A, 0xe3, REG_BITS_8},
	{0xA02B, 0xd8, REG_BITS_8},
	{0xA02C, 0x65, REG_BITS_8},
	{0xA02D, 0x39, REG_BITS_8},
	{0xA02E, 0x77, REG_BITS_8},
	{0xA02F, 0x81, REG_BITS_8},
	{0xA030, 0xce, REG_BITS_8},
	{0xA031, 0x5a, REG_BITS_8},
	{0xA032, 0x88, REG_BITS_8},
	{0xA033, 0xe3, REG_BITS_8},
	{0xA034, 0x16, REG_BITS_8},
	{0xA035, 0xe1, REG_BITS_8},
	{0xA036, 0xd0, REG_BITS_8},
	{0xA037, 0x65, REG_BITS_8},
	{0xA038, 0x38, REG_BITS_8},
	{0xA039, 0x64, REG_BITS_8},
	{0xA03A, 0x31, REG_BITS_8},
	{0xA03B, 0x8d, REG_BITS_8},
	{0xA03C, 0x56, REG_BITS_8},
	{0xA03D, 0x2a, REG_BITS_8},
	{0xA03E, 0x63, REG_BITS_8},
	{0xA03F, 0x15, REG_BITS_8},
	{0xA040, 0xc7, REG_BITS_8},
	{0xA041, 0x64, REG_BITS_8},
	{0xA042, 0x85, REG_BITS_8},
	{0xA043, 0x32, REG_BITS_8},
	{0xA044, 0x63, REG_BITS_8},
	{0xA045, 0x41, REG_BITS_8},
	{0xA046, 0x8d, REG_BITS_8},
	{0xA047, 0x5c, REG_BITS_8},
	{0xA048, 0x88, REG_BITS_8},
	{0xA049, 0x83, REG_BITS_8},
	{0xA04A, 0x16, REG_BITS_8},
	{0xA04B, 0xdf, REG_BITS_8},
	{0xA04C, 0xa8, REG_BITS_8},
	{0xA04D, 0xe5, REG_BITS_8},
	{0xA04E, 0x35, REG_BITS_8},
	{0xA04F, 0x63, REG_BITS_8},
	{0xA050, 0xf9, REG_BITS_8},
	{0xA051, 0x0c, REG_BITS_8},
	{0xA052, 0x53, REG_BITS_8},
	{0xA053, 0xf0, REG_BITS_8},
	{0xA054, 0xb2, REG_BITS_8},
	{0xA055, 0x13, REG_BITS_8},
	{0xA056, 0xad, REG_BITS_8},
	{0xA057, 0xd0, REG_BITS_8},
	{0xA058, 0x04, REG_BITS_8},
	{0xA059, 0x2a, REG_BITS_8},
	{0xA05A, 0x3a, REG_BITS_8},
	{0xA05B, 0xd9, REG_BITS_8},
	{0xA05C, 0xca, REG_BITS_8},
	{0xA05D, 0x52, REG_BITS_8},
	{0xA05E, 0xee, REG_BITS_8},
	{0xA05F, 0x02, REG_BITS_8},
	{0xA060, 0x96, REG_BITS_8},
	{0xA061, 0xce, REG_BITS_8},
	{0xA062, 0x90, REG_BITS_8},
	{0xA063, 0x45, REG_BITS_8},
	{0xA064, 0x35, REG_BITS_8},
	{0xA065, 0x5f, REG_BITS_8},
	{0xA066, 0xa9, REG_BITS_8},
	{0xA067, 0x4c, REG_BITS_8},
	{0xA068, 0x54, REG_BITS_8},
	{0xA069, 0xf8, REG_BITS_8},
	{0xA06A, 0x32, REG_BITS_8},
	{0xA06B, 0x93, REG_BITS_8},
	{0xA06C, 0xa6, REG_BITS_8},
	{0xA06D, 0x6c, REG_BITS_8},
	{0xA06E, 0x04, REG_BITS_8},
	{0xA06F, 0x25, REG_BITS_8},
	{0xA070, 0x13, REG_BITS_8},
	{0xA071, 0xe1, REG_BITS_8},
	{0xA072, 0xc8, REG_BITS_8},
	{0xA073, 0x46, REG_BITS_8},
	{0xA074, 0x4e, REG_BITS_8},
	{0xA075, 0x42, REG_BITS_8},
	{0xA076, 0x93, REG_BITS_8},
	{0xA077, 0xa5, REG_BITS_8},
	{0xA078, 0x40, REG_BITS_8},
	{0xA079, 0x65, REG_BITS_8},
	{0xA07A, 0x2f, REG_BITS_8},
	{0xA07B, 0x5b, REG_BITS_8},
	{0xA07C, 0x91, REG_BITS_8},
	{0xA07D, 0x4c, REG_BITS_8},
	{0xA07E, 0x54, REG_BITS_8},
	{0xA07F, 0x02, REG_BITS_8},
	{0xA080, 0x33, REG_BITS_8},
	{0xA081, 0x14, REG_BITS_8},
	{0xA082, 0xb3, REG_BITS_8},
	{0xA083, 0x88, REG_BITS_8},
	{0xA084, 0x44, REG_BITS_8},
	{0xA085, 0x26, REG_BITS_8},
	{0xA086, 0x09, REG_BITS_8},
	{0xA087, 0x69, REG_BITS_8},
	{0xA088, 0x48, REG_BITS_8},
	{0xA089, 0x40, REG_BITS_8},
	{0xA08A, 0x04, REG_BITS_8},
	{0xA08B, 0x92, REG_BITS_8},
	{0xA08C, 0x10, REG_BITS_8},
	{0xA08D, 0x86, REG_BITS_8},
	{0xA08E, 0x90, REG_BITS_8},
	{0xA08F, 0x44, REG_BITS_8},
	{0xA090, 0x26, REG_BITS_8},
	{0xA091, 0x44, REG_BITS_8},
	{0xA092, 0x39, REG_BITS_8},
	{0xA093, 0xcb, REG_BITS_8},
	{0xA094, 0x53, REG_BITS_8},
	{0xA095, 0x02, REG_BITS_8},
	{0xA096, 0x03, REG_BITS_8},
	{0xA097, 0x95, REG_BITS_8},
	{0xA098, 0xc0, REG_BITS_8},
	{0xA099, 0x08, REG_BITS_8},
	{0xA09A, 0x85, REG_BITS_8},
	{0xA09B, 0x2c, REG_BITS_8},
	{0xA09C, 0x21, REG_BITS_8},
	{0xA09D, 0x69, REG_BITS_8},
	{0xA09E, 0xc9, REG_BITS_8},
	{0xA09F, 0x41, REG_BITS_8},
	{0xA0A0, 0x10, REG_BITS_8},
	{0xA0A1, 0xe2, REG_BITS_8},
	{0xA0A2, 0x8f, REG_BITS_8},
	{0xA0A3, 0x7e, REG_BITS_8},
	{0xA0A4, 0x1c, REG_BITS_8},
	{0xA0A5, 0x04, REG_BITS_8},
	{0xA0A6, 0x21, REG_BITS_8},
	{0xA0A7, 0x21, REG_BITS_8},
	{0xA0A8, 0x69, REG_BITS_8},
	{0xA0A9, 0x89, REG_BITS_8},
	{0xA0AA, 0x50, REG_BITS_8},
	{0xA0AB, 0xc6, REG_BITS_8},
	{0xA0AC, 0xd2, REG_BITS_8},
	{0xA0AD, 0x14, REG_BITS_8},
	{0xA0AE, 0xbf, REG_BITS_8},
	{0xA0AF, 0x70, REG_BITS_8},
	{0xA0B0, 0x65, REG_BITS_8},
	{0xA0B1, 0x32, REG_BITS_8},
	{0xA0B2, 0x4d, REG_BITS_8},
	{0xA0B3, 0xb1, REG_BITS_8},
	{0xA0B4, 0xcb, REG_BITS_8},
	{0xA0B5, 0x4b, REG_BITS_8},
	{0xA0B6, 0x80, REG_BITS_8},
	{0xA0B7, 0x52, REG_BITS_8},
	{0xA0B8, 0x11, REG_BITS_8},
	{0xA0B9, 0x8d, REG_BITS_8},
	{0xA0BA, 0x34, REG_BITS_8},
	{0xA0BB, 0xe4, REG_BITS_8},
	{0xA0BC, 0x21, REG_BITS_8},
	{0xA0BD, 0x16, REG_BITS_8},
	{0xA0BE, 0xd1, REG_BITS_8},
	{0xA0BF, 0xc8, REG_BITS_8},
	{0xA0C0, 0x4b, REG_BITS_8},
	{0xA0C1, 0x7c, REG_BITS_8},
	{0xA0C2, 0xd2, REG_BITS_8},
	{0xA0C3, 0x14, REG_BITS_8},
	{0xA0C4, 0xb8, REG_BITS_8},
	{0xA0C5, 0x64, REG_BITS_8},
	{0xA0C6, 0x65, REG_BITS_8},
	{0xA0C7, 0x31, REG_BITS_8},
	{0xA0C8, 0x67, REG_BITS_8},
	{0xA0C9, 0x39, REG_BITS_8},
	{0xA0CA, 0x8d, REG_BITS_8},
	{0xA0CB, 0x57, REG_BITS_8},
	{0xA0CC, 0x26, REG_BITS_8},
	{0xA0CD, 0x63, REG_BITS_8},
	{0xA0CE, 0x94, REG_BITS_8},
	{0xA0CF, 0xb2, REG_BITS_8},
	{0xA0D0, 0xcc, REG_BITS_8},
	{0xA0D1, 0xc4, REG_BITS_8},
	{0xA0D2, 0x28, REG_BITS_8},
	{0xA0D3, 0x2c, REG_BITS_8},
	{0xA0D4, 0xd9, REG_BITS_8},
	{0xA0D5, 0xc9, REG_BITS_8},
	{0xA0D6, 0x4c, REG_BITS_8},
	{0xA0D7, 0x8c, REG_BITS_8},
	{0xA0D8, 0x62, REG_BITS_8},
	{0xA0D9, 0x94, REG_BITS_8},
	{0xA0DA, 0xb2, REG_BITS_8},
	{0xA0DB, 0x7c, REG_BITS_8},
	{0xA0DC, 0x25, REG_BITS_8},
	{0xA0DD, 0x32, REG_BITS_8},
	{0xA0DE, 0x65, REG_BITS_8},
	{0xA0DF, 0x19, REG_BITS_8},
	{0xA0E0, 0x0d, REG_BITS_8},
	{0xA0E1, 0x5b, REG_BITS_8},
	{0xA0E2, 0x72, REG_BITS_8},
	{0xA0E3, 0x13, REG_BITS_8},
	{0xA0E4, 0x97, REG_BITS_8},
	{0xA0E5, 0xdb, REG_BITS_8},
	{0xA0E6, 0x78, REG_BITS_8},
	{0xA0E7, 0x85, REG_BITS_8},
	{0xA0E8, 0x32, REG_BITS_8},
	{0xA0E9, 0x50, REG_BITS_8},
	{0xA0EA, 0xf1, REG_BITS_8},
	{0xA0EB, 0x0b, REG_BITS_8},
	{0xA0EC, 0x53, REG_BITS_8},
	{0xA0ED, 0xec, REG_BITS_8},
	{0xA0EE, 0x12, REG_BITS_8},
	{0xA0EF, 0x95, REG_BITS_8},
	{0xA0F0, 0xbe, REG_BITS_8},
	{0xA0F1, 0x7c, REG_BITS_8},
	{0xA0F2, 0x85, REG_BITS_8},
	{0xA0F3, 0x32, REG_BITS_8},
	{0xA0F4, 0x73, REG_BITS_8},
	{0xA0F5, 0xa9, REG_BITS_8},
	{0xA0F6, 0xcd, REG_BITS_8},
	{0xA0F7, 0x5a, REG_BITS_8},
	{0xA0F8, 0x66, REG_BITS_8},
	{0xA0F9, 0x03, REG_BITS_8},
	{0xA0FA, 0x17, REG_BITS_8},
	{0xA0FB, 0xe3, REG_BITS_8},
	{0xA0FC, 0xdc, REG_BITS_8},
	{0xA0FD, 0xa5, REG_BITS_8},
	{0xA0FE, 0x39, REG_BITS_8},
	{0xA0FF, 0x74, REG_BITS_8},
	{0xA100, 0x11, REG_BITS_8},
	{0xA101, 0x0e, REG_BITS_8},
	{0xA102, 0x5b, REG_BITS_8},
	{0xA103, 0x6a, REG_BITS_8},
	{0xA104, 0xa3, REG_BITS_8},
	{0xA105, 0x16, REG_BITS_8},
	{0xA106, 0xd8, REG_BITS_8},
	{0xA107, 0xb4, REG_BITS_8},
	{0xA108, 0xa5, REG_BITS_8},
	{0xA109, 0x36, REG_BITS_8},
	{0xA10A, 0x73, REG_BITS_8},
	{0xA10B, 0x01, REG_BITS_8},
	{0xA10C, 0x0e, REG_BITS_8},
	{0xA10D, 0x5e, REG_BITS_8},
	{0xA10E, 0x9a, REG_BITS_8},
	{0xA10F, 0xf3, REG_BITS_8},
	{0xA110, 0x16, REG_BITS_8},
	{0xA111, 0xe3, REG_BITS_8},
	{0xA112, 0x38, REG_BITS_8},
	{0xA113, 0x85, REG_BITS_8},
	{0xA114, 0x33, REG_BITS_8},
	{0xA115, 0x65, REG_BITS_8},
	{0xA116, 0xd1, REG_BITS_8},
	{0xA117, 0xcd, REG_BITS_8},
	{0xA118, 0x59, REG_BITS_8},
	{0xA119, 0x74, REG_BITS_8},
	{0xA11A, 0xe3, REG_BITS_8},
	{0xA11B, 0x95, REG_BITS_8},
	{0xA11C, 0xd6, REG_BITS_8},
	{0xA11D, 0x7c, REG_BITS_8},
	{0xA11E, 0xa5, REG_BITS_8},
	{0xA11F, 0x35, REG_BITS_8},
	{0xA120, 0x60, REG_BITS_8},
	{0xA121, 0x79, REG_BITS_8},
	{0xA122, 0xcd, REG_BITS_8},
	{0xA123, 0x59, REG_BITS_8},
	{0xA124, 0x74, REG_BITS_8},
	{0xA125, 0x73, REG_BITS_8},
	{0xA126, 0x96, REG_BITS_8},
	{0xA127, 0xdf, REG_BITS_8},
	{0xA128, 0x44, REG_BITS_8},
	{0xA129, 0xa5, REG_BITS_8},
	{0xA12A, 0x34, REG_BITS_8},
	{0xA12B, 0x34, REG_BITS_8},
	{0xA12C, 0x21, REG_BITS_8},
	{0xA12D, 0xca, REG_BITS_8},
	{0xA12E, 0x54, REG_BITS_8},
	{0xA12F, 0xcc, REG_BITS_8},
	{0xA130, 0x92, REG_BITS_8},
	{0xA131, 0x15, REG_BITS_8},
	{0xA132, 0xb5, REG_BITS_8},
	{0xA133, 0x5c, REG_BITS_8},
	{0xA134, 0xe5, REG_BITS_8},
	{0xA135, 0x2c, REG_BITS_8},
	{0xA136, 0x58, REG_BITS_8},
	{0xA137, 0x39, REG_BITS_8},
	{0xA138, 0xcb, REG_BITS_8},
	{0xA139, 0x56, REG_BITS_8},
	{0xA13A, 0xcc, REG_BITS_8},
	{0xA13B, 0x02, REG_BITS_8},
	{0xA13C, 0x16, REG_BITS_8},
	{0xA13D, 0xb6, REG_BITS_8},
	{0xA13E, 0x6c, REG_BITS_8},
	{0xA13F, 0xa5, REG_BITS_8},
	{0xA140, 0x2c, REG_BITS_8},
	{0xA141, 0x3b, REG_BITS_8},
	{0xA142, 0x21, REG_BITS_8},
	{0xA143, 0x0a, REG_BITS_8},
	{0xA144, 0x57, REG_BITS_8},
	{0xA145, 0xe6, REG_BITS_8},
	{0xA146, 0x62, REG_BITS_8},
	{0xA147, 0x16, REG_BITS_8},
	{0xA148, 0xbe, REG_BITS_8},
	{0xA149, 0x9c, REG_BITS_8},
	{0xA14A, 0x45, REG_BITS_8},
	{0xA14B, 0x2f, REG_BITS_8},
	{0xA14C, 0x67, REG_BITS_8},
	{0xA14D, 0xc1, REG_BITS_8},
	{0xA14E, 0xcb, REG_BITS_8},
	{0xA14F, 0x59, REG_BITS_8},
	{0xA150, 0xee, REG_BITS_8},
	{0xA151, 0xb2, REG_BITS_8},
	{0xA152, 0x96, REG_BITS_8},
	{0xA153, 0xbc, REG_BITS_8},
	{0xA154, 0xb8, REG_BITS_8},
	{0xA155, 0x85, REG_BITS_8},
	{0xA156, 0x2f, REG_BITS_8},
	{0xA157, 0x6f, REG_BITS_8},
	{0xA158, 0xd9, REG_BITS_8},
	{0xA159, 0x4b, REG_BITS_8},
	{0xA15A, 0x58, REG_BITS_8},
	{0xA15B, 0xda, REG_BITS_8},
	{0xA15C, 0xb2, REG_BITS_8},
	{0xA15D, 0x15, REG_BITS_8},
	{0xA15E, 0xb8, REG_BITS_8},
	{0xA15F, 0x8c, REG_BITS_8},
	{0xA160, 0x05, REG_BITS_8},
	{0xA161, 0x2f, REG_BITS_8},
	{0xA162, 0x58, REG_BITS_8},
	{0xA163, 0x41, REG_BITS_8},
	{0xA164, 0x4b, REG_BITS_8},
	{0xA165, 0x54, REG_BITS_8},
	{0xA166, 0xba, REG_BITS_8},
	{0xA167, 0xf2, REG_BITS_8},
	{0xA168, 0x14, REG_BITS_8},
	{0xA169, 0xad, REG_BITS_8},
	{0xA16A, 0x4c, REG_BITS_8},
	{0xA16B, 0xc5, REG_BITS_8},
	{0xA16C, 0x2b, REG_BITS_8},
	{0xA16D, 0x5e, REG_BITS_8},
	{0xA16E, 0x41, REG_BITS_8},
	{0xA16F, 0xcb, REG_BITS_8},
	{0xA170, 0x5a, REG_BITS_8},
	{0xA171, 0xea, REG_BITS_8},
	{0xA172, 0x02, REG_BITS_8},
	{0xA173, 0x16, REG_BITS_8},
	{0xA174, 0xb5, REG_BITS_8},
	{0xA175, 0x50, REG_BITS_8},
	{0xA176, 0x05, REG_BITS_8},
	{0xA177, 0x2d, REG_BITS_8},
	{0xA178, 0x51, REG_BITS_8},
	{0xA179, 0x19, REG_BITS_8},
	{0xA17A, 0x8b, REG_BITS_8},
	{0xA17B, 0x50, REG_BITS_8},
	{0xA17C, 0x9c, REG_BITS_8},
	{0xA17D, 0x62, REG_BITS_8},
	{0xA17E, 0x13, REG_BITS_8},
	{0xA17F, 0x9f, REG_BITS_8},
	{0xA180, 0xc8, REG_BITS_8},
	{0xA181, 0x04, REG_BITS_8},
	{0xA182, 0x27, REG_BITS_8},
	{0xA183, 0x39, REG_BITS_8},
	{0xA184, 0xe9, REG_BITS_8},
	{0xA185, 0x09, REG_BITS_8},
	{0xA186, 0x52, REG_BITS_8},
	{0xA187, 0x9c, REG_BITS_8},
	{0xA188, 0x92, REG_BITS_8},
	{0xA189, 0x95, REG_BITS_8},
	{0xA18A, 0xb1, REG_BITS_8},
	{0xA18B, 0x68, REG_BITS_8},
	{0xA18C, 0xc5, REG_BITS_8},
	{0xA18D, 0x2c, REG_BITS_8},
	{0xA18E, 0x48, REG_BITS_8},
	{0xA18F, 0xd9, REG_BITS_8},
	{0xA190, 0x0a, REG_BITS_8},
	{0xA191, 0x50, REG_BITS_8},
	{0xA192, 0x9e, REG_BITS_8},
	{0xA193, 0xb2, REG_BITS_8},
	{0xA194, 0x92, REG_BITS_8},
	{0xA195, 0x9a, REG_BITS_8},
	{0xA196, 0x60, REG_BITS_8},
	{0xA197, 0xc4, REG_BITS_8},
	{0xA198, 0x23, REG_BITS_8},
	{0xA199, 0x13, REG_BITS_8},
	{0xA19A, 0xa9, REG_BITS_8},
	{0xA19B, 0xc8, REG_BITS_8},
	{0xA19C, 0x46, REG_BITS_8},
	{0xA19D, 0x38, REG_BITS_8},
	{0xA19E, 0x22, REG_BITS_8},
	{0xA19F, 0x93, REG_BITS_8},
	{0xA1A0, 0x9a, REG_BITS_8},
	{0xA1A1, 0x20, REG_BITS_8},
	{0xA1A2, 0x25, REG_BITS_8},
	{0xA1A3, 0x2a, REG_BITS_8},
	{0xA1A4, 0x4f, REG_BITS_8},
	{0xA1A5, 0xd9, REG_BITS_8},
	{0xA1A6, 0x4a, REG_BITS_8},
	{0xA1A7, 0x4f, REG_BITS_8},
	{0xA1A8, 0x98, REG_BITS_8},
	{0xA1A9, 0x52, REG_BITS_8},
	{0xA1AA, 0x93, REG_BITS_8},
	{0xA1AB, 0xa0, REG_BITS_8},
	{0xA1AC, 0x74, REG_BITS_8},
	{0xA1AD, 0x64, REG_BITS_8},
	{0xA1AE, 0x24, REG_BITS_8},
	{0xA1AF, 0x08, REG_BITS_8},
	{0xA1B0, 0x51, REG_BITS_8},
	{0xA1B1, 0x48, REG_BITS_8},
	{0xA1B2, 0x40, REG_BITS_8},
	{0xA1B3, 0x02, REG_BITS_8},
	{0xA1B4, 0xa2, REG_BITS_8},
	{0xA1B5, 0x90, REG_BITS_8},
	{0xA1B6, 0x84, REG_BITS_8},
	{0xA1B7, 0x88, REG_BITS_8},
	{0xA1B8, 0x64, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x3d, REG_BITS_8},
	{0xA1BB, 0x21, REG_BITS_8},
	{0xA1BC, 0x8a, REG_BITS_8},
	{0xA1BD, 0x50, REG_BITS_8},
	{0xA1BE, 0x9c, REG_BITS_8},
	{0xA1BF, 0xe2, REG_BITS_8},
	{0xA1C0, 0x93, REG_BITS_8},
	{0xA1C1, 0xa5, REG_BITS_8},
	{0xA1C2, 0xd8, REG_BITS_8},
	{0xA1C3, 0xe4, REG_BITS_8},
	{0xA1C4, 0x27, REG_BITS_8},
	{0xA1C5, 0x1c, REG_BITS_8},
	{0xA1C6, 0xf9, REG_BITS_8},
	{0xA1C7, 0x08, REG_BITS_8},
	{0xA1C8, 0x41, REG_BITS_8},
	{0xA1C9, 0x0c, REG_BITS_8},
	{0xA1CA, 0xe2, REG_BITS_8},
	{0xA1CB, 0x0f, REG_BITS_8},
	{0xA1CC, 0x7f, REG_BITS_8},
	{0xA1CD, 0x14, REG_BITS_8},
	{0xA1CE, 0xa4, REG_BITS_8},
	{0xA1CF, 0x20, REG_BITS_8},
	{0xA1D0, 0x1e, REG_BITS_8},
	{0xA1D1, 0xf9, REG_BITS_8},
	{0xA1D2, 0x88, REG_BITS_8},
	{0xA1D3, 0x4e, REG_BITS_8},
	{0xA1D4, 0x80, REG_BITS_8},
	{0xA1D5, 0x12, REG_BITS_8},
	{0xA1D6, 0x94, REG_BITS_8},
	{0xA1D7, 0xa5, REG_BITS_8},
	{0xA1D8, 0x28, REG_BITS_8},
	{0xA1D9, 0xa5, REG_BITS_8},
	{0xA1DA, 0x2a, REG_BITS_8},
	{0xA1DB, 0x3f, REG_BITS_8},
	{0xA1DC, 0x41, REG_BITS_8},
	{0xA1DD, 0x8a, REG_BITS_8},
	{0xA1DE, 0x49, REG_BITS_8},
	{0xA1DF, 0x56, REG_BITS_8},
	{0xA1E0, 0x02, REG_BITS_8},
	{0xA1E1, 0x11, REG_BITS_8},
	{0xA1E2, 0x89, REG_BITS_8},
	{0xA1E3, 0x24, REG_BITS_8},
	{0xA1E4, 0x44, REG_BITS_8},
	{0xA1E5, 0x21, REG_BITS_8},
	{0xA1E6, 0x10, REG_BITS_8},
	{0xA1E7, 0x91, REG_BITS_8},
	{0xA1E8, 0xc8, REG_BITS_8},
	{0xA1E9, 0x49, REG_BITS_8},
	{0xA1EA, 0x56, REG_BITS_8},
	{0xA1EB, 0xe2, REG_BITS_8},
	{0xA1EC, 0x13, REG_BITS_8},
	{0xA1ED, 0xa4, REG_BITS_8},
	{0xA1EE, 0x18, REG_BITS_8},
	{0xA1EF, 0x85, REG_BITS_8},
	{0xA1F0, 0x2a, REG_BITS_8},
	{0xA1F1, 0x56, REG_BITS_8},
	{0xA1F2, 0xf9, REG_BITS_8},
	{0xA1F3, 0x0a, REG_BITS_8},
	{0xA1F4, 0x54, REG_BITS_8},
	{0xA1F5, 0xae, REG_BITS_8},
	{0xA1F6, 0xa2, REG_BITS_8},
	{0xA1F7, 0x93, REG_BITS_8},
	{0xA1F8, 0xa0, REG_BITS_8},
	{0xA1F9, 0xa8, REG_BITS_8},
	{0xA1FA, 0xc4, REG_BITS_8},
	{0xA1FB, 0x25, REG_BITS_8},
	{0xA1FC, 0x24, REG_BITS_8},
	{0xA1FD, 0x39, REG_BITS_8},
	{0xA1FE, 0x49, REG_BITS_8},
	{0xA1FF, 0x4a, REG_BITS_8},
	{0xA200, 0x5c, REG_BITS_8},
	{0xA201, 0x82, REG_BITS_8},
	{0xA202, 0x13, REG_BITS_8},
	{0xA203, 0xa1, REG_BITS_8},
	{0xA204, 0x2c, REG_BITS_8},
	{0xA205, 0x45, REG_BITS_8},
	{0xA206, 0x2b, REG_BITS_8},
	{0xA207, 0x4d, REG_BITS_8},
	{0xA208, 0x09, REG_BITS_8},
	{0xA209, 0x0b, REG_BITS_8},
	{0xA20A, 0x57, REG_BITS_8},
	{0xA20B, 0xd0, REG_BITS_8},
	{0xA20C, 0x22, REG_BITS_8},
	{0xA20D, 0x96, REG_BITS_8},
	{0xA20E, 0xb6, REG_BITS_8},
	{0xA20F, 0x48, REG_BITS_8},
	{0xA210, 0x45, REG_BITS_8},
	{0xA211, 0x2b, REG_BITS_8},
	{0xA212, 0x44, REG_BITS_8},
	{0xA213, 0x69, REG_BITS_8},
	{0xA214, 0x0a, REG_BITS_8},
	{0xA215, 0x50, REG_BITS_8},
	{0xA216, 0x90, REG_BITS_8},
	{0xA217, 0x32, REG_BITS_8},
	{0xA218, 0x14, REG_BITS_8},
	{0xA219, 0xa7, REG_BITS_8},
	{0xA21A, 0x30, REG_BITS_8},
	{0xA21B, 0x85, REG_BITS_8},
	{0xA21C, 0x2b, REG_BITS_8},
	{0xA21D, 0x5a, REG_BITS_8},
	{0xA21E, 0x81, REG_BITS_8},
	{0xA21F, 0x0b, REG_BITS_8},
	{0xA220, 0x54, REG_BITS_8},
	{0xA221, 0xd2, REG_BITS_8},
	{0xA222, 0x12, REG_BITS_8},
	{0xA223, 0x16, REG_BITS_8},
	{0xA224, 0xb6, REG_BITS_8},
	{0xA225, 0xa0, REG_BITS_8},
	{0xA226, 0x85, REG_BITS_8},
	{0xA227, 0x2e, REG_BITS_8},
	{0xA228, 0x65, REG_BITS_8},
	{0xA229, 0x89, REG_BITS_8},
	{0xA22A, 0x8b, REG_BITS_8},
	{0xA22B, 0x57, REG_BITS_8},
	{0xA22C, 0xd8, REG_BITS_8},
	{0xA22D, 0xc2, REG_BITS_8},
	{0xA22E, 0x15, REG_BITS_8},
	{0xA22F, 0xb5, REG_BITS_8},
	{0xA230, 0x78, REG_BITS_8},
	{0xA231, 0xc5, REG_BITS_8},
	{0xA232, 0x2d, REG_BITS_8},
	{0xA233, 0x5f, REG_BITS_8},
	{0xA234, 0xa9, REG_BITS_8},
	{0xA235, 0x0b, REG_BITS_8},
	{0xA236, 0x58, REG_BITS_8},
	{0xA237, 0xf4, REG_BITS_8},
	{0xA238, 0x62, REG_BITS_8},
	{0xA239, 0x15, REG_BITS_8},
	{0xA23A, 0xb8, REG_BITS_8},
	{0xA23B, 0x08, REG_BITS_8},
	{0xA23C, 0x65, REG_BITS_8},
	{0xA23D, 0x29, REG_BITS_8},
	{0xA23E, 0x57, REG_BITS_8},
	{0xA23F, 0x11, REG_BITS_8},
	{0xA240, 0x4b, REG_BITS_8},
	{0xA241, 0x56, REG_BITS_8},
	{0xA242, 0xcc, REG_BITS_8},
	{0xA243, 0x22, REG_BITS_8},
	{0xA244, 0x15, REG_BITS_8},
	{0xA245, 0xb0, REG_BITS_8},
	{0xA246, 0x48, REG_BITS_8},
	{0xA247, 0x45, REG_BITS_8},
	{0xA248, 0x2c, REG_BITS_8},
	{0xA249, 0x53, REG_BITS_8},
	{0xA24A, 0x21, REG_BITS_8},
	{0xA24B, 0x4b, REG_BITS_8},
	{0xA24C, 0x55, REG_BITS_8},
	{0xA24D, 0xd6, REG_BITS_8},
	{0xA24E, 0x22, REG_BITS_8},
	{0xA24F, 0x15, REG_BITS_8},
	{0xA250, 0xb5, REG_BITS_8},
	{0xA251, 0xec, REG_BITS_8},
	{0xA252, 0x64, REG_BITS_8},
	{0xA253, 0x2a, REG_BITS_8},
	{0xA254, 0x6d, REG_BITS_8},
	{0xA255, 0xc1, REG_BITS_8},
	{0xA256, 0x4c, REG_BITS_8},
	{0xA257, 0x67, REG_BITS_8},
	{0xA258, 0x30, REG_BITS_8},
	{0xA259, 0x93, REG_BITS_8},
	{0xA25A, 0x19, REG_BITS_8},
	{0xA25B, 0xcd, REG_BITS_8},
	{0xA25C, 0x78, REG_BITS_8},
	{0xA25D, 0xe6, REG_BITS_8},
	{0xA25E, 0x32, REG_BITS_8},
	{0xA25F, 0x6e, REG_BITS_8},
	{0xA260, 0x29, REG_BITS_8},
	{0xA261, 0x4d, REG_BITS_8},
	{0xA262, 0x6c, REG_BITS_8},
	{0xA263, 0x56, REG_BITS_8},
	{0xA264, 0x53, REG_BITS_8},
	{0xA265, 0x9a, REG_BITS_8},
	{0xA266, 0xd1, REG_BITS_8},
	{0xA267, 0x98, REG_BITS_8},
	{0xA268, 0x66, REG_BITS_8},
	{0xA269, 0x35, REG_BITS_8},
	{0xA26A, 0xb0, REG_BITS_8},
	{0xA26B, 0x19, REG_BITS_8},
	{0xA26C, 0x8d, REG_BITS_8},
	{0xA26D, 0x68, REG_BITS_8},
	{0xA26E, 0x46, REG_BITS_8},
	{0xA26F, 0x73, REG_BITS_8},
	{0xA270, 0x98, REG_BITS_8},
	{0xA271, 0xba, REG_BITS_8},
	{0xA272, 0xbc, REG_BITS_8},
	{0xA273, 0xa5, REG_BITS_8},
	{0xA274, 0x2e, REG_BITS_8},
	{0xA275, 0x88, REG_BITS_8},
	{0xA276, 0x19, REG_BITS_8},
	{0xA277, 0x8d, REG_BITS_8},
	{0xA278, 0x67, REG_BITS_8},
	{0xA279, 0x20, REG_BITS_8},
	{0xA27A, 0x03, REG_BITS_8},
	{0xA27B, 0x98, REG_BITS_8},
	{0xA27C, 0xae, REG_BITS_8},
	{0xA27D, 0x10, REG_BITS_8},
	{0xA27E, 0xa5, REG_BITS_8},
	{0xA27F, 0x27, REG_BITS_8},
	{0xA280, 0x45, REG_BITS_8},
	{0xA281, 0xe1, REG_BITS_8},
	{0xA282, 0x8a, REG_BITS_8},
	{0xA283, 0x5f, REG_BITS_8},
	{0xA284, 0x18, REG_BITS_8},
	{0xA285, 0x83, REG_BITS_8},
	{0xA286, 0x97, REG_BITS_8},
	{0xA287, 0xb0, REG_BITS_8},
	{0xA288, 0xe8, REG_BITS_8},
	{0xA289, 0xa4, REG_BITS_8},
	{0xA28A, 0x23, REG_BITS_8},
	{0xA28B, 0x14, REG_BITS_8},
	{0xA28C, 0xe1, REG_BITS_8},
	{0xA28D, 0x48, REG_BITS_8},
	{0xA28E, 0x4e, REG_BITS_8},
	{0xA28F, 0xc0, REG_BITS_8},
	{0xA290, 0x72, REG_BITS_8},
	{0xA291, 0x17, REG_BITS_8},
	{0xA292, 0xb3, REG_BITS_8},
	{0xA293, 0x40, REG_BITS_8},
	{0xA294, 0xc5, REG_BITS_8},
	{0xA295, 0x24, REG_BITS_8},
	{0xA296, 0x0a, REG_BITS_8},
	{0xA297, 0x09, REG_BITS_8},
	{0xA298, 0x08, REG_BITS_8},
	{0xA299, 0x42, REG_BITS_8},
	{0xA29A, 0x4c, REG_BITS_8},
	{0xA29B, 0x02, REG_BITS_8},
	{0xA29C, 0x15, REG_BITS_8},
	{0xA29D, 0xb3, REG_BITS_8},
	{0xA29E, 0x94, REG_BITS_8},
	{0xA29F, 0xc5, REG_BITS_8},
	{0xA2A0, 0x29, REG_BITS_8},
	{0xA2A1, 0x23, REG_BITS_8},
	{0xA2A2, 0x31, REG_BITS_8},
	{0xA2A3, 0x88, REG_BITS_8},
	{0xA2A4, 0x3f, REG_BITS_8},
	{0xA2A5, 0x0c, REG_BITS_8},
	{0xA2A6, 0x32, REG_BITS_8},
	{0xA2A7, 0x12, REG_BITS_8},
	{0xA2A8, 0xa7, REG_BITS_8},
	{0xA2A9, 0x94, REG_BITS_8},
	{0xA2AA, 0xc5, REG_BITS_8},
	{0xA2AB, 0x2e, REG_BITS_8},
	{0xA2AC, 0x5c, REG_BITS_8},
	{0xA2AD, 0x81, REG_BITS_8},
	{0xA2AE, 0xc9, REG_BITS_8},
	{0xA2AF, 0x44, REG_BITS_8},
	{0xA2B0, 0x16, REG_BITS_8},
	{0xA2B1, 0x32, REG_BITS_8},
	{0xA2B2, 0x11, REG_BITS_8},
	{0xA2B3, 0x98, REG_BITS_8},
	{0xA2B4, 0x68, REG_BITS_8},
	{0xA2B5, 0x45, REG_BITS_8},
	{0xA2B6, 0x2e, REG_BITS_8},
	{0xA2B7, 0x8a, REG_BITS_8},
	{0xA2B8, 0xb1, REG_BITS_8},
	{0xA2B9, 0x8b, REG_BITS_8},
	{0xA2BA, 0x53, REG_BITS_8},
	{0xA2BB, 0x6a, REG_BITS_8},
	{0xA2BC, 0xd2, REG_BITS_8},
	{0xA2BD, 0x12, REG_BITS_8},
	{0xA2BE, 0x9b, REG_BITS_8},
	{0xA2BF, 0x3c, REG_BITS_8},
	{0xA2C0, 0xc5, REG_BITS_8},
	{0xA2C1, 0x2e, REG_BITS_8},
	{0xA2C2, 0x89, REG_BITS_8},
	{0xA2C3, 0xe9, REG_BITS_8},
	{0xA2C4, 0xcc, REG_BITS_8},
	{0xA2C5, 0x66, REG_BITS_8},
	{0xA2C6, 0xf2, REG_BITS_8},
	{0xA2C7, 0x42, REG_BITS_8},
	{0xA2C8, 0x96, REG_BITS_8},
	{0xA2C9, 0xae, REG_BITS_8},
	{0xA2CA, 0x90, REG_BITS_8},
	{0xA2CB, 0x25, REG_BITS_8},
	{0xA2CC, 0x2f, REG_BITS_8},
	{0xA2CD, 0x9b, REG_BITS_8},
	{0xA2CE, 0xd9, REG_BITS_8},
	{0xA2CF, 0x4c, REG_BITS_8},
	{0xA2D0, 0x6a, REG_BITS_8},
	{0xA2D1, 0x60, REG_BITS_8},
	{0xA2D2, 0x53, REG_BITS_8},
	{0xA2D3, 0x1a, REG_BITS_8},
	{0xA2D4, 0xcc, REG_BITS_8},
	{0xA2D5, 0x50, REG_BITS_8},
	{0xA2D6, 0x06, REG_BITS_8},
	{0xA2D7, 0x33, REG_BITS_8},
	{0xA2D8, 0xa4, REG_BITS_8},
	{0xA2D9, 0x89, REG_BITS_8},
	{0xA2DA, 0x8d, REG_BITS_8},
	{0xA2DB, 0x6a, REG_BITS_8},
	{0xA2DC, 0x02, REG_BITS_8},
	{0xA2DD, 0xe3, REG_BITS_8},
	{0xA2DE, 0x19, REG_BITS_8},
	{0xA2DF, 0xcf, REG_BITS_8},
	{0xA2E0, 0x48, REG_BITS_8},
	{0xA2E1, 0x46, REG_BITS_8},
	{0xA2E2, 0x32, REG_BITS_8},
	{0xA2E3, 0x93, REG_BITS_8},
	{0xA2E4, 0xf1, REG_BITS_8},
	{0xA2E5, 0x8c, REG_BITS_8},
	{0xA2E6, 0x68, REG_BITS_8},
	{0xA2E7, 0x12, REG_BITS_8},
	{0xA2E8, 0x03, REG_BITS_8},
	{0xA2E9, 0x80, REG_BITS_8},
	{0xA2EA, 0x00, REG_BITS_8},
	{0xA2EB, 0x00, REG_BITS_8},
	{0xA2EC, 0x00, REG_BITS_8},
	{0xA2ED, 0x00, REG_BITS_8},
	{0xA2EE, 0x95, REG_BITS_8},
	{0xA2EF, 0x19, REG_BITS_8},
	{0xA2F0, 0xce, REG_BITS_8},
	{0xA2F1, 0x71, REG_BITS_8},
	{0xA2F2, 0x7c, REG_BITS_8},
	{0xA2F3, 0xe3, REG_BITS_8},
	{0xA2F4, 0x1b, REG_BITS_8},
	{0xA2F5, 0xdf, REG_BITS_8},
	{0xA2F6, 0x08, REG_BITS_8},
	{0xA2F7, 0x27, REG_BITS_8},
	{0xA2F8, 0x37, REG_BITS_8},
	{0xA2F9, 0x8b, REG_BITS_8},
	{0xA2FA, 0x99, REG_BITS_8},
	{0xA2FB, 0x4e, REG_BITS_8},
	{0xA2FC, 0x77, REG_BITS_8},
	{0xA2FD, 0xa8, REG_BITS_8},
	{0xA2FE, 0xb3, REG_BITS_8},
	{0xA2FF, 0x9c, REG_BITS_8},
	{0xA300, 0xe3, REG_BITS_8},
	{0xA301, 0x24, REG_BITS_8},
	{0xA302, 0xc7, REG_BITS_8},
	{0xA303, 0x39, REG_BITS_8},
	{0xA304, 0xd3, REG_BITS_8},
	{0xA305, 0x21, REG_BITS_8},
	{0xA306, 0x8e, REG_BITS_8},
	{0xA307, 0x72, REG_BITS_8},
	{0xA308, 0x96, REG_BITS_8},
	{0xA309, 0x83, REG_BITS_8},
	{0xA30A, 0x9a, REG_BITS_8},
	{0xA30B, 0xc9, REG_BITS_8},
	{0xA30C, 0x2c, REG_BITS_8},
	{0xA30D, 0x26, REG_BITS_8},
	{0xA30E, 0x32, REG_BITS_8},
	{0xA30F, 0xa5, REG_BITS_8},
	{0xA310, 0x11, REG_BITS_8},
	{0xA311, 0x4e, REG_BITS_8},
	{0xA312, 0x6f, REG_BITS_8},
	{0xA313, 0x6c, REG_BITS_8},
	{0xA314, 0x23, REG_BITS_8},
	{0xA315, 0x1a, REG_BITS_8},
	{0xA316, 0xbb, REG_BITS_8},
	{0xA317, 0x5c, REG_BITS_8},
	{0xA318, 0xa5, REG_BITS_8},
	{0xA319, 0x29, REG_BITS_8},
	{0xA31A, 0x56, REG_BITS_8},
	{0xA31B, 0x89, REG_BITS_8},
	{0xA31C, 0x4b, REG_BITS_8},
	{0xA31D, 0x66, REG_BITS_8},
	{0xA31E, 0x52, REG_BITS_8},
	{0xA31F, 0xc3, REG_BITS_8},
	{0xA320, 0x99, REG_BITS_8},
	{0xA321, 0xbe, REG_BITS_8},
	{0xA322, 0x2c, REG_BITS_8},
	{0xA323, 0xc5, REG_BITS_8},
	{0xA324, 0x24, REG_BITS_8},
	{0xA325, 0x1a, REG_BITS_8},
	{0xA326, 0x21, REG_BITS_8},
	{0xA327, 0xc9, REG_BITS_8},
	{0xA328, 0x51, REG_BITS_8},
	{0xA329, 0xec, REG_BITS_8},
	{0xA32A, 0x12, REG_BITS_8},
	{0xA32B, 0x99, REG_BITS_8},
	{0xA32C, 0xc2, REG_BITS_8},
	{0xA32D, 0xa0, REG_BITS_8},
	{0xA32E, 0x45, REG_BITS_8},
	{0xA32F, 0x26, REG_BITS_8},
	{0xA330, 0x0d, REG_BITS_8},
	{0xA331, 0x09, REG_BITS_8},
	{0xA332, 0xc8, REG_BITS_8},
	{0xA333, 0x42, REG_BITS_8},
	{0xA334, 0x5e, REG_BITS_8},
	{0xA335, 0x32, REG_BITS_8},
	{0xA336, 0x16, REG_BITS_8},
	{0xA337, 0xbf, REG_BITS_8},
	{0xA338, 0x0c, REG_BITS_8},
	{0xA339, 0xa6, REG_BITS_8},
	{0xA33A, 0x2c, REG_BITS_8},
	{0xA33B, 0x2d, REG_BITS_8},
	{0xA33C, 0x49, REG_BITS_8},
	{0xA33D, 0x88, REG_BITS_8},
	{0xA33E, 0x3f, REG_BITS_8},
	{0xA33F, 0x0e, REG_BITS_8},
	{0xA340, 0xb2, REG_BITS_8},
	{0xA341, 0x12, REG_BITS_8},
	{0xA342, 0xb0, REG_BITS_8},
	{0xA343, 0xf0, REG_BITS_8},
	{0xA344, 0xc5, REG_BITS_8},
	{0xA345, 0x32, REG_BITS_8},
	{0xA346, 0x75, REG_BITS_8},
	{0xA347, 0xf9, REG_BITS_8},
	{0xA348, 0x89, REG_BITS_8},
	{0xA349, 0x46, REG_BITS_8},
	{0xA34A, 0x1e, REG_BITS_8},
	{0xA34B, 0x92, REG_BITS_8},
	{0xA34C, 0x11, REG_BITS_8},
	{0xA34D, 0x9e, REG_BITS_8},
	{0xA34E, 0xb4, REG_BITS_8},
	{0xA34F, 0x45, REG_BITS_8},
	{0xA350, 0x31, REG_BITS_8},
	{0xA351, 0xae, REG_BITS_8},
	{0xA352, 0xa9, REG_BITS_8},
	{0xA353, 0x4c, REG_BITS_8},
	{0xA354, 0x59, REG_BITS_8},
	{0xA355, 0x8a, REG_BITS_8},
	{0xA356, 0xa2, REG_BITS_8},
	{0xA357, 0x13, REG_BITS_8},
	{0xA358, 0xa2, REG_BITS_8},
	{0xA359, 0x84, REG_BITS_8},
	{0xA35A, 0xa5, REG_BITS_8},
	{0xA35B, 0x31, REG_BITS_8},
	{0xA35C, 0xa2, REG_BITS_8},
	{0xA35D, 0x21, REG_BITS_8},
	{0xA35E, 0xce, REG_BITS_8},
	{0xA35F, 0x6f, REG_BITS_8},
	{0xA360, 0x2e, REG_BITS_8},
	{0xA361, 0xe3, REG_BITS_8},
	{0xA362, 0x17, REG_BITS_8},
	{0xA363, 0xba, REG_BITS_8},
	{0xA364, 0xf0, REG_BITS_8},
	{0xA365, 0x65, REG_BITS_8},
	{0xA366, 0x32, REG_BITS_8},
	{0xA367, 0xb7, REG_BITS_8},
	{0xA368, 0xb9, REG_BITS_8},
	{0xA369, 0x4d, REG_BITS_8},
	{0xA36A, 0x74, REG_BITS_8},
	{0xA36B, 0xb0, REG_BITS_8},
	{0xA36C, 0x93, REG_BITS_8},
	{0xA36D, 0x9c, REG_BITS_8},
	{0xA36E, 0xdc, REG_BITS_8},
	{0xA36F, 0xcc, REG_BITS_8},
	{0xA370, 0x06, REG_BITS_8},
	{0xA371, 0x37, REG_BITS_8},
	{0xA372, 0xc4, REG_BITS_8},
	{0xA373, 0x91, REG_BITS_8},
	{0xA374, 0x8e, REG_BITS_8},
	{0xA375, 0x72, REG_BITS_8},
	{0xA376, 0x4a, REG_BITS_8},
	{0xA377, 0x23, REG_BITS_8},
	{0xA378, 0x1c, REG_BITS_8},
	{0xA379, 0xe1, REG_BITS_8},
	{0xA37A, 0xd0, REG_BITS_8},
	{0xA37B, 0x46, REG_BITS_8},
	{0xA37C, 0x36, REG_BITS_8},
	{0xA37D, 0xb4, REG_BITS_8},
	{0xA37E, 0x01, REG_BITS_8},
	{0xA37F, 0xce, REG_BITS_8},
	{0xA380, 0x70, REG_BITS_8},
	{0xA381, 0x4e, REG_BITS_8},
	{0xA382, 0xf3, REG_BITS_8},
	{0xA383, 0x14, REG_BITS_8},
	{0xA384, 0xb7, REG_BITS_8},
	{0xA385, 0xc0, REG_BITS_8},
	{0xA386, 0x05, REG_BITS_8},
	{0xA387, 0x2d, REG_BITS_8},
	{0xA388, 0x4f, REG_BITS_8},
	{0xA389, 0x71, REG_BITS_8},
	{0xA38A, 0x0b, REG_BITS_8},
	{0xA38B, 0x5c, REG_BITS_8},
	{0xA38C, 0xd0, REG_BITS_8},
	{0xA38D, 0x62, REG_BITS_8},
	{0xA38E, 0x16, REG_BITS_8},
	{0xA38F, 0xb5, REG_BITS_8},
	{0xA390, 0xc4, REG_BITS_8},
	{0xA391, 0xc5, REG_BITS_8},
	{0xA392, 0x2d, REG_BITS_8},
	{0xA393, 0x4d, REG_BITS_8},
	{0xA394, 0xc1, REG_BITS_8},
	{0xA395, 0x8b, REG_BITS_8},
	{0xA396, 0x5f, REG_BITS_8},
	{0xA397, 0xf6, REG_BITS_8},
	{0xA398, 0x62, REG_BITS_8},
	{0xA399, 0x17, REG_BITS_8},
	{0xA39A, 0xb9, REG_BITS_8},
	{0xA39B, 0xe0, REG_BITS_8},
	{0xA39C, 0x85, REG_BITS_8},
	{0xA39D, 0x2f, REG_BITS_8},
	{0xA39E, 0x7f, REG_BITS_8},
	{0xA39F, 0x99, REG_BITS_8},
	{0xA3A0, 0xcb, REG_BITS_8},
	{0xA3A1, 0x5c, REG_BITS_8},
	{0xA3A2, 0xf0, REG_BITS_8},
	{0xA3A3, 0x72, REG_BITS_8},
	{0xA3A4, 0x16, REG_BITS_8},
	{0xA3A5, 0xae, REG_BITS_8},
	{0xA3A6, 0x5c, REG_BITS_8},
	{0xA3A7, 0x65, REG_BITS_8},
	{0xA3A8, 0x2b, REG_BITS_8},
	{0xA3A9, 0x68, REG_BITS_8},
	{0xA3AA, 0xc9, REG_BITS_8},
	{0xA3AB, 0x8b, REG_BITS_8},
	{0xA3AC, 0x5b, REG_BITS_8},
	{0xA3AD, 0xce, REG_BITS_8},
	{0xA3AE, 0x12, REG_BITS_8},
	{0xA3AF, 0x16, REG_BITS_8},
	{0xA3B0, 0xa6, REG_BITS_8},
	{0xA3B1, 0xf0, REG_BITS_8},
	{0xA3B2, 0xe4, REG_BITS_8},
	{0xA3B3, 0x26, REG_BITS_8},
	{0xA3B4, 0x3e, REG_BITS_8},
	{0xA3B5, 0x71, REG_BITS_8},
	{0xA3B6, 0x8a, REG_BITS_8},
	{0xA3B7, 0x58, REG_BITS_8},
	{0xA3B8, 0xc8, REG_BITS_8},
	{0xA3B9, 0x72, REG_BITS_8},
	{0xA3BA, 0x95, REG_BITS_8},
	{0xA3BB, 0xa5, REG_BITS_8},
	{0xA3BC, 0xc8, REG_BITS_8},
	{0xA3BD, 0x84, REG_BITS_8},
	{0xA3BE, 0x23, REG_BITS_8},
	{0xA3BF, 0x15, REG_BITS_8},
	{0xA3C0, 0xe9, REG_BITS_8},
	{0xA3C1, 0x48, REG_BITS_8},
	{0xA3C2, 0x4d, REG_BITS_8},
	{0xA3C3, 0x9c, REG_BITS_8},
	{0xA3C4, 0x52, REG_BITS_8},
	{0xA3C5, 0x95, REG_BITS_8},
	{0xA3C6, 0xa4, REG_BITS_8},
	{0xA3C7, 0x00, REG_BITS_8},
	{0xA3C8, 0x65, REG_BITS_8},
	{0xA3C9, 0x24, REG_BITS_8},
	{0xA3CA, 0x0b, REG_BITS_8},
	{0xA3CB, 0x11, REG_BITS_8},
	{0xA3CC, 0x48, REG_BITS_8},
	{0xA3CD, 0x42, REG_BITS_8},
	{0xA3CE, 0x46, REG_BITS_8},
	{0xA3CF, 0xf2, REG_BITS_8},
	{0xA3D0, 0x93, REG_BITS_8},
	{0xA3D1, 0xa3, REG_BITS_8},
	{0xA3D2, 0x30, REG_BITS_8},
	{0xA3D3, 0x25, REG_BITS_8},
	{0xA3D4, 0x28, REG_BITS_8},
	{0xA3D5, 0x22, REG_BITS_8},
	{0xA3D6, 0x31, REG_BITS_8},
	{0xA3D7, 0x48, REG_BITS_8},
	{0xA3D8, 0x3f, REG_BITS_8},
	{0xA3D9, 0x06, REG_BITS_8},
	{0xA3DA, 0xe2, REG_BITS_8},
	{0xA3DB, 0x91, REG_BITS_8},
	{0xA3DC, 0x9e, REG_BITS_8},
	{0xA3DD, 0x18, REG_BITS_8},
	{0xA3DE, 0x25, REG_BITS_8},
	{0xA3DF, 0x2b, REG_BITS_8},
	{0xA3E0, 0x4b, REG_BITS_8},
	{0xA3E1, 0x69, REG_BITS_8},
	{0xA3E2, 0x89, REG_BITS_8},
	{0xA3E3, 0x44, REG_BITS_8},
	{0xA3E4, 0x10, REG_BITS_8},
	{0xA3E5, 0xe2, REG_BITS_8},
	{0xA3E6, 0x10, REG_BITS_8},
	{0xA3E7, 0x93, REG_BITS_8},
	{0xA3E8, 0x00, REG_BITS_8},
	{0xA3E9, 0x45, REG_BITS_8},
	{0xA3EA, 0x29, REG_BITS_8},
	{0xA3EB, 0x67, REG_BITS_8},
	{0xA3EC, 0xe9, REG_BITS_8},
	{0xA3ED, 0x8a, REG_BITS_8},
	{0xA3EE, 0x50, REG_BITS_8},
	{0xA3EF, 0x5c, REG_BITS_8},
	{0xA3F0, 0x42, REG_BITS_8},
	{0xA3F1, 0x12, REG_BITS_8},
	{0xA3F2, 0x94, REG_BITS_8},
	{0xA3F3, 0xe0, REG_BITS_8},
	{0xA3F4, 0xc4, REG_BITS_8},
	{0xA3F5, 0x29, REG_BITS_8},
	{0xA3F6, 0x52, REG_BITS_8},
	{0xA3F7, 0x71, REG_BITS_8},
	{0xA3F8, 0x4b, REG_BITS_8},
	{0xA3F9, 0x5c, REG_BITS_8},
	{0xA3FA, 0xb8, REG_BITS_8},
	{0xA3FB, 0x92, REG_BITS_8},
	{0xA3FC, 0x14, REG_BITS_8},
	{0xA3FD, 0xa1, REG_BITS_8},
	{0xA3FE, 0x14, REG_BITS_8},
	{0xA3FF, 0x05, REG_BITS_8},
	{0xA400, 0x2a, REG_BITS_8},
	{0xA401, 0x60, REG_BITS_8},
	{0xA402, 0xc1, REG_BITS_8},
	{0xA403, 0x4a, REG_BITS_8},
	{0xA404, 0x5d, REG_BITS_8},
	{0xA405, 0xf4, REG_BITS_8},
	{0xA406, 0x22, REG_BITS_8},
	{0xA407, 0x97, REG_BITS_8},
	{0xA408, 0xb3, REG_BITS_8},
	{0xA409, 0x90, REG_BITS_8},
	{0xA40A, 0xc5, REG_BITS_8},
	{0xA40B, 0x2c, REG_BITS_8},
	{0xA40C, 0x68, REG_BITS_8},
	{0xA40D, 0x61, REG_BITS_8},
	{0xA40E, 0xcb, REG_BITS_8},
	{0xA40F, 0x58, REG_BITS_8},
	{0xA410, 0xae, REG_BITS_8},
	{0xA411, 0xb2, REG_BITS_8},
	{0xA412, 0x96, REG_BITS_8},
	{0xA413, 0xb4, REG_BITS_8},
	{0xA414, 0x70, REG_BITS_8},
	{0xA415, 0xa5, REG_BITS_8},
	{0xA416, 0x2b, REG_BITS_8},
	{0xA417, 0x5e, REG_BITS_8},
	{0xA418, 0x11, REG_BITS_8},
	{0xA419, 0x4b, REG_BITS_8},
	{0xA41A, 0x58, REG_BITS_8},
	{0xA41B, 0x96, REG_BITS_8},
	{0xA41C, 0x02, REG_BITS_8},
	{0xA41D, 0x00, REG_BITS_8},
	{0xA41E, 0x00, REG_BITS_8},
	{0xA41F, 0x00, REG_BITS_8},
	{0xA420, 0x00, REG_BITS_8},
	{0xA421, 0x0a, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_SHD_2_ES2 = sizeof(seix006_vendor_1_SHD_2_ES2);

const struct reg_entry seix006_vendor_1_SHD_3_ES2[] = {
	{0x0068, 0x50, REG_BITS_8},
	{0x9000, 0x8282, REG_BITS_16},
	{0x9002, 0xfe, REG_BITS_8},
	{0x9003, 0x11, REG_BITS_8},
	{0x9004, 0xf8, REG_BITS_8},
	{0x9005, 0x47, REG_BITS_8},
	{0x9006, 0x00, REG_BITS_8},
	{0x9007, 0x20, REG_BITS_8},
	{0x9008, 0x81, REG_BITS_8},
	{0x9009, 0x80, REG_BITS_8},
	{0x900A, 0x04, REG_BITS_8},
	{0x900B, 0x00, REG_BITS_8},
	{0x900C, 0x10, REG_BITS_8},
	{0x900D, 0x04, REG_BITS_8},
	{0x900E, 0x48, REG_BITS_8},
	{0x900F, 0x10, REG_BITS_8},
	{0x9010, 0x40, REG_BITS_8},
	{0x9011, 0x41, REG_BITS_8},
	{0x9012, 0x80, REG_BITS_8},
	{0x9013, 0x05, REG_BITS_8},
	{0x9014, 0x01, REG_BITS_8},
	{0x9015, 0x16, REG_BITS_8},
	{0x9016, 0xf8, REG_BITS_8},
	{0x9017, 0x47, REG_BITS_8},
	{0x9018, 0xe0, REG_BITS_8},
	{0x9019, 0x1f, REG_BITS_8},
	{0x901A, 0x01, REG_BITS_8},
	{0x901B, 0x80, REG_BITS_8},
	{0x901C, 0x04, REG_BITS_8},
	{0x901D, 0x02, REG_BITS_8},
	{0x901E, 0x12, REG_BITS_8},
	{0x901F, 0x00, REG_BITS_8},
	{0x9020, 0x40, REG_BITS_8},
	{0x9021, 0x10, REG_BITS_8},
	{0x9022, 0x20, REG_BITS_8},
	{0x9023, 0x41, REG_BITS_8},
	{0x9024, 0x00, REG_BITS_8},
	{0x9025, 0x05, REG_BITS_8},
	{0x9026, 0x01, REG_BITS_8},
	{0x9027, 0x16, REG_BITS_8},
	{0x9028, 0x04, REG_BITS_8},
	{0x9029, 0x58, REG_BITS_8},
	{0x902A, 0x20, REG_BITS_8},
	{0x902B, 0x00, REG_BITS_8},
	{0x902C, 0x81, REG_BITS_8},
	{0x902D, 0x00, REG_BITS_8},
	{0x902E, 0x04, REG_BITS_8},
	{0x902F, 0x01, REG_BITS_8},
	{0x9030, 0x12, REG_BITS_8},
	{0x9031, 0x08, REG_BITS_8},
	{0x9032, 0x38, REG_BITS_8},
	{0x9033, 0x10, REG_BITS_8},
	{0x9034, 0x00, REG_BITS_8},
	{0x9035, 0x81, REG_BITS_8},
	{0x9036, 0x80, REG_BITS_8},
	{0x9037, 0x04, REG_BITS_8},
	{0x9038, 0x01, REG_BITS_8},
	{0x9039, 0x12, REG_BITS_8},
	{0x903A, 0x04, REG_BITS_8},
	{0x903B, 0x50, REG_BITS_8},
	{0x903C, 0x10, REG_BITS_8},
	{0x903D, 0x40, REG_BITS_8},
	{0x903E, 0x81, REG_BITS_8},
	{0x903F, 0x80, REG_BITS_8},
	{0x9040, 0x03, REG_BITS_8},
	{0x9041, 0x02, REG_BITS_8},
	{0x9042, 0x0e, REG_BITS_8},
	{0x9043, 0x00, REG_BITS_8},
	{0x9044, 0x28, REG_BITS_8},
	{0x9045, 0x20, REG_BITS_8},
	{0x9046, 0x80, REG_BITS_8},
	{0x9047, 0x40, REG_BITS_8},
	{0x9048, 0x00, REG_BITS_8},
	{0x9049, 0x02, REG_BITS_8},
	{0x904A, 0x02, REG_BITS_8},
	{0x904B, 0x08, REG_BITS_8},
	{0x904C, 0x04, REG_BITS_8},
	{0x904D, 0x30, REG_BITS_8},
	{0x904E, 0x20, REG_BITS_8},
	{0x904F, 0x20, REG_BITS_8},
	{0x9050, 0x81, REG_BITS_8},
	{0x9051, 0x80, REG_BITS_8},
	{0x9052, 0x04, REG_BITS_8},
	{0x9053, 0x03, REG_BITS_8},
	{0x9054, 0x0a, REG_BITS_8},
	{0x9055, 0x0c, REG_BITS_8},
	{0x9056, 0x28, REG_BITS_8},
	{0x9057, 0x30, REG_BITS_8},
	{0x9058, 0x60, REG_BITS_8},
	{0x9059, 0x80, REG_BITS_8},
	{0x905A, 0x00, REG_BITS_8},
	{0x905B, 0x01, REG_BITS_8},
	{0x905C, 0x03, REG_BITS_8},
	{0x905D, 0x02, REG_BITS_8},
	{0x905E, 0x08, REG_BITS_8},
	{0x905F, 0x08, REG_BITS_8},
	{0x9060, 0x00, REG_BITS_8},
	{0x9061, 0xa0, REG_BITS_8},
	{0x9062, 0x80, REG_BITS_8},
	{0x9063, 0x80, REG_BITS_8},
	{0x9064, 0x02, REG_BITS_8},
	{0x9065, 0x02, REG_BITS_8},
	{0x9066, 0x0a, REG_BITS_8},
	{0x9067, 0x0c, REG_BITS_8},
	{0x9068, 0x18, REG_BITS_8},
	{0x9069, 0x30, REG_BITS_8},
	{0x906A, 0x60, REG_BITS_8},
	{0x906B, 0x40, REG_BITS_8},
	{0x906C, 0x81, REG_BITS_8},
	{0x906D, 0x00, REG_BITS_8},
	{0x906E, 0x02, REG_BITS_8},
	{0x906F, 0x02, REG_BITS_8},
	{0x9070, 0x00, REG_BITS_8},
	{0x9071, 0xf8, REG_BITS_8},
	{0x9072, 0x2f, REG_BITS_8},
	{0x9073, 0x40, REG_BITS_8},
	{0x9074, 0xc0, REG_BITS_8},
	{0x9075, 0x00, REG_BITS_8},
	{0x9076, 0x01, REG_BITS_8},
	{0x9077, 0x03, REG_BITS_8},
	{0x9078, 0x0c, REG_BITS_8},
	{0x9079, 0x0c, REG_BITS_8},
	{0x907A, 0x30, REG_BITS_8},
	{0x907B, 0x10, REG_BITS_8},
	{0x907C, 0x60, REG_BITS_8},
	{0x907D, 0x40, REG_BITS_8},
	{0x907E, 0x80, REG_BITS_8},
	{0x907F, 0x01, REG_BITS_8},
	{0x9080, 0x01, REG_BITS_8},
	{0x9081, 0x04, REG_BITS_8},
	{0x9082, 0x08, REG_BITS_8},
	{0x9083, 0xf8, REG_BITS_8},
	{0x9084, 0x0f, REG_BITS_8},
	{0x9085, 0x00, REG_BITS_8},
	{0x9086, 0x40, REG_BITS_8},
	{0x9087, 0x00, REG_BITS_8},
	{0x9088, 0x00, REG_BITS_8},
	{0x9089, 0x02, REG_BITS_8},
	{0x908A, 0x04, REG_BITS_8},
	{0x908B, 0x0c, REG_BITS_8},
	{0x908C, 0x20, REG_BITS_8},
	{0x908D, 0x30, REG_BITS_8},
	{0x908E, 0x80, REG_BITS_8},
	{0x908F, 0xc0, REG_BITS_8},
	{0x9090, 0x80, REG_BITS_8},
	{0x9091, 0x01, REG_BITS_8},
	{0x9092, 0x03, REG_BITS_8},
	{0x9093, 0x06, REG_BITS_8},
	{0x9094, 0x0c, REG_BITS_8},
	{0x9095, 0x00, REG_BITS_8},
	{0x9096, 0x20, REG_BITS_8},
	{0x9097, 0x20, REG_BITS_8},
	{0x9098, 0x00, REG_BITS_8},
	{0x9099, 0x81, REG_BITS_8},
	{0x909A, 0xff, REG_BITS_8},
	{0x909B, 0x03, REG_BITS_8},
	{0x909C, 0x00, REG_BITS_8},
	{0x909D, 0x10, REG_BITS_8},
	{0x909E, 0x00, REG_BITS_8},
	{0x909F, 0x10, REG_BITS_8},
	{0x90A0, 0x80, REG_BITS_8},
	{0x90A1, 0x40, REG_BITS_8},
	{0x90A2, 0x00, REG_BITS_8},
	{0x90A3, 0x02, REG_BITS_8},
	{0x90A4, 0x03, REG_BITS_8},
	{0x90A5, 0x08, REG_BITS_8},
	{0x90A6, 0x0c, REG_BITS_8},
	{0x90A7, 0x20, REG_BITS_8},
	{0x90A8, 0x20, REG_BITS_8},
	{0x90A9, 0x60, REG_BITS_8},
	{0x90AA, 0xc0, REG_BITS_8},
	{0x90AB, 0x80, REG_BITS_8},
	{0x90AC, 0x01, REG_BITS_8},
	{0x90AD, 0x03, REG_BITS_8},
	{0x90AE, 0x02, REG_BITS_8},
	{0x90AF, 0x0c, REG_BITS_8},
	{0x90B0, 0x10, REG_BITS_8},
	{0x90B1, 0x30, REG_BITS_8},
	{0x90B2, 0x60, REG_BITS_8},
	{0x90B3, 0xc0, REG_BITS_8},
	{0x90B4, 0x80, REG_BITS_8},
	{0x90B5, 0x02, REG_BITS_8},
	{0x90B6, 0x03, REG_BITS_8},
	{0x90B7, 0x0a, REG_BITS_8},
	{0x90B8, 0x08, REG_BITS_8},
	{0x90B9, 0x20, REG_BITS_8},
	{0x90BA, 0x20, REG_BITS_8},
	{0x90BB, 0x80, REG_BITS_8},
	{0x90BC, 0x00, REG_BITS_8},
	{0x90BD, 0x01, REG_BITS_8},
	{0x90BE, 0x02, REG_BITS_8},
	{0x90BF, 0x04, REG_BITS_8},
	{0x90C0, 0x06, REG_BITS_8},
	{0x90C1, 0x10, REG_BITS_8},
	{0x90C2, 0x18, REG_BITS_8},
	{0x90C3, 0x30, REG_BITS_8},
	{0x90C4, 0x60, REG_BITS_8},
	{0x90C5, 0x80, REG_BITS_8},
	{0x90C6, 0x00, REG_BITS_8},
	{0x90C7, 0x02, REG_BITS_8},
	{0x90C8, 0x04, REG_BITS_8},
	{0x90C9, 0x0a, REG_BITS_8},
	{0x90CA, 0x10, REG_BITS_8},
	{0x90CB, 0x28, REG_BITS_8},
	{0x90CC, 0x50, REG_BITS_8},
	{0x90CD, 0xc0, REG_BITS_8},
	{0x90CE, 0x40, REG_BITS_8},
	{0x90CF, 0x01, REG_BITS_8},
	{0x90D0, 0x03, REG_BITS_8},
	{0x90D1, 0x05, REG_BITS_8},
	{0x90D2, 0x08, REG_BITS_8},
	{0x90D3, 0x08, REG_BITS_8},
	{0x90D4, 0x30, REG_BITS_8},
	{0x90D5, 0x40, REG_BITS_8},
	{0x90D6, 0xe0, REG_BITS_8},
	{0x90D7, 0x40, REG_BITS_8},
	{0x90D8, 0x81, REG_BITS_8},
	{0x90D9, 0x03, REG_BITS_8},
	{0x90DA, 0x04, REG_BITS_8},
	{0x90DB, 0x0a, REG_BITS_8},
	{0x90DC, 0x0c, REG_BITS_8},
	{0x90DD, 0x30, REG_BITS_8},
	{0x90DE, 0x30, REG_BITS_8},
	{0x90DF, 0xc0, REG_BITS_8},
	{0x90E0, 0x40, REG_BITS_8},
	{0x90E1, 0x01, REG_BITS_8},
	{0x90E2, 0x03, REG_BITS_8},
	{0x90E3, 0x05, REG_BITS_8},
	{0x90E4, 0x0c, REG_BITS_8},
	{0x90E5, 0x14, REG_BITS_8},
	{0x90E6, 0x20, REG_BITS_8},
	{0x90E7, 0x20, REG_BITS_8},
	{0x90E8, 0xc0, REG_BITS_8},
	{0x90E9, 0x00, REG_BITS_8},
	{0x90EA, 0x81, REG_BITS_8},
	{0x90EB, 0x03, REG_BITS_8},
	{0x90EC, 0x05, REG_BITS_8},
	{0x90ED, 0x0e, REG_BITS_8},
	{0x90EE, 0x10, REG_BITS_8},
	{0x90EF, 0x28, REG_BITS_8},
	{0x90F0, 0x30, REG_BITS_8},
	{0x90F1, 0xc0, REG_BITS_8},
	{0x90F2, 0xc0, REG_BITS_8},
	{0x90F3, 0x00, REG_BITS_8},
	{0x90F4, 0x03, REG_BITS_8},
	{0x90F5, 0x01, REG_BITS_8},
	{0x90F6, 0xe6, REG_BITS_8},
	{0x90F7, 0x07, REG_BITS_8},
	{0x90F8, 0x98, REG_BITS_8},
	{0x90F9, 0x1f, REG_BITS_8},
	{0x90FA, 0x40, REG_BITS_8},
	{0x90FB, 0x7e, REG_BITS_8},
	{0x90FC, 0x80, REG_BITS_8},
	{0x90FD, 0xfa, REG_BITS_8},
	{0x90FE, 0x01, REG_BITS_8},
	{0x90FF, 0xe2, REG_BITS_8},
	{0x9100, 0x03, REG_BITS_8},
	{0x9101, 0xc0, REG_BITS_8},
	{0x9102, 0x0f, REG_BITS_8},
	{0x9103, 0x80, REG_BITS_8},
	{0x9104, 0x7e, REG_BITS_8},
	{0x9105, 0x80, REG_BITS_8},
	{0x9106, 0xfb, REG_BITS_8},
	{0x9107, 0x01, REG_BITS_8},
	{0x9108, 0xee, REG_BITS_8},
	{0x9109, 0x07, REG_BITS_8},
	{0x910A, 0x98, REG_BITS_8},
	{0x910B, 0x1f, REG_BITS_8},
	{0x910C, 0x60, REG_BITS_8},
	{0x910D, 0x7e, REG_BITS_8},
	{0x910E, 0x00, REG_BITS_8},
	{0x910F, 0xf9, REG_BITS_8},
	{0x9110, 0x01, REG_BITS_8},
	{0x9111, 0xea, REG_BITS_8},
	{0x9112, 0x07, REG_BITS_8},
	{0x9113, 0x88, REG_BITS_8},
	{0x9114, 0x0f, REG_BITS_8},
	{0x9115, 0x00, REG_BITS_8},
	{0x9116, 0x3f, REG_BITS_8},
	{0x9117, 0x00, REG_BITS_8},
	{0x9118, 0xfa, REG_BITS_8},
	{0x9119, 0x01, REG_BITS_8},
	{0x911A, 0xee, REG_BITS_8},
	{0x911B, 0x07, REG_BITS_8},
	{0x911C, 0xb8, REG_BITS_8},
	{0x911D, 0x3f, REG_BITS_8},
	{0x911E, 0x80, REG_BITS_8},
	{0x911F, 0xfe, REG_BITS_8},
	{0x9120, 0x00, REG_BITS_8},
	{0x9121, 0xfa, REG_BITS_8},
	{0x9122, 0x01, REG_BITS_8},
	{0x9123, 0xdc, REG_BITS_8},
	{0x9124, 0x03, REG_BITS_8},
	{0x9125, 0xa8, REG_BITS_8},
	{0x9126, 0x2f, REG_BITS_8},
	{0x9127, 0x00, REG_BITS_8},
	{0x9128, 0x7f, REG_BITS_8},
	{0x9129, 0x00, REG_BITS_8},
	{0x912A, 0xfb, REG_BITS_8},
	{0x912B, 0x03, REG_BITS_8},
	{0x912C, 0xee, REG_BITS_8},
	{0x912D, 0x07, REG_BITS_8},
	{0x912E, 0xc8, REG_BITS_8},
	{0x912F, 0x1f, REG_BITS_8},
	{0x9130, 0x20, REG_BITS_8},
	{0x9131, 0xff, REG_BITS_8},
	{0x9132, 0x00, REG_BITS_8},
	{0x9133, 0xfa, REG_BITS_8},
	{0x9134, 0x03, REG_BITS_8},
	{0x9135, 0xe8, REG_BITS_8},
	{0x9136, 0x03, REG_BITS_8},
	{0x9137, 0xa0, REG_BITS_8},
	{0x9138, 0x3f, REG_BITS_8},
	{0x9139, 0xc0, REG_BITS_8},
	{0x913A, 0xfe, REG_BITS_8},
	{0x913B, 0xff, REG_BITS_8},
	{0x913C, 0xfb, REG_BITS_8},
	{0x913D, 0xff, REG_BITS_8},
	{0x913E, 0xf1, REG_BITS_8},
	{0x913F, 0x03, REG_BITS_8},
	{0x9140, 0xb8, REG_BITS_8},
	{0x9141, 0x0f, REG_BITS_8},
	{0x9142, 0xc0, REG_BITS_8},
	{0x9143, 0x3e, REG_BITS_8},
	{0x9144, 0x00, REG_BITS_8},
	{0x9145, 0xfb, REG_BITS_8},
	{0x9146, 0x03, REG_BITS_8},
	{0x9147, 0xe6, REG_BITS_8},
	{0x9148, 0x0f, REG_BITS_8},
	{0x9149, 0x98, REG_BITS_8},
	{0x914A, 0x1f, REG_BITS_8},
	{0x914B, 0x00, REG_BITS_8},
	{0x914C, 0xff, REG_BITS_8},
	{0x914D, 0x7f, REG_BITS_8},
	{0x914E, 0xfc, REG_BITS_8},
	{0x914F, 0xff, REG_BITS_8},
	{0x9150, 0xf3, REG_BITS_8},
	{0x9151, 0xfb, REG_BITS_8},
	{0x9152, 0xc7, REG_BITS_8},
	{0x9153, 0xdf, REG_BITS_8},
	{0x9154, 0x1f, REG_BITS_8},
	{0x9155, 0xff, REG_BITS_8},
	{0x9156, 0xff, REG_BITS_8},
	{0x9157, 0xfb, REG_BITS_8},
	{0x9158, 0xff, REG_BITS_8},
	{0x9159, 0xef, REG_BITS_8},
	{0x915A, 0x0f, REG_BITS_8},
	{0x915B, 0xc0, REG_BITS_8},
	{0x915C, 0x3f, REG_BITS_8},
	{0x915D, 0x00, REG_BITS_8},
	{0x915E, 0x7f, REG_BITS_8},
	{0x915F, 0x80, REG_BITS_8},
	{0x9160, 0xfc, REG_BITS_8},
	{0x9161, 0xff, REG_BITS_8},
	{0x9162, 0xf7, REG_BITS_8},
	{0x9163, 0xff, REG_BITS_8},
	{0x9164, 0xc7, REG_BITS_8},
	{0x9165, 0xef, REG_BITS_8},
	{0x9166, 0x5f, REG_BITS_8},
	{0x9167, 0xbf, REG_BITS_8},
	{0x9168, 0xff, REG_BITS_8},
	{0x9169, 0xfd, REG_BITS_8},
	{0x916A, 0x00, REG_BITS_8},
	{0x916B, 0xfc, REG_BITS_8},
	{0x916C, 0x03, REG_BITS_8},
	{0x916D, 0xf0, REG_BITS_8},
	{0x916E, 0x4f, REG_BITS_8},
	{0x916F, 0x60, REG_BITS_8},
	{0x9170, 0x3f, REG_BITS_8},
	{0x9171, 0x81, REG_BITS_8},
	{0x9172, 0xfd, REG_BITS_8},
	{0x9173, 0x03, REG_BITS_8},
	{0x9174, 0xfc, REG_BITS_8},
	{0x9175, 0xff, REG_BITS_8},
	{0x9176, 0xef, REG_BITS_8},
	{0x9177, 0x0f, REG_BITS_8},
	{0x9178, 0x00, REG_BITS_8},
	{0x9179, 0x00, REG_BITS_8},
	{0x917A, 0x80, REG_BITS_8},
	{0x917B, 0xfe, REG_BITS_8},
	{0x917C, 0xff, REG_BITS_8},
	{0x917D, 0xfd, REG_BITS_8},
	{0x917E, 0x07, REG_BITS_8},
	{0x917F, 0x08, REG_BITS_8},
	{0x9180, 0x10, REG_BITS_8},
	{0x9181, 0x20, REG_BITS_8},
	{0x9182, 0x80, REG_BITS_8},
	{0x9183, 0x01, REG_BITS_8},
	{0x9184, 0x00, REG_BITS_8},
	{0x9185, 0x06, REG_BITS_8},
	{0x9186, 0x00, REG_BITS_8},
	{0x9187, 0x10, REG_BITS_8},
	{0x9188, 0x08, REG_BITS_8},
	{0x9189, 0x30, REG_BITS_8},
	{0x918A, 0x20, REG_BITS_8},
	{0x918B, 0x00, REG_BITS_8},
	{0x918C, 0x80, REG_BITS_8},
	{0x918D, 0x01, REG_BITS_8},
	{0x918E, 0x02, REG_BITS_8},
	{0x918F, 0x04, REG_BITS_8},
	{0x9190, 0x00, REG_BITS_8},
	{0x9191, 0x28, REG_BITS_8},
	{0x9192, 0x20, REG_BITS_8},
	{0x9193, 0x00, REG_BITS_8},
	{0x9194, 0x80, REG_BITS_8},
	{0x9195, 0x00, REG_BITS_8},
	{0x9196, 0x00, REG_BITS_8},
	{0x9197, 0x06, REG_BITS_8},
	{0x9198, 0x00, REG_BITS_8},
	{0x9199, 0x18, REG_BITS_8},
	{0x919A, 0x00, REG_BITS_8},
	{0x919B, 0x40, REG_BITS_8},
	{0x919C, 0x40, REG_BITS_8},
	{0x919D, 0x40, REG_BITS_8},
	{0x919E, 0x01, REG_BITS_8},
	{0x919F, 0x02, REG_BITS_8},
	{0x91A0, 0x02, REG_BITS_8},
	{0x91A1, 0x0a, REG_BITS_8},
	{0x91A2, 0x08, REG_BITS_8},
	{0x91A3, 0x38, REG_BITS_8},
	{0x91A4, 0x30, REG_BITS_8},
	{0x91A5, 0xa0, REG_BITS_8},
	{0x91A6, 0x40, REG_BITS_8},
	{0x91A7, 0x01, REG_BITS_8},
	{0x91A8, 0x03, REG_BITS_8},
	{0x91A9, 0x05, REG_BITS_8},
	{0x91AA, 0x0c, REG_BITS_8},
	{0x91AB, 0x1c, REG_BITS_8},
	{0x91AC, 0x18, REG_BITS_8},
	{0x91AD, 0x70, REG_BITS_8},
	{0x91AE, 0x60, REG_BITS_8},
	{0x91AF, 0xc0, REG_BITS_8},
	{0x91B0, 0x01, REG_BITS_8},
	{0x91B1, 0x04, REG_BITS_8},
	{0x91B2, 0x06, REG_BITS_8},
	{0x91B3, 0x0c, REG_BITS_8},
	{0x91B4, 0x0c, REG_BITS_8},
	{0x91B5, 0x28, REG_BITS_8},
	{0x91B6, 0x50, REG_BITS_8},
	{0x91B7, 0x20, REG_BITS_8},
	{0x91B8, 0x81, REG_BITS_8},
	{0x91B9, 0x01, REG_BITS_8},
	{0x91BA, 0x05, REG_BITS_8},
	{0x91BB, 0x04, REG_BITS_8},
	{0x91BC, 0x0e, REG_BITS_8},
	{0x91BD, 0x10, REG_BITS_8},
	{0x91BE, 0x38, REG_BITS_8},
	{0x91BF, 0x70, REG_BITS_8},
	{0x91C0, 0x60, REG_BITS_8},
	{0x91C1, 0xc0, REG_BITS_8},
	{0x91C2, 0x81, REG_BITS_8},
	{0x91C3, 0x01, REG_BITS_8},
	{0x91C4, 0x07, REG_BITS_8},
	{0x91C5, 0x0c, REG_BITS_8},
	{0x91C6, 0x1c, REG_BITS_8},
	{0x91C7, 0x28, REG_BITS_8},
	{0x91C8, 0x60, REG_BITS_8},
	{0x91C9, 0x40, REG_BITS_8},
	{0x91CA, 0x01, REG_BITS_8},
	{0x91CB, 0x01, REG_BITS_8},
	{0x91CC, 0x03, REG_BITS_8},
	{0x91CD, 0x04, REG_BITS_8},
	{0x91CE, 0x10, REG_BITS_8},
	{0x91CF, 0x10, REG_BITS_8},
	{0x91D0, 0x48, REG_BITS_8},
	{0x91D1, 0x40, REG_BITS_8},
	{0x91D2, 0x20, REG_BITS_8},
	{0x91D3, 0xc1, REG_BITS_8},
	{0x91D4, 0x81, REG_BITS_8},
	{0x91D5, 0x01, REG_BITS_8},
	{0x91D6, 0x07, REG_BITS_8},
	{0x91D7, 0x06, REG_BITS_8},
	{0x91D8, 0x1c, REG_BITS_8},
	{0x91D9, 0x30, REG_BITS_8},
	{0x91DA, 0x70, REG_BITS_8},
	{0x91DB, 0xa0, REG_BITS_8},
	{0x91DC, 0x80, REG_BITS_8},
	{0x91DD, 0x01, REG_BITS_8},
	{0x91DE, 0x05, REG_BITS_8},
	{0x91DF, 0x04, REG_BITS_8},
	{0x91E0, 0x0c, REG_BITS_8},
	{0x91E1, 0x10, REG_BITS_8},
	{0x91E2, 0x40, REG_BITS_8},
	{0x91E3, 0x40, REG_BITS_8},
	{0x91E4, 0x20, REG_BITS_8},
	{0x91E5, 0x01, REG_BITS_8},
	{0x91E6, 0x81, REG_BITS_8},
	{0x91E7, 0x04, REG_BITS_8},
	{0xA000, 0x9191, REG_BITS_16},
	{0xA002, 0x4c, REG_BITS_8},
	{0xA003, 0x11, REG_BITS_8},
	{0xA004, 0x0d, REG_BITS_8},
	{0xA005, 0x5b, REG_BITS_8},
	{0xA006, 0x98, REG_BITS_8},
	{0xA007, 0xe3, REG_BITS_8},
	{0xA008, 0x96, REG_BITS_8},
	{0xA009, 0xe7, REG_BITS_8},
	{0xA00A, 0x9c, REG_BITS_8},
	{0xA00B, 0x65, REG_BITS_8},
	{0xA00C, 0x38, REG_BITS_8},
	{0xA00D, 0x63, REG_BITS_8},
	{0xA00E, 0xe1, REG_BITS_8},
	{0xA00F, 0xcd, REG_BITS_8},
	{0xA010, 0x58, REG_BITS_8},
	{0xA011, 0x76, REG_BITS_8},
	{0xA012, 0x73, REG_BITS_8},
	{0xA013, 0x16, REG_BITS_8},
	{0xA014, 0xe2, REG_BITS_8},
	{0xA015, 0x94, REG_BITS_8},
	{0xA016, 0xc5, REG_BITS_8},
	{0xA017, 0x38, REG_BITS_8},
	{0xA018, 0x4a, REG_BITS_8},
	{0xA019, 0x19, REG_BITS_8},
	{0xA01A, 0x0d, REG_BITS_8},
	{0xA01B, 0x5e, REG_BITS_8},
	{0xA01C, 0xb6, REG_BITS_8},
	{0xA01D, 0x23, REG_BITS_8},
	{0xA01E, 0x18, REG_BITS_8},
	{0xA01F, 0xf4, REG_BITS_8},
	{0xA020, 0xf8, REG_BITS_8},
	{0xA021, 0xe5, REG_BITS_8},
	{0xA022, 0x3b, REG_BITS_8},
	{0xA023, 0x79, REG_BITS_8},
	{0xA024, 0x91, REG_BITS_8},
	{0xA025, 0x0e, REG_BITS_8},
	{0xA026, 0x5d, REG_BITS_8},
	{0xA027, 0x94, REG_BITS_8},
	{0xA028, 0x43, REG_BITS_8},
	{0xA029, 0x17, REG_BITS_8},
	{0xA02A, 0xe5, REG_BITS_8},
	{0xA02B, 0xd8, REG_BITS_8},
	{0xA02C, 0x05, REG_BITS_8},
	{0xA02D, 0x3a, REG_BITS_8},
	{0xA02E, 0x78, REG_BITS_8},
	{0xA02F, 0xc9, REG_BITS_8},
	{0xA030, 0x4e, REG_BITS_8},
	{0xA031, 0x5b, REG_BITS_8},
	{0xA032, 0xa2, REG_BITS_8},
	{0xA033, 0x83, REG_BITS_8},
	{0xA034, 0x97, REG_BITS_8},
	{0xA035, 0xea, REG_BITS_8},
	{0xA036, 0xf8, REG_BITS_8},
	{0xA037, 0x05, REG_BITS_8},
	{0xA038, 0x3b, REG_BITS_8},
	{0xA039, 0x6b, REG_BITS_8},
	{0xA03A, 0xc9, REG_BITS_8},
	{0xA03B, 0x8d, REG_BITS_8},
	{0xA03C, 0x57, REG_BITS_8},
	{0xA03D, 0x3e, REG_BITS_8},
	{0xA03E, 0x63, REG_BITS_8},
	{0xA03F, 0x15, REG_BITS_8},
	{0xA040, 0xc9, REG_BITS_8},
	{0xA041, 0x64, REG_BITS_8},
	{0xA042, 0xe5, REG_BITS_8},
	{0xA043, 0x32, REG_BITS_8},
	{0xA044, 0x62, REG_BITS_8},
	{0xA045, 0x41, REG_BITS_8},
	{0xA046, 0x4d, REG_BITS_8},
	{0xA047, 0x5c, REG_BITS_8},
	{0xA048, 0x88, REG_BITS_8},
	{0xA049, 0x63, REG_BITS_8},
	{0xA04A, 0x96, REG_BITS_8},
	{0xA04B, 0xdf, REG_BITS_8},
	{0xA04C, 0xd4, REG_BITS_8},
	{0xA04D, 0xe5, REG_BITS_8},
	{0xA04E, 0x38, REG_BITS_8},
	{0xA04F, 0x6d, REG_BITS_8},
	{0xA050, 0xa9, REG_BITS_8},
	{0xA051, 0x4d, REG_BITS_8},
	{0xA052, 0x54, REG_BITS_8},
	{0xA053, 0x08, REG_BITS_8},
	{0xA054, 0xd3, REG_BITS_8},
	{0xA055, 0x13, REG_BITS_8},
	{0xA056, 0xb0, REG_BITS_8},
	{0xA057, 0xd0, REG_BITS_8},
	{0xA058, 0x24, REG_BITS_8},
	{0xA059, 0x2a, REG_BITS_8},
	{0xA05A, 0x3a, REG_BITS_8},
	{0xA05B, 0xc1, REG_BITS_8},
	{0xA05C, 0x4a, REG_BITS_8},
	{0xA05D, 0x52, REG_BITS_8},
	{0xA05E, 0xe6, REG_BITS_8},
	{0xA05F, 0xe2, REG_BITS_8},
	{0xA060, 0x95, REG_BITS_8},
	{0xA061, 0xce, REG_BITS_8},
	{0xA062, 0x84, REG_BITS_8},
	{0xA063, 0x85, REG_BITS_8},
	{0xA064, 0x35, REG_BITS_8},
	{0xA065, 0x6d, REG_BITS_8},
	{0xA066, 0x89, REG_BITS_8},
	{0xA067, 0x4d, REG_BITS_8},
	{0xA068, 0x57, REG_BITS_8},
	{0xA069, 0x26, REG_BITS_8},
	{0xA06A, 0xa3, REG_BITS_8},
	{0xA06B, 0x13, REG_BITS_8},
	{0xA06C, 0xac, REG_BITS_8},
	{0xA06D, 0x74, REG_BITS_8},
	{0xA06E, 0x84, REG_BITS_8},
	{0xA06F, 0x25, REG_BITS_8},
	{0xA070, 0x13, REG_BITS_8},
	{0xA071, 0xd9, REG_BITS_8},
	{0xA072, 0x48, REG_BITS_8},
	{0xA073, 0x46, REG_BITS_8},
	{0xA074, 0x46, REG_BITS_8},
	{0xA075, 0x02, REG_BITS_8},
	{0xA076, 0x13, REG_BITS_8},
	{0xA077, 0xa4, REG_BITS_8},
	{0xA078, 0x34, REG_BITS_8},
	{0xA079, 0xe5, REG_BITS_8},
	{0xA07A, 0x2e, REG_BITS_8},
	{0xA07B, 0x58, REG_BITS_8},
	{0xA07C, 0x81, REG_BITS_8},
	{0xA07D, 0x8c, REG_BITS_8},
	{0xA07E, 0x58, REG_BITS_8},
	{0xA07F, 0x38, REG_BITS_8},
	{0xA080, 0x23, REG_BITS_8},
	{0xA081, 0x95, REG_BITS_8},
	{0xA082, 0xbe, REG_BITS_8},
	{0xA083, 0xb0, REG_BITS_8},
	{0xA084, 0xe4, REG_BITS_8},
	{0xA085, 0x27, REG_BITS_8},
	{0xA086, 0x0c, REG_BITS_8},
	{0xA087, 0x91, REG_BITS_8},
	{0xA088, 0x08, REG_BITS_8},
	{0xA089, 0x40, REG_BITS_8},
	{0xA08A, 0x00, REG_BITS_8},
	{0xA08B, 0x72, REG_BITS_8},
	{0xA08C, 0x10, REG_BITS_8},
	{0xA08D, 0x85, REG_BITS_8},
	{0xA08E, 0x84, REG_BITS_8},
	{0xA08F, 0xc4, REG_BITS_8},
	{0xA090, 0x25, REG_BITS_8},
	{0xA091, 0x42, REG_BITS_8},
	{0xA092, 0x19, REG_BITS_8},
	{0xA093, 0x4b, REG_BITS_8},
	{0xA094, 0x53, REG_BITS_8},
	{0xA095, 0xfc, REG_BITS_8},
	{0xA096, 0x22, REG_BITS_8},
	{0xA097, 0x96, REG_BITS_8},
	{0xA098, 0xcf, REG_BITS_8},
	{0xA099, 0x48, REG_BITS_8},
	{0xA09A, 0xc5, REG_BITS_8},
	{0xA09B, 0x2f, REG_BITS_8},
	{0xA09C, 0x2b, REG_BITS_8},
	{0xA09D, 0xf1, REG_BITS_8},
	{0xA09E, 0xc9, REG_BITS_8},
	{0xA09F, 0x42, REG_BITS_8},
	{0xA0A0, 0x20, REG_BITS_8},
	{0xA0A1, 0xf2, REG_BITS_8},
	{0xA0A2, 0x8f, REG_BITS_8},
	{0xA0A3, 0x7f, REG_BITS_8},
	{0xA0A4, 0x14, REG_BITS_8},
	{0xA0A5, 0xc4, REG_BITS_8},
	{0xA0A6, 0x20, REG_BITS_8},
	{0xA0A7, 0x1f, REG_BITS_8},
	{0xA0A8, 0x51, REG_BITS_8},
	{0xA0A9, 0x49, REG_BITS_8},
	{0xA0AA, 0x50, REG_BITS_8},
	{0xA0AB, 0xc0, REG_BITS_8},
	{0xA0AC, 0xc2, REG_BITS_8},
	{0xA0AD, 0x14, REG_BITS_8},
	{0xA0AE, 0xbd, REG_BITS_8},
	{0xA0AF, 0xc8, REG_BITS_8},
	{0xA0B0, 0x85, REG_BITS_8},
	{0xA0B1, 0x36, REG_BITS_8},
	{0xA0B2, 0x60, REG_BITS_8},
	{0xA0B3, 0x99, REG_BITS_8},
	{0xA0B4, 0x8c, REG_BITS_8},
	{0xA0B5, 0x4e, REG_BITS_8},
	{0xA0B6, 0xa8, REG_BITS_8},
	{0xA0B7, 0xc2, REG_BITS_8},
	{0xA0B8, 0x91, REG_BITS_8},
	{0xA0B9, 0x93, REG_BITS_8},
	{0xA0BA, 0x40, REG_BITS_8},
	{0xA0BB, 0x84, REG_BITS_8},
	{0xA0BC, 0x22, REG_BITS_8},
	{0xA0BD, 0x16, REG_BITS_8},
	{0xA0BE, 0xd9, REG_BITS_8},
	{0xA0BF, 0x48, REG_BITS_8},
	{0xA0C0, 0x4b, REG_BITS_8},
	{0xA0C1, 0x7a, REG_BITS_8},
	{0xA0C2, 0xa2, REG_BITS_8},
	{0xA0C3, 0x94, REG_BITS_8},
	{0xA0C4, 0xb8, REG_BITS_8},
	{0xA0C5, 0x58, REG_BITS_8},
	{0xA0C6, 0x85, REG_BITS_8},
	{0xA0C7, 0x31, REG_BITS_8},
	{0xA0C8, 0x7d, REG_BITS_8},
	{0xA0C9, 0x49, REG_BITS_8},
	{0xA0CA, 0x0e, REG_BITS_8},
	{0xA0CB, 0x5d, REG_BITS_8},
	{0xA0CC, 0x6a, REG_BITS_8},
	{0xA0CD, 0x53, REG_BITS_8},
	{0xA0CE, 0x95, REG_BITS_8},
	{0xA0CF, 0xc0, REG_BITS_8},
	{0xA0D0, 0xf8, REG_BITS_8},
	{0xA0D1, 0x64, REG_BITS_8},
	{0xA0D2, 0x2b, REG_BITS_8},
	{0xA0D3, 0x32, REG_BITS_8},
	{0xA0D4, 0x31, REG_BITS_8},
	{0xA0D5, 0x4a, REG_BITS_8},
	{0xA0D6, 0x4d, REG_BITS_8},
	{0xA0D7, 0x98, REG_BITS_8},
	{0xA0D8, 0x62, REG_BITS_8},
	{0xA0D9, 0x94, REG_BITS_8},
	{0xA0DA, 0xb4, REG_BITS_8},
	{0xA0DB, 0x74, REG_BITS_8},
	{0xA0DC, 0xa5, REG_BITS_8},
	{0xA0DD, 0x32, REG_BITS_8},
	{0xA0DE, 0x64, REG_BITS_8},
	{0xA0DF, 0x41, REG_BITS_8},
	{0xA0E0, 0xcd, REG_BITS_8},
	{0xA0E1, 0x60, REG_BITS_8},
	{0xA0E2, 0xba, REG_BITS_8},
	{0xA0E3, 0x83, REG_BITS_8},
	{0xA0E4, 0x18, REG_BITS_8},
	{0xA0E5, 0xee, REG_BITS_8},
	{0xA0E6, 0xc8, REG_BITS_8},
	{0xA0E7, 0x85, REG_BITS_8},
	{0xA0E8, 0x36, REG_BITS_8},
	{0xA0E9, 0x60, REG_BITS_8},
	{0xA0EA, 0xb1, REG_BITS_8},
	{0xA0EB, 0x8c, REG_BITS_8},
	{0xA0EC, 0x55, REG_BITS_8},
	{0xA0ED, 0x0e, REG_BITS_8},
	{0xA0EE, 0x73, REG_BITS_8},
	{0xA0EF, 0x15, REG_BITS_8},
	{0xA0F0, 0xc5, REG_BITS_8},
	{0xA0F1, 0x88, REG_BITS_8},
	{0xA0F2, 0xe5, REG_BITS_8},
	{0xA0F3, 0x33, REG_BITS_8},
	{0xA0F4, 0x74, REG_BITS_8},
	{0xA0F5, 0x09, REG_BITS_8},
	{0xA0F6, 0x0e, REG_BITS_8},
	{0xA0F7, 0x5b, REG_BITS_8},
	{0xA0F8, 0x7a, REG_BITS_8},
	{0xA0F9, 0xa3, REG_BITS_8},
	{0xA0FA, 0x18, REG_BITS_8},
	{0xA0FB, 0xf7, REG_BITS_8},
	{0xA0FC, 0x48, REG_BITS_8},
	{0xA0FD, 0x46, REG_BITS_8},
	{0xA0FE, 0x3e, REG_BITS_8},
	{0xA0FF, 0x89, REG_BITS_8},
	{0xA100, 0x01, REG_BITS_8},
	{0xA101, 0x8f, REG_BITS_8},
	{0xA102, 0x5f, REG_BITS_8},
	{0xA103, 0xa6, REG_BITS_8},
	{0xA104, 0x83, REG_BITS_8},
	{0xA105, 0x97, REG_BITS_8},
	{0xA106, 0xe6, REG_BITS_8},
	{0xA107, 0xe4, REG_BITS_8},
	{0xA108, 0xa5, REG_BITS_8},
	{0xA109, 0x39, REG_BITS_8},
	{0xA10A, 0x7b, REG_BITS_8},
	{0xA10B, 0x81, REG_BITS_8},
	{0xA10C, 0x8e, REG_BITS_8},
	{0xA10D, 0x5f, REG_BITS_8},
	{0xA10E, 0xb4, REG_BITS_8},
	{0xA10F, 0x33, REG_BITS_8},
	{0xA110, 0x17, REG_BITS_8},
	{0xA111, 0xe8, REG_BITS_8},
	{0xA112, 0x78, REG_BITS_8},
	{0xA113, 0xa5, REG_BITS_8},
	{0xA114, 0x36, REG_BITS_8},
	{0xA115, 0x7b, REG_BITS_8},
	{0xA116, 0xd1, REG_BITS_8},
	{0xA117, 0x0e, REG_BITS_8},
	{0xA118, 0x5e, REG_BITS_8},
	{0xA119, 0x9e, REG_BITS_8},
	{0xA11A, 0xb3, REG_BITS_8},
	{0xA11B, 0x16, REG_BITS_8},
	{0xA11C, 0xe3, REG_BITS_8},
	{0xA11D, 0xa8, REG_BITS_8},
	{0xA11E, 0xa5, REG_BITS_8},
	{0xA11F, 0x38, REG_BITS_8},
	{0xA120, 0x69, REG_BITS_8},
	{0xA121, 0x19, REG_BITS_8},
	{0xA122, 0x4e, REG_BITS_8},
	{0xA123, 0x5b, REG_BITS_8},
	{0xA124, 0x88, REG_BITS_8},
	{0xA125, 0xb3, REG_BITS_8},
	{0xA126, 0x96, REG_BITS_8},
	{0xA127, 0xe2, REG_BITS_8},
	{0xA128, 0x50, REG_BITS_8},
	{0xA129, 0x45, REG_BITS_8},
	{0xA12A, 0x35, REG_BITS_8},
	{0xA12B, 0x42, REG_BITS_8},
	{0xA12C, 0x89, REG_BITS_8},
	{0xA12D, 0x8a, REG_BITS_8},
	{0xA12E, 0x57, REG_BITS_8},
	{0xA12F, 0xe0, REG_BITS_8},
	{0xA130, 0xf2, REG_BITS_8},
	{0xA131, 0x95, REG_BITS_8},
	{0xA132, 0xb8, REG_BITS_8},
	{0xA133, 0x6c, REG_BITS_8},
	{0xA134, 0x45, REG_BITS_8},
	{0xA135, 0x2d, REG_BITS_8},
	{0xA136, 0x5c, REG_BITS_8},
	{0xA137, 0x39, REG_BITS_8},
	{0xA138, 0x8b, REG_BITS_8},
	{0xA139, 0x56, REG_BITS_8},
	{0xA13A, 0xcc, REG_BITS_8},
	{0xA13B, 0xf2, REG_BITS_8},
	{0xA13C, 0x15, REG_BITS_8},
	{0xA13D, 0xb5, REG_BITS_8},
	{0xA13E, 0x7c, REG_BITS_8},
	{0xA13F, 0x25, REG_BITS_8},
	{0xA140, 0x2d, REG_BITS_8},
	{0xA141, 0x44, REG_BITS_8},
	{0xA142, 0x71, REG_BITS_8},
	{0xA143, 0x8a, REG_BITS_8},
	{0xA144, 0x59, REG_BITS_8},
	{0xA145, 0xf8, REG_BITS_8},
	{0xA146, 0x02, REG_BITS_8},
	{0xA147, 0x17, REG_BITS_8},
	{0xA148, 0xc3, REG_BITS_8},
	{0xA149, 0xb8, REG_BITS_8},
	{0xA14A, 0x05, REG_BITS_8},
	{0xA14B, 0x30, REG_BITS_8},
	{0xA14C, 0x6b, REG_BITS_8},
	{0xA14D, 0xd9, REG_BITS_8},
	{0xA14E, 0xcb, REG_BITS_8},
	{0xA14F, 0x5a, REG_BITS_8},
	{0xA150, 0xee, REG_BITS_8},
	{0xA151, 0xc2, REG_BITS_8},
	{0xA152, 0x16, REG_BITS_8},
	{0xA153, 0xbc, REG_BITS_8},
	{0xA154, 0xb8, REG_BITS_8},
	{0xA155, 0x25, REG_BITS_8},
	{0xA156, 0x2f, REG_BITS_8},
	{0xA157, 0x70, REG_BITS_8},
	{0xA158, 0xe1, REG_BITS_8},
	{0xA159, 0x0b, REG_BITS_8},
	{0xA15A, 0x59, REG_BITS_8},
	{0xA15B, 0xe2, REG_BITS_8},
	{0xA15C, 0x32, REG_BITS_8},
	{0xA15D, 0x16, REG_BITS_8},
	{0xA15E, 0xbc, REG_BITS_8},
	{0xA15F, 0xac, REG_BITS_8},
	{0xA160, 0xc5, REG_BITS_8},
	{0xA161, 0x2f, REG_BITS_8},
	{0xA162, 0x5d, REG_BITS_8},
	{0xA163, 0x61, REG_BITS_8},
	{0xA164, 0x4b, REG_BITS_8},
	{0xA165, 0x55, REG_BITS_8},
	{0xA166, 0xc0, REG_BITS_8},
	{0xA167, 0x22, REG_BITS_8},
	{0xA168, 0x15, REG_BITS_8},
	{0xA169, 0xad, REG_BITS_8},
	{0xA16A, 0x54, REG_BITS_8},
	{0xA16B, 0x85, REG_BITS_8},
	{0xA16C, 0x2b, REG_BITS_8},
	{0xA16D, 0x5f, REG_BITS_8},
	{0xA16E, 0x31, REG_BITS_8},
	{0xA16F, 0xcb, REG_BITS_8},
	{0xA170, 0x5a, REG_BITS_8},
	{0xA171, 0xe8, REG_BITS_8},
	{0xA172, 0xe2, REG_BITS_8},
	{0xA173, 0x15, REG_BITS_8},
	{0xA174, 0xb5, REG_BITS_8},
	{0xA175, 0x7c, REG_BITS_8},
	{0xA176, 0x45, REG_BITS_8},
	{0xA177, 0x2e, REG_BITS_8},
	{0xA178, 0x5b, REG_BITS_8},
	{0xA179, 0x61, REG_BITS_8},
	{0xA17A, 0xcb, REG_BITS_8},
	{0xA17B, 0x51, REG_BITS_8},
	{0xA17C, 0xa6, REG_BITS_8},
	{0xA17D, 0x92, REG_BITS_8},
	{0xA17E, 0x93, REG_BITS_8},
	{0xA17F, 0x9f, REG_BITS_8},
	{0xA180, 0xcc, REG_BITS_8},
	{0xA181, 0xe4, REG_BITS_8},
	{0xA182, 0x26, REG_BITS_8},
	{0xA183, 0x38, REG_BITS_8},
	{0xA184, 0xd9, REG_BITS_8},
	{0xA185, 0x89, REG_BITS_8},
	{0xA186, 0x51, REG_BITS_8},
	{0xA187, 0x94, REG_BITS_8},
	{0xA188, 0x72, REG_BITS_8},
	{0xA189, 0x15, REG_BITS_8},
	{0xA18A, 0xaf, REG_BITS_8},
	{0xA18B, 0x5c, REG_BITS_8},
	{0xA18C, 0x25, REG_BITS_8},
	{0xA18D, 0x2c, REG_BITS_8},
	{0xA18E, 0x57, REG_BITS_8},
	{0xA18F, 0x41, REG_BITS_8},
	{0xA190, 0x4b, REG_BITS_8},
	{0xA191, 0x53, REG_BITS_8},
	{0xA192, 0xb4, REG_BITS_8},
	{0xA193, 0x22, REG_BITS_8},
	{0xA194, 0x93, REG_BITS_8},
	{0xA195, 0x9d, REG_BITS_8},
	{0xA196, 0x68, REG_BITS_8},
	{0xA197, 0xc4, REG_BITS_8},
	{0xA198, 0x23, REG_BITS_8},
	{0xA199, 0x12, REG_BITS_8},
	{0xA19A, 0xa1, REG_BITS_8},
	{0xA19B, 0x48, REG_BITS_8},
	{0xA19C, 0x46, REG_BITS_8},
	{0xA19D, 0x34, REG_BITS_8},
	{0xA19E, 0xe2, REG_BITS_8},
	{0xA19F, 0x92, REG_BITS_8},
	{0xA1A0, 0x98, REG_BITS_8},
	{0xA1A1, 0x18, REG_BITS_8},
	{0xA1A2, 0x85, REG_BITS_8},
	{0xA1A3, 0x29, REG_BITS_8},
	{0xA1A4, 0x4c, REG_BITS_8},
	{0xA1A5, 0xb1, REG_BITS_8},
	{0xA1A6, 0x0a, REG_BITS_8},
	{0xA1A7, 0x53, REG_BITS_8},
	{0xA1A8, 0xb8, REG_BITS_8},
	{0xA1A9, 0x32, REG_BITS_8},
	{0xA1AA, 0x94, REG_BITS_8},
	{0xA1AB, 0xa7, REG_BITS_8},
	{0xA1AC, 0x90, REG_BITS_8},
	{0xA1AD, 0x64, REG_BITS_8},
	{0xA1AE, 0x25, REG_BITS_8},
	{0xA1AF, 0x09, REG_BITS_8},
	{0xA1B0, 0x61, REG_BITS_8},
	{0xA1B1, 0x48, REG_BITS_8},
	{0xA1B2, 0x40, REG_BITS_8},
	{0xA1B3, 0x00, REG_BITS_8},
	{0xA1B4, 0x72, REG_BITS_8},
	{0xA1B5, 0x10, REG_BITS_8},
	{0xA1B6, 0x83, REG_BITS_8},
	{0xA1B7, 0x78, REG_BITS_8},
	{0xA1B8, 0x04, REG_BITS_8},
	{0xA1B9, 0x24, REG_BITS_8},
	{0xA1BA, 0x3a, REG_BITS_8},
	{0xA1BB, 0x01, REG_BITS_8},
	{0xA1BC, 0x0a, REG_BITS_8},
	{0xA1BD, 0x50, REG_BITS_8},
	{0xA1BE, 0x94, REG_BITS_8},
	{0xA1BF, 0xe2, REG_BITS_8},
	{0xA1C0, 0x14, REG_BITS_8},
	{0xA1C1, 0xae, REG_BITS_8},
	{0xA1C2, 0x0c, REG_BITS_8},
	{0xA1C3, 0xc5, REG_BITS_8},
	{0xA1C4, 0x29, REG_BITS_8},
	{0xA1C5, 0x24, REG_BITS_8},
	{0xA1C6, 0x51, REG_BITS_8},
	{0xA1C7, 0xc9, REG_BITS_8},
	{0xA1C8, 0x41, REG_BITS_8},
	{0xA1C9, 0x14, REG_BITS_8},
	{0xA1CA, 0xe2, REG_BITS_8},
	{0xA1CB, 0x8f, REG_BITS_8},
	{0xA1CC, 0x7f, REG_BITS_8},
	{0xA1CD, 0x14, REG_BITS_8},
	{0xA1CE, 0x64, REG_BITS_8},
	{0xA1CF, 0x20, REG_BITS_8},
	{0xA1D0, 0x1b, REG_BITS_8},
	{0xA1D1, 0xe1, REG_BITS_8},
	{0xA1D2, 0xc8, REG_BITS_8},
	{0xA1D3, 0x4d, REG_BITS_8},
	{0xA1D4, 0x7a, REG_BITS_8},
	{0xA1D5, 0xd2, REG_BITS_8},
	{0xA1D6, 0x93, REG_BITS_8},
	{0xA1D7, 0xa3, REG_BITS_8},
	{0xA1D8, 0x70, REG_BITS_8},
	{0xA1D9, 0x45, REG_BITS_8},
	{0xA1DA, 0x2d, REG_BITS_8},
	{0xA1DB, 0x50, REG_BITS_8},
	{0xA1DC, 0xc9, REG_BITS_8},
	{0xA1DD, 0x8a, REG_BITS_8},
	{0xA1DE, 0x4c, REG_BITS_8},
	{0xA1DF, 0x6e, REG_BITS_8},
	{0xA1E0, 0x72, REG_BITS_8},
	{0xA1E1, 0x91, REG_BITS_8},
	{0xA1E2, 0x8c, REG_BITS_8},
	{0xA1E3, 0x30, REG_BITS_8},
	{0xA1E4, 0xa4, REG_BITS_8},
	{0xA1E5, 0x21, REG_BITS_8},
	{0xA1E6, 0x12, REG_BITS_8},
	{0xA1E7, 0x89, REG_BITS_8},
	{0xA1E8, 0x88, REG_BITS_8},
	{0xA1E9, 0x49, REG_BITS_8},
	{0xA1EA, 0x52, REG_BITS_8},
	{0xA1EB, 0xd2, REG_BITS_8},
	{0xA1EC, 0x93, REG_BITS_8},
	{0xA1ED, 0xa2, REG_BITS_8},
	{0xA1EE, 0x10, REG_BITS_8},
	{0xA1EF, 0x25, REG_BITS_8},
	{0xA1F0, 0x2a, REG_BITS_8},
	{0xA1F1, 0x66, REG_BITS_8},
	{0xA1F2, 0x99, REG_BITS_8},
	{0xA1F3, 0x4b, REG_BITS_8},
	{0xA1F4, 0x58, REG_BITS_8},
	{0xA1F5, 0xd6, REG_BITS_8},
	{0xA1F6, 0x92, REG_BITS_8},
	{0xA1F7, 0x94, REG_BITS_8},
	{0xA1F8, 0xa7, REG_BITS_8},
	{0xA1F9, 0xd8, REG_BITS_8},
	{0xA1FA, 0x04, REG_BITS_8},
	{0xA1FB, 0x27, REG_BITS_8},
	{0xA1FC, 0x2a, REG_BITS_8},
	{0xA1FD, 0x69, REG_BITS_8},
	{0xA1FE, 0x49, REG_BITS_8},
	{0xA1FF, 0x4b, REG_BITS_8},
	{0xA200, 0x62, REG_BITS_8},
	{0xA201, 0xb2, REG_BITS_8},
	{0xA202, 0x13, REG_BITS_8},
	{0xA203, 0xa1, REG_BITS_8},
	{0xA204, 0x34, REG_BITS_8},
	{0xA205, 0x25, REG_BITS_8},
	{0xA206, 0x2b, REG_BITS_8},
	{0xA207, 0x4e, REG_BITS_8},
	{0xA208, 0xf9, REG_BITS_8},
	{0xA209, 0xca, REG_BITS_8},
	{0xA20A, 0x5b, REG_BITS_8},
	{0xA20B, 0xf6, REG_BITS_8},
	{0xA20C, 0x52, REG_BITS_8},
	{0xA20D, 0x17, REG_BITS_8},
	{0xA20E, 0xc0, REG_BITS_8},
	{0xA20F, 0x90, REG_BITS_8},
	{0xA210, 0xa5, REG_BITS_8},
	{0xA211, 0x2d, REG_BITS_8},
	{0xA212, 0x56, REG_BITS_8},
	{0xA213, 0xd9, REG_BITS_8},
	{0xA214, 0x0a, REG_BITS_8},
	{0xA215, 0x53, REG_BITS_8},
	{0xA216, 0xa6, REG_BITS_8},
	{0xA217, 0xd2, REG_BITS_8},
	{0xA218, 0x94, REG_BITS_8},
	{0xA219, 0xaa, REG_BITS_8},
	{0xA21A, 0x50, REG_BITS_8},
	{0xA21B, 0x45, REG_BITS_8},
	{0xA21C, 0x2c, REG_BITS_8},
	{0xA21D, 0x5f, REG_BITS_8},
	{0xA21E, 0x91, REG_BITS_8},
	{0xA21F, 0x0b, REG_BITS_8},
	{0xA220, 0x55, REG_BITS_8},
	{0xA221, 0xd4, REG_BITS_8},
	{0xA222, 0x52, REG_BITS_8},
	{0xA223, 0x97, REG_BITS_8},
	{0xA224, 0xc0, REG_BITS_8},
	{0xA225, 0xf4, REG_BITS_8},
	{0xA226, 0x25, REG_BITS_8},
	{0xA227, 0x31, REG_BITS_8},
	{0xA228, 0x79, REG_BITS_8},
	{0xA229, 0x21, REG_BITS_8},
	{0xA22A, 0x8c, REG_BITS_8},
	{0xA22B, 0x5c, REG_BITS_8},
	{0xA22C, 0xf8, REG_BITS_8},
	{0xA22D, 0xc2, REG_BITS_8},
	{0xA22E, 0x96, REG_BITS_8},
	{0xA22F, 0xbc, REG_BITS_8},
	{0xA230, 0xa4, REG_BITS_8},
	{0xA231, 0x05, REG_BITS_8},
	{0xA232, 0x2f, REG_BITS_8},
	{0xA233, 0x68, REG_BITS_8},
	{0xA234, 0xe9, REG_BITS_8},
	{0xA235, 0x8b, REG_BITS_8},
	{0xA236, 0x59, REG_BITS_8},
	{0xA237, 0xfe, REG_BITS_8},
	{0xA238, 0xb2, REG_BITS_8},
	{0xA239, 0x15, REG_BITS_8},
	{0xA23A, 0xba, REG_BITS_8},
	{0xA23B, 0x34, REG_BITS_8},
	{0xA23C, 0xe5, REG_BITS_8},
	{0xA23D, 0x2a, REG_BITS_8},
	{0xA23E, 0x69, REG_BITS_8},
	{0xA23F, 0xa1, REG_BITS_8},
	{0xA240, 0x8b, REG_BITS_8},
	{0xA241, 0x5a, REG_BITS_8},
	{0xA242, 0xea, REG_BITS_8},
	{0xA243, 0x32, REG_BITS_8},
	{0xA244, 0x16, REG_BITS_8},
	{0xA245, 0xb6, REG_BITS_8},
	{0xA246, 0x7c, REG_BITS_8},
	{0xA247, 0x85, REG_BITS_8},
	{0xA248, 0x2d, REG_BITS_8},
	{0xA249, 0x5a, REG_BITS_8},
	{0xA24A, 0x51, REG_BITS_8},
	{0xA24B, 0x0b, REG_BITS_8},
	{0xA24C, 0x57, REG_BITS_8},
	{0xA24D, 0xe0, REG_BITS_8},
	{0xA24E, 0x72, REG_BITS_8},
	{0xA24F, 0x95, REG_BITS_8},
	{0xA250, 0xb6, REG_BITS_8},
	{0xA251, 0xfc, REG_BITS_8},
	{0xA252, 0x84, REG_BITS_8},
	{0xA253, 0x2a, REG_BITS_8},
	{0xA254, 0x9c, REG_BITS_8},
	{0xA255, 0x79, REG_BITS_8},
	{0xA256, 0xce, REG_BITS_8},
	{0xA257, 0x75, REG_BITS_8},
	{0xA258, 0x94, REG_BITS_8},
	{0xA259, 0x43, REG_BITS_8},
	{0xA25A, 0x9c, REG_BITS_8},
	{0xA25B, 0xdf, REG_BITS_8},
	{0xA25C, 0x24, REG_BITS_8},
	{0xA25D, 0x07, REG_BITS_8},
	{0xA25E, 0x39, REG_BITS_8},
	{0xA25F, 0xa1, REG_BITS_8},
	{0xA260, 0xf9, REG_BITS_8},
	{0xA261, 0x4e, REG_BITS_8},
	{0xA262, 0x7c, REG_BITS_8},
	{0xA263, 0xd0, REG_BITS_8},
	{0xA264, 0x93, REG_BITS_8},
	{0xA265, 0x1d, REG_BITS_8},
	{0xA266, 0xe7, REG_BITS_8},
	{0xA267, 0x30, REG_BITS_8},
	{0xA268, 0x87, REG_BITS_8},
	{0xA269, 0x3a, REG_BITS_8},
	{0xA26A, 0xde, REG_BITS_8},
	{0xA26B, 0xa9, REG_BITS_8},
	{0xA26C, 0x8e, REG_BITS_8},
	{0xA26D, 0x77, REG_BITS_8},
	{0xA26E, 0xc2, REG_BITS_8},
	{0xA26F, 0xc3, REG_BITS_8},
	{0xA270, 0x9b, REG_BITS_8},
	{0xA271, 0xce, REG_BITS_8},
	{0xA272, 0x34, REG_BITS_8},
	{0xA273, 0xe6, REG_BITS_8},
	{0xA274, 0x31, REG_BITS_8},
	{0xA275, 0xa3, REG_BITS_8},
	{0xA276, 0x39, REG_BITS_8},
	{0xA277, 0xce, REG_BITS_8},
	{0xA278, 0x71, REG_BITS_8},
	{0xA279, 0x98, REG_BITS_8},
	{0xA27A, 0x63, REG_BITS_8},
	{0xA27B, 0x9b, REG_BITS_8},
	{0xA27C, 0xc0, REG_BITS_8},
	{0xA27D, 0x68, REG_BITS_8},
	{0xA27E, 0x25, REG_BITS_8},
	{0xA27F, 0x29, REG_BITS_8},
	{0xA280, 0x4d, REG_BITS_8},
	{0xA281, 0x49, REG_BITS_8},
	{0xA282, 0x0b, REG_BITS_8},
	{0xA283, 0x66, REG_BITS_8},
	{0xA284, 0x60, REG_BITS_8},
	{0xA285, 0x33, REG_BITS_8},
	{0xA286, 0x9b, REG_BITS_8},
	{0xA287, 0xc7, REG_BITS_8},
	{0xA288, 0x48, REG_BITS_8},
	{0xA289, 0xe5, REG_BITS_8},
	{0xA28A, 0x24, REG_BITS_8},
	{0xA28B, 0x16, REG_BITS_8},
	{0xA28C, 0xe1, REG_BITS_8},
	{0xA28D, 0x48, REG_BITS_8},
	{0xA28E, 0x4f, REG_BITS_8},
	{0xA28F, 0xe0, REG_BITS_8},
	{0xA290, 0x22, REG_BITS_8},
	{0xA291, 0x99, REG_BITS_8},
	{0xA292, 0xce, REG_BITS_8},
	{0xA293, 0xe4, REG_BITS_8},
	{0xA294, 0x25, REG_BITS_8},
	{0xA295, 0x27, REG_BITS_8},
	{0xA296, 0x10, REG_BITS_8},
	{0xA297, 0x01, REG_BITS_8},
	{0xA298, 0x88, REG_BITS_8},
	{0xA299, 0x41, REG_BITS_8},
	{0xA29A, 0x4c, REG_BITS_8},
	{0xA29B, 0xb2, REG_BITS_8},
	{0xA29C, 0x95, REG_BITS_8},
	{0xA29D, 0xbf, REG_BITS_8},
	{0xA29E, 0x7c, REG_BITS_8},
	{0xA29F, 0x26, REG_BITS_8},
	{0xA2A0, 0x2f, REG_BITS_8},
	{0xA2A1, 0x39, REG_BITS_8},
	{0xA2A2, 0x71, REG_BITS_8},
	{0xA2A3, 0xc8, REG_BITS_8},
	{0xA2A4, 0x3f, REG_BITS_8},
	{0xA2A5, 0x08, REG_BITS_8},
	{0xA2A6, 0x42, REG_BITS_8},
	{0xA2A7, 0x12, REG_BITS_8},
	{0xA2A8, 0xad, REG_BITS_8},
	{0xA2A9, 0xf0, REG_BITS_8},
	{0xA2AA, 0xc5, REG_BITS_8},
	{0xA2AB, 0x36, REG_BITS_8},
	{0xA2AC, 0x8f, REG_BITS_8},
	{0xA2AD, 0x71, REG_BITS_8},
	{0xA2AE, 0xca, REG_BITS_8},
	{0xA2AF, 0x48, REG_BITS_8},
	{0xA2B0, 0x24, REG_BITS_8},
	{0xA2B1, 0x72, REG_BITS_8},
	{0xA2B2, 0x91, REG_BITS_8},
	{0xA2B3, 0x9b, REG_BITS_8},
	{0xA2B4, 0xb8, REG_BITS_8},
	{0xA2B5, 0x45, REG_BITS_8},
	{0xA2B6, 0x32, REG_BITS_8},
	{0xA2B7, 0xd3, REG_BITS_8},
	{0xA2B8, 0xb9, REG_BITS_8},
	{0xA2B9, 0x4d, REG_BITS_8},
	{0xA2BA, 0x5f, REG_BITS_8},
	{0xA2BB, 0xa8, REG_BITS_8},
	{0xA2BC, 0x12, REG_BITS_8},
	{0xA2BD, 0x94, REG_BITS_8},
	{0xA2BE, 0xa3, REG_BITS_8},
	{0xA2BF, 0x98, REG_BITS_8},
	{0xA2C0, 0x05, REG_BITS_8},
	{0xA2C1, 0x33, REG_BITS_8},
	{0xA2C2, 0xb2, REG_BITS_8},
	{0xA2C3, 0x51, REG_BITS_8},
	{0xA2C4, 0x8f, REG_BITS_8},
	{0xA2C5, 0x79, REG_BITS_8},
	{0xA2C6, 0x70, REG_BITS_8},
	{0xA2C7, 0x63, REG_BITS_8},
	{0xA2C8, 0x99, REG_BITS_8},
	{0xA2C9, 0xc2, REG_BITS_8},
	{0xA2CA, 0x28, REG_BITS_8},
	{0xA2CB, 0x66, REG_BITS_8},
	{0xA2CC, 0x34, REG_BITS_8},
	{0xA2CD, 0xcd, REG_BITS_8},
	{0xA2CE, 0x81, REG_BITS_8},
	{0xA2CF, 0x0e, REG_BITS_8},
	{0xA2D0, 0x7e, REG_BITS_8},
	{0xA2D1, 0x04, REG_BITS_8},
	{0xA2D2, 0xe4, REG_BITS_8},
	{0xA2D3, 0x1e, REG_BITS_8},
	{0xA2D4, 0xef, REG_BITS_8},
	{0xA2D5, 0x54, REG_BITS_8},
	{0xA2D6, 0xe7, REG_BITS_8},
	{0xA2D7, 0x3a, REG_BITS_8},
	{0xA2D8, 0xde, REG_BITS_8},
	{0xA2D9, 0x61, REG_BITS_8},
	{0xA2DA, 0x8f, REG_BITS_8},
	{0xA2DB, 0x78, REG_BITS_8},
	{0xA2DC, 0x6c, REG_BITS_8},
	{0xA2DD, 0x53, REG_BITS_8},
	{0xA2DE, 0x9e, REG_BITS_8},
	{0xA2DF, 0xef, REG_BITS_8},
	{0xA2E0, 0x50, REG_BITS_8},
	{0xA2E1, 0x47, REG_BITS_8},
	{0xA2E2, 0x3a, REG_BITS_8},
	{0xA2E3, 0xd0, REG_BITS_8},
	{0xA2E4, 0xa1, REG_BITS_8},
	{0xA2E5, 0x0e, REG_BITS_8},
	{0xA2E6, 0x75, REG_BITS_8},
	{0xA2E7, 0x68, REG_BITS_8},
	{0xA2E8, 0x03, REG_BITS_8},
	{0xA2E9, 0x80, REG_BITS_8},
	{0xA2EA, 0x00, REG_BITS_8},
	{0xA2EB, 0x00, REG_BITS_8},
	{0xA2EC, 0x00, REG_BITS_8},
	{0xA2ED, 0x00, REG_BITS_8},
	{0xA2EE, 0xb7, REG_BITS_8},
	{0xA2EF, 0x41, REG_BITS_8},
	{0xA2F0, 0x0f, REG_BITS_8},
	{0xA2F1, 0x7b, REG_BITS_8},
	{0xA2F2, 0xba, REG_BITS_8},
	{0xA2F3, 0x23, REG_BITS_8},
	{0xA2F4, 0x1d, REG_BITS_8},
	{0xA2F5, 0xe5, REG_BITS_8},
	{0xA2F6, 0x34, REG_BITS_8},
	{0xA2F7, 0x27, REG_BITS_8},
	{0xA2F8, 0x39, REG_BITS_8},
	{0xA2F9, 0xa2, REG_BITS_8},
	{0xA2FA, 0xc9, REG_BITS_8},
	{0xA2FB, 0xcf, REG_BITS_8},
	{0xA2FC, 0x81, REG_BITS_8},
	{0xA2FD, 0xf4, REG_BITS_8},
	{0xA2FE, 0x93, REG_BITS_8},
	{0xA2FF, 0x9e, REG_BITS_8},
	{0xA300, 0xed, REG_BITS_8},
	{0xA301, 0x54, REG_BITS_8},
	{0xA302, 0x07, REG_BITS_8},
	{0xA303, 0x3b, REG_BITS_8},
	{0xA304, 0xdd, REG_BITS_8},
	{0xA305, 0x91, REG_BITS_8},
	{0xA306, 0x0e, REG_BITS_8},
	{0xA307, 0x7d, REG_BITS_8},
	{0xA308, 0xe6, REG_BITS_8},
	{0xA309, 0xa3, REG_BITS_8},
	{0xA30A, 0x1c, REG_BITS_8},
	{0xA30B, 0xd5, REG_BITS_8},
	{0xA30C, 0x5c, REG_BITS_8},
	{0xA30D, 0xc6, REG_BITS_8},
	{0xA30E, 0x32, REG_BITS_8},
	{0xA30F, 0xa6, REG_BITS_8},
	{0xA310, 0x31, REG_BITS_8},
	{0xA311, 0x8e, REG_BITS_8},
	{0xA312, 0x70, REG_BITS_8},
	{0xA313, 0xc4, REG_BITS_8},
	{0xA314, 0x83, REG_BITS_8},
	{0xA315, 0x9c, REG_BITS_8},
	{0xA316, 0xc7, REG_BITS_8},
	{0xA317, 0x94, REG_BITS_8},
	{0xA318, 0x05, REG_BITS_8},
	{0xA319, 0x2a, REG_BITS_8},
	{0xA31A, 0x52, REG_BITS_8},
	{0xA31B, 0x69, REG_BITS_8},
	{0xA31C, 0x4b, REG_BITS_8},
	{0xA31D, 0x66, REG_BITS_8},
	{0xA31E, 0x58, REG_BITS_8},
	{0xA31F, 0xa3, REG_BITS_8},
	{0xA320, 0x1c, REG_BITS_8},
	{0xA321, 0xd1, REG_BITS_8},
	{0xA322, 0x7c, REG_BITS_8},
	{0xA323, 0xc5, REG_BITS_8},
	{0xA324, 0x25, REG_BITS_8},
	{0xA325, 0x1a, REG_BITS_8},
	{0xA326, 0xf1, REG_BITS_8},
	{0xA327, 0x08, REG_BITS_8},
	{0xA328, 0x50, REG_BITS_8},
	{0xA329, 0xe2, REG_BITS_8},
	{0xA32A, 0xf2, REG_BITS_8},
	{0xA32B, 0x98, REG_BITS_8},
	{0xA32C, 0xda, REG_BITS_8},
	{0xA32D, 0x2c, REG_BITS_8},
	{0xA32E, 0x86, REG_BITS_8},
	{0xA32F, 0x28, REG_BITS_8},
	{0xA330, 0x14, REG_BITS_8},
	{0xA331, 0x01, REG_BITS_8},
	{0xA332, 0x88, REG_BITS_8},
	{0xA333, 0x41, REG_BITS_8},
	{0xA334, 0x4e, REG_BITS_8},
	{0xA335, 0xd2, REG_BITS_8},
	{0xA336, 0x95, REG_BITS_8},
	{0xA337, 0xbd, REG_BITS_8},
	{0xA338, 0xd8, REG_BITS_8},
	{0xA339, 0x86, REG_BITS_8},
	{0xA33A, 0x31, REG_BITS_8},
	{0xA33B, 0x43, REG_BITS_8},
	{0xA33C, 0x91, REG_BITS_8},
	{0xA33D, 0xc8, REG_BITS_8},
	{0xA33E, 0x3f, REG_BITS_8},
	{0xA33F, 0x08, REG_BITS_8},
	{0xA340, 0x52, REG_BITS_8},
	{0xA341, 0x12, REG_BITS_8},
	{0xA342, 0xae, REG_BITS_8},
	{0xA343, 0xf0, REG_BITS_8},
	{0xA344, 0xc5, REG_BITS_8},
	{0xA345, 0x39, REG_BITS_8},
	{0xA346, 0xa2, REG_BITS_8},
	{0xA347, 0xd1, REG_BITS_8},
	{0xA348, 0x4a, REG_BITS_8},
	{0xA349, 0x4a, REG_BITS_8},
	{0xA34A, 0x28, REG_BITS_8},
	{0xA34B, 0x92, REG_BITS_8},
	{0xA34C, 0x11, REG_BITS_8},
	{0xA34D, 0x9d, REG_BITS_8},
	{0xA34E, 0xc4, REG_BITS_8},
	{0xA34F, 0x65, REG_BITS_8},
	{0xA350, 0x32, REG_BITS_8},
	{0xA351, 0xeb, REG_BITS_8},
	{0xA352, 0x59, REG_BITS_8},
	{0xA353, 0xce, REG_BITS_8},
	{0xA354, 0x62, REG_BITS_8},
	{0xA355, 0xbc, REG_BITS_8},
	{0xA356, 0x82, REG_BITS_8},
	{0xA357, 0x14, REG_BITS_8},
	{0xA358, 0xa7, REG_BITS_8},
	{0xA359, 0xac, REG_BITS_8},
	{0xA35A, 0x65, REG_BITS_8},
	{0xA35B, 0x33, REG_BITS_8},
	{0xA35C, 0xb2, REG_BITS_8},
	{0xA35D, 0x11, REG_BITS_8},
	{0xA35E, 0xd0, REG_BITS_8},
	{0xA35F, 0x7e, REG_BITS_8},
	{0xA360, 0x90, REG_BITS_8},
	{0xA361, 0x23, REG_BITS_8},
	{0xA362, 0x9a, REG_BITS_8},
	{0xA363, 0xc8, REG_BITS_8},
	{0xA364, 0x4c, REG_BITS_8},
	{0xA365, 0x26, REG_BITS_8},
	{0xA366, 0x35, REG_BITS_8},
	{0xA367, 0xce, REG_BITS_8},
	{0xA368, 0x71, REG_BITS_8},
	{0xA369, 0xce, REG_BITS_8},
	{0xA36A, 0x84, REG_BITS_8},
	{0xA36B, 0x2e, REG_BITS_8},
	{0xA36C, 0xf4, REG_BITS_8},
	{0xA36D, 0x1f, REG_BITS_8},
	{0xA36E, 0xf6, REG_BITS_8},
	{0xA36F, 0x98, REG_BITS_8},
	{0xA370, 0x27, REG_BITS_8},
	{0xA371, 0x3c, REG_BITS_8},
	{0xA372, 0xe5, REG_BITS_8},
	{0xA373, 0x69, REG_BITS_8},
	{0xA374, 0x8f, REG_BITS_8},
	{0xA375, 0x78, REG_BITS_8},
	{0xA376, 0xa2, REG_BITS_8},
	{0xA377, 0xc3, REG_BITS_8},
	{0xA378, 0x1f, REG_BITS_8},
	{0xA379, 0xf9, REG_BITS_8},
	{0xA37A, 0x8c, REG_BITS_8},
	{0xA37B, 0x07, REG_BITS_8},
	{0xA37C, 0x3c, REG_BITS_8},
	{0xA37D, 0xda, REG_BITS_8},
	{0xA37E, 0xe1, REG_BITS_8},
	{0xA37F, 0xce, REG_BITS_8},
	{0xA380, 0x75, REG_BITS_8},
	{0xA381, 0x6a, REG_BITS_8},
	{0xA382, 0x53, REG_BITS_8},
	{0xA383, 0x16, REG_BITS_8},
	{0xA384, 0xc0, REG_BITS_8},
	{0xA385, 0xec, REG_BITS_8},
	{0xA386, 0x65, REG_BITS_8},
	{0xA387, 0x2e, REG_BITS_8},
	{0xA388, 0x65, REG_BITS_8},
	{0xA389, 0x01, REG_BITS_8},
	{0xA38A, 0xcc, REG_BITS_8},
	{0xA38B, 0x5e, REG_BITS_8},
	{0xA38C, 0xe6, REG_BITS_8},
	{0xA38D, 0x02, REG_BITS_8},
	{0xA38E, 0x17, REG_BITS_8},
	{0xA38F, 0xb4, REG_BITS_8},
	{0xA390, 0xac, REG_BITS_8},
	{0xA391, 0xc5, REG_BITS_8},
	{0xA392, 0x2d, REG_BITS_8},
	{0xA393, 0x55, REG_BITS_8},
	{0xA394, 0x49, REG_BITS_8},
	{0xA395, 0xcc, REG_BITS_8},
	{0xA396, 0x63, REG_BITS_8},
	{0xA397, 0x0e, REG_BITS_8},
	{0xA398, 0x03, REG_BITS_8},
	{0xA399, 0x98, REG_BITS_8},
	{0xA39A, 0xbd, REG_BITS_8},
	{0xA39B, 0xdc, REG_BITS_8},
	{0xA39C, 0x05, REG_BITS_8},
	{0xA39D, 0x2f, REG_BITS_8},
	{0xA39E, 0x7c, REG_BITS_8},
	{0xA39F, 0x99, REG_BITS_8},
	{0xA3A0, 0x0b, REG_BITS_8},
	{0xA3A1, 0x61, REG_BITS_8},
	{0xA3A2, 0x0c, REG_BITS_8},
	{0xA3A3, 0xf3, REG_BITS_8},
	{0xA3A4, 0x16, REG_BITS_8},
	{0xA3A5, 0xb2, REG_BITS_8},
	{0xA3A6, 0x70, REG_BITS_8},
	{0xA3A7, 0x45, REG_BITS_8},
	{0xA3A8, 0x2b, REG_BITS_8},
	{0xA3A9, 0x65, REG_BITS_8},
	{0xA3AA, 0x91, REG_BITS_8},
	{0xA3AB, 0x0b, REG_BITS_8},
	{0xA3AC, 0x5a, REG_BITS_8},
	{0xA3AD, 0xf8, REG_BITS_8},
	{0xA3AE, 0x32, REG_BITS_8},
	{0xA3AF, 0x17, REG_BITS_8},
	{0xA3B0, 0xab, REG_BITS_8},
	{0xA3B1, 0x14, REG_BITS_8},
	{0xA3B2, 0x05, REG_BITS_8},
	{0xA3B3, 0x27, REG_BITS_8},
	{0xA3B4, 0x38, REG_BITS_8},
	{0xA3B5, 0x29, REG_BITS_8},
	{0xA3B6, 0x0a, REG_BITS_8},
	{0xA3B7, 0x56, REG_BITS_8},
	{0xA3B8, 0xb6, REG_BITS_8},
	{0xA3B9, 0x12, REG_BITS_8},
	{0xA3BA, 0x97, REG_BITS_8},
	{0xA3BB, 0xb0, REG_BITS_8},
	{0xA3BC, 0xfc, REG_BITS_8},
	{0xA3BD, 0x24, REG_BITS_8},
	{0xA3BE, 0x24, REG_BITS_8},
	{0xA3BF, 0x14, REG_BITS_8},
	{0xA3C0, 0xa9, REG_BITS_8},
	{0xA3C1, 0x48, REG_BITS_8},
	{0xA3C2, 0x4a, REG_BITS_8},
	{0xA3C3, 0x86, REG_BITS_8},
	{0xA3C4, 0xb2, REG_BITS_8},
	{0xA3C5, 0x14, REG_BITS_8},
	{0xA3C6, 0xb2, REG_BITS_8},
	{0xA3C7, 0x54, REG_BITS_8},
	{0xA3C8, 0xe5, REG_BITS_8},
	{0xA3C9, 0x25, REG_BITS_8},
	{0xA3CA, 0x0e, REG_BITS_8},
	{0xA3CB, 0x09, REG_BITS_8},
	{0xA3CC, 0xc8, REG_BITS_8},
	{0xA3CD, 0x40, REG_BITS_8},
	{0xA3CE, 0x30, REG_BITS_8},
	{0xA3CF, 0x72, REG_BITS_8},
	{0xA3D0, 0x13, REG_BITS_8},
	{0xA3D1, 0xa0, REG_BITS_8},
	{0xA3D2, 0x94, REG_BITS_8},
	{0xA3D3, 0xa5, REG_BITS_8},
	{0xA3D4, 0x2a, REG_BITS_8},
	{0xA3D5, 0x2e, REG_BITS_8},
	{0xA3D6, 0x59, REG_BITS_8},
	{0xA3D7, 0x88, REG_BITS_8},
	{0xA3D8, 0x3f, REG_BITS_8},
	{0xA3D9, 0x04, REG_BITS_8},
	{0xA3DA, 0x62, REG_BITS_8},
	{0xA3DB, 0x91, REG_BITS_8},
	{0xA3DC, 0x9a, REG_BITS_8},
	{0xA3DD, 0xfc, REG_BITS_8},
	{0xA3DE, 0xa4, REG_BITS_8},
	{0xA3DF, 0x2e, REG_BITS_8},
	{0xA3E0, 0x63, REG_BITS_8},
	{0xA3E1, 0xe9, REG_BITS_8},
	{0xA3E2, 0xc9, REG_BITS_8},
	{0xA3E3, 0x46, REG_BITS_8},
	{0xA3E4, 0x18, REG_BITS_8},
	{0xA3E5, 0x02, REG_BITS_8},
	{0xA3E6, 0x91, REG_BITS_8},
	{0xA3E7, 0x91, REG_BITS_8},
	{0xA3E8, 0x00, REG_BITS_8},
	{0xA3E9, 0x25, REG_BITS_8},
	{0xA3EA, 0x29, REG_BITS_8},
	{0xA3EB, 0x81, REG_BITS_8},
	{0xA3EC, 0xa9, REG_BITS_8},
	{0xA3ED, 0x8b, REG_BITS_8},
	{0xA3EE, 0x55, REG_BITS_8},
	{0xA3EF, 0x7a, REG_BITS_8},
	{0xA3F0, 0xb2, REG_BITS_8},
	{0xA3F1, 0x12, REG_BITS_8},
	{0xA3F2, 0x97, REG_BITS_8},
	{0xA3F3, 0xf8, REG_BITS_8},
	{0xA3F4, 0x84, REG_BITS_8},
	{0xA3F5, 0x2a, REG_BITS_8},
	{0xA3F6, 0x58, REG_BITS_8},
	{0xA3F7, 0x69, REG_BITS_8},
	{0xA3F8, 0xcc, REG_BITS_8},
	{0xA3F9, 0x63, REG_BITS_8},
	{0xA3FA, 0xea, REG_BITS_8},
	{0xA3FB, 0x02, REG_BITS_8},
	{0xA3FC, 0x96, REG_BITS_8},
	{0xA3FD, 0xa9, REG_BITS_8},
	{0xA3FE, 0x4c, REG_BITS_8},
	{0xA3FF, 0x85, REG_BITS_8},
	{0xA400, 0x2b, REG_BITS_8},
	{0xA401, 0x68, REG_BITS_8},
	{0xA402, 0x01, REG_BITS_8},
	{0xA403, 0xcb, REG_BITS_8},
	{0xA404, 0x66, REG_BITS_8},
	{0xA405, 0x38, REG_BITS_8},
	{0xA406, 0x03, REG_BITS_8},
	{0xA407, 0x19, REG_BITS_8},
	{0xA408, 0xc2, REG_BITS_8},
	{0xA409, 0xf0, REG_BITS_8},
	{0xA40A, 0x85, REG_BITS_8},
	{0xA40B, 0x2e, REG_BITS_8},
	{0xA40C, 0x73, REG_BITS_8},
	{0xA40D, 0x99, REG_BITS_8},
	{0xA40E, 0x8b, REG_BITS_8},
	{0xA40F, 0x5a, REG_BITS_8},
	{0xA410, 0xe6, REG_BITS_8},
	{0xA411, 0xb2, REG_BITS_8},
	{0xA412, 0x18, REG_BITS_8},
	{0xA413, 0xc2, REG_BITS_8},
	{0xA414, 0xdc, REG_BITS_8},
	{0xA415, 0xe5, REG_BITS_8},
	{0xA416, 0x2d, REG_BITS_8},
	{0xA417, 0x66, REG_BITS_8},
	{0xA418, 0x49, REG_BITS_8},
	{0xA419, 0x0b, REG_BITS_8},
	{0xA41A, 0x59, REG_BITS_8},
	{0xA41B, 0x9a, REG_BITS_8},
	{0xA41C, 0x02, REG_BITS_8},
	{0xA41D, 0x00, REG_BITS_8},
	{0xA41E, 0x00, REG_BITS_8},
	{0xA41F, 0x00, REG_BITS_8},
	{0xA420, 0x00, REG_BITS_8},
	{0xA421, 0x0a, REG_BITS_8},
};

int32_t sizeof_seix006_vendor_1_SHD_3_ES2 = sizeof(seix006_vendor_1_SHD_3_ES2);

const uint16_t AEO_table[] = {
	0, 38, 74, 109, 143, 176, 209, 240, 270, 300,
	329, 357, 384, 411, 437, 462, 487, 511, 535, 558,
	581, 603, 625, 646, 667, 687, 707, 727, 746, 765,
	783, 801, 819, 836, 853, 870, 887, 903, 919, 934,
	950, 965, 980, 994, 1009, 1023, 1037, 1050, 1064, 1077,
	1090, 1103, 1116, 1128, 1141, 1153, 1165, 1176, 1188, 1199,
	1211, 1222, 1233, 1243, 1254, 1264, 1275, 1285, 1295, 1305,
	1315, 1324, 1334, 1343, 1353, 1362, 1371, 1380, 1388, 1397,
	1406, 1414, 1423, 1431, 1439, 1447, 1455, 1463, 1471, 1479,
	1486, 1494, 1501, 1508, 1516, 1523, 1530, 1537, 1544, 1551,
	1557, 1564, 1571, 1577, 1584, 1590, 1597, 1603, 1609, 1615,
	1621, 1627, 1633, 1639, 1645, 1651, 1656, 1662, 1667, 1673,
	1678, 1684, 1689, 1694, 1700, 1705, 1710, 1715, 1720, 1725,
	1730, 1735, 1739, 1744, 1749, 1754, 1758, 1763, 1767, 1772,
	1776, 1781, 1785, 1789, 1794, 1798, 1802, 1806, 1810, 1814,
	1819, 1823, 1826, 1830, 1834, 1838, 1842, 1846, 1850, 1853,
	1857, 1861, 1864, 1868, 1871, 1875, 1878, 1882, 1885, 1889,
	1892, 1895, 1899, 1902, 1905, 1908, 1911, 1915, 1918, 1921,
	1924, 1927, 1930, 1933, 1936, 1939, 1942, 1945, 1947, 1950,
	1953, 1956, 1959, 1961, 1964, 1967, 1969, 1972, 1975, 1977,
	1980, 1983, 1985, 1988, 1990, 1993, 1995, 1997, 2000, 2002,
	2005, 2007, 2009, 2012, 2014, 2016, 2018, 2021, 2023, 2025,
	2027, 2029, 2032, 2034, 2036, 2038, 2040, 2042, 2044, 2046,
	2048, 2050, 2052, 2054, 2056, 2058, 2060, 2062, 2064, 2066,
	2067, 2069, 2071, 2073, 2075, 2076, 2078, 2080, 2082, 2083,
	2085, 2087, 2089, 2090, 2092, 2093, 2095, 2097, 2098, 2100,
	2102, 2103, 2105, 2106, 2108, 2109, 2111, 2112, 2114, 2115,
	2117, 2118, 2120, 2121, 2122, 2124, 2125, 2127, 2128, 2129,
	2131, 2132, 2133, 2135, 2136, 2137, 2139, 2140, 2141, 2142,
	2144, 2145, 2146, 2147, 2149, 2150, 2151, 2152, 2153, 2155,
	2156, 2157, 2158, 2159, 2160, 2161, 2163, 2164, 2165, 2166,
	2167, 2168, 2169, 2170, 2171, 2172, 2173, 2174, 2175, 2176,
	2177, 2178, 2179, 2180, 2181, 2182, 2183, 2184, 2185, 2186,
	2187, 2188, 2189, 2190, 2191, 2191, 2192, 2193, 2194, 2195,
	2196, 2197, 2198, 2198, 2199, 2200, 2201, 2202, 2203, 2203,
	2204, 2205, 2206, 2207, 2207, 2208, 2209, 2210, 2210, 2211,
	2212, 2213, 2213, 2214, 2215, 2216, 2216, 2217, 2218, 2218,
	2219, 2220, 2220, 2221, 2222, 2222, 2223, 2224, 2224, 2225,
	2226, 2226, 2227, 2228, 2228, 2229, 2229, 2230, 2231, 2231,
	2232, 2233, 2233, 2234, 2234, 2235, 2235, 2236, 2237, 2237,
	2238, 2238, 2239, 2239, 2240, 2240, 2241, 2242, 2242, 2243,
	2243, 2244, 2244, 2245, 2245, 2246, 2246, 2247, 2247, 2248,
	2248, 2249, 2249, 2250, 2250, 2250, 2251, 2251, 2252, 2252,
	2253, 2253, 2254, 2254, 2255, 2255, 2255, 2256, 2256, 2257,
	2257, 2258, 2258, 2258, 2259, 2259, 2260, 2260, 2260, 2261,
	2261, 2262, 2262, 2262, 2263, 2263, 2263, 2264, 2264, 2265,
	2265, 2265, 2266, 2266, 2266, 2267, 2267, 2267, 2268, 2268,
	2268, 2269, 2269, 2269, 2270, 2270, 2270, 2271, 2271, 2271,
	2272, 2272, 2272, 2273, 2273, 2273, 2274, 2274, 2274, 2275,
	2275, 2275, 2275, 2276, 2276, 2276, 2277, 2277, 2277, 2277
};
/****************************************************************
ISO AUTO
****************************************************************/
const struct reg_entry seix006_iso_auto[] = {
	{0x01E5, 0x00, REG_BITS_8},
};

int32_t sizeof_seix006_iso_auto = sizeof(seix006_iso_auto);

/****************************************************************
MANUAL ISO 100
****************************************************************/
const struct reg_entry seix006_iso_100[] = {
	{0x01E5, 0x07, REG_BITS_8},
};

int32_t sizeof_seix006_iso_100 = sizeof(seix006_iso_100);
/****************************************************************
MANUAL ISO 200
****************************************************************/
const struct reg_entry seix006_iso_200[] = {
	{0x01E5, 0x0A, REG_BITS_8},
};

int32_t sizeof_seix006_iso_200 = sizeof(seix006_iso_200);

/****************************************************************
MANUAL ISO 400
****************************************************************/
const struct reg_entry seix006_iso_400[] = {
	{0x01E5, 0x0D, REG_BITS_8},
};

int32_t sizeof_seix006_iso_400 = sizeof(seix006_iso_400);

/****************************************************************
MANUAL ISO 800
****************************************************************/
const struct reg_entry seix006_iso_800[] = {
	{0x01E5, 0x10, REG_BITS_8},
};

int32_t sizeof_seix006_iso_800 = sizeof(seix006_iso_800);

/****************************************************************
MANUAL ISO 1600
****************************************************************/
const struct reg_entry seix006_iso_1600[] = {
	{0x01E5, 0x13, REG_BITS_8},
};

int32_t sizeof_seix006_iso_1600 = sizeof(seix006_iso_1600);

/****************************************************************
focus mode auto
****************************************************************/
const struct reg_entry seix006_focus_mode_auto[] = {
	{0x002E, 0x02, REG_BITS_8},
	{0x0012, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_focus_mode_auto = sizeof(seix006_focus_mode_auto);

/****************************************************************
focus mode continuous
****************************************************************/
const struct reg_entry seix006_focus_mode_continuous[] = {
	{0x002E, 0x01, REG_BITS_8},
	{0x0012, 0x01, REG_BITS_8},
};

int32_t sizeof_seix006_focus_mode_continuous =
		sizeof(seix006_focus_mode_continuous);

/****************************************************************
primary focus window continuous
****************************************************************/
const struct reg_entry seix006_primary_focus_window_continuous[] = {
	{0x4C4C, 0x2E04, REG_BITS_16},
	{0x4C4E, 0xC502, REG_BITS_16},
	{0x4C50, 0x1702, REG_BITS_16},
	{0x4C52, 0x1702, REG_BITS_16},
};

int32_t sizeof_seix006_primary_focus_window_continuous =
		sizeof(seix006_primary_focus_window_continuous);

/****************************************************************
primary focus window auto
****************************************************************/
const struct reg_entry seix006_primary_focus_window_auto[] = {
	{0x4C4C, 0xC604, REG_BITS_16},
	{0x4C4E, 0x5D03, REG_BITS_16},
	{0x4C50, 0xE600, REG_BITS_16},
	{0x4C52, 0xE600, REG_BITS_16},
};

int32_t sizeof_seix006_primary_focus_window_auto =
		sizeof(seix006_primary_focus_window_auto);

/**************** End of file ****************/
