/*
 * Decompiled with CFR 0.152.
 */
package proguard.preverify;

import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.preverify.CodePreverifier;

public class Preverifier {
    private final Configuration configuration;

    public Preverifier(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool) {
        classPool.classesAccept(new ClassCleaner());
        ClassVisitor classVisitor = new AllMethodVisitor(new AllAttributeVisitor(new CodePreverifier(this.configuration.microEdition)));
        if (!this.configuration.microEdition) {
            classVisitor = new ClassVersionFilter(0x320000, Integer.MAX_VALUE, classVisitor);
        }
        classPool.classesAccept(classVisitor);
    }
}

