package mirrg.swing.helium.property;

public class PropertyInteger extends Property<Integer>
{

	public int value;

	public PropertyInteger(String id, String name, int value)
	{
		super(id, name);
		this.value = value;
	}

	@Override
	public String getString()
	{
		return Integer.toString(value);
	}

	@Override
	public boolean setString(String string)
	{
		try {
			value = Integer.parseInt(string, 10);
		} catch (NumberFormatException e) {
			return false;
		}
		return true;
	}

	@Override
	public String getType()
	{
		return "Integer";
	}

}
