package mirrg.simulation.cart.almandine.gui.toolcursor;

import static mirrg.swing.helium.GroupBuilder.*;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Optional;

import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JComponent;

import mirrg.swing.helium.TitledGroup;

public class Tab
{

	public String localizedName;
	public ArrayList<TabItem> tabItems = new ArrayList<>();

	public Tab(String localizedName)
	{
		this.localizedName = localizedName;
	}

	public void addTabItem(TabItem tabItem)
	{
		tabItems.add(tabItem);
	}

	public JComponent createComponent()
	{
		JComponent component = new TitledGroup(localizedName);

		GroupLayout layout = new GroupLayout(component);

		{
			Object[] components = new Object[tabItems.size()];

			for (int i = 0; i < tabItems.size(); i++) {
				components[i] = tabItems.get(i).createComponent();
			}

			group(components).align(Alignment.CENTER).apply(layout);
		}

		component.setLayout(layout);

		return component;
	}

	public Optional<TabItem> find(KeyEvent keyEvent)
	{
		for (TabItem tabItem : tabItems) {
			if (tabItem.match(keyEvent)) return Optional.of(tabItem);
		}
		return Optional.empty();
	}

}
