package mirrg.simulation.cart.almandine.gui;

import static mirrg.swing.helium.GroupBuilder.*;

import javax.swing.GroupLayout;
import javax.swing.JButton;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.RegistryToolCursor;
import mirrg.swing.helium.DialogMirrg;

public class DialogTools extends DialogMirrg
{

	public DialogTools(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine.getFrame(), "ツール");

		{
			GroupLayout layout = new GroupLayout(getContentPane());

			group(

				// <!-- 時間操作系
				group(
					button("■", frameGameAlmandine, 1, 0),
					button("[> 1", frameGameAlmandine, 1, 1),
					button("[> 3", frameGameAlmandine, 1, 3),
					button("[> 10", frameGameAlmandine, 1, 10),
					button("[> 30", frameGameAlmandine, 1, 30),
					button("[> 60", frameGameAlmandine, 1, 60),
					button("[> 100", frameGameAlmandine, 1, 100)
				),

				group(
					button("[>[> 60x3", frameGameAlmandine, 3, 60),
					button("[>[> 60x10", frameGameAlmandine, 10, 60),
					button("[>[> 60x30", frameGameAlmandine, 30, 60),
					button("[>[> 60x60", frameGameAlmandine, 60, 60)
				),
				// -->

				// Mod追加分
				RegistryToolCursor.instance.createComponent()

			).apply(layout);

			layout.setAutoCreateGaps(true);
			layout.setAutoCreateContainerGaps(true);
			setLayout(layout);
		}

		setDefaultCloseOperation(HIDE_ON_CLOSE);
		pack();
		setLocationByPlatform(true);
	}

	private JButton button(String title, IFrameGameAlmandine frameGameAlmandine, double secondPerTick, int tickPerFrame)
	{
		JButton button = new JButton(title);
		button.addActionListener(e -> {
			frameGameAlmandine.getGame().getTickPerFrame().value = tickPerFrame;
			frameGameAlmandine.getGame().getSecondPerTick().value = secondPerTick;
		});
		return button;
	}

}
