package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ToolCursorSelectArea extends ToolCursor
{

	public ToolCursorSelectArea(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			begin = getCoord(e.mouseEvent);
			mouseDragged(e.mouseEvent);
		});
		eventManager.register(NitrogenEventMouse.Released.class, e -> {
			mouseDragged(e.mouseEvent);

			if (begin == null) return;
			if (end == null) return;

			Rectangle area = new Rectangle(
				Math.min(begin.x, end.x),
				Math.min(begin.y, end.y),
				Math.abs(end.x - begin.x),
				Math.abs(end.y - begin.y));

			begin = null;
			end = null;

			//

			if (e.mouseEvent.isControlDown()) {
				// 選択解除しない、XOR選択モード

			Factory.filterClass(getFactory().getEntities(), Primary.class)
				.filter(primary -> {
					try {
						return primary.isContained(area);
					} catch (IllegalEntityIdException e1) {
						return false;
					}
				})
				.forEach(furniture -> furniture.selected = !furniture.selected);

		} else {
			// 選択解除する。

			getFactory().resetSelection();

			Factory.filterClass(getFactory().getEntities(), Primary.class)
				.filter(primary -> {
					try {
						return primary.isContained(area);
					} catch (IllegalEntityIdException e1) {
						return false;
					}
				})
				.forEach(furniture -> furniture.selected = true);

		}

	}	);
		eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
			mouseDragged(e.mouseEvent);
		});
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (begin == null) return;
			if (end == null) return;

			Rectangle area = new Rectangle(
				Math.min(begin.x, end.x),
				Math.min(begin.y, end.y),
				Math.abs(end.x - begin.x),
				Math.abs(end.y - begin.y));

			frameGameAlmandine.doTranslate(e.graphics, () -> {
				Factory.filterClass(getFactory().getEntities(), Primary.class)
					.filter(primary -> {
						try {
							return primary.isContained(area);
						} catch (IllegalEntityIdException e1) {
							return false;
						}
					})
					.forEach(furniture -> {
						try {
							furniture.drawHover(e.graphics);
						} catch (IllegalEntityIdException e1) {

						}
					});

				e.graphics.setColor(new Color(0x405ec163, true));
				e.graphics.fill(area);
				e.graphics.setColor(new Color(0xd05ec163, true));
				e.graphics.draw(area);
			});
		});
	}

	private Point begin;
	private Point end;

	public void mouseDragged(MouseEvent e)
	{
		end = getCoord(e);
	}

	@Override
	public String getLocalizedName()
	{
		return "範囲選択";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左ドラッグで範囲に完全に含まれるアイテムを選択、Ctrlで選択切り替え";
	}

}
