package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.IPrimaryResizable;

public class ToolCursorResize extends ToolCursor
{

	private Point begin;
	private Point end;

	public ToolCursorResize(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			begin = getCoord(e.mouseEvent);
			end = getCoord(e.mouseEvent);
		});
		eventManager.register(NitrogenEventMouse.Released.class, e -> {
			begin = null;
			end = null;
		});
		eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
			Point now = getCoord(e.mouseEvent);

			Factory.filterSelected(Factory.filterClass(getFactory().getEntities(), Primary.class))
				.forEach(primary -> {
					if (primary instanceof IPrimaryResizable) {
						((IPrimaryResizable) primary).resizeOffset(now.x - end.x, now.y - end.y);
					}
				});

			end = now;
		});
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (begin == null) return;
			if (end == null) return;

			frameGameAlmandine.doTranslate(e.graphics, () -> {
				e.graphics.setColor(new Color(0xff0000));
				e.graphics.drawLine(begin.x, begin.y, end.x, end.y);
			});

		});
	}

	@Override
	public String getLocalizedName()
	{
		return "リサイズ";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左ドラッグで選択中のエンティティのサイズを変更";
	}

}
