package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.event.MouseEvent;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ToolCursorDelete extends ToolCursor
{

	public ToolCursorDelete(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		new ModuleClickEntity<Primary>(frameGameAlmandine, button -> button == MouseEvent.BUTTON1, (e, entity) -> {
			entity.deleteLater();
		}, (factory, point) -> {
			return Factory.filterHover(Factory.filterClass(factory.getEntities(), Primary.class), point);
		}).apply(this);
		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			if (e.mouseEvent.getButton() == MouseEvent.BUTTON3) {
				Factory.filterSelected(Factory.filterClass(getFactory().getEntities(), Primary.class))
					.forEach(Primary::deleteLater);
			}
		});
	}

	@Override
	public String getLocalizedName()
	{
		return "削除";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左クリックした対象を削除、右クリックで選択中の物を一括削除";
	}

}
