package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart.PositionStation;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;

public class StationIntegrate extends StationThrough
{

	@Deprecated
	public StationIntegrate()
	{
		super();
	}

	public String direction;

	public StationIntegrate(GameAlmandine game, Point point, int radius)
	{
		super(game, point, radius);
	}

	@Override
	protected int getColor()
	{
		return 0x000991;
	}

	@Override
	public void draw(Graphics2D graphics)
	{
		super.draw(graphics);

		graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 12));
		graphics.setColor(Color.black);
		String text = "Integrate";
		int width = graphics.getFontMetrics().stringWidth(text);
		graphics.drawString(text, x - width / 2, y - radius - 6);

		drawMarkerDirection(graphics, direction, false);

	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		if (direction == null) direction = "UNDEFINED";
		Cart cart = getCartPrimary().orElse(null);
		if (cart == null) return;

		Direction direction2 = Direction.valueOf(direction);
		if (direction2 == null || direction2 == Direction.UNDEFINED) return;

		RailBase rail = getRail(direction2).orElse(null);
		if (rail == null) return;

		if (rail.getId() == ((PositionStation) cart.position).idRailFrom) {
			super.tick(deltaSecond);
			return;
		}

		emitCart(cart, rail);
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyComboBox("Direction", Stream.of(Direction.values()), () -> Direction.valueOf(direction), direction -> {
			this.direction = direction.name();
			return true;
		});
	}

}
