package mirrg.simulation.cart.almandine.mods.vanilla.rails;

import java.awt.Point;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;

public class RailAutoDistance extends RailBase
{

	@Deprecated
	public RailAutoDistance()
	{
		super();
	}

	/**
	 * [m]
	 */
	public double distancePerPixel;

	public RailAutoDistance(GameAlmandine game, StationBase begin, StationBase end, double distancePerPixel)
	{
		super(game, begin, end);
		this.distancePerPixel = distancePerPixel;
	}

	@Override
	protected int getColor()
	{
		return 0x8c4d00;
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyDouble("DistancePerPixel", "m/px", () -> distancePerPixel, distancePerPixel -> {
			if (distancePerPixel < 0) return false;
			this.distancePerPixel = distancePerPixel;
			return true;
		});
		dialogProperty.addPropertyDouble("Distance", "m", () -> {
			try {
				return getDistance();
			} catch (IllegalEntityIdException e) {
				return 0;
			}
		}, distancePerPixel -> {
			return false;
		});
	}

	@Override
	public double getDistance() throws IllegalEntityIdException
	{
		Point pointBegin = getEntity(idBegin).getPoint();
		Point pointEnd = getEntity(idEnd).getPoint();

		return pointBegin.distance(pointEnd) * distancePerPixel;
	}

}
