package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Point;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;

public class FurnitureConsumer extends FurnitureIO
{

	@Deprecated
	public FurnitureConsumer()
	{
		super();
	}

	public FurnitureConsumer(GameAlmandine game, Point point, double duration) throws IllegalEntityIdException
	{
		super(game, point, duration);
	}

	@Override
	protected int getBackColor()
	{
		return 0x606080;
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		super.tick(deltaSecond);

		gauge.amount -= deltaSecond;
		if (gauge.amount <= 0) {
			IStackSlab stackSlab = slot.slot.tryPop(1);
			if (stackSlab != null && stackSlab.getAmount() == 1) {
				gauge.amount = gauge.capacity;
			} else {
				gauge.amount = 0;
			}
		}

	}

}
