package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.simulation.cart.almandine.mods.vanilla.slots.SlotModule;

public class FurnitureBuffer extends Furniture
{

	public SlotModule slot;

	@Deprecated
	public FurnitureBuffer()
	{
		super();
	}

	public FurnitureBuffer(GameAlmandine game, Point point) throws IllegalEntityIdException
	{
		super(game, new Bound(point.x - 10, point.y - 10, 20, 20));
		slot = new SlotModule(game, new Bound(point.x - 8, point.y - 8, 16, 16), 10);
	}

	protected Stream<SlotBase> getSlots()
	{
		return Stream.of(slot);
	}

	@Override
	protected void drawBody(Graphics2D graphics)
	{
		graphics.setColor(new Color(0xc0c0c0));
		graphics.fill(bound.createShape());
		graphics.setColor(new Color(0x404040));
		graphics.draw(bound.grow(1, 1, 0, 0).createShape());
	}

}
