package mirrg.simulation.cart.almandine.mods.vanilla;

import static java.awt.event.KeyEvent.*;

import java.awt.Point;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.RegistryDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.RegistryToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ShortcutKey;
import mirrg.simulation.cart.almandine.gui.toolcursor.Tab;
import mirrg.simulation.cart.almandine.gui.toolcursor.TabItem;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mod.HAlmandineForge;
import mirrg.simulation.cart.almandine.mod.ModBase;
import mirrg.simulation.cart.almandine.mod.NitrogenEventAlmandine;
import mirrg.simulation.cart.almandine.mods.vanilla.furnitures.FurnitureBuffer;
import mirrg.simulation.cart.almandine.mods.vanilla.furnitures.FurnitureConsumer;
import mirrg.simulation.cart.almandine.mods.vanilla.furnitures.FurnitureStation;
import mirrg.simulation.cart.almandine.mods.vanilla.furnitures.FurnitureStation.ICreatorStation;
import mirrg.simulation.cart.almandine.mods.vanilla.furnitures.FurnitureSupplier;
import mirrg.simulation.cart.almandine.mods.vanilla.furnitures.FurnitureThermometer;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.AreaBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.AreaEnvironmentThermo;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.AreaProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.RegistryProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationCovering;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationDecovering;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationExport;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationImport;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationIntegrate;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationScripted;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationThrough;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorDelete;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorMove;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorProperty;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorPutArea;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorPutArm;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorPutCart;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorPutFurniture;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorPutRail;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorPutRailAutoDistance;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorResize;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorScreen;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorSelect;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ToolCursorSelectArea;
import mirrg.swing.helium.property.PropertyString;

public class ModVanilla extends ModBase
{

	public static Tab tabScreen;
	public static Tab tabEdit;
	public static Tab tabMachine;
	public static Tab tabRail;
	public static Tab tabRail2;
	public static Tab tabThermo;

	public ModVanilla()
	{
		HAlmandineForge.eventManager.register(NitrogenEventAlmandine.InitToolCursor.class, this::handle);

		HAlmandineForge.eventManager.register(NitrogenEventAlmandine.InitDialogProperty.class, this::handle);
		HAlmandineForge.eventManager.register(NitrogenEventAlmandine.CreatedGame.class, e -> {

			e.game.getIdDialogProperty().value = "vanilla:default";

			e.game.managerProperty.getOrCreateProperty(
				PropertyString::new,
				PropertyString.class,
				"vanilla:basic",
				"stackslab.providerEnvironmentDefault",
				"背景のProviderEnvironment ID[id]").get();

		});

		RegistryProviderEnvironment.instance.register("vanilla", "basic", new ProviderEnvironmentBasic());
		RegistryProviderEnvironment.instance.register("vanilla", "thermo", new ProviderEnvironmentThermo());

	}

	public void handle(NitrogenEventAlmandine.InitToolCursor event)
	{
		Supplier<IFrameGameAlmandine> sfga = event.supplierFrameGameAlmandine;

		tabScreen = tab("表示");
		{
			Tab tab = tabScreen;
			tab.addTabItem(tabItem("？画面", key(VK_ESCAPE), sfga, ToolCursorScreen::new));
		}

		tabEdit = tab("編集");
		{
			Tab tab = tabEdit;
			tab.addTabItem(tabItem("？選択", key(VK_S), sfga, ToolCursorSelect::new));
			tab.addTabItem(tabItem("？範囲選択", key(VK_S).shift(), sfga, ToolCursorSelectArea::new));
			tab.addTabItem(tabItem("☆移動", key(VK_M), sfga, ToolCursorMove::new));
			tab.addTabItem(tabItem("☆リサイズ", key(VK_M).shift(), sfga, ToolCursorResize::new));
			tab.addTabItem(tabItem("☆プロパティ", key(VK_SLASH), sfga, ToolCursorProperty::new));
			tab.addTabItem(tabItem("☆削除", key(VK_DELETE), sfga, ToolCursorDelete::new));
		}

		tabMachine = tab("機械：基本");
		{
			Tab tab = tabMachine;
			tab.addTabItem(tabItem("◆アーム", key(VK_A), sfga, ToolCursorPutArm::new));
			tab.addTabItem(tabItem("■スラブバッファ", key(VK_B), sfga, (g, point) -> new FurnitureBuffer(g, point)));
			tab.addTabItem(tabItem("■生産機", key(VK_I), sfga, (g, point) -> new FurnitureSupplier(g, point, 30 * 60)));
			tab.addTabItem(tabItem("■消費機", key(VK_O), sfga, (g, point) -> new FurnitureConsumer(g, point, 30 * 60)));
		}

		tabRail = tab("運送：基本");
		{
			Tab tab = tabRail;
			tab.addTabItem(tabItem("◆レール", key(VK_R), sfga, ToolCursorPutRail::new));
			tab.addTabItem(tabItem("◆自動距離調整レール", key(VK_R).shift(), sfga, ToolCursorPutRailAutoDistance::new));
			tab.addTabItem(tabItem("◆貨車", key(VK_C), sfga, ToolCursorPutCart::new));
			tab.addTabItem(tabItem("●通過駅", key(VK_S).alt(), sfga, StationThrough::new));
			tab.addTabItem(tabItem("●積み込み駅", key(VK_I).alt(), sfga, StationImport::new));
			tab.addTabItem(tabItem("●降ろし駅", key(VK_O).alt(), sfga, StationExport::new));
		}

		tabRail2 = tab("運送：高度");
		{
			Tab tab = tabRail2;
			tab.addTabItem(tabItem("●方向指示駅", key(VK_D).alt(), sfga, StationIntegrate::new));
			tab.addTabItem(tabItem("●スクリプト駅", key(VK_P).alt(), sfga, StationScripted::new));
		}

		tabThermo = tab("熱");
		{
			Tab tab = tabThermo;
			tab.addTabItem(tabItem("■温度計", key(VK_T), sfga, FurnitureThermometer::new));
			tab.addTabItem(tabItem("●カバー取り付け駅", key(VK_C).alt(), sfga, (g, point, r) -> new StationCovering(g, point, r, 8 * 60)));
			tab.addTabItem(tabItem("●カバー取り外し駅", key(VK_C).alt().shift(), sfga, (g, point, r) -> new StationDecovering(g, point, r, 8 * 60)));
			tab.addTabItem(tabItemArea("□熱定数領域", key(VK_T).shift(), sfga, AreaEnvironmentThermo::new));
			tab.addTabItem(tabItem("？環境調査", key(VK_SLASH).shift(), sfga, ToolCursorEnvironment::new));
			tab.addTabItem(tabItemArea("□環境プロバイダ領域", key(VK_P), sfga, AreaProviderEnvironment::new));
		}

	}

	public void handle(NitrogenEventAlmandine.InitDialogProperty event)
	{
		RegistryDialogProperty.instance.register(getModId(), "default", DialogPropertyToolCursor::new);
	}

	public static Tab tab(String localizedName)
	{
		Tab tab = new Tab(localizedName);
		RegistryToolCursor.instance.addTab(tab);
		return tab;
	}

	public static ShortcutKey key(int keyCode)
	{
		return new ShortcutKey(keyCode);
	}

	public static TabItem tabItem(
		String localizedName,
		ShortcutKey shortcutKey,
		Supplier<IFrameGameAlmandine> supplierFrameGameAlmandine,
		Function<IFrameGameAlmandine, ToolCursor> creatorToolCursor)
	{
		return new TabItem(
			localizedName,
			shortcutKey,
			() -> {
				supplierFrameGameAlmandine.get().setToolCursor(creatorToolCursor.apply(supplierFrameGameAlmandine.get()));
			});
	}

	public static TabItem tabItem(
		String localizedName,
		ShortcutKey shortcutKey,
		Supplier<IFrameGameAlmandine> supplierFrameGameAlmandine,
		ICreatorFurniture creatorFurniture)
	{
		return tabItem(
			localizedName,
			shortcutKey,
			supplierFrameGameAlmandine,
			frameGameAlmandine -> new ToolCursorPutFurniture(
				frameGameAlmandine,
				point -> creatorFurniture.create(frameGameAlmandine.getGame(), point),
				localizedName));
	}

	public static TabItem tabItem(
		String localizedName,
		ShortcutKey shortcutKey,
		Supplier<IFrameGameAlmandine> supplierFrameGameAlmandine,
		ICreatorStation creatorStation)
	{
		return tabItem(
			localizedName,
			shortcutKey,
			supplierFrameGameAlmandine,
			frameGameAlmandine -> new ToolCursorPutFurniture(
				frameGameAlmandine,
				point -> new FurnitureStation(frameGameAlmandine.getGame(), point, creatorStation),
				localizedName));
	}

	public static TabItem tabItemArea(
		String localizedName,
		ShortcutKey shortcutKey,
		Supplier<IFrameGameAlmandine> supplierFrameGameAlmandine,
		BiFunction<GameAlmandine, Bound, AreaBase> creatorArea)
	{
		return tabItem(
			localizedName,
			shortcutKey,
			supplierFrameGameAlmandine,
			frameGameAlmandine -> new ToolCursorPutArea(
				frameGameAlmandine,
				creatorArea));
	}

	public static interface ICreatorFurniture
	{

		public Furniture create(GameAlmandine game, Point point) throws IllegalEntityIdException;

	}

	@Override
	public String getModId()
	{
		return "vanilla";
	}

}
