/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui.toolcursor;

import java.awt.event.KeyEvent;
import java.util.Optional;
import javax.swing.JButton;
import mirrg.simulation.cart.almandine.gui.toolcursor.ShortcutKey;
import mirrg.swing.helium.GroupBuilder;

public class TabItem {
    private String localizedName;
    private Optional<ShortcutKey> optionalShortcutKey;
    private Runnable listener;

    public TabItem(String localizedName, ShortcutKey shortcutKey, Runnable listener) {
        this.localizedName = localizedName;
        this.optionalShortcutKey = Optional.ofNullable(shortcutKey);
        this.listener = listener;
    }

    public String getText() {
        return this.localizedName + this.optionalShortcutKey.map(shortcutKey -> " (" + shortcutKey.getText() + ")").orElse("");
    }

    public JButton createButton() {
        JButton button = new JButton(this.getText());
        button.addActionListener(e -> this.action());
        return button;
    }

    public GroupBuilder createComponent() {
        return GroupBuilder.group((Object[])new Object[]{this.createButton()});
    }

    public void action() {
        this.listener.run();
    }

    public boolean match(KeyEvent keyEvent) {
        return this.optionalShortcutKey.map(shortcutKey -> shortcutKey.match(keyEvent)).orElse(false);
    }
}

