/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.ui.model;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jdesktop.application.AbstractBean;
import textkeymatcher.service.PredefinedSimpleSplitCharColumnSplitter;

/**
 * データインポートダイアログのモデル
 * @author seraphy
 */
public class ImportDataDialogModel extends AbstractBean {

    public static final String PROPERTY_LOAD_FILE = "loadFile";
    
    public static final String PROPERTY_DIRECT = "direct";

    public enum SourceType {
        LOAD_FILE, DIRECT;
        
        public boolean isLoadFile() {
            return this == LOAD_FILE;
        }
        
        public boolean isDirect() {
            return this == DIRECT;
        }
    }
    
    private SourceType sourceType = SourceType.LOAD_FILE;
    
    
    public boolean isLoadFile() {
        return sourceType.isLoadFile();
    }
    
    public boolean isDirect() {
        return sourceType.isDirect();
    }
    
    public void setLoadFile(boolean enable) {
        setSourceType(enable ? SourceType.LOAD_FILE : SourceType.DIRECT);
    }
    
    public void setDirect(boolean enable) {
        setSourceType(!enable ? SourceType.LOAD_FILE : SourceType.DIRECT);
    }
    
    public SourceType getSourceType() {
        return sourceType;
    }
    
    public void setSourceType(SourceType sourceType) {
        if (sourceType == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceType != sourceType) {
            boolean oldLoadFile = this.sourceType.isLoadFile();
            boolean oldDirect = this.sourceType.isDirect();

            this.sourceType = sourceType;
            
            boolean newLoadFile = this.sourceType.isLoadFile();
            boolean newDirect = this.sourceType.isDirect();
            
            firePropertyChange(PROPERTY_LOAD_FILE, oldLoadFile, newLoadFile);
            firePropertyChange(PROPERTY_DIRECT, oldDirect, newDirect);
            checkValid();
        }
    }
    
    private String sourceFile;
    
    public static final String PROPERTY_SOURCE_FILE = "sourceFile";
    
    public String getSourceFile() {
        return sourceFile;
    }
    
    public void setSourceFile(String sourceFile) {
        String oldValue = this.sourceFile;
        this.sourceFile = sourceFile;
        firePropertyChange(PROPERTY_SOURCE_FILE, oldValue, sourceFile);
        checkValid();
    }
    
    private Charset charset = Charset.defaultCharset();
    
    public static final String PROPERTY_CHARSET = "charset";
    
    public Charset getCharset() {
        return charset;
    }
    
    public void setCharset(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException();
        }
        Charset oldValue = this.charset;
        this.charset = charset;
        firePropertyChange(PROPERTY_CHARSET, oldValue, charset);
    }
    
    public String directText;
    
    public static final String PROPERTY_DIRECT_TEXT = "directText";
    
    public String getDirectText() {
        return directText;
    }
    
    public void setDirectText(String directText) {
        String oldValue = this.directText;
        this.directText = directText;
        firePropertyChange(PROPERTY_DIRECT_TEXT, oldValue, directText);
        checkValid();
    }
    
    public enum ParserType {
        
        SIMPLE_SPLIT, REG_EXP;
        
        public boolean isSimpleSplit() {
            return this == SIMPLE_SPLIT;
        }
        
        public boolean isRegExp() {
            return this == REG_EXP;
        }
    }
    
    private ParserType parserType = ParserType.SIMPLE_SPLIT;
    
    public static final String PROPERTY_SIMPLE_SPLIT = "simpleSplit";
    
    public static final String PROPERTY_REG_EXP = "regExp";
    
    public boolean isSimpleSplit() {
        return parserType.isSimpleSplit();
    }
    
    public boolean isRegExp() {
        return parserType.isRegExp();
    }
    
    public void setSimpleSplit(boolean enable) {
        setParserType(enable ? ParserType.SIMPLE_SPLIT : ParserType.REG_EXP);
    }

    public void setRegExp(boolean enable) {
        setParserType(!enable ? ParserType.SIMPLE_SPLIT : ParserType.REG_EXP);
    }
    
    public ParserType getParserType() {
        return parserType;
    }
    
    public void setParserType(ParserType parserType) {
        if (parserType == null) {
            throw new IllegalArgumentException();
        }
        if (this.parserType != parserType) {
            boolean oldSimpleSplit = this.parserType.isSimpleSplit();
            boolean oldRegExp = this.parserType.isRegExp();
            
            this.parserType = parserType;
            
            boolean newSimpleSplit = this.parserType.isSimpleSplit();
            boolean newRegExp = this.parserType.isRegExp();
            
            firePropertyChange(PROPERTY_SIMPLE_SPLIT, oldSimpleSplit, newSimpleSplit);
            firePropertyChange(PROPERTY_REG_EXP, oldRegExp, newRegExp);
            checkValid();
        }
    }
    
    private PredefinedSimpleSplitCharColumnSplitter simpleSplitType = PredefinedSimpleSplitCharColumnSplitter.TAB_SPLIT;
    
    public static final String PROPERTY_SIMPLE_SPLIT_TYPE = "simpleSplitType";
    
    public PredefinedSimpleSplitCharColumnSplitter getSimpleSplitType() {
        return simpleSplitType;
    }
    
    public void setSimpleSplitType(PredefinedSimpleSplitCharColumnSplitter simpleSplitType) {
        if (simpleSplitType == null) {
            throw new IllegalArgumentException();
        }
        PredefinedSimpleSplitCharColumnSplitter oldValue = this.simpleSplitType;
        this.simpleSplitType = simpleSplitType;
        firePropertyChange(PROPERTY_SIMPLE_SPLIT_TYPE, oldValue, simpleSplitType);
        checkValid();
    }
    
    private String regExpText;
    
    public static final String PROPERTY_REG_EXP_TEXT = "regExpText";
    
    public String getRegExpText() {
        return regExpText;
    }
    
    public void setRegExpText(String regExpText) {
        String oldValue = this.regExpText;
        this.regExpText = regExpText;
        firePropertyChange(PROPERTY_REG_EXP_TEXT, oldValue, regExpText);
        checkValid();
    }
    
    
    private int keyColumn;
    
    public static final String PROPERTY_KEY_COLUMN = "keyColumn";
    
    public int getKeyColumn() {
        return keyColumn;
    }
    
    public void setKeyColumn(int keyColumn) {
        int oldValue = this.keyColumn;
        this.keyColumn = keyColumn;
        firePropertyChange(PROPERTY_KEY_COLUMN, oldValue, keyColumn);
        checkValid();
    }
    
    
    private int valueColumn = 1;
    
    public static final String PROPERTY_VALUE_COLUMN = "valueColumn";
    
    public int getValueColumn() {
        return valueColumn;
    }
    
    public void setValueColumn(int valueColumn) {
        int oldValue = this.valueColumn;
        this.valueColumn = valueColumn;
        firePropertyChange(PROPERTY_VALUE_COLUMN, oldValue, valueColumn);
        checkValid();
    }
    
    private boolean fullLine;
    
    public static final String PROPERTY_FULL_LINE = "fullLine";
    
    public boolean isFullLine() {
        return fullLine;
    }
    
    public void setFullLine(boolean fullLine) {
        boolean oldValue = this.fullLine;
        this.fullLine = fullLine;
        firePropertyChange(PROPERTY_FULL_LINE, oldValue, fullLine);
        checkValid();
    }
    
    
    private boolean valid;
    
    public static final String PROPERTY_VALID = "valid";
    
    public boolean isValid() {
        return valid;
    }
    
    protected void setValid(boolean valid) {
        boolean oldValue = this.valid;
        this.valid = valid;
        firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }
    
    public void checkValid() {
        boolean v = true;
        if (isLoadFile() && StringUtils.isBlank(getSourceFile())) {
            v = false;
        }
        if (isRegExp() && StringUtils.isBlank(getRegExpText())) {
            v = false;
        }
        if (keyColumn < 0) {
            v = false;
        }
        if (valueColumn < 0 && !fullLine) {
            v = false;
        }
        setValid(v);
    }
    
    private String title;
    
    public static final String PROPERTY_TITLE = "title";
    
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }
    
    public void copyTo(ImportDataDialogModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        
        model.setTitle(title);
        
        model.setSourceType(sourceType);
        model.setSourceFile(sourceFile);
        model.setCharset(charset);
        model.setDirectText(directText);
        
        model.setParserType(parserType);
        model.setSimpleSplitType(simpleSplitType);
        model.setRegExpText(regExpText);
        
        model.setKeyColumn(keyColumn);
        model.setValueColumn(valueColumn);
        model.setFullLine(fullLine);
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
 }
