/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.ui;

import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

/**
 *
 * @author seraphy
 */
public final class ErrorDialog {
 
    private ErrorDialog() {
        super();
    }
   
    public static String getErrorText(Throwable ex) {
        // エラーメッセージ
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (ex != null) {
            ex.printStackTrace(pw);
        }
        return sw.toString();
    }
    
    /**
     * モードレスダイアログとしてエラーダイアログを表示する.
     * @param ex 例外
     */
    public static void showErrorDialog(Throwable ex) {
        // エラーメッセージ
        final String msg = getErrorText(ex);

        // エラーダイアログを表示する.(非同期)
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                JTextArea textArea = new JTextArea(msg);
                textArea.setEditable(false);
                
                JScrollPane sp = new JScrollPane(textArea);
                sp.setPreferredSize(new Dimension(300, 200));
                
                JOptionPane pane = new JOptionPane(sp, JOptionPane.ERROR_MESSAGE);
                JDialog dlg = pane.createDialog("Error (on EDT)");
                
                dlg.setModal(false); // モーダル
                dlg.setResizable(true); // リサイズ可能
                
                dlg.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
                dlg.setVisible(true);
            }
        });
    }
    
    
}
