/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.service;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import textkeymatcher.entity.LineData;
import textkeymatcher.entity.LineDataList;
import textkeymatcher.service.LineDataLoader.LineDataLoaderCallback;

/**
 *
 * @author seraphy
 */
public class LineDataCollector extends AbstractList<LineData> implements LineDataLoaderCallback, LineDataList {
    
    private List<LineData> lineDatas = new ArrayList<LineData>();
    
    private String title;
    
    public LineDataCollector() {
        this(null);
    }

    public LineDataCollector(String title) {
        this.title = title;
    }
    
    @Override
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public void setBackingStore(List<LineData> lineDatas) {
        if (lineDatas == null) {
            throw new IllegalArgumentException();
        }
        this.lineDatas = lineDatas;
    }
    
    public List<LineData> getBackingStore() {
        return lineDatas;
    }
    
    
    @Override
    public void fetch(LineData lineData) {
        lineDatas.add(lineData);
    }
    
    @Override
    public void clear() {
        lineDatas.clear();
    }

    @Override
    public LineData get(int i) {
        return lineDatas.get(i);
    }

    @Override
    public int size() {
        return lineDatas.size();
    }

    @Override
    public LineData set(int i, LineData e) {
        return lineDatas.set(i, e);
    }

    @Override
    public LineData remove(int i) {
        return lineDatas.remove(i);
    }

    @Override
    public void add(int i, LineData e) {
        lineDatas.add(i, e);
    }
}
